/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.GreatCircle;
import cn.org.gddsn.seis.location.rstt.Grid;
import cn.org.gddsn.seis.location.rstt.LayerProfile;
import cn.org.gddsn.seis.location.rstt.Location;
import cn.org.gddsn.seis.location.rstt.SLBMException;
import cn.org.gddsn.seis.location.rstt.TauPSite;
import cn.org.gddsn.seis.location.rstt.TravelTimeResult;
import java.util.Vector;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class GreatCircle_Xg
extends GreatCircle {
    private double pSource;
    private double tHeadwave;
    private double pHeadwave;
    private double pTaup;
    private double trHeadwave;
    private TravelTimeResult taupResult;
    private double taupModelRadius;

    public GreatCircle_Xg(int _phase, Grid _grid, double latSource, double lonSource, double depthSource, double latReceiver, double lonReceiver, double depthReceiver) {
        super(_phase, _grid, latSource, lonSource, depthSource, latReceiver, lonReceiver, depthReceiver);
        this.taupModelRadius = 6471.0;
        this.taupResult = null;
        if (this.getDistance() > MAX_DISTANCE) {
            String err = String.format("\nERROR in GreatCircle_Xg()\nSource-receiver separation exceeds maximum value.\nSource-receiver separation (degrees) : %.2f\nMaximum allowed separation (degrees) : %.2f\nSource   location : %s\nReceiver location : %s\n", this.getDistance() * 57.29577951308232, MAX_DISTANCE * 57.29577951308232, this.source.getLocation().toString(), this.receiver.getLocation().toString());
            this.setNAValues();
            throw new SLBMException(err, 201);
        }
        if (!this.source.isInCrust() || !this.receiver.isInCrust()) {
            String err = String.format("\nERROR in GreatCircle_Xg constructor\nPg/Lg not valid because source or receiver is below the Moho.\nSource-receiver separation (deg) = %.2f\nReceiver lat, lon, depth, radius, moho depth : %s  %.2f  %.2f\nSource   lat, lon, depth, radius, moho depth : %s  %.2f  %.2f\n", this.source.getLocation().distance(this.receiver.getLocation()) * 57.29577951308232, this.receiver.getLocation().toString(), this.receiver.getLocation().getRadius(), this.receiver.getDepth(8), this.source.getLocation().toString(), this.source.getLocation().getRadius(), this.source.getDepth(8));
            this.setNAValues();
            throw new SLBMException(err, 200);
        }
        if (this.receiver.getTauPSite() == null) {
            String phtype = "P";
            if (this.phase == 1) {
                phtype = "S";
            } else if (this.phase == 3) {
                phtype = "L";
            }
            TauPSite tps = new TauPSite("", phtype);
            tps.setEarthRadius(this.taupModelRadius);
            tps.setSiteDepth(this.taupModelRadius - this.receiver.getLocation().getRadius());
            int nlay = this.receiver.getNLayid();
            int[] layid = this.receiver.getLayid();
            double v = 0.0;
            double rbot = 0.0;
            int i = 0;
            while (i < nlay - 1) {
                rbot = this.receiver.getInterfaceRadius(layid[i + 1]);
                if (!(rbot >= this.taupModelRadius)) {
                    double rtop = tps.getVelocityModels().size() == 0 ? this.taupModelRadius : this.receiver.getInterfaceRadius(layid[i]);
                    v = this.receiver.getVelocity(layid[i]);
                    tps.appendConstVelocityModel(v, rtop, rbot, "");
                }
                ++i;
            }
            tps.appendConstVelocityModel(v, rbot, 0.0, "");
            this.receiver.setTauPSite(tps);
        }
        this.computeTravelTime();
    }

    public GreatCircle_Xg(GreatCircle_Xg other) {
        super(other);
    }

    public GreatCircle_Xg copy(GreatCircle_Xg other) {
        super.copy(other);
        return this;
    }

    public void getZhaoParameters(doubleW Vm_, doubleW Gm_, doubleW H_, doubleW C_, doubleW Cm_, intW udSign_) {
        Vm_.val = -999999.0;
        Gm_.val = -999999.0;
        H_.val = -999999.0;
        C_.val = -999999.0;
        Cm_.val = -999999.0;
        udSign_.val = -999;
    }

    public void getPgLgComponents(doubleW tT, doubleW tP, doubleW tH, doubleW pT, doubleW pH, doubleW trT, doubleW trH) {
        tT.val = this.tTotal;
        tP.val = this.taupResult != null ? this.taupResult.ttrT : -999999.0;
        tH.val = this.tHeadwave;
        pT.val = this.taupResult != null ? this.taupResult.ttrP / this.taupResult.ttrR : -999999.0;
        pH.val = this.pHeadwave;
        trT.val = this.taupResult != null ? this.taupResult.ttrR : -999999.0;
        trH.val = this.trHeadwave;
    }

    public void computeTravelTime() {
        this.tTotal = 0.0;
        this.tHorizontal = 0.0;
        this.tReceiver = 0.0;
        this.tSource = 0.0;
        this.xHorizontal = 0.0;
        this.xReceiver = 0.0;
        this.xSource = 0.0;
        this.pSource = -999999.0;
        this.trHeadwave = -999999.0;
        this.pHeadwave = -999999.0;
        this.tHeadwave = -999999.0;
        this.solutionMethod = "neither";
        this.computeTravelTimeTaup();
        this.pTaup = this.taupResult != null && this.taupResult.ttrRayType.equals("DownGoing") ? this.taupResult.ttrP / this.taupResult.ttrR : -1.0;
        this.computeTravelTimeHeadwave();
        if (this.taupResult != null && this.tHeadwave != -999999.0) {
            this.solutionMethod = this.source.getLocation().getRadius() >= this.source.getInterfaceRadius(6) ? (this.profiles.size() == 0 || this.taupResult.ttrR > this.getProfile(this.profiles.size() - 1).getRadius() || this.taupResult.ttrRayType.equals("UpGoing") ? "computeTravelTimeTaup()" : "computeTravelTimeHeadwave()") : (this.taupResult.ttrRayType.equals("UpGoing") && this.taupResult.ttrT > this.tHeadwave ? "computeTravelTimeTaup()" : "computeTravelTimeHeadwave()");
        } else if (this.taupResult != null) {
            this.solutionMethod = "computeTravelTimeTaup()";
        } else if (this.tHeadwave != -999999.0) {
            this.solutionMethod = "computeTravelTimeHeadwave()";
        }
        if (this.solutionMethod.equals("computeTravelTimeTaup()")) {
            this.tTotal = this.taupResult.ttrT;
            this.rayParameter = this.taupResult.ttrP;
            this.turningRadius = this.taupResult.ttrR;
        } else if (this.solutionMethod.equals("computeTravelTimeHeadwave()")) {
            this.tTotal = this.tHeadwave;
            this.rayParameter = this.pHeadwave;
            this.turningRadius = this.trHeadwave;
        } else {
            String err = String.format("\nERROR in computeTravelTime\ncomputeTravelTimeTaup() and computeTravelTimeHeadwave() both returned NA_VALUE.\nSource-receiver separation (deg) = %.2f\nReceiver lat, lon, depth, radius, moho depth : %s  %.2f  %.2f\nSource   lat, lon, depth, radius, moho depth :  %s  %.2f  %.2f\n", this.source.getLocation().distance(this.receiver.getLocation()) * 57.29577951308232, this.receiver.getLocation().toString(), this.receiver.getLocation().getRadius(), this.receiver.getDepth(8), this.source.getLocation().toString(), this.source.getLocation().getRadius(), this.source.getDepth(8));
            this.setNAValues();
            throw new SLBMException(err, 400);
        }
    }

    public void computeTravelTimeTaup() {
        TauPSite tps = this.receiver.getTauPSite();
        tps.calculateTravelTimes(this.getDistance(), this.taupModelRadius - this.source.getLocation().getRadius(), false);
        this.taupResult = tps.getFirstTravelTimeResult();
    }

    public void computeTravelTimeHeadwave() {
        double h;
        int j;
        this.sourceIndex = 0;
        this.receiverIndex = Math.max(0, this.profiles.size() - 1);
        int i = 0;
        while (i < this.profiles.size()) {
            double dkm = this.actual_path_increment * this.getProfile(i).getRadius();
            this.xHorizontal += dkm;
            this.tHorizontal += dkm / ((LayerProfile)this.profiles.get(i)).getVelocity();
            ++i;
        }
        if (this.pHeadwave == -999999.0) {
            this.pHeadwave = this.xHorizontal > 0.0 ? this.tHorizontal / this.xHorizontal : 0.0;
        }
        int[] rlayid = this.receiver.getLayid();
        int k = this.receiver.getTopLayid();
        while (rlayid[k] < 6) {
            j = rlayid[k];
            h = k == this.receiver.getTopLayid() ? this.receiver.getLocation().getRadius() - this.receiver.getInterfaceRadius(j + 1) : this.receiver.getInterfaceRadius(j) - this.receiver.getInterfaceRadius(j + 1);
            this.tReceiver += h / this.receiver.getVelocity(j) * Math.sqrt(Math.max(0.0, 1.0 - this.sqr(this.pHeadwave * this.receiver.getVelocity(j))));
            ++k;
        }
        if (this.source.getLocation().getRadius() >= this.source.getInterfaceRadius(6)) {
            this.pSource = this.pHeadwave;
            this.trHeadwave = this.source.getInterfaceRadius(6);
            k = this.source.getTopLayid();
            int[] slayid = this.source.getLayid();
            while (slayid[k] < 6) {
                j = slayid[k];
                h = k == this.source.getTopLayid() ? this.source.getLocation().getRadius() - this.source.getInterfaceRadius(j + 1) : this.source.getInterfaceRadius(j) - this.source.getInterfaceRadius(j + 1);
                this.tSource += h / this.source.getVelocity(j) * Math.sqrt(Math.max(0.0, 1.0 - this.sqr(this.pHeadwave * this.source.getVelocity(j))));
                ++k;
            }
        } else {
            this.trHeadwave = this.source.getLocation().getRadius();
            h = this.source.getInterfaceRadius(6) - this.source.getLocation().getRadius();
            this.pSource = 0.997 / this.source.getVelocity(6);
            this.pTaup = this.source.getLocation().getRadius() / this.source.getInterfaceRadius(6);
            this.tSource += h / this.source.getVelocity(6) * Math.sqrt(1.0 - this.pTaup * this.pTaup);
        }
        this.tHeadwave = this.tSource + this.tReceiver + this.tHorizontal;
    }

    public String toString(int verbosity) {
        if (verbosity < 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append(String.format("   SLBM Version %s\n\n", "2.8.4"));
        if (Location.EARTH_RADIUS > 0.0) {
            sb.append(String.format("   Earth radius = constant % km.\n\n", Location.EARTH_RADIUS));
        } else {
            sb.append(String.format("   Earth radius varies as a function of latitude. \n\n", new Object[0]));
        }
        sb.append(String.format("   Phase = %s\n\n", this.getPhaseString()));
        sb.append(String.format("   Source-Receiver separation = %.4f degrees\n\n", this.getDistance() * 57.29577951308232));
        sb.append(String.format("   Headwave travel time       = %.4f\n\n", this.tHeadwave));
        sb.append(String.format("   Taup travel time           = %.4f\n\n", this.taupResult != null ? this.taupResult.ttrT : -999999.0));
        sb.append(String.format("   Solution method = %s\n\n", this.solutionMethod));
        if (this.solutionMethod.indexOf("Taup") != -1) {
            this.toStringTaup(sb, verbosity);
        } else if (this.solutionMethod.indexOf("Headwave") != -1) {
            this.toStringHeadwave(sb, verbosity);
        }
        return sb.toString();
    }

    public void toStringTaup(StringBuffer os, int verbosity) {
        os.append(String.format("   Travel time                = %.4f\n\n", this.tTotal));
        TravelTimeResult ttr = this.receiver.getTauPSite().getFirstTravelTimeResult();
        os.append(String.format("   Ray parameter              = %.4f\n\n", ttr.ttrP));
        os.append(String.format("   Turning Depth              = %.4f\n\n", this.receiver.getLocation().getEarthRadius() - ttr.ttrR));
        if (verbosity >= 3) {
            os.append(String.format("   Source Profile:\n\n%s\n\n", this.source.toString()));
            os.append(String.format("   Receiver Profile:\n\n%s\n", this.receiver.toString()));
        }
        os.append(String.format("%s\n\n%s", this.receiver.getTauPSite().toString(), this.taupResult.toString()));
    }

    public void toStringHeadwave(StringBuffer os, int verbosity) {
        int n = this.getHeadWaveInterface();
        os.append(String.format("               %10s%10s%10s%10s\n", "X, deg", "X, km", "T, sec", "    P, sec/km"));
        os.append(String.format("   Source    = %10.4f%10.4f%10.4f%10.4f\n", this.xSource * 57.29577951308232, this.xSource * this.source.getInterfaceRadius(n), this.tSource, this.pSource));
        os.append(String.format("   Receiver  = %10.4f%10.4f%10.4f%10.4f\n", this.xReceiver * 57.29577951308232, this.xReceiver * this.receiver.getInterfaceRadius(n), this.tReceiver, this.rayParameter));
        os.append(String.format("   Head wave = %10.4f%10.4f%10.4f\n", (this.getDistance() - this.xSource - this.xReceiver) * 57.29577951308232, this.xHorizontal, this.tHorizontal));
        os.append(String.format("   Total     = %10.4f%10.4f%10.4f\n\n", this.source.getLocation().distanceDegrees(this.receiver.getLocation()), this.xSource * this.source.getInterfaceRadius(n) + this.xReceiver * this.receiver.getInterfaceRadius(n) + this.xHorizontal, this.tSource + this.tReceiver + this.tHorizontal));
        os.append(String.format("   Fraction Active          = %10.4f\n\n", this.getFractionActive()));
        if (verbosity >= 3) {
            os.append(String.format("   Source Profile:\n\n%s\n", this.source.toString()));
            os.append(String.format("\n   Receiver Profile:\n\n%s\n", this.receiver.toString()));
            if (verbosity >= 4) {
                os.append(String.format("\n   Grid Node Weights:\n\n", new Object[0]));
                os.append(String.format("%13s%12%%15s\n", "grid_id", "active_id", "weight"));
                Vector<Integer> nodeids = new Vector<Integer>();
                Vector<Double> weights = new Vector<Double>();
                this.getWeights(nodeids, weights);
                double sum = 0.0;
                int i = 0;
                while (i < nodeids.size()) {
                    os.append(String.format("       %6d %11d %14.8f\n", nodeids.get(i), this.grid.getActiveNodeId(nodeids.get(i)), weights.get(i)));
                    sum += weights.get(i).doubleValue();
                    ++i;
                }
                os.append(String.format("\n      Sum of weights = %.8f km\n", sum));
                if (verbosity >= 5) {
                    os.append(String.format("\n   Head wave Profiles:\n\n", new Object[0]));
                    os.append(String.format("%6s%8s%9s%8s%9s%8s", "#", "Lat", "Lon", "Head", "R Earth", "Vel"));
                    os.append(String.format("%9s%9s\n", "dx", "Active"));
                    i = 0;
                    while (i < this.profiles.size()) {
                        this.getProfile(i);
                        this.source.getLocation().move(this.vtp, ((double)i + 0.5) * this.actual_path_increment, this.location);
                        os.append(String.format("%6d%8.3f%9.3f%8.3f%9.2f%8.4f%9.4f", i, this.location.getLatDegrees(), this.location.getLonDegrees(), this.location.getEarthRadius() - ((LayerProfile)this.profiles.get(i)).getRadius(), this.location.getEarthRadius(), ((LayerProfile)this.profiles.get(i)).getVelocity(), this.getActualPathIncrement(i) * 57.29577951308232));
                        if (this.getActualPathIncrement(i) < 1.0E-9) {
                            os.append("      -");
                        } else if (((LayerProfile)this.profiles.get(i)).isActiveProfile()) {
                            os.append("     y");
                        } else {
                            os.append("    n");
                        }
                        os.append("\n");
                        ++i;
                    }
                    os.append("\n");
                    if (verbosity >= 6) {
                        os.append(String.format("\n   Head wave Profile Interpolation Coefficients:\n\n", new Object[0]));
                        os.append(String.format("%6s", "#"));
                        i = 0;
                        while (i < 3) {
                            os.append(String.format("%7s%10s", "id", "coeff"));
                            ++i;
                        }
                        os.append("\n");
                        i = 0;
                        while (i < this.profiles.size()) {
                            os.append(String.format("%6d", i));
                            int j = 0;
                            while (j < 3) {
                                os.append(String.format(" %6d %9.4f", ((LayerProfile)this.profiles.get(i)).getNeighbors()[j].getNodeId(), ((LayerProfile)this.profiles.get(i)).getCoefficients()[j]));
                                ++j;
                            }
                            os.append("\n");
                            ++i;
                        }
                        os.append("\n");
                    }
                }
            }
        }
    }
}

