/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.CrustalProfile;
import cn.org.gddsn.seis.location.rstt.GreatCircle_Xg;
import cn.org.gddsn.seis.location.rstt.GreatCircle_Xn;
import cn.org.gddsn.seis.location.rstt.Grid;
import cn.org.gddsn.seis.location.rstt.GridProfile;
import cn.org.gddsn.seis.location.rstt.LayerProfile;
import cn.org.gddsn.seis.location.rstt.Location;
import cn.org.gddsn.seis.location.rstt.SLBMException;
import java.util.Vector;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GreatCircle {
    protected static int greatCircleClassCount = 0;
    protected Grid grid;
    protected int phase;
    protected int headWaveInterface;
    protected CrustalProfile source;
    protected CrustalProfile receiver;
    protected Location location = new Location();
    protected double[] vtp = new double[3];
    protected Vector<LayerProfile> profiles = new Vector();
    protected String solutionMethod;
    protected double tTotal;
    protected double actual_path_increment;
    protected double distance;
    protected double esaz;
    protected double rayParameter;
    protected double xSource;
    protected double tSource;
    protected double xReceiver;
    protected double tReceiver;
    protected double xHorizontal;
    protected double tHorizontal;
    protected double tGamma;
    protected double sourceRayParameter;
    protected double receiverRayParameter;
    protected double turningRadius;
    protected int sourceIndex;
    protected int receiverIndex;
    protected double ttHminus;
    protected double ttHplus;
    protected double ttHZplus;
    protected double ttEast;
    protected double ttWest;
    protected double ttEastZ;
    protected double ttNorth;
    protected double ttSouth;
    protected double ttNorthZ;
    protected static double DEL_DISTANCE = 0.001;
    protected static double DEL_DEPTH = 0.1;
    protected static double PATH_INCREMENT = 0.0017453292519943296;
    public static double MAX_DISTANCE = 0.2617993877991494;
    public static double MAX_DEPTH = 200.0;

    public GreatCircle(GreatCircle other) {
        this.grid = other.grid;
        this.source = other.source;
        this.receiver = other.receiver;
        this.phase = other.phase;
        this.profiles = other.profiles;
        this.actual_path_increment = other.actual_path_increment;
        this.distance = other.distance;
        this.esaz = other.esaz;
        this.ttHminus = other.ttHminus;
        this.ttHplus = other.ttHplus;
        this.ttHZplus = other.ttHZplus;
        this.ttNorth = other.ttNorth;
        this.ttSouth = other.ttSouth;
        this.ttNorthZ = other.ttNorthZ;
        this.ttEast = other.ttEast;
        this.ttWest = other.ttWest;
        this.ttEastZ = other.ttEastZ;
        ++greatCircleClassCount;
    }

    public GreatCircle(int _phase, Grid _grid, double latSource, double lonSource, double depthSource, double latReceiver, double lonReceiver, double depthReceiver) {
        int n;
        this.phase = _phase;
        this.grid = _grid;
        this.tTotal = -999999.0;
        this.tSource = -999999.0;
        this.tReceiver = -999999.0;
        this.tGamma = 0.0;
        this.headWaveInterface = _phase / 2 == 0 ? 8 : 6;
        this.esaz = -999999.0;
        this.ttHminus = -999999.0;
        this.ttHplus = -999999.0;
        this.ttHZplus = -999999.0;
        this.ttNorth = -999999.0;
        this.ttSouth = -999999.0;
        this.ttNorthZ = -999999.0;
        this.ttEast = -999999.0;
        this.ttWest = -999999.0;
        this.ttEastZ = -999999.0;
        ++greatCircleClassCount;
        this.setNAValues();
        this.receiver = this.grid.getReceiverProfile(this.phase, latReceiver, lonReceiver, depthReceiver);
        this.source = this.grid.getSourceProfile(this.phase, latSource, lonSource, depthSource);
        this.distance = this.source.getLocation().distance(this.receiver.getLocation());
        if (this.source.getLocation().vectorTripleProduct(this.receiver.getLocation(), this.vtp)) {
            n = (int)Math.ceil(this.distance / PATH_INCREMENT);
            if (n <= 0) {
                n = 1;
            }
            this.actual_path_increment = this.distance / (double)n;
        } else {
            this.actual_path_increment = this.distance;
            n = 1;
        }
        this.profiles.setSize(n);
    }

    protected abstract void computeTravelTime();

    public GreatCircle copy(GreatCircle other) {
        this.grid = other.grid;
        this.source = other.source;
        this.receiver = other.receiver;
        this.phase = other.phase;
        this.profiles = other.profiles;
        this.actual_path_increment = other.actual_path_increment;
        this.distance = other.distance;
        this.esaz = other.esaz;
        this.ttHminus = other.ttHminus;
        this.ttHplus = other.ttHplus;
        this.ttHZplus = other.ttHZplus;
        this.ttNorth = other.ttNorth;
        this.ttSouth = other.ttSouth;
        this.ttNorthZ = other.ttNorthZ;
        this.ttEast = other.ttEast;
        this.ttWest = other.ttWest;
        this.ttEastZ = other.ttEastZ;
        return this;
    }

    protected void finalize() {
        --greatCircleClassCount;
        int i = 0;
        while (i < this.profiles.size()) {
            this.profiles.add(i, null);
            ++i;
        }
        this.profiles.clear();
    }

    public void get_dtt_ddepth(doubleW dtt_ddepth) {
        dtt_ddepth.val = this.getTravelTime() > -1.0 ? (this.getSourceProfile().isInCrust() && this.getSourceProfile().getLocation().getDepth() + DEL_DEPTH >= this.getSourceProfile().getDepth(8) ? (this.getTravelTime() - this.get_ttZminus()) / DEL_DEPTH : (this.get_ttZplus() - this.getTravelTime()) / DEL_DEPTH) : -999999.0;
    }

    public double get_dtt_ddist() {
        double dtt_ddist = -999999.0;
        dtt_ddist = this.getTravelTime() > -1.0 ? (this.get_ttHplus() - this.getTravelTime()) / DEL_DISTANCE : -999999.0;
        return dtt_ddist;
    }

    public void get_dtt_dlat(doubleW dtt_dlat) {
        dtt_dlat.val = this.getTravelTime() > -1.0 ? (this.get_ttNorth() - this.getTravelTime()) / DEL_DISTANCE : -999999.0;
    }

    protected void get_dtt_dlon(doubleW dtt_dlon) {
        dtt_dlon.val = this.getTravelTime() > -1.0 ? (this.get_ttEast() - this.getTravelTime()) / DEL_DISTANCE : -999999.0;
    }

    protected double get_ttEast() {
        if (this.ttEast == -999999.0) {
            Location position = new Location();
            this.getSourceProfile().getLocation().move(1.5707963267948966, DEL_DISTANCE, position);
            GreatCircle gc = GreatCircle.create(this.getPhase(), this.grid, position.getLat(), position.getLon(), this.getSourceProfile().getLocation().getDepth(), this.getReceiverProfile().getLocation().getLat(), this.getReceiverProfile().getLocation().getLon(), this.getReceiverProfile().getLocation().getDepth(), 1.0E30);
            this.ttEast = gc.getTravelTime();
            Object var2_2 = null;
        }
        return this.ttEast;
    }

    protected double get_ttEastZ() {
        if (this.ttEastZ == -999999.0) {
            Location position = new Location();
            this.getSourceProfile().getLocation().move(1.5707963267948966, DEL_DISTANCE, position);
            GreatCircle gc = GreatCircle.create(this.getPhase(), this.grid, position.getLat(), position.getLon(), this.getSourceProfile().getLocation().getDepth() + DEL_DEPTH, this.getReceiverProfile().getLocation().getLat(), this.getReceiverProfile().getLocation().getLon(), this.getReceiverProfile().getLocation().getDepth(), 1.0E30);
            this.ttEastZ = gc.getTravelTime();
            Object var2_2 = null;
        }
        return this.ttEastZ;
    }

    protected double get_ttHminus() {
        if (this.ttHminus == -999999.0) {
            Location position = new Location();
            this.getGreatCircleLocation(DEL_DISTANCE, position);
            GreatCircle gc = GreatCircle.create(this.getPhase(), this.grid, position.getLat(), position.getLon(), this.getSourceProfile().getLocation().getDepth(), this.getReceiverProfile().getLocation().getLat(), this.getReceiverProfile().getLocation().getLon(), this.getReceiverProfile().getLocation().getDepth(), 1.0E30);
            this.ttHminus = gc.getTravelTime();
            Object var2_2 = null;
        }
        return this.ttHminus;
    }

    protected double get_ttHplus() {
        if (this.ttHplus == -999999.0) {
            Location position = new Location();
            this.getGreatCircleLocation(-DEL_DISTANCE, position);
            GreatCircle gc = GreatCircle.create(this.getPhase(), this.grid, position.getLat(), position.getLon(), this.getSourceProfile().getLocation().getDepth(), this.getReceiverProfile().getLocation().getLat(), this.getReceiverProfile().getLocation().getLon(), this.getReceiverProfile().getLocation().getDepth(), 1.0E30);
            this.ttHplus = gc.getTravelTime();
            Object var2_2 = null;
        }
        return this.ttHplus;
    }

    protected double get_ttHZplus() {
        if (this.ttHZplus == -999999.0) {
            Location position = new Location();
            this.getSourceProfile().getLocation().move(this.getEsaz() + Math.PI, DEL_DISTANCE, position);
            GreatCircle gc = GreatCircle.create(this.getPhase(), this.grid, position.getLat(), position.getLon(), this.getSourceProfile().getLocation().getDepth() + DEL_DEPTH, this.getReceiverProfile().getLocation().getLat(), this.getReceiverProfile().getLocation().getLon(), this.getReceiverProfile().getLocation().getDepth(), 1.0E30);
            this.ttHZplus = gc.getTravelTime();
            Object var2_2 = null;
        }
        return this.ttHZplus;
    }

    protected double get_ttNorth() {
        if (this.ttNorth == -999999.0) {
            Location position = new Location();
            this.getSourceProfile().getLocation().move_north(DEL_DISTANCE, position);
            GreatCircle gc = GreatCircle.create(this.getPhase(), this.grid, position.getLat(), position.getLon(), this.getSourceProfile().getLocation().getDepth(), this.getReceiverProfile().getLocation().getLat(), this.getReceiverProfile().getLocation().getLon(), this.getReceiverProfile().getLocation().getDepth(), 1.0E30);
            this.ttNorth = gc.getTravelTime();
            Object var2_2 = null;
        }
        return this.ttNorth;
    }

    protected double get_ttNorthZ() {
        if (this.ttNorthZ == -999999.0) {
            Location position = new Location();
            this.getSourceProfile().getLocation().move_north(DEL_DISTANCE, position);
            GreatCircle gc = GreatCircle.create(this.getPhase(), this.grid, position.getLat(), position.getLon(), this.getSourceProfile().getLocation().getDepth() + DEL_DEPTH, this.getReceiverProfile().getLocation().getLat(), this.getReceiverProfile().getLocation().getLon(), this.getReceiverProfile().getLocation().getDepth(), 1.0E30);
            this.ttNorthZ = gc.getTravelTime();
            Object var2_2 = null;
        }
        return this.ttNorthZ;
    }

    protected double get_ttSouth() {
        if (this.ttSouth == -999999.0) {
            Location position = new Location();
            this.getSourceProfile().getLocation().move_north(-DEL_DISTANCE, position);
            GreatCircle gc = GreatCircle.create(this.getPhase(), this.grid, position.getLat(), position.getLon(), this.getSourceProfile().getLocation().getDepth(), this.getReceiverProfile().getLocation().getLat(), this.getReceiverProfile().getLocation().getLon(), this.getReceiverProfile().getLocation().getDepth(), 1.0E30);
            this.ttSouth = gc.getTravelTime();
            Object var2_2 = null;
        }
        return this.ttSouth;
    }

    protected double get_ttWest() {
        if (this.ttWest == -999999.0) {
            Location position = new Location();
            this.getSourceProfile().getLocation().move(-1.5707963267948966, DEL_DISTANCE, position);
            GreatCircle gc = GreatCircle.create(this.getPhase(), this.grid, position.getLat(), position.getLon(), this.getSourceProfile().getLocation().getDepth(), this.getReceiverProfile().getLocation().getLat(), this.getReceiverProfile().getLocation().getLon(), this.getReceiverProfile().getLocation().getDepth(), 1.0E30);
            this.ttWest = gc.getTravelTime();
            Object var2_2 = null;
        }
        return this.ttWest;
    }

    protected double get_ttZminus() {
        GreatCircle gc = GreatCircle.create(this.getPhase(), this.grid, this.getSourceProfile().getLocation().getLat(), this.getSourceProfile().getLocation().getLon(), this.getSourceProfile().getLocation().getDepth() - DEL_DEPTH, this.getReceiverProfile().getLocation().getLat(), this.getReceiverProfile().getLocation().getLon(), this.getReceiverProfile().getLocation().getDepth(), 1.0E30);
        double ttZminus = gc.getTravelTime();
        gc = null;
        return ttZminus;
    }

    protected double get_ttZplus() {
        GreatCircle gc = GreatCircle.create(this.getPhase(), this.grid, this.getSourceProfile().getLocation().getLat(), this.getSourceProfile().getLocation().getLon(), this.getSourceProfile().getLocation().getDepth() + DEL_DEPTH, this.getReceiverProfile().getLocation().getLat(), this.getReceiverProfile().getLocation().getLon(), this.getReceiverProfile().getLocation().getDepth(), 1.0E30);
        double ttZplus = gc.getTravelTime();
        gc = null;
        return ttZplus;
    }

    public double getActualPathIncrement() {
        return this.actual_path_increment;
    }

    protected double getActualPathIncrement(int i) {
        if (i > this.sourceIndex && i < this.receiverIndex) {
            return this.actual_path_increment;
        }
        if (i == this.sourceIndex && i == this.receiverIndex) {
            return this.distance - this.xSource - this.xReceiver;
        }
        if (i == this.sourceIndex) {
            return (double)(this.sourceIndex + 1) * this.actual_path_increment - this.xSource;
        }
        if (i == this.receiverIndex) {
            return this.distance - this.xReceiver - (double)this.receiverIndex * this.actual_path_increment;
        }
        return 0.0;
    }

    public static int getClassCount() {
        return greatCircleClassCount;
    }

    public void getData(intW p, doubleW d, double[] sourceDepth, double[] sourceVelocity, double[] receiverDepth, double[] receiverVelocity, double[] headWaveVelocity, double[] gradient, int[][] neighbors, double[][] coefficients) {
        p.val = this.phase;
        d.val = this.actual_path_increment;
        int i = 0;
        while (i < 9) {
            sourceDepth[i] = this.source.getDepth(i);
            sourceVelocity[i] = this.source.getVelocity(i);
            receiverDepth[i] = this.receiver.getDepth(i);
            receiverVelocity[i] = this.receiver.getVelocity(i);
            ++i;
        }
        i = 0;
        while (i < this.profiles.size()) {
            this.getProfile(i);
            headWaveVelocity[i] = this.profiles.get(i).getVelocity();
            gradient[i] = this.phase == 0 || this.phase == 1 ? this.profiles.get(i).getGradient() : -999999.0;
            int j = 0;
            while (j < 3) {
                neighbors[i][j] = this.profiles.get(i).getNeighbors()[j].getNodeId();
                coefficients[i][j] = this.profiles.get(i).getCoefficients()[j];
                ++j;
            }
            ++i;
        }
    }

    public void getData(intW p, doubleW d, Vector<Double> sourceDepth, Vector<Double> sourceVelocity, Vector<Double> receiverDepth, Vector<Double> receiverVelocity, Vector<Double> headWaveVelocity, Vector<Double> gradient, Vector<Vector<Integer>> neighbors, Vector<Vector<Double>> coefficients) {
        p.val = this.phase;
        d.val = this.actual_path_increment;
        sourceDepth.clear();
        sourceVelocity.clear();
        receiverDepth.clear();
        receiverVelocity.clear();
        int i = 0;
        while (i < 9) {
            sourceDepth.add(this.source.getDepth(i));
            sourceVelocity.add(this.source.getVelocity(i));
            receiverDepth.add(this.receiver.getDepth(i));
            receiverVelocity.add(this.receiver.getVelocity(i));
            ++i;
        }
        headWaveVelocity.clear();
        gradient.clear();
        neighbors.setSize(this.profiles.size());
        coefficients.setSize(this.profiles.size());
        i = 0;
        while (i < this.profiles.size()) {
            this.getProfile(i);
            headWaveVelocity.add(this.profiles.get(i).getVelocity());
            if (this.phase == 0 || this.phase == 1) {
                gradient.add(this.profiles.get(i).getGradient());
            } else {
                gradient.add(-999999.0);
            }
            int j = 0;
            while (j < 3) {
                neighbors.get(i).add(this.profiles.get(i).getNeighbors()[j].getNodeId());
                coefficients.get(i).add(this.profiles.get(i).getCoefficients()[j]);
                ++j;
            }
            ++i;
        }
    }

    public static void getDelDepth(doubleW del_depth) {
        del_depth.val = DEL_DEPTH;
    }

    public static void getDelDistance(doubleW del_distance) {
        del_distance.val = DEL_DISTANCE;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getEsaz() {
        if (this.esaz == -999999.0) {
            this.esaz = this.source.getLocation().azimuth(this.receiver.getLocation());
        }
        return this.esaz;
    }

    public double getFractionActive() {
        int nactive = 0;
        int i = 0;
        while (i < this.profiles.size()) {
            if (this.getProfile(i).isActiveProfile()) {
                ++nactive;
            }
            ++i;
        }
        return (double)nactive / (double)this.profiles.size();
    }

    public void getGreatCircleLocation(double dist, Location loc) {
        this.source.getLocation().move(this.vtp, dist, loc);
        loc.setRadius(-999999.0);
    }

    public Grid getGrid() {
        return this.grid;
    }

    public double getHeadwaveDistance() {
        return this.distance - this.xSource - this.xReceiver;
    }

    public double getHeadwaveDistanceKm() {
        return this.xHorizontal;
    }

    public final int getHeadWaveInterface() {
        return this.headWaveInterface;
    }

    public void getLayerProfileLocation(int i, Location loc) {
        this.source.getLocation().move(this.vtp, ((double)i + 0.5) * this.actual_path_increment, loc);
        loc.setRadius(this.getProfile(i).getRadius());
    }

    public int getNProfiles() {
        return this.profiles.size();
    }

    public static void getPathIncrement(doubleW path_increment) {
        path_increment.val = PATH_INCREMENT;
    }

    public void getPgLgComponents(doubleW tT, doubleW tTaup, doubleW tHeadwave, doubleW pTaup, doubleW pHeadwave, doubleW trTaup, doubleW trHeadwave) {
        trHeadwave.val = -999999.0;
        trTaup.val = -999999.0;
        pHeadwave.val = -999999.0;
        pTaup.val = -999999.0;
        tHeadwave.val = -999999.0;
        tTaup.val = -999999.0;
        tT.val = -999999.0;
    }

    public int getPhase() {
        return this.phase;
    }

    public String getPhaseString() {
        return this.phase == 0 ? "Pn" : (this.phase == 1 ? "Sn" : (this.phase == 2 ? "Pg" : (this.phase == 3 ? "Lg" : "unknown phase")));
    }

    public LayerProfile getProfile(int i) {
        if (this.profiles.get(i) == null) {
            this.source.getLocation().move(this.vtp, ((double)i + 0.5) * this.actual_path_increment, this.location);
            this.profiles.set(i, this.grid.getLayerProfile(this, this.location));
            if (this.profiles.get(i) == null) {
                String err = String.format("\nERROR in getProfile\nUnable to interpolate a LayerProfile along head wave interface.\nlat, lon (deg) = %.4f, %.4f is outside of model range.\n", this.location.getLatDegrees(), this.location.getLonDegrees());
                throw new SLBMException(err, 600);
            }
        }
        return this.profiles.get(i);
    }

    public double getRayParameter() {
        return this.rayParameter;
    }

    public double getReceiverDistance() {
        return this.xReceiver;
    }

    public CrustalProfile getReceiverProfile() {
        return this.receiver;
    }

    public double getReceiverRayParameter() {
        return this.receiverRayParameter;
    }

    public double getSourceDistance() {
        return this.xSource;
    }

    public CrustalProfile getSourceProfile() {
        return this.source;
    }

    public double getSourceRayParameter() {
        return this.sourceRayParameter;
    }

    public double getTravelTime() {
        return this.tTotal;
    }

    public void getTravelTime(doubleW tT, doubleW tS, doubleW tR, doubleW tM, doubleW tG) {
        tT.val = this.tTotal;
        tS.val = this.tSource;
        tR.val = this.tReceiver;
        tM.val = this.tHorizontal;
        tG.val = this.tGamma;
    }

    public double getTurningRadius() {
        return this.turningRadius;
    }

    public void getWeights(int[] nodeids, double[] weights, intW nweights) {
        GridProfile gp;
        nweights.val = 0;
        int i = 0;
        while (i < this.profiles.size()) {
            double d = this.getActualPathIncrement(i);
            if (d > 0.0) {
                double r = this.getProfile(i).getRadius();
                int j = 0;
                while (j < 3) {
                    gp = this.profiles.get(i).getNeighbors()[j];
                    if (gp.getWeight() == -999999.0) {
                        nodeids[nweights.val++] = gp.getNodeId();
                        gp.setWeight(0.0);
                    }
                    gp.addWeight(d * r * this.profiles.get(i).getCoefficients()[j]);
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < nweights.val) {
            gp = this.grid.getProfile(nodeids[i]);
            weights[i] = gp.getWeight();
            gp.setWeight(-999999.0);
            gp.incrementHitCount();
            ++i;
        }
    }

    public void getWeights(Vector<Integer> nodeids, Vector<Double> weights) {
        GridProfile gp;
        weights.clear();
        nodeids.clear();
        int i = 0;
        while (i < this.profiles.size()) {
            double d = this.getActualPathIncrement(i);
            if (d > 0.0) {
                double r = this.getProfile(i).getRadius();
                int j = 0;
                while (j < 3) {
                    gp = this.profiles.get(i).getNeighbors()[j];
                    if (gp.getWeight() == -999999.0) {
                        nodeids.add(gp.getNodeId());
                        gp.setWeight(0.0);
                    }
                    gp.addWeight(d * r * this.profiles.get(i).getCoefficients()[j]);
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < nodeids.size()) {
            gp = this.grid.getProfile(nodeids.get(i));
            weights.add(gp.getWeight());
            gp.setWeight(-999999.0);
            gp.incrementHitCount();
            ++i;
        }
    }

    public abstract void getZhaoParameters(doubleW var1, doubleW var2, doubleW var3, doubleW var4, doubleW var5, intW var6);

    public static void setDelDepth(double del_depth) {
        DEL_DEPTH = del_depth;
    }

    public static void setDelDistance(double del_distance) {
        DEL_DISTANCE = del_distance;
    }

    public void setNAValues() {
        this.rayParameter = -999999.0;
        this.receiverRayParameter = -999999.0;
        this.sourceRayParameter = -999999.0;
        this.tGamma = -999999.0;
        this.tHorizontal = -999999.0;
        this.tReceiver = -999999.0;
        this.tSource = -999999.0;
        this.ttEast = -999999.0;
        this.ttEastZ = -999999.0;
        this.ttHZplus = -999999.0;
        this.ttHminus = -999999.0;
        this.ttHplus = -999999.0;
        this.ttNorth = -999999.0;
        this.ttNorthZ = -999999.0;
        this.ttSouth = -999999.0;
        this.ttWest = -999999.0;
        this.turningRadius = -999999.0;
        this.xHorizontal = -999999.0;
        this.xReceiver = -999999.0;
        this.xSource = -999999.0;
    }

    public static void setPathIncrement(double path_increment) {
        PATH_INCREMENT = path_increment;
    }

    protected double sqr(double x) {
        return x * x;
    }

    public abstract String toString(int var1);

    public static GreatCircle create(int phase, Grid grid, double latSource, double lonSource, double depthSource, double latReceiver, double lonReceiver, double depthReceiver, double chMax) {
        if (phase < 0 || phase > 3) {
            String err = String.format("\nERROR in create\n%d is not a recognized phase.  Must be one of Pn, Sn, Pg, Lg.\nsource   lat, lon, depth = %12.4f, %12.4f, 12.4f\nreceiver lat, lon, depth = %12.4f, %12.4f, 12.4f\n", phase, latSource * 57.29577951308232, lonSource * 57.29577951308232, depthSource, latReceiver * 57.29577951308232, lonReceiver * 57.29577951308232, depthReceiver);
            throw new SLBMException(err, 100);
        }
        GreatCircle greatcircle = null;
        try {
            if (phase == 0 || phase == 1) {
                greatcircle = new GreatCircle_Xn(phase, grid, latSource, lonSource, depthSource, latReceiver, lonReceiver, depthReceiver, chMax);
            } else if (phase == 2 || phase == 3) {
                greatcircle = new GreatCircle_Xg(phase, grid, latSource, lonSource, depthSource, latReceiver, lonReceiver, depthReceiver);
            }
            return greatcircle;
        }
        catch (SLBMException ex) {
            if (greatcircle != null) {
                greatcircle = null;
            }
            throw new SLBMException(ex.getMessage(), ex.ecode);
        }
    }
}

