/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.security.Bytes;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBuffer {
    protected ByteBuffer dbData;
    protected int dbDataPos;
    protected int dbSize;
    protected boolean dbPad;

    public DataBuffer() {
        this.dbData = ByteBuffer.allocate(32);
        this.dbDataPos = 0;
        this.dbSize = 0;
        this.dbPad = true;
    }

    public DataBuffer(boolean doPad) {
        this.dbData = ByteBuffer.allocate(32);
        this.dbDataPos = 0;
        this.dbSize = 0;
        this.dbPad = doPad;
    }

    public DataBuffer(String str) {
        this.dbData = ByteBuffer.wrap(str.getBytes());
        this.dbDataPos = 0;
        this.dbSize = 0;
        this.dbPad = true;
    }

    public DataBuffer(DataBuffer db) {
        this.dbData = db.dbData;
        this.dbSize = db.dbSize;
        this.dbDataPos = db.dbDataPos;
        this.dbPad = db.dbPad;
    }

    public DataBuffer copy(DataBuffer db) {
        this.dbData = db.dbData;
        this.dbSize = db.dbSize;
        this.dbDataPos = db.dbDataPos;
        this.dbPad = db.dbPad;
        return this;
    }

    public void dumpBuffer() {
        int i = 0;
        while (i < this.dbData.capacity()) {
            System.out.printf("%02x", this.dbData.get(i) & 0xFF);
            ++i;
        }
        System.out.println();
    }

    public void writeToFile(OutputStream ofs) throws IOException {
        if (this.dbDataPos > this.dbSize) {
            this.dbSize = this.dbDataPos;
        }
        byte[] bb = this.dbData.array();
        ofs.write(bb, 0, this.dbSize);
    }

    public void writeToFile(FileOutputStream ofs) throws IOException {
        if (this.dbDataPos > this.dbSize) {
            this.dbSize = this.dbDataPos;
        }
        byte[] bb = this.dbData.array();
        ofs.write(bb, 0, this.dbSize);
    }

    public void readFromFile(RandomAccessFile ifs, long file_pos, int num_bytes) throws IOException {
        this.checkBufferSize(num_bytes);
        byte[] bb = new byte[num_bytes];
        ifs.seek(file_pos);
        ifs.read(bb);
        this.dbData.put(bb);
        this.dbDataPos += num_bytes;
    }

    public void readFromFile(RandomAccessFile ifs, int num_bytes) throws IOException {
        this.checkBufferSize(num_bytes);
        byte[] bb = new byte[num_bytes];
        ifs.read(bb);
        this.dbData.put(bb);
        this.dbDataPos += num_bytes;
    }

    public final byte[] readMD5HashKey() {
        int db = this.dbDataPos;
        this.dbDataPos = 0;
        int len = this.readInt32();
        byte[] s = new byte[len];
        this.dbData.get(s);
        this.dbDataPos = db;
        this.dbData.position(this.dbDataPos);
        return s;
    }

    public String generateMD5HashKey() {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        int sze = this.size();
        int savdb = this.dbDataPos;
        this.dbDataPos = 0;
        String hexstring = this.readString();
        byte[] bb = new byte[sze - this.dbDataPos];
        this.dbData.get(bb);
        md5.reset();
        hexstring = Bytes.toString((byte[])md5.digest(bb));
        this.dbDataPos = 0;
        this.dbData.position(this.dbDataPos);
        this.writeString(hexstring);
        this.dbDataPos = savdb;
        this.dbData.position(this.dbDataPos);
        return hexstring;
    }

    public String generateDataBufMD5HashKey() {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        int savdb = this.dbDataPos;
        int sze = this.size();
        this.dbDataPos = 0;
        byte[] bb = new byte[sze - this.dbDataPos];
        this.dbData.get(bb);
        md5.reset();
        String hexstring = Bytes.toString((byte[])md5.digest(bb));
        this.dbDataPos = savdb;
        this.dbData.position(this.dbDataPos);
        return hexstring;
    }

    public String class_name() {
        return "DataBuffer";
    }

    public String get_class_name() {
        return this.class_name();
    }

    public void align4Byte() {
        int sm = this.dbDataPos % 4;
        if (sm != 0 && this.dbPad) {
            this.dbDataPos += 4 - sm;
        }
        this.dbData.position(this.dbDataPos);
    }

    public void align8Byte() {
        int sm = this.dbDataPos % 8;
        if (sm != 0 && this.dbPad) {
            this.dbDataPos += 8 - sm;
        }
        this.dbData.position(this.dbDataPos);
    }

    public void clear() {
        this.dbData.position(0);
        this.dbDataPos = 0;
        this.dbSize = 0;
    }

    public final String readString() {
        int len = this.readInt32();
        byte[] s = new byte[len];
        this.dbData.get(s);
        this.dbDataPos += len;
        return new String(s);
    }

    public int readByte() {
        int b = this.dbData.get() & 0xFF;
        ++this.dbDataPos;
        return b;
    }

    public int readByte(int pos) {
        int b = this.dbData.get(pos) & 0xFF;
        return b;
    }

    public int readInt32() {
        this.align4Byte();
        return this.readRawInt32();
    }

    public int readRawInt32() {
        int i = this.dbData.getInt();
        this.dbDataPos += 4;
        return i;
    }

    public long readInt64() {
        this.align8Byte();
        return this.readRawInt64();
    }

    public long readRawInt64() {
        long i = this.dbData.getLong();
        this.dbDataPos += 8;
        return i;
    }

    public float readFloat() {
        this.align4Byte();
        return this.readRawFloat();
    }

    public float readRawFloat() {
        float f = this.dbData.getFloat();
        this.dbDataPos += 4;
        return f;
    }

    public double readDouble() {
        this.align8Byte();
        return this.readRawDouble();
    }

    public double readRawDouble() {
        double d = this.dbData.getDouble();
        this.dbDataPos += 8;
        return d;
    }

    public void readDoubleArray(Vector<Double> array, int num_doubles) {
        int num_bytes = num_doubles * 8;
        this.align8Byte();
        int i = 0;
        while (i < num_doubles) {
            array.set(i, this.dbData.getDouble());
            ++i;
        }
        this.dbDataPos += num_bytes;
    }

    public void writeString(byte[] bb) {
        int sz = bb.length + 4;
        this.align4Byte();
        this.checkBufferSize(sz);
        this.writeRawInt32(bb.length);
        this.dbData.put(bb);
        this.dbDataPos += bb.length;
    }

    public void writeString(String in_string) {
        byte[] bb = in_string.getBytes();
        this.writeString(bb);
    }

    public void writeByte(byte b) {
        this.checkBufferSize(1);
        this.writeRawByte(b);
    }

    public void writeRawByte(byte b) {
        this.dbData.put(b);
        ++this.dbDataPos;
    }

    public void writeInt32(int i) {
        this.align4Byte();
        this.checkBufferSize(4);
        this.writeRawInt32(i);
    }

    public void writeRawInt32(int i) {
        this.dbData.putInt(i);
        this.dbDataPos += 4;
    }

    public void writeInt64(long i) {
        this.align8Byte();
        this.checkBufferSize(8);
        this.writeRawInt64(i);
    }

    public void writeRawInt64(long i) {
        this.dbData.putLong(i);
        this.dbDataPos += 8;
    }

    public void writeFloat(float f) {
        this.align4Byte();
        this.checkBufferSize(4);
        this.writeRawFloat(f);
    }

    public void writeRawFloat(float f) {
        this.dbData.putFloat(f);
        this.dbDataPos += 4;
    }

    public void writeDouble(double d) {
        this.align8Byte();
        this.checkBufferSize(8);
        this.writeRawDouble(d);
    }

    public void writeRawDouble(double d) {
        this.dbData.putDouble(d);
        this.dbDataPos += 8;
    }

    public void writeDoubleArray(Vector<Double> array, int num_doubles) {
        int num_bytes = num_doubles * 8;
        this.align8Byte();
        this.checkBufferSize(num_bytes);
        int i = 0;
        while (i < num_doubles) {
            this.dbData.putDouble(array.get(i));
            ++i;
        }
        this.dbDataPos += num_bytes;
    }

    public int size() {
        if (this.dbDataPos > this.dbSize) {
            this.dbSize = this.dbDataPos;
        }
        return this.dbSize;
    }

    public void resetPos() {
        if (this.dbDataPos > this.dbSize) {
            this.dbSize = this.dbDataPos;
        }
        this.dbDataPos = 0;
    }

    public void setPosToEnd() {
        if (this.dbDataPos > this.dbSize) {
            this.dbSize = this.dbDataPos;
        }
        this.dbDataPos = this.dbSize;
        this.dbData.position(this.dbDataPos);
    }

    public int getPos() {
        return this.dbDataPos;
    }

    public void incrementPos(int increment) {
        this.dbDataPos += increment;
        this.dbData.position(this.dbDataPos);
    }

    public void decrementPos(int decrement) {
        this.dbDataPos -= decrement;
    }

    public byte[] getData() {
        return this.dbData.array();
    }

    public int getCapacity() {
        return this.dbData.capacity();
    }

    public void reserve(int sze) {
        if (this.dbData.capacity() < sze) {
            byte[] oldB = this.dbData.array();
            byte[] newB = new byte[sze];
            System.arraycopy(oldB, 0, newB, 0, oldB.length);
            this.dbData = ByteBuffer.wrap(newB);
            this.dbData.position(this.dbDataPos);
        }
    }

    private void checkBufferSize(int sincr) {
        if (this.dbDataPos + sincr > this.dbData.capacity()) {
            byte[] oldB = this.dbData.array();
            byte[] newB = new byte[this.dbDataPos + sincr];
            System.arraycopy(oldB, 0, newB, 0, oldB.length);
            this.dbData = ByteBuffer.wrap(newB);
            this.dbData.position(this.dbDataPos);
        }
    }
}

