/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.rstt;

import cn.org.gddsn.seis.location.rstt.GreatCircle;
import cn.org.gddsn.seis.location.rstt.Grid;
import cn.org.gddsn.seis.location.rstt.InterpolatedProfile;
import cn.org.gddsn.seis.location.rstt.Location;
import cn.org.gddsn.seis.location.rstt.SLBMException;
import cn.org.gddsn.seis.location.rstt.TauPSite;
import java.util.Vector;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrustalProfile
extends InterpolatedProfile {
    private static int crustalProfileClassCount = 0;
    private Location location = new Location();
    private boolean inCrust;
    private int phase;
    private double[] radius = new double[9];
    private double[] velocity = new double[9];
    private int[] layid = new int[9];
    private int nlay;
    private int topLayid;
    private int nMiddleCrust;
    private double fudgeFactor;
    private TauPSite cpTPS = null;

    public CrustalProfile() {
        this.fudgeFactor = 1.0;
        ++crustalProfileClassCount;
    }

    public CrustalProfile(CrustalProfile other) {
        super(other);
        this.fudgeFactor = other.fudgeFactor;
        ++crustalProfileClassCount;
        if (other.cpTPS != null) {
            this.cpTPS = new TauPSite(other.cpTPS);
        }
        int k = 0;
        while (k < 9) {
            this.radius[k] = other.radius[k];
            this.velocity[k] = other.velocity[k];
            ++k;
        }
        this.inCrust = other.inCrust;
    }

    public CrustalProfile copy(CrustalProfile other) {
        if (this.cpTPS != null) {
            this.cpTPS = null;
        }
        this.cpTPS = null;
        if (other.cpTPS != null) {
            this.cpTPS = new TauPSite(other.cpTPS);
        }
        super.copy(other);
        int k = 0;
        while (k < 9) {
            this.radius[k] = other.radius[k];
            this.velocity[k] = other.velocity[k];
            ++k;
        }
        this.fudgeFactor = other.fudgeFactor;
        return this;
    }

    public boolean equals(CrustalProfile other) {
        return super.equals(other) && this.radius == other.radius && this.velocity == other.velocity;
    }

    public boolean equals_no(CrustalProfile other) {
        return !this.equals(other);
    }

    @Override
    protected void finalize() {
        --crustalProfileClassCount;
        if (this.cpTPS != null) {
            this.cpTPS = null;
        }
    }

    public static int getClassCount() {
        return crustalProfileClassCount;
    }

    public void getData(Vector<Double> depths, Vector<Double> velocities) {
        depths.clear();
        velocities.clear();
        double R = this.getEarthRadius();
        int i = 0;
        while (i < this.getNIntervals()) {
            depths.add(R - this.radius[i]);
            velocities.add(this.velocity[i]);
            ++i;
        }
    }

    public double getDepth(int k) {
        return this.getEarthRadius() - this.radius[k];
    }

    public void getDepths(double[] depths) {
        double R = this.getEarthRadius();
        int i = 0;
        while (i < this.getNIntervals()) {
            depths[i] = R - this.radius[i];
            ++i;
        }
    }

    public double getEarthRadius() {
        return this.location.getEarthRadius();
    }

    public double getInterfaceRadius(int k) {
        return this.radius[k];
    }

    public final int[] getLayid() {
        return this.layid;
    }

    public final Location getLocation() {
        return this.location;
    }

    public int getNIntervals() {
        return 9;
    }

    public int getNLayid() {
        return this.nlay;
    }

    public double getPCrit(GreatCircle greatCircle) {
        return this.radius[greatCircle.getHeadWaveInterface()] / this.velocity[greatCircle.getHeadWaveInterface()];
    }

    public TauPSite getTauPSite() {
        return this.cpTPS;
    }

    public int getTopLayid() {
        return this.topLayid;
    }

    public double[] getVelocities() {
        return this.velocity;
    }

    public double getVelocity(int k) {
        return this.velocity[k];
    }

    public boolean isInCrust() {
        return this.inCrust;
    }

    public void setTauPSite(TauPSite tps) {
        this.cpTPS = tps;
    }

    public void setup(Grid grid, int _phase, double lat, double lon, double depth) {
        int i;
        this.location.setLocation(lat, lon, depth);
        double earthRadius = this.getEarthRadius();
        this.phase = _phase;
        if (this.cpTPS != null) {
            this.cpTPS = null;
        }
        grid.findProfile(this.location, this.neighbors, this.coefficients);
        int k = 0;
        while (k < 9) {
            this.interpDepth(k, this.radius, k);
            this.radius[k] = earthRadius - this.radius[k];
            this.interpVelocity(this.phase % 2, k, this.velocity, k);
            ++k;
        }
        this.nlay = 0;
        k = 1;
        while (k < 8) {
            if (k == 5) {
                if ((this.phase == 0 || this.phase == 1) && this.radius[5] - this.radius[7] > 1.0E-6) {
                    this.layid[this.nlay++] = k;
                }
            } else if (k == 6) {
                if ((this.phase == 2 || this.phase == 3) && this.radius[6] - this.radius[7] > 1.0E-6) {
                    this.layid[this.nlay++] = k;
                }
            } else if (this.radius[k] - this.radius[k + 1] > 1.0E-6) {
                this.layid[this.nlay++] = k;
            }
            ++k;
        }
        this.layid[this.nlay++] = 8;
        this.nMiddleCrust = -1;
        this.topLayid = -1;
        boolean bl = this.inCrust = this.location.getRadius() > this.radius[8];
        if (this.inCrust) {
            k = 0;
            while (k < this.nlay) {
                if (this.radius[this.layid[k]] < this.location.getRadius()) {
                    if (this.topLayid == -1) {
                        this.topLayid = Math.max(0, k - 1);
                    }
                    if (this.nMiddleCrust < 0 && this.layid[k] >= 6) {
                        this.nMiddleCrust = k;
                    }
                }
                ++k;
            }
        }
        if (this.phase == 2 || this.phase == 3) {
            this.velocity[7] = this.velocity[6];
            this.fudgeFactor = Math.min(1.0, (this.velocity[6] - 0.1) / this.velocity[4]);
            if (this.fudgeFactor < 1.0) {
                i = 0;
                while (i <= 4) {
                    int n = i++;
                    this.velocity[n] = this.velocity[n] * this.fudgeFactor;
                }
            }
        } else {
            this.fudgeFactor = 1.0;
        }
        i = 0;
        while (i < this.nlay) {
            if (this.velocity[this.layid[i]] < 1.0E-6) {
                String err = "\nERROR in CrustalProfile constructor\nLayer " + this.layid[i] + " has velocity of 0 km/sec.\n" + "Phase = " + (this.phase == 0 ? "Pn" : (this.phase == 1 ? "Sn" : (this.phase == 2 ? "Pg" : (this.phase == 3 ? "Lg" : "?")))) + "\nLocation = " + this.location.toString() + "\n";
                throw new SLBMException(err, 500);
            }
            ++i;
        }
    }

    public void xtCrust(GreatCircle greatCircle, double p, doubleW xTotal, doubleW tTotal) {
        int n = 0;
        if (greatCircle.getHeadWaveInterface() == 8) {
            n = this.nlay - 1;
        } else if (greatCircle.getHeadWaveInterface() == 6) {
            n = this.nMiddleCrust;
        }
        double rayParameter = p < 0.0 ? this.getPCrit(greatCircle) : Math.min(p, this.getPCrit(greatCircle));
        boolean done = false;
        while (!done) {
            done = true;
            xTotal.val = 0.0;
            tTotal.val = 0.0;
            int j = this.topLayid;
            while (j < n) {
                double r = j == this.topLayid ? this.location.getRadius() : this.radius[this.layid[j]];
                double pv = rayParameter * this.velocity[this.layid[j]];
                if (pv / this.radius[this.layid[j + 1]] > 1.0) {
                    String err = "\nERROR in xtCrust()\nA crustal layer has velocity greater than the velocity of the top of the mantle.\n\n" + this.toString() + "\n";
                    throw new SLBMException(err, 501);
                }
                xTotal.val += Math.acos(pv / r) - Math.acos(pv / this.radius[this.layid[j + 1]]);
                tTotal.val += (Math.sqrt(r * r - pv * pv) - Math.sqrt(this.radius[this.layid[j + 1]] * this.radius[this.layid[j + 1]] - pv * pv)) / this.velocity[this.layid[j]];
                ++j;
            }
        }
    }

    public void xtCrust(GreatCircle greatCircle, double p, int[] lid, double[] x, double[] r, double[] v, double[] t, intW npoints) {
        int n = 0;
        if (greatCircle.getHeadWaveInterface() == 8) {
            n = this.nlay - 1;
        } else if (greatCircle.getHeadWaveInterface() == 6) {
            n = this.nMiddleCrust;
        }
        npoints.val = n + 1;
        double rayParameter = p < 0.0 ? this.getPCrit(greatCircle) : Math.min(p, this.getPCrit(greatCircle));
        double dx = 0.0;
        double dt = 0.0;
        boolean done = false;
        while (!done) {
            done = true;
            int j = 0;
            while (j < npoints.val) {
                x[j] = j == 0 ? 0.0 : x[j - 1] + dx;
                r[j] = j == 0 ? this.location.getRadius() : this.radius[this.layid[j]];
                v[j] = this.velocity[this.layid[j]];
                t[j] = j == 0 ? 0.0 : t[j - 1] + dt;
                lid[j] = this.layid[j];
                double pv = rayParameter * this.velocity[this.layid[j]];
                if (pv / r[j] > 1.0) {
                    String err = "\nERROR in xtCrust()\nA crustal layer has velocity greater than the velocity of the top of the mantle.\n\n" + this.toString() + "\n";
                    throw new SLBMException(err, 502);
                }
                if (j < this.nlay - 1) {
                    dx = Math.acos(pv / r[j]) - Math.acos(pv / this.radius[this.layid[j + 1]]);
                    dt = (Math.sqrt(r[j] * r[j] - pv * pv) - Math.sqrt(this.radius[this.layid[j + 1]] * this.radius[this.layid[j + 1]] - pv * pv)) / this.velocity[this.layid[j]];
                }
                ++j;
            }
        }
    }
}

