/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.nlloc;

import org.apache.log4j.Logger;

public class Time3d {
    static Logger logger = Logger.getLogger(Time3d.class);
    private static final float M_SQRT2 = 1.4142135f;
    private static final float M_SQRT3 = 1.7320508f;
    private static final float INFINITY = 1.0E19f;
    private static int nmesh_x;
    private static int nmesh_y;
    private static int nmesh_z;
    private static float[][][] hs;
    private static float[] hs_buf;
    private static float[] hs_keep;
    private static int nx;
    private static int ny;
    private static int nz;
    private static float[][][] t;
    private static float[] t_buf;
    private static float fxs;
    private static float fys;
    private static float fzs;
    private static int xs;
    private static int ys;
    private static int zs;
    private static int mult;
    private static final int INIT_MIN = 7;
    private static final int N_INIT_X = 31;
    private static final int N_INIT = 29791;
    private static final int INIT_RECURS_LIMIT = 1;
    private static int messages;
    private static int source_at_node;
    private static int no_init;
    private static int init_stage;
    private static int current_side_limit;
    private static int X0;
    private static int X1;
    private static int Y0;
    private static int Y1;
    private static int Z0;
    private static int Z1;
    private static int sum_updated;
    private static int reverse_order;
    private static int flag_fb;
    private static int x_start_fb;
    private static int y_start_fb;
    private static int z_start_fb;
    private static int flag_bf;
    private static int x_start_bf;
    private static int y_start_bf;
    private static int z_start_bf;
    private static int flag_ff;
    private static int x_start_ff;
    private static int y_start_ff;
    private static int z_start_ff;
    private static int flag_bb;
    private static int x_start_bb;
    private static int y_start_bb;
    private static int z_start_bb;
    private static int[] longflags;
    private static float hs_eps_init;
    private static final int NO_ERROR = 0;
    private static final int ERR_MULT = -1;
    private static final int ERR_INF = -2;
    private static final int ERR_HS_EPS = -5;
    private static final int ERR_NONPHYSICAL = -6;
    private static final String[] err_msg;

    static {
        mult = 0;
        source_at_node = 0;
        no_init = 0;
        init_stage = 0;
        err_msg = new String[]{"\ntime_3d: Computations terminated normally.\n", "\ntime_3d: Multiple source but no source at finite time.\n", "\ntime_3d: Source point is in a zero velocity zone.\n", "\ntime_3d: Fatal error during recursive init.\n", "\ntime_3d: Memory Allocation failed.\n", "\ntime_3d: Init: Illegal tolerance on inhomogeneity.\n", "\ntime_3d: Illegal negative slowness value.\n"};
    }

    private static boolean ISINF(float x) {
        return (double)x > 1.0E18;
    }

    private static int NINT(float x) {
        return (int)Math.floor((double)x + 0.5);
    }

    private static float min3(float x, float y, float z) {
        return Math.min(x, Math.min(y, z));
    }

    private static float min4(float x, float y, float z, float t) {
        return Math.min(x, Time3d.min3(y, z, t));
    }

    private Time3d() {
    }

    private static void error(int flag) {
        if (messages != 0 || flag != 0) {
            System.err.printf("%s", err_msg[-flag]);
        }
    }

    public static int time_3d(float[] HS, float[] T, int NX, int NY, int NZ, float XS, float YS, float ZS, float HS_EPS_INIT, int MSG) {
        hs_buf = HS;
        t_buf = T;
        nx = NX;
        ny = NY;
        nz = NZ;
        fxs = XS;
        fys = YS;
        fzs = ZS;
        hs_eps_init = HS_EPS_INIT;
        if ((double)hs_eps_init < 0.0 || (double)hs_eps_init > 1.0) {
            Time3d.error(-5);
            return -5;
        }
        int msg = MSG;
        if (msg < 0) {
            no_init = 1;
            msg = -msg;
        }
        messages = msg;
        int signal = Time3d.pre_init();
        if (signal == 0) {
            signal = Time3d.propagate_point(Time3d.init_point());
            Time3d.free_ptrs(nx);
        }
        if (init_stage == 0 || signal != 0) {
            Time3d.error(signal);
        }
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                int z = 0;
                while (z < nz) {
                    Time3d.t_buf[x * Time3d.ny * Time3d.nz + y * Time3d.nz + z] = t[x][y][z];
                    Time3d.hs_buf[x * Time3d.ny * Time3d.nz + y * Time3d.nz + z] = hs[x][y][z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return signal;
    }

    private static int pre_init() {
        int z;
        int y;
        int x;
        int n0;
        nmesh_x = nx - 1;
        nmesh_y = ny - 1;
        nmesh_z = nz - 1;
        int np = ny * nz;
        int nt = nx * np;
        int n1 = Math.max(nx, ny);
        if (n1 == (n0 = Math.max(nx, nz))) {
            n0 = Math.max(ny, nz);
        }
        hs = new float[nx][ny][nz];
        t = new float[nx][ny][nz];
        longflags = new int[n1 *= n0];
        if (init_stage != 0) {
            return 0;
        }
        if ((double)fxs >= 0.0 && fxs <= (float)(nx - 1) && fys >= 0.0f && fys <= (float)(ny - 1) && fzs >= 0.0f && fzs <= (float)(nz - 1)) {
            x = 0;
            while (x < nt) {
                Time3d.t_buf[x] = 1.0E19f;
                ++x;
            }
        }
        x = (nx + 1) * (ny + 1) + (nx + 1) * nz + nz * ny;
        hs_keep = new float[x];
        int n = 0;
        x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                Time3d.hs_keep[n++] = hs[x][y][nmesh_z];
                Time3d.hs_buf[x * Time3d.ny * Time3d.nz + y * Time3d.nz + Time3d.nmesh_z] = 1.0E19f;
                ++y;
            }
            z = 0;
            while (z < nmesh_z) {
                Time3d.hs_keep[n++] = hs[x][nmesh_y][z];
                Time3d.hs_buf[x * Time3d.ny * Time3d.nz + Time3d.nmesh_y * Time3d.nz + z] = 1.0E19f;
                ++z;
            }
            ++x;
        }
        y = 0;
        while (y < nmesh_y) {
            z = 0;
            while (z < nmesh_z) {
                Time3d.hs_keep[n++] = hs[nmesh_x][y][z];
                Time3d.hs_buf[Time3d.nmesh_x * Time3d.ny * Time3d.nz + y * Time3d.nz + z] = 1.0E19f;
                ++z;
            }
            ++y;
        }
        x = 0;
        while (x < nx * ny * nz) {
            if ((double)hs_buf[x] < 0.0) {
                Time3d.free_ptrs(nx);
                return -6;
            }
            ++x;
        }
        x = 0;
        while (x < nx) {
            y = 0;
            while (y < ny) {
                z = 0;
                while (z < nz) {
                    Time3d.t[x][y][z] = t_buf[x * ny * nz + y * nz + z];
                    Time3d.hs[x][y][z] = hs_buf[x * ny * nz + y * nz + z];
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return 0;
    }

    private static int init_point() {
        int test;
        int z;
        int y;
        int x;
        int signal = 0;
        float hs0 = 0.0f;
        if ((double)fxs < 0.0 || fxs > (float)(nx - 1) || fys < 0.0f || fys > (float)(ny - 1) || fzs < 0.0f || fzs > (float)(nz - 1)) {
            x = 0;
            float min_t = 1.0E19f;
            while (x < nx) {
                y = 0;
                while (y < ny) {
                    z = 0;
                    while (z < nz) {
                        if (t[x][y][z] < min_t) {
                            min_t = t[x][y][z];
                            xs = x;
                            ys = y;
                            zs = z;
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            if (Time3d.ISINF(min_t)) {
                return -1;
            }
            source_at_node = 1;
            mult = 1;
            if (messages != 0) {
                logger.info((Object)String.format("\nMultiple source starting at node [%d,%d,%d] at time %g.", xs, ys, zs, Float.valueOf(min_t)));
            }
        } else {
            xs = Time3d.NINT(fxs);
            ys = Time3d.NINT(fys);
            zs = Time3d.NINT(fzs);
            if ((float)xs == fxs && (float)ys == fys && (float)zs == fzs) {
                source_at_node = 1;
                if (messages != 0) {
                    logger.info((Object)String.format("\nSource located exactly at node [%d,%d,%d].", xs, ys, zs));
                }
            }
            mult = 0;
        }
        if (source_at_node != 0) {
            hs0 = hs[xs][ys][zs];
            if (Time3d.ISINF(hs0) && zs != 0) {
                hs0 = hs[xs][ys][zs - 1];
            }
            if (Time3d.ISINF(hs0) && ys != 0) {
                hs0 = hs[xs][ys - 1][zs];
            }
            if (Time3d.ISINF(hs0) && xs != 0) {
                hs0 = hs[xs - 1][ys][zs];
            }
            if (Time3d.ISINF(hs0) && zs != 0 && ys != 0) {
                hs0 = hs[xs][ys - 1][zs - 1];
            }
            if (Time3d.ISINF(hs0) && zs != 0 && xs != 0) {
                hs0 = hs[xs - 1][ys][zs - 1];
            }
            if (Time3d.ISINF(hs0) && ys != 0 && xs != 0) {
                hs0 = hs[xs - 1][ys - 1][zs];
            }
            if (Time3d.ISINF(hs0) && zs != 0 && ys != 0 && xs != 0) {
                hs0 = hs[xs - 1][ys - 1][zs - 1];
            }
        } else if (mult == 0) {
            x = fxs < (float)xs ? xs - 1 : xs;
            hs0 = hs[x][y = fys < (float)ys ? ys - 1 : ys][z = fzs < (float)zs ? zs - 1 : zs];
            if (Time3d.ISINF(hs0) && fxs == (float)xs && xs != 0) {
                hs0 = hs[x - 1][y][z];
                if (Time3d.ISINF(hs0) && fys == (float)ys && ys != 0) {
                    hs0 = hs[x - 1][y - 1][z];
                }
                if (Time3d.ISINF(hs0) && fzs == (float)zs && zs != 0) {
                    hs0 = hs[x - 1][y][z - 1];
                }
            }
            if (Time3d.ISINF(hs0) && fys == (float)ys && ys != 0 && Time3d.ISINF(hs0 = hs[x][y - 1][z]) && fzs == (float)zs && zs != 0) {
                hs0 = hs[x][y - 1][z - 1];
            }
            if (Time3d.ISINF(hs0) && fzs == (float)zs && zs != 0) {
                hs0 = hs[x][y][z - 1];
            }
        }
        if (Time3d.ISINF(hs0)) {
            return -2;
        }
        if (mult != 0) {
            X0 = X1 = xs;
            Y0 = Y1 = ys;
            Z0 = Z1 = zs;
            return 0;
        }
        if (no_init != 0) {
            X0 = X1 = xs;
            Y0 = Y1 = ys;
            Z0 = Z1 = zs;
            Time3d.init_nearest();
            return 0;
        }
        X0 = Math.max(xs - 1, 0);
        Y0 = Math.max(ys - 1, 0);
        Z0 = Math.max(zs - 1, 0);
        X1 = Math.min(xs + 1, nmesh_x - 1);
        Y1 = Math.min(ys + 1, nmesh_y - 1);
        Z1 = Math.min(zs + 1, nmesh_z - 1);
        boolean t_Z1 = false;
        boolean t_Z0 = false;
        boolean t_Y1 = false;
        boolean t_Y0 = false;
        boolean t_X1 = false;
        boolean t_X0 = false;
        float allowed_delta_hs = hs0 * hs_eps_init;
        do {
            test = 0;
            if (X0 != 0 && !t_X0) {
                ++test;
                x = X0;
                y = Y0;
                while (y <= Y1 && y < nmesh_y && !t_X0) {
                    z = Z0;
                    while (z <= Z1 && z < nmesh_z && !t_X0) {
                        if (Math.abs(hs[x][y][z] - hs0) > allowed_delta_hs) {
                            t_X0 = true;
                        }
                        ++z;
                    }
                    ++y;
                }
                if (!t_X0) {
                    --X0;
                }
            }
            if (Y0 != 0 && !t_Y0) {
                ++test;
                y = Y0;
                x = X0;
                while (x <= X1 && x < nmesh_x && !t_Y0) {
                    z = Z0;
                    while (z <= Z1 && z < nmesh_z && !t_Y0) {
                        if (Math.abs(hs[x][y][z] - hs0) > allowed_delta_hs) {
                            t_Y0 = true;
                        }
                        ++z;
                    }
                    ++x;
                }
                if (!t_Y0) {
                    --Y0;
                }
            }
            if (Z0 != 0 && !t_Z0) {
                ++test;
                z = Z0;
                x = X0;
                while (x <= X1 && x < nmesh_x && !t_Z0) {
                    y = Y0;
                    while (y <= Y1 && y < nmesh_y && !t_Z0) {
                        if (Math.abs(hs[x][y][z] - hs0) > allowed_delta_hs) {
                            t_Z0 = true;
                        }
                        ++y;
                    }
                    ++x;
                }
                if (!t_Z0) {
                    --Z0;
                }
            }
            if (X1 < nmesh_x && !t_X1) {
                ++test;
                x = ++X1;
                y = Y0;
                while (y <= Y1 && y < nmesh_y && !t_X1) {
                    z = Z0;
                    while (z <= Z1 && z < nmesh_z && !t_X1) {
                        if (Math.abs(hs[x][y][z] - hs0) > allowed_delta_hs) {
                            t_X1 = true;
                        }
                        ++z;
                    }
                    ++y;
                }
            }
            if (Y1 < nmesh_y && !t_Y1) {
                ++test;
                y = ++Y1;
                x = X0;
                while (x <= X1 && x < nmesh_x && !t_Y1) {
                    z = Z0;
                    while (z <= Z1 && z < nmesh_z && !t_Y1) {
                        if (Math.abs(hs[x][y][z] - hs0) > allowed_delta_hs) {
                            t_Y1 = true;
                        }
                        ++z;
                    }
                    ++x;
                }
            }
            if (Z1 >= nmesh_z || t_Z1) continue;
            ++test;
            z = ++Z1;
            x = X0;
            while (x <= X1 && x < nmesh_x && !t_Z1) {
                y = Y0;
                while (y <= Y1 && y < nmesh_y && !t_Z1) {
                    if (Math.abs(hs[x][y][z] - hs0) > allowed_delta_hs) {
                        t_Z1 = true;
                    }
                    ++y;
                }
                ++x;
            }
        } while (test != 0);
        if (X0 != 0) {
            ++X0;
        }
        if (Y0 != 0) {
            ++Y0;
        }
        if (Z0 != 0) {
            ++Z0;
        }
        if (X1 < nmesh_x) {
            --X1;
        }
        if (Y1 < nmesh_y) {
            --Y1;
        }
        if (Z1 < nmesh_z) {
            --Z1;
        }
        if (!(init_stage < 1 && (X0 != 0 && xs - X0 < 7 || Y0 != 0 && ys - Y0 < 7 || Z0 != 0 && zs - Z0 < 7 || X1 != nmesh_x && X1 - xs < 7 || Y1 != nmesh_y && Y1 - ys < 7 || Z1 != nmesh_z && Z1 - zs < 7))) {
            if ((X1 - X0 + 1) * (Y1 - Y0 + 1) * (Z1 - Z0 + 1) == 1) {
                Time3d.init_nearest();
            } else {
                x = X0;
                while (x <= X1) {
                    y = Y0;
                    while (y <= Y1) {
                        z = Z0;
                        while (z <= Z1) {
                            float dist = ((float)x - fxs) * ((float)x - fxs) + ((float)y - fys) * ((float)y - fys) + ((float)z - fzs) * ((float)z - fzs);
                            Time3d.t[x][y][z] = hs0 * (float)Math.sqrt(dist);
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            if (messages != 0) {
                logger.info((Object)String.format("\nHomogeneous region: x[%d->%d] y[%d->%d] z[%d->%d]\n", X0, X1, Y0, Y1, Z0, Z1));
            }
        } else {
            signal = Time3d.recursive_init();
            if (signal != 0) {
                return signal;
            }
            X0 = Math.max(xs - 7, 0);
            Y0 = Math.max(ys - 7, 0);
            Z0 = Math.max(zs - 7, 0);
            X1 = Math.min(xs + 7, nmesh_x);
            Y1 = Math.min(ys + 7, nmesh_y);
            Z1 = Math.min(zs + 7, nmesh_z);
        }
        return signal;
    }

    private static void init_nearest() {
        if (source_at_node != 0) {
            Time3d.t[Time3d.xs][Time3d.ys][Time3d.zs] = 0.0f;
            return;
        }
        int x = fxs < (float)xs ? xs - 1 : xs;
        int y = fys < (float)ys ? ys - 1 : ys;
        int z = fzs < (float)zs ? zs - 1 : zs;
        float distx = Math.abs(fxs - (float)x);
        float disty = Math.abs(fys - (float)y);
        float distz = Math.abs(fzs - (float)z);
        Time3d.init_cell(distx, disty, distz, x, y, z);
        if (fxs == (float)xs) {
            if (fys == (float)ys) {
                if (x != 0) {
                    Time3d.init_cell(1.0f, 0.0f, distz, x - 1, y, z);
                }
                if (y != 0) {
                    Time3d.init_cell(0.0f, 1.0f, distz, x, y - 1, z);
                }
                if (x != 0 && y != 0) {
                    Time3d.init_cell(1.0f, 1.0f, distz, x - 1, y - 1, z);
                }
            } else if (fzs == (float)zs) {
                if (x != 0) {
                    Time3d.init_cell(1.0f, disty, 0.0f, x - 1, y, z);
                }
                if (z != 0) {
                    Time3d.init_cell(0.0f, disty, 1.0f, x, y, z - 1);
                }
                if (z != 0 && x != 0) {
                    Time3d.init_cell(1.0f, disty, 1.0f, x - 1, y, z - 1);
                }
            } else if (x != 0) {
                Time3d.init_cell(1.0f, disty, distz, x - 1, y, z);
            }
        } else if (fys == (float)ys) {
            if (fzs == (float)zs) {
                if (y != 0) {
                    Time3d.init_cell(distx, 1.0f, 0.0f, x, y - 1, z);
                }
                if (z != 0) {
                    Time3d.init_cell(distz, 0.0f, 1.0f, x, y, z - 1);
                }
                if (y != 0 && z != 0) {
                    Time3d.init_cell(distx, 1.0f, 1.0f, x, y - 1, z - 1);
                }
            } else if (y != 0) {
                Time3d.init_cell(distx, 1.0f, distz, x, y - 1, z);
            }
        } else if (fzs == (float)zs && y != 0) {
            Time3d.init_cell(distx, disty, 1.0f, x, y, z - 1);
        }
    }

    private static void init_cell(float vx, float vy, float vz, int xl, int yl, int zl) {
        float est = Time3d.exact_delay(vx, vy, vz, xl, yl, zl);
        if (est < t[xl][yl][zl]) {
            Time3d.t[xl][yl][zl] = est;
        }
        if ((est = Time3d.exact_delay(1.0f - vx, vy, vz, xl, yl, zl)) < t[xl + 1][yl][zl]) {
            Time3d.t[xl + 1][yl][zl] = est;
        }
        if ((est = Time3d.exact_delay(vx, 1.0f - vy, vz, xl, yl, zl)) < t[xl][yl + 1][zl]) {
            Time3d.t[xl][yl + 1][zl] = est;
        }
        if ((est = Time3d.exact_delay(vx, vy, 1.0f - vz, xl, yl, zl)) < t[xl][yl][zl + 1]) {
            Time3d.t[xl][yl][zl + 1] = est;
        }
        if ((est = Time3d.exact_delay(1.0f - vx, 1.0f - vy, vz, xl, yl, zl)) < t[xl + 1][yl + 1][zl]) {
            Time3d.t[xl + 1][yl + 1][zl] = est;
        }
        if ((est = Time3d.exact_delay(1.0f - vx, vy, 1.0f - vz, xl, yl, zl)) < t[xl + 1][yl][zl + 1]) {
            Time3d.t[xl + 1][yl][zl + 1] = est;
        }
        if ((est = Time3d.exact_delay(vx, 1.0f - vy, 1.0f - vz, xl, yl, zl)) < t[xl][yl + 1][zl + 1]) {
            Time3d.t[xl][yl + 1][zl + 1] = est;
        }
        if ((est = Time3d.exact_delay(1.0f - vx, 1.0f - vy, 1.0f - vz, xl, yl, zl)) < t[xl + 1][yl + 1][zl + 1]) {
            Time3d.t[xl + 1][yl + 1][zl + 1] = est;
        }
    }

    private static int recursive_init() {
        int signal;
        int kk;
        int k;
        int jj;
        int j;
        float[] HS = new float[29791];
        float[] T = new float[29791];
        ++init_stage;
        if (messages != 0) {
            logger.info((Object)String.format("\nRecursive initialization: level %d", init_stage));
        }
        Time3d.free_ptrs(nx);
        int nx_ = nx;
        int ny_ = ny;
        int nz_ = nz;
        float[] hs_buf_ = hs_buf;
        float[] t_buf_ = t_buf;
        int xs_ = xs;
        int ys_ = ys;
        int zs_ = zs;
        float fxs_ = fxs;
        float fys_ = fys;
        float fzs_ = fzs;
        int X0_ = X0;
        int X1_ = X1;
        int Y0_ = Y0;
        int Y1_ = Y1;
        int Z0_ = Z0;
        int Z1_ = Z1;
        int i = 0;
        while (i < 29791) {
            T[i] = 1.0E19f;
            HS[i] = 1.0E19f;
            ++i;
        }
        nz = 31;
        ny = 31;
        nx = 31;
        zs = 15;
        ys = 15;
        xs = 15;
        int k0 = 1;
        int j0 = 1;
        int i0 = 1;
        int ihs = xs_ - 7 - 1;
        int d = 7 - xs_;
        if (d >= 0) {
            ihs += d + 1;
            d = 1 + 2 * d;
            nx -= d;
            xs -= d;
            i0 = 0;
        }
        if ((d = xs_ + 7 - nx_ + 1) >= 0) {
            nx -= 1 + 2 * d;
        }
        int jhs = ys_ - 7 - 1;
        d = 7 - ys_;
        if (d >= 0) {
            jhs += d + 1;
            d = 1 + 2 * d;
            ny -= d;
            ys -= d;
            j0 = 0;
        }
        if ((d = ys_ + 7 - ny_ + 1) >= 0) {
            ny -= 1 + 2 * d;
        }
        int khs = zs_ - 7 - 1;
        d = 7 - zs_;
        if (d >= 0) {
            khs += d + 1;
            d = 1 + 2 * d;
            nz -= d;
            zs -= d;
            k0 = 0;
        }
        if ((d = zs_ + 7 - nz_ + 1) >= 0) {
            nz -= 1 + 2 * d;
        }
        i = ihs;
        int ii = 0;
        int n = 0;
        while (ii < nx) {
            j = jhs;
            jj = 0;
            while (jj < ny) {
                k = khs;
                kk = 0;
                while (kk < nz) {
                    HS[n] = 0.5f * hs_buf_[i * ny_ * nz_ + j * nz_ + k];
                    if (kk % 2 != k0) {
                        ++k;
                    }
                    ++kk;
                    ++n;
                }
                if (jj % 2 != j0) {
                    ++j;
                }
                ++jj;
            }
            if (ii % 2 != i0) {
                ++i;
            }
            ++ii;
        }
        fxs = (float)xs + 2.0f * (fxs_ - (float)xs_);
        fys = (float)ys + 2.0f * (fys_ - (float)ys_);
        fzs = (float)zs + 2.0f * (fzs_ - (float)zs_);
        if (messages == 2) {
            logger.debug((Object)String.format("\nRediscretized timefield dimensions: %d %d %d", nx, ny, nz));
        }
        if ((signal = Time3d.time_3d(HS, T, nx, ny, nz, fxs, fys, fzs, hs_eps_init, messages)) == 0) {
            i = ihs + i0;
            ii = i0;
            while (ii < nx) {
                j = jhs + j0;
                jj = j0;
                while (jj < ny) {
                    k = khs + k0;
                    kk = k0;
                    while (kk < nz) {
                        t_buf_[i * ny_ * nz_ + j * nz_ + k] = T[ii * ny * nz + jj * nz + kk];
                        kk += 2;
                        ++k;
                    }
                    jj += 2;
                    ++j;
                }
                ii += 2;
                ++i;
            }
        }
        nx = nx_;
        ny = ny_;
        nz = nz_;
        hs_buf = hs_buf_;
        t_buf = t_buf_;
        xs = xs_;
        ys = ys_;
        zs = zs_;
        fxs = fxs_;
        fys = fys_;
        fzs = fzs_;
        X0 = X0_;
        X1 = X1_;
        Y0 = Y0_;
        Y1 = Y1_;
        Z0 = Z0_;
        Z1 = Z1_;
        signal = Time3d.pre_init();
        --init_stage;
        return signal;
    }

    private static int propagate_point(int start) {
        int test;
        if (start != 0) {
            return start;
        }
        sum_updated = 0;
        if (messages != 0) {
            logger.info((Object)String.format("\nStarting F.D. computation...", new Object[0]));
        }
        int msg = messages;
        if (init_stage != 0) {
            messages = 0;
        }
        do {
            test = 0;
            if (X0 > 0) {
                --X0;
                if (messages == 2) {
                    logger.debug((Object)String.format("\nx_side %d->%d: ", X0 + 1, X0));
                }
                Time3d.x_side(Y0, Y1, Z0, Z1, X0, -1);
                ++test;
            }
            if (Y0 > 0) {
                --Y0;
                if (messages == 2) {
                    logger.debug((Object)String.format("\ny_side %d->%d: ", Y0 + 1, Y0));
                }
                Time3d.y_side(X0, X1, Z0, Z1, Y0, -1);
                ++test;
            }
            if (Z0 > 0) {
                --Z0;
                if (messages == 2) {
                    logger.debug((Object)String.format("\nz_side %d->%d: ", Z0 + 1, Z0));
                }
                Time3d.z_side(X0, X1, Y0, Y1, Z0, -1);
                ++test;
            }
            if (X1 < nmesh_x) {
                ++X1;
                if (messages == 2) {
                    logger.debug((Object)String.format("\nx_side %d->%d: ", X1 - 1, X1));
                }
                Time3d.x_side(Y0, Y1, Z0, Z1, X1, 1);
                ++test;
            }
            if (Y1 < nmesh_y) {
                ++Y1;
                if (messages == 2) {
                    logger.debug((Object)String.format("\ny_side %d->%d: ", Y1 - 1, Y1));
                }
                Time3d.y_side(X0, X1, Z0, Z1, Y1, 1);
                ++test;
            }
            if (Z1 >= nmesh_z) continue;
            ++Z1;
            if (messages == 2) {
                logger.debug((Object)String.format("\nz_side %d->%d: ", Z1 - 1, Z1));
            }
            Time3d.z_side(X0, X1, Y0, Y1, Z1, 1);
            ++test;
        } while (test != 0);
        messages = msg;
        return 0;
    }

    private static void free_ptrs(int max_x) {
        if (init_stage == 0 && hs_keep != null) {
            int z;
            int y;
            int n = 0;
            int x = 0;
            while (x < nx) {
                y = 0;
                while (y < ny) {
                    Time3d.hs[x][y][Time3d.nmesh_z] = hs_keep[n++];
                    ++y;
                }
                z = 0;
                while (z < nmesh_z) {
                    Time3d.hs[x][Time3d.nmesh_y][z] = hs_keep[n++];
                    ++z;
                }
                ++x;
            }
            y = 0;
            while (y < nmesh_y) {
                z = 0;
                while (z < nmesh_z) {
                    Time3d.hs[Time3d.nmesh_x][y][z] = hs_keep[n++];
                    ++z;
                }
                ++y;
            }
        }
        hs_keep = null;
        hs = null;
        t = null;
        longflags = null;
    }

    private static float exact_delay(float vx, float vy, float vz, int xm, int ym, int zm) {
        if (xm < 0 || xm >= nmesh_x || ym < 0 || ym >= nmesh_y || zm < 0 || zm >= nmesh_z) {
            return 1.0E19f;
        }
        float estimate = (vx * vx + vy * vy + vz * vz) * hs[xm][ym][zm] * hs[xm][ym][zm];
        return (float)Math.sqrt(estimate);
    }

    private static int t_1d(int x, int y, int z, float t0, float hs0, float hs1, float hs2, float hs3) {
        float estimate = t0 + Time3d.min4(hs0, hs1, hs2, hs3);
        if (estimate < t[x][y][z]) {
            Time3d.t[x][y][z] = estimate;
            return 1;
        }
        return 0;
    }

    private static int diff_2d(int x, int y, int z, float t0, float hs0, float hs1) {
        float estimate = t0 + 1.4142135f * Math.min(hs0, hs1);
        if (estimate < t[x][y][z]) {
            Time3d.t[x][y][z] = estimate;
            return 1;
        }
        return 0;
    }

    private static int point_diff(int x, int y, int z, float t0, float hs0) {
        float estimate = t0 + hs0 * 1.7320508f;
        if (estimate < t[x][y][z]) {
            Time3d.t[x][y][z] = estimate;
            return 1;
        }
        return 0;
    }

    private static int t_2d(int x, int y, int z, float t0, float t1, float hs0, float hs1) {
        float estimate;
        float dt = t1 - t0;
        float test2 = t[x][y][z] - t1;
        if ((double)dt < 0.0 || (double)test2 < 0.0) {
            return 0;
        }
        test2 *= test2;
        float hsm = Math.min(hs0, hs1);
        float u2 = hsm * hsm - dt * dt;
        if (dt <= hsm / 1.4142135f && u2 <= test2 && (estimate = t1 + (float)Math.sqrt(u2)) < t[x][y][z]) {
            Time3d.t[x][y][z] = estimate;
            return 1;
        }
        return 0;
    }

    private static int edge_diff(int x, int y, int z, float t0, float t1, float hs0) {
        float estimate;
        float dt = t1 - t0;
        float test2 = t[x][y][z] - t1;
        if ((double)dt < 0.0 || (double)test2 < 0.0) {
            return 0;
        }
        test2 *= test2;
        float u2 = hs0 * hs0 - dt * dt;
        if (dt <= hs0 / 1.7320508f && 2.0 * (double)u2 <= (double)test2 && (estimate = t1 + 1.4142135f * (float)Math.sqrt(u2)) < t[x][y][z]) {
            Time3d.t[x][y][z] = estimate;
            return 1;
        }
        return 0;
    }

    private static int t_3d(int x, int y, int z, float a, float b, float c, float d, float e) {
        return Time3d.t_3d_(x, y, z, a, b, c, d, e, 0);
    }

    private static int t_3d_part2(int x, int y, int z, float a, float b, float c, float d, float e) {
        return Time3d.t_3d_(x, y, z, a, b, c, d, e, 1);
    }

    private static int t_3d_(int x, int y, int z, float t0, float tl, float tr, float td, float hs0, int redundant) {
        float estimate;
        float r2;
        float test2;
        int action = 0;
        hs0 *= hs0;
        float dta = tl - t0;
        float dtb = tr - t0;
        float dta2 = dta * dta;
        float dtb2 = dtb * dtb;
        if ((double)dta >= 0.0 && (double)dtb >= 0.0 && (double)(dta2 + dtb2 + dta * dtb) >= 0.5 * (double)hs0 && 2.0 * (double)dta2 + (double)dtb2 <= (double)hs0 && 2.0 * (double)dtb2 + (double)dta2 <= (double)hs0 && (double)(test2 = t[x][y][z] - tr - tl + t0) >= 0.0 && (r2 = hs0 - dta2 - dtb2) < (test2 *= test2) && (estimate = tr + tl - t0 + (float)Math.sqrt(r2)) < t[x][y][z]) {
            Time3d.t[x][y][z] = estimate;
            ++action;
        }
        if ((double)(test2 = t[x][y][z] - td) < 0.0) {
            return action;
        }
        test2 *= test2;
        float u2 = 1.0E19f;
        float t2 = 1.0E19f;
        float s2 = 1.0E19f;
        dtb = td - tl;
        dtb2 = dtb * dtb;
        if ((double)dta >= 0.0 && dtb >= dta && 2.0 * (double)dtb2 + (double)dta2 <= (double)hs0) {
            s2 = hs0 - dta2 - dtb2;
        }
        dta = td - tr;
        dta2 = dta * dta;
        if (redundant == 0 && (double)dta >= 0.0 && (double)dtb >= 0.0 && (double)(dta2 + dtb2 + dta * dtb) <= 0.5 * (double)hs0) {
            t2 = hs0 - dta2 - dtb2;
        }
        dtb = tr - t0;
        dtb2 = dtb * dtb;
        if ((double)dtb >= 0.0 && dta >= dtb && 2.0 * (double)dta2 + (double)dtb2 <= (double)hs0) {
            u2 = hs0 - dta2 - dtb2;
        }
        if ((u2 = Time3d.min3(s2, t2, u2)) < test2 && (estimate = td + (float)Math.sqrt(u2)) < t[x][y][z]) {
            Time3d.t[x][y][z] = estimate;
            ++action;
        }
        return action;
    }

    private static int t_3d_part1(int x, int y, int z, float t0, float tl, float tr, float hs0) {
        float estimate;
        float dtl = t0 - tl;
        float dtr = t0 - tr;
        float test2 = t[x][y][z] - t0;
        if ((double)test2 < 0.0 || (double)dtl < 0.0 || (double)dtr < 0.0) {
            return 0;
        }
        test2 *= test2;
        float s2 = dtl * dtl + dtr * dtr;
        if ((double)(s2 + dtl * dtr) > 0.5 * (double)(hs0 *= hs0)) {
            return 0;
        }
        float u2 = hs0 - s2;
        if (u2 < test2 && (estimate = t0 + (float)Math.sqrt(u2)) < t[x][y][z]) {
            Time3d.t[x][y][z] = estimate;
            return 1;
        }
        return 0;
    }

    private static int x_side(int y_begin, int y_end, int z_begin, int z_end, int x, int future) {
        int test;
        if (reverse_order == 0) {
            current_side_limit = x + future;
        }
        int updated = 0;
        int x0 = x - future;
        int x_s = future == 1 ? x0 : x;
        flag_bb = 0;
        flag_ff = 0;
        flag_bf = 0;
        flag_fb = 0;
        y_start_ff = y_start_fb = y_end;
        y_start_bf = y_start_bb = y_begin;
        z_start_ff = z_start_bf = z_end;
        z_start_fb = z_start_bb = z_begin;
        int y = y_begin;
        while (y <= y_end) {
            int z = z_begin;
            while (z <= z_end) {
                float hs_ff = hs[x_s][y][z];
                float hs_bf = y > 0 ? hs[x_s][y - 1][z] : 1.0E19f;
                float hs_bb = z > 0 && y > 0 ? hs[x_s][y - 1][z - 1] : 1.0E19f;
                float hs_fb = z > 0 ? hs[x_s][y][z - 1] : 1.0E19f;
                int sign_bb = 0;
                int sign_ff = 0;
                int sign_bf = 0;
                int sign_fb = 0;
                updated += Time3d.t_1d(x, y, z, t[x0][y][z], hs_ff, hs_bf, hs_bb, hs_fb);
                if (y < y_end && z < z_end) {
                    updated += Time3d.t_3d_part1(x, y, z, t[x0][y][z], t[x0][y + 1][z], t[x0][y][z + 1], hs_ff);
                }
                if (y > y_begin && z < z_end) {
                    updated += Time3d.t_3d_part1(x, y, z, t[x0][y][z], t[x0][y - 1][z], t[x0][y][z + 1], hs_bf);
                }
                if (y > y_begin && z > z_begin) {
                    updated += Time3d.t_3d_part1(x, y, z, t[x0][y][z], t[x0][y - 1][z], t[x0][y][z - 1], hs_bb);
                }
                if (y < y_end && z > z_begin) {
                    updated += Time3d.t_3d_part1(x, y, z, t[x0][y][z], t[x0][y + 1][z], t[x0][y][z - 1], hs_fb);
                }
                if (y < y_end && t[x0][y][z] <= t[x0][y + 1][z]) {
                    ++sign_fb;
                    ++sign_ff;
                    if (y < y_start_ff) {
                        y_start_ff = y;
                    }
                    if (y < y_start_fb) {
                        y_start_fb = y;
                    }
                    updated += Time3d.diff_2d(x, y + 1, z, t[x0][y][z], hs_ff, hs_fb);
                    updated += Time3d.t_2d(x, y + 1, z, t[x0][y][z], t[x0][y + 1][z], hs_ff, hs_fb);
                }
                if (y > y_begin && t[x0][y][z] <= t[x0][y - 1][z]) {
                    ++sign_bb;
                    ++sign_bf;
                    if (y > y_start_bf) {
                        y_start_bf = y;
                    }
                    if (y > y_start_bb) {
                        y_start_bb = y;
                    }
                    updated += Time3d.diff_2d(x, y - 1, z, t[x0][y][z], hs_bf, hs_bb);
                    updated += Time3d.t_2d(x, y - 1, z, t[x0][y][z], t[x0][y - 1][z], hs_bf, hs_bb);
                }
                if (z < z_end && t[x0][y][z] <= t[x0][y][z + 1]) {
                    ++sign_bf;
                    ++sign_ff;
                    if (z < z_start_ff) {
                        z_start_ff = z;
                    }
                    if (z < z_start_bf) {
                        z_start_bf = z;
                    }
                    updated += Time3d.diff_2d(x, y, z + 1, t[x0][y][z], hs_ff, hs_bf);
                    updated += Time3d.t_2d(x, y, z + 1, t[x0][y][z], t[x0][y][z + 1], hs_ff, hs_bf);
                }
                if (z > z_begin && t[x0][y][z] <= t[x0][y][z - 1]) {
                    ++sign_bb;
                    ++sign_fb;
                    if (z > z_start_fb) {
                        z_start_fb = z;
                    }
                    if (z > z_start_bb) {
                        z_start_bb = z;
                    }
                    updated += Time3d.diff_2d(x, y, z - 1, t[x0][y][z], hs_bb, hs_fb);
                    updated += Time3d.t_2d(x, y, z - 1, t[x0][y][z], t[x0][y][z - 1], hs_bb, hs_fb);
                }
                if (sign_ff == 2) {
                    flag_ff = 1;
                    updated += Time3d.point_diff(x, y + 1, z + 1, t[x0][y][z], hs_ff);
                    updated += Time3d.edge_diff(x, y + 1, z + 1, t[x0][y][z], t[x0][y + 1][z], hs_ff);
                    updated += Time3d.edge_diff(x, y + 1, z + 1, t[x0][y][z], t[x0][y][z + 1], hs_ff);
                    updated += Time3d.t_3d_part2(x, y + 1, z + 1, t[x0][y][z], t[x0][y + 1][z], t[x0][y][z + 1], t[x0][y + 1][z + 1], hs_ff);
                }
                if (sign_bf == 2) {
                    flag_bf = 1;
                    updated += Time3d.point_diff(x, y - 1, z + 1, t[x0][y][z], hs_bf);
                    updated += Time3d.edge_diff(x, y - 1, z + 1, t[x0][y][z], t[x0][y - 1][z], hs_bf);
                    updated += Time3d.edge_diff(x, y - 1, z + 1, t[x0][y][z], t[x0][y][z + 1], hs_bf);
                    updated += Time3d.t_3d_part2(x, y - 1, z + 1, t[x0][y][z], t[x0][y - 1][z], t[x0][y][z + 1], t[x0][y - 1][z + 1], hs_bf);
                }
                if (sign_bb == 2) {
                    flag_bb = 1;
                    updated += Time3d.point_diff(x, y - 1, z - 1, t[x0][y][z], hs_bb);
                    updated += Time3d.edge_diff(x, y - 1, z - 1, t[x0][y][z], t[x0][y - 1][z], hs_bb);
                    updated += Time3d.edge_diff(x, y - 1, z - 1, t[x0][y][z], t[x0][y][z - 1], hs_bb);
                    updated += Time3d.t_3d_part2(x, y - 1, z - 1, t[x0][y][z], t[x0][y - 1][z], t[x0][y][z - 1], t[x0][y - 1][z - 1], hs_bb);
                }
                if (sign_fb == 2) {
                    flag_fb = 1;
                    updated += Time3d.point_diff(x, y + 1, z - 1, t[x0][y][z], hs_fb);
                    updated += Time3d.edge_diff(x, y + 1, z - 1, t[x0][y][z], t[x0][y + 1][z], hs_fb);
                    updated += Time3d.edge_diff(x, y + 1, z - 1, t[x0][y][z], t[x0][y][z - 1], hs_fb);
                    updated += Time3d.t_3d_part2(x, y + 1, z - 1, t[x0][y][z], t[x0][y + 1][z], t[x0][y][z - 1], t[x0][y + 1][z - 1], hs_fb);
                }
                ++z;
            }
            ++y;
        }
        y = 0;
        while (y < ny * nz) {
            Time3d.longflags[y] = 0;
            ++y;
        }
        if (y_begin == y_end || z_begin == z_end) {
            flag_bb = 1;
            flag_bf = 1;
            flag_fb = 1;
            flag_ff = 1;
            y_start_ff = y_start_fb = y_begin;
            y_start_bf = y_start_bb = y_end;
            z_start_ff = z_start_bf = z_begin;
            z_start_fb = z_start_bb = z_end;
        }
        do {
            test = 0;
            if (flag_ff != 0) {
                ++test;
                if (messages == 2) {
                    logger.debug((Object)String.format("ff ", new Object[0]));
                }
                updated += Time3d.scan_x_ff(y_start_ff, y_end, z_start_ff, z_end, x0, x, x_s);
            }
            if (flag_fb != 0) {
                ++test;
                if (messages == 2) {
                    logger.debug((Object)String.format("fb ", new Object[0]));
                }
                updated += Time3d.scan_x_fb(y_start_fb, y_end, z_begin, z_start_fb, x0, x, x_s);
            }
            if (flag_bb != 0) {
                ++test;
                if (messages == 2) {
                    logger.debug((Object)String.format("bb ", new Object[0]));
                }
                updated += Time3d.scan_x_bb(y_begin, y_start_bb, z_begin, z_start_bb, x0, x, x_s);
            }
            if (flag_bf == 0) continue;
            ++test;
            if (messages == 2) {
                logger.debug((Object)String.format("bf ", new Object[0]));
            }
            updated += Time3d.scan_x_bf(y_begin, y_start_bf, z_start_bf, z_end, x0, x, x_s);
        } while (test != 0);
        sum_updated += updated;
        int longhead = 0;
        y = 0;
        while (y < ny * nz) {
            longhead += longflags[y];
            ++y;
        }
        if (longhead != 0) {
            ++reverse_order;
            if (messages == 2) {
                logger.debug((Object)String.format("\nReverse#%d from x_side %d", reverse_order, x));
            }
            int past = -future;
            x = x0;
            while (x != current_side_limit) {
                if (x < 0 || x >= nx) break;
                if (messages == 2) {
                    logger.debug((Object)String.format("\nupdate side x=%d: ", x));
                }
                if (Time3d.x_side(y_begin, y_end, z_begin, z_end, x, past) == 0) break;
                if (messages == 2) {
                    logger.debug((Object)String.format("x=%d <R#%d>updated.", x, reverse_order));
                }
                x += past;
            }
            if (messages == 2) {
                logger.debug((Object)String.format("\nEnd Reverse#%d\n", reverse_order));
            }
            --reverse_order;
        }
        return updated;
    }

    private static int scan_x_ff(int y_start, int y_end, int z_start, int z_end, int x0, int x, int x_s) {
        float hs_fb;
        int alert0;
        int alert1;
        float hs_bf;
        int updated = 0;
        int x_sf = x_s + x - x0;
        float hs_ube = 1.0E19f;
        float hs_ubb = 1.0E19f;
        float hs_bb = 1.0E19f;
        int y = y_start;
        int z = z_start;
        while (y < y_end) {
            hs_bf = hs[x_s][y][z];
            if (z != 0) {
                hs_bb = hs[x_s][y][z - 1];
            }
            if (x_sf >= 0 && x_sf < nmesh_x) {
                hs_ube = hs[x_sf][y][z];
                if (z != 0) {
                    hs_ubb = hs[x_sf][y][z - 1];
                }
            }
            alert1 = Time3d.t_1d(x, y + 1, z, t[x][y][z], hs_bb, hs_bf, hs_ubb, hs_ube);
            alert0 = Time3d.t_2d(x, y + 1, z, t[x0][y][z], t[x][y][z], hs_bb, hs_bf);
            updated += alert0 + alert1;
            if (alert1 != 0) {
                Time3d.longflags[y * Time3d.nz + Time3d.nz + z] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[y * Time3d.nz + Time3d.nz + z] = 0;
            }
            ++y;
        }
        float hs_ueb = 1.0E19f;
        hs_ubb = 1.0E19f;
        hs_bb = 1.0E19f;
        y = y_start;
        z = z_start;
        while (z < z_end) {
            hs_fb = hs[x_s][y][z];
            if (y != 0) {
                hs_bb = hs[x_s][y - 1][z];
            }
            if (x_sf >= 0 && x_sf < nmesh_x) {
                hs_ueb = hs[x_sf][y][z];
                if (y != 0) {
                    hs_ubb = hs[x_sf][y - 1][z];
                }
            }
            alert1 = Time3d.t_1d(x, y, z + 1, t[x][y][z], hs_bb, hs_fb, hs_ubb, hs_ueb);
            alert0 = Time3d.t_2d(x, y, z + 1, t[x0][y][z], t[x][y][z], hs_bb, hs_fb);
            updated += alert0 + alert1;
            if (alert1 != 0) {
                Time3d.longflags[y * Time3d.nz + z + 1] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[y * Time3d.nz + z + 1] = 0;
            }
            ++z;
        }
        y = y_start;
        while (y < y_end) {
            z = z_start;
            while (z < z_end) {
                hs_bb = hs[x_s][y][z];
                hs_bf = hs[x_s][y][z + 1];
                hs_fb = hs[x_s][y + 1][z];
                if (x_sf >= 0 && x_sf < nmesh_x) {
                    hs_ubb = hs[x_sf][y][z];
                    hs_ube = hs[x_sf][y][z + 1];
                    hs_ueb = hs[x_sf][y + 1][z];
                } else {
                    hs_ueb = 1.0E19f;
                    hs_ube = 1.0E19f;
                    hs_ubb = 1.0E19f;
                }
                alert0 = Time3d.edge_diff(x, y + 1, z + 1, t[x0][y][z], t[x][y][z], hs_bb) + Time3d.t_3d(x, y + 1, z + 1, t[x0][y][z], t[x0][y + 1][z], t[x][y][z], t[x][y + 1][z], hs_bb) + Time3d.t_3d(x, y + 1, z + 1, t[x0][y][z], t[x0][y][z + 1], t[x][y][z], t[x][y][z + 1], hs_bb);
                if (alert0 != 0) {
                    updated += alert0;
                    Time3d.longflags[y * Time3d.nz + Time3d.nz + z + 1] = 0;
                }
                alert1 = Time3d.t_1d(x, y + 1, z + 1, t[x][y][z + 1], hs_bb, hs_bf, hs_ubb, hs_ube);
                alert0 = Time3d.t_2d(x, y + 1, z + 1, t[x0][y][z + 1], t[x][y][z + 1], hs_bb, hs_bf);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_fb;
                    if (y_start_fb > y) {
                        y_start_fb = y;
                    }
                    if (z_start_fb < z + 1) {
                        z_start_fb = z + 1;
                    }
                    Time3d.longflags[y * Time3d.nz + Time3d.nz + z + 1] = alert1 != 0 ? 1 : 0;
                }
                alert1 = Time3d.t_1d(x, y + 1, z + 1, t[x][y + 1][z], hs_bb, hs_fb, hs_ubb, hs_ueb);
                alert0 = Time3d.t_2d(x, y + 1, z + 1, t[x0][y + 1][z], t[x][y + 1][z], hs_bb, hs_fb);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_bf;
                    if (y_start_bf < y + 1) {
                        y_start_bf = y + 1;
                    }
                    if (z_start_bf > z) {
                        z_start_bf = z;
                    }
                    Time3d.longflags[y * Time3d.nz + Time3d.nz + z + 1] = alert1 != 0 ? 1 : 0;
                }
                if ((alert1 = Time3d.diff_2d(x, y + 1, z + 1, t[x][y][z], hs_bb, hs_ubb) + Time3d.t_2d(x, y + 1, z + 1, t[x][y][z], t[x][y + 1][z], hs_bb, hs_ubb) + Time3d.t_2d(x, y + 1, z + 1, t[x][y][z], t[x][y][z + 1], hs_bb, hs_ubb)) != 0) {
                    updated += alert1;
                    Time3d.longflags[y * Time3d.nz + Time3d.nz + z + 1] = 1;
                }
                ++z;
            }
            ++y;
        }
        flag_ff = 0;
        y_start_ff = y_end;
        z_start_ff = z_end;
        return updated;
    }

    private static int scan_x_bf(int y_begin, int y_start, int z_start, int z_end, int x0, int x, int x_s) {
        int alert0;
        int alert1;
        float hs_ff;
        int updated = 0;
        int x_sf = x_s + x - x0;
        float hs_ueb = 1.0E19f;
        float hs_uee = 1.0E19f;
        float hs_fb = 1.0E19f;
        int y = y_start;
        int z = z_start;
        while (y > y_begin) {
            hs_ff = hs[x_s][y - 1][z];
            if (z != 0) {
                hs_fb = hs[x_s][y - 1][z - 1];
            }
            if (x_sf >= 0 && x_sf < nmesh_x) {
                hs_uee = hs[x_sf][y - 1][z];
                if (z != 0) {
                    hs_ueb = hs[x_sf][y - 1][z - 1];
                }
            }
            alert1 = Time3d.t_1d(x, y - 1, z, t[x][y][z], hs_fb, hs_ff, hs_ueb, hs_uee);
            alert0 = Time3d.t_2d(x, y - 1, z, t[x0][y][z], t[x][y][z], hs_fb, hs_ff);
            updated += alert0 + alert1;
            if (alert1 != 0) {
                Time3d.longflags[y * Time3d.nz - Time3d.nz + z] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[y * Time3d.nz - Time3d.nz + z] = 0;
            }
            --y;
        }
        hs_ueb = 1.0E19f;
        float hs_ubb = 1.0E19f;
        float hs_bb = 1.0E19f;
        y = y_start;
        z = z_start;
        while (z < z_end) {
            if (y != 0) {
                hs_bb = hs[x_s][y - 1][z];
            }
            hs_fb = hs[x_s][y][z];
            if (x_sf >= 0 && x_sf < nmesh_x) {
                if (y != 0) {
                    hs_ubb = hs[x_sf][y - 1][z];
                }
                hs_ueb = hs[x_sf][y][z];
            }
            alert1 = Time3d.t_1d(x, y, z + 1, t[x][y][z], hs_bb, hs_fb, hs_ubb, hs_ueb);
            alert0 = Time3d.t_2d(x, y, z + 1, t[x0][y][z], t[x][y][z], hs_bb, hs_fb);
            updated += alert0 + alert1;
            if (alert1 != 0) {
                Time3d.longflags[y * Time3d.nz + z + 1] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[y * Time3d.nz + z + 1] = 0;
            }
            ++z;
        }
        y = y_start;
        while (y > y_begin) {
            z = z_start;
            while (z < z_end) {
                hs_ff = hs[x_s][y - 1][z + 1];
                hs_bb = y > 1 ? hs[x_s][y - 2][z] : 1.0E19f;
                hs_fb = hs[x_s][y - 1][z];
                if (x_sf >= 0 && x_sf < nmesh_x) {
                    hs_uee = hs[x_sf][y - 1][z + 1];
                    hs_ubb = y > 1 ? hs[x_sf][y - 2][z] : 1.0E19f;
                    hs_ueb = hs[x_sf][y - 1][z];
                } else {
                    hs_ueb = 1.0E19f;
                    hs_uee = 1.0E19f;
                    hs_ubb = 1.0E19f;
                }
                alert0 = Time3d.edge_diff(x, y - 1, z + 1, t[x0][y][z], t[x][y][z], hs_fb) + Time3d.t_3d(x, y - 1, z + 1, t[x0][y][z], t[x0][y - 1][z], t[x][y][z], t[x][y - 1][z], hs_fb) + Time3d.t_3d(x, y - 1, z + 1, t[x0][y][z], t[x0][y][z + 1], t[x][y][z], t[x][y][z + 1], hs_fb);
                if (alert0 != 0) {
                    updated += alert0;
                    Time3d.longflags[y * Time3d.nz - Time3d.nz + z + 1] = 0;
                }
                alert1 = Time3d.t_1d(x, y - 1, z + 1, t[x][y][z + 1], hs_ff, hs_fb, hs_uee, hs_ueb);
                alert0 = Time3d.t_2d(x, y - 1, z + 1, t[x0][y][z + 1], t[x][y][z + 1], hs_ff, hs_fb);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_bb;
                    if (y_start_bb < y) {
                        y_start_bb = y;
                    }
                    if (z_start_bb < z + 1) {
                        z_start_bb = z + 1;
                    }
                    Time3d.longflags[y * Time3d.nz - Time3d.nz + z + 1] = alert1 != 0 ? 1 : 0;
                }
                alert1 = Time3d.t_1d(x, y - 1, z + 1, t[x][y - 1][z], hs_bb, hs_fb, hs_ubb, hs_ueb);
                alert0 = Time3d.t_2d(x, y - 1, z + 1, t[x0][y - 1][z], t[x][y - 1][z], hs_bb, hs_fb);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_ff;
                    if (y_start_ff > y - 1) {
                        y_start_ff = y - 1;
                    }
                    if (z_start_ff > z) {
                        z_start_ff = z;
                    }
                    Time3d.longflags[y * Time3d.nz - Time3d.nz + z + 1] = alert1 != 0 ? 1 : 0;
                }
                if ((alert1 = Time3d.diff_2d(x, y - 1, z + 1, t[x][y][z], hs_fb, hs_ueb) + Time3d.t_2d(x, y - 1, z + 1, t[x][y][z], t[x][y - 1][z], hs_fb, hs_ueb) + Time3d.t_2d(x, y - 1, z + 1, t[x][y][z], t[x][y][z + 1], hs_fb, hs_ueb)) != 0) {
                    updated += alert1;
                    Time3d.longflags[y * Time3d.nz - Time3d.nz + z + 1] = 1;
                }
                ++z;
            }
            --y;
        }
        flag_bf = 0;
        y_start_bf = y_begin;
        z_start_bf = z_end;
        return updated;
    }

    private static int scan_x_bb(int y_begin, int y_start, int z_begin, int z_start, int x0, int x, int x_s) {
        float hs_bf;
        int alert0;
        int alert1;
        float hs_fb;
        int updated = 0;
        int x_sf = x_s + x - x0;
        float hs_ueb = 1.0E19f;
        float hs_uee = 1.0E19f;
        float hs_ff = 1.0E19f;
        int y = y_start;
        int z = z_start;
        while (y > y_begin) {
            if (z != 0) {
                hs_ff = hs[x_s][y - 1][z - 1];
            }
            hs_fb = hs[x_s][y - 1][z];
            if (x_sf >= 0 && x_sf < nmesh_x) {
                if (z != 0) {
                    hs_uee = hs[x_sf][y - 1][z - 1];
                }
                hs_ueb = hs[x_sf][y - 1][z];
            }
            alert1 = Time3d.t_1d(x, y - 1, z, t[x][y][z], hs_fb, hs_ff, hs_ueb, hs_uee);
            alert0 = Time3d.t_2d(x, y - 1, z, t[x0][y][z], t[x][y][z], hs_fb, hs_ff);
            updated += alert0 + alert1;
            if (alert1 != 0) {
                Time3d.longflags[y * Time3d.nz - Time3d.nz + z] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[y * Time3d.nz - Time3d.nz + z] = 0;
            }
            --y;
        }
        float hs_ube = 1.0E19f;
        hs_uee = 1.0E19f;
        hs_ff = 1.0E19f;
        y = y_start;
        z = z_start;
        while (z > z_begin) {
            if (y != 0) {
                hs_ff = hs[x_s][y - 1][z - 1];
            }
            hs_bf = hs[x_s][y][z - 1];
            if (x_sf >= 0 && x_sf < nmesh_x) {
                if (y != 0) {
                    hs_uee = hs[x_sf][y - 1][z - 1];
                }
                hs_ube = hs[x_sf][y][z - 1];
            }
            alert1 = Time3d.t_1d(x, y, z - 1, t[x][y][z], hs_bf, hs_ff, hs_ube, hs_uee);
            alert0 = Time3d.t_2d(x, y, z - 1, t[x0][y][z], t[x][y][z], hs_bf, hs_ff);
            updated += alert0 + alert1;
            if (alert1 != 0) {
                Time3d.longflags[y * Time3d.nz + z - 1] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[y * Time3d.nz + z - 1] = 0;
            }
            --z;
        }
        y = y_start;
        while (y > y_begin) {
            z = z_start;
            while (z > z_begin) {
                hs_ff = hs[x_s][y - 1][z - 1];
                hs_bf = y > 1 ? hs[x_s][y - 2][z - 1] : 1.0E19f;
                hs_fb = z > 1 ? hs[x_s][y - 1][z - 2] : 1.0E19f;
                if (x_sf >= 0 && x_sf < nmesh_x) {
                    hs_uee = hs[x_sf][y - 1][z - 1];
                    hs_ube = y > 1 ? hs[x_sf][y - 2][z - 1] : 1.0E19f;
                    hs_ueb = z > 1 ? hs[x_sf][y - 1][z - 2] : 1.0E19f;
                } else {
                    hs_ueb = 1.0E19f;
                    hs_ube = 1.0E19f;
                    hs_uee = 1.0E19f;
                }
                alert0 = Time3d.edge_diff(x, y - 1, z - 1, t[x0][y][z], t[x][y][z], hs_ff) + Time3d.t_3d(x, y - 1, z - 1, t[x0][y][z], t[x0][y - 1][z], t[x][y][z], t[x][y - 1][z], hs_ff) + Time3d.t_3d(x, y - 1, z - 1, t[x0][y][z], t[x0][y][z - 1], t[x][y][z], t[x][y][z - 1], hs_ff);
                if (alert0 != 0) {
                    updated += alert0;
                    Time3d.longflags[y * Time3d.nz - Time3d.nz + z - 1] = 0;
                }
                alert1 = Time3d.t_1d(x, y - 1, z - 1, t[x][y][z - 1], hs_ff, hs_fb, hs_uee, hs_ueb);
                alert0 = Time3d.t_2d(x, y - 1, z - 1, t[x0][y][z - 1], t[x][y][z - 1], hs_ff, hs_fb);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_bf;
                    if (y_start_bf < y) {
                        y_start_bf = y;
                    }
                    if (z_start_bf > z - 1) {
                        z_start_bf = z - 1;
                    }
                    Time3d.longflags[y * Time3d.nz - Time3d.nz + z - 1] = alert1 != 0 ? 1 : 0;
                }
                alert1 = Time3d.t_1d(x, y - 1, z - 1, t[x][y - 1][z], hs_ff, hs_bf, hs_uee, hs_ube);
                alert0 = Time3d.t_2d(x, y - 1, z - 1, t[x0][y - 1][z], t[x][y - 1][z], hs_ff, hs_bf);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_fb;
                    if (y_start_fb > y - 1) {
                        y_start_fb = y - 1;
                    }
                    if (z_start_fb < z) {
                        z_start_fb = z;
                    }
                    Time3d.longflags[y * Time3d.nz - Time3d.nz + z - 1] = alert1 != 0 ? 1 : 0;
                }
                if ((alert1 = Time3d.diff_2d(x, y - 1, z - 1, t[x][y][z], hs_ff, hs_uee) + Time3d.t_2d(x, y - 1, z - 1, t[x][y][z], t[x][y - 1][z], hs_ff, hs_uee) + Time3d.t_2d(x, y - 1, z - 1, t[x][y][z], t[x][y][z - 1], hs_ff, hs_uee)) != 0) {
                    updated += alert1;
                    Time3d.longflags[y * Time3d.nz - Time3d.nz + z - 1] = 1;
                }
                --z;
            }
            --y;
        }
        flag_bb = 0;
        y_start_bb = y_begin;
        z_start_bb = z_begin;
        return updated;
    }

    private static int scan_x_fb(int y_start, int y_end, int z_begin, int z_start, int x0, int x, int x_s) {
        int alert0;
        int alert1;
        float hs_bb;
        int updated = 0;
        int x_sf = x_s + x - x0;
        float hs_ube = 1.0E19f;
        float hs_ubb = 1.0E19f;
        float hs_bf = 1.0E19f;
        int y = y_start;
        int z = z_start;
        while (y < y_end) {
            if (z != 0) {
                hs_bf = hs[x_s][y][z - 1];
            }
            hs_bb = hs[x_s][y][z];
            if (x_sf >= 0 && x_sf < nmesh_x) {
                if (z != 0) {
                    hs_ube = hs[x_sf][y][z - 1];
                }
                hs_ubb = hs[x_sf][y][z];
            }
            alert1 = Time3d.t_1d(x, y + 1, z, t[x][y][z], hs_bf, hs_bb, hs_ube, hs_ubb);
            alert0 = Time3d.t_2d(x, y + 1, z, t[x0][y][z], t[x][y][z], hs_bf, hs_bb);
            updated += alert0 + alert1;
            if (alert1 != 0) {
                Time3d.longflags[y * Time3d.nz + Time3d.nz + z] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[y * Time3d.nz + Time3d.nz + z] = 0;
            }
            ++y;
        }
        hs_ube = 1.0E19f;
        float hs_uee = 1.0E19f;
        float hs_ff = 1.0E19f;
        y = y_start;
        z = z_start;
        while (z > z_begin) {
            if (y != 0) {
                hs_ff = hs[x_s][y - 1][z - 1];
            }
            hs_bf = hs[x_s][y][z - 1];
            if (x_sf >= 0 && x_sf < nmesh_x) {
                if (y != 0) {
                    hs_uee = hs[x_sf][y - 1][z - 1];
                }
                hs_ube = hs[x_sf][y][z - 1];
            }
            alert1 = Time3d.t_1d(x, y, z - 1, t[x][y][z], hs_bf, hs_ff, hs_ube, hs_uee);
            alert0 = Time3d.t_2d(x, y, z - 1, t[x0][y][z], t[x][y][z], hs_bf, hs_ff);
            updated += alert0 + alert1;
            if (alert1 != 0) {
                Time3d.longflags[y * Time3d.nz + z - 1] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[y * Time3d.nz + z - 1] = 0;
            }
            --z;
        }
        y = y_start;
        while (y < y_end) {
            z = z_start;
            while (z > z_begin) {
                hs_bf = hs[x_s][y][z - 1];
                hs_bb = z > 1 ? hs[x_s][y][z - 2] : 1.0E19f;
                hs_ff = hs[x_s][y + 1][z - 1];
                if (x_sf >= 0 && x_sf < nmesh_x) {
                    hs_ube = hs[x_sf][y][z - 1];
                    hs_ubb = z > 1 ? hs[x_sf][y][z - 2] : 1.0E19f;
                    hs_uee = hs[x_sf][y + 1][z - 1];
                } else {
                    hs_uee = 1.0E19f;
                    hs_ube = 1.0E19f;
                    hs_ubb = 1.0E19f;
                }
                alert0 = Time3d.edge_diff(x, y + 1, z - 1, t[x0][y][z], t[x][y][z], hs_bf) + Time3d.t_3d(x, y + 1, z - 1, t[x0][y][z], t[x0][y + 1][z], t[x][y][z], t[x][y + 1][z], hs_bf) + Time3d.t_3d(x, y + 1, z - 1, t[x0][y][z], t[x0][y][z - 1], t[x][y][z], t[x][y][z - 1], hs_bf);
                if (alert0 != 0) {
                    updated += alert0;
                    Time3d.longflags[y * Time3d.nz + Time3d.nz + z - 1] = 0;
                }
                alert1 = Time3d.t_1d(x, y + 1, z - 1, t[x][y][z - 1], hs_bb, hs_bf, hs_ubb, hs_ube);
                alert0 = Time3d.t_2d(x, y + 1, z - 1, t[x0][y][z - 1], t[x][y][z - 1], hs_bb, hs_bf);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_ff;
                    if (y_start_ff > y) {
                        y_start_ff = y;
                    }
                    if (z_start_ff > z - 1) {
                        z_start_ff = z - 1;
                    }
                    Time3d.longflags[y * Time3d.nz + Time3d.nz + z - 1] = alert1 != 0 ? 1 : 0;
                }
                alert1 = Time3d.t_1d(x, y + 1, z - 1, t[x][y + 1][z], hs_ff, hs_bf, hs_uee, hs_ube);
                alert0 = Time3d.t_2d(x, y + 1, z - 1, t[x0][y + 1][z], t[x][y + 1][z], hs_ff, hs_bf);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_bb;
                    if (y_start_bb < y + 1) {
                        y_start_bb = y + 1;
                    }
                    if (z_start_bb < z) {
                        z_start_bb = z;
                    }
                    Time3d.longflags[y * Time3d.nz + Time3d.nz + z - 1] = alert1 != 0 ? 1 : 0;
                }
                if ((alert1 = Time3d.diff_2d(x, y + 1, z - 1, t[x][y][z], hs_bf, hs_ube) + Time3d.t_2d(x, y + 1, z - 1, t[x][y][z], t[x][y + 1][z], hs_bf, hs_ube) + Time3d.t_2d(x, y + 1, z - 1, t[x][y][z], t[x][y][z - 1], hs_bf, hs_ube)) != 0) {
                    ++updated;
                    Time3d.longflags[y * Time3d.nz + Time3d.nz + z - 1] = 1;
                }
                --z;
            }
            ++y;
        }
        flag_fb = 0;
        y_start_fb = y_end;
        z_start_fb = z_begin;
        return updated;
    }

    private static int y_side(int x_begin, int x_end, int z_begin, int z_end, int y, int future) {
        int test;
        if (reverse_order == 0) {
            current_side_limit = y + future;
        }
        int updated = 0;
        int y0 = y - future;
        int y_s = future == 1 ? y0 : y;
        flag_bb = 0;
        flag_ff = 0;
        flag_bf = 0;
        flag_fb = 0;
        x_start_ff = x_start_fb = x_end;
        x_start_bf = x_start_bb = x_begin;
        z_start_ff = z_start_bf = z_end;
        z_start_fb = z_start_bb = z_begin;
        int x = x_begin;
        while (x <= x_end) {
            int z = z_begin;
            while (z <= z_end) {
                float hs_ff = hs[x][y_s][z];
                float hs_bf = x > 0 ? hs[x - 1][y_s][z] : 1.0E19f;
                float hs_bb = x > 0 && z > 0 ? hs[x - 1][y_s][z - 1] : 1.0E19f;
                float hs_fb = z > 0 ? hs[x][y_s][z - 1] : 1.0E19f;
                int sign_fb = 0;
                int sign_bb = 0;
                int sign_bf = 0;
                int sign_ff = 0;
                updated += Time3d.t_1d(x, y, z, t[x][y0][z], hs_ff, hs_bf, hs_bb, hs_fb);
                if (x < x_end && z < z_end) {
                    updated += Time3d.t_3d_part1(x, y, z, t[x][y0][z], t[x + 1][y0][z], t[x][y0][z + 1], hs_ff);
                }
                if (x > x_begin && z < z_end) {
                    updated += Time3d.t_3d_part1(x, y, z, t[x][y0][z], t[x - 1][y0][z], t[x][y0][z + 1], hs_bf);
                }
                if (x > x_begin && z > z_begin) {
                    updated += Time3d.t_3d_part1(x, y, z, t[x][y0][z], t[x - 1][y0][z], t[x][y0][z - 1], hs_bb);
                }
                if (x < x_end && z > z_begin) {
                    updated += Time3d.t_3d_part1(x, y, z, t[x][y0][z], t[x + 1][y0][z], t[x][y0][z - 1], hs_fb);
                }
                if (x < x_end && t[x][y0][z] <= t[x + 1][y0][z]) {
                    ++sign_fb;
                    ++sign_ff;
                    if (x < x_start_ff) {
                        x_start_ff = x;
                    }
                    if (x < x_start_fb) {
                        x_start_fb = x;
                    }
                    updated += Time3d.diff_2d(x + 1, y, z, t[x][y0][z], hs_ff, hs_fb);
                    updated += Time3d.t_2d(x + 1, y, z, t[x][y0][z], t[x + 1][y0][z], hs_ff, hs_fb);
                }
                if (x > x_begin && t[x][y0][z] <= t[x - 1][y0][z]) {
                    ++sign_bb;
                    ++sign_bf;
                    if (x > x_start_bf) {
                        x_start_bf = x;
                    }
                    if (x > x_start_bb) {
                        x_start_bb = x;
                    }
                    updated += Time3d.diff_2d(x - 1, y, z, t[x][y0][z], hs_bf, hs_bb);
                    updated += Time3d.t_2d(x - 1, y, z, t[x][y0][z], t[x - 1][y0][z], hs_bf, hs_bb);
                }
                if (z < z_end && t[x][y0][z] <= t[x][y0][z + 1]) {
                    ++sign_bf;
                    ++sign_ff;
                    if (z < z_start_ff) {
                        z_start_ff = z;
                    }
                    if (z < z_start_bf) {
                        z_start_bf = z;
                    }
                    updated += Time3d.diff_2d(x, y, z + 1, t[x][y0][z], hs_ff, hs_bf);
                    updated += Time3d.t_2d(x, y, z + 1, t[x][y0][z], t[x][y0][z + 1], hs_ff, hs_bf);
                }
                if (z > z_begin && t[x][y0][z] <= t[x][y0][z - 1]) {
                    ++sign_bb;
                    ++sign_fb;
                    if (z > z_start_fb) {
                        z_start_fb = z;
                    }
                    if (z > z_start_bb) {
                        z_start_bb = z;
                    }
                    updated += Time3d.diff_2d(x, y, z - 1, t[x][y0][z], hs_bb, hs_fb);
                    updated += Time3d.t_2d(x, y, z - 1, t[x][y0][z], t[x][y0][z - 1], hs_bb, hs_fb);
                }
                if (sign_ff == 2) {
                    flag_ff = 1;
                    updated += Time3d.point_diff(x + 1, y, z + 1, t[x][y0][z], hs_ff) + Time3d.edge_diff(x + 1, y, z + 1, t[x][y0][z], t[x + 1][y0][z], hs_ff) + Time3d.edge_diff(x + 1, y, z + 1, t[x][y0][z], t[x][y0][z + 1], hs_ff) + Time3d.t_3d_part2(x + 1, y, z + 1, t[x][y0][z], t[x + 1][y0][z], t[x][y0][z + 1], t[x + 1][y0][z + 1], hs_ff);
                }
                if (sign_bf == 2) {
                    flag_bf = 1;
                    updated += Time3d.point_diff(x - 1, y, z + 1, t[x][y0][z], hs_bf) + Time3d.edge_diff(x - 1, y, z + 1, t[x][y0][z], t[x - 1][y0][z], hs_bf) + Time3d.edge_diff(x - 1, y, z + 1, t[x][y0][z], t[x][y0][z + 1], hs_bf) + Time3d.t_3d_part2(x - 1, y, z + 1, t[x][y0][z], t[x - 1][y0][z], t[x][y0][z + 1], t[x - 1][y0][z + 1], hs_bf);
                }
                if (sign_bb == 2) {
                    flag_bb = 1;
                    updated += Time3d.point_diff(x - 1, y, z - 1, t[x][y0][z], hs_bb) + Time3d.edge_diff(x - 1, y, z - 1, t[x][y0][z], t[x - 1][y0][z], hs_bb) + Time3d.edge_diff(x - 1, y, z - 1, t[x][y0][z], t[x][y0][z - 1], hs_bb) + Time3d.t_3d_part2(x - 1, y, z - 1, t[x][y0][z], t[x - 1][y0][z], t[x][y0][z - 1], t[x - 1][y0][z - 1], hs_bb);
                }
                if (sign_fb == 2) {
                    flag_fb = 1;
                    updated += Time3d.point_diff(x + 1, y, z - 1, t[x][y0][z], hs_fb) + Time3d.edge_diff(x + 1, y, z - 1, t[x][y0][z], t[x + 1][y0][z], hs_fb) + Time3d.edge_diff(x + 1, y, z - 1, t[x][y0][z], t[x][y0][z - 1], hs_fb) + Time3d.t_3d_part2(x + 1, y, z - 1, t[x][y0][z], t[x + 1][y0][z], t[x][y0][z - 1], t[x + 1][y0][z - 1], hs_fb);
                }
                ++z;
            }
            ++x;
        }
        x = 0;
        while (x < nx * nz) {
            Time3d.longflags[x] = 0;
            ++x;
        }
        if (x_begin == x_end || z_begin == z_end) {
            flag_bb = 1;
            flag_bf = 1;
            flag_fb = 1;
            flag_ff = 1;
            x_start_ff = x_start_fb = x_begin;
            x_start_bf = x_start_bb = x_end;
            z_start_ff = z_start_bf = z_begin;
            z_start_fb = z_start_bb = z_end;
        }
        do {
            test = 0;
            if (flag_ff != 0) {
                ++test;
                if (messages == 2) {
                    logger.debug((Object)String.format("ff ", new Object[0]));
                }
                updated += Time3d.scan_y_ff(x_start_ff, x_end, z_start_ff, z_end, y0, y, y_s);
            }
            if (flag_fb != 0) {
                ++test;
                if (messages == 2) {
                    logger.debug((Object)String.format("fb ", new Object[0]));
                }
                updated += Time3d.scan_y_fb(x_start_fb, x_end, z_begin, z_start_fb, y0, y, y_s);
            }
            if (flag_bb != 0) {
                ++test;
                if (messages == 2) {
                    logger.debug((Object)String.format("bb ", new Object[0]));
                }
                updated += Time3d.scan_y_bb(x_begin, x_start_bb, z_begin, z_start_bb, y0, y, y_s);
            }
            if (flag_bf == 0) continue;
            ++test;
            if (messages == 2) {
                logger.debug((Object)String.format("bf ", new Object[0]));
            }
            updated += Time3d.scan_y_bf(x_begin, x_start_bf, z_start_bf, z_end, y0, y, y_s);
        } while (test != 0);
        sum_updated += updated;
        int longhead = 0;
        x = 0;
        while (x < nx * nz) {
            longhead += longflags[x];
            ++x;
        }
        if (longhead != 0) {
            ++reverse_order;
            if (messages == 2) {
                logger.debug((Object)String.format("\nReverse#%d from y_side %d", reverse_order, y));
            }
            int past = -future;
            y = y0;
            while (y != current_side_limit) {
                if (y < 0 || y >= ny) break;
                if (messages == 2) {
                    logger.debug((Object)String.format("\nupdate side y=%d: ", y));
                }
                if (Time3d.y_side(x_begin, x_end, z_begin, z_end, y, past) == 0) break;
                if (messages == 2) {
                    logger.debug((Object)String.format("y=%d <R#%d>updated.", y, reverse_order));
                }
                y += past;
            }
            if (messages == 2) {
                logger.debug((Object)String.format("\nEnd Reverse#%d\n", reverse_order));
            }
            --reverse_order;
        }
        return updated;
    }

    private static int scan_y_ff(int x_start, int x_end, int z_start, int z_end, int y0, int y, int y_s) {
        float hs_fb;
        int alert0;
        int alert1;
        float hs_bf;
        int updated = 0;
        int y_sf = y_s + y - y0;
        float hs_ube = 1.0E19f;
        float hs_ubb = 1.0E19f;
        float hs_bb = 1.0E19f;
        int x = x_start;
        int z = z_start;
        while (x < x_end) {
            hs_bf = hs[x][y_s][z];
            if (z != 0) {
                hs_bb = hs[x][y_s][z - 1];
            }
            if (y_sf >= 0 && y_sf < nmesh_y) {
                hs_ube = hs[x][y_sf][z];
                if (z != 0) {
                    hs_ubb = hs[x][y_sf][z - 1];
                }
            }
            alert1 = Time3d.t_1d(x + 1, y, z, t[x][y][z], hs_bb, hs_bf, hs_ubb, hs_ube);
            alert0 = Time3d.t_2d(x + 1, y, z, t[x][y0][z], t[x][y][z], hs_bb, hs_bf);
            updated += alert0 + alert1;
            if (alert1 != 0) {
                Time3d.longflags[x * Time3d.nz + Time3d.nz + z] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[x * Time3d.nz + Time3d.nz + z] = 0;
            }
            ++x;
        }
        float hs_ueb = 1.0E19f;
        hs_ubb = 1.0E19f;
        hs_bb = 1.0E19f;
        x = x_start;
        z = z_start;
        while (z < z_end) {
            hs_fb = hs[x][y_s][z];
            if (x != 0) {
                hs_bb = hs[x - 1][y_s][z];
            }
            if (y_sf >= 0 && y_sf < nmesh_y) {
                hs_ueb = hs[x][y_sf][z];
                if (x != 0) {
                    hs_ubb = hs[x - 1][y_sf][z];
                }
            }
            alert1 = Time3d.t_1d(x, y, z + 1, t[x][y][z], hs_bb, hs_fb, hs_ubb, hs_ueb);
            alert0 = Time3d.t_2d(x, y, z + 1, t[x][y0][z], t[x][y][z], hs_bb, hs_fb);
            updated += alert0 + alert1;
            if (alert1 != 0) {
                Time3d.longflags[x * Time3d.nz + z + 1] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[x * Time3d.nz + z + 1] = 0;
            }
            ++z;
        }
        x = x_start;
        while (x < x_end) {
            z = z_start;
            while (z < z_end) {
                hs_bb = hs[x][y_s][z];
                hs_bf = hs[x][y_s][z + 1];
                hs_fb = hs[x + 1][y_s][z];
                if (y_sf >= 0 && y_sf < nmesh_y) {
                    hs_ubb = hs[x][y_sf][z];
                    hs_ube = hs[x][y_sf][z + 1];
                    hs_ueb = hs[x + 1][y_sf][z];
                } else {
                    hs_ueb = 1.0E19f;
                    hs_ube = 1.0E19f;
                    hs_ubb = 1.0E19f;
                }
                alert0 = Time3d.edge_diff(x + 1, y, z + 1, t[x][y0][z], t[x][y][z], hs_bb) + Time3d.t_3d(x + 1, y, z + 1, t[x][y0][z], t[x + 1][y0][z], t[x][y][z], t[x + 1][y][z], hs_bb) + Time3d.t_3d(x + 1, y, z + 1, t[x][y0][z], t[x][y0][z + 1], t[x][y][z], t[x][y][z + 1], hs_bb);
                if (alert0 != 0) {
                    ++updated;
                    Time3d.longflags[x * Time3d.nz + Time3d.nz + z + 1] = 0;
                }
                alert1 = Time3d.t_1d(x + 1, y, z + 1, t[x][y][z + 1], hs_bb, hs_bf, hs_ubb, hs_ube);
                alert0 = Time3d.t_2d(x + 1, y, z + 1, t[x][y0][z + 1], t[x][y][z + 1], hs_bb, hs_bf);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_fb;
                    if (x_start_fb > x) {
                        x_start_fb = x;
                    }
                    if (z_start_fb < z + 1) {
                        z_start_fb = z + 1;
                    }
                    Time3d.longflags[x * Time3d.nz + Time3d.nz + z + 1] = alert1 != 0 ? 1 : 0;
                }
                alert1 = Time3d.t_1d(x + 1, y, z + 1, t[x + 1][y][z], hs_bb, hs_fb, hs_ubb, hs_ueb);
                alert0 = Time3d.t_2d(x + 1, y, z + 1, t[x + 1][y0][z], t[x + 1][y][z], hs_bb, hs_fb);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_bf;
                    if (x_start_bf < x + 1) {
                        x_start_bf = x + 1;
                    }
                    if (z_start_bf > z) {
                        z_start_bf = z;
                    }
                    Time3d.longflags[x * Time3d.nz + Time3d.nz + z + 1] = alert1 != 0 ? 1 : 0;
                }
                if ((alert1 = Time3d.diff_2d(x + 1, y, z + 1, t[x][y][z], hs_bb, hs_ubb) + Time3d.t_2d(x + 1, y, z + 1, t[x][y][z], t[x + 1][y][z], hs_bb, hs_ubb) + Time3d.t_2d(x + 1, y, z + 1, t[x][y][z], t[x][y][z + 1], hs_bb, hs_ubb)) != 0) {
                    updated += alert1;
                    Time3d.longflags[x * Time3d.nz + Time3d.nz + z + 1] = 1;
                }
                ++z;
            }
            ++x;
        }
        flag_ff = 0;
        x_start_ff = x_end;
        z_start_ff = z_end;
        return updated;
    }

    private static int scan_y_bf(int x_begin, int x_start, int z_start, int z_end, int y0, int y, int y_s) {
        int alert0;
        int alert1;
        float hs_ff;
        int updated = 0;
        int y_sf = y_s + y - y0;
        float hs_ueb = 1.0E19f;
        float hs_uee = 1.0E19f;
        float hs_fb = 1.0E19f;
        int x = x_start;
        int z = z_start;
        while (x > x_begin) {
            hs_ff = hs[x - 1][y_s][z];
            if (z != 0) {
                hs_fb = hs[x - 1][y_s][z - 1];
            }
            if (y_sf >= 0 && y_sf < nmesh_y) {
                hs_uee = hs[x - 1][y_sf][z];
                if (z != 0) {
                    hs_ueb = hs[x - 1][y_sf][z - 1];
                }
            }
            alert1 = Time3d.t_1d(x - 1, y, z, t[x][y][z], hs_fb, hs_ff, hs_ueb, hs_uee);
            alert0 = Time3d.t_2d(x - 1, y, z, t[x][y0][z], t[x][y][z], hs_fb, hs_ff);
            updated += alert0 + alert1;
            if (alert1 != 0) {
                Time3d.longflags[x * Time3d.nz - Time3d.nz + z] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[x * Time3d.nz - Time3d.nz + z] = 0;
            }
            --x;
        }
        hs_ueb = 1.0E19f;
        float hs_ubb = 1.0E19f;
        float hs_bb = 1.0E19f;
        x = x_start;
        z = z_start;
        while (z < z_end) {
            if (x != 0) {
                hs_bb = hs[x - 1][y_s][z];
            }
            hs_fb = hs[x][y_s][z];
            if (y_sf >= 0 && y_sf < nmesh_y) {
                if (x != 0) {
                    hs_ubb = hs[x - 1][y_sf][z];
                }
                hs_ueb = hs[x][y_sf][z];
            }
            alert1 = Time3d.t_1d(x, y, z + 1, t[x][y][z], hs_bb, hs_fb, hs_ubb, hs_ueb);
            alert0 = Time3d.t_2d(x, y, z + 1, t[x][y0][z], t[x][y][z], hs_bb, hs_fb);
            updated += alert0 + alert1;
            if (alert1 != 0) {
                Time3d.longflags[x * Time3d.nz + z + 1] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[x * Time3d.nz + z + 1] = 0;
            }
            ++z;
        }
        x = x_start;
        while (x > x_begin) {
            z = z_start;
            while (z < z_end) {
                hs_ff = hs[x - 1][y_s][z + 1];
                hs_bb = x > 1 ? hs[x - 2][y_s][z] : 1.0E19f;
                hs_fb = hs[x - 1][y_s][z];
                if (y_sf >= 0 && y_sf < nmesh_y) {
                    hs_uee = hs[x - 1][y_sf][z + 1];
                    hs_ubb = x > 1 ? hs[x - 2][y_sf][z] : 1.0E19f;
                    hs_ueb = hs[x - 1][y_sf][z];
                } else {
                    hs_ueb = 1.0E19f;
                    hs_uee = 1.0E19f;
                    hs_ubb = 1.0E19f;
                }
                alert0 = Time3d.edge_diff(x - 1, y, z + 1, t[x][y0][z], t[x][y][z], hs_fb) + Time3d.t_3d(x - 1, y, z + 1, t[x][y0][z], t[x - 1][y0][z], t[x][y][z], t[x - 1][y][z], hs_fb) + Time3d.t_3d(x - 1, y, z + 1, t[x][y0][z], t[x][y0][z + 1], t[x][y][z], t[x][y][z + 1], hs_fb);
                if (alert0 != 0) {
                    updated += alert0;
                    Time3d.longflags[x * Time3d.nz - Time3d.nz + z + 1] = 0;
                }
                alert1 = Time3d.t_1d(x - 1, y, z + 1, t[x][y][z + 1], hs_ff, hs_fb, hs_uee, hs_ueb);
                alert0 = Time3d.t_2d(x - 1, y, z + 1, t[x][y0][z + 1], t[x][y][z + 1], hs_ff, hs_fb);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_bb;
                    if (x_start_bb < x) {
                        x_start_bb = x;
                    }
                    if (z_start_bb < z + 1) {
                        z_start_bb = z + 1;
                    }
                    Time3d.longflags[x * Time3d.nz - Time3d.nz + z + 1] = alert1 != 0 ? 1 : 0;
                }
                alert1 = Time3d.t_1d(x - 1, y, z + 1, t[x - 1][y][z], hs_bb, hs_fb, hs_ubb, hs_ueb);
                alert0 = Time3d.t_2d(x - 1, y, z + 1, t[x - 1][y0][z], t[x - 1][y][z], hs_bb, hs_fb);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_ff;
                    if (x_start_ff > x - 1) {
                        x_start_ff = x - 1;
                    }
                    if (z_start_ff > z) {
                        z_start_ff = z;
                    }
                    Time3d.longflags[x * Time3d.nz - Time3d.nz + z + 1] = alert1 != 0 ? 1 : 0;
                }
                if ((alert1 = Time3d.diff_2d(x - 1, y, z + 1, t[x][y][z], hs_fb, hs_ueb) + Time3d.t_2d(x - 1, y, z + 1, t[x][y][z], t[x - 1][y][z], hs_fb, hs_ueb) + Time3d.t_2d(x - 1, y, z + 1, t[x][y][z], t[x][y][z + 1], hs_fb, hs_ueb)) != 0) {
                    updated += alert1;
                    Time3d.longflags[x * Time3d.nz - Time3d.nz + z + 1] = 1;
                }
                ++z;
            }
            --x;
        }
        flag_bf = 0;
        x_start_bf = x_begin;
        z_start_bf = z_end;
        return updated;
    }

    private static int scan_y_bb(int x_begin, int x_start, int z_begin, int z_start, int y0, int y, int y_s) {
        float hs_bf;
        int alert0;
        int alert1;
        float hs_fb;
        int updated = 0;
        int y_sf = y_s + y - y0;
        float hs_ueb = 1.0E19f;
        float hs_uee = 1.0E19f;
        float hs_ff = 1.0E19f;
        int x = x_start;
        int z = z_start;
        while (x > x_begin) {
            if (z != 0) {
                hs_ff = hs[x - 1][y_s][z - 1];
            }
            hs_fb = hs[x - 1][y_s][z];
            if (y_sf >= 0 && y_sf < nmesh_y) {
                if (z != 0) {
                    hs_uee = hs[x - 1][y_sf][z - 1];
                }
                hs_ueb = hs[x - 1][y_sf][z];
            }
            alert1 = Time3d.t_1d(x - 1, y, z, t[x][y][z], hs_fb, hs_ff, hs_ueb, hs_uee);
            alert0 = Time3d.t_2d(x - 1, y, z, t[x][y0][z], t[x][y][z], hs_fb, hs_ff);
            updated += alert0 + alert1;
            if (alert1 != 0) {
                Time3d.longflags[x * Time3d.nz - Time3d.nz + z] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[x * Time3d.nz - Time3d.nz + z] = 0;
            }
            --x;
        }
        float hs_ube = 1.0E19f;
        hs_uee = 1.0E19f;
        hs_ff = 1.0E19f;
        x = x_start;
        z = z_start;
        while (z > z_begin) {
            if (x != 0) {
                hs_ff = hs[x - 1][y_s][z - 1];
            }
            hs_bf = hs[x][y_s][z - 1];
            if (y_sf >= 0 && y_sf < nmesh_y) {
                if (x != 0) {
                    hs_uee = hs[x - 1][y_sf][z - 1];
                }
                hs_ube = hs[x][y_sf][z - 1];
            }
            alert1 = Time3d.t_1d(x, y, z - 1, t[x][y][z], hs_bf, hs_ff, hs_ube, hs_uee);
            alert0 = Time3d.t_2d(x, y, z - 1, t[x][y0][z], t[x][y][z], hs_bf, hs_ff);
            updated += alert0 + alert1;
            if (alert1 != 0) {
                Time3d.longflags[x * Time3d.nz + z - 1] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[x * Time3d.nz + z - 1] = 0;
            }
            --z;
        }
        x = x_start;
        while (x > x_begin) {
            z = z_start;
            while (z > z_begin) {
                hs_ff = hs[x - 1][y_s][z - 1];
                hs_bf = x > 1 ? hs[x - 2][y_s][z - 1] : 1.0E19f;
                hs_fb = z > 1 ? hs[x - 1][y_s][z - 2] : 1.0E19f;
                if (y_sf >= 0 && y_sf < nmesh_y) {
                    hs_uee = hs[x - 1][y_sf][z - 1];
                    hs_ube = x > 1 ? hs[x - 2][y_sf][z - 1] : 1.0E19f;
                    hs_ueb = z > 1 ? hs[x - 1][y_sf][z - 2] : 1.0E19f;
                } else {
                    hs_ueb = 1.0E19f;
                    hs_ube = 1.0E19f;
                    hs_uee = 1.0E19f;
                }
                alert0 = Time3d.edge_diff(x - 1, y, z - 1, t[x][y0][z], t[x][y][z], hs_ff) + Time3d.t_3d(x - 1, y, z - 1, t[x][y0][z], t[x - 1][y0][z], t[x][y][z], t[x - 1][y][z], hs_ff) + Time3d.t_3d(x - 1, y, z - 1, t[x][y0][z], t[x][y0][z - 1], t[x][y][z], t[x][y][z - 1], hs_ff);
                if (alert0 != 0) {
                    updated += alert0;
                    Time3d.longflags[x * Time3d.nz - Time3d.nz + z - 1] = 0;
                }
                alert1 = Time3d.t_1d(x - 1, y, z - 1, t[x][y][z - 1], hs_ff, hs_fb, hs_uee, hs_ueb);
                alert0 = Time3d.t_2d(x - 1, y, z - 1, t[x][y0][z - 1], t[x][y][z - 1], hs_ff, hs_fb);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_bf;
                    if (x_start_bf < x) {
                        x_start_bf = x;
                    }
                    if (z_start_bf > z - 1) {
                        z_start_bf = z - 1;
                    }
                    Time3d.longflags[x * Time3d.nz - Time3d.nz + z - 1] = alert1 != 0 ? 1 : 0;
                }
                alert1 = Time3d.t_1d(x - 1, y, z - 1, t[x - 1][y][z], hs_ff, hs_bf, hs_uee, hs_ube);
                alert0 = Time3d.t_2d(x - 1, y, z - 1, t[x - 1][y0][z], t[x - 1][y][z], hs_ff, hs_bf);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_fb;
                    if (x_start_fb > x - 1) {
                        x_start_fb = x - 1;
                    }
                    if (z_start_fb < z) {
                        z_start_fb = z;
                    }
                    Time3d.longflags[x * Time3d.nz - Time3d.nz + z - 1] = alert1 != 0 ? 1 : 0;
                }
                if ((alert1 = Time3d.diff_2d(x - 1, y, z - 1, t[x][y][z], hs_ff, hs_uee) + Time3d.t_2d(x - 1, y, z - 1, t[x][y][z], t[x - 1][y][z], hs_ff, hs_uee) + Time3d.t_2d(x - 1, y, z - 1, t[x][y][z], t[x][y][z - 1], hs_ff, hs_uee)) != 0) {
                    updated += alert1;
                    Time3d.longflags[x * Time3d.nz - Time3d.nz + z - 1] = 1;
                }
                --z;
            }
            --x;
        }
        flag_bb = 0;
        x_start_bb = x_begin;
        z_start_bb = z_begin;
        return updated;
    }

    private static int scan_y_fb(int x_start, int x_end, int z_begin, int z_start, int y0, int y, int y_s) {
        int alert0;
        int alert1;
        float hs_bb;
        int updated = 0;
        int y_sf = y_s + y - y0;
        float hs_ube = 1.0E19f;
        float hs_ubb = 1.0E19f;
        float hs_bf = 1.0E19f;
        int x = x_start;
        int z = z_start;
        while (x < x_end) {
            if (z != 0) {
                hs_bf = hs[x][y_s][z - 1];
            }
            hs_bb = hs[x][y_s][z];
            if (y_sf >= 0 && y_sf < nmesh_y) {
                if (z != 0) {
                    hs_ube = hs[x][y_sf][z - 1];
                }
                hs_ubb = hs[x][y_sf][z];
            }
            alert1 = Time3d.t_1d(x + 1, y, z, t[x][y][z], hs_bf, hs_bb, hs_ube, hs_ubb);
            alert0 = Time3d.t_2d(x + 1, y, z, t[x][y0][z], t[x][y][z], hs_bf, hs_bb);
            updated += alert0 + alert1;
            if (alert1 != 0) {
                Time3d.longflags[x * Time3d.nz + Time3d.nz + z] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[x * Time3d.nz + Time3d.nz + z] = 0;
            }
            ++x;
        }
        hs_ube = 1.0E19f;
        float hs_uee = 1.0E19f;
        float hs_ff = 1.0E19f;
        x = x_start;
        z = z_start;
        while (z > z_begin) {
            if (x != 0) {
                hs_ff = hs[x - 1][y_s][z - 1];
            }
            hs_bf = hs[x][y_s][z - 1];
            if (y_sf >= 0 && y_sf < nmesh_y) {
                if (x != 0) {
                    hs_uee = hs[x - 1][y_sf][z - 1];
                }
                hs_ube = hs[x][y_sf][z - 1];
            }
            alert1 = Time3d.t_1d(x, y, z - 1, t[x][y][z], hs_bf, hs_ff, hs_ube, hs_uee);
            alert0 = Time3d.t_2d(x, y, z - 1, t[x][y0][z], t[x][y][z], hs_bf, hs_ff);
            updated += alert0 + alert1;
            if (alert1 != 0) {
                Time3d.longflags[x * Time3d.nz + z - 1] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[x * Time3d.nz + z - 1] = 0;
            }
            --z;
        }
        x = x_start;
        while (x < x_end) {
            z = z_start;
            while (z > z_begin) {
                hs_bf = hs[x][y_s][z - 1];
                hs_bb = z > 1 ? hs[x][y_s][z - 2] : 1.0E19f;
                hs_ff = hs[x + 1][y_s][z - 1];
                if (y_sf >= 0 && y_sf < nmesh_y) {
                    hs_ube = hs[x][y_sf][z - 1];
                    hs_ubb = z > 1 ? hs[x][y_sf][z - 2] : 1.0E19f;
                    hs_uee = hs[x + 1][y_sf][z - 1];
                } else {
                    hs_uee = 1.0E19f;
                    hs_ube = 1.0E19f;
                    hs_ubb = 1.0E19f;
                }
                alert0 = Time3d.edge_diff(x + 1, y, z - 1, t[x][y0][z], t[x][y][z], hs_bf) + Time3d.t_3d(x + 1, y, z - 1, t[x][y0][z], t[x + 1][y0][z], t[x][y][z], t[x + 1][y][z], hs_bf) + Time3d.t_3d(x + 1, y, z - 1, t[x][y0][z], t[x][y0][z - 1], t[x][y][z], t[x][y][z - 1], hs_bf);
                if (alert0 != 0) {
                    updated += alert0;
                    Time3d.longflags[x * Time3d.nz + Time3d.nz + z - 1] = 0;
                }
                alert1 = Time3d.t_1d(x + 1, y, z - 1, t[x][y][z - 1], hs_bb, hs_bf, hs_ubb, hs_ube);
                alert0 = Time3d.t_2d(x + 1, y, z - 1, t[x][y0][z - 1], t[x][y][z - 1], hs_bb, hs_bf);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_ff;
                    if (x_start_ff > x) {
                        x_start_ff = x;
                    }
                    if (z_start_ff > z - 1) {
                        z_start_ff = z - 1;
                    }
                    Time3d.longflags[x * Time3d.nz + Time3d.nz + z - 1] = alert1 != 0 ? 1 : 0;
                }
                alert1 = Time3d.t_1d(x + 1, y, z - 1, t[x + 1][y][z], hs_ff, hs_bf, hs_uee, hs_ube);
                alert0 = Time3d.t_2d(x + 1, y, z - 1, t[x + 1][y0][z], t[x + 1][y][z], hs_ff, hs_bf);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_bb;
                    if (x_start_bb < x + 1) {
                        x_start_bb = x + 1;
                    }
                    if (z_start_bb < z) {
                        z_start_bb = z;
                    }
                    Time3d.longflags[x * Time3d.nz + Time3d.nz + z - 1] = alert1 != 0 ? 1 : 0;
                }
                if ((alert1 = Time3d.diff_2d(x + 1, y, z - 1, t[x][y][z], hs_bf, hs_ube) + Time3d.t_2d(x + 1, y, z - 1, t[x][y][z], t[x + 1][y][z], hs_bf, hs_ube) + Time3d.t_2d(x + 1, y, z - 1, t[x][y][z], t[x][y][z - 1], hs_bf, hs_ube)) != 0) {
                    updated += alert1;
                    Time3d.longflags[x * Time3d.nz + Time3d.nz + z - 1] = 1;
                }
                --z;
            }
            ++x;
        }
        flag_fb = 0;
        x_start_fb = x_end;
        z_start_fb = z_begin;
        return updated;
    }

    private static int z_side(int x_begin, int x_end, int y_begin, int y_end, int z, int future) {
        int test;
        if (reverse_order == 0) {
            current_side_limit = z + future;
        }
        int updated = 0;
        int z0 = z - future;
        int z_s = future == 1 ? z0 : z;
        flag_bb = 0;
        flag_ff = 0;
        flag_bf = 0;
        flag_fb = 0;
        x_start_ff = x_start_fb = x_end;
        x_start_bf = x_start_bb = x_begin;
        y_start_ff = y_start_bf = y_end;
        y_start_fb = y_start_bb = y_begin;
        int x = x_begin;
        while (x <= x_end) {
            int y = y_begin;
            while (y <= y_end) {
                float hs_ff = hs[x][y][z_s];
                float hs_bf = x > 0 ? hs[x - 1][y][z_s] : 1.0E19f;
                float hs_bb = x > 0 && y > 0 ? hs[x - 1][y - 1][z_s] : 1.0E19f;
                float hs_fb = y > 0 ? hs[x][y - 1][z_s] : 1.0E19f;
                int sign_fb = 0;
                int sign_bb = 0;
                int sign_bf = 0;
                int sign_ff = 0;
                updated += Time3d.t_1d(x, y, z, t[x][y][z0], hs_ff, hs_bf, hs_bb, hs_fb);
                if (x < x_end && y < y_end) {
                    updated += Time3d.t_3d_part1(x, y, z, t[x][y][z0], t[x + 1][y][z0], t[x][y + 1][z0], hs_ff);
                }
                if (x > x_begin && y < y_end) {
                    updated += Time3d.t_3d_part1(x, y, z, t[x][y][z0], t[x - 1][y][z0], t[x][y + 1][z0], hs_bf);
                }
                if (x > x_begin && y > y_begin) {
                    updated += Time3d.t_3d_part1(x, y, z, t[x][y][z0], t[x - 1][y][z0], t[x][y - 1][z0], hs_bb);
                }
                if (x < x_end && y > y_begin) {
                    updated += Time3d.t_3d_part1(x, y, z, t[x][y][z0], t[x + 1][y][z0], t[x][y - 1][z0], hs_fb);
                }
                if (x < x_end && t[x][y][z0] <= t[x + 1][y][z0]) {
                    ++sign_fb;
                    ++sign_ff;
                    if (x < x_start_ff) {
                        x_start_ff = x;
                    }
                    if (x < x_start_fb) {
                        x_start_fb = x;
                    }
                    updated += Time3d.diff_2d(x + 1, y, z, t[x][y][z0], hs_ff, hs_fb);
                    updated += Time3d.t_2d(x + 1, y, z, t[x][y][z0], t[x + 1][y][z0], hs_ff, hs_fb);
                }
                if (x > x_begin && t[x][y][z0] <= t[x - 1][y][z0]) {
                    ++sign_bb;
                    ++sign_bf;
                    if (x > x_start_bf) {
                        x_start_bf = x;
                    }
                    if (x > x_start_bb) {
                        x_start_bb = x;
                    }
                    updated += Time3d.diff_2d(x - 1, y, z, t[x][y][z0], hs_bf, hs_bb);
                    updated += Time3d.t_2d(x - 1, y, z, t[x][y][z0], t[x - 1][y][z0], hs_bf, hs_bb);
                }
                if (y < y_end && t[x][y][z0] <= t[x][y + 1][z0]) {
                    ++sign_bf;
                    ++sign_ff;
                    if (y < y_start_ff) {
                        y_start_ff = y;
                    }
                    if (y < y_start_bf) {
                        y_start_bf = y;
                    }
                    updated += Time3d.diff_2d(x, y + 1, z, t[x][y][z0], hs_ff, hs_bf);
                    updated += Time3d.t_2d(x, y + 1, z, t[x][y][z0], t[x][y + 1][z0], hs_ff, hs_bf);
                }
                if (y > y_begin && t[x][y][z0] <= t[x][y - 1][z0]) {
                    ++sign_bb;
                    ++sign_fb;
                    if (y > y_start_fb) {
                        y_start_fb = y;
                    }
                    if (y > y_start_bb) {
                        y_start_bb = y;
                    }
                    updated += Time3d.diff_2d(x, y - 1, z, t[x][y][z0], hs_bb, hs_fb);
                    updated += Time3d.t_2d(x, y - 1, z, t[x][y][z0], t[x][y - 1][z0], hs_bb, hs_fb);
                }
                if (sign_ff == 2) {
                    flag_ff = 1;
                    updated += Time3d.point_diff(x + 1, y + 1, z, t[x][y][z0], hs_ff) + Time3d.edge_diff(x + 1, y + 1, z, t[x][y][z0], t[x + 1][y][z0], hs_ff) + Time3d.edge_diff(x + 1, y + 1, z, t[x][y][z0], t[x][y + 1][z0], hs_ff) + Time3d.t_3d_part2(x + 1, y + 1, z, t[x][y][z0], t[x + 1][y][z0], t[x][y + 1][z0], t[x + 1][y + 1][z0], hs_ff);
                }
                if (sign_bf == 2) {
                    flag_bf = 1;
                    updated += Time3d.point_diff(x - 1, y + 1, z, t[x][y][z0], hs_bf) + Time3d.edge_diff(x - 1, y + 1, z, t[x][y][z0], t[x - 1][y][z0], hs_bf) + Time3d.edge_diff(x - 1, y + 1, z, t[x][y][z0], t[x][y + 1][z0], hs_bf) + Time3d.t_3d_part2(x - 1, y + 1, z, t[x][y][z0], t[x - 1][y][z0], t[x][y + 1][z0], t[x - 1][y + 1][z0], hs_bf);
                }
                if (sign_bb == 2) {
                    flag_bb = 1;
                    updated += Time3d.point_diff(x - 1, y - 1, z, t[x][y][z0], hs_bb) + Time3d.edge_diff(x - 1, y - 1, z, t[x][y][z0], t[x - 1][y][z0], hs_bb) + Time3d.edge_diff(x - 1, y - 1, z, t[x][y][z0], t[x][y - 1][z0], hs_bb) + Time3d.t_3d_part2(x - 1, y - 1, z, t[x][y][z0], t[x - 1][y][z0], t[x][y - 1][z0], t[x - 1][y - 1][z0], hs_bb);
                }
                if (sign_fb == 2) {
                    flag_fb = 1;
                    updated += Time3d.point_diff(x + 1, y - 1, z, t[x][y][z0], hs_fb) + Time3d.edge_diff(x + 1, y - 1, z, t[x][y][z0], t[x + 1][y][z0], hs_fb) + Time3d.edge_diff(x + 1, y - 1, z, t[x][y][z0], t[x][y - 1][z0], hs_fb) + Time3d.t_3d_part2(x + 1, y - 1, z, t[x][y][z0], t[x + 1][y][z0], t[x][y - 1][z0], t[x + 1][y - 1][z0], hs_fb);
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < nx * ny) {
            Time3d.longflags[x] = 0;
            ++x;
        }
        if (x_begin == x_end || y_begin == y_end) {
            flag_bb = 1;
            flag_bf = 1;
            flag_fb = 1;
            flag_ff = 1;
            x_start_ff = x_start_fb = x_begin;
            x_start_bf = x_start_bb = x_end;
            y_start_ff = y_start_bf = y_begin;
            y_start_fb = y_start_bb = y_end;
        }
        do {
            test = 0;
            if (flag_ff != 0) {
                ++test;
                if (messages == 2) {
                    logger.debug((Object)String.format("ff ", new Object[0]));
                }
                updated += Time3d.scan_z_ff(x_start_ff, x_end, y_start_ff, y_end, z0, z, z_s);
            }
            if (flag_fb != 0) {
                ++test;
                if (messages == 2) {
                    logger.debug((Object)String.format("fb ", new Object[0]));
                }
                updated += Time3d.scan_z_fb(x_start_fb, x_end, y_begin, y_start_fb, z0, z, z_s);
            }
            if (flag_bb != 0) {
                ++test;
                if (messages == 2) {
                    logger.debug((Object)String.format("bb ", new Object[0]));
                }
                updated += Time3d.scan_z_bb(x_begin, x_start_bb, y_begin, y_start_bb, z0, z, z_s);
            }
            if (flag_bf == 0) continue;
            ++test;
            if (messages == 2) {
                logger.debug((Object)String.format("bf ", new Object[0]));
            }
            updated += Time3d.scan_z_bf(x_begin, x_start_bf, y_start_bf, y_end, z0, z, z_s);
        } while (test != 0);
        sum_updated += updated;
        int longhead = 0;
        x = 0;
        while (x < nx * ny) {
            longhead += longflags[x];
            ++x;
        }
        if (longhead != 0) {
            ++reverse_order;
            if (messages == 2) {
                logger.debug((Object)String.format("\nReverse#%d from z_side %d", reverse_order, z));
            }
            int past = -future;
            z = z0;
            while (z != current_side_limit) {
                if (z < 0 || z >= nz) break;
                if (messages == 2) {
                    logger.debug((Object)String.format("\nupdate side z=%d: ", z));
                }
                if (Time3d.z_side(x_begin, x_end, y_begin, y_end, z, past) == 0) break;
                if (messages == 2) {
                    logger.debug((Object)String.format("z=%d <R#%d>updated.", z, reverse_order));
                }
                z += past;
            }
            if (messages == 2) {
                logger.debug((Object)String.format("\nEnd Reverse#%d\n", reverse_order));
            }
            --reverse_order;
        }
        return updated;
    }

    private static int scan_z_ff(int x_start, int x_end, int y_start, int y_end, int z0, int z, int z_s) {
        float hs_fb;
        int alert0;
        int alert1;
        float hs_bf;
        int updated = 0;
        int z_sf = z_s + z - z0;
        float hs_ube = 1.0E19f;
        float hs_ubb = 1.0E19f;
        float hs_bb = 1.0E19f;
        int x = x_start;
        int y = y_start;
        while (x < x_end) {
            hs_bf = hs[x][y][z_s];
            if (y != 0) {
                hs_bb = hs[x][y - 1][z_s];
            }
            if (z_sf >= 0 && z_sf < nmesh_z) {
                hs_ube = hs[x][y][z_sf];
                if (y != 0) {
                    hs_ubb = hs[x][y - 1][z_sf];
                }
            }
            alert1 = Time3d.t_1d(x + 1, y, z, t[x][y][z], hs_bb, hs_bf, hs_ubb, hs_ube);
            alert0 = Time3d.t_2d(x + 1, y, z, t[x][y][z0], t[x][y][z], hs_bb, hs_bf);
            if (alert1 != 0) {
                Time3d.longflags[x * Time3d.ny + Time3d.ny + y] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[x * Time3d.ny + Time3d.ny + y] = 0;
            }
            ++x;
        }
        float hs_ueb = 1.0E19f;
        hs_ubb = 1.0E19f;
        hs_bb = 1.0E19f;
        x = x_start;
        y = y_start;
        while (y < y_end) {
            hs_fb = hs[x][y][z_s];
            if (x != 0) {
                hs_bb = hs[x - 1][y][z_s];
            }
            if (z_sf >= 0 && z_sf < nmesh_z) {
                hs_ueb = hs[x][y][z_sf];
                if (x != 0) {
                    hs_ubb = hs[x - 1][y][z_sf];
                }
            }
            alert1 = Time3d.t_1d(x, y + 1, z, t[x][y][z], hs_bb, hs_fb, hs_ubb, hs_ueb);
            alert0 = Time3d.t_2d(x, y + 1, z, t[x][y][z0], t[x][y][z], hs_bb, hs_fb);
            if (alert1 != 0) {
                Time3d.longflags[x * Time3d.ny + y + 1] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[x * Time3d.ny + y + 1] = 0;
            }
            ++y;
        }
        x = x_start;
        while (x < x_end) {
            y = y_start;
            while (y < y_end) {
                hs_bb = hs[x][y][z_s];
                hs_bf = hs[x][y + 1][z_s];
                hs_fb = hs[x + 1][y][z_s];
                if (z_sf >= 0 && z_sf < nmesh_z) {
                    hs_ubb = hs[x][y][z_sf];
                    hs_ube = hs[x][y + 1][z_sf];
                    hs_ueb = hs[x + 1][y][z_sf];
                } else {
                    hs_ueb = 1.0E19f;
                    hs_ube = 1.0E19f;
                    hs_ubb = 1.0E19f;
                }
                alert0 = Time3d.edge_diff(x + 1, y + 1, z, t[x][y][z0], t[x][y][z], hs_bb) + Time3d.t_3d(x + 1, y + 1, z, t[x][y][z0], t[x + 1][y][z0], t[x][y][z], t[x + 1][y][z], hs_bb) + Time3d.t_3d(x + 1, y + 1, z, t[x][y][z0], t[x][y + 1][z0], t[x][y][z], t[x][y + 1][z], hs_bb);
                if (alert0 != 0) {
                    updated += alert0;
                    Time3d.longflags[x * Time3d.ny + Time3d.ny + y + 1] = 0;
                }
                alert1 = Time3d.t_1d(x + 1, y + 1, z, t[x][y + 1][z], hs_bb, hs_bf, hs_ubb, hs_ube);
                alert0 = Time3d.t_2d(x + 1, y + 1, z, t[x][y + 1][z0], t[x][y + 1][z], hs_bb, hs_bf);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_fb;
                    if (x_start_fb > x) {
                        x_start_fb = x;
                    }
                    if (y_start_fb < y + 1) {
                        y_start_fb = y + 1;
                    }
                    Time3d.longflags[x * Time3d.ny + Time3d.ny + y + 1] = alert1 != 0 ? 1 : 0;
                }
                alert1 = Time3d.t_1d(x + 1, y + 1, z, t[x + 1][y][z], hs_bb, hs_fb, hs_ubb, hs_ueb);
                alert0 = Time3d.t_2d(x + 1, y + 1, z, t[x + 1][y][z0], t[x + 1][y][z], hs_bb, hs_fb);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_bf;
                    if (x_start_bf < x + 1) {
                        x_start_bf = x + 1;
                    }
                    if (y_start_bf > y) {
                        y_start_bf = y;
                    }
                    Time3d.longflags[x * Time3d.ny + Time3d.ny + y + 1] = alert1 != 0 ? 1 : 0;
                }
                if ((alert1 = Time3d.diff_2d(x + 1, y + 1, z, t[x][y][z], hs_bb, hs_ubb) + Time3d.t_2d(x + 1, y + 1, z, t[x][y][z], t[x + 1][y][z], hs_bb, hs_ubb) + Time3d.t_2d(x + 1, y + 1, z, t[x][y][z], t[x][y + 1][z], hs_bb, hs_ubb)) != 0) {
                    updated += alert1;
                    Time3d.longflags[x * Time3d.ny + Time3d.ny + y + 1] = 1;
                }
                ++y;
            }
            ++x;
        }
        flag_ff = 0;
        x_start_ff = x_end;
        y_start_ff = y_end;
        return updated;
    }

    private static int scan_z_bf(int x_begin, int x_start, int y_start, int y_end, int z0, int z, int z_s) {
        int alert0;
        int alert1;
        float hs_ff;
        int updated = 0;
        int z_sf = z_s + z - z0;
        float hs_ueb = 1.0E19f;
        float hs_uee = 1.0E19f;
        float hs_fb = 1.0E19f;
        int x = x_start;
        int y = y_start;
        while (x > x_begin) {
            hs_ff = hs[x - 1][y][z_s];
            if (y != 0) {
                hs_fb = hs[x - 1][y - 1][z_s];
            }
            if (z_sf >= 0 && z_sf < nmesh_z) {
                hs_uee = hs[x - 1][y][z_sf];
                if (y != 0) {
                    hs_ueb = hs[x - 1][y - 1][z_sf];
                }
            }
            alert1 = Time3d.t_1d(x - 1, y, z, t[x][y][z], hs_fb, hs_ff, hs_ueb, hs_uee);
            alert0 = Time3d.t_2d(x - 1, y, z, t[x][y][z0], t[x][y][z], hs_fb, hs_ff);
            if (alert1 != 0) {
                Time3d.longflags[x * Time3d.ny - Time3d.ny + y] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[x * Time3d.ny - Time3d.ny + y] = 0;
            }
            --x;
        }
        hs_ueb = 1.0E19f;
        float hs_ubb = 1.0E19f;
        float hs_bb = 1.0E19f;
        x = x_start;
        y = y_start;
        while (y < y_end) {
            if (x != 0) {
                hs_bb = hs[x - 1][y][z_s];
            }
            hs_fb = hs[x][y][z_s];
            if (z_sf >= 0 && z_sf < nmesh_z) {
                if (x != 0) {
                    hs_ubb = hs[x - 1][y][z_sf];
                }
                hs_ueb = hs[x][y][z_sf];
            }
            alert1 = Time3d.t_1d(x, y + 1, z, t[x][y][z], hs_bb, hs_fb, hs_ubb, hs_ueb);
            alert0 = Time3d.t_2d(x, y + 1, z, t[x][y][z0], t[x][y][z], hs_bb, hs_fb);
            if (alert1 != 0) {
                Time3d.longflags[x * Time3d.ny + y + 1] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[x * Time3d.ny + y + 1] = 0;
            }
            ++y;
        }
        x = x_start;
        while (x > x_begin) {
            y = y_start;
            while (y < y_end) {
                hs_ff = hs[x - 1][y + 1][z_s];
                hs_bb = x > 1 ? hs[x - 2][y][z_s] : 1.0E19f;
                hs_fb = hs[x - 1][y][z_s];
                if (z_sf >= 0 && z_sf < nmesh_z) {
                    hs_uee = hs[x - 1][y + 1][z_sf];
                    hs_ubb = x > 1 ? hs[x - 2][y][z_sf] : 1.0E19f;
                    hs_ueb = hs[x - 1][y][z_sf];
                } else {
                    hs_ueb = 1.0E19f;
                    hs_uee = 1.0E19f;
                    hs_ubb = 1.0E19f;
                }
                alert0 = Time3d.edge_diff(x - 1, y + 1, z, t[x][y][z0], t[x][y][z], hs_fb) + Time3d.t_3d(x - 1, y + 1, z, t[x][y][z0], t[x - 1][y][z0], t[x][y][z], t[x - 1][y][z], hs_fb) + Time3d.t_3d(x - 1, y + 1, z, t[x][y][z0], t[x][y + 1][z0], t[x][y][z], t[x][y + 1][z], hs_fb);
                if (alert0 != 0) {
                    updated += alert0;
                    Time3d.longflags[x * Time3d.ny - Time3d.ny + y + 1] = 0;
                }
                alert1 = Time3d.t_1d(x - 1, y + 1, z, t[x][y + 1][z], hs_ff, hs_fb, hs_uee, hs_ueb);
                alert0 = Time3d.t_2d(x - 1, y + 1, z, t[x][y + 1][z0], t[x][y + 1][z], hs_ff, hs_fb);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_bb;
                    if (x_start_bb < x) {
                        x_start_bb = x;
                    }
                    if (y_start_bb < y + 1) {
                        y_start_bb = y + 1;
                    }
                    Time3d.longflags[x * Time3d.ny - Time3d.ny + y + 1] = alert1 != 0 ? 1 : 0;
                }
                alert1 = Time3d.t_1d(x - 1, y + 1, z, t[x - 1][y][z], hs_bb, hs_fb, hs_ubb, hs_ueb);
                alert0 = Time3d.t_2d(x - 1, y + 1, z, t[x - 1][y][z0], t[x - 1][y][z], hs_bb, hs_fb);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_ff;
                    if (x_start_ff > x - 1) {
                        x_start_ff = x - 1;
                    }
                    if (y_start_ff > y) {
                        y_start_ff = y;
                    }
                    Time3d.longflags[x * Time3d.ny - Time3d.ny + y + 1] = alert1 != 0 ? 1 : 0;
                }
                if ((alert1 = Time3d.diff_2d(x - 1, y + 1, z, t[x][y][z], hs_fb, hs_ueb) + Time3d.t_2d(x - 1, y + 1, z, t[x][y][z], t[x - 1][y][z], hs_fb, hs_ueb) + Time3d.t_2d(x - 1, y + 1, z, t[x][y][z], t[x][y + 1][z], hs_fb, hs_ueb)) != 0) {
                    updated += alert1;
                    Time3d.longflags[x * Time3d.ny - Time3d.ny + y + 1] = 1;
                }
                ++y;
            }
            --x;
        }
        flag_bf = 0;
        x_start_bf = x_begin;
        y_start_bf = y_end;
        return updated;
    }

    private static int scan_z_bb(int x_begin, int x_start, int y_begin, int y_start, int z0, int z, int z_s) {
        float hs_bf;
        int alert0;
        int alert1;
        float hs_fb;
        int updated = 0;
        int z_sf = z_s + z - z0;
        float hs_ueb = 1.0E19f;
        float hs_uee = 1.0E19f;
        float hs_ff = 1.0E19f;
        int x = x_start;
        int y = y_start;
        while (x > x_begin) {
            if (y != 0) {
                hs_ff = hs[x - 1][y - 1][z_s];
            }
            hs_fb = hs[x - 1][y][z_s];
            if (z_sf >= 0 && z_sf < nmesh_z) {
                if (y != 0) {
                    hs_uee = hs[x - 1][y - 1][z_sf];
                }
                hs_ueb = hs[x - 1][y][z_sf];
            }
            alert1 = Time3d.t_1d(x - 1, y, z, t[x][y][z], hs_fb, hs_ff, hs_ueb, hs_uee);
            alert0 = Time3d.t_2d(x - 1, y, z, t[x][y][z0], t[x][y][z], hs_fb, hs_ff);
            if (alert1 != 0) {
                Time3d.longflags[x * Time3d.ny - Time3d.ny + y] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[x * Time3d.ny - Time3d.ny + y] = 0;
            }
            --x;
        }
        float hs_ube = 1.0E19f;
        hs_uee = 1.0E19f;
        hs_ff = 1.0E19f;
        x = x_start;
        y = y_start;
        while (y > y_begin) {
            if (x != 0) {
                hs_ff = hs[x - 1][y - 1][z_s];
            }
            hs_bf = hs[x][y - 1][z_s];
            if (z_sf >= 0 && z_sf < nmesh_z) {
                if (x != 0) {
                    hs_uee = hs[x - 1][y - 1][z_sf];
                }
                hs_ube = hs[x][y - 1][z_sf];
            }
            alert1 = Time3d.t_1d(x, y - 1, z, t[x][y][z], hs_bf, hs_ff, hs_ube, hs_uee);
            alert0 = Time3d.t_2d(x, y - 1, z, t[x][y][z0], t[x][y][z], hs_bf, hs_ff);
            if (alert1 != 0) {
                Time3d.longflags[x * Time3d.ny + y - 1] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[x * Time3d.ny + y - 1] = 0;
            }
            --y;
        }
        x = x_start;
        while (x > x_begin) {
            y = y_start;
            while (y > y_begin) {
                hs_ff = hs[x - 1][y - 1][z_s];
                hs_bf = x > 1 ? hs[x - 2][y - 1][z_s] : 1.0E19f;
                hs_fb = y > 1 ? hs[x - 1][y - 2][z_s] : 1.0E19f;
                if (z_sf >= 0 && z_sf < nmesh_z) {
                    hs_uee = hs[x - 1][y - 1][z_sf];
                    hs_ube = x > 1 ? hs[x - 2][y - 1][z_sf] : 1.0E19f;
                    hs_ueb = y > 1 ? hs[x - 1][y - 2][z_sf] : 1.0E19f;
                } else {
                    hs_ueb = 1.0E19f;
                    hs_ube = 1.0E19f;
                    hs_uee = 1.0E19f;
                }
                alert0 = Time3d.edge_diff(x - 1, y - 1, z, t[x][y][z0], t[x][y][z], hs_ff) + Time3d.t_3d(x - 1, y - 1, z, t[x][y][z0], t[x - 1][y][z0], t[x][y][z], t[x - 1][y][z], hs_ff) + Time3d.t_3d(x - 1, y - 1, z, t[x][y][z0], t[x][y - 1][z0], t[x][y][z], t[x][y - 1][z], hs_ff);
                if (alert0 != 0) {
                    updated += alert0;
                    Time3d.longflags[x * Time3d.ny - Time3d.ny + y - 1] = 0;
                }
                alert1 = Time3d.t_1d(x - 1, y - 1, z, t[x][y - 1][z], hs_ff, hs_fb, hs_uee, hs_ueb);
                alert0 = Time3d.t_2d(x - 1, y - 1, z, t[x][y - 1][z0], t[x][y - 1][z], hs_ff, hs_fb);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_bf;
                    if (x_start_bf < x) {
                        x_start_bf = x;
                    }
                    if (y_start_bf > y - 1) {
                        y_start_bf = y - 1;
                    }
                    Time3d.longflags[x * Time3d.ny - Time3d.ny + y - 1] = alert1 != 0 ? 1 : 0;
                }
                alert1 = Time3d.t_1d(x - 1, y - 1, z, t[x - 1][y][z], hs_ff, hs_bf, hs_uee, hs_ube);
                alert0 = Time3d.t_2d(x - 1, y - 1, z, t[x - 1][y][z0], t[x - 1][y][z], hs_ff, hs_bf);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_fb;
                    if (x_start_fb > x - 1) {
                        x_start_fb = x - 1;
                    }
                    if (y_start_fb < y) {
                        y_start_fb = y;
                    }
                    Time3d.longflags[x * Time3d.ny - Time3d.ny + y - 1] = alert1 != 0 ? 1 : 0;
                }
                if ((alert1 = Time3d.diff_2d(x - 1, y - 1, z, t[x][y][z], hs_ff, hs_uee) + Time3d.t_2d(x - 1, y - 1, z, t[x][y][z], t[x - 1][y][z], hs_ff, hs_uee) + Time3d.t_2d(x - 1, y - 1, z, t[x][y][z], t[x][y - 1][z], hs_ff, hs_uee)) != 0) {
                    updated += alert1;
                    Time3d.longflags[x * Time3d.ny - Time3d.ny + y - 1] = 1;
                }
                --y;
            }
            --x;
        }
        flag_bb = 0;
        x_start_bb = x_begin;
        y_start_bb = y_begin;
        return updated;
    }

    private static int scan_z_fb(int x_start, int x_end, int y_begin, int y_start, int z0, int z, int z_s) {
        int alert0;
        int alert1;
        float hs_bb;
        int updated = 0;
        int z_sf = z_s + z - z0;
        float hs_ube = 1.0E19f;
        float hs_ubb = 1.0E19f;
        float hs_bf = 1.0E19f;
        int x = x_start;
        int y = y_start;
        while (x < x_end) {
            if (y != 0) {
                hs_bf = hs[x][y - 1][z_s];
            }
            hs_bb = hs[x][y][z_s];
            if (z_sf >= 0 && z_sf < nmesh_z) {
                if (y != 0) {
                    hs_ube = hs[x][y - 1][z_sf];
                }
                hs_ubb = hs[x][y][z_sf];
            }
            alert1 = Time3d.t_1d(x + 1, y, z, t[x][y][z], hs_bf, hs_bb, hs_ube, hs_ubb);
            alert0 = Time3d.t_2d(x + 1, y, z, t[x][y][z0], t[x][y][z], hs_bf, hs_bb);
            if (alert1 != 0) {
                Time3d.longflags[x * Time3d.ny + Time3d.ny + y] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[x * Time3d.ny + Time3d.ny + y] = 0;
            }
            ++x;
        }
        hs_ube = 1.0E19f;
        float hs_uee = 1.0E19f;
        float hs_ff = 1.0E19f;
        x = x_start;
        y = y_start;
        while (y > y_begin) {
            if (x != 0) {
                hs_ff = hs[x - 1][y - 1][z_s];
            }
            hs_bf = hs[x][y - 1][z_s];
            if (z_sf >= 0 && z_sf < nmesh_z) {
                if (x != 0) {
                    hs_uee = hs[x - 1][y - 1][z_sf];
                }
                hs_ube = hs[x][y - 1][z_sf];
            }
            alert1 = Time3d.t_1d(x, y - 1, z, t[x][y][z], hs_bf, hs_ff, hs_ube, hs_uee);
            alert0 = Time3d.t_2d(x, y - 1, z, t[x][y][z0], t[x][y][z], hs_bf, hs_ff);
            if (alert1 != 0) {
                Time3d.longflags[x * Time3d.ny + y - 1] = 1;
            }
            if (alert0 != 0) {
                Time3d.longflags[x * Time3d.ny + y - 1] = 0;
            }
            --y;
        }
        x = x_start;
        while (x < x_end) {
            y = y_start;
            while (y > y_begin) {
                hs_bf = hs[x][y - 1][z_s];
                hs_bb = y > 1 ? hs[x][y - 2][z_s] : 1.0E19f;
                hs_ff = hs[x + 1][y - 1][z_s];
                if (z_sf >= 0 && z_sf < nmesh_z) {
                    hs_ube = hs[x][y - 1][z_sf];
                    hs_ubb = y > 1 ? hs[x][y - 2][z_sf] : 1.0E19f;
                    hs_uee = hs[x + 1][y - 1][z_sf];
                } else {
                    hs_uee = 1.0E19f;
                    hs_ube = 1.0E19f;
                    hs_ubb = 1.0E19f;
                }
                alert0 = Time3d.edge_diff(x + 1, y - 1, z, t[x][y][z0], t[x][y][z], hs_bf) + Time3d.t_3d(x + 1, y - 1, z, t[x][y][z0], t[x + 1][y][z0], t[x][y][z], t[x + 1][y][z], hs_bf) + Time3d.t_3d(x + 1, y - 1, z, t[x][y][z0], t[x][y - 1][z0], t[x][y][z], t[x][y - 1][z], hs_bf);
                if (alert0 != 0) {
                    updated += alert0;
                    Time3d.longflags[x * Time3d.ny + Time3d.ny + y - 1] = 0;
                }
                alert1 = Time3d.t_1d(x + 1, y - 1, z, t[x][y - 1][z], hs_bb, hs_bf, hs_ubb, hs_ube);
                alert0 = Time3d.t_2d(x + 1, y - 1, z, t[x][y - 1][z0], t[x][y - 1][z], hs_bb, hs_bf);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_ff;
                    if (x_start_ff > x) {
                        x_start_ff = x;
                    }
                    if (y_start_ff > y - 1) {
                        y_start_ff = y - 1;
                    }
                    Time3d.longflags[x * Time3d.ny + Time3d.ny + y - 1] = alert1 != 0 ? 1 : 0;
                }
                alert1 = Time3d.t_1d(x + 1, y - 1, z, t[x + 1][y][z], hs_ff, hs_bf, hs_uee, hs_ube);
                alert0 = Time3d.t_2d(x + 1, y - 1, z, t[x + 1][y][z0], t[x + 1][y][z], hs_ff, hs_bf);
                if (alert0 + alert1 != 0) {
                    updated += alert0 + alert1;
                    ++flag_bb;
                    if (x_start_bb < x + 1) {
                        x_start_bb = x + 1;
                    }
                    if (y_start_bb < y) {
                        y_start_bb = y;
                    }
                    Time3d.longflags[x * Time3d.ny + Time3d.ny + y - 1] = alert1 != 0 ? 1 : 0;
                }
                if ((alert1 = Time3d.diff_2d(x + 1, y - 1, z, t[x][y][z], hs_bf, hs_ube) + Time3d.t_2d(x + 1, y - 1, z, t[x][y][z], t[x + 1][y][z], hs_bf, hs_ube) + Time3d.t_2d(x + 1, y - 1, z, t[x][y][z], t[x][y - 1][z], hs_bf, hs_ube)) != 0) {
                    updated += alert1;
                    Time3d.longflags[x * Time3d.ny + Time3d.ny + y - 1] = 1;
                }
                --y;
            }
            ++x;
        }
        flag_fb = 0;
        x_start_fb = x_end;
        y_start_fb = y_begin;
        return updated;
    }
}

