/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.nlloc;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.io.LittleEndianOutputStream;
import cn.org.gddsn.seis.location.nlloc.RandomUtil;
import java.io.IOException;

public class OctTree {
    public static OctNode newOctNode(OctNode parent, Vect3D center, Vect3D ds, double value, Object pdata) {
        OctNode node = new OctNode();
        node.parent = parent;
        node.center = center;
        node.ds = ds;
        node.value = value;
        node.pdata = pdata;
        int l = 0;
        while (l < 2) {
            int m = 0;
            while (m < 2) {
                int n = 0;
                while (n < 2) {
                    node.child[l][m][n] = null;
                    ++n;
                }
                ++m;
            }
            ++l;
        }
        node.isLeaf = 1;
        return node;
    }

    public static Tree3D newTree3D(int data_code, int numx, int numy, int numz, double origx, double origy, double origz, double dx, double dy, double dz, double value, double integral, Object pdata) {
        Vect3D center = new Vect3D();
        Vect3D ds = new Vect3D();
        OctNode[][][] garray = new OctNode[numx][numy][numz];
        ds.x = dx;
        ds.y = dy;
        ds.z = dz;
        int ix = 0;
        while (ix < numx) {
            center.x = origx + (double)ix * dx + dx / 2.0;
            int iy = 0;
            while (iy < numy) {
                center.y = origy + (double)iy * dy + dy / 2.0;
                int iz = 0;
                while (iz < numz) {
                    center.z = origz + (double)iz * dz + dz / 2.0;
                    garray[ix][iy][iz] = OctTree.newOctNode(null, center, ds, value, pdata);
                    ++iz;
                }
                ++iy;
            }
            ++ix;
        }
        Tree3D tree = new Tree3D();
        tree.nodeArray = garray;
        tree.data_code = data_code;
        tree.numx = numx;
        tree.numy = numy;
        tree.numz = numz;
        tree.orig.x = origx;
        tree.orig.y = origy;
        tree.orig.z = origz;
        tree.ds = ds;
        tree.integral = integral;
        return tree;
    }

    public static void subdivide(OctNode parent, double value, Object pdata) {
        Vect3D center = new Vect3D();
        Vect3D ds = new Vect3D();
        ds.x = parent.ds.x / 2.0;
        ds.y = parent.ds.y / 2.0;
        ds.z = parent.ds.z / 2.0;
        int ix = 0;
        while (ix < 2) {
            center.x = parent.center.x + (double)(2 * ix - 1) * ds.x / 2.0;
            int iy = 0;
            while (iy < 2) {
                center.y = parent.center.y + (double)(2 * iy - 1) * ds.y / 2.0;
                int iz = 0;
                while (iz < 2) {
                    center.z = parent.center.z + (double)(2 * iz - 1) * ds.z / 2.0;
                    parent.child[ix][iy][iz] = OctTree.newOctNode(parent, center, ds, value, pdata);
                    ++iz;
                }
                ++iy;
            }
            ++ix;
        }
        if (parent != null) {
            parent.isLeaf = 0;
        }
    }

    public static void freeTree3D(Tree3D tree, int freeDataPointer) {
        if (tree == null) {
            return;
        }
        int ix = 0;
        while (ix < tree.numx) {
            int iy = 0;
            while (iy < tree.numy) {
                int iz = 0;
                while (iz < tree.numz) {
                    OctTree.freeNode(tree.nodeArray[ix][iy][iz], freeDataPointer);
                    ++iz;
                }
                tree.nodeArray[ix][iy] = null;
                ++iy;
            }
            tree.nodeArray[ix] = null;
            ++ix;
        }
        tree.nodeArray = null;
        tree = null;
    }

    public static void freeNode(OctNode node, int freeDataPointer) {
        int ix = 0;
        while (ix < 2) {
            int iy = 0;
            while (iy < 2) {
                int iz = 0;
                while (iz < 2) {
                    if (node.child[ix][iy][iz] != null) {
                        OctTree.freeNode(node.child[ix][iy][iz], freeDataPointer);
                    }
                    ++iz;
                }
                ++iy;
            }
            ++ix;
        }
        if (freeDataPointer != 0) {
            node.pdata = null;
        }
        node = null;
    }

    public static OctNode getLeafNodeContaining(Tree3D tree, Vect3D coords) {
        int ix = (int)((coords.x - tree.orig.x) / tree.ds.x);
        if (ix < 0 || ix >= tree.numx) {
            return null;
        }
        int iy = (int)((coords.y - tree.orig.y) / tree.ds.y);
        if (iy < 0 || iy >= tree.numy) {
            return null;
        }
        int iz = (int)((coords.z - tree.orig.z) / tree.ds.z);
        if (iz < 0 || iz >= tree.numz) {
            return null;
        }
        OctNode rootNode = tree.nodeArray[ix][iy][iz];
        if (rootNode == null) {
            return null;
        }
        return OctTree.getLeafContaining(rootNode, coords.x, coords.y, coords.z);
    }

    public static OctNode getLeafContaining(OctNode node, double x, double y, double z) {
        OctNode childNode;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        if (x >= node.center.x) {
            ix = 1;
        }
        if (y >= node.center.y) {
            iy = 1;
        }
        if (z >= node.center.z) {
            iz = 1;
        }
        if ((childNode = node.child[ix][iy][iz]) == null) {
            return node;
        }
        return OctTree.getLeafContaining(childNode, x, y, z);
    }

    public static int nodeContains(OctNode node, double x, double y, double z) {
        Vect3D ds = node.ds;
        double dx2 = ds.x / 2.0;
        if (x < node.center.x - dx2 || x > node.center.x + dx2) {
            return 0;
        }
        double dy2 = ds.y / 2.0;
        if (y < node.center.y - dy2 || y > node.center.y + dy2) {
            return 0;
        }
        double dz2 = ds.z / 2.0;
        if (z < node.center.z - dz2 || z > node.center.z + dz2) {
            return 0;
        }
        return 1;
    }

    public static int extendedNodeContains(OctNode node, double x, double y, double z, int checkZ) {
        double dz2;
        Vect3D ds = node.ds;
        double dx2 = ds.x;
        if (x < node.center.x - dx2 || x > node.center.x + dx2) {
            return 0;
        }
        double dy2 = ds.y;
        if (y < node.center.y - dy2 || y > node.center.y + dy2) {
            return 0;
        }
        if (checkZ != 0 && (z < node.center.z - (dz2 = ds.z) || z > node.center.z + dz2)) {
            return 0;
        }
        return 1;
    }

    public static ResultTreeNode addResult(ResultTreeNode prtree, double value, double volume, OctNode pnode) {
        if (prtree == null) {
            prtree = new ResultTreeNode();
            prtree.value = value;
            prtree.volume = volume;
            prtree.pnode = pnode;
            prtree.right = null;
            prtree.left = null;
        } else if (value == prtree.value) {
            if (RandomUtil.get_rand_int(-10000, 9999) < 0) {
                prtree.left = OctTree.addResult(prtree.left, value, volume, pnode);
            } else {
                prtree.right = OctTree.addResult(prtree.right, value, volume, pnode);
            }
        } else if (value < prtree.value) {
            prtree.left = OctTree.addResult(prtree.left, value, volume, pnode);
        } else {
            prtree.right = OctTree.addResult(prtree.right, value, volume, pnode);
        }
        return prtree;
    }

    public static void freeResultTree(ResultTreeNode prtree) {
        if (prtree.left != null) {
            OctTree.freeResultTree(prtree.left);
        }
        if (prtree.right != null) {
            OctTree.freeResultTree(prtree.right);
        }
        prtree = null;
    }

    public static ResultTreeNode getHighestValue(ResultTreeNode prtree) {
        if (prtree.right == null) {
            return prtree;
        }
        return OctTree.getHighestValue(prtree.right);
    }

    public static ResultTreeNode getHighestLeafValue(ResultTreeNode prtree) {
        ResultTreeNode prtree_returned = null;
        if (prtree.right != null) {
            prtree_returned = OctTree.getHighestLeafValue(prtree.right);
        }
        if (prtree_returned != null) {
            return prtree_returned;
        }
        if (prtree.pnode.isLeaf == 1) {
            return prtree;
        }
        if (prtree.left != null) {
            prtree_returned = OctTree.getHighestLeafValue(prtree.left);
        }
        return prtree_returned;
    }

    public static ResultTreeNode getHighestLeafValueMinSize(ResultTreeNode prtree, double sizeMinX, double sizeMinY, double sizeMinZ) {
        ResultTreeNode prtree_returned = null;
        if (prtree.right != null) {
            prtree_returned = OctTree.getHighestLeafValueMinSize(prtree.right, sizeMinX, sizeMinY, sizeMinZ);
        }
        if (prtree_returned != null) {
            return prtree_returned;
        }
        if (prtree.pnode.isLeaf == 1 && prtree.pnode.ds.x >= sizeMinX && prtree.pnode.ds.y >= sizeMinY && prtree.pnode.ds.z >= sizeMinZ) {
            return prtree;
        }
        if (prtree.left != null) {
            prtree_returned = OctTree.getHighestLeafValueMinSize(prtree.left, sizeMinX, sizeMinY, sizeMinZ);
        }
        return prtree_returned;
    }

    public static Tree3D readTree3D(LittleEndianInputStream fpio) throws IOException {
        int istat = 0;
        Tree3D tree = null;
        Vect3D orig = new Vect3D();
        Vect3D ds = new Vect3D();
        int data_code = fpio.readInt();
        int numx = fpio.readInt();
        int numy = fpio.readInt();
        int numz = fpio.readInt();
        orig.x = fpio.readDouble();
        orig.y = fpio.readDouble();
        orig.z = fpio.readDouble();
        ds.x = fpio.readDouble();
        ds.y = fpio.readDouble();
        ds.z = fpio.readDouble();
        double integral = fpio.readDouble();
        tree = OctTree.newTree3D(data_code, numx, numy, numz, orig.x, orig.y, orig.z, ds.x, ds.y, ds.z, -1.0, integral, null);
        int istat_cum = 0;
        int ix = 0;
        while (ix < tree.numx) {
            int iy = 0;
            while (iy < tree.numy) {
                int iz = 0;
                while (iz < tree.numz) {
                    if ((istat += OctTree.readNode(fpio, tree.nodeArray[ix][iy][iz])) < 0) {
                        return null;
                    }
                    istat_cum += istat;
                    ++iz;
                }
                ++iy;
            }
            ++ix;
        }
        return tree;
    }

    public static int readNode(LittleEndianInputStream fpio, OctNode node) throws IOException {
        float value = fpio.readFloat();
        node.value = value;
        node.isLeaf = fpio.readByte();
        if (node.isLeaf == 1) {
            return 1;
        }
        OctTree.subdivide(node, -1.0, null);
        int istat_cum = 1;
        int ix = 0;
        while (ix < 2) {
            int iy = 0;
            while (iy < 2) {
                int iz = 0;
                while (iz < 2) {
                    if (node.child[ix][iy][iz] != null) {
                        int istat = OctTree.readNode(fpio, node.child[ix][iy][iz]);
                        if (istat < 0) {
                            return -1;
                        }
                        istat_cum += istat;
                    }
                    ++iz;
                }
                ++iy;
            }
            ++ix;
        }
        return istat_cum;
    }

    public static int writeTree3D(LittleEndianOutputStream fpio, Tree3D tree) throws IOException {
        fpio.writeInt(tree.data_code);
        fpio.writeInt(tree.numx);
        fpio.writeInt(tree.numy);
        fpio.writeInt(tree.numz);
        fpio.writeDouble(tree.orig.x);
        fpio.writeDouble(tree.orig.y);
        fpio.writeDouble(tree.orig.z);
        fpio.writeDouble(tree.ds.x);
        fpio.writeDouble(tree.ds.y);
        fpio.writeDouble(tree.ds.z);
        fpio.writeDouble(tree.integral);
        int istat_cum = 0;
        int ix = 0;
        while (ix < tree.numx) {
            int iy = 0;
            while (iy < tree.numy) {
                int iz = 0;
                while (iz < tree.numz) {
                    int istat = OctTree.writeNode(fpio, tree.nodeArray[ix][iy][iz]);
                    if (istat < 0) {
                        return -1;
                    }
                    istat_cum += istat;
                    ++iz;
                }
                ++iy;
            }
            ++ix;
        }
        return istat_cum;
    }

    public static int writeNode(LittleEndianOutputStream fpio, OctNode node) throws IOException {
        float value = (float)node.value;
        fpio.writeFloat(value);
        fpio.write((int)node.isLeaf);
        if (node.isLeaf == 1) {
            return 1;
        }
        int istat_cum = 1;
        int ix = 0;
        while (ix < 2) {
            int iy = 0;
            while (iy < 2) {
                int iz = 0;
                while (iz < 2) {
                    if (node.child[ix][iy][iz] != null) {
                        int istat = OctTree.writeNode(fpio, node.child[ix][iy][iz]);
                        if (istat < 0) {
                            return -1;
                        }
                        istat_cum += istat;
                    }
                    ++iz;
                }
                ++iy;
            }
            ++ix;
        }
        return istat_cum;
    }

    public static class Mtrx3D {
        public double xx;
        public double xy;
        public double xz;
        public double yx;
        public double yy;
        public double yz;
        public double zx;
        public double zy;
        public double zz;
    }

    public static class OctNode {
        public OctNode parent;
        public Vect3D center;
        public Vect3D ds;
        public double value;
        public OctNode[][][] child = new OctNode[2][2][2];
        public byte isLeaf;
        public Object pdata;
    }

    public static class ResultTreeNode {
        public ResultTreeNode left;
        public ResultTreeNode right;
        public double value;
        public double volume;
        public OctNode pnode;
    }

    public static class Tree3D {
        public OctNode[][][] nodeArray;
        public int data_code;
        public int numx;
        public int numy;
        public int numz;
        public Vect3D orig;
        public Vect3D ds;
        public double integral;
    }

    public static class Vect2D {
        public double x;
        public double y;
    }

    public static class Vect3D {
        public double x;
        public double y;
        public double z;
    }
}

