/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.locsat3d.libloc;

import cn.org.gddsn.seis.location.locsat.LocSAT;
import cn.org.gddsn.seis.location.locsat3d.libloc.TBTT;
import cn.org.gddsn.seis.location.locsat3d.libloc.TBTTStation;
import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TBTT3D {
    static Logger logger = Logger.getLogger(TBTT3D.class);
    int MAXTBZ = 40;
    int MAXTBD = 207;
    public TBTT defaultTBTT;
    private Hashtable<String, TBTTStation> ttt3d = new Hashtable(512);

    public int setup_tbtt3d(String dir_3d, String prefix, String[] phases, int nphases) {
        File[] allDirs = new File(dir_3d).listFiles();
        int i = 0;
        while (i < allDirs.length) {
            int ierr;
            String staid = allDirs[i].getName();
            if (staid.equals("__.DFT")) {
                this.defaultTBTT = new TBTT();
                ierr = this.setup_tttables(new File(dir_3d, "__.DFT").getAbsolutePath(), prefix, phases, nphases, this.defaultTBTT);
                if (ierr != 0) {
                    return ierr;
                }
                this.defaultTBTT.staid = "__.DFT";
            } else {
                File dirSta = new File(dir_3d, staid);
                Vector<File> vec = new Vector<File>(32);
                File[] azi_files = dirSta.listFiles();
                int j = 0;
                while (j < azi_files.length) {
                    vec.add(azi_files[j]);
                    ++j;
                }
                Collections.sort(vec);
                vec.toArray(azi_files);
                float[] azi = new float[azi_files.length];
                TBTT[] locTTs = new TBTT[azi_files.length];
                int j2 = 0;
                while (j2 < azi_files.length) {
                    azi[j2] = Float.parseFloat(azi_files[j2].getName());
                    locTTs[j2] = new TBTT();
                    ierr = this.setup_tttables(azi_files[j2].getAbsolutePath(), prefix, phases, nphases, locTTs[j2]);
                    if (ierr != 0) {
                        return ierr;
                    }
                    locTTs[j2].staid = staid;
                    ++j2;
                }
                TBTTStation tbttSta = new TBTTStation(azi, locTTs);
                this.ttt3d.put(staid, tbttSta);
            }
            ++i;
        }
        return 0;
    }

    public int setup_tttables(String dir, String prefix, String[] phases, int nphases, TBTT locTT) {
        int _j;
        int maxtbd = this.MAXTBD;
        int maxtbz = this.MAXTBZ;
        int[] ntbd = new int[nphases];
        int[] ntbz = new int[nphases];
        float[][] tbd1 = new float[nphases][maxtbd];
        float[][] tbz1 = new float[nphases][maxtbz];
        float[][][] tbtt1 = new float[nphases][maxtbz][maxtbd];
        int ierr = LocSAT.rdtttab(String.valueOf(dir) + File.separator + prefix, phases, nphases, maxtbd, maxtbz, ntbd, ntbz, tbd1, tbz1, tbtt1);
        float[] tbd = new float[nphases * maxtbd];
        float[] tbz = new float[nphases * maxtbz];
        float[] tbtt = new float[nphases * maxtbz * maxtbd];
        int _k = 0;
        while (_k < nphases) {
            _j = 0;
            while (_j < maxtbz) {
                tbz[_k * maxtbz + _j] = tbz1[_k][_j];
                ++_j;
            }
            ++_k;
        }
        tbz1 = null;
        _k = 0;
        while (_k < nphases) {
            int _i = 0;
            while (_i < maxtbd) {
                tbd[_k * maxtbd + _i] = tbd1[_k][_i];
                ++_i;
            }
            ++_k;
        }
        tbd1 = null;
        _k = 0;
        while (_k < nphases) {
            _j = 0;
            while (_j < maxtbz) {
                int _i = 0;
                while (_i < maxtbd) {
                    tbtt[_k * maxtbz * maxtbd + _j * maxtbd + _i] = tbtt1[_k][_j][_i];
                    ++_i;
                }
                ++_j;
            }
            ++_k;
        }
        tbtt1 = null;
        locTT.wavid = phases;
        locTT.nwav = nphases;
        locTT.maxtbd = maxtbd;
        locTT.maxtbz = maxtbz;
        locTT.ntbd = ntbd;
        locTT.ntbz = ntbz;
        locTT.tbd = tbd;
        locTT.tbz = tbz;
        locTT.tbtt = tbtt;
        if (ierr == 0) {
            return 0;
        }
        if (ierr == 1) {
            logger.warn((Object)"setup_tttables: Error opening travel-time tables");
            return 13;
        }
        if (ierr == 2) {
            logger.warn((Object)"setup_tttables: Error reading travel-time tables: Unexpected E-O-F");
            return 14;
        }
        logger.warn((Object)"setup_tttables: Unknown error reading travel-time tables");
        return 15;
    }

    public TBTT get(String sta, float azi) {
        TBTTStation tbttSta = this.ttt3d.get(sta);
        if (tbttSta == null) {
            logger.warn((Object)("Could not found TT for " + sta + ", Use default one"));
            return this.defaultTBTT;
        }
        return tbttSta.get(azi);
    }
}

