/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.locsat3d.libloc;

import cn.org.gddsn.seis.location.locsat.libloc.Hypcut0;
import cn.org.gddsn.seis.location.locsat.libloc.LocUtil;
import cn.org.gddsn.seis.location.locsat3d.libloc.Hypinv0;
import cn.org.gddsn.seis.location.locsat3d.libloc.TBTT3D;
import java.io.PrintWriter;
import java.util.Date;
import org.netlib.util.doubleW;
import org.netlib.util.floatW;
import org.netlib.util.intW;

public class Locsat0 {
    public static final float radius = 6371.0f;
    private static final double km2deg = 0.00899322;

    public static void locsat0(String[] dstaid, String[] dwavid, String[] dtype, String[] atype, float[] dobs, float[] dsd, int[] idarid, int ndata, String[] staid, float[] stalat, float[] stalon, float[] stelev, float[] stacor, int nsta, TBTT3D tbtt3d, double time_offset, floatW alat0, floatW alon0, floatW zfoc0, floatW sig0, int ndf0, float pconf, floatW azwt, floatW damp, int maxit, boolean prtflg, boolean fxdflg, String outfile, PrintWriter pwOut, floatW alat, floatW alon, floatW zfoc, floatW torg, floatW sighat, floatW snssd, intW ndf, floatW epmaj, floatW epmin, floatW epstr, floatW zfint, floatW toint, floatW sxx, floatW syy, floatW szz, floatW stt, floatW sxy, floatW sxz, floatW syz, floatW stx, floatW sty, floatW stz, float[] stadel, float[] staazi, float[] stabaz, float[] epimp, float[] zfimp, float[] resid, int[] ipsta, int[] iderr, intW igap, intW niter, intW ierr) {
        int i = 0;
        int icnt = 0;
        int[] idtyp = new int[1500];
        int[] indx = new int[1500];
        int[] indx2 = new int[50];
        int[] ipwav = new int[1500];
        int isave = 0;
        int[] itdex = new int[50];
        int itimes = 0;
        int j = 0;
        int m = 0;
        int n = 0;
        intW nd = new intW(0);
        double[] azim = new double[1500];
        double[] dist = new double[1500];
        double dsdnorm = 0.0;
        double[] obs = new double[50];
        doubleW rank = new doubleW(0.0);
        double slodel = 0.0;
        double slovecres = 0.0;
        double timeref = time_offset;
        double torgd = 0.0;
        boolean[] lprt = new boolean[19];
        String ew = new String("  ");
        String ns = new String("  ");
        if (ndata < 3) {
            if (prtflg) {
                pwOut.printf("\n Insufficient data for a solution of Data = %d", nd.val);
            }
            ierr.val = 5;
            return;
        }
        LocUtil.check_data(dstaid, dwavid, dtype, dsd, ndata, staid, nsta, tbtt3d.defaultTBTT.wavid, tbtt3d.defaultTBTT.nwav, ipsta, ipwav, idtyp, iderr);
        n = 1;
        while (n <= ndata) {
            if (!(idtyp[n - 1] != 1 && idtyp[n - 1] != 3 || tbtt3d.defaultTBTT.ntbd[ipwav[n - 1] - 1] > 0 && tbtt3d.defaultTBTT.ntbz[ipwav[n - 1] - 1] > 0)) {
                iderr[n - 1] = 2;
            }
            ++n;
        }
        if (prtflg) {
            pwOut.printf("\n LocSAT LOCATION RESULTS\n", new Object[0]);
            pwOut.printf(" =======================================", new Object[0]);
            pwOut.printf("======================================= \n\n", new Object[0]);
            Date firstAT = new Date((long)(timeref * 1000.0));
            pwOut.printf("  First arrival detected at: %1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL\n\n", firstAT);
            pwOut.printf(" =======================================", new Object[0]);
            pwOut.printf("======================================= \n\n", new Object[0]);
            i = 1;
            while (i <= nsta) {
                pwOut.printf("%-6s%10.4f%10.4f%10.4f\n", staid[i - 1], Float.valueOf(stalat[i - 1]), Float.valueOf(stalon[i - 1]), Float.valueOf(stelev[i - 1]));
                ++i;
            }
            pwOut.printf("\n Ariv ID Statn  Phase    Type Atype  Observed    S.D. Err\n", new Object[0]);
            n = 1;
            while (n <= ndata) {
                pwOut.printf("%8d %-6s %-8s %-4s %1s    %10.3f%8.3f%4d\n", idarid[n - 1], dstaid[n - 1], dwavid[n - 1], dtype[n - 1], atype[n - 1], Float.valueOf(dobs[n - 1]), Float.valueOf(dsd[n - 1]), iderr[n - 1]);
                ++n;
            }
            pwOut.printf(" =======================================", new Object[0]);
            pwOut.printf("======================================= \n", new Object[0]);
        }
        boolean go1040 = false;
        if (Math.abs(alat0.val) > 90.0f || Math.abs(alon0.val) > 180.0f) {
            int nwav = tbtt3d.defaultTBTT.nwav;
            int maxtbd = tbtt3d.defaultTBTT.maxtbd;
            int maxtbz = tbtt3d.defaultTBTT.maxtbz;
            int[] ntbd = tbtt3d.defaultTBTT.ntbd;
            float[] tbd = tbtt3d.defaultTBTT.tbd;
            float[] tbtt = tbtt3d.defaultTBTT.tbtt;
            Hypcut0.hypcut0(staid, stalat, stalon, nsta, dobs, dsd, dwavid, ipsta, ipwav, nwav, maxtbd, maxtbz, ntbd, tbd, tbtt, idtyp, iderr, atype, ndata, pwOut, prtflg, alat0, alon0, ierr);
            if (ierr.val > 0) {
                if (prtflg) {
                    pwOut.printf("? LocSAT: Too few data to get an initial location", new Object[0]);
                }
                go1040 = true;
            }
        }
        if (!go1040) {
            sighat.val = -1.0f;
            zfint.val = -1.0f;
            toint.val = -1.0f;
            i = 1;
            while (i <= ndata) {
                epimp[i - 1] = -1.0f;
                zfimp[i - 1] = -1.0f;
                ++i;
            }
            Hypinv0.hypinv0(dstaid, dwavid, dtype, atype, dobs, dsd, ndata, staid, stalat, stalon, nsta, tbtt3d, ipsta, ipwav, idtyp, iderr, alat0.val, alon0.val, zfoc0, sig0, ndf0, pconf, 6371.0f, azwt, damp, maxit, prtflg, fxdflg, pwOut, alat, alon, zfoc, torg, sighat, snssd, ndf, epmaj, epmin, epstr, zfint, toint, sxx, syy, szz, stt, sxy, sxz, syz, stx, sty, stz, stadel, staazi, stabaz, epimp, rank, resid, igap, niter, nd, ierr);
            torgd = timeref + (double)torg.val;
        }
        if (prtflg) {
            if (ierr.val == 0) {
                pwOut.printf("\n Location ran for%3d iterations ... Converged!\n", niter.val);
            } else if (ierr.val == 1) {
                pwOut.printf("\n Location ran for%3d iterations ... Exhausted!\n", niter.val);
            } else if (ierr.val == 2) {
                pwOut.printf("\n Location ran for%3d iterations ... Diverged!\n", niter.val);
            } else if (ierr.val == 3) {
                pwOut.printf("\n Too few usable data\n", new Object[0]);
            } else if (ierr.val == 4) {
                pwOut.printf("\n Too few usable data to constrain origin time,\n however, a valid location was obtained\n", new Object[0]);
            } else {
                if (ierr.val == 5) {
                    pwOut.printf("\n Insufficient data for a solution: # of Data = %3d", n);
                    return;
                }
                if (ierr.val == 6) {
                    pwOut.printf(" SVD routine cannot invert given matrix --", new Object[0]);
                    pwOut.printf(" No singular values found\n", new Object[0]);
                    pwOut.printf(" Returning !!\n", new Object[0]);
                    return;
                }
            }
            pwOut.printf("\n =======================================", new Object[0]);
            pwOut.printf("======================================= \n\n\n", new Object[0]);
            ew = " E";
            ns = " N";
            if (alon.val < 0.0f) {
                ew = " W";
            }
            if (alat.val < 0.0f) {
                ns = " S";
            }
            if (sxx.val < 0.0f || syy.val < 0.0f) {
                pwOut.printf(" Final location estimate:\n", new Object[0]);
                pwOut.printf("      Latitude:%9.3f deg.%2s\n", Float.valueOf(Math.abs(alat.val)), ns);
                pwOut.printf("     Longitude:%9.3f deg.%2s\n", Float.valueOf(Math.abs(alon.val)), ew);
            } else {
                pwOut.printf(" Final location estimate (+/- S.D.):\n", new Object[0]);
                pwOut.printf("      Latitude:%9.3f deg.%2s +/- %9.3f km.\n", Float.valueOf(Math.abs(alat.val)), ns, Math.sqrt(syy.val));
                pwOut.printf("     Longitude:%9.3f deg.%2s +/- %9.3f km.\n", Float.valueOf(Math.abs(alon.val)), ew, Math.sqrt(sxx.val));
            }
            if (!fxdflg) {
                if (szz.val < 0.0f) {
                    pwOut.printf("         Depth:%9.3f km.\n", Float.valueOf(zfoc.val));
                } else {
                    pwOut.printf("         Depth:%9.3f  km.   +/- %9.3f km.\n", Float.valueOf(zfoc.val), Math.sqrt(szz.val));
                }
            } else {
                pwOut.printf("         Depth:%9.3f  km.   +/- %9.3f km. (Fixed)\n", Float.valueOf(zfoc.val), 0.0);
            }
            if (stt.val < 0.0f) {
                pwOut.printf(" Relative O.T.:%9.3f sec.\n", Float.valueOf(torg.val));
                pwOut.printf(" Absolute O.T.:%9.3f sec.\n", torgd);
            } else {
                pwOut.printf(" Relative O.T.:%9.3f sec.   +/- %9.3f sec.\n", Float.valueOf(torg.val), Math.sqrt(stt.val));
                pwOut.printf(" Absolute O.T.:%14.3f s +/- %9.3f sec.\n", torgd, Math.sqrt(stt.val));
            }
            Date orig = new Date((long)(torgd * 1000.0));
            pwOut.printf("              :%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL\n", orig);
            pwOut.printf("\n Confidence region at %4.2f level:\n", Float.valueOf(pconf));
            pwOut.printf("   Semi-major axis:%8.1f  km. =%6.2f deg.\n", Float.valueOf(epmaj.val), (double)epmaj.val * 0.00899322);
            pwOut.printf("   Semi-minor axis:%8.1f  km. =%6.2f deg.\n", Float.valueOf(epmin.val), (double)epmin.val * 0.00899322);
            pwOut.printf(" Major-axis strike:%8.1f deg. clockwise from North\n", Float.valueOf(epstr.val));
            if (!fxdflg) {
                pwOut.printf("       Depth error:%8.1f  km.\n", Float.valueOf(zfint.val));
            }
            pwOut.printf("  Orig. time error:%8.1f sec.\n\n", Float.valueOf(toint.val));
            pwOut.printf(" Standard errors (sigma):\n", new Object[0]);
            pwOut.printf("              Prior:%6.2f (%6d deg. of freedom)\n", Float.valueOf(sig0.val), ndf0);
            pwOut.printf("          Posterior:%6.2f (%6d deg. of freedom)\n", Float.valueOf(sighat.val), ndf.val);
            pwOut.printf("          Posterior:%6.2f (Normalized sample S.D.)\n\n", Float.valueOf(snssd.val));
            pwOut.printf("      Azimuthal weighting: %5.2f\n Effective rank of matrix: %5.2f\n", Float.valueOf(azwt.val), rank.val);
            pwOut.printf("    Maximum azimuthal GAP: %4d deg.\n", igap.val);
            if (damp.val >= 0.0f) {
                pwOut.printf("         Percent damping: %12.8f\n", Float.valueOf(damp.val));
            }
            i = 1;
            while (i <= 19) {
                lprt[i - 1] = false;
                ++i;
            }
            n = 1;
            while (n <= ndata) {
                i = ipsta[n - 1];
                dist[n - 1] = stadel[i - 1];
                azim[n - 1] = staazi[i - 1];
                stadel[i - 1] = stadel[i - 1] + 1.0E-4f;
                ++n;
            }
            LocUtil.index_array(new intW(ndata), dist, indx);
            isave = 0;
            icnt = 1;
            n = 1;
            while (n <= ndata) {
                j = indx[n - 1];
                i = ipsta[j - 1];
                if (i != isave) {
                    if (icnt > 1 && itimes > 1) {
                        LocUtil.index_array(new intW(icnt), obs, indx2);
                        m = 1;
                        while (m <= icnt) {
                            indx[n - (icnt - m) - 1 - 1] = itdex[indx2[m - 1] - 1];
                            ++m;
                        }
                    }
                    itimes = 0;
                    icnt = 1;
                    itdex[0] = j;
                    obs[0] = dobs[j - 1];
                } else {
                    itdex[++icnt - 1] = j;
                    if (dtype[j - 1].equals("t")) {
                        obs[icnt - 1] = dobs[j - 1];
                        ++itimes;
                    } else {
                        obs[icnt - 1] = dtype[j - 1].equals("a") ? (double)(dobs[j - 1 - 1] + 1.0E-4f) : (double)(dobs[j - 2 - 1] + 2.0E-4f);
                    }
                }
                isave = i;
                ++n;
            }
            pwOut.printf("\n =======================================", new Object[0]);
            pwOut.printf("======================================= \n", new Object[0]);
            pwOut.printf("                       Data           Residuals    ", new Object[0]);
            pwOut.printf("Distance Azimuth   Data\n", new Object[0]);
            pwOut.printf(" Ariv ID Statn  Phase  Type at     True Normalized ", new Object[0]);
            pwOut.printf("  (deg.)  (deg.)  Import Err\n", new Object[0]);
            pwOut.printf(" =======================================", new Object[0]);
            pwOut.printf("======================================= \n", new Object[0]);
            n = 1;
            while (n <= ndata) {
                j = indx[n - 1];
                if (dtype[j - 1].equals("s")) {
                    j = indx[n - 1 - 1];
                } else if (dtype[j - 1].equals("a")) {
                    j = indx[n + 1 - 1];
                }
                if (dtype[j - 1].equals("s")) {
                    slodel = dobs[j - 1] - resid[j - 1];
                    slovecres = Math.pow((double)((float)Math.pow(dobs[j - 1], 2.0)) + Math.pow(slodel, 2.0) - (double)(2.0f * dobs[j - 1]) * slodel * Math.cos(0.0174532925239284 * (double)resid[j - 1 - 1]), 0.5);
                    pwOut.printf("Slowness Vector Residual:%8.3f\n", slovecres);
                }
                dsdnorm = resid[j - 1] != -999.0f ? (double)(resid[j - 1] / dsd[j - 1]) : -999.0;
                pwOut.printf("%8d %-6s %-7s%-4s  %1s%9.3f%11.3f%9.3f%8.2f%8.3f%4d\n", idarid[j - 1], dstaid[j - 1], dwavid[j - 1], dtype[j - 1], atype[j - 1], Float.valueOf(resid[j - 1]), dsdnorm, dist[j - 1], azim[j - 1], Float.valueOf(epimp[j - 1]), iderr[j - 1]);
                if (iderr[n - 1] > 0) {
                    lprt[iderr[n - 1] - 1] = true;
                }
                ++n;
            }
            pwOut.printf(" =======================================", new Object[0]);
            pwOut.printf("======================================= \n\n", new Object[0]);
            pwOut.printf("  =  0, No problem, normal interpolation\n", new Object[0]);
            if (lprt[0]) {
                pwOut.printf("  =  1, No station information", new Object[0]);
            }
            if (lprt[1]) {
                pwOut.printf("  =  2, No travel-time tables", new Object[0]);
            }
            if (lprt[2]) {
                pwOut.printf("  =  3, Data type unknown", new Object[0]);
            }
            if (lprt[3]) {
                pwOut.printf("  =  4, S.D. <= 0.0", new Object[0]);
            }
            if (lprt[10]) {
                pwOut.printf("  = 11, Distance-depth point (x0,z0) in hole of travel-time curve", new Object[0]);
            }
            if (lprt[11]) {
                pwOut.printf("  = 12, x0 < x(1)", new Object[0]);
            }
            if (lprt[12]) {
                pwOut.printf("  = 13, x0 > x(max)", new Object[0]);
            }
            if (lprt[13]) {
                pwOut.printf("  = 14, z0 < z(1)", new Object[0]);
            }
            if (lprt[14]) {
                pwOut.printf("  = 15, z0 > z(max)", new Object[0]);
            }
            if (lprt[15]) {
                pwOut.printf("  = 16, x0 < x(1) & z0 < z(1)", new Object[0]);
            }
            if (lprt[16]) {
                pwOut.printf("  = 17, x0 > x(max) & z0 < z(1)", new Object[0]);
            }
            if (lprt[17]) {
                pwOut.printf("  = 18, x0 < x(1) & z0 > z(max)", new Object[0]);
            }
            if (lprt[18]) {
                pwOut.printf("  = 19, x0 > x(max) & z0 > z(max)", new Object[0]);
            }
            i = 11;
            while (i <= 19) {
                if (lprt[i - 1]) {
                    pwOut.printf(" NOTE: If any of these codes are negative , then, \n", new Object[0]);
                    pwOut.printf("       use the datum to compute the event location!\n", new Object[0]);
                    break;
                }
                ++i;
            }
        }
    }
}

