/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.locsat3d;

import cn.org.gddsn.seis.location.locsat.LocSAT;
import cn.org.gddsn.seis.location.locsat.LocsatControl;
import cn.org.gddsn.seis.location.locsat.Phase;
import cn.org.gddsn.seis.location.locsat.PhaseDataHeader;
import cn.org.gddsn.seis.location.locsat3d.libloc.Locsat0;
import cn.org.gddsn.seis.location.locsat3d.libloc.TBTT3D;
import cn.org.gddsn.seis.regions.RegionsFE;
import cn.org.gddsn.util.Log4jConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;
import org.netlib.util.floatW;
import org.netlib.util.intW;

public class LocSAT3D {
    static Logger logger = Logger.getLogger(LocSAT3D.class);
    String dir;
    String[] phase_type_ptr;
    int num_phase_types;
    TBTT3D tbtt3d;
    boolean first_table_read = true;
    int len_dir;
    int extrap_distance;
    int extrap_depth;
    int extrap_in_hole;
    int num_sta;
    String net;
    int len_sta_id;
    String[] sta_id;
    float[] sta_lat;
    float[] sta_lon;
    float[] sta_elev;
    float[] sta_cor;
    boolean first_site_list = true;
    static String[] default_phases = new String[]{"Pn", "Pg", "PmP", "Sn", "Sg", "SmS"};

    public int setup_sites(String new_net, LocSAT.Site[] new_sites, int new_num_sta) {
        if (!this.first_site_list && new_net != null && this.net != null && new_net.equals(this.net)) {
            return 0;
        }
        if (new_net != null) {
            this.net = new String(new_net);
        }
        if (new_num_sta == 0 || new_sites == null) {
            logger.warn((Object)"Error setup_sites: Null station list");
            return 16;
        }
        this.first_site_list = false;
        this.num_sta = new_num_sta;
        this.len_sta_id = 7;
        this.sta_id = new String[this.num_sta];
        this.sta_lat = new float[this.num_sta];
        this.sta_lon = new float[this.num_sta];
        this.sta_cor = new float[this.num_sta];
        this.sta_elev = new float[this.num_sta];
        int i = 0;
        while (i < this.num_sta) {
            this.sta_id[i] = new_sites[i].sta;
            this.sta_lat[i] = new_sites[i].lat;
            this.sta_lon[i] = new_sites[i].lon;
            this.sta_elev[i] = new_sites[i].elev;
            this.sta_cor[i] = 0.0f;
            ++i;
        }
        return 0;
    }

    int setup_tttables3d(String new_dir, String prefix, String[] new_phase_types, int new_num_phase_types) {
        if (new_num_phase_types == 0 || new_phase_types == null) {
            logger.warn((Object)"Error setup_tttables: Null phase_type list");
            return 12;
        }
        if (!this.first_table_read && new_dir.equals(this.dir) && LocSAT.lstcmp(this.phase_type_ptr, new_phase_types)) {
            return 0;
        }
        this.first_table_read = false;
        this.dir = new String(new_dir);
        this.len_dir = this.dir.length();
        this.num_phase_types = new_num_phase_types;
        this.phase_type_ptr = new String[this.num_phase_types];
        int i = 0;
        while (i < this.num_phase_types) {
            this.phase_type_ptr[i] = new_phase_types[i];
            ++i;
        }
        this.tbtt3d = new TBTT3D();
        int ierr = this.tbtt3d.setup_tbtt3d(this.dir, prefix, this.phase_type_ptr, this.num_phase_types);
        if (ierr == 0) {
            return 0;
        }
        if (ierr == 1) {
            logger.warn((Object)"setup_tttables: Error opening travel-time tables");
            return 13;
        }
        if (ierr == 2) {
            logger.warn((Object)"setup_tttables: Error reading travel-time tables: Unexpected E-O-F");
            return 14;
        }
        logger.warn((Object)"setup_tttables: Unknown error reading travel-time tables");
        return 15;
    }

    public int locate_event(String network, LocSAT.Site[] sites, int num_sites, LocSAT.Arrival[] arrival, LocSAT.Assoc[] assoc, LocSAT.Origin origin, LocSAT.Origerr origerr, LocSAT.Locator_params locator_params, LocSAT.Locator_errors[] locator_errors, int num_obs) {
        floatW lat = new floatW(0.0f);
        floatW lon = new floatW(0.0f);
        floatW depth = new floatW(0.0f);
        floatW torg = new floatW(0.0f);
        floatW semi_major_axis = new floatW(0.0f);
        floatW semi_minor_axis = new floatW(0.0f);
        floatW strike = new floatW(0.0f);
        floatW sxx = new floatW(0.0f);
        floatW syy = new floatW(0.0f);
        floatW szz = new floatW(0.0f);
        floatW stt = new floatW(0.0f);
        floatW sxy = new floatW(0.0f);
        floatW sxz = new floatW(0.0f);
        floatW syz = new floatW(0.0f);
        floatW stx = new floatW(0.0f);
        floatW sty = new floatW(0.0f);
        floatW stz = new floatW(0.0f);
        floatW sighat = new floatW(0.0f);
        floatW snssd = new floatW(0.0f);
        intW ndf = new intW(0);
        floatW depth_error = new floatW(0.0f);
        floatW origin_time_error = new floatW(0.0f);
        intW igap = new intW(0);
        intW niter = new intW(0);
        intW ierr = new intW(0);
        floatW lat_init = new floatW(0.0f);
        floatW lon_init = new floatW(0.0f);
        floatW depth_init = new floatW(0.0f);
        floatW fixing_depth = new floatW(0.0f);
        floatW est_std_error = new floatW(0.0f);
        floatW azimuth_wt = new floatW(0.0f);
        floatW damp = new floatW(0.0f);
        PrintWriter pwOut = null;
        boolean error_found = false;
        int loc_err = this.setup_sites(network, sites, num_sites);
        if (loc_err != 0) {
            logger.warn((Object)"locate_event: Aborting location process");
            return loc_err;
        }
        if (this.first_table_read) {
            String new_dir = new File(locator_params.prefix).getParent();
            int new_num_phase_types = default_phases.length;
            String[] new_phase_types = default_phases;
            loc_err = this.setup_tttables3d(new_dir, new File(locator_params.prefix).getName(), new_phase_types, new_num_phase_types);
            if (loc_err != 0) {
                return loc_err;
            }
        }
        if (num_obs == 0 || arrival == null) {
            logger.warn((Object)"Warning locate_event: No observations to process");
            return 7;
        }
        if (assoc == null) {
            logger.warn((Object)"Error locate_event: Bad assoc data");
            return 8;
        }
        if (origin == null) {
            logger.warn((Object)"Error locate_event: Bad origin pointer");
            return 9;
        }
        if (origerr == null) {
            logger.warn((Object)"Error locate_event: Bad origerr pointer");
            return 10;
        }
        int i = 0;
        while (i < num_obs) {
            if (arrival[i].arid != assoc[i].arid) {
                logger.warn((Object)"Error locate_event: Mismatch between arrival/assoc.");
                return 11;
            }
            ++i;
        }
        lat_init.val = locator_params.lat_init;
        lon_init.val = locator_params.lon_init;
        depth_init.val = locator_params.depth_init;
        est_std_error.val = locator_params.est_std_error;
        int num_dof = locator_params.num_dof;
        float conf_level = locator_params.conf_level;
        damp.val = locator_params.damp;
        int max_iterations = locator_params.max_iterations;
        boolean fix_depth = locator_params.fix_depth;
        boolean verbose = locator_params.verbose;
        String outfile_name = locator_params.outfile_name;
        fixing_depth.val = locator_params.fixing_depth;
        lat_init.val = origin.lat;
        lon_init.val = origin.lon;
        if (!locator_params.use_location) {
            lon_init.val = -999.0f;
            lat_init.val = -999.0f;
        }
        if (fix_depth) {
            depth_init.val = fixing_depth.val;
        }
        int max_data = 3 * num_obs;
        String[] data_phase_type = new String[max_data];
        String[] data_sta_id = new String[max_data];
        String[] data_type = new String[max_data];
        String[] data_defining = new String[max_data];
        float[] obs_data = new float[max_data];
        float[] data_std_err = new float[max_data];
        int[] data_arrival_id_index = new int[max_data];
        int[] obs_data_index = new int[max_data];
        float[] sta_delta = new float[this.num_sta];
        float[] sta_azimuth = new float[this.num_sta];
        float[] sta_back_azimuth = new float[this.num_sta];
        float[] data_importances = new float[max_data];
        float[] zfimp = new float[max_data];
        float[] data_residual = new float[max_data];
        int[] sta_index = new int[max_data];
        int[] data_err_code = new int[max_data];
        i = 0;
        while (!LocSAT.VALID_TIME(arrival[i].time) && i < num_obs) {
            ++i;
        }
        double time_offset = i < num_obs ? arrival[i].time : 0.0;
        i = 0;
        while (i < num_obs) {
            if (LocSAT.VALID_TIME(arrival[i].time)) {
                time_offset = Math.min(time_offset, arrival[i].time);
            }
            ++i;
        }
        i = 0;
        int num_data = 0;
        while (i < num_obs) {
            data_arrival_id_index[num_data] = arrival[i].arid;
            data_sta_id[num_data] = arrival[i].sta;
            data_type[num_data] = "t";
            data_defining[num_data] = assoc[i].timedef;
            data_phase_type[num_data] = assoc[i].phase;
            obs_data[num_data] = (float)(arrival[i].time - time_offset);
            data_std_err[num_data] = arrival[i].deltim;
            obs_data_index[num_data] = i;
            ++num_data;
            if (LocSAT.VALID_SEAZ(arrival[i].azimuth)) {
                data_arrival_id_index[num_data] = arrival[i].arid;
                data_sta_id[num_data] = arrival[i].sta;
                data_type[num_data] = "a";
                data_defining[num_data] = assoc[i].azdef;
                data_phase_type[num_data] = assoc[i].phase;
                obs_data[num_data] = arrival[i].azimuth;
                data_std_err[num_data] = arrival[i].delaz;
                obs_data_index[num_data] = i;
                ++num_data;
            }
            if (LocSAT.VALID_SLOW(arrival[i].slow)) {
                data_arrival_id_index[num_data] = arrival[i].arid;
                data_sta_id[num_data] = arrival[i].sta;
                data_type[num_data] = "s";
                data_defining[num_data] = assoc[i].slodef;
                data_phase_type[num_data] = assoc[i].phase;
                obs_data[num_data] = arrival[i].slow;
                data_std_err[num_data] = arrival[i].delslo;
                obs_data_index[num_data] = i;
                ++num_data;
            }
            ++i;
        }
        if (verbose) {
            try {
                pwOut = new PrintWriter(new FileWriter(outfile_name));
            }
            catch (IOException ioEx) {
                verbose = false;
                logger.warn((Object)("Could not open " + outfile_name));
            }
        }
        Locsat0.locsat0(data_sta_id, data_phase_type, data_type, data_defining, obs_data, data_std_err, data_arrival_id_index, num_data, this.sta_id, this.sta_lat, this.sta_lon, this.sta_elev, this.sta_cor, this.num_sta, this.tbtt3d, time_offset, lat_init, lon_init, depth_init, est_std_error, num_dof, conf_level, azimuth_wt, damp, max_iterations, verbose, fix_depth, outfile_name, pwOut, lat, lon, depth, torg, sighat, snssd, ndf, semi_major_axis, semi_minor_axis, strike, depth_error, origin_time_error, sxx, syy, szz, stt, sxy, sxz, syz, stx, sty, stz, sta_delta, sta_azimuth, sta_back_azimuth, data_importances, zfimp, data_residual, sta_index, data_err_code, igap, niter, ierr);
        if (verbose) {
            pwOut.close();
        }
        if (ierr.val == 6) {
            logger.warn((Object)"locate_event: Error 6 from locsat0: SVD routine can't decompose matrix\n");
        } else if (ierr.val == 5) {
            logger.warn((Object)"locate_event: Error 5 from locsat0: Insufficient data for a solution\n");
        } else if (ierr.val == 4) {
            logger.warn((Object)"locate_event: Error 4 from locsat0: Too few data to constrain O.T.\n");
        } else if (ierr.val == 3) {
            logger.warn((Object)"locate_event: Error 3 from locsat0: Too few usable data\n");
        } else if (ierr.val == 2) {
            logger.warn((Object)"locate_event: Error 2 from locsat0: Solution did not converge\n");
        } else if (ierr.val == 1) {
            logger.warn((Object)"locate_event: Error 1 from locsat0: Exceeded maximum iterations\n");
        } else {
            int j;
            if (Float.isNaN(lat.val) || Float.isNaN(lon.val) || Float.isNaN(depth.val)) {
                logger.warn((Object)"locate_event: SVD routine can't decompose matrix, SVD return NaN\n");
                ierr.val = 6;
                return ierr.val;
            }
            origin.lat = lat.val;
            origin.lon = lon.val;
            origin.depth = depth.val;
            origin.algorithm = "LocSAT";
            origin.auth = "Locator:";
            String user = System.getenv("USER");
            if (user != null) {
                origin.auth = String.valueOf(origin.auth) + user;
            }
            origin.grn = RegionsFE.getFeGeoRegionNum(lat.val, lon.val);
            origin.igap = igap.val;
            origerr.sdobs = sighat.val;
            origerr.sxx = sxx.val;
            origerr.syy = syy.val;
            origerr.szz = szz.val;
            origerr.sxy = sxy.val;
            origerr.sxz = sxz.val;
            origerr.syz = syz.val;
            origerr.stt = stt.val;
            origerr.stx = stx.val;
            origerr.sty = sty.val;
            origerr.stz = stz.val;
            origerr.smajax = semi_major_axis.val;
            origerr.sminax = semi_minor_axis.val;
            origerr.stime = origin_time_error.val;
            origerr.sdepth = depth_error.val;
            if ((double)strike.val < 0.0 && (double)strike.val != -1.0) {
                while ((double)strike.val < 0.0) {
                    strike.val += 180.0f;
                }
            }
            origerr.strike = strike.val;
            if (ierr.val == 4) {
                logger.warn((Object)"locate_event: Error 4 from locsta0: Unconstrained origin time");
                origin.time = -9.999999999999E9;
                origerr.stt = stt.val;
                origerr.stx = stx.val;
                origerr.sty = sty.val;
                origerr.stz = stz.val;
            } else if (ierr.val == 0) {
                origin.time = (double)torg.val + time_offset;
            }
            i = 0;
            while (i < num_data) {
                j = obs_data_index[i];
                locator_errors[j].arid = data_arrival_id_index[i];
                if (data_type[i].equals("t")) {
                    if (ierr.val != 4) {
                        assoc[j].timeres = data_residual[i];
                        locator_errors[j].time = data_err_code[i];
                        if (data_err_code[i] != 0) {
                            error_found = true;
                            assoc[j].timedef = "n";
                        }
                    }
                    assoc[j].azres = -999.0f;
                    assoc[j].slores = -999.0f;
                } else if (data_type[i].equals("a")) {
                    assoc[j].azres = data_residual[i];
                    locator_errors[j].az = data_err_code[i];
                    if (data_err_code[i] != 0) {
                        error_found = true;
                        assoc[j].azdef = "n";
                    }
                } else if (data_type[i].equals("s")) {
                    assoc[j].slores = data_residual[i];
                    locator_errors[j].slow = data_err_code[i];
                    if (data_err_code[i] != 0) {
                        error_found = true;
                        assoc[j].slodef = "n";
                    }
                }
                if (error_found) {
                    locator_errors[j].arid = assoc[j].arid;
                    error_found = false;
                }
                ++i;
            }
            i = 0;
            while (i < num_data) {
                j = obs_data_index[i];
                int k = sta_index[i] - 1;
                assoc[j].delta = sta_delta[k];
                assoc[j].seaz = sta_back_azimuth[k];
                assoc[j].esaz = sta_azimuth[k];
                ++i;
            }
            i = 0;
            j = 0;
            while (i < num_obs) {
                if (assoc[i].timedef.equals("d")) {
                    ++j;
                }
                ++i;
            }
            origin.ndef = j;
            origin.nass = i;
        }
        return ierr.val;
    }

    int find_phase(String phase) {
        int n = -1;
        int i = 0;
        while (i < this.num_phase_types) {
            if (phase.equals(this.phase_type_ptr[i])) {
                n = i;
                break;
            }
            ++i;
        }
        return n;
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain((String)"LocSAT.properties");
        LocSAT3D.main0(args);
    }

    public static void main0(String[] args) throws Exception {
        LocSAT3D locSAT3D = new LocSAT3D();
        String outFile = "out";
        String staFile = "sta";
        String inFile = "in";
        String ctlFile = "ctl";
        Options options = new Options();
        Option help = new Option("h", "print this message");
        OptionBuilder.withArgName((String)"Control filename");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"contains information on how to perform the location");
        Option ctl = OptionBuilder.create((String)"c");
        OptionBuilder.withArgName((String)"Station filename");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"contains station information");
        Option sta = OptionBuilder.create((String)"s");
        OptionBuilder.withArgName((String)"Data filename");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"contains observed phase data");
        Option in = OptionBuilder.create((String)"d");
        OptionBuilder.withArgName((String)"Output  filename");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"contains location result");
        Option out = OptionBuilder.create((String)"o");
        options.addOption(help).addOption(ctl).addOption(sta).addOption(in).addOption(out);
        BasicParser parser = new BasicParser();
        CommandLine cmd = parser.parse(options, args);
        if (args.length == 0 || cmd.hasOption(help.getOpt())) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -cp LocSAT.jar cn.org.gddsn.seis.location.locsat3d.LocSAT3D", options);
            System.exit(-1);
        }
        if (cmd.hasOption(ctl.getOpt())) {
            ctlFile = cmd.getOptionValue(ctl.getOpt());
        }
        if (cmd.hasOption(sta.getOpt())) {
            staFile = cmd.getOptionValue(sta.getOpt());
        }
        if (cmd.hasOption(in.getOpt())) {
            inFile = cmd.getOptionValue(in.getOpt());
        }
        if (cmd.hasOption(out.getOpt())) {
            outFile = cmd.getOptionValue(out.getOpt());
        }
        LocSAT.Site[] sites = new LocSAT.Site[1500];
        LocSAT.Locator_params locator_params = new LocSAT.Locator_params();
        LocSAT.Origerr origerr = new LocSAT.Origerr();
        LocSAT.Origin origin = new LocSAT.Origin();
        String newnet = null;
        int num_obs = 0;
        int num_data = 0;
        int num_sta = 0;
        locator_params.outfile_name = outFile;
        LocsatControl locsatCtl = new LocsatControl();
        locsatCtl.parse(new File(ctlFile));
        locator_params.prefix = String.valueOf(locsatCtl.getDirTT()) + File.separator + locsatCtl.getPrefixTT();
        locator_params.cor_level = 0;
        locator_params.fix_depth = locsatCtl.isFixDepth();
        locator_params.verbose = locsatCtl.isVerbose();
        locator_params.conf_level = (float)locsatCtl.getConfidenceLevel();
        locator_params.damp = (float)locsatCtl.getDamp();
        locator_params.est_std_error = (float)locsatCtl.getEst_std_err();
        locator_params.num_dof = locsatCtl.getNum_dof();
        locator_params.max_iterations = locsatCtl.getMaxIterations();
        locator_params.use_location = locsatCtl.isUseLocation();
        BufferedReader br = new BufferedReader(new FileReader(staFile));
        num_sta = 0;
        String line = null;
        StringTokenizer st = null;
        while ((line = br.readLine()) != null) {
            sites[num_sta] = new LocSAT.Site();
            st = new StringTokenizer(line);
            sites[num_sta].sta = st.nextToken();
            sites[num_sta].lat = Float.parseFloat(st.nextToken());
            sites[num_sta].lon = Float.parseFloat(st.nextToken());
            sites[num_sta].elev = Float.parseFloat(st.nextToken());
            ++num_sta;
        }
        if (num_sta >= 1500) {
            logger.warn((Object)"Number of stations greater than dimension 1500 remaining Stations ignored!");
        }
        br.close();
        br = new BufferedReader(new FileReader(inFile));
        while (true) {
            long now = System.currentTimeMillis();
            PhaseDataHeader pd = new PhaseDataHeader();
            line = br.readLine();
            if (line == null) {
                br.close();
                return;
            }
            pd.parse(line);
            locator_params.lat_init = pd.getLatInit();
            locator_params.lon_init = pd.getLonInit();
            locator_params.depth_init = pd.getDepthInit();
            num_data = pd.getNumData();
            double origin_time_init = pd.getOriginTimeInit();
            origin.lat = locator_params.lat_init;
            origin.lon = locator_params.lon_init;
            origin.depth = locator_params.depth_init;
            origerr.sdobs = -1.0f;
            origerr.smajax = -1.0f;
            origerr.sminax = -1.0f;
            origerr.strike = -1.0f;
            origerr.stime = -1.0f;
            origerr.sdepth = -1.0f;
            origerr.sxx = -1.0f;
            origerr.sxz = -1.0f;
            origerr.syz = -1.0f;
            origerr.syy = -1.0f;
            origerr.szz = -1.0f;
            origerr.sxy = -1.0f;
            origerr.stt = -1.0f;
            origerr.stx = -1.0f;
            origerr.sty = -1.0f;
            origerr.stz = -1.0f;
            LocSAT.Arrival[] arrival = new LocSAT.Arrival[num_data];
            LocSAT.Assoc[] assoc = new LocSAT.Assoc[num_data];
            LocSAT.Locator_errors[] locator_errors = new LocSAT.Locator_errors[num_data];
            int i = 0;
            while (i < num_data) {
                arrival[i] = new LocSAT.Arrival();
                assoc[i] = new LocSAT.Assoc();
                locator_errors[i] = new LocSAT.Locator_errors();
                ++i;
            }
            assoc[0].orid = 90000001;
            locator_params.fixing_depth = locator_params.depth_init;
            num_obs = 0;
            int n = 0;
            while ((line = br.readLine()) != null && n < num_data) {
                Phase ph = new Phase();
                ph.parse(line);
                if (ph.getDataType().equals("t")) {
                    if (n != 0) {
                        ++num_obs;
                    }
                    arrival[num_obs].time = origin_time_init + (double)ph.getDatum();
                    arrival[num_obs].azimuth = -1.0f;
                    arrival[num_obs].slow = -1.0f;
                    arrival[num_obs].deltim = ph.getStdErr();
                    assoc[num_obs].timedef = ph.getArrivalType();
                } else if (ph.getDataType().equals("a")) {
                    arrival[num_obs].azimuth = ph.getDatum();
                    arrival[num_obs].delaz = ph.getStdErr();
                    assoc[num_obs].azdef = ph.getArrivalType();
                } else if (ph.getDataType().equals("s")) {
                    arrival[num_obs].slow = ph.getDatum();
                    arrival[num_obs].delslo = ph.getStdErr();
                    assoc[num_obs].slodef = ph.getArrivalType();
                }
                arrival[num_obs].arid = ph.getId();
                assoc[num_obs].arid = ph.getId();
                arrival[num_obs].sta = ph.getStationCode();
                assoc[num_obs].sta = ph.getStationCode();
                assoc[num_obs].phase = ph.getPhase();
                ++n;
            }
            ++num_obs;
            if (n >= 1500) {
                logger.warn((Object)"Number of data greater than dimension: 1500, remaining Data ignored!");
            }
            int status = locSAT3D.locate_event(newnet, sites, num_sta, arrival, assoc, origin, origerr, locator_params, locator_errors, num_obs);
            ++status;
            --status;
            Date date = new Date((long)(origin.time * 1000.0));
            System.out.printf("Origin time: %1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL\n\n", date);
            System.out.println("locsat time: " + (System.currentTimeMillis() - now));
        }
    }
}

