/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.locsat;

import cn.org.gddsn.seis.location.StationMapping;
import java.util.Date;
import java.util.Formatter;
import java.util.StringTokenizer;

public class Phase {
    private int id;
    private String stationCode;
    private String phase;
    private String dataType;
    private String arrivalType;
    private float datum;
    private float stdErr;

    public void parse(Date origin, int arrivalId, cn.org.gddsn.seis.Phase p, StationMapping smap) {
        this.parse((double)origin.getTime() / 1000.0, arrivalId, p, smap);
    }

    public void parse(double origin, int arrivalId, cn.org.gddsn.seis.Phase p, StationMapping smap) {
        this.id = arrivalId;
        this.stationCode = smap == null || smap.getStation(p.getNetCode(), p.getStationCode()) == null ? p.getStationCode() : smap.getStation(p.getNetCode(), p.getStationCode());
        this.phase = p.getPhaseName();
        this.dataType = "t";
        this.arrivalType = p.getWeight() == 1 ? "d" : "n";
        this.datum = (float)((double)p.getPhaseTime().getTime() / 1000.0 - origin);
        this.stdErr = 1.0f;
    }

    public void parse(String buf) {
        StringTokenizer st = new StringTokenizer(buf);
        this.id = Integer.parseInt(st.nextToken().trim());
        this.stationCode = st.nextToken().trim();
        this.phase = st.nextToken().trim();
        this.dataType = st.nextToken().trim();
        this.arrivalType = st.nextToken().trim();
        this.datum = Float.parseFloat(st.nextToken().trim());
        this.stdErr = Float.parseFloat(st.nextToken().trim());
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("%1$8d %2$-6s %3$-8s %4$-4s%5$2s%6$14.3f%7$8.3f", this.id, this.stationCode, this.phase, this.dataType, this.arrivalType, Float.valueOf(this.datum), Float.valueOf(this.stdErr));
        return sb.substring(0);
    }

    public String getArrivalType() {
        return this.arrivalType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public float getDatum() {
        return this.datum;
    }

    public int getId() {
        return this.id;
    }

    public String getPhase() {
        return this.phase;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public float getStdErr() {
        return this.stdErr;
    }
}

