/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.ISCPha;
import cn.org.gddsn.seis.location.iscloc2.ISCSol;
import cn.org.gddsn.seis.location.iscloc2.Utils;
import org.apache.log4j.Logger;

public class Uncertainty {
    static Logger logger = Logger.getLogger(Uncertainty.class);
    static int[] ns = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 40, 60, 120, 99999};
    static double[] ps = new double[]{0.9, 0.95, 0.99};
    private static final int MAX_TAB = 34;
    private static final int MAX_P = 3;
    static double[][][] xs = new double[][][]{new double[][]{{39.86, 8.53, 5.54, 4.54, 4.06, 3.78, 3.59, 3.46, 3.36, 3.29, 3.23, 3.18, 3.14, 3.1, 3.07, 3.05, 3.03, 3.01, 2.99, 2.97, 2.96, 2.95, 2.94, 2.93, 2.92, 2.91, 2.9, 2.89, 2.89, 2.88, 2.84, 2.79, 2.75, 2.71}, {49.5, 9.0, 5.46, 4.32, 3.78, 3.46, 3.26, 3.11, 3.01, 2.92, 2.86, 2.81, 2.76, 2.73, 2.7, 2.67, 2.64, 2.62, 2.61, 2.59, 2.57, 2.56, 2.55, 2.54, 2.53, 2.52, 2.51, 2.5, 2.5, 2.49, 2.44, 2.39, 2.35, 2.3}, {53.59, 9.16, 5.39, 4.19, 3.62, 3.29, 3.07, 2.92, 2.81, 2.73, 2.66, 2.61, 2.56, 2.52, 2.49, 2.46, 2.44, 2.42, 2.4, 2.38, 2.36, 2.35, 2.34, 2.33, 2.32, 2.31, 2.3, 2.29, 2.28, 2.28, 2.23, 2.18, 2.13, 2.08}}, new double[][]{{161.4, 18.51, 10.13, 7.71, 6.61, 5.99, 5.59, 5.32, 5.12, 4.96, 4.84, 4.75, 4.67, 4.6, 4.54, 4.49, 4.45, 4.41, 4.38, 4.35, 4.32, 4.3, 4.28, 4.26, 4.24, 4.23, 4.21, 4.2, 4.18, 4.17, 4.08, 4.0, 3.92, 3.84}, {199.5, 19.0, 9.55, 6.94, 5.79, 5.14, 4.74, 4.46, 4.26, 4.1, 3.98, 3.89, 3.81, 3.74, 3.68, 3.63, 3.59, 3.55, 3.52, 3.49, 3.47, 3.44, 3.42, 3.4, 3.39, 3.37, 3.35, 3.34, 3.33, 3.32, 3.23, 3.15, 3.07, 3.0}, {215.7, 19.16, 9.28, 6.59, 5.41, 4.76, 4.35, 4.07, 3.86, 3.71, 3.59, 3.49, 3.41, 3.34, 3.29, 3.24, 3.2, 3.16, 3.13, 3.1, 3.07, 3.05, 3.03, 3.01, 2.99, 2.98, 2.96, 2.95, 2.93, 2.92, 2.84, 2.76, 2.68, 2.6}}, new double[][]{{4052.0, 98.5, 34.12, 21.2, 16.26, 13.75, 12.25, 11.26, 10.56, 10.04, 9.65, 9.33, 9.07, 8.86, 8.68, 8.53, 8.4, 8.29, 8.18, 8.1, 8.02, 7.95, 7.88, 7.82, 7.77, 7.72, 7.68, 7.64, 7.6, 7.56, 7.31, 7.08, 6.85, 6.63}, {4999.5, 99.0, 30.82, 18.0, 13.27, 10.92, 9.55, 8.65, 8.02, 7.56, 7.21, 6.93, 6.7, 6.51, 6.36, 6.23, 6.11, 6.01, 5.93, 5.85, 5.78, 5.72, 5.66, 5.61, 5.57, 5.53, 5.49, 5.45, 5.42, 5.39, 5.18, 4.98, 4.79, 4.61}, {5403.0, 99.17, 29.46, 16.69, 12.06, 9.78, 8.45, 7.59, 6.99, 6.55, 6.22, 5.95, 5.74, 5.56, 5.42, 5.29, 5.18, 5.09, 5.01, 4.94, 4.87, 4.82, 4.76, 4.72, 4.68, 4.64, 4.6, 4.57, 4.54, 4.51, 4.31, 4.13, 3.95, 3.78}}};

    private Uncertainty() {
    }

    public static int calc_error(ISCSol sp, ISCPha[] p) {
        double fs = 0.0;
        double scale_fact = 0.0;
        double conf = Config.confidence / 100.0;
        double ndf = 0.0;
        double b = 0.0;
        double d = 0.0;
        double eigen1 = 0.0;
        double eigen2 = 0.0;
        double ssq = 0.0;
        double sigmahat = 0.0;
        double sxx = 0.0;
        double sxy = 0.0;
        double syy = 0.0;
        double strike = 0.0;
        int npha = 0;
        int used = 0;
        int totndf = 0;
        int k = 0;
        String prev_sta = "";
        sp.ndefsta = 0;
        sp.nass = 0;
        int i = 0;
        while (i < sp.numphas) {
            npha = 0;
            used = 0;
            int j = i;
            while (j < sp.numphas) {
                if (p[j].purged == 0) {
                    if (p[j].rdid != p[i].rdid) break;
                    ++npha;
                    if (p[j].timedef) {
                        ++used;
                    }
                }
                ++j;
            }
            sp.nass += npha;
            if (used != 0 && !p[i].prista.equals(prev_sta)) {
                prev_sta = p[i].prista;
                ++sp.ndefsta;
            }
            i += npha;
        }
        if (Config.verbose > 0) {
            logger.info((Object)String.format("\tcalc_error: nreading=%d nass=%d ndefsta=%d ndef=%d", sp.nreading, sp.nass, sp.ndefsta, sp.ndef));
        }
        totndf = Math.max(sp.ndef - sp.number_of_unknowns, 1);
        sp.sdobs = sp.urms * Utils.Sqrt((double)sp.ndef / (double)totndf);
        k = 99999;
        totndf = sp.prank - sp.number_of_unknowns + k;
        ssq = sp.wrms * sp.wrms * (double)sp.ndef + (double)k;
        ndf = totndf;
        if (Math.abs(ndf) < 1.0E-8) {
            ndf = 0.001;
        }
        if (Math.abs((double)totndf - ssq) < 1.0E-5) {
            ndf = ssq;
        }
        sigmahat = Utils.Sqrt(ssq / ndf);
        fs = Uncertainty.Ftest(1, totndf, conf);
        scale_fact = Utils.Sqrt(fs) * sigmahat;
        i = 0;
        while (i < 4) {
            if (sp.covar[i][i] != 9999999.0) {
                sp.error[i] = scale_fact * Utils.Sqrt(sp.covar[i][i]);
            }
            ++i;
        }
        if (sp.error[1] != 9999999.0) {
            sp.error[1] = sp.error[1] / 111.19492664455873;
        }
        if (sp.error[2] != 9999999.0) {
            sp.error[2] = sp.error[2] / 111.19492664455873;
        }
        if (sp.epifix) {
            return 0;
        }
        sxx = sp.covar[1][1];
        sxy = sp.covar[1][2];
        syy = sp.covar[2][2];
        b = sxx + syy;
        d = Utils.Sqrt(b * b - 4.0 * (sxx * syy - sxy * sxy));
        eigen1 = Math.abs((b + d) / 2.0);
        eigen2 = Math.abs((b - d) / 2.0);
        strike = 0.5 * Math.atan2(2.0 * sxy, syy - sxx);
        if (strike < 0.0) {
            strike += Math.PI * 2;
        }
        if (strike > Math.PI * 2) {
            strike -= Math.PI * 2;
        }
        if (strike > Math.PI) {
            strike -= Math.PI;
        }
        sp.strike = 57.29577951308232 * strike;
        fs = Uncertainty.Ftest(2, totndf, conf);
        scale_fact = Utils.Sqrt(2.0 * fs) * sigmahat;
        sp.smajax = Utils.Sqrt(eigen1) * scale_fact;
        sp.sminax = Utils.Sqrt(eigen2) * scale_fact;
        return 0;
    }

    private static double Ftest(int m, int n, double conf) {
        int ip = 0;
        int j = 0;
        double an = 0.0;
        double an1 = 0.0;
        double an2 = 0.0;
        double x1 = 0.0;
        double x2 = 0.0;
        double y = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double x = 0.0;
        if (m < 1 || m > 3) {
            return x;
        }
        if (n < 1) {
            x = 1000.0;
            return x;
        }
        int i = 0;
        while (i < 3) {
            if (Math.abs(conf - ps[i]) < 0.001) {
                ip = i;
            }
            ++i;
        }
        i = 33;
        while (i >= 0) {
            if (n >= ns[i]) {
                j = i;
                break;
            }
            --i;
        }
        if (n == ns[j] || j == 33) {
            x = xs[ip][m - 1][j];
        } else {
            an1 = ns[j];
            an2 = ns[j + 1];
            an = n;
            y1 = an1 / (1.0 + an1);
            y2 = an2 / (1.0 + an2);
            y = an / (1.0 + an);
            x1 = xs[ip][m - 1][j];
            x2 = xs[ip][m - 1][j + 1];
            x = x1 + (x2 - x1) * ((y - y1) / (y2 - y1));
        }
        return x;
    }
}

