/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.ISCPha;
import cn.org.gddsn.seis.location.iscloc2.Locator;
import cn.org.gddsn.seis.location.iscloc2.PhaseList;
import cn.org.gddsn.seis.location.iscloc2.Utils;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.netlib.lapack.DLAMCH;
import org.netlib.lapack.Dsyevr;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class SVD {
    static Logger logger = Logger.getLogger(SVD.class);

    private SVD() {
    }

    public static int svd_decompose(int n, int m, double[][] u, double[] sv, double[][] v) {
        int j;
        int k;
        boolean flag = false;
        int its = 0;
        int l = 0;
        int nm = 0;
        double anorm = 0.0;
        double c = 0.0;
        double f = 0.0;
        double g = 0.0;
        double h = 0.0;
        double s = 0.0;
        double scale = 0.0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double[] rv1 = new double[m];
        anorm = 0.0;
        scale = 0.0;
        g = 0.0;
        int i = 0;
        while (i < m) {
            l = i + 1;
            rv1[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < n) {
                k = i;
                while (k < n) {
                    scale += Math.abs(u[k][i]);
                    ++k;
                }
                if (scale != 0.0) {
                    k = i;
                    while (k < n) {
                        double[] dArray = u[k];
                        int n2 = i;
                        dArray[n2] = dArray[n2] / scale;
                        s += u[k][i] * u[k][i];
                        ++k;
                    }
                    f = u[i][i];
                    g = -SVD.sign(Math.sqrt(s), f);
                    h = f * g - s;
                    u[i][i] = f - g;
                    j = l;
                    while (j < m) {
                        s = 0.0;
                        k = i;
                        while (k < n) {
                            s += u[k][i] * u[k][j];
                            ++k;
                        }
                        f = s / h;
                        k = i;
                        while (k < n) {
                            double[] dArray = u[k];
                            int n3 = j;
                            dArray[n3] = dArray[n3] + f * u[k][i];
                            ++k;
                        }
                        ++j;
                    }
                    k = i;
                    while (k < n) {
                        double[] dArray = u[k];
                        int n4 = i;
                        dArray[n4] = dArray[n4] * scale;
                        ++k;
                    }
                }
            }
            sv[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < n && i != m - 1) {
                k = l;
                while (k < m) {
                    scale += Math.abs(u[i][k]);
                    ++k;
                }
                if (scale != 0.0) {
                    k = l;
                    while (k < m) {
                        double[] dArray = u[i];
                        int n5 = k;
                        dArray[n5] = dArray[n5] / scale;
                        s += u[i][k] * u[i][k];
                        ++k;
                    }
                    f = u[i][l];
                    g = -SVD.sign(Math.sqrt(s), f);
                    h = f * g - s;
                    u[i][l] = f - g;
                    k = l;
                    while (k < m) {
                        rv1[k] = u[i][k] / h;
                        ++k;
                    }
                    j = l;
                    while (j < n) {
                        s = 0.0;
                        k = l;
                        while (k < m) {
                            s += u[j][k] * u[i][k];
                            ++k;
                        }
                        k = l;
                        while (k < m) {
                            double[] dArray = u[j];
                            int n6 = k;
                            dArray[n6] = dArray[n6] + s * rv1[k];
                            ++k;
                        }
                        ++j;
                    }
                    k = l;
                    while (k < m) {
                        double[] dArray = u[i];
                        int n7 = k++;
                        dArray[n7] = dArray[n7] * scale;
                    }
                }
            }
            anorm = Math.max(anorm, Math.abs(sv[i]) + Math.abs(rv1[i]));
            ++i;
        }
        i = m - 1;
        while (i >= 0) {
            if (i < m - 1) {
                if (g != 0.0) {
                    j = l;
                    while (j < m) {
                        v[j][i] = u[i][j] / u[i][l] / g;
                        ++j;
                    }
                    j = l;
                    while (j < m) {
                        s = 0.0;
                        k = l;
                        while (k < m) {
                            s += u[i][k] * v[k][j];
                            ++k;
                        }
                        k = l;
                        while (k < m) {
                            double[] dArray = v[k];
                            int n8 = j;
                            dArray[n8] = dArray[n8] + s * v[k][i];
                            ++k;
                        }
                        ++j;
                    }
                }
                j = l;
                while (j < m) {
                    v[j][i] = 0.0;
                    v[i][j] = 0.0;
                    ++j;
                }
            }
            v[i][i] = 1.0;
            g = rv1[i];
            l = i--;
        }
        i = Math.min(m, n) - 1;
        while (i >= 0) {
            l = i + 1;
            g = sv[i];
            j = l;
            while (j < m) {
                u[i][j] = 0.0;
                ++j;
            }
            if (g != 0.0) {
                g = 1.0 / g;
                j = l;
                while (j < m) {
                    s = 0.0;
                    k = l;
                    while (k < n) {
                        s += u[k][i] * u[k][j];
                        ++k;
                    }
                    f = s / u[i][i] * g;
                    k = i;
                    while (k < n) {
                        double[] dArray = u[k];
                        int n9 = j;
                        dArray[n9] = dArray[n9] + f * u[k][i];
                        ++k;
                    }
                    ++j;
                }
                j = i;
                while (j < n) {
                    double[] dArray = u[j];
                    int n10 = i;
                    dArray[n10] = dArray[n10] * g;
                    ++j;
                }
            } else {
                j = i;
                while (j < n) {
                    u[j][i] = 0.0;
                    ++j;
                }
            }
            double[] dArray = u[i];
            int n11 = i--;
            dArray[n11] = dArray[n11] + 1.0;
        }
        k = m - 1;
        while (k >= 0) {
            its = 0;
            while (its < 30) {
                flag = true;
                l = k;
                while (l >= 0) {
                    nm = l - 1;
                    if (l == 0 || Math.abs(rv1[l]) < 1.0E-8) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(sv[nm]) < 1.0E-8) break;
                    --l;
                }
                if (flag) {
                    c = 0.0;
                    s = 1.0;
                    i = l;
                    while (i < k + 1) {
                        f = s * rv1[i];
                        rv1[i] = c * rv1[i];
                        if (Math.abs(f) < 1.0E-8) break;
                        g = sv[i];
                        sv[i] = h = SVD.pythag(f, g);
                        if (h > 1.0E-10) {
                            h = 1.0 / h;
                            c = g * h;
                            s = -f * h;
                        }
                        j = 0;
                        while (j < n) {
                            y = u[j][nm];
                            z = u[j][i];
                            u[j][nm] = y * c + z * s;
                            u[j][i] = z * c - y * s;
                            ++j;
                        }
                        ++i;
                    }
                }
                z = sv[k];
                if (l == k) {
                    if (!(z < 0.0)) break;
                    sv[k] = -z;
                    j = 0;
                    while (j < m) {
                        v[j][k] = -v[j][k];
                        ++j;
                    }
                    break;
                }
                if (its == 29) {
                    rv1 = null;
                    logger.info((Object)String.format("svd_decompose: max iteration reached!", new Object[0]));
                    return 2;
                }
                x = sv[l];
                nm = k - 1;
                y = sv[nm];
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = SVD.pythag(f, 1.0);
                f = ((x - z) * (x + z) + h * (y / (f + SVD.sign(g, f)) - h)) / x;
                s = 1.0;
                c = 1.0;
                j = l;
                while (j <= nm) {
                    i = j + 1;
                    g = rv1[i];
                    y = sv[i];
                    h = s * g;
                    g = c * g;
                    rv1[j] = z = SVD.pythag(f, h);
                    if (z > 1.0E-10) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    int jj = 0;
                    while (jj < m) {
                        x = v[jj][j];
                        z = v[jj][i];
                        v[jj][j] = x * c + z * s;
                        v[jj][i] = z * c - x * s;
                        ++jj;
                    }
                    sv[j] = z = SVD.pythag(f, h);
                    if (z > 1.0E-10) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    jj = 0;
                    while (jj < n) {
                        y = u[jj][j];
                        z = u[jj][i];
                        u[jj][j] = y * c + z * s;
                        u[jj][i] = z * c - y * s;
                        ++jj;
                    }
                    ++j;
                }
                rv1[l] = 0.0;
                rv1[k] = f;
                sv[k] = x;
                ++its;
            }
            --k;
        }
        rv1 = null;
        if (SVD.svd_reorder(n, m, u, sv, v) != 0) {
            return 1;
        }
        return 0;
    }

    private static int svd_reorder(int n, int m, double[][] u, double[] w, double[][] v) {
        int j;
        int k;
        int i;
        int inc = 1;
        double sw = 0.0;
        double[] su = new double[n];
        double[] sv = new double[m];
        do {
            inc *= 3;
        } while (++inc <= m);
        do {
            i = inc /= 3;
            while (i < m) {
                sw = w[i];
                k = 0;
                while (k < n) {
                    su[k] = u[k][i];
                    ++k;
                }
                k = 0;
                while (k < m) {
                    sv[k] = v[k][i];
                    ++k;
                }
                j = i;
                while (w[j - inc] < sw) {
                    w[j] = w[j - inc];
                    k = 0;
                    while (k < n) {
                        u[k][j] = u[k][j - inc];
                        ++k;
                    }
                    k = 0;
                    while (k < m) {
                        v[k][j] = v[k][j - inc];
                        ++k;
                    }
                    if ((j -= inc) < inc) break;
                }
                w[j] = sw;
                k = 0;
                while (k < n) {
                    u[k][j] = su[k];
                    ++k;
                }
                k = 0;
                while (k < m) {
                    v[k][j] = sv[k];
                    ++k;
                }
                ++i;
            }
        } while (inc > 1);
        k = 0;
        while (k < m) {
            int s = 0;
            i = 0;
            while (i < n) {
                if (u[i][k] < 0.0) {
                    ++s;
                }
                ++i;
            }
            j = 0;
            while (j < m) {
                if (v[j][k] < 0.0) {
                    ++s;
                }
                ++j;
            }
            if (s > (m + n) / 2) {
                i = 0;
                while (i < n) {
                    u[i][k] = -u[i][k];
                    ++i;
                }
                j = 0;
                while (j < m) {
                    v[j][k] = -v[j][k];
                    ++j;
                }
            }
            ++k;
        }
        sv = null;
        su = null;
        return 0;
    }

    private static double pythag(double a, double b) {
        double absb;
        double absa = Math.abs(a);
        if (absa > (absb = Math.abs(b))) {
            return absa * Math.sqrt(1.0 + Math.pow(absb / absa, 2.0));
        }
        if (absb < 1.0E-8) {
            return 0.0;
        }
        return absb * Math.sqrt(1.0 + Math.pow(absa / absb, 2.0));
    }

    private static double sign(double A, double B) {
        return B < 0.0 ? (A < 0.0 ? A : -A) : (A < 0.0 ? -A : A);
    }

    public static int svd_solve(int n, int m, double[][] u, double[] sv, double[][] v, double[] b, double[] x, double thres) {
        double s = 0.0;
        double tsh = 0.0;
        double[] tmp = new double[m];
        tsh = thres >= 0.0 ? thres : SVD.svd_threshold(n, m, sv);
        int j = 0;
        while (j < m) {
            s = 0.0;
            if (sv[j] > tsh) {
                int i = 0;
                while (i < n) {
                    s += u[i][j] * b[i];
                    ++i;
                }
                s /= sv[j];
            }
            tmp[j] = s;
            ++j;
        }
        j = 0;
        while (j < m) {
            s = 0.0;
            int jj = 0;
            while (jj < m) {
                s += v[j][jj] * tmp[jj];
                ++jj;
            }
            x[j] = s;
            ++j;
        }
        tmp = null;
        return 0;
    }

    public static void svd_model_covariance_matrix(int m, double thres, double[] sv, double[][] v, double[][] mcov) {
        int j;
        double s = 0.0;
        int i = 0;
        while (i < m) {
            j = 0;
            while (j < i + 1) {
                mcov[j][i] = 0.0;
                mcov[i][j] = 0.0;
                s = 0.0;
                int k = 0;
                while (k < m) {
                    if (sv[k] > thres) {
                        s += v[i][k] * v[j][k] / (sv[k] * sv[k]);
                    }
                    ++k;
                }
                double d = s;
                mcov[i][j] = d;
                mcov[j][i] = d;
                ++j;
            }
            ++i;
        }
        if (Config.verbose > 2) {
            logger.info((Object)String.format("        SV(%d) :", m));
            StringBuilder sb = new StringBuilder(128);
            sb.append("        ");
            i = 0;
            while (i < m) {
                sb.append(String.format("%12.5f ", sv[i]));
                ++i;
            }
            logger.info((Object)sb.substring(0));
            logger.info((Object)String.format("        V(%d x %d) matrix:", m, m));
            i = 0;
            while (i < m) {
                sb = new StringBuilder(128);
                sb.append(String.format("        ", new Object[0]));
                j = 0;
                while (j < m) {
                    sb.append(String.format("%12.5f ", v[i][j]));
                    ++j;
                }
                logger.info((Object)sb.substring(0));
                ++i;
            }
            logger.info((Object)String.format("        MCOV(%d x %d) matrix:", m, m));
            i = 0;
            while (i < m) {
                sb = new StringBuilder(128);
                sb.append(String.format("        ", new Object[0]));
                j = 0;
                while (j < m) {
                    sb.append(String.format("%12.5f ", mcov[i][j]));
                    ++j;
                }
                logger.info((Object)sb.substring(0));
                ++i;
            }
        }
    }

    public static double svd_threshold(int n, int m, double[] sv) {
        return 0.5 * Math.sqrt((double)(n + m) + 1.0) * sv[0] * 1.0E-8;
    }

    public static int svd_rank(int n, int m, double[] sv, double thres) {
        int nr = 0;
        double tsh = 0.0;
        tsh = thres >= 0.0 ? thres : SVD.svd_threshold(n, m, sv);
        int j = 0;
        while (j < m) {
            if (sv[j] > tsh) {
                ++nr;
            }
            ++j;
        }
        return nr;
    }

    public static double svd_norm(int m, double[] sv, double thres, doubleW cond) {
        double norm = 0.0;
        double cnum = 0.0;
        int i = 0;
        while (i < m) {
            if (sv[i] <= thres) break;
            norm += sv[i] * sv[i];
            ++i;
        }
        if (i == m) {
            --i;
        }
        cond.val = cnum = sv[0] <= 0.0 || sv[i] <= 0.0 ? 99999.0 : sv[0] / sv[i];
        return norm;
    }

    public static int projection_matrix(int numphas, ISCPha[] p, int n, double pctvar, double[][] cov, double[][] w, intW prank, int nunp, String[] phundef, int ispchange) {
        int j;
        int knull = 0;
        int nphases = 0;
        PhaseList[] plist = new PhaseList[95];
        int i = 0;
        while (i < plist.length) {
            plist[i] = new PhaseList();
            ++i;
        }
        double sum = 0.0;
        double pct = 0.0;
        nphases = Locator.getphases(numphas, p, plist);
        if (nphases == 0) {
            return 1;
        }
        pct = pctvar / 100.0;
        boolean temp = true;
        if (temp) {
            j = 0;
            while (j < nphases) {
                SVD.w_matrix(plist[j], pct, cov, w, nunp, phundef, ispchange);
                ++j;
            }
        } else {
            OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
            int ncpu = os.getAvailableProcessors();
            ExecutorService pool = Executors.newFixedThreadPool(ncpu);
            j = 0;
            while (j < nphases) {
                pool.submit(new w_matrix_thr(plist[j], pct, cov, w, nunp, phundef, ispchange));
                ++j;
            }
            pool.shutdown();
            while (!pool.isTerminated()) {
            }
        }
        Locator.freephaselist(nphases, plist);
        if (Config.errorcode != 0) {
            return 1;
        }
        if (Config.verbose > 3) {
            logger.info((Object)String.format("        Projection matrix and row sums", new Object[0]));
        }
        knull = 0;
        i = 0;
        while (i < n) {
            StringBuffer sb = new StringBuffer(128);
            if (Config.verbose > 3) {
                sb.append(String.format("          %4d ", i));
            }
            sum = 0.0;
            j = 0;
            while (j < n) {
                sum += w[i][j];
                if (Config.verbose > 3) {
                    sb.append(String.format("%13.4f ", w[i][j]));
                }
                ++j;
            }
            if (Math.abs(sum) < 1.0E-5) {
                ++knull;
            }
            if (Config.verbose > 3) {
                sb.append(String.format(" | %12.4f %d", sum, knull));
                logger.info((Object)sb.toString());
            }
            ++i;
        }
        if (Config.verbose > 1) {
            logger.info((Object)String.format("    Projection matrix W(%d x %d):", n, n));
            logger.info((Object)String.format("      %d observations are projected to the null space (rank = %d)", knull, n - knull));
        }
        prank.val = n - knull;
        return 0;
    }

    static int w_matrix(PhaseList plist, double pct, double[][] cov, double[][] w, int nunp, String[] phundef, int ispchange) {
        int np = 0;
        int mp = 0;
        int knull = 0;
        int nr = 0;
        boolean isfound = false;
        double sum = 0.0;
        double esum = 0.0;
        double psum = 0.0;
        double ths = 0.0;
        double x = 0.0;
        isfound = false;
        int i = 0;
        while (i < nunp) {
            if (Config.streq(phundef[i], plist.phase)) {
                isfound = true;
            }
            ++i;
        }
        if (!isfound && ispchange == 0) {
            return 0;
        }
        np = plist.n;
        if (Config.verbose > 3) {
            logger.info((Object)String.format("        Correlated errors: phase %s, %d observations", plist.phase, plist.n));
        }
        if (np == 1) {
            int ii = plist.ind[0];
            w[ii][ii] = 0.0;
            if (cov[ii][ii] > 1.0E-10) {
                w[ii][ii] = 1.0 / Math.sqrt(cov[ii][ii]);
            }
            if (Config.verbose > 3) {
                logger.info((Object)String.format("          Covariance matrix C(%d x %d):", np, np));
                logger.info((Object)String.format("          %4d %15.6f", ii, cov[ii][ii]));
                logger.info((Object)String.format("          Projection matrix W(%d x %d):", np, np));
                logger.info((Object)String.format("               %15.6f", w[ii][ii]));
            }
        } else {
            int jj;
            int m;
            int ii;
            double[][] z = new double[np][np];
            int k = 0;
            while (k < np) {
                ii = plist.ind[k];
                z[k][k] = cov[ii][ii];
                m = 0;
                while (m < k) {
                    jj = plist.ind[m];
                    z[k][m] = cov[ii][jj];
                    z[m][k] = cov[jj][ii];
                    ++m;
                }
                ++k;
            }
            k = 0;
            while (k < np) {
                mp = np - 1;
                while (z[k][mp] < 1.0E-10) {
                    --mp;
                }
                if (mp == k) {
                    ii = plist.ind[k];
                    w[ii][ii] = 0.0;
                    if (z[k][k] > 1.0E-10) {
                        w[ii][ii] = 1.0 / Math.sqrt(z[k][k]);
                    }
                    if (Config.verbose > 3) {
                        logger.info((Object)String.format("          Covariance matrix C(1 x 1):", new Object[0]));
                        logger.info((Object)String.format("          %4d %12.4f", ii, z[k][k]));
                        logger.info((Object)String.format("          Projection matrix W(1 x 1):", new Object[0]));
                        logger.info((Object)String.format("               %12.4f", w[ii][ii]));
                    }
                } else {
                    AbstractStringBuilder sb;
                    i = k + 1;
                    while (i < mp) {
                        m = np - 1;
                        while (z[i][m] < 1.0E-10) {
                            --m;
                        }
                        if (m > mp) {
                            mp = m;
                        }
                        ++i;
                    }
                    mp = mp - k + 1;
                    double[][] u = new double[mp][mp];
                    double[] avec = new double[mp * mp];
                    double[] sv = new double[mp];
                    if (Config.verbose > 3) {
                        logger.info((Object)String.format("          Covariance matrix C(%d x %d):", mp, mp));
                    }
                    ii = 0;
                    i = k;
                    while (ii < mp) {
                        sb = new StringBuffer(128);
                        if (Config.verbose > 3) {
                            ((StringBuffer)sb).append(String.format("      %4d", plist.ind[i]));
                        }
                        m = 0;
                        jj = k;
                        while (m < mp) {
                            avec[ii + m * mp] = z[i][jj];
                            if (Config.verbose > 3) {
                                ((StringBuffer)sb).append(String.format("%12.4f ", z[i][jj]));
                            }
                            ++m;
                            ++jj;
                        }
                        if (Config.verbose > 3) {
                            logger.info((Object)((StringBuffer)sb).toString());
                        }
                        ++ii;
                        ++i;
                    }
                    if (SVD.eigen_decompose(mp, avec, u, sv) != 0) {
                        u = null;
                        z = null;
                        avec = null;
                        sv = null;
                        Config.errorcode = 1;
                        return 1;
                    }
                    ths = SVD.svd_threshold(mp, mp, sv);
                    esum = 0.0;
                    m = 0;
                    while (m < mp) {
                        if (sv[m] <= ths) break;
                        esum += sv[m];
                        ++m;
                    }
                    nr = m;
                    psum = 0.0;
                    i = 0;
                    while (i < nr) {
                        if ((psum += sv[i] / esum) > pct) break;
                        ++i;
                    }
                    m = Math.min(i, nr - 1);
                    ths = sv[m];
                    if (Config.verbose > 3) {
                        logger.info((Object)String.format("          Projection matrix W(%d x %d):", mp, mp));
                    }
                    knull = 0;
                    m = 0;
                    while (m < mp) {
                        ii = plist.ind[m + k];
                        sum = 0.0;
                        sb = new StringBuilder(128);
                        if (Config.verbose > 3) {
                            ((StringBuilder)sb).append(String.format("          %4d", ii));
                        }
                        i = 0;
                        while (i < mp) {
                            jj = plist.ind[i + k];
                            x = 0.0;
                            if (sv[m] >= ths) {
                                x = u[i][m] / Utils.Sqrt(sv[m]);
                                if (Math.abs(x) < 1.0E-10) {
                                    x = 0.0;
                                }
                                sum += x;
                            }
                            w[ii][jj] = x;
                            if (Config.verbose > 3) {
                                ((StringBuilder)sb).append(String.format("%14.2f ", x));
                            }
                            ++i;
                        }
                        if (Math.abs(sum) < 1.0E-5) {
                            ++knull;
                        }
                        if (Config.verbose > 3) {
                            ((StringBuilder)sb).append(String.format("| %12.4f", sum));
                            logger.info((Object)((StringBuilder)sb).substring(0));
                        }
                        ++m;
                    }
                    if (Config.verbose > 3) {
                        if (knull != 0) {
                            logger.info((Object)String.format("          %d observations are projected to the null space", knull));
                        }
                        logger.info((Object)String.format("          Eigenvalue spectrum:", new Object[0]));
                        logger.info((Object)String.format("          threshold = %.3f rank = %d", ths, mp - knull));
                        sb = new StringBuilder(128);
                        ((StringBuilder)sb).append(String.format("          ", new Object[0]));
                        m = 0;
                        while (m < mp) {
                            ((StringBuilder)sb).append(String.format("%10.3f ", sv[m]));
                            ++m;
                        }
                        logger.info((Object)((StringBuilder)sb).substring(0));
                        sb = new StringBuilder(128);
                        ((StringBuilder)sb).append(String.format("          ", new Object[0]));
                        psum = 0.0;
                        m = 0;
                        while (m < nr) {
                            ((StringBuilder)sb).append(String.format("   %7.3f ", psum += 100.0 * sv[m] / esum));
                            ++m;
                        }
                        m = nr;
                        while (m < mp) {
                            ((StringBuilder)sb).append("   100.0   ");
                            ++m;
                        }
                        logger.info((Object)((StringBuilder)sb).substring(0));
                    }
                    u = null;
                    avec = null;
                    sv = null;
                    k += mp - 1;
                }
                ++k;
            }
            z = null;
        }
        return 0;
    }

    static int eigen_decompose(int nd, double[] avec, double[][] u, double[] sv) {
        int n = nd;
        int lda = nd;
        int ldz = nd;
        int il = 0;
        int iu = 0;
        intW info = new intW(0);
        intW m = new intW(nd);
        int lwork = -1;
        int liwork = -1;
        double abstol = DLAMCH.DLAMCH((String)"S");
        double vl = 0.0;
        double vu = 0.0;
        double[] wkopt = new double[1];
        int[] iwkopt = new int[1];
        double[] uvec = new double[n * n];
        int[] isuppz = new int[2 * n];
        Dsyevr.dsyevr((String)"V", (String)"A", (String)"U", (int)n, (double[])avec, (int)0, (int)lda, (double)vl, (double)vu, (int)il, (int)iu, (double)abstol, (intW)m, (double[])sv, (int)0, (double[])uvec, (int)0, (int)ldz, (int[])isuppz, (int)0, (double[])wkopt, (int)0, (int)lwork, (int[])iwkopt, (int)0, (int)liwork, (intW)info);
        lwork = (int)wkopt[0];
        liwork = iwkopt[0];
        double[] work = new double[lwork];
        int[] iwork = new int[liwork];
        Dsyevr.dsyevr((String)"V", (String)"A", (String)"U", (int)n, (double[])avec, (int)0, (int)lda, (double)vl, (double)vu, (int)il, (int)iu, (double)abstol, (intW)m, (double[])sv, (int)0, (double[])uvec, (int)0, (int)ldz, (int[])isuppz, (int)0, (double[])work, (int)0, (int)lwork, (int[])iwork, (int)0, (int)liwork, (intW)info);
        if (info.val != 0) {
            logger.warn((Object)"eigen_decompose: failed to compute eigenvalues");
            isuppz = null;
            uvec = null;
            work = null;
            iwork = null;
            return 1;
        }
        int i = 0;
        while (i < nd) {
            int j = 0;
            while (j < nd) {
                u[i][nd - j - 1] = uvec[i + j * nd];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nd) {
            avec[i] = sv[nd - i - 1];
            ++i;
        }
        i = 0;
        while (i < nd) {
            sv[i] = avec[i];
            ++i;
        }
        isuppz = null;
        uvec = null;
        work = null;
        iwork = null;
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class w_matrix_thr
    implements Callable<Boolean> {
        final PhaseList plist;
        final double pct;
        final double[][] cov;
        final double[][] w;
        final int nunp;
        final String[] phundef;
        final int ispchange;

        public w_matrix_thr(PhaseList plist, double pct, double[][] cov, double[][] w, int nunp, String[] phundef, int ispchange) {
            this.plist = plist;
            this.pct = pct;
            this.cov = cov;
            this.w = w;
            this.nunp = nunp;
            this.phundef = phundef;
            this.ispchange = ispchange;
        }

        @Override
        public Boolean call() {
            SVD.w_matrix(this.plist, this.pct, this.cov, this.w, this.nunp, this.phundef, this.ispchange);
            return true;
        }
    }
}

