/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.DataCovariance;
import cn.org.gddsn.seis.location.iscloc2.EC_COEF;
import cn.org.gddsn.seis.location.iscloc2.ISCPha;
import cn.org.gddsn.seis.location.iscloc2.ISCSol;
import cn.org.gddsn.seis.location.iscloc2.ISCSta;
import cn.org.gddsn.seis.location.iscloc2.LocQual;
import cn.org.gddsn.seis.location.iscloc2.Locator;
import cn.org.gddsn.seis.location.iscloc2.NASPACE;
import cn.org.gddsn.seis.location.iscloc2.PhaseIds;
import cn.org.gddsn.seis.location.iscloc2.READING;
import cn.org.gddsn.seis.location.iscloc2.SOBOL;
import cn.org.gddsn.seis.location.iscloc2.SVD;
import cn.org.gddsn.seis.location.iscloc2.StaOrder;
import cn.org.gddsn.seis.location.iscloc2.TT_TABLE;
import cn.org.gddsn.seis.location.iscloc2.TravelTimes;
import cn.org.gddsn.seis.location.iscloc2.Utils;
import cn.org.gddsn.seis.location.iscloc2.VarioGram;
import com.nr.ran.Ranfib;
import com.nr.ran.Sobol;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log4j.Logger;
import org.netlib.util.StringW;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class NA {
    static Logger logger = Logger.getLogger(NA.class);
    static Ranfib ranfib;
    private static int id;
    private static int ic;
    private static final double[] ntot;
    private static final int[] nprim;
    private static final long[][] pporder;
    private static double fac;
    private static long in;
    private static long[] inn;
    private static long[] ix;

    static {
        id = 0;
        ic = 0;
        ntot = new double[]{1.0, 2.0, 8.0, 64.0, 1024.0, 32768.0, 2097152.0, 2.68435456E8, 6.8719476E10, 3.5184372E13};
        nprim = new int[]{1, 1, 2, 2, 6, 6, 18, 16, 48, 60};
        long[][] lArrayArray = new long[10][];
        lArrayArray[0] = new long[60];
        long[] lArray = new long[60];
        lArray[0] = 1L;
        lArrayArray[1] = lArray;
        long[] lArray2 = new long[60];
        lArray2[0] = 1L;
        lArray2[1] = 2L;
        lArrayArray[2] = lArray2;
        long[] lArray3 = new long[60];
        lArray3[0] = 1L;
        lArray3[1] = 4L;
        lArrayArray[3] = lArray3;
        long[] lArray4 = new long[60];
        lArray4[0] = 2L;
        lArray4[1] = 4L;
        lArray4[2] = 7L;
        lArray4[3] = 11L;
        lArray4[4] = 13L;
        lArray4[5] = 14L;
        lArrayArray[4] = lArray4;
        long[] lArray5 = new long[60];
        lArray5[0] = 1L;
        lArray5[1] = 13L;
        lArray5[2] = 16L;
        lArray5[3] = 19L;
        lArray5[4] = 22L;
        lArray5[5] = 25L;
        lArrayArray[5] = lArray5;
        long[] lArray6 = new long[60];
        lArray6[0] = 1L;
        lArray6[1] = 4L;
        lArray6[2] = 7L;
        lArray6[3] = 8L;
        lArray6[4] = 14L;
        lArray6[5] = 19L;
        lArray6[6] = 21L;
        lArray6[7] = 28L;
        lArray6[8] = 31L;
        lArray6[9] = 32L;
        lArray6[10] = 37L;
        lArray6[11] = 41L;
        lArray6[12] = 42L;
        lArray6[13] = 50L;
        lArray6[14] = 55L;
        lArray6[15] = 56L;
        lArray6[16] = 59L;
        lArray6[17] = 62L;
        lArrayArray[6] = lArray6;
        long[] lArray7 = new long[60];
        lArray7[0] = 14L;
        lArray7[1] = 21L;
        lArray7[2] = 22L;
        lArray7[3] = 34L;
        lArray7[4] = 47L;
        lArray7[5] = 49L;
        lArray7[6] = 50L;
        lArray7[7] = 52L;
        lArray7[8] = 56L;
        lArray7[9] = 67L;
        lArray7[10] = 70L;
        lArray7[11] = 84L;
        lArray7[12] = 97L;
        lArray7[13] = 103L;
        lArray7[14] = 115L;
        lArray7[15] = 122L;
        lArrayArray[7] = lArray7;
        long[] lArray8 = new long[60];
        lArray8[0] = 8L;
        lArray8[1] = 13L;
        lArray8[2] = 16L;
        lArray8[3] = 22L;
        lArray8[4] = 25L;
        lArray8[5] = 44L;
        lArray8[6] = 47L;
        lArray8[7] = 52L;
        lArray8[8] = 55L;
        lArray8[9] = 59L;
        lArray8[10] = 62L;
        lArray8[11] = 67L;
        lArray8[12] = 74L;
        lArray8[13] = 81L;
        lArray8[14] = 82L;
        lArray8[15] = 87L;
        lArray8[16] = 91L;
        lArray8[17] = 94L;
        lArray8[18] = 103L;
        lArray8[19] = 104L;
        lArray8[20] = 109L;
        lArray8[21] = 122L;
        lArray8[22] = 124L;
        lArray8[23] = 137L;
        lArray8[24] = 138L;
        lArray8[25] = 143L;
        lArray8[26] = 145L;
        lArray8[27] = 152L;
        lArray8[28] = 157L;
        lArray8[29] = 167L;
        lArray8[30] = 173L;
        lArray8[31] = 176L;
        lArray8[32] = 181L;
        lArray8[33] = 182L;
        lArray8[34] = 185L;
        lArray8[35] = 191L;
        lArray8[36] = 194L;
        lArray8[37] = 199L;
        lArray8[38] = 218L;
        lArray8[39] = 220L;
        lArray8[40] = 227L;
        lArray8[41] = 229L;
        lArray8[42] = 230L;
        lArray8[43] = 234L;
        lArray8[44] = 236L;
        lArray8[45] = 241L;
        lArray8[46] = 244L;
        lArray8[47] = 253L;
        lArrayArray[8] = lArray8;
        lArrayArray[9] = new long[]{4L, 13L, 19L, 22L, 50L, 55L, 64L, 69L, 98L, 107L, 115L, 121L, 127L, 134L, 140L, 145L, 152L, 158L, 161L, 171L, 181L, 194L, 199L, 203L, 208L, 227L, 242L, 251L, 253L, 265L, 266L, 274L, 283L, 289L, 295L, 301L, 316L, 319L, 324L, 346L, 352L, 361L, 367L, 382L, 395L, 398L, 400L, 412L, 419L, 422L, 426L, 428L, 433L, 446L, 454L, 457L, 472L, 493L, 505L, 508L};
        pporder = lArrayArray;
        inn = new long[20000];
        ix = new long[20000];
    }

    private NA() {
    }

    public static int set_searchspace(ISCSol sp, NASPACE nasp) {
        nasp.lat = sp.lat;
        nasp.lon = sp.lon;
        nasp.ot = sp.time;
        nasp.depth = sp.depth;
        nasp.epifix = sp.epifix;
        nasp.otfix = sp.timfix;
        nasp.depfix = sp.depfix;
        if (sp.depfixtype == 4) {
            if (Config.na_ottol > 20.0) {
                Config.na_ottol = 20.0;
            }
            if (Config.na_radius > 2.0) {
                Config.na_radius = 2.0;
            }
        }
        nasp.nd = 4;
        if (nasp.epifix) {
            nasp.nd -= 2;
        }
        if (nasp.otfix) {
            --nasp.nd;
        }
        if (nasp.depfix) {
            --nasp.nd;
        }
        if (nasp.nd < 1) {
            return 1;
        }
        int i = 0;
        if (!nasp.epifix) {
            nasp.range[i][0] = 0.0;
            nasp.range[i][1] = Config.na_radius;
            nasp.range[++i][0] = 0.0;
            nasp.range[i][1] = 360.0;
            ++i;
        }
        if (!nasp.otfix) {
            nasp.range[i][0] = sp.time - Config.na_ottol;
            nasp.range[i][1] = sp.time + Config.na_ottol;
            ++i;
        }
        if (!nasp.depfix) {
            nasp.range[i][0] = sp.depth - Config.na_deptol > 0.0 ? sp.depth - Config.na_deptol : 0.0;
            nasp.range[i][1] = sp.depth + Config.na_deptol < Config.max_depth_km ? sp.depth + Config.na_deptol : Config.max_depth_km;
        }
        nasp.scale[0] = -1.0;
        i = 0;
        while (i < nasp.nd) {
            nasp.scale[i + 1] = nasp.range[i][1] - nasp.range[i][0];
            if (nasp.scale[i + 1] < 0.001) {
                logger.warn((Object)String.format("Invalid range: %d, %f!", i + 1, nasp.scale[i + 1]));
                return 1;
            }
            ++i;
        }
        if (Config.na_lpnorm < 1.0 || Config.na_lpnorm > 2.0) {
            logger.warn((Object)String.format("Invalid lp-norm: %.2f!", Config.na_lpnorm));
            return 1;
        }
        nasp.lpnorm = Config.na_lpnorm;
        return 0;
    }

    public static int na_search(int nsta, ISCSol sp, ISCPha[] p, TT_TABLE[] tt_tables, EC_COEF[] ec, short[][] topo, ISCSta[] stalist, double[][] distmatrix, VarioGram variogramp, StaOrder[] staorder, NASPACE nasp, String filename) {
        int k;
        String timestr;
        PrintWriter fp = null;
        READING[] rdindx = null;
        double du = 1.0;
        doubleW gap = new doubleW(360.0);
        doubleW sgap = new doubleW(360.0);
        double[] xcur = new double[4];
        double[] model_opt = new double[4];
        int[] mfitord = new int[5000];
        int[] iwork_NA2 = new int[5000];
        int ntotal = 0;
        int nsamp = 0;
        int nclean = 500;
        intW restartNA = new intW(1);
        int prev_rdid = -1;
        int ntot = 0;
        int ncald = 0;
        int nupd = 0;
        int nc = 0;
        intW nu = new intW(0);
        int iter = 0;
        int ns = 0;
        int nd = 0;
        int np = 0;
        int nrd = 0;
        intW prank = new intW(0);
        int verbose_cf = Config.verbose;
        StringW buf = new StringW("");
        SOBOL sas = new SOBOL();
        ntotal = Config.na_nsamplei + 1 + Config.na_nsample * Config.na_itermax;
        nsamp = Math.max(Config.na_nsample, Config.na_nsamplei + 1);
        doubleW mfitmin = new doubleW(0.0);
        doubleW mfitminc = new doubleW(0.0);
        doubleW mfitmean = new doubleW(0.0);
        intW mopt = new intW(0);
        if (Config.iseed < 0L) {
            Config.iseed = -Config.iseed;
        }
        if ((nd = nasp.nd) > 4) {
            logger.info((Object)String.format("NA: model parameters %d > %d!", nd, 4));
            return 1;
        }
        if (nsamp > 5000) {
            logger.warn((Object)String.format("NA: sample size %d > %d!", nsamp, 5000));
            return 1;
        }
        if (ntotal > 500001) {
            logger.warn((Object)String.format("NA: number of models %d > %d!", ntotal, 500001));
            return 1;
        }
        if (Config.na_itermax > 100) {
            logger.warn((Object)String.format("NA: number of iterations %d > %d!", Config.na_itermax, 100));
            return 1;
        }
        if (Config.na_ncells > Config.na_nsample || Config.na_ncells > Config.na_nsamplei) {
            logger.warn((Object)String.format("NA: number of cells to resampled %d > (%d, %d)!", Config.na_ncells, Config.na_nsamplei, Config.na_nsample));
            return 1;
        }
        if (nd * Config.na_ncells > 20000) {
            logger.warn((Object)String.format("NA: random sequence %d > %d!", nd * Config.na_ncells, 20000));
            return 1;
        }
        nrd = 0;
        np = 0;
        int i = 0;
        while (i < sp.numphas) {
            p[i].timedef = false;
            if (!(p[i].phase.length() <= 0 || p[i].phase.toUpperCase().charAt(0) != 'P' && p[i].phase.toUpperCase().charAt(0) != 'S' || Config.streq(p[i].phase, "pmax") || Config.streq(p[i].phase, "smax"))) {
                p[i].timedef = true;
                ++np;
                if (p[i].rdid != prev_rdid) {
                    ++nrd;
                }
                prev_rdid = p[i].rdid;
            }
            ++i;
        }
        if (np < nasp.nd) {
            logger.warn((Object)String.format("insufficient number of observations (%d) to perform grid search!", np));
            return 1;
        }
        if (Config.write_gridsearch_results != 0) {
            try {
                fp = new PrintWriter(new FileWriter(filename));
            }
            catch (IOException e) {
                logger.warn((Object)String.format("NA: cannot open %s", filename));
                return 1;
            }
        }
        rdindx = new READING[nrd];
        int n = 0;
        while (n < rdindx.length) {
            rdindx[n] = new READING();
            ++n;
        }
        double[] esaz = new double[np + 2];
        ISCPha[] pgs = new ISCPha[np];
        String prevsta = "";
        int ksta = 0;
        int j = 0;
        i = 0;
        while (i < sp.numphas) {
            if (p[i].timedef) {
                pgs[j] = new ISCPha(p[i]);
                if (!p[i].prista.equals(prevsta)) {
                    esaz[ksta++] = p[i].esaz;
                }
                prevsta = p[i].prista;
                ++j;
            }
            ++i;
        }
        sp.numphas = prank.val = np;
        sp.nreading = nrd;
        Locator.readings(np, nrd, pgs, rdindx);
        du = LocQual.gapper(ksta, esaz, gap, sgap);
        esaz = null;
        int do_correlated_errors_cf = Config.do_correlated_errors;
        if (np > 30 && du < 0.7) {
            Config.do_correlated_errors = 0;
        }
        if (Config.do_correlated_errors != 0) {
            DataCovariance.sort_phaserec_nn(np, nsta, pgs, stalist, staorder);
            Locator.readings(np, nrd, pgs, rdindx);
        }
        double[] misfit = new double[ntotal];
        double[] work_NA2 = new double[ntotal];
        int[] iwork_NA1 = new int[ntotal];
        double[][] na_models = new double[ntotal][4];
        double[] dlist = new double[ntotal];
        mfitmin.val = 1000000.0;
        if (Config.verbose > 0) {
            logger.info((Object)String.format("Grid search around hypocentre:", new Object[0]));
            timestr = Utils.human_time(nasp.ot);
            logger.info((Object)String.format("  OT = %s Lat = %7.3f Lon = %8.3f Depth = %.1f", timestr, nasp.lat, nasp.lon, nasp.depth));
            logger.info((Object)String.format("  Number of phases = %d", np));
            logger.info((Object)String.format("  Number of model parameters = %d", nd));
            logger.info((Object)String.format("    NA options", new Object[0]));
            logger.info((Object)String.format("      Initial sample size = %d", Config.na_nsamplei));
            logger.info((Object)String.format("      Sample size = %d", Config.na_nsample));
            logger.info((Object)String.format("      Number of iterations = %d", Config.na_itermax));
            logger.info((Object)String.format("      Number of cells resampled = %d", Config.na_ncells));
            logger.info((Object)String.format("      Random seed value = %d", Config.iseed));
            logger.info((Object)String.format("      SAS Quasi-random sequence used", new Object[0]));
            logger.info((Object)String.format("      Starting models generated randomly", new Object[0]));
            if (Config.do_correlated_errors != do_correlated_errors_cf) {
                logger.info((Object)String.format("      Temporarily disabled correlated errors (np = %d > 30 && dU = %4.2f < 0.7)", np, du));
            }
        }
        if (NA.na_initialize(nasp, xcur, sas) != 0) {
            Config.do_correlated_errors = do_correlated_errors_cf;
            return 1;
        }
        if (Config.write_gridsearch_results != 0) {
            fp.printf("# epifix = %d epirange = %.2f", nasp.epifix, Config.na_radius);
            fp.printf("# ot_fix = %d ot_range = %.2f", nasp.otfix, Config.na_ottol);
            fp.printf("# depfix = %d deprange = %.2f", nasp.depfix, Config.na_deptol);
            fp.printf("# %8.4f %9.4f %15.3f %8.4f", nasp.lat, nasp.lon, nasp.ot, nasp.depth);
            fp.printf("#  i   j   lat       lon         ot          depth     misfit       norm     penalty    np ndef rank", new Object[0]);
        }
        nu.val = 0;
        nc = 0;
        nupd = 0;
        ncald = 0;
        ntot = 0;
        ns = Config.na_nsamplei + 1;
        iter = 0;
        while (iter <= Config.na_itermax) {
            if (iter != 0) {
                nc = NA.na_sample(na_models, nasp, ntot, mfitord, xcur, restartNA, nclean, dlist, sas, nu);
                ncald += nc;
                nupd += nu.val;
                ns = Config.na_nsample;
            } else {
                NA.na_initial_sample(na_models, nasp, sas);
            }
            Config.verbose = 0;
            i = 0;
            while (i < ns) {
                misfit[ntot + i] = NA.dosamples(i, ntot, na_models[ntot + i], nasp, np, nsta, sp, rdindx, pgs, tt_tables, ec, topo, stalist, distmatrix, variogramp, fp);
                ++i;
            }
            Config.verbose = verbose_cf;
            NA.na_misfits(misfit, ns, ntot, mfitmin, mfitminc, mfitmean, mopt, work_NA2, iwork_NA1, iwork_NA2, mfitord);
            NA.transform2raw(na_models[mopt.val], nasp, model_opt);
            if (!nasp.epifix) {
                NA.tolatlon(model_opt, nasp);
            }
            ntot += ns;
            if (Config.write_gridsearch_results != 0) {
                k = 0;
                fp.printf("%4d %3d ", iter, -1);
                if (nasp.epifix) {
                    fp.printf("%8.4f %9.4f ", nasp.lat, nasp.lon);
                } else {
                    fp.printf("%8.4f %9.4f ", model_opt[k], model_opt[k + 1]);
                    k += 2;
                }
                if (nasp.otfix) {
                    fp.printf("%15.3f ", nasp.ot);
                } else {
                    fp.printf("%15.3f ", model_opt[k]);
                    ++k;
                }
                if (nasp.depfix) {
                    fp.printf("%8.4f ", nasp.depth);
                } else {
                    fp.printf("%8.4f ", model_opt[k]);
                }
                fp.printf("%10.4f\n", misfit[mopt.val]);
            }
            if (Config.verbose > 3) {
                logger.info((Object)String.format("        NA iteration %d", iter));
                logger.info((Object)String.format("          Total number of samples = %d", ntot));
                logger.info((Object)String.format("          Minimum misfit = %.4f", mfitmin.val));
                logger.info((Object)String.format("          Minimum misfit in this iteration = %.4f", mfitminc.val));
                logger.info((Object)String.format("          Mean misfit in this iteration = %.4f", mfitmean.val));
                logger.info((Object)String.format("          Index of best fitting model = %d", mopt.val));
                logger.info((Object)String.format("          Best fitting model so far", new Object[0]));
                k = 0;
                StringBuilder sb = new StringBuilder(128);
                sb.append(String.format("          ", new Object[0]));
                if (nasp.epifix) {
                    sb.append(String.format("%7.3f %8.3f ", nasp.lat, nasp.lon));
                } else {
                    sb.append(String.format("%7.3f %8.3f ", model_opt[k], model_opt[k + 1]));
                    k += 2;
                }
                if (nasp.otfix) {
                    sb.append(String.format("%15.3f ", nasp.ot));
                } else {
                    sb.append(String.format("%15.3f ", model_opt[k]));
                    ++k;
                }
                if (nasp.depfix) {
                    sb.append(String.format("%7.3f ", nasp.depth));
                } else {
                    sb.append(String.format("%7.3f ", model_opt[k]));
                }
                logger.info((Object)sb.substring(0));
            }
            ++iter;
        }
        if (Config.write_gridsearch_results != 0) {
            fp.close();
        }
        if (Config.verbose > 0) {
            logger.info((Object)String.format("  NA summary", new Object[0]));
            logger.info((Object)String.format("    Total number of samples = %d", ntot));
            logger.info((Object)String.format("    Total number of full dlist evaluations = %d", ncald));
            logger.info((Object)String.format("    Total number of partial dlist updates = %d", nupd));
            logger.info((Object)String.format("    Lowest misfit found = %.4f", mfitmin.val));
        }
        if (mfitmin.val < 999.0) {
            if (Config.verbose > 0) {
                logger.info((Object)String.format("    Mean misfit over all models = %.4f", mfitmean.val));
                logger.info((Object)String.format("    Index of best fitting model = %d", mopt.val));
                logger.info((Object)String.format("    Best fitting model", new Object[0]));
                k = 0;
                StringBuilder sb = new StringBuilder(128);
                sb.append(String.format("    ", new Object[0]));
                if (nasp.epifix) {
                    sb.append(String.format("%7.3f %8.3f ", nasp.lat, nasp.lon));
                } else {
                    sb.append(String.format("%7.3f %8.3f ", model_opt[k], model_opt[k + 1]));
                    k += 2;
                }
                if (nasp.otfix) {
                    timestr = Utils.human_time(nasp.ot);
                } else {
                    timestr = Utils.human_time(model_opt[k]);
                    ++k;
                }
                sb.append(String.format("%s ", timestr));
                if (nasp.depfix) {
                    sb.append(String.format("%7.3f ", nasp.depth));
                } else {
                    sb.append(String.format("%7.3f ", model_opt[k]));
                }
                logger.info((Object)sb.substring(0));
                if (Config.verbose > 3) {
                    NA.writemodels(na_models, nasp, misfit);
                }
            }
            NA.forward(nsta, nasp, model_opt, sp, rdindx, pgs, tt_tables, ec, topo, stalist, distmatrix, variogramp, buf);
            if (Config.verbose > 2) {
                Utils.print_sol(sp, 0);
                Utils.print_defining_pha(np, pgs);
            }
            j = 0;
        } else {
            if (Config.verbose > 0) {
                logger.info((Object)String.format("    No acceptable model was found!", new Object[0]));
            }
            j = 1;
        }
        na_models = null;
        iwork_NA1 = null;
        work_NA2 = null;
        dlist = null;
        misfit = null;
        pgs = null;
        Config.do_correlated_errors = do_correlated_errors_cf;
        return j;
    }

    public static double forward(int nsta, NASPACE nasp, double[] model, ISCSol sp, READING[] rdindx, ISCPha[] pgs, TT_TABLE[] tt_tables, EC_COEF[] ec, short[][] topo, ISCSta[] stalist, double[][] distmatrix, VarioGram variogramp, StringW buf) {
        double[][] dcov;
        double obstt = 0.0;
        double badfit = 999.0;
        double z = 0.0;
        double misfit = 9999.0;
        double sum = 0.0;
        double norm = 0.0;
        double penal = 0.0;
        intW prank = new intW(0);
        int i = 0;
        if (!nasp.epifix) {
            sp.lat = model[i++];
            sp.lon = model[i++];
        }
        if (!nasp.otfix) {
            sp.time = model[i++];
        }
        if (!nasp.depfix) {
            sp.depth = model[i];
        }
        int np = sp.numphas;
        Utils.calc_delaz(sp, pgs, false);
        PhaseIds.reidentify_pha(sp, rdindx, pgs, ec, tt_tables, topo);
        PhaseIds.mark_duplicates(sp, pgs, ec, tt_tables, topo);
        int ndef = 0;
        i = 0;
        while (i < np) {
            if (pgs[i].timedef) {
                ++ndef;
            }
            ++i;
        }
        prank.val = ndef;
        buf.val = String.format("%10.4f %10.4f %4d %4d %4d", misfit, misfit, np, ndef, prank.val);
        if (ndef < nasp.nd) {
            return misfit;
        }
        double[] d = new double[ndef];
        double[] temp = new double[ndef];
        double[][] w = null;
        if (Config.do_correlated_errors != 0) {
            dcov = DataCovariance.data_covariance_matrix(nsta, np, ndef, pgs, stalist, distmatrix, variogramp);
            if (dcov == null) {
                d = null;
                temp = null;
                return misfit;
            }
            w = new double[ndef][ndef];
            if (SVD.projection_matrix(np, pgs, ndef, 95.0, dcov, w, prank, 0, null, 1) != 0) {
                dcov = null;
                w = null;
                temp = null;
                d = temp;
                return misfit;
            }
            if (prank.val < nasp.nd) {
                dcov = null;
                w = null;
                temp = null;
                d = temp;
                return misfit;
            }
        }
        int k = 0;
        i = 0;
        while (i < np) {
            if (pgs[i].timedef) {
                obstt = pgs[i].time - sp.time;
                d[k] = TravelTimes.read_ttime(sp, pgs[i], ec, tt_tables, topo, 0, 0) != 0 ? badfit : obstt - pgs[i].ttime;
                pgs[i].resid = d[k];
                ++k;
            }
            ++i;
        }
        if (Config.do_correlated_errors != 0) {
            i = 0;
            while (i < ndef) {
                temp[i] = 0.0;
                k = 0;
                while (k < ndef) {
                    int n = i;
                    temp[n] = temp[n] + w[i][k] * d[k];
                    ++k;
                }
                if (Math.abs(temp[i]) < 1.0E-10) {
                    temp[i] = 0.0;
                }
                ++i;
            }
            i = 0;
            while (i < ndef) {
                d[i] = temp[i];
                ++i;
            }
        } else {
            k = 0;
            i = 0;
            while (i < ndef) {
                if (pgs[i].timedef && !(pgs[i].measerr < 1.0E-8)) {
                    int n = k++;
                    d[n] = d[n] / pgs[i].measerr;
                }
                ++i;
            }
        }
        sum = 0.0;
        i = 0;
        while (i < ndef) {
            z = nasp.lpnorm - 1.0 < 0.01 ? Math.abs(d[i]) : Math.pow(Math.abs(d[i]), nasp.lpnorm);
            sum += z;
            ++i;
        }
        z = Math.max(prank.val - nasp.nd, 1);
        norm = sum / z;
        penal = 4.0 * (double)(np - ndef) / (double)np;
        misfit = norm + penal;
        buf.val = String.format("%10.4f %10.4f %4d %4d %4d", norm, penal, np, ndef, prank.val);
        dcov = null;
        w = null;
        temp = null;
        d = temp;
        return misfit;
    }

    static int na_initialize(NASPACE nasp, double[] xcur, SOBOL sas) {
        int i;
        double[] rval = new double[2];
        double[] dummy = new double[]{0.0};
        int nd = nasp.nd;
        Sobol.sobseq((int)-1, (double[])rval);
        ranfib = new Ranfib(Config.iseed);
        NA.na_sas_table(nd * Config.na_ncells, sas);
        if (NA.na_sobol(nd * Config.na_ncells, dummy, 1, 1, sas) != 0) {
            return 1;
        }
        if (nasp.scale[0] == 0.0) {
            i = 0;
            while (i < nd) {
                nasp.ranget[i][0] = nasp.range[i][0];
                nasp.ranget[i][1] = nasp.range[i][1];
                nasp.scale[i + 1] = 1.0;
                ++i;
            }
        } else if (nasp.scale[0] == -1.0) {
            i = 0;
            while (i < nd) {
                nasp.ranget[i][0] = 0.0;
                nasp.ranget[i][1] = 1.0;
                nasp.scale[i + 1] = nasp.range[i][1] - nasp.range[i][0];
                ++i;
            }
        } else {
            i = 0;
            while (i < nd) {
                nasp.ranget[i][0] = 0.0;
                nasp.ranget[i][1] = 1.0;
                if (nasp.scale[i + 1] > 0.0) {
                    nasp.ranget[i][1] = (nasp.range[i][1] - nasp.range[i][0]) / nasp.scale[i + 1];
                }
                ++i;
            }
        }
        i = 0;
        while (i < nd) {
            xcur[i] = (nasp.ranget[i][0] + nasp.ranget[i][1]) / 2.0;
            ++i;
        }
        if (Config.verbose > 0) {
            logger.info((Object)String.format("      Parameter ranges", new Object[0]));
            logger.info((Object)String.format("        Number       Minimum         Maximum   prior_Cov Scaled min  Scaled max", new Object[0]));
            i = 0;
            while (i < nd) {
                logger.info((Object)String.format("    %7d  %15.4f %15.4f %10.4f %10.4f %10.4f", i + 1, nasp.range[i][0], nasp.range[i][1], nasp.scale[i + 1], nasp.ranget[i][0], nasp.ranget[i][1]));
                ++i;
            }
        }
        return 0;
    }

    static int na_initial_sample(double[][] na_models, NASPACE nasp, SOBOL sas) {
        int nd = nasp.nd;
        double[] a = new double[]{0.0};
        double b = 0.0;
        if (Config.verbose > 3) {
            logger.info((Object)String.format("                initial sample:", new Object[0]));
        }
        int i = 0;
        while (i < Config.na_nsamplei) {
            int j = 0;
            if (i == 0) {
                if (!nasp.epifix) {
                    na_models[i][j++] = 0.0;
                    na_models[i][j++] = 0.0;
                }
                if (!nasp.otfix) {
                    na_models[i][j++] = 0.5;
                }
                if (!nasp.depfix) {
                    na_models[i][j] = (nasp.depth - nasp.range[j][0]) / (nasp.range[j][1] - nasp.range[j][0]);
                }
            } else {
                if (!nasp.epifix) {
                    NA.na_sobol(j, a, 1, 0, sas);
                    na_models[i][j] = Utils.Sqrt(a[0]) * nasp.ranget[j][1];
                    ++j;
                }
                while (j < nd) {
                    NA.na_sobol(j, a, 1, 0, sas);
                    b = 1.0 - a[0];
                    na_models[i][j] = b * nasp.ranget[j][0] + a[0] * nasp.ranget[j][1];
                    ++j;
                }
            }
            if (Config.verbose > 3) {
                int k = 0;
                StringBuilder sb = new StringBuilder(128);
                sb.append(String.format("                  %4d ", i));
                if (nasp.epifix) {
                    sb.append(String.format("%7.3f %8.3f ", nasp.lat, nasp.lon));
                } else {
                    sb.append(String.format("%7.3f %8.3f ", na_models[i][k], na_models[i][k + 1]));
                    k += 2;
                }
                if (nasp.otfix) {
                    sb.append(String.format("%15.3f ", nasp.ot));
                } else {
                    sb.append(String.format("%15.3f ", na_models[i][k]));
                    ++k;
                }
                if (nasp.depfix) {
                    sb.append(String.format("%7.3f", nasp.depth));
                } else {
                    sb.append(String.format("%7.3f", na_models[i][k]));
                }
                logger.info((Object)sb.substring(0));
            }
            ++i;
        }
        return 0;
    }

    static int na_sample(double[][] na_models, NASPACE nasp, int ntot, int[] mfitord, double[] xcur, intW restartNA, int nclean, double[] dlist, SOBOL sas, intW nu) {
        int idnext = 0;
        int cell = 0;
        int icount = 0;
        int nc = 0;
        int nup = 0;
        int nrem = 0;
        int nsampercell = 0;
        int is = 0;
        int iw = 0;
        boolean resetlist = false;
        int ind_cell = 0;
        int ind_nextcell = 0;
        int ind_lastcell = 0;
        int mopt = 0;
        int nodex = 0;
        int nnode = 0;
        int nd = 0;
        int kd = 0;
        doubleW x1 = new doubleW(0.0);
        doubleW x2 = new doubleW(0.0);
        double[] xdum = new double[4];
        if (Config.verbose > 4) {
            logger.info((Object)String.format("                next sample:", new Object[0]));
        }
        nd = nasp.nd;
        idnext = NA.irandomvalue(0, nd - 1);
        if (++ic % nclean == 0) {
            resetlist = true;
        }
        ind_nextcell = mopt = mfitord[cell];
        ind_lastcell = 0;
        nrem = Config.na_nsample % Config.na_ncells;
        nsampercell = nrem == 0 ? Config.na_nsample / Config.na_ncells : 1 + Config.na_nsample / Config.na_ncells;
        is = 0;
        while (is < Config.na_nsample) {
            int i;
            ind_cell = ind_nextcell;
            ++icount;
            if (ind_cell != ind_lastcell) {
                restartNA.val = NA.na_restart(na_models, nd, ind_cell, xcur);
            }
            if (restartNA.val != 0) {
                restartNA.val = 0;
                resetlist = true;
            }
            iw = 0;
            while (iw < nd) {
                if (resetlist) {
                    nodex = NA.NNcalc_dlist(idnext, dlist, na_models, nd, ntot, xcur);
                    ++nc;
                    resetlist = false;
                } else {
                    nodex = NA.NNupdate_dlist(idnext, id, dlist, na_models, ntot, xcur);
                    ++nup;
                }
                id = idnext;
                NA.NNaxis_intersect(id, dlist, na_models, ntot, nodex, nasp, x1, x2);
                kd = id + cell * nd;
                xcur[NA.id] = NA.na_deviate(x1.val, x2.val, kd, sas);
                if (Config.verbose > 4) {
                    i = 0;
                    while (i < nd) {
                        xdum[i] = xcur[i];
                        ++i;
                    }
                    xdum[NA.id] = x1.val;
                    nnode = NA.findnearest(xdum, na_models, ntot, nd);
                    logger.info((Object)String.format("                Nearest node to x1 = %d", nnode));
                    xdum[NA.id] = x2.val;
                    nnode = NA.findnearest(xdum, na_models, ntot, nd);
                    logger.info((Object)String.format("                Nearest node to x2 = %d", nnode));
                }
                if (++idnext == nd) {
                    idnext = 0;
                }
                ++iw;
            }
            int j = ntot + is;
            i = 0;
            while (i < nd) {
                na_models[j][i] = xcur[i];
                ++i;
            }
            if (Config.verbose > 4) {
                nnode = NA.findnearest(xcur, na_models, ntot, nd);
                logger.info((Object)String.format("                Nearest node to new model %d = %d", j, nnode));
                if (nnode != nodex) {
                    logger.info((Object)String.format("              Node outside original Voronoi cell!", new Object[0]));
                    logger.info((Object)String.format("                  original cell = %d", nodex));
                    logger.info((Object)String.format("                       new cell = %d", nnode));
                    logger.info((Object)String.format("                  j = %d, iw = %d id = %d", j, iw, id));
                }
            }
            ind_lastcell = ind_cell;
            if (icount == nsampercell) {
                icount = 0;
                ind_nextcell = mfitord[++cell];
                if (cell == nrem) {
                    --nsampercell;
                }
            }
            ++is;
        }
        nu.val = nup;
        return nc;
    }

    static int na_restart(double[][] na_models, int nd, int ind, double[] x) {
        int restartNA = 1;
        int i = 0;
        while (i < nd) {
            x[i] = na_models[ind][i];
            ++i;
        }
        return restartNA;
    }

    static int NNcalc_dlist(int dim, double[] dlist, double[][] na_models, int nd, int ntot, double[] x) {
        int nodex = 0;
        double dmin = 1000000.0;
        double dsum = 0.0;
        double d = 0.0;
        int i = 0;
        while (i < ntot) {
            dsum = 0.0;
            int j = 0;
            while (j < dim) {
                d = x[j] - na_models[i][j];
                dsum += d * d;
                ++j;
            }
            j = dim + 1;
            while (j < nd) {
                d = x[j] - na_models[i][j];
                dsum += d * d;
                ++j;
            }
            dlist[i] = dsum;
            d = x[dim] - na_models[i][dim];
            if ((dsum += d * d) < dmin) {
                dmin = dsum;
                nodex = i;
            }
            ++i;
        }
        return nodex;
    }

    static int NNupdate_dlist(int idnext, int id, double[] dlist, double[][] na_models, int ntot, double[] x) {
        int nodex = 0;
        double dmin = 1000000.0;
        double d1 = 0.0;
        double d2 = 0.0;
        int i = 0;
        while (i < ntot) {
            d1 = x[id] - na_models[i][id];
            if ((d1 = dlist[i] + d1 * d1) < dmin) {
                dmin = d1;
                nodex = i;
            }
            d2 = x[idnext] - na_models[i][idnext];
            dlist[i] = d1 - d2 * d2;
            ++i;
        }
        return nodex;
    }

    static void NNaxis_intersect(int id, double[] dlist, double[][] na_models, int ntot, int nodex, NASPACE nasp, doubleW x1, doubleW x2) {
        double xmax;
        double xmin;
        double xc = 0.0;
        double dpc = 0.0;
        double dx = 0.0;
        double xi = 0.0;
        double lo = xmin = nasp.ranget[id][0];
        double hi = xmax = nasp.ranget[id][1];
        double x0 = na_models[nodex][id];
        double dp0 = dlist[nodex];
        int i = 0;
        while (i < ntot) {
            xc = na_models[i][id];
            dpc = dlist[i];
            dx = x0 - xc;
            if (Math.abs(dx) > 1.0E-8 && xmin < (xi = 0.5 * (x0 + xc + (dp0 - dpc) / dx)) && xi < xmax) {
                if (xi > lo && x0 > xc) {
                    lo = xi;
                }
                if (xi < hi && x0 < xc) {
                    hi = xi;
                }
            }
            ++i;
        }
        x1.val = lo;
        x2.val = hi;
    }

    static double na_deviate(double x1, double x2, int i, SOBOL sas) {
        double[] x = new double[]{0.0};
        double deviate = 0.0;
        NA.na_sobol(i, x, 1, 0, sas);
        deviate = x1 + (x2 - x1) * x[0];
        return deviate;
    }

    static int findnearest(double[] xcur, double[][] na_models, int ntot, int nd) {
        int nnode = 0;
        double dmin = 1000000.0;
        double dsum = 0.0;
        double d = 0.0;
        int i = 0;
        while (i < ntot) {
            dsum = 0.0;
            int j = 0;
            while (j < nd) {
                d = xcur[j] - na_models[i][j];
                dsum += d * d;
                ++j;
            }
            if (dsum < dmin) {
                dmin = dsum;
                nnode = i;
            }
            ++i;
        }
        return nnode;
    }

    static void na_misfits(double[] misfit, int ns, int ntot, doubleW mfitmin, doubleW mfitminc, doubleW mfitmean, intW mopt, double[] work, int[] ind, int[] iwork, int[] mfitord) {
        int ibest = 0;
        double mean = 0.0;
        double minc = 1000000.0;
        int n = ntot + ns;
        int i = ntot;
        while (i < n) {
            mean += misfit[i];
            if (misfit[i] < minc) {
                minc = misfit[i];
                ibest = i;
            }
            ++i;
        }
        mean /= (double)ns;
        if (minc < mfitmin.val) {
            mfitmin.val = minc;
            mopt.val = ibest;
        }
        mfitmean.val = mean;
        mfitminc.val = minc;
        if (Config.na_ncells == 1) {
            mfitord[0] = mopt.val;
        } else {
            i = 0;
            while (i < n) {
                ind[i] = i;
                work[i] = misfit[i];
                ++i;
            }
            NA.jumble(ind, work, n);
            NA.selecti(Config.na_ncells, n, work, ind);
            i = 0;
            while (i < Config.na_ncells) {
                iwork[i] = ind[i];
                ++i;
            }
            NA.indexx(Config.na_ncells, work, ind);
            i = 0;
            while (i < Config.na_ncells) {
                mfitord[i] = iwork[ind[i]];
                ++i;
            }
        }
    }

    static void transform2raw(double[] model_sca, NASPACE nasp, double[] model_raw) {
        double a = 0.0;
        double b = 0.0;
        int nd = nasp.nd;
        if (nasp.scale[0] == 0.0) {
            int i = 0;
            while (i < nd) {
                model_raw[i] = model_sca[i];
                ++i;
            }
        } else if (nasp.scale[0] == -1.0) {
            int i = 0;
            while (i < nd) {
                b = model_sca[i];
                a = 1.0 - b;
                model_raw[i] = a * nasp.range[i][0] + b * nasp.range[i][1];
                ++i;
            }
        } else {
            int i = 0;
            while (i < nd) {
                model_raw[i] = nasp.range[i][0] + nasp.scale[i + 1] * model_sca[i];
                ++i;
            }
        }
    }

    static void tolatlon(double[] model_raw, NASPACE nasp) {
        doubleW lat = new doubleW(0.0);
        doubleW lon = new doubleW(0.0);
        Utils.deltaloc(nasp.lat, nasp.lon, model_raw[0], model_raw[1], lat, lon);
        model_raw[0] = lat.val;
        model_raw[1] = lon.val;
    }

    static void jumble(int[] iarr, double[] arr, int n) {
        double rn = 0.0;
        double rval = 0.0;
        rn = n;
        int j = 0;
        while (j < n) {
            rval = ranfib.doub();
            int k = (int)(rval * rn);
            if (k < n) {
                Utils.swap(arr, j, k);
                Utils.swap(iarr, j, k);
            }
            ++j;
        }
    }

    static int irandomvalue(int lo, int hi) {
        int irnum = 0;
        double[] rval = new double[2];
        Sobol.sobseq((int)1, (double[])rval);
        irnum = lo + (int)rval[0] * (hi - lo + 1);
        return irnum;
    }

    static double selecti(int k, int n, double[] arr, int[] ind) {
        int i = 0;
        int ia = 0;
        int ir = 0;
        int j = 0;
        int l = 0;
        int mid = 0;
        double a = 0.0;
        ir = n - 1;
        while (true) {
            if (ir <= l + 1) {
                if (ir == l + 1 && arr[ir] < arr[l]) {
                    Utils.swap(arr, l, ir);
                    Utils.swap(ind, l, ir);
                }
                return arr[k];
            }
            mid = l + ir >> 1;
            Utils.swap(arr, mid, l + 1);
            Utils.swap(ind, mid, l + 1);
            if (arr[l] > arr[ir]) {
                Utils.swap(arr, l, ir);
                Utils.swap(ind, l, ir);
            }
            if (arr[l + 1] > arr[ir]) {
                Utils.swap(arr, l + 1, ir);
                Utils.swap(ind, l + 1, ir);
            }
            if (arr[l] > arr[l + 1]) {
                Utils.swap(arr, l, l + 1);
                Utils.swap(ind, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            ia = ind[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                Utils.swap(arr, i, j);
                Utils.swap(ind, i, j);
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            ind[l + 1] = ind[j];
            ind[j] = ia;
            if (j >= k) {
                ir = j - 1;
            }
            if (j > k) continue;
            l = i;
        }
    }

    static void indexx(int n, double[] arr, int[] indx) {
        int M = 7;
        int NSTACK = 64;
        int i = 0;
        int indxt = 0;
        int ir = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        int jstack = -1;
        double a = 0.0;
        int[] istack = new int[64];
        ir = n - 1;
        j = 0;
        while (j < n) {
            indx[j] = j;
            ++j;
        }
        while (true) {
            if (ir - l < 7) {
                j = l + 1;
                while (j <= ir) {
                    indxt = indx[j];
                    a = arr[indxt];
                    i = j - 1;
                    while (i >= l) {
                        if (arr[indx[i]] <= a) break;
                        indx[i + 1] = indx[i];
                        --i;
                    }
                    indx[i + 1] = indxt;
                    ++j;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            k = l + ir >> 1;
            Utils.swap(indx, k, l + 1);
            if (arr[indx[l]] > arr[indx[ir]]) {
                Utils.swap(indx, l, ir);
            }
            if (arr[indx[l + 1]] > arr[indx[ir]]) {
                Utils.swap(indx, l + 1, ir);
            }
            if (arr[indx[l]] > arr[indx[l + 1]]) {
                Utils.swap(indx, l, l + 1);
            }
            i = l + 1;
            j = ir;
            indxt = indx[l + 1];
            a = arr[indxt];
            while (true) {
                if (arr[indx[++i]] < a) {
                    continue;
                }
                while (arr[indx[--j]] > a) {
                }
                if (j < i) break;
                Utils.swap(indx, i, j);
            }
            indx[l + 1] = indx[j];
            indx[j] = indxt;
            if ((jstack += 2) >= 64) {
                logger.info((Object)String.format("NSTACK too small in index!", new Object[0]));
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    static void na_sas_table(int nt, SOBOL sas) {
        int is = 0;
        int m = 0;
        int j = 0;
        int k = 0;
        int n = 0;
        int md = 0;
        double rval = 0.0;
        if (Config.verbose > 3) {
            logger.info((Object)String.format("            Initializing SAS table", new Object[0]));
        }
        int i = 0;
        while (i < 20000) {
            sas.mdeg[i] = 0;
            sas.pol[i] = 0L;
            k = 0;
            while (k < 30) {
                sas.iv[i][k] = 0L;
                ++k;
            }
            ++i;
        }
        i = 0;
        md = 6;
        while (md < 10) {
            n = (int)(ntot[md] / 100.0);
            k = 0;
            while (k < n) {
                is = (k + 1) % nprim[md];
                sas.mdeg[i] = md;
                sas.pol[i] = pporder[md][is];
                sas.iv[i][0] = 1L;
                j = 1;
                while (j <= md) {
                    rval = ranfib.doub();
                    m = 1 << j;
                    sas.iv[i][j] = 2L * (1L + (long)((double)m * rval)) - 1L;
                    ++j;
                }
                if (++i == nt) break;
                ++k;
            }
            if (i == nt) break;
            ++md;
        }
        sas.n = i;
    }

    static int na_sobol(int n, double[] x, int mode, int init, SOBOL sas) {
        if (init != 0) {
            int k;
            if (n > sas.n) {
                logger.info((Object)String.format("na_sobol: requested number of sequences %d > %d!", n, sas.n));
                return 1;
            }
            if (Config.verbose > 3) {
                logger.info((Object)String.format("            initializing SAS sequence", new Object[0]));
            }
            if (mode == 0) {
                in = 0L;
            } else {
                k = 0;
                while (k < n) {
                    NA.inn[k] = 0L;
                    ++k;
                }
            }
            fac = 9.313225746154785E-10;
            k = 0;
            while (k < 20000) {
                NA.ix[k] = 0L;
                int j = 0;
                while (j < sas.mdeg[k]) {
                    long[] lArray = sas.iv[k];
                    int n2 = j;
                    lArray[n2] = lArray[n2] << 30 - j - 1;
                    ++j;
                }
                j = sas.mdeg[k];
                while (j < 30) {
                    long ipp = sas.pol[k];
                    long i = sas.iv[k][j - sas.mdeg[k]];
                    i ^= i >>> sas.mdeg[k];
                    int m = sas.mdeg[k] - 1;
                    while (m >= 1) {
                        if ((ipp & 1L) != 0L) {
                            i ^= sas.iv[k][j - m];
                        }
                        ipp >>>= 1;
                        --m;
                    }
                    sas.iv[k][j] = i;
                    ++j;
                }
                ++k;
            }
        } else if (mode == 0) {
            long im = in++;
            int j = 0;
            while (j < 30) {
                if ((im & 1L) == 0L) break;
                im >>>= 1;
                ++j;
            }
            if (j >= 30) {
                logger.info((Object)String.format("MAXBIT too small in na_sobol!", new Object[0]));
                j = 29;
            }
            im = j * 20000;
            int m = Math.min(n, 20000);
            int k = 0;
            while (k < m) {
                int n3 = k;
                ix[n3] = ix[n3] ^ sas.iv[k][j];
                x[k] = (double)ix[k] * fac;
                ++k;
            }
        } else {
            int k;
            int n4 = k = n;
            long l = inn[n4];
            inn[n4] = l + 1L;
            long im = l;
            int j = 0;
            while (j < 30) {
                if ((im & 1L) == 0L) break;
                im >>>= 1;
                ++j;
            }
            if (j >= 30) {
                logger.info((Object)String.format("MAXBIT too small in na_sobol!", new Object[0]));
                j = 29;
            }
            im = j * 20000;
            int n5 = k;
            ix[n5] = ix[n5] ^ sas.iv[k][j];
            x[0] = (double)ix[k] * fac;
        }
        return 0;
    }

    static void writemodels(double[][] na_models, NASPACE nasp, double[] misfit) {
        String timestr;
        StringBuilder sb;
        int k;
        int ns = 0;
        int np = 0;
        int jj = 0;
        int mopt = 0;
        double mean = 0.0;
        double minfit = 0.0;
        double minfitc = 0.0;
        double[] model_raw = new double[4];
        logger.info((Object)String.format("    Parameter space search using a Neighbourhood algorithm", new Object[0]));
        logger.info((Object)String.format("      Misfit Lp-norm : %4.2f", nasp.lpnorm));
        ns = Config.na_nsamplei;
        minfit = misfit[0];
        int it = 0;
        while (it <= Config.na_itermax) {
            minfitc = misfit[np];
            mean = 0.0;
            int i = 0;
            while (i < ns) {
                jj = np + i;
                if (misfit[jj] < minfit) {
                    minfit = misfit[jj];
                    mopt = jj;
                }
                if (misfit[jj] < minfitc) {
                    minfitc = misfit[jj];
                }
                mean += misfit[jj];
                ++i;
            }
            logger.info((Object)String.format("    iteration %5d,  misfit: mean = %10.4f min = %9.4f best so far = %9.4f", it, mean /= (double)ns, minfitc, minfit));
            i = 0;
            while (i < ns) {
                jj = np + i;
                NA.transform2raw(na_models[jj], nasp, model_raw);
                if (!nasp.epifix) {
                    NA.tolatlon(model_raw, nasp);
                }
                k = 0;
                sb = new StringBuilder(128);
                sb.append(String.format("      %4d ", jj));
                if (nasp.epifix) {
                    sb.append(String.format("%7.3f %8.3f ", nasp.lat, nasp.lon));
                } else {
                    sb.append(String.format("%7.3f %8.3f ", model_raw[k], model_raw[k + 1]));
                    k += 2;
                }
                if (nasp.otfix) {
                    sb.append(String.format("%15.3f ", nasp.ot));
                } else {
                    sb.append(String.format("%15.3f ", model_raw[k]));
                    ++k;
                }
                if (nasp.depfix) {
                    sb.append(String.format("%7.3f ", nasp.depth));
                } else {
                    sb.append(String.format("%7.3f ", model_raw[k]));
                }
                sb.append(String.format("%9.4f", misfit[jj]));
                logger.info((Object)sb.substring(0));
                ++i;
            }
            np += ns;
            ns = Config.na_nsample;
            ++it;
        }
        NA.transform2raw(na_models[mopt], nasp, model_raw);
        if (!nasp.epifix) {
            NA.tolatlon(model_raw, nasp);
        }
        if (!nasp.otfix) {
            k = nasp.epifix ? 0 : 2;
            timestr = Utils.human_time(model_raw[k]);
        } else {
            timestr = Utils.human_time(nasp.ot);
        }
        logger.info((Object)String.format("    Best model:", new Object[0]));
        logger.info((Object)String.format("       id   lat      lon     origin time             depth    misfit", new Object[0]));
        k = 0;
        sb = new StringBuilder(128);
        sb.append(String.format("      %5d ", mopt));
        if (nasp.epifix) {
            sb.append(String.format("%7.3f %8.3f ", nasp.lat, nasp.lon));
        } else {
            sb.append(String.format("%7.3f %8.3f ", model_raw[k], model_raw[k + 1]));
            k += 2;
        }
        if (!nasp.otfix) {
            ++k;
        }
        sb.append(String.format("%s ", timestr));
        if (nasp.depfix) {
            sb.append(String.format("%7.3f ", nasp.depth));
        } else {
            sb.append(String.format("%7.3f ", model_raw[k]));
        }
        sb.append(String.format("%9.4f", misfit[mopt]));
        logger.info((Object)sb.substring(0));
    }

    public static double dosamples(int i, int ntot, double[] na_model, NASPACE nasp, int np, int nsta, ISCSol sp, READING[] rdindx, ISCPha[] pgs, TT_TABLE[] tt_tables, EC_COEF[] ec, short[][] topo, ISCSta[] stalist, double[][] distmatrix, VarioGram variogramp, PrintWriter fp) {
        ISCSol s = new ISCSol();
        double[] model_raw = new double[4];
        double misfit = 9999.0;
        StringW buf = new StringW("");
        int j = ntot + i;
        ISCPha[] pset = new ISCPha[np];
        int n = 0;
        while (n < pset.length) {
            pset[n] = new ISCPha();
            ++n;
        }
        int k = 0;
        while (k < np) {
            pset[k] = new ISCPha(pgs[k]);
            ++k;
        }
        s = new ISCSol(sp);
        NA.transform2raw(na_model, nasp, model_raw);
        if (!nasp.epifix) {
            NA.tolatlon(model_raw, nasp);
        }
        misfit = NA.forward(nsta, nasp, model_raw, s, rdindx, pset, tt_tables, ec, topo, stalist, distmatrix, variogramp, buf);
        if (Config.write_gridsearch_results != 0) {
            k = 0;
            fp.printf("%4d %3d ", j, i);
            if (nasp.epifix) {
                fp.printf("%8.4f %9.4f ", nasp.lat, nasp.lon);
            } else {
                fp.printf("%8.4f %9.4f ", model_raw[k], model_raw[k + 1]);
                k += 2;
            }
            if (nasp.otfix) {
                fp.printf("%15.3f ", nasp.ot);
            } else {
                fp.printf("%15.3f ", model_raw[k]);
                ++k;
            }
            if (nasp.depfix) {
                fp.printf("%8.4f ", nasp.depth);
            } else {
                fp.printf("%8.4f ", model_raw[k]);
            }
            fp.printf("%10.4f %s\n", misfit, buf);
        }
        pset = null;
        return misfit;
    }
}

