/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Cluster;
import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.DataCovariance;
import cn.org.gddsn.seis.location.iscloc2.DepthPhases;
import cn.org.gddsn.seis.location.iscloc2.EC_COEF;
import cn.org.gddsn.seis.location.iscloc2.FE;
import cn.org.gddsn.seis.location.iscloc2.GeoRegion;
import cn.org.gddsn.seis.location.iscloc2.ISCEvent;
import cn.org.gddsn.seis.location.iscloc2.ISCHyp;
import cn.org.gddsn.seis.location.iscloc2.ISCHypQual;
import cn.org.gddsn.seis.location.iscloc2.ISCPha;
import cn.org.gddsn.seis.location.iscloc2.ISCSol;
import cn.org.gddsn.seis.location.iscloc2.ISCSta;
import cn.org.gddsn.seis.location.iscloc2.ISFIO;
import cn.org.gddsn.seis.location.iscloc2.Initializations;
import cn.org.gddsn.seis.location.iscloc2.LocQual;
import cn.org.gddsn.seis.location.iscloc2.MAGQ;
import cn.org.gddsn.seis.location.iscloc2.MSZH;
import cn.org.gddsn.seis.location.iscloc2.Magnitude;
import cn.org.gddsn.seis.location.iscloc2.NA;
import cn.org.gddsn.seis.location.iscloc2.NASPACE;
import cn.org.gddsn.seis.location.iscloc2.PhaseIds;
import cn.org.gddsn.seis.location.iscloc2.PhaseList;
import cn.org.gddsn.seis.location.iscloc2.RDMAG;
import cn.org.gddsn.seis.location.iscloc2.READING;
import cn.org.gddsn.seis.location.iscloc2.STAMAG;
import cn.org.gddsn.seis.location.iscloc2.SVD;
import cn.org.gddsn.seis.location.iscloc2.StaOrder;
import cn.org.gddsn.seis.location.iscloc2.TT_TABLE;
import cn.org.gddsn.seis.location.iscloc2.TravelTimes;
import cn.org.gddsn.seis.location.iscloc2.Uncertainty;
import cn.org.gddsn.seis.location.iscloc2.Utils;
import cn.org.gddsn.seis.location.iscloc2.VarioGram;
import java.io.PrintWriter;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class Locator {
    static Logger logger = Logger.getLogger(Locator.class);

    private Locator() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int eventloc(int isf, int database, intW total, intW fail, int[] opt, ISCEvent e, ISCHyp[] h, ISCSol s, ISCPha[] p, STAMAG[] stamag_mb, STAMAG[] stamag_ms, RDMAG[] rdmag_mb, RDMAG[] rdmag_ms, MSZH[] mszh, int ismbQ, MAGQ mbQ, EC_COEF[] ec, TT_TABLE[] tt_tables, VarioGram variogram, double gres, int ngrid, double[][] depthgrid, FE fe, double[] grn_depth, short[][] topo, PrintWriter isfout) {
        int i;
        ISCHyp starthyp = new ISCHyp();
        ISCSol grds = new ISCSol();
        ISCHypQual hq = new ISCHypQual();
        NASPACE nasp = new NASPACE();
        double[][] distmatrix = null;
        StaOrder[] staorder = null;
        READING[] rdindx = null;
        String filename = null;
        int iszderiv = 0;
        boolean firstpass = true;
        int do_gridsearch_cf = Config.do_gridsearch;
        int option = 0;
        int grn = 0;
        int has_depth_resolution = 0;
        int has_depdpres = 0;
        int isdefdep = 0;
        int nsta = 0;
        int ndef = 0;
        int ndefinit = 0;
        double loss = 0.0;
        double mediandepth = 0.0;
        double medianot = 0.0;
        double medianlat = 0.0;
        double medianlon = 0.0;
        int iflag = Config.do_gridsearch;
        Utils.t0 = (double)System.currentTimeMillis() / 1000.0;
        if (Initializations.init_event(e, h) != 0) {
            logger.warn((Object)String.format("ABORT: event initialization failed!", new Object[0]));
            return 1;
        }
        Utils.print_hyp(e, h);
        if (e.numphas < Config.min_phases) {
            logger.warn((Object)String.format("ABORT: insufficient number of phases (%d)", e.numphas));
            e.hypo_fix = true;
        }
        rdindx = new READING[e.numrd];
        int k = 0;
        while (k < rdindx.length) {
            rdindx[k] = new READING();
            ++k;
        }
        Locator.readings(e.numphas, e.numrd, p, rdindx);
        if (e.hypo_fix) {
            logger.info((Object)String.format("Calculate residuals for fixed hypocentre", new Object[0]));
            Locator.synthetic(e, h[0], s, rdindx, p, ec, tt_tables, topo, database, isf);
            opt[6] = opt[6] + 1;
            rdindx = null;
            return 0;
        }
        Initializations.start_hyp(e, h, starthyp);
        String timestr = Utils.human_time(starthyp.time);
        logger.info((Object)String.format("Median hypocentre:", new Object[0]));
        logger.info((Object)String.format("  OT = %s Lat = %7.3f Lon = %8.3f Depth = %.1f", timestr, starthyp.lat, starthyp.lon, starthyp.depth));
        intW nstaW = new intW(0);
        ISCSta[] stalist = DataCovariance.get_stalist(e.numphas, p, nstaW);
        nsta = nstaW.val;
        if (Config.do_correlated_errors != 0) {
            staorder = new StaOrder[nsta];
            i = 0;
            while (i < nsta) {
                staorder[i] = new StaOrder();
                ++i;
            }
            distmatrix = DataCovariance.distance_matrix(nsta, stalist);
            if (Cluster.HierarchicalCluster(nsta, distmatrix, staorder) != 0) {
                logger.warn((Object)String.format("ABORT: HierarchicalCluster failed!", new Object[0]));
                stalist = null;
                staorder = null;
                distmatrix = null;
                rdindx = null;
                return 1;
            }
        }
        option = 0;
        while (option < 2) {
            block85: {
                block93: {
                    block92: {
                        block91: {
                            block90: {
                                block89: {
                                    block87: {
                                        block88: {
                                            Config.errorcode = 0;
                                            if (e.depth_fix) {
                                                option = 2;
                                            }
                                            if (e.fix_depth_default) {
                                                option = 1;
                                            }
                                            if (e.fix_depth_depdp) {
                                                option = 3;
                                            }
                                            if (e.epi_fix) {
                                                option = e.depth_fix ? 5 : 4;
                                            }
                                            logger.info((Object)String.format("Option %d", option));
                                            s.number_of_unknowns = option == 0 ? 4 : (option == 4 ? 2 : (option == 5 ? 1 : 3));
                                            s.number_of_unknowns = s.number_of_unknowns - (e.time_fix ? 1 : 0);
                                            iszderiv = option == 0 || option == 4 ? 1 : 0;
                                            if (option == 0 || option == 4) {
                                                s.depfixtype = 0;
                                            }
                                            if (option == 2 || option == 5) {
                                                if (e.depth_fix_editor) {
                                                    s.depfixtype = 8;
                                                } else if (e.surface_fix) {
                                                    s.depfixtype = 4;
                                                } else if (Config.streq(e.depth_agency, "")) {
                                                    s.depfixtype = 6;
                                                    isdefdep = 1;
                                                } else {
                                                    s.depfixtype = 2;
                                                }
                                            }
                                            if (option == 3) {
                                                s.depfixtype = 3;
                                            }
                                            if (!firstpass) break block87;
                                            if (Initializations.init_sol(s, e, starthyp) == 0) break block88;
                                            logger.warn((Object)String.format("    WARNING: init_sol failed!", new Object[0]));
                                            break block85;
                                        }
                                        mediandepth = s.depth;
                                        medianot = s.time;
                                        medianlat = s.lat;
                                        medianlon = s.lon;
                                    }
                                    if (option == 1) {
                                        s.depth = mediandepth;
                                        intW isdefdepW = new intW(isdefdep);
                                        s.depth = GeoRegion.get_default_depth(s, ngrid, gres, depthgrid, fe, grn_depth, isdefdepW);
                                        isdefdep = isdefdepW.val;
                                        if (Math.abs(s.depth - mediandepth) > 20.0) {
                                            logger.warn((Object)"Large depth difference, fall back to median hypocentre");
                                            s.time = medianot;
                                            s.lat = medianlat;
                                            s.lon = medianlon;
                                            s.depth = mediandepth;
                                            isdefdepW = new intW(isdefdep);
                                            s.depth = GeoRegion.get_default_depth(s, ngrid, gres, depthgrid, fe, grn_depth, isdefdepW);
                                            isdefdep = isdefdepW.val;
                                        }
                                        s.time += (s.depth - mediandepth) / 10.0;
                                        if (Math.abs(s.depth - mediandepth) > 20.0) {
                                            firstpass = true;
                                        }
                                    }
                                    s.depfix = option != 0 && option != 4;
                                    timestr = Utils.human_time(s.time);
                                    logger.info((Object)String.format("Initial hypocentre:", new Object[0]));
                                    logger.info((Object)String.format("  OT = %s Lat = %7.3f Lon = %8.3f Depth = %.1f", timestr, s.lat, s.lon, s.depth));
                                    Utils.calc_delaz(s, p, true);
                                    ndefinit = PhaseIds.id_pha(s, rdindx, p, ec, tt_tables, topo);
                                    if (PhaseIds.mark_duplicates(s, p, ec, tt_tables, topo) != 0) break block85;
                                    if (Config.do_gridsearch != 0 && firstpass) {
                                        logger.info((Object)String.format("Neighbourhood algorithm (%.4f)", Utils.secs(Utils.t0)));
                                        grds = new ISCSol(s);
                                        if (NA.set_searchspace(grds, nasp) != 0) {
                                            logger.warn((Object)"    WARNING: set_searchspace failed!");
                                        } else {
                                            if (Config.write_gridsearch_results != 0) {
                                                filename = String.format("%d.%d.gsres", e.evid, option);
                                            }
                                            if (NA.na_search(nsta, grds, p, tt_tables, ec, topo, stalist, distmatrix, variogram, staorder, nasp, filename) != 0) {
                                                logger.warn((Object)"    WARNING: na_search failed!");
                                                grds = new ISCSol(s);
                                            } else {
                                                s.lat = grds.lat;
                                                s.lon = grds.lon;
                                                s.time = grds.time;
                                                s.depth = grds.depth;
                                                timestr = Utils.human_time(s.time);
                                                logger.info((Object)String.format("Best fitting hypocentre from grid search:", new Object[0]));
                                                logger.info((Object)String.format("  OT = %s Lat = %7.3f Lon = %8.3f Depth = %.1f", timestr, s.lat, s.lon, s.depth));
                                                logger.info((Object)String.format("Reidentify phases after NA", new Object[0]));
                                                Utils.calc_delaz(s, p, false);
                                                PhaseIds.reidentify_pha(s, rdindx, p, ec, tt_tables, topo);
                                                PhaseIds.mark_duplicates(s, p, ec, tt_tables, topo);
                                            }
                                            logger.info((Object)String.format("NA (%.4f) done", Utils.secs(Utils.t0)));
                                        }
                                    }
                                    firstpass = false;
                                    if (TravelTimes.calc_resid(s, p, "use", ec, tt_tables, topo, iszderiv) != 0) break block85;
                                    ndef = 0;
                                    i = 0;
                                    while (i < s.numphas) {
                                        if (p[i].timedef) {
                                            ++ndef;
                                        }
                                        ++i;
                                    }
                                    loss = ndefinit != 0 ? 100.0 * ((double)(ndefinit - ndef) / (double)ndefinit) : 100.0;
                                    if (ndef >= s.number_of_unknowns) break block89;
                                    logger.warn((Object)String.format("Insufficient number (%d) of phases left; ", ndef));
                                    logger.warn((Object)String.format("%.0f%% phase loss!", loss));
                                    Config.errorcode = 7;
                                    break block85;
                                }
                                i = option == 0 || option == 4 ? 1 : 0;
                                has_depdpres = DepthPhases.depth_phase_check(s, rdindx, p, i != 0);
                                if (option != 3 || has_depdpres != 0) break block90;
                                logger.warn((Object)String.format("ABORT: insufficient number of depth phases ", new Object[0]));
                                logger.warn((Object)String.format("to perform option 3!", new Object[0]));
                                break block85;
                            }
                            ndef = 0;
                            i = 0;
                            while (i < s.numphas) {
                                if (p[i].timedef) {
                                    ++ndef;
                                }
                                ++i;
                            }
                            loss = ndefinit != 0 ? 100.0 * ((double)(ndefinit - ndef) / (double)ndefinit) : 100.0;
                            if (ndef >= s.number_of_unknowns) break block91;
                            logger.warn((Object)String.format("Insufficient number (%d) of phases left; ", ndef));
                            logger.warn((Object)String.format("%.0f%% phase loss!", loss));
                            Config.errorcode = 7;
                            break block85;
                        }
                        i = option == 0 || option == 4 ? 1 : 0;
                        has_depth_resolution = DepthPhases.depth_resolution(s, rdindx, p, i != 0);
                        if (has_depdpres != 0) {
                            has_depth_resolution = 1;
                        }
                        if (has_depth_resolution != 0 || option != 0 && option != 4) break block92;
                        logger.warn((Object)String.format("No depth resolution for free-depth solution!", new Object[0]));
                        if (Math.abs(s.depth - mediandepth) > 20.0) {
                            firstpass = true;
                        }
                        break block85;
                    }
                    logger.info((Object)"Event location");
                    ndefinit = ndef;
                    if (Locator.locate_event(option, nsta, has_depdpres, s, rdindx, p, ec, tt_tables, stalist, distmatrix, variogram, staorder, topo) == 0) break block93;
                    if (iflag != 0) {
                        Config.do_gridsearch = 0;
                        iflag = 0;
                        firstpass = true;
                        if (--option > 0) {
                            option = 0;
                        }
                        logger.info((Object)"Try again without the grid search");
                        break block85;
                    } else if (option == 0) {
                        firstpass = true;
                        break block85;
                    } else {
                        logger.warn((Object)String.format("locator failed!", new Object[0]));
                    }
                    break block85;
                }
                if (s.converged != 0) {
                    if (option != 0 || !(s.depth > 0.0 && s.depth <= Config.moho && s.error[3] > Config.maxdeperror_shallow) && (!(s.depth > Config.moho) || !(s.error[3] > Config.maxdeperror_deep))) break;
                    logger.info((Object)String.format("Discarded free-depth solution!", new Object[0]));
                    logger.info((Object)String.format("     depth = %5.1f depth error = %.1f", s.depth, s.error[3]));
                    firstpass = true;
                }
            }
            ++option;
        }
        Config.do_gridsearch = do_gridsearch_cf;
        if (Config.verbose > 0) {
            logger.info((Object)String.format("End of option loop (%.2f)", Utils.secs(Utils.t0)));
        }
        stalist = null;
        if (Config.do_correlated_errors != 0) {
            distmatrix = null;
            staorder = null;
        }
        if (s.converged != 0) {
            logger.info((Object)String.format("Convergent solution, final touches", new Object[0]));
            if (option != 3) {
                s.depdp_error = 9999999.0;
                s.depdp = 9999999.0;
                has_depdpres = DepthPhases.depth_phase_check(s, rdindx, p, true);
                if (has_depdpres != 0) {
                    DepthPhases.depth_phase_stack(s, p, tt_tables, topo);
                    if (s.depdp != 9999999.0) {
                        logger.info((Object)String.format("    ndp = %d, depth=%.1f, depth error=%.1f", s.ndp, s.depdp, s.depdp_error));
                    }
                }
            }
            PhaseIds.id_pfake(s, p, ec, tt_tables, topo);
            TravelTimes.calc_resid(s, p, "all", ec, tt_tables, topo, 0);
            PhaseIds.remove_pfake(s, p);
            if (LocQual.location_quality(s.numphas, p, hq) == 0) {
                s.azimgap = hq.whole_net.gap;
                s.mindist = hq.whole_net.mindist;
                s.maxdist = hq.whole_net.maxdist;
            }
            Magnitude.calc_netmag(s, rdindx, p, stamag_mb, stamag_ms, rdmag_mb, rdmag_ms, mszh, ismbQ, mbQ);
            grn = GeoRegion.gregnum(s.lat, s.lon, fe);
            Utils.print_pha(s.numphas, p);
            Utils.print_sol(s, grn);
            StringBuffer sb = new StringBuffer(128);
            sb.append(String.format("    etype=%s nreading=%d nass=%d ndef=%d ndefsta=%d nrank=%d", e.etype.trim(), s.nreading, s.nass, s.ndef, s.ndefsta, s.prank));
            if (s.sdobs != 9999999.0) {
                sb.append(String.format(" sdobs=%.3f", s.sdobs));
            }
            sb.append(String.format(" sgap=%5.1f", hq.whole_net.sgap));
            logger.info((Object)sb.substring(0));
            sb = new StringBuffer(128);
            if (s.smajax != 9999999.0) {
                sb.append(String.format("    smajax=%.1f sminax=%.1f strike=%.1f", s.smajax, s.sminax, s.strike));
            }
            if (s.error[0] != 9999999.0) {
                sb.append(String.format(" stime=%.3f", s.error[0]));
            }
            if (s.error[3] != 9999999.0) {
                sb.append(String.format(" sdepth=%.1f", s.error[3]));
            }
            logger.info((Object)sb.substring(0));
            if (s.depdp != 9999999.0) {
                logger.info((Object)String.format("    depdp=%.2f +/- %.2f ndp=%d", s.depdp, s.depdp_error, s.ndp));
            }
            if (e.epi_fix) {
                if (Config.streq(e.location_agency, "")) {
                    logger.info((Object)String.format("    epicentre fixed to median epicentre", new Object[0]));
                } else {
                    logger.info((Object)String.format("    epicentre fixed to %s epicentre", e.location_agency));
                }
            }
            if (e.time_fix) {
                if (Config.streq(e.time_agency, "")) {
                    logger.info((Object)String.format("    origin time fixed to median origin time", new Object[0]));
                } else {
                    logger.info((Object)String.format("    origin time fixed to %s origin time", e.time_agency));
                }
            }
            if (s.depfixtype == 8) {
                logger.info((Object)String.format("    depth fixed by editor", new Object[0]));
            } else if (s.depfixtype == 1) {
                logger.info((Object)String.format("    airquake, depth fixed to surface", new Object[0]));
            } else if (s.depfixtype == 2) {
                logger.info((Object)String.format("    depth fixed to %s depth", e.depth_agency));
            } else if (s.depfixtype == 3) {
                logger.info((Object)String.format("    depth fixed to depth-phase depth", new Object[0]));
            } else if (s.depfixtype == 4) {
                logger.info((Object)String.format("    anthropogenic event, depth fixed to surface", new Object[0]));
            } else if (s.depfixtype == 5) {
                logger.info((Object)String.format("    depth fixed to default depth grid depth", new Object[0]));
            } else if (s.depfixtype == 6) {
                if (isdefdep == 0) {
                    logger.info((Object)String.format("    no default depth grid point exists, depth fixed to median reported depth", new Object[0]));
                } else {
                    logger.info((Object)String.format("    depth fixed to median reported depth", new Object[0]));
                }
            } else if (s.depfixtype == 7) {
                logger.info((Object)String.format("    no default depth grid point exists, depth fixed to GRN-dependent depth", new Object[0]));
            } else {
                logger.info((Object)String.format("    free-depth solution", new Object[0]));
            }
            loss = ndefinit != 0 ? 100.0 * ((double)(ndefinit - s.ndef) / (double)ndefinit) : 100.0;
            logger.info((Object)String.format("    %.0f%% of phases were made non-defining", loss));
            logger.info((Object)String.format("    local network:  nsta=%d ndef=%d sgap=%5.1f dU=%5.3f ndefsta_10km=%d GT5cand=%d", hq.local_net.ndefsta, hq.local_net.ndef, hq.local_net.sgap, hq.local_net.du, hq.ndefsta_10km, hq.gtcand));
            if (s.bodymag != 9999999.0) {
                logger.info((Object)String.format("    mb=%.2f +/- %.2f nsta=%d", s.bodymag, s.bodymag_uncertainty, s.nsta_mb));
            }
            if (s.surfmag != 9999999.0) {
                logger.info((Object)String.format("    MS=%.2f +/- %.2f nsta=%d", s.surfmag, s.surfmag_uncertainty, s.nsta_ms));
            }
            int n = option;
            opt[n] = opt[n] + 1;
            ++total.val;
            if (Config.isf_outfile.length() != 0) {
                i = s.hypid;
                s.hypid = total.val;
                ISFIO.write_isf(isfout, e, s, h, p, rdmag_mb, rdmag_ms, grn);
                s.hypid = i;
            }
        } else {
            ++fail.val;
            if (isf != 0) {
                return 1;
            }
            e.start_depth = 9999999.0;
            e.start_lat = 9999999.0;
            e.start_lon = 9999999.0;
            e.start_time = 9999999.0;
            if (Config.streq(h[0].agency, Config.in_agency)) {
                if (e.numhyps <= 1) {
                    logger.warn((Object)String.format("WARNING: Search event %d could not ", e.evid));
                    logger.warn((Object)String.format("converge and should be banished", new Object[0]));
                    logger.warn((Object)String.format("FAILURE", new Object[0]));
                    return 1;
                }
                logger.info((Object)String.format("Set prime to %s", h[1].agency));
                Utils.swap(h, 1, 0);
            }
            logger.info((Object)String.format("Calculate residuals w.r.t. previous prime", new Object[0]));
            Locator.fixedhypo(e, h[0], s, rdindx, p, ec, tt_tables, topo);
            Utils.print_pha(s.numphas, p);
            logger.info((Object)String.format("FAILURE", new Object[0]));
            return 1;
        }
        logger.info((Object)String.format("Finished event %d (%.2f)", e.evid, Utils.secs(Utils.t0)));
        return 0;
    }

    public static void synthetic(ISCEvent ep, ISCHyp hp, ISCSol sp, READING[] rdindx, ISCPha[] p, EC_COEF[] ec, TT_TABLE[] tt_tables, short[][] topo, int database, int isf) {
        logger.info((Object)String.format("Calculating residuals for a fixed hypocentre", new Object[0]));
        sp.number_of_unknowns = 0;
        Locator.fixedhypo(ep, hp, sp, rdindx, p, ec, tt_tables, topo);
        Utils.print_pha(sp.numphas, p);
        if (isf != 0) {
            return;
        }
    }

    public static void fixedhypo(ISCEvent ep, ISCHyp hp, ISCSol sp, READING[] rdindx, ISCPha[] p, EC_COEF[] ec, TT_TABLE[] tt_tables, short[][] topo) {
        if (Config.verbose > 0) {
            logger.info((Object)String.format("    init_sol", new Object[0]));
        }
        if (hp.depth == 9999999.0 || hp.depth < 0.0) {
            hp.depth = Config.default_depth;
        }
        Initializations.init_sol(sp, ep, hp);
        if (Config.verbose > 0) {
            logger.info((Object)String.format("    calc_delaz", new Object[0]));
        }
        Utils.calc_delaz(sp, p, true);
        if (Config.verbose > 0) {
            logger.info((Object)String.format("    id_pha", new Object[0]));
        }
        PhaseIds.id_pha(sp, rdindx, p, ec, tt_tables, topo);
        if (Config.verbose > 0) {
            logger.info((Object)String.format("    id_pfake", new Object[0]));
        }
        PhaseIds.id_pfake(sp, p, ec, tt_tables, topo);
        if (Config.verbose > 0) {
            logger.info((Object)String.format("    calc_resid", new Object[0]));
        }
        TravelTimes.calc_resid(sp, p, "all", ec, tt_tables, topo, 0);
        if (Config.verbose > 0) {
            logger.info((Object)String.format("    remove_pfake", new Object[0]));
        }
        PhaseIds.remove_pfake(sp, p);
    }

    public static int locate_event(int option, int nsta, int has_depdpres, ISCSol sp, READING[] rdindx, ISCPha[] p, EC_COEF[] ec, TT_TABLE[] tt_tables, ISCSta[] stalist, double[][] distmatrix, VarioGram variogramp, StaOrder[] staorder, short[][] topo) {
        int j;
        int m = 0;
        int iserr = 0;
        int isconv = 0;
        int isdiv = 0;
        int[] nds = new int[3];
        int iszderiv = 0;
        int fixdepthfornow = 0;
        int nairquakes = 0;
        int ndeepquakes = 0;
        int ndef = 0;
        int nd = 0;
        int nr = 0;
        intW prank = new intW(0);
        intW dpok = new intW(0);
        intW ischanged = new intW(0);
        intW nunp = new intW(0);
        int ispchange = 0;
        double[][] g = null;
        double[][] v = null;
        double[][] dcov = null;
        double[][] w = null;
        double[] d = null;
        double[] sv = null;
        double[] svundamped = new double[4];
        double[][] mcov = new double[4][4];
        double[] sol = new double[4];
        double[] oldsol = new double[4];
        double[] modelnorm = new double[3];
        double[] convgtest = new double[3];
        double toffset = 0.0;
        double torg = 0.0;
        double delta = 0.0;
        double azim = 0.0;
        double svth = 0.0;
        double damp = 0.0;
        double dmax = 0.0;
        double step = 0.0;
        double prev_depth = 0.0;
        double urms = 0.0;
        double scale = 0.0;
        double gtd = 0.0;
        double gtdnorm = 0.0;
        double gnorm = 0.0;
        double mnorm = 0.0;
        double cnvgtst = 0.0;
        double oldcvgtst = 0.0;
        double loss = 0.0;
        doubleW dnorm = new doubleW(0.0);
        doubleW wrms = new doubleW(0.0);
        doubleW cond = new doubleW(0.0);
        String[] phundef = new String[200];
        dpok.val = has_depdpres;
        prev_depth = sp.depth;
        doubleW toffsetW = new doubleW(toffset);
        nd = Locator.getndef(sp.numphas, p, nsta, stalist, toffsetW);
        toffset = toffsetW.val;
        prank.val = nd;
        if (nd < 0) {
            return 1;
        }
        if (nd <= sp.number_of_unknowns) {
            if (Config.verbose > 0) {
                logger.info((Object)String.format("locate_event: insufficient number of phases (%d)!", nd));
            }
            Config.errorcode = 5;
            return 1;
        }
        torg = sp.time - toffset;
        int i = 0;
        while (i < 4) {
            sol[i] = 0.0;
            oldsol[i] = 0.0;
            ++i;
        }
        i = 0;
        if (!sp.timfix) {
            sol[i++] = torg;
        }
        if (!sp.epifix) {
            sol[i++] = sp.lon;
            sol[i++] = sp.lat;
        }
        if (!sp.depfix) {
            sol[i] = sp.depth;
        }
        ndeepquakes = 0;
        nairquakes = 0;
        isdiv = 0;
        isconv = 0;
        ispchange = 0;
        ischanged.val = 0;
        iserr = 1;
        oldcvgtst = 1.0;
        step = 1.0;
        i = 0;
        while (i < 4) {
            sp.covar[i][i] = 9999999.0;
            sp.error[i] = 9999999.0;
            j = i + 1;
            while (j < 4) {
                sp.covar[j][i] = 9999999.0;
                sp.covar[i][j] = 9999999.0;
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < 3) {
            modelnorm[j] = 0.0;
            convgtest[j] = 0.0;
            nds[j] = 0;
            ++j;
        }
        nds[0] = nd;
        if (Config.do_correlated_errors != 0) {
            DataCovariance.sort_phaserec_nn(sp.numphas, nsta, p, stalist, staorder);
            Locator.readings(sp.numphas, sp.nreading, p, rdindx);
            dpok.val = DepthPhases.depth_phase_check(sp, rdindx, p, false);
            if (Config.verbose > 3) {
                Utils.print_pha(sp.numphas, p);
            }
        }
        if (Config.verbose > 0) {
            logger.info((Object)String.format("Start iteration loop (%.4f)", Utils.secs(Utils.t0)));
        }
        int iter = 0;
        while (iter < Config.max_iter) {
            StringBuilder sb;
            if (Config.verbose > 0) {
                logger.info((Object)String.format("iteration = %d", iter));
            }
            m = sp.number_of_unknowns;
            iszderiv = 1;
            if (option == 0 || option == 4) {
                fixdepthfornow = 0;
                if (iter < Config.min_iter - 1) {
                    fixdepthfornow = 1;
                    --m;
                } else if (sp.depth < 0.0) {
                    if (Config.verbose > 0) {
                        logger.info((Object)String.format("    airquake, fixing depth to 0", new Object[0]));
                    }
                    ++nairquakes;
                    sp.depth = 0.0;
                    fixdepthfornow = 1;
                    --m;
                } else if (sp.depth > Config.max_depth_km) {
                    if (Config.verbose > 0) {
                        logger.info((Object)String.format("    deepquake, fixing depth to max depth", new Object[0]));
                    }
                    ++ndeepquakes;
                    sp.depth = Config.max_depth_km;
                    fixdepthfornow = 1;
                    --m;
                }
            } else {
                fixdepthfornow = 1;
            }
            if (nairquakes > 2 || ndeepquakes > 2) {
                fixdepthfornow = 1;
                m = sp.number_of_unknowns - 1;
                sp.depfixtype = 1;
            }
            if (fixdepthfornow != 0) {
                iszderiv = 0;
            }
            Utils.calc_delaz(sp, p, false);
            if (sp.depth > Config.moho && prev_depth <= Config.moho || sp.depth < Config.moho && prev_depth >= Config.moho || sp.depth > Config.conrad && prev_depth <= Config.conrad || sp.depth < Config.conrad && prev_depth >= Config.conrad) {
                if (Config.verbose > 0) {
                    logger.info((Object)String.format("    depth: %.2f prev_depth: %.2f; reidentifying phases", sp.depth, prev_depth));
                }
                ispchange = PhaseIds.reidentify_pha(sp, rdindx, p, ec, tt_tables, topo);
                PhaseIds.mark_duplicates(sp, p, ec, tt_tables, topo);
            }
            intW ndefW = new intW(ndef);
            int ret_tmp = Locator.getresids(sp, rdindx, p, ec, tt_tables, topo, iszderiv, dpok, ndefW, ischanged, iter, ispchange, nd, nunp, phundef, dcov, w);
            ndef = ndefW.val;
            if (ret_tmp != 0) break;
            if (ndef <= sp.number_of_unknowns) {
                loss = 100.0 * ((double)(nd - ndef) / (double)nd);
                if (Config.verbose > 0) {
                    logger.info((Object)String.format("Insufficient number (%d) of phases left; %.0f%% phase loss!", ndef, loss));
                }
                Config.errorcode = 7;
                break;
            }
            j = 2;
            while (j > 0) {
                nds[j] = nds[j - 1];
                --j;
            }
            nds[0] = ndef;
            if (iter == 0) {
                nd = ndef;
                prank.val = ndef;
                g = new double[nd][4];
                v = new double[4][4];
                d = new double[nd];
                sv = new double[4];
                if (Config.do_correlated_errors != 0 && ((dcov = DataCovariance.data_covariance_matrix(nsta, sp.numphas, nd, p, stalist, distmatrix, variogramp)) == null || SVD.projection_matrix(sp.numphas, p, nd, 95.0, dcov, w = new double[nd][nd], prank, nunp.val, phundef, 1) != 0)) {
                    break;
                }
            } else if (ispchange != 0) {
                if (nd != ndef) {
                    g = null;
                    d = null;
                    isconv = 0;
                    nd = ndef;
                    g = new double[nd][4];
                    d = new double[nd];
                }
                if (Config.do_correlated_errors != 0) {
                    if (Config.verbose > 0) {
                        logger.info((Object)String.format("    Changes in defining phasenames, recalculating projection matrix", new Object[0]));
                    }
                    dcov = null;
                    w = null;
                    dcov = DataCovariance.data_covariance_matrix(nsta, sp.numphas, nd, p, stalist, distmatrix, variogramp);
                    if (dcov == null || SVD.projection_matrix(sp.numphas, p, nd, 95.0, dcov, w = new double[nd][nd], prank, nunp.val, phundef, ispchange) != 0) {
                        break;
                    }
                } else {
                    prank.val = ndef;
                }
            } else if (ischanged.val != 0) {
                isconv = 0;
                nd = ndef;
                if (Config.do_correlated_errors != 0) {
                    if (Config.verbose > 0) {
                        logger.info((Object)String.format("    Changes in defining phasenames, recalculating projection matrix", new Object[0]));
                    }
                    if (SVD.projection_matrix(sp.numphas, p, nd, 95.0, dcov, w, prank, nunp.val, phundef, ispchange) != 0) {
                        break;
                    }
                } else {
                    prank.val = ndef;
                }
            }
            if (prank.val <= sp.number_of_unknowns) {
                logger.warn((Object)String.format("Insufficient number of independent phases (%d)!", prank.val));
                Config.errorcode = 6;
                break;
            }
            urms = Locator.build_gd(nd, sp, p, fixdepthfornow, g, d);
            if (Config.do_correlated_errors != 0) {
                if (Locator.project_gd(nd, m, g, d, w, dnorm, wrms) != 0) {
                    break;
                }
            } else {
                Locator.weight_gd(nd, m, sp.numphas, p, g, d, dnorm, wrms);
            }
            if (isconv != 0 || isdiv != 0) break;
            gtdnorm = 0.0;
            i = 0;
            while (i < nd) {
                gtd = 0.0;
                j = 0;
                while (j < m) {
                    gtd += g[i][j] * d[i];
                    ++j;
                }
                gtdnorm += gtd * gtd;
                ++i;
            }
            if (SVD.svd_decompose(nd, m, g, sv, v) != 0) break;
            j = 0;
            while (j < m) {
                svundamped[j] = sv[j];
                ++j;
            }
            svth = SVD.svd_threshold(nd, m, sv);
            nr = SVD.svd_rank(nd, m, sv, svth);
            gnorm = SVD.svd_norm(m, sv, svth, cond);
            if (nr < m) {
                logger.warn((Object)String.format("Singular G matrix (%d < %d)!", nr, m));
                Config.errorcode = 9;
                break;
            }
            if (cond.val > 30000.0) {
                logger.warn((Object)String.format("Abnormally ill-conditioned problem (cond=%.0f)!", cond));
                Config.errorcode = 10;
                break;
            }
            cnvgtst = Locator.convtestval(gtdnorm, gnorm, dnorm.val);
            if (Config.allow_damping != 0 && cond.val > 30.0) {
                damp = 0.01;
                if (cond.val > 300.0) {
                    damp = 0.05;
                }
                if (cond.val > 3000.0) {
                    damp = 0.1;
                }
                j = 1;
                while (j < nr) {
                    int n = j++;
                    sv[n] = sv[n] + sv[0] * damp;
                }
                if (Config.verbose > 0) {
                    logger.info((Object)String.format("    Large condition number (%.3f): .0f%% damping is applied.", cond.val, 100.0 * damp));
                }
            }
            if (SVD.svd_solve(nd, m, g, sv, v, d, sol, svth) != 0) break;
            mnorm = 0.0;
            j = 0;
            while (j < m) {
                mnorm += sol[j] * sol[j];
                ++j;
            }
            if ((mnorm = Utils.Sqrt(mnorm)) > (dmax = 1000.0)) {
                scale = dmax / mnorm;
                j = 0;
                while (j < m) {
                    int n = j++;
                    sol[n] = sol[n] * scale;
                }
                mnorm = dmax;
                if (Config.verbose > 0) {
                    logger.info((Object)String.format("    Large perturbation: %.g scaling is applied.", scale));
                }
            }
            j = 2;
            while (j > 0) {
                modelnorm[j] = modelnorm[j - 1];
                convgtest[j] = convgtest[j - 1];
                --j;
            }
            modelnorm[0] = mnorm;
            convgtest[0] = cnvgtst;
            if (iter > Config.min_iter - 1) {
                doubleW oldcvgtstW = new doubleW(oldcvgtst);
                doubleW stepW = new doubleW(step);
                intW isdivW = new intW(isdiv);
                isconv = Locator.convergence_test(iter, m, nds, sol, oldsol, wrms.val, modelnorm, convgtest, oldcvgtstW, stepW, isdivW);
                oldcvgtst = oldcvgtstW.val;
                step = stepW.val;
                isdiv = isdivW.val;
            }
            prev_depth = sp.depth;
            if (Config.verbose > 0) {
                sb = new StringBuilder(128);
                sb.append(String.format("    iteration = %d: ", iter));
                if (isconv != 0) {
                    sb.append(String.format("    converged!", new Object[0]));
                } else if (isdiv != 0) {
                    sb.append(String.format("    diverged!", new Object[0]));
                } else {
                    sb.append("");
                }
                logger.info((Object)sb.substring(0));
                logger.info((Object)String.format("    ||Gt*d|| = %.5f ||G|| = %.5f ||d|| = %.5f ||m|| = %.5f", gtdnorm, gnorm, dnorm.val, mnorm));
                logger.info((Object)String.format("    convgtst = %.5f condition number = %.3f", cnvgtst, cond.val));
                sb = new StringBuilder(128);
                sb.append(String.format("    eigenvalues: ", new Object[0]));
                i = 0;
                while (i < m) {
                    sb.append(String.format("%g ", sv[i]));
                    ++i;
                }
                logger.info((Object)sb.substring(0));
                logger.info((Object)String.format("    unweighted RMS residual = %8.4f", urms));
                logger.info((Object)String.format("      weighted RMS residual = %8.4f", wrms.val));
                logger.info((Object)String.format("    ndef = %d rank = %d m = %d ischanged = %d", nd, prank.val, m, ischanged.val));
            }
            i = 0;
            sb = new StringBuilder(128);
            if (Config.verbose > 0) {
                sb.append(String.format("    ", new Object[0]));
            }
            if (!sp.timfix) {
                if (Config.verbose > 0) {
                    sb.append(String.format("dOT = %g ", sol[i]));
                }
                sp.time = (torg += sol[i++]) + toffset;
            }
            if (!sp.epifix) {
                azim = 57.29577951308232 * Math.atan2(sol[i], sol[i + 1]);
                delta = Utils.Sqrt(sol[i] * sol[i] + sol[i + 1] * sol[i + 1]);
                delta = 57.29577951308232 * (delta / (6371.0 - sp.depth));
                doubleW latW = new doubleW(sp.lat);
                doubleW lonW = new doubleW(sp.lon);
                Utils.deltaloc(sp.lat, sp.lon, delta, azim, latW, lonW);
                sp.lat = latW.val;
                sp.lon = lonW.val;
                if (Config.verbose > 0) {
                    sb.append(String.format("dx = %g dy = %g ", sol[i], sol[i + 1]));
                }
                i += 2;
            }
            if (fixdepthfornow == 0) {
                if (Config.verbose > 0) {
                    sb.append(String.format("dz = %g ", -sol[i]));
                }
                sp.depth -= sol[i];
            }
            if (Config.verbose > 0) {
                logger.info((Object)sb.substring(0));
                Utils.print_sol(sp, 0);
            }
            if (Config.verbose > 1) {
                Utils.print_defining_pha(sp.numphas, p);
            }
            if (Config.verbose > 0) {
                logger.info((Object)String.format("iteration = %d (%.4f) done", iter, Utils.secs(Utils.t0)));
            }
            ++iter;
        }
        if (Config.verbose > 0) {
            logger.info((Object)String.format("    end of iteration loop (%.4f)", Utils.secs(Utils.t0)));
        }
        Utils.sort_phaserec_db(sp.numphas, p);
        Locator.readings(sp.numphas, sp.nreading, p, rdindx);
        if (Config.verbose > 3) {
            Utils.print_pha(sp.numphas, p);
        }
        if (iter >= Config.max_iter) {
            logger.info((Object)String.format("    maximum number of iterations is reached!", new Object[0]));
            Config.errorcode = 8;
            isdiv = 1;
        } else if (isconv != 0) {
            logger.info((Object)String.format("    convergent solution after %d iterations", iter));
            iserr = 0;
            sp.urms = urms;
            sp.wrms = wrms.val;
            sp.prank = prank.val;
            sp.ndef = nd;
            if (sp.depfixtype == 0 && sp.depth < 1.0E-8) {
                fixdepthfornow = 1;
                sp.depfixtype = 1;
                sp.depth = 0.0;
                --m;
            }
            if (sp.depfixtype == 0 && sp.depth > Config.max_depth_km - 1.0E-8) {
                fixdepthfornow = 1;
                sp.depfixtype = 1;
                sp.depth = Config.max_depth_km;
                --m;
            }
            sp.number_of_unknowns = m;
            sp.depfix = fixdepthfornow != 0;
            SVD.svd_model_covariance_matrix(m, svth, svundamped, v, mcov);
            if (!sp.timfix) {
                sp.covar[0][0] = mcov[0][0];
                if (!sp.epifix) {
                    sp.covar[0][1] = mcov[0][1];
                    sp.covar[0][2] = mcov[0][2];
                    sp.covar[1][0] = mcov[1][0];
                    sp.covar[1][1] = mcov[1][1];
                    sp.covar[1][2] = mcov[1][2];
                    sp.covar[2][0] = mcov[2][0];
                    sp.covar[2][1] = mcov[2][1];
                    sp.covar[2][2] = mcov[2][2];
                    if (fixdepthfornow == 0) {
                        sp.covar[0][3] = mcov[0][3];
                        sp.covar[1][3] = mcov[1][3];
                        sp.covar[2][3] = mcov[2][3];
                        sp.covar[3][0] = mcov[3][0];
                        sp.covar[3][1] = mcov[3][1];
                        sp.covar[3][2] = mcov[3][2];
                        sp.covar[3][3] = mcov[3][3];
                    }
                } else if (fixdepthfornow == 0) {
                    sp.covar[0][3] = mcov[0][1];
                    sp.covar[3][0] = mcov[1][0];
                    sp.covar[3][3] = mcov[1][1];
                }
            } else if (!sp.epifix) {
                sp.covar[1][1] = mcov[0][0];
                sp.covar[1][2] = mcov[0][1];
                sp.covar[2][1] = mcov[1][0];
                sp.covar[2][2] = mcov[1][1];
                if (fixdepthfornow == 0) {
                    sp.covar[1][3] = mcov[0][2];
                    sp.covar[2][3] = mcov[1][2];
                    sp.covar[3][1] = mcov[2][0];
                    sp.covar[3][2] = mcov[2][1];
                    sp.covar[3][3] = mcov[2][2];
                }
            } else if (fixdepthfornow == 0) {
                sp.covar[3][3] = mcov[0][0];
            }
            Uncertainty.calc_error(sp, p);
        } else if (isdiv != 0) {
            logger.warn((Object)String.format("    divergent solution", new Object[0]));
            Config.errorcode = 4;
        } else {
            logger.warn((Object)String.format("    abnormal exit from iteration loop!", new Object[0]));
            isdiv = 1;
        }
        sp.converged = isconv;
        sp.diverging = isdiv;
        if (Config.do_correlated_errors != 0) {
            w = null;
            dcov = null;
        }
        sv = null;
        d = null;
        v = null;
        g = null;
        return iserr;
    }

    static int getndef(int numphas, ISCPha[] p, int nsta, ISCSta[] stalist, doubleW toffset) {
        int nd = 0;
        double toff = 1.0E32;
        int i = 0;
        while (i < numphas) {
            if (p[i].timedef) {
                if (DataCovariance.get_sta_index(nsta, stalist, p[i].prista) < 0) {
                    logger.warn((Object)String.format("getndef: %-6s invalid station!", p[i].prista));
                    Config.errorcode = 11;
                    return -1;
                }
                p[i].prevtimedef = p[i].timedef;
                p[i].prevphase = p[i].phase;
                if (p[i].time < toff) {
                    toff = p[i].time;
                }
                ++nd;
            }
            ++i;
        }
        toffset.val = toff;
        return nd;
    }

    public static int getphases(int numphas, ISCPha[] p, PhaseList[] plist) {
        int nphases = 0;
        boolean isfound = false;
        int j = 0;
        while (j < 95) {
            plist[j].phase = "";
            plist[j].n = 0;
            plist[j].ind = null;
            ++j;
        }
        int i = 0;
        while (i < numphas) {
            if (p[i].timedef) {
                isfound = false;
                j = 0;
                while (j < nphases) {
                    if (Config.streq(p[i].phase, plist[j].phase)) {
                        ++plist[j].n;
                        isfound = true;
                        break;
                    }
                    ++j;
                }
                if (!isfound) {
                    plist[j].phase = p[i].phase;
                    plist[j].n = 1;
                    ++nphases;
                }
            }
            ++i;
        }
        j = 0;
        while (j < nphases) {
            plist[j].ind = new int[plist[j].n];
            int m = -1;
            int k = 0;
            i = 0;
            while (i < numphas) {
                if (p[i].timedef) {
                    ++m;
                    if (Config.streq(p[i].phase, plist[j].phase)) {
                        plist[j].ind[k++] = m;
                    }
                }
                ++i;
            }
            ++j;
        }
        return nphases;
    }

    public static void freephaselist(int nphases, PhaseList[] plist) {
        int j = 0;
        while (j < nphases) {
            plist[j].phase = "";
            plist[j].n = 0;
            plist[j].ind = null;
            ++j;
        }
    }

    static int getresids(ISCSol sp, READING[] rdindx, ISCPha[] p, EC_COEF[] ec, TT_TABLE[] tt_tables, short[][] topo, int iszderiv, intW has_depdpres, intW ndef, intW ischanged, int iter, int ispchange, int prevndef, intW nunp, String[] phundef, double[][] dcov, double[][] w) {
        int k = 0;
        int m = 0;
        int kp = 0;
        int nd = 0;
        int nund = 0;
        int isdiff = 0;
        boolean isfound = false;
        double thres = 0.0;
        has_depdpres.val = k = DepthPhases.depth_phase_check(sp, rdindx, p, false);
        if (TravelTimes.calc_resid(sp, p, "use", ec, tt_tables, topo, iszderiv) != 0) {
            return 1;
        }
        int i = 0;
        while (i < sp.numphas) {
            if (p[i].timedef) {
                thres = Config.sigmathres * p[i].measerr;
                if (Math.abs(p[i].resid) > thres) {
                    p[i].timedef = false;
                } else {
                    ++nd;
                }
            }
            if (p[i].timedef != p[i].prevtimedef) {
                isdiff = 1;
                ++nund;
                if (Config.verbose > 2) {
                    logger.info((Object)String.format("        %-6s %-8s %10.3f made non-defining", p[i].sta, p[i].phase, p[i].resid));
                }
                if (iter != 0 && ispchange == 0 && Config.do_correlated_errors != 0) {
                    isfound = false;
                    int j = 0;
                    while (j < kp) {
                        if (Config.streq(phundef[j], p[i].phase)) {
                            isfound = true;
                        }
                        ++j;
                    }
                    if (!isfound) {
                        phundef[kp++] = p[i].phase;
                    }
                    j = k = p[i].covindex;
                    while (j < prevndef - 1) {
                        m = 0;
                        while (m < prevndef) {
                            dcov[j][m] = dcov[j + 1][m];
                            w[j][m] = w[j + 1][m];
                            ++m;
                        }
                        ++j;
                    }
                    j = k;
                    while (j < prevndef - 1) {
                        m = 0;
                        while (m < prevndef) {
                            dcov[m][j] = dcov[m][j + 1];
                            w[m][j] = w[m][j + 1];
                            ++m;
                        }
                        ++j;
                    }
                }
            }
            p[i].prevtimedef = p[i].timedef;
            ++i;
        }
        if (Config.verbose > 0) {
            logger.info((Object)String.format("    getresids: %d phases made non-defining", nund));
        }
        ndef.val = nd;
        nunp.val = kp;
        ischanged.val = isdiff;
        return 0;
    }

    static double build_gd(int ndef, ISCSol sp, ISCPha[] p, int fixdepthfornow, double[][] g, double[] d) {
        int im = 0;
        double urms = 0.0;
        double depthcorr = 0.0;
        double esaz = 0.0;
        depthcorr = Math.PI / 180 * (6371.0 - sp.depth);
        if (Config.verbose > 2) {
            logger.info((Object)String.format("        G matrix and d vector:", new Object[0]));
        }
        int k = 0;
        int i = 0;
        while (i < sp.numphas) {
            if (p[i].timedef) {
                int j = 0;
                while (j < 4) {
                    g[k][j] = 0.0;
                    ++j;
                }
                im = 0;
                if (!sp.timfix) {
                    g[k][im++] = 1.0;
                }
                if (!sp.epifix) {
                    esaz = Math.PI / 180 * p[i].esaz;
                    g[k][im++] = -(p[i].dtdd / depthcorr) * Math.sin(esaz);
                    g[k][im++] = -(p[i].dtdd / depthcorr) * Math.cos(esaz);
                }
                if (fixdepthfornow == 0) {
                    g[k][im++] = -p[i].dtdh;
                }
                d[k] = p[i].resid;
                urms += d[k] * d[k];
                if (Config.verbose > 2) {
                    StringBuilder sb = new StringBuilder(128);
                    sb.append(String.format("          %6d %-6s %-9s", k, p[i].prista, p[i].phase));
                    j = 0;
                    while (j < im) {
                        sb.append(String.format("%12.6f ", g[k][j]));
                        ++j;
                    }
                    sb.append(String.format(" , %12.6f", d[k]));
                    logger.info((Object)sb.substring(0));
                }
                ++k;
            }
            ++i;
        }
        urms = Utils.Sqrt(urms / (double)ndef);
        return urms;
    }

    static int project_gd(int ndef, int m, double[][] g, double[] d, double[][] w, doubleW dnorm, doubleW wrms) {
        double wssq = 0.0;
        double[] temp = new double[ndef];
        int j = 0;
        while (j < m) {
            Locator.WxG(j, ndef, w, g);
            ++j;
        }
        if (Config.errorcode != 0) {
            return 1;
        }
        int i = 0;
        while (i < ndef) {
            temp[i] = 0.0;
            int k = 0;
            while (k < ndef) {
                int n = i;
                temp[n] = temp[n] + w[i][k] * d[k];
                ++k;
            }
            if (Math.abs(temp[i]) < 1.0E-10) {
                temp[i] = 0.0;
            }
            ++i;
        }
        wssq = 0.0;
        i = 0;
        while (i < ndef) {
            d[i] = temp[i];
            wssq += d[i] * d[i];
            ++i;
        }
        temp = null;
        dnorm.val = wssq;
        wrms.val = Utils.Sqrt(wssq / (double)ndef);
        if (Config.verbose > 2) {
            logger.info((Object)String.format("        WG(%d x %d) matrix and Wd vector:", ndef, m));
            i = 0;
            while (i < ndef) {
                StringBuilder sb = new StringBuilder(128);
                sb.append(String.format("          %6d ", i));
                j = 0;
                while (j < m) {
                    sb.append(String.format("%12.6f ", g[i][j]));
                    ++j;
                }
                sb.append(String.format(" , %12.6f", d[i]));
                logger.info((Object)sb.substring(0));
                ++i;
            }
        }
        return 0;
    }

    static int WxG(int j, int ndef, double[][] w, double[][] g) {
        double[] temp = new double[ndef];
        int k = 0;
        while (k < ndef) {
            temp[k] = g[k][j];
            ++k;
        }
        int i = 0;
        while (i < ndef) {
            g[i][j] = 0.0;
            k = 0;
            while (k < ndef) {
                double[] dArray = g[i];
                int n = j;
                dArray[n] = dArray[n] + w[i][k] * temp[k];
                ++k;
            }
            if (Math.abs(g[i][j]) < 1.0E-10) {
                g[i][j] = 0.0;
            }
            ++i;
        }
        temp = null;
        return 0;
    }

    static void weight_gd(int ndef, int m, int numphas, ISCPha[] p, double[][] g, double[] d, doubleW dnorm, doubleW wrms) {
        int j;
        double wssq = 0.0;
        double weight = 0.0;
        int k = 0;
        int i = 0;
        while (i < numphas) {
            if (p[i].timedef) {
                weight = p[i].measerr < 1.0E-8 ? 1.0 : 1.0 / p[i].measerr;
                j = 0;
                while (j < m) {
                    double[] dArray = g[k];
                    int n = j++;
                    dArray[n] = dArray[n] * weight;
                }
                int n = k;
                d[n] = d[n] * weight;
                wssq += d[k] * d[k];
                ++k;
            }
            ++i;
        }
        dnorm.val = wssq;
        wrms.val = Utils.Sqrt(wssq / (double)ndef);
        if (Config.verbose > 2) {
            logger.info((Object)String.format("        WG(%d x %d) matrix and Wd vector:", ndef, m));
            i = 0;
            while (i < ndef) {
                StringBuilder sb = new StringBuilder(128);
                sb.append(String.format("          %6d ", i));
                j = 0;
                while (j < m) {
                    sb.append(String.format("%12.6f ", g[i][j]));
                    ++j;
                }
                sb.append(String.format(" , %12.6f", d[i]));
                logger.info((Object)sb.substring(0));
                ++i;
            }
        }
    }

    static double convtestval(double gtdnorm, double gnorm, double dnorm) {
        double cnvgtst = 0.0;
        double gd = 0.0;
        gd = gnorm * dnorm;
        cnvgtst = gtdnorm > 1.0E-8 && gd < 1.0E-8 ? 999.0 : gtdnorm / gd;
        return cnvgtst;
    }

    static int convergence_test(int iter, int m, int[] nds, double[] sol, double[] oldsol, double wrms, double[] modelnorm, double[] convgtest, doubleW oldcvgtst, doubleW step, intW isdiv) {
        double dm01 = 0.0;
        double dm12 = 0.0;
        double dc01 = 0.0;
        double dc12 = 0.0;
        double sc = step.val;
        double oldcvg = 0.0;
        int convergent = 0;
        int divergent = 0;
        oldcvg = oldcvgtst.val;
        if (modelnorm[0] > 0.0 && convgtest[0] > 0.0) {
            if (modelnorm[1] <= 0.0 || modelnorm[2] <= 0.0) {
                dm12 = 1.05;
                dm01 = 1.05;
            } else {
                dm01 = modelnorm[0] / modelnorm[1];
                dm12 = modelnorm[1] / modelnorm[2];
            }
            if (convgtest[1] <= 0.0 || convgtest[2] <= 0.0) {
                dc01 = convgtest[0];
            } else {
                dc01 = convgtest[0] / convgtest[1];
                dc12 = convgtest[1] / convgtest[2];
                dc01 = Math.abs(dc12 - dc01);
            }
            dc12 = Math.abs(convgtest[0] - convgtest[2]);
            if (dm12 > 1.1 && dm01 > dm12 && iter > Config.min_iter + 2 && modelnorm[0] > 500.0) {
                divergent = 1;
            } else if (nds[0] == nds[1] && (convgtest[0] < 1.0E-8 || modelnorm[0] < 0.1 || wrms < 0.01)) {
                convergent = 1;
            } else if (convgtest[0] < 1.01 * oldcvg && convgtest[0] < 1.0E-8 || iter > 3 * Config.max_iter / 4 && (convgtest[0] < Math.sqrt(1.0E-8) || dc01 < 1.0E-8 || dc12 < Math.sqrt(1.0E-8))) {
                convergent = 1;
            }
        } else {
            convergent = 1;
        }
        if (iter == Config.max_iter - 1) {
            convergent = 0;
        }
        if (iter > Config.min_iter + 2 && (convgtest[0] > oldcvgtst.val || convgtest[0] - convgtest[2] == 0.0) && sc > 0.05) {
            if ((sc *= 0.5) != 0.5) {
                int i = 0;
                while (i < m) {
                    if (Math.abs(oldsol[i]) < 1.0E-10) {
                        oldsol[i] = sol[i];
                    }
                    sol[i] = sc * oldsol[i];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < m) {
                    sol[i] = sc * sol[i];
                    oldsol[i] = sol[i];
                    ++i;
                }
            }
        } else {
            sc = 1.0;
            oldcvgtst.val = convgtest[0];
        }
        step.val = sc;
        isdiv.val = divergent;
        return convergent;
    }

    public static void readings(int numphas, int nreading, ISCPha[] p, READING[] rdindx) {
        int j = 0;
        int i = 0;
        while (i < nreading) {
            rdindx[i].start = j;
            rdindx[i].npha = 0;
            int rdid = p[j].rdid;
            while (j < numphas) {
                if (p[j].rdid != rdid) break;
                ++rdindx[i].npha;
                ++j;
            }
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WxG_thr
    implements Callable<Boolean> {
        final int j;
        final int ndef;
        final double[][] w;
        final double[][] g;

        public WxG_thr(int j, int ndef, double[][] w, double[][] g) {
            this.j = j;
            this.ndef = ndef;
            this.w = w;
            this.g = g;
        }

        @Override
        public Boolean call() {
            Locator.WxG(this.j, this.ndef, this.w, this.g);
            return true;
        }
    }
}

