/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.ISCHypQual;
import cn.org.gddsn.seis.location.iscloc2.ISCPha;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.netlib.util.doubleW;

public class LocQual {
    static Logger logger = Logger.getLogger(LocQual.class);

    private LocQual() {
    }

    public static int location_quality(int numphas, ISCPha[] p, ISCHypQual hq) {
        double du = 0.0;
        double score = 0.0;
        doubleW gap = new doubleW(0.0);
        doubleW sgap = new doubleW(0.0);
        double delta = 0.0;
        double d10 = 0.0;
        double mind = 0.0;
        double maxd = 0.0;
        double d = 0.0;
        int ndef = 0;
        int nsta = 0;
        int ndefsta_10km = 0;
        double[] esaz = new double[numphas + 2];
        delta = 1.3489824088780957;
        d10 = 0.08993216059187305;
        String prevsta = "";
        mind = 180.0;
        maxd = 0.0;
        nsta = 0;
        ndef = 0;
        int i = 0;
        while (i < numphas) {
            if (p[i].timedef && !(p[i].delta > delta)) {
                ++ndef;
                if (!Config.streq(p[i].prista, prevsta)) {
                    esaz[nsta++] = p[i].esaz;
                    prevsta = p[i].prista;
                    if (p[i].delta > maxd) {
                        maxd = p[i].delta;
                    }
                    if (p[i].delta < mind) {
                        mind = p[i].delta;
                    }
                    if (p[i].delta <= d10) {
                        ++ndefsta_10km;
                    }
                }
            }
            ++i;
        }
        hq.local_net.ndefsta = nsta;
        hq.local_net.ndef = ndef;
        hq.local_net.du = du = LocQual.gapper(nsta, esaz, gap, sgap);
        hq.local_net.gap = gap.val;
        hq.local_net.sgap = sgap.val;
        hq.local_net.mindist = mind;
        hq.local_net.maxdist = maxd;
        hq.ndefsta_10km = ndefsta_10km;
        hq.gtcand = du > 0.35 || ndefsta_10km < 1 || sgap.val > 160.0 ? 0 : 1;
        d = du < 1.0E-4 ? 1.0E-4 : du;
        score += 2.0 * (1.0 / d + (double)nsta / 7.5 + (360.0 - sgap.val) / 60.0);
        if (Config.verbose > 1) {
            StringBuilder sb = new StringBuilder(128);
            sb.append(String.format("    local network:         nsta=%3d ndef=%3d", nsta, ndef));
            sb.append(String.format(" gap=%5.1f sgap=%5.1f dU=%5.3f", gap.val, sgap.val, du));
            sb.append(String.format(" ndefsta_10km=%d GT5cand=%d", ndefsta_10km, hq.gtcand));
            logger.info((Object)sb.substring(0));
        }
        prevsta = "";
        mind = 180.0;
        maxd = 0.0;
        nsta = 0;
        ndef = 0;
        i = 0;
        while (i < numphas) {
            if (p[i].timedef && !(p[i].delta < 3.0) && !(p[i].delta > 10.0)) {
                ++ndef;
                if (!Config.streq(p[i].prista, prevsta)) {
                    esaz[nsta++] = p[i].esaz;
                    prevsta = p[i].prista;
                    if (p[i].delta > maxd) {
                        maxd = p[i].delta;
                    }
                    if (p[i].delta < mind) {
                        mind = p[i].delta;
                    }
                }
            }
            ++i;
        }
        hq.near_net.ndefsta = nsta;
        hq.near_net.ndef = ndef;
        hq.near_net.du = du = LocQual.gapper(nsta, esaz, gap, sgap);
        hq.near_net.gap = gap.val;
        hq.near_net.sgap = sgap.val;
        hq.near_net.mindist = mind;
        hq.near_net.maxdist = maxd;
        d = du < 1.0E-4 ? 1.0E-4 : du;
        score += 1.2 * (1.0 / d + (double)nsta / 7.5 + (360.0 - sgap.val) / 60.0);
        if (Config.verbose > 1) {
            logger.info((Object)String.format("    near-regional network: nsta=%3d ndef=%3d gap=%5.1f sgap=%5.1f dU=%5.3f", nsta, ndef, gap.val, sgap.val, du));
        }
        prevsta = "";
        mind = 180.0;
        maxd = 0.0;
        nsta = 0;
        ndef = 0;
        i = 0;
        while (i < numphas) {
            if (p[i].timedef && !(p[i].delta < 28.0)) {
                ++ndef;
                if (!Config.streq(p[i].prista, prevsta)) {
                    esaz[nsta++] = p[i].esaz;
                    prevsta = p[i].prista;
                    if (p[i].delta > maxd) {
                        maxd = p[i].delta;
                    }
                    if (p[i].delta < mind) {
                        mind = p[i].delta;
                    }
                }
            }
            ++i;
        }
        hq.tele_net.ndefsta = nsta;
        hq.tele_net.ndef = ndef;
        hq.tele_net.du = du = LocQual.gapper(nsta, esaz, gap, sgap);
        hq.tele_net.gap = gap.val;
        hq.tele_net.sgap = sgap.val;
        hq.tele_net.mindist = mind;
        hq.tele_net.maxdist = maxd;
        d = du < 1.0E-4 ? 1.0E-4 : du;
        score += 1.5 * (1.0 / d + (double)nsta / 7.5 + (360.0 - sgap.val) / 60.0);
        if (Config.verbose > 1) {
            logger.info((Object)String.format("    teleseismic network:   nsta=%3d ndef=%3d gap=%5.1f sgap=%5.1f dU=%5.3f", nsta, ndef, gap.val, sgap.val, du));
        }
        prevsta = "";
        mind = 180.0;
        maxd = 0.0;
        nsta = 0;
        ndef = 0;
        i = 0;
        while (i < numphas) {
            if (p[i].timedef) {
                ++ndef;
                if (!Config.streq(p[i].prista, prevsta)) {
                    esaz[nsta++] = p[i].esaz;
                    prevsta = p[i].prista;
                    if (p[i].delta > maxd) {
                        maxd = p[i].delta;
                    }
                    if (p[i].delta < mind) {
                        mind = p[i].delta;
                    }
                }
            }
            ++i;
        }
        hq.whole_net.ndefsta = nsta;
        hq.whole_net.ndef = ndef;
        hq.whole_net.du = du = LocQual.gapper(nsta, esaz, gap, sgap);
        hq.whole_net.gap = gap.val;
        hq.whole_net.sgap = sgap.val;
        hq.whole_net.mindist = mind;
        hq.whole_net.maxdist = maxd;
        d = du < 1.0E-4 ? 1.0E-4 : du;
        score += 1.0 / d + (double)nsta / 7.5 + (360.0 - sgap.val) / 60.0;
        if (Config.verbose > 1) {
            logger.info((Object)String.format("    entire network:        nsta=%3d ndef=%3d gap=%5.1f sgap=%5.1f dU=%5.3f", nsta, ndef, gap.val, sgap.val, du));
        }
        if (score < 0.1) {
            score = 4.0;
        }
        hq.score = score;
        esaz = null;
        return 0;
    }

    public static double gapper(int nsta, double[] esaz, doubleW gap, doubleW sgap) {
        double du = 1.0;
        double bb = 0.0;
        double uesaz = 0.0;
        double w = 0.0;
        double s1 = 0.0;
        double s2 = 0.0;
        gap.val = 360.0;
        sgap.val = 360.0;
        if (nsta < 2) {
            return du;
        }
        Arrays.sort(esaz, 0, nsta);
        int i = 0;
        while (i < nsta) {
            uesaz = 360.0 * (double)i / (double)nsta;
            s1 += esaz[i];
            s2 += uesaz;
            ++i;
        }
        bb = (s1 - s2) / (double)nsta;
        w = 0.0;
        i = 0;
        while (i < nsta) {
            uesaz = 360.0 * (double)i / (double)nsta;
            w += Math.abs(esaz[i] - uesaz - bb);
            ++i;
        }
        du = 4.0 * w / (360.0 * (double)nsta);
        esaz[nsta] = esaz[0] + 360.0;
        w = 0.0;
        i = 0;
        while (i < nsta) {
            w = Math.max(w, esaz[i + 1] - esaz[i]);
            ++i;
        }
        if (w > 360.0) {
            w = 360.0;
        }
        gap.val = w;
        esaz[nsta + 1] = esaz[1] + 360.0;
        w = 0.0;
        i = 0;
        while (i < nsta) {
            w = Math.max(w, esaz[i + 2] - esaz[i]);
            ++i;
        }
        if (w > 360.0) {
            w = 360.0;
        }
        sgap.val = w;
        return du;
    }
}

