/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.ISCEvent;
import cn.org.gddsn.seis.location.iscloc2.ISCHyp;
import cn.org.gddsn.seis.location.iscloc2.ISCSol;
import cn.org.gddsn.seis.location.iscloc2.Utils;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class Initializations {
    static Logger logger = Logger.getLogger(Initializations.class);

    private Initializations() {
    }

    public static int init_event(ISCEvent ep, ISCHyp[] h) {
        int i;
        boolean manmade = false;
        if (Config.verbose > 0) {
            logger.info((Object)String.format("etype=%s", ep.etype));
        }
        if (ep.etype.charAt(1) == 'n' || ep.etype.charAt(1) == 'x' || ep.etype.charAt(1) == 'm' || ep.etype.charAt(1) == 'q' || ep.etype.charAt(1) == 'r' || ep.etype.charAt(1) == 'h' || ep.etype.charAt(1) == 's' || ep.etype.charAt(1) == 'i') {
            manmade = true;
        }
        if (manmade) {
            if (!ep.depth_fix) {
                ep.start_depth = 0.0;
                ep.depth_fix = true;
                ep.surface_fix = true;
                logger.info((Object)String.format("Fix depth to zero because etype=%s", ep.etype));
            } else {
                ep.surface_fix = true;
            }
        }
        if (ep.depth_agency.length() != 0 && ep.start_depth == 9999999.0) {
            i = 0;
            while (i < ep.numhyps) {
                if (Config.streq(h[i].agency, ep.depth_agency)) {
                    ep.start_depth = h[i].depth;
                    break;
                }
                ++i;
            }
            if (ep.start_depth == 9999999.0) {
                logger.warn((Object)String.format("ABORT: %d invalid depth agency %s!", ep.evid, ep.depth_agency));
                return 1;
            }
        }
        if (ep.location_agency.length() != 0 && ep.start_lat == 9999999.0) {
            i = 0;
            while (i < ep.numhyps) {
                if (Config.streq(h[i].agency, ep.location_agency)) {
                    ep.start_lat = h[i].lat;
                    ep.start_lon = h[i].lon;
                    break;
                }
                ++i;
            }
            if (ep.start_lat == 9999999.0) {
                logger.warn((Object)String.format("ABORT: %d invalid location agency %s!", ep.evid, ep.location_agency));
                return 1;
            }
        }
        if (ep.time_agency.length() != 0 && ep.start_time == 9999999.0) {
            i = 0;
            while (i < ep.numhyps) {
                if (Config.streq(h[i].agency, ep.time_agency)) {
                    ep.start_time = h[i].time;
                    break;
                }
                ++i;
            }
            if (ep.start_time == 9999999.0) {
                logger.warn((Object)String.format("ABORT: %d invalid time agency %s!", ep.evid, ep.time_agency));
                return 1;
            }
        }
        if (ep.hypo_agency.length() != 0) {
            i = 0;
            while (i < ep.numhyps) {
                if (Config.streq(h[i].agency, ep.hypo_agency)) {
                    ep.start_time = h[i].time;
                    ep.start_lat = h[i].lat;
                    ep.start_lon = h[i].lon;
                    ep.start_depth = h[i].depth;
                    Utils.swap(h, i, 0);
                    break;
                }
                ++i;
            }
            if (ep.start_time == 9999999.0) {
                logger.warn((Object)String.format("ABORT: %d invalid hypo agency %s!", ep.evid, ep.hypo_agency));
                return 1;
            }
        }
        if (ep.epi_fix && ep.depth_fix && ep.time_fix) {
            ep.hypo_fix = true;
        }
        if (ep.start_depth != 9999999.0 && ep.start_depth < 0.0) {
            ep.start_depth = Config.default_depth;
        }
        return 0;
    }

    public static void start_hyp(ISCEvent ep, ISCHyp[] h, ISCHyp starthyp) {
        int j;
        double[] x = null;
        double medtim = 0.0;
        double medlat = 0.0;
        double medlon = 0.0;
        double meddep = 0.0;
        int n = 0;
        starthyp.time = h[0].time;
        starthyp.lat = h[0].lat;
        starthyp.lon = h[0].lon;
        starthyp.depth = h[0].depth == 9999999.0 || h[0].depth < 0.0 ? Config.default_depth : h[0].depth;
        if (Config.streq(h[0].agency, "IASPEI") || Config.streq(h[0].agency, "ISC") || Config.streq(h[0].agency, "EHB")) {
            return;
        }
        if (ep.numhyps == 1) {
            return;
        }
        int i = 0;
        while (i < ep.numhyps) {
            h[i].ignorehypo = 0;
            j = 0;
            while (j < Config.numnohypoagency) {
                if (Config.streq(h[i].agency, Config.nohypoagency[j])) {
                    h[i].ignorehypo = 1;
                    break;
                }
                ++j;
            }
            if (h[i].ignorehypo == 0) {
                ++n;
            }
            ++i;
        }
        int m = n / 2;
        x = new double[n];
        j = 0;
        i = 0;
        while (i < ep.numhyps) {
            if (h[i].ignorehypo == 0) {
                x[j++] = h[i].time;
            }
            ++i;
        }
        if (n == 2) {
            medtim = (x[0] + x[1]) / 2.0;
        } else {
            Arrays.sort(x, 0, n);
            medtim = x[m];
        }
        j = 0;
        i = 0;
        while (i < ep.numhyps) {
            if (h[i].ignorehypo == 0) {
                x[j++] = h[i].lat;
            }
            ++i;
        }
        if (n == 2) {
            medlat = (x[0] + x[1]) / 2.0;
        } else {
            Arrays.sort(x, 0, n);
            medlat = x[m];
        }
        j = 0;
        i = 0;
        while (i < ep.numhyps) {
            if (h[i].ignorehypo == 0) {
                x[j++] = h[i].lon;
            }
            ++i;
        }
        if (n == 2) {
            double y = Math.abs(x[0]) + Math.abs(x[1]);
            medlon = y > 180.0 && x[0] * x[1] < 0.0 ? y / 2.0 : (x[0] + x[1]) / 2.0;
        } else {
            Arrays.sort(x, 0, n);
            medlon = x[m];
        }
        j = 0;
        i = 0;
        while (i < ep.numhyps) {
            if (h[i].ignorehypo == 0 && h[i].depth != 9999999.0 && h[i].depth >= 0.0) {
                x[j++] = h[i].depth;
            }
            ++i;
        }
        if (j == 0) {
            meddep = Config.default_depth;
        } else if (j == 1) {
            meddep = x[0];
        } else if (j == 2) {
            meddep = (x[0] + x[1]) / 2.0;
        } else {
            Arrays.sort(x, 0, j);
            meddep = x[j /= 2];
        }
        x = null;
        starthyp.time = medtim;
        starthyp.lat = medlat;
        starthyp.lon = medlon;
        starthyp.depth = meddep;
    }

    public static int init_sol(ISCSol sp, ISCEvent ep, ISCHyp hp) {
        sp.converged = 0;
        sp.diverging = 0;
        sp.numphas = ep.numphas;
        sp.nreading = ep.numrd;
        if (sp.numphas <= sp.number_of_unknowns) {
            logger.warn((Object)String.format("init_sol: insufficient number of observations!", new Object[0]));
            logger.warn((Object)String.format("          unknowns=%d numphas=%d", sp.number_of_unknowns, sp.numphas));
            Config.errorcode = 5;
            return 1;
        }
        sp.lat = ep.start_lat != 9999999.0 ? ep.start_lat : hp.lat;
        sp.lon = ep.start_lon != 9999999.0 ? ep.start_lon : hp.lon;
        sp.depth = ep.start_depth != 9999999.0 ? ep.start_depth : hp.depth;
        sp.time = ep.start_time != 9999999.0 ? ep.start_time : hp.time;
        sp.epifix = ep.epi_fix;
        sp.timfix = ep.time_fix;
        sp.depfix = ep.depth_fix;
        int i = 0;
        while (i < 4) {
            sp.error[i] = 9999999.0;
            int j = 0;
            while (j < 4) {
                sp.covar[i][j] = 9999999.0;
                ++j;
            }
            ++i;
        }
        sp.sdobs = 9999999.0;
        sp.maxdist = 9999999.0;
        sp.mindist = 9999999.0;
        sp.strike = 9999999.0;
        sp.sminax = 9999999.0;
        sp.smajax = 9999999.0;
        sp.ndef = 0;
        sp.nass = 0;
        sp.ndefsta = 0;
        sp.prank = 0;
        sp.depdp = 9999999.0;
        sp.depdp_error = 9999999.0;
        sp.ndp = 0;
        sp.urms = 0.0;
        sp.wrms = 0.0;
        sp.bodymag = 0.0;
        sp.bodymag_uncertainty = 0.0;
        sp.nsta_mb = 0;
        sp.nass_mb = 0;
        sp.nmbagency = 0;
        sp.surfmag = 0.0;
        sp.surfmag_uncertainty = 0.0;
        sp.nsta_ms = 0;
        sp.nass_ms = 0;
        sp.nMsagency = 0;
        return 0;
    }
}

