/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.DataCovariance;
import cn.org.gddsn.seis.location.iscloc2.GeoRegion;
import cn.org.gddsn.seis.location.iscloc2.ISCEvent;
import cn.org.gddsn.seis.location.iscloc2.ISCHyp;
import cn.org.gddsn.seis.location.iscloc2.ISCPha;
import cn.org.gddsn.seis.location.iscloc2.ISCSol;
import cn.org.gddsn.seis.location.iscloc2.ISCSta;
import cn.org.gddsn.seis.location.iscloc2.MSZH;
import cn.org.gddsn.seis.location.iscloc2.RDMAG;
import cn.org.gddsn.seis.location.iscloc2.STAMAG;
import cn.org.gddsn.seis.location.iscloc2.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.netlib.util.intW;

public class ISFIO {
    static Logger logger = Logger.getLogger(ISFIO.class);
    public static String isf_error = "";

    private ISFIO() {
    }

    public static int read_isf(Scanner sc, ISFStruct isf) {
        int m;
        String line;
        intW yyyy = new intW(0);
        intW mm = new intW(0);
        intW dd = new intW(0);
        intW hh = new intW(0);
        intW mi = new intW(0);
        intW ss = new intW(0);
        intW msec = new intW(0);
        int rdid = 0;
        intW evid = new intW(0);
        boolean found = false;
        int nstas = 0;
        ISCEvent ep = isf.ep;
        char[] timfix = new char[50];
        char[] epifix = new char[50];
        char[] depfix = new char[50];
        double[] hyp_time = new double[50];
        double[] lat = new double[50];
        double[] lon = new double[50];
        double[] depth = new double[50];
        double[] stime = new double[50];
        double[] sdepth = new double[50];
        double[] sdobs = new double[50];
        double[] smajax = new double[50];
        double[] sminax = new double[50];
        int[] strike = new int[50];
        int[] ndef = new int[50];
        int[] nsta = new int[50];
        int[] azimgap = new int[50];
        double[] mindist = new double[50];
        double[] maxdist = new double[50];
        String[] etype = new String[50];
        String[] author = new String[50];
        int[] origid = new int[50];
        String[] sta = new String[5000];
        String[] phase = new String[5000];
        double[] delta = new double[5000];
        double[] pha_time = new double[5000];
        double[] azim = new double[5000];
        double[] slow = new double[5000];
        double[] amp = new double[5000];
        double[] per = new double[5000];
        char[] sp_fm = new char[5000];
        char[] detchar = new char[5000];
        ep.evid = 9999999;
        while (sc.hasNext()) {
            line = sc.nextLine();
            if (ISFIO.parse_event_id(line, evid) != 0) continue;
            ep.evid = evid.val;
            break;
        }
        if (ep.evid == 9999999) {
            if (sc.hasNext()) {
                logger.warn((Object)String.format("read_isf: no event line found", new Object[0]));
            }
            return 1;
        }
        if (Config.verbose > 0) {
            logger.info((Object)String.format("    found event id %d", ep.evid));
        }
        found = false;
        while (sc.hasNext()) {
            line = sc.nextLine();
            if (!line.contains("Latitude Longitude")) continue;
            found = true;
            break;
        }
        if (!found) {
            logger.warn((Object)String.format("read_isf: no origin block found", new Object[0]));
            return 1;
        }
        int i = 0;
        while (sc.hasNext()) {
            line = sc.nextLine();
            if (ISFIO.all_blank(line)) break;
            if (line.startsWith(" (")) continue;
            if (ISFIO.parse_origin(line, yyyy, mm, dd, hh, mi, ss, msec, timfix, stime, sdobs, lat, lon, epifix, smajax, sminax, strike, depth, depfix, sdepth, ndef, nsta, azimgap, mindist, maxdist, etype, author, origid, i) == 0) {
                if (msec.val == 9999999) {
                    msec.val = 0;
                }
                hyp_time[i++] = Utils.epoch_time(yyyy.val, mm.val, dd.val, hh.val, mi.val, ss.val, msec.val);
                continue;
            }
            logger.warn((Object)String.format("read_isf: origin: %s", isf_error));
        }
        if ((ep.numhyps = i) == 0) {
            logger.warn((Object)String.format("read_isf: no hypocentres found", new Object[0]));
            return 1;
        }
        if (Config.verbose > 0) {
            logger.info((Object)String.format("    %d hypocentres read", ep.numhyps));
        }
        found = false;
        while (sc.hasNext()) {
            line = sc.nextLine();
            if (!line.contains("Phase")) continue;
            found = true;
            break;
        }
        if (!found) {
            logger.warn((Object)String.format("read_isf: no phase block found", new Object[0]));
            return 1;
        }
        i = 0;
        while (sc.hasNext()) {
            line = sc.nextLine();
            if (ISFIO.all_blank(line)) break;
            if (line.startsWith(" (")) continue;
            if (ISFIO.parse_phase(line, sta, delta, phase, hh, mi, ss, msec, azim, slow, amp, per, sp_fm, detchar, i) == 0) {
                if (hh.val == 9999999) {
                    pha_time[i] = 9999999.0;
                } else {
                    if (msec.val == 9999999) {
                        msec.val = 0;
                    }
                    pha_time[i] = Utils.epoch_time(yyyy.val, mm.val, dd.val, hh.val, mi.val, ss.val, msec.val);
                    if (pha_time[i] < hyp_time[0]) {
                        int n = i;
                        pha_time[n] = pha_time[n] + 86400.0;
                    }
                }
                if (delta[i] == 9999999.0) {
                    logger.warn((Object)String.format("read_isf: phases must have delta", new Object[0]));
                    return 1;
                }
                ++i;
                continue;
            }
            logger.warn((Object)String.format("read_isf: phase: %s", isf_error));
        }
        if ((ep.numphas = i) == 0) {
            logger.warn((Object)String.format("read_isf: no phases read", new Object[0]));
            return 1;
        }
        if (Config.verbose > 0) {
            logger.info((Object)String.format("    %d phases read", ep.numphas));
        }
        isf.hp = new ISCHyp[ep.numhyps];
        i = 0;
        while (i < isf.hp.length) {
            isf.hp[i] = new ISCHyp();
            ++i;
        }
        isf.pp = new ISCPha[ep.numphas];
        i = 0;
        while (i < isf.pp.length) {
            isf.pp[i] = new ISCPha();
            ++i;
        }
        ISCHyp[] h = isf.hp;
        i = 0;
        int j = ep.numhyps - 1;
        while (i < ep.numhyps) {
            h[i].hypid = origid[j];
            h[i].time = hyp_time[j];
            h[i].lat = lat[j];
            h[i].lon = lon[j];
            h[i].depth = depth[j];
            h[i].ndef = ndef[j];
            h[i].ndefsta = nsta[j];
            h[i].mindist = mindist[j];
            h[i].maxdist = maxdist[j];
            h[i].azimgap = azimgap[j];
            h[i].etype = etype[j];
            h[i].agency = author[j];
            h[i].sdobs = sdobs[j];
            h[i].stime = stime[j];
            h[i].sdepth = sdepth[j];
            h[i].sminax = sminax[j];
            h[i].smajax = smajax[j];
            h[i].strike = strike[j];
            h[i].timfix = false;
            h[i].epifix = false;
            h[i].depfix = false;
            ++i;
            --j;
        }
        Config.numagencies = 1;
        Config.agencies[0] = h[0].agency;
        ISCPha[] p = isf.pp;
        i = 0;
        while (i < ep.numphas) {
            p[i].hypid = h[0].hypid;
            p[i].phid = i + 1;
            p[i].agency = h[0].agency;
            p[i].rep_phase = phase[i];
            p[i].sta = sta[i];
            m = DataCovariance.get_sta_index(Config.numsta, isf.stationlist, sta[i]);
            p[i].prista = isf.stationlist[m].altsta;
            p[i].delta = delta[i];
            p[i].time = pha_time[i];
            p[i].slow = slow[i];
            p[i].azim = azim[i];
            if (amp[i] == 9999999.0) {
                p[i].numamps = 0;
            } else {
                p[i].numamps = 1;
                p[i].a[0].amp = amp[i];
                p[i].a[0].per = per[i];
                p[i].comp = (char)32;
            }
            p[i].sp_fm = sp_fm[i];
            p[i].detchar = detchar[i];
            ++i;
        }
        ISFIO.sort_phaserec_isf(ep.numphas, p);
        String prev_sta = "";
        rdid = 1;
        nstas = 0;
        i = 0;
        while (i < ep.numphas) {
            if (!p[i].sta.equals(prev_sta)) {
                p[i].rdid = rdid++;
                p[i].init = 1;
                ++nstas;
                m = DataCovariance.get_sta_index(Config.numsta, isf.stationlist, p[i].prista);
                p[i].sta_lat = isf.stationlist[m].lat;
                p[i].sta_lon = isf.stationlist[m].lon;
                p[i].sta_elev = isf.stationlist[m].elev;
                prev_sta = p[i].sta;
            } else {
                p[i].rdid = p[i - 1].rdid;
                p[i].sta_lat = p[i - 1].sta_lat;
                p[i].sta_lon = p[i - 1].sta_lon;
                p[i].sta_elev = p[i - 1].sta_elev;
            }
            ++i;
        }
        ep.numrd = rdid - 1;
        ep.numsta = nstas;
        if (ep.numsta == 0) {
            logger.warn((Object)String.format("read_isf: missing stations!", new Object[0]));
            isf.pp = null;
            isf.hp = null;
            return 1;
        }
        isf.stamag_mb = new STAMAG[ep.numsta];
        isf.stamag_ms = new STAMAG[ep.numsta];
        isf.rdmag_mb = new RDMAG[ep.numsta];
        isf.rdmag_ms = new RDMAG[ep.numsta];
        isf.mszh = new MSZH[ep.numsta];
        i = 0;
        while (i < ep.numsta) {
            isf.stamag_mb[i] = new STAMAG();
            isf.stamag_ms[i] = new STAMAG();
            isf.rdmag_mb[i] = new RDMAG();
            isf.rdmag_ms[i] = new RDMAG();
            isf.mszh[i] = new MSZH();
            ++i;
        }
        ep.etype = h[0].etype;
        ep.numagency = 1;
        if (!ep.depth_fix) {
            ep.depth_fix = h[0].depfix;
        }
        if (!ep.epi_fix) {
            ep.epi_fix = h[0].epifix;
        }
        if (!ep.time_fix) {
            ep.time_fix = h[0].timfix;
        }
        if (!ep.time_fix) {
            ep.start_time = h[0].time;
        }
        if (!ep.epi_fix) {
            ep.start_lat = h[0].lat;
            ep.start_lon = h[0].lon;
        }
        if (!ep.depth_fix) {
            ep.start_depth = h[0].depth;
        }
        if (Config.verbose > 0) {
            logger.info((Object)String.format("read_isf done.", new Object[0]));
            Utils.print_pha(ep.numphas, p);
        }
        return 0;
    }

    public static void write_isf(PrintWriter ofp, ISCEvent ep, ISCSol sp, ISCHyp[] h, ISCPha[] p, RDMAG[] rdmag_mb, RDMAG[] rdmag_ms, int grn) {
        int j;
        char depfix;
        char epifix;
        char timfix;
        int yyyy = 0;
        int mm = 0;
        int dd = 0;
        int hh = 0;
        int mi = 0;
        int[] ymdhms = new int[7];
        double sec = 0.0;
        String phase = "";
        double amp = 0.0;
        double per = 0.0;
        double x = 9999999.0;
        char loctype = ' ';
        char antype = ' ';
        String gregname = "";
        if (grn != 0) {
            gregname = GeoRegion.gregion(grn);
        }
        ofp.printf("\nEvent %8d %s\n\n", ep.evid, gregname);
        ofp.printf("   Date       Time        Err   RMS Latitude Longitude  ", new Object[0]);
        ofp.printf("Smaj  Smin  Az Depth   Err Ndef Nsta Gap  mdist  Mdist ", new Object[0]);
        ofp.printf("Qual   Author      OrigID\n", new Object[0]);
        int i = 0;
        while (i < ep.numhyps) {
            if (!Config.streq(h[i].agency, "ISC")) {
                Utils.human_time(h[i].time, ymdhms);
                yyyy = ymdhms[0];
                mm = ymdhms[1];
                dd = ymdhms[2];
                hh = ymdhms[3];
                mi = ymdhms[4];
                sec = (double)ymdhms[5] + (double)ymdhms[6] / 1000.0;
                timfix = ' ';
                epifix = ' ';
                depfix = ' ';
                if (h[i].depfix) {
                    depfix = 'f';
                }
                if (h[i].epifix) {
                    epifix = 'f';
                }
                if (h[i].timfix) {
                    timfix = 'f';
                }
                ISFIO.write_origin(ofp, yyyy, mm, dd, hh, mi, sec, timfix, h[i].stime, h[i].sdobs, h[i].lat, h[i].lon, epifix, h[i].smajax, h[i].sminax, h[i].strike, h[i].depth, depfix, h[i].sdepth, h[i].ndef, h[i].ndefsta, h[i].azimgap, h[i].mindist, h[i].maxdist, antype, loctype, h[i].etype, h[i].agency, h[i].hypid);
            }
            ++i;
        }
        Utils.human_time(sp.time, ymdhms);
        yyyy = ymdhms[0];
        mm = ymdhms[1];
        dd = ymdhms[2];
        hh = ymdhms[3];
        mi = ymdhms[4];
        sec = (double)ymdhms[5] + (double)ymdhms[6] / 1000.0;
        timfix = ' ';
        epifix = ' ';
        depfix = ' ';
        if (sp.depfix) {
            depfix = 'f';
        }
        if (ep.fix_depth_depdp) {
            depfix = 'd';
        }
        if (sp.epifix) {
            epifix = 'f';
        }
        if (sp.timfix) {
            timfix = 'f';
        }
        ISFIO.write_origin(ofp, yyyy, mm, dd, hh, mi, sec, timfix, sp.error[0], sp.sdobs, sp.lat, sp.lon, epifix, sp.smajax, sp.sminax, sp.strike, sp.depth, depfix, sp.error[3], sp.ndef, sp.ndefsta, sp.azimgap, sp.mindist, sp.maxdist, antype, loctype, ep.etype, Config.out_agency, sp.hypid);
        ofp.printf(" (#PRIME)\n\n", new Object[0]);
        if (sp.bodymag != 9999999.0 || sp.surfmag != 9999999.0) {
            ofp.printf("Magnitude  Err Nsta Author      OrigID\n", new Object[0]);
        }
        if (sp.bodymag != 9999999.0) {
            ofp.printf("mb    %4.1f %3.1f %4d %-9s %d\n", sp.bodymag, sp.bodymag_uncertainty, sp.nsta_mb, Config.out_agency, sp.hypid);
        }
        if (sp.surfmag != 9999999.0) {
            ofp.printf("MS    %4.1f %3.1f %4d %-9s %d\n", sp.surfmag, sp.surfmag_uncertainty, sp.nsta_ms, Config.out_agency, sp.hypid);
        }
        ofp.printf("\nSta     Dist  EvAz Phase        Time      TRes  ", new Object[0]);
        ofp.printf("Azim AzRes   Slow   SRes Def   SNR       Amp   Per ", new Object[0]);
        ofp.printf("Qual Magnitude    ArrID\n", new Object[0]);
        int rdid = -1;
        i = 0;
        while (i < ep.numphas) {
            if (p[i].rdid != rdid && i != 0) {
                j = 0;
                while (j < sp.nass_mb) {
                    if (rdid == rdmag_mb[j].rdid && rdmag_mb[j].magdef != 0) {
                        ISFIO.write_phase(ofp, rdmag_mb[j].sta, p[i - 1].delta, p[i - 1].esaz, "MB_STA", (int)x, (int)x, x, x, x, x, '_', x, x, 'x', 'x', "mb", rdmag_mb[j].magnitude, rdid);
                    }
                    ++j;
                }
                j = 0;
                while (j < sp.nass_ms) {
                    if (rdid == rdmag_ms[j].rdid && rdmag_ms[j].magdef != 0) {
                        ISFIO.write_phase(ofp, rdmag_ms[j].sta, p[i - 1].delta, p[i - 1].esaz, "MS_STA", (int)x, (int)x, x, x, x, x, '_', x, x, 'x', 'x', "MS", rdmag_ms[j].magnitude, rdid);
                    }
                    ++j;
                }
            }
            rdid = p[i].rdid;
            per = 9999999.0;
            amp = 9999999.0;
            if (p[i].time == 9999999.0) {
                hh = 9999999;
            } else {
                Utils.human_time(p[i].time, ymdhms);
                yyyy = ymdhms[0];
                mm = ymdhms[1];
                dd = ymdhms[2];
                hh = ymdhms[3];
                mi = ymdhms[4];
                sec = (double)ymdhms[5] + (double)ymdhms[6] / 1000.0;
            }
            char timedef = p[i].timedef ? (char)'T' : '_';
            if (p[i].numamps > 0) {
                amp = p[i].a[0].amp;
                per = p[i].a[0].per;
            }
            ISFIO.write_phase(ofp, p[i].sta, p[i].delta, p[i].esaz, p[i].phase, hh, mi, sec, p[i].resid, p[i].azim, p[i].slow, timedef, amp, per, p[i].sp_fm, p[i].detchar, "     ", x, p[i].phid);
            boolean isms = false;
            boolean ismb = false;
            if (p[i].numamps > 1) {
                j = 0;
                while (j < Config.mb_phase_num) {
                    if (Config.streq(p[i].phase, Config.mb_phase[j])) {
                        ismb = true;
                    }
                    ++j;
                }
                j = 0;
                while (j < Config.ms_phase_num) {
                    if (Config.streq(p[i].phase, Config.ms_phase[j])) {
                        isms = true;
                    }
                    ++j;
                }
                if (ismb) {
                    phase = "AMB";
                }
                if (isms) {
                    phase = "AMS";
                }
                if (ismb || isms) {
                    j = 1;
                    while (j < p[i].numamps) {
                        ISFIO.write_phase(ofp, p[i].sta, p[i].delta, p[i].esaz, phase, (int)x, (int)x, x, x, x, x, '_', p[i].a[j].amp, p[i].a[j].per, 'x', 'x', "     ", x, p[i].phid);
                        ++j;
                    }
                }
            }
            ++i;
        }
        j = 0;
        while (j < sp.nass_mb) {
            if (rdid == rdmag_mb[j].rdid && rdmag_mb[j].magdef != 0) {
                ISFIO.write_phase(ofp, rdmag_mb[j].sta, p[i - 1].delta, p[i - 1].esaz, "MB_STA", (int)x, (int)x, x, x, x, x, '_', x, x, 'x', 'x', "mb", rdmag_mb[j].magnitude, rdid);
            }
            ++j;
        }
        j = 0;
        while (j < sp.nass_ms) {
            if (rdid == rdmag_ms[j].rdid && rdmag_ms[j].magdef != 0) {
                ISFIO.write_phase(ofp, rdmag_ms[j].sta, p[i - 1].delta, p[i - 1].esaz, "MS_STA", (int)x, (int)x, x, x, x, x, '_', x, x, 'x', 'x', "MS", rdmag_ms[j].magnitude, rdid);
            }
            ++j;
        }
    }

    public static boolean write_stafile(ISCSta[] ps) {
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(Config.isf_stafile));
            int i = 0;
            while (i < ps.length) {
                String sta;
                String net;
                int idx = ps[i].sta.indexOf(46);
                if (idx != -1) {
                    net = ps[i].sta.substring(0, idx);
                    sta = ps[i].sta.substring(idx + 1);
                } else {
                    net = null;
                    sta = ps[i].sta;
                }
                pw.printf("%-5s, %-5s, %8.4f, %9.4f, %6.1f", sta, sta, ps[i].lat, ps[i].lon, ps[i].elev);
                if (net != null) {
                    pw.printf(", %2s", net);
                }
                pw.println();
                ++i;
            }
            pw.close();
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            return false;
        }
        return true;
    }

    public static ISCSta[] read_stafile() {
        double elev = 0.0;
        Scanner sc = null;
        try {
            sc = new Scanner(new File(Config.isf_stafile));
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        String delimiter = "((,)+|\\p{javaWhitespace}+)+";
        sc.useDelimiter(delimiter);
        int i = 0;
        while (sc.hasNext()) {
            String line = sc.nextLine();
            if (line.trim().length() == 0) continue;
            ++i;
        }
        Config.numsta = i;
        sc.close();
        try {
            sc = new Scanner(new File(Config.isf_stafile));
            sc.useDelimiter(delimiter);
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        sc.useDelimiter(delimiter);
        Object[] slist = new ISCSta[Config.numsta];
        i = 0;
        while (i < Config.numsta) {
            slist[i] = new ISCSta();
            ++i;
        }
        i = 0;
        while (sc.hasNext()) {
            Scanner sc1 = new Scanner(sc.nextLine()).useDelimiter(delimiter);
            ((ISCSta)slist[i]).sta = sc1.next();
            ((ISCSta)slist[i]).altsta = sc1.next();
            ((ISCSta)slist[i]).lat = sc1.nextDouble();
            ((ISCSta)slist[i]).lon = sc1.nextDouble();
            elev = sc1.nextDouble();
            ((ISCSta)slist[i]).elev = 9999999.0;
            if (elev > -9999.0) {
                ((ISCSta)slist[i]).elev = elev;
            }
            if (sc1.hasNext()) {
                String net = sc1.next();
                ((ISCSta)slist[i]).sta = String.valueOf(net) + "." + ((ISCSta)slist[i]).sta;
                ((ISCSta)slist[i]).altsta = String.valueOf(net) + "." + ((ISCSta)slist[i]).altsta;
            }
            sc1.close();
            ++i;
        }
        sc.close();
        Arrays.sort(slist, 0, Config.numsta);
        return slist;
    }

    static void sort_phaserec_isf(int numphas, ISCPha[] p) {
        int j;
        int i = 1;
        while (i < numphas) {
            j = i - 1;
            while (j > -1) {
                if (p[j].time > p[j + 1].time && p[j + 1].time != 9999999.0 || p[j].time == 9999999.0) {
                    Utils.swap(p, j, j + 1);
                }
                --j;
            }
            ++i;
        }
        i = 1;
        while (i < numphas) {
            j = i - 1;
            while (j > -1) {
                if (p[j].prista.compareTo(p[j + 1].prista) > 0) {
                    Utils.swap(p, j, j + 1);
                }
                --j;
            }
            ++i;
        }
        i = 1;
        while (i < numphas) {
            j = i - 1;
            while (j > -1) {
                if (p[j].delta > p[j + 1].delta) {
                    Utils.swap(p, j, j + 1);
                }
                --j;
            }
            ++i;
        }
    }

    static int parse_event_id(String line, intW evid) {
        String[] substr = new String[1];
        if (!line.startsWith("Event ") && !line.startsWith("EVENT ")) {
            return 1;
        }
        if (ISFIO.partline(substr, 0, line, 6, 8)) {
            if (ISFIO.check_int(substr[0])) {
                isf_error = String.format("bad evid: %s", line);
                return 1;
            }
        } else {
            return 1;
        }
        evid.val = Integer.parseInt(substr[0]);
        return 0;
    }

    static int parse_origin(String line, intW yyyy, intW mm, intW dd, intW hh, intW mi, intW ss, intW msec, char[] timfix, double[] stime, double[] sdobs, double[] lat, double[] lon, char[] epifix, double[] smaj, double[] smin, int[] strike, double[] depth, char[] depfix, double[] sdepth, int[] ndef, int[] nsta, int[] gap, double[] mindist, double[] maxdist, String[] etype, String[] author, int[] origid, int ind) {
        String[] substr = new String[1];
        if (!ISFIO.partline(substr, 0, line, 0, 4)) {
            isf_error = String.format("missing year: %s", line);
            return 1;
        }
        if (ISFIO.check_int(substr[0])) {
            isf_error = String.format("bad year: %s", line);
            return 1;
        }
        yyyy.val = Integer.parseInt(substr[0]);
        if (!ISFIO.partline(substr, 0, line, 5, 2)) {
            isf_error = String.format("missing month: %s", line);
            return 1;
        }
        if (ISFIO.check_int(substr[0])) {
            isf_error = String.format("bad month: %s", line);
            return 1;
        }
        mm.val = Integer.parseInt(substr[0]);
        if (!ISFIO.partline(substr, 0, line, 8, 2)) {
            isf_error = String.format("missing day: %s", line);
            return 1;
        }
        if (ISFIO.check_int(substr[0])) {
            isf_error = String.format("bad day: %s", line);
            return 1;
        }
        dd.val = Integer.parseInt(substr[0]);
        if (!ISFIO.partline(substr, 0, line, 11, 2)) {
            isf_error = String.format("missing hour: %s", line);
            return 1;
        }
        if (ISFIO.check_int(substr[0])) {
            isf_error = String.format("bad hour: %s", line);
            return 1;
        }
        hh.val = Integer.parseInt(substr[0]);
        if (!ISFIO.partline(substr, 0, line, 14, 2)) {
            isf_error = String.format("missing minute: %s", line);
            return 1;
        }
        if (ISFIO.check_int(substr[0])) {
            isf_error = String.format("bad minute: %s", line);
            return 1;
        }
        mi.val = Integer.parseInt(substr[0]);
        if (!ISFIO.partline(substr, 0, line, 17, 2)) {
            isf_error = String.format("missing second: %s", line);
            return 1;
        }
        if (ISFIO.check_int(substr[0])) {
            isf_error = String.format("bad second: %s", line);
            return 1;
        }
        ss.val = Integer.parseInt(substr[0]);
        if (ISFIO.partline(substr, 0, line, 20, 2)) {
            if (line.charAt(19) != '.') {
                isf_error = String.format("bad date: %s", line);
                return 1;
            }
            if (!Character.isDigit(line.charAt(20))) {
                isf_error = String.format("bad date: %s", line);
                return 1;
            }
            msec.val = (line.charAt(20) - 48) * 100;
            if (Character.isDigit(line.charAt(21))) {
                msec.val += (line.charAt(21) - 48) * 10;
            } else if (line.charAt(21) != ' ') {
                isf_error = String.format("bad date: %s", line);
                return 1;
            }
        } else {
            if (line.charAt(19) != '.' && line.charAt(19) != ' ') {
                isf_error = String.format("bad date: %s", line);
                return 1;
            }
            msec.val = 9999999;
        }
        if (line.charAt(22) != ' ' && line.charAt(22) != 'f') {
            isf_error = String.format("bad timfix: %s", line);
            return 1;
        }
        timfix[ind] = line.charAt(22);
        if (ISFIO.partline(substr, 0, line, 24, 5)) {
            if (ISFIO.check_float(substr[0])) {
                isf_error = String.format("bad stime: %s", line);
                return 1;
            }
            stime[ind] = Double.parseDouble(substr[0]);
        } else {
            stime[ind] = 9999999.0;
        }
        if (ISFIO.partline(substr, 0, line, 30, 5)) {
            if (ISFIO.check_float(substr[0])) {
                isf_error = String.format("bad sdobs: %s", line);
                return 1;
            }
            sdobs[ind] = Double.parseDouble(substr[0]);
        } else {
            sdobs[ind] = 9999999.0;
        }
        if (!ISFIO.partline(substr, 0, line, 36, 8)) {
            isf_error = String.format("missing latitude: %s", line);
            return 1;
        }
        if (ISFIO.check_float(substr[0])) {
            isf_error = String.format("bad latitude: %s", line);
            return 1;
        }
        lat[ind] = Double.parseDouble(substr[0]);
        if (!ISFIO.partline(substr, 0, line, 45, 9)) {
            isf_error = String.format("missing longitude: %s", line);
            return 1;
        }
        if (ISFIO.check_float(substr[0])) {
            isf_error = String.format("bad longitude: %s", line);
            return 1;
        }
        lon[ind] = Double.parseDouble(substr[0]);
        if (line.charAt(54) != ' ' && line.charAt(54) != 'f') {
            isf_error = String.format("bad epifix: %s", line);
            return 1;
        }
        epifix[ind] = line.charAt(54);
        if (ISFIO.partline(substr, 0, line, 55, 5)) {
            if (ISFIO.check_float(substr[0])) {
                isf_error = String.format("bad smaj: %s", line);
                return 1;
            }
            smaj[ind] = Double.parseDouble(substr[0]);
        } else {
            smaj[ind] = 9999999.0;
        }
        if (ISFIO.partline(substr, 0, line, 61, 5)) {
            if (ISFIO.check_float(substr[0])) {
                isf_error = String.format("bad smin: %s", line);
                return 1;
            }
            smin[ind] = Double.parseDouble(substr[0]);
        } else {
            smin[ind] = 9999999.0;
        }
        if (ISFIO.partline(substr, 0, line, 67, 3)) {
            if (ISFIO.check_int(substr[0])) {
                isf_error = String.format("bad strike: %s", line);
                return 1;
            }
            strike[ind] = Integer.parseInt(substr[0]);
        } else {
            strike[ind] = 9999999;
        }
        if (ISFIO.partline(substr, 0, line, 71, 5)) {
            if (ISFIO.check_float(substr[0])) {
                isf_error = String.format("bad depth: %s", line);
                return 1;
            }
            depth[ind] = Double.parseDouble(substr[0]);
        } else {
            depth[ind] = 9999999.0;
        }
        if (line.charAt(76) != ' ' && line.charAt(76) != 'f' && line.charAt(76) != 'd') {
            isf_error = String.format("bad depfix: %s", line);
            return 1;
        }
        depfix[ind] = line.charAt(76);
        if (ISFIO.partline(substr, 0, line, 78, 4)) {
            if (ISFIO.check_float(substr[0])) {
                isf_error = String.format("bad sdepth: %s", line);
                return 1;
            }
            sdepth[ind] = Double.parseDouble(substr[0]);
        } else {
            sdepth[ind] = 9999999.0;
        }
        if (ISFIO.partline(substr, 0, line, 83, 4)) {
            if (ISFIO.check_int(substr[0])) {
                isf_error = String.format("bad ndef: %s", line);
                return 1;
            }
            ndef[ind] = Integer.parseInt(substr[0]);
        } else {
            ndef[ind] = 9999999;
        }
        if (ISFIO.partline(substr, 0, line, 88, 4)) {
            if (ISFIO.check_int(substr[0])) {
                isf_error = String.format("bad nsta: %s", line);
                return 1;
            }
            nsta[ind] = Integer.parseInt(substr[0]);
        } else {
            nsta[ind] = 9999999;
        }
        if (ISFIO.partline(substr, 0, line, 93, 3)) {
            if (ISFIO.check_int(substr[0])) {
                isf_error = String.format("bad gap: %s", line);
                return 1;
            }
            gap[ind] = Integer.parseInt(substr[0]);
        } else {
            gap[ind] = 9999999;
        }
        if (ISFIO.partline(substr, 0, line, 97, 6)) {
            if (ISFIO.check_float(substr[0])) {
                isf_error = String.format("bad mindist: %s", line);
                return 1;
            }
            mindist[ind] = Double.parseDouble(substr[0]);
        } else {
            mindist[ind] = 9999999.0;
        }
        if (ISFIO.partline(substr, 0, line, 104, 6)) {
            if (ISFIO.check_float(substr[0])) {
                isf_error = String.format("bad maxdist: %s", line);
                return 1;
            }
            maxdist[ind] = Double.parseDouble(substr[0]);
        } else {
            maxdist[ind] = 9999999.0;
        }
        if (!ISFIO.partline(etype, ind, line, 115, 2)) {
            etype[ind] = "  ";
        } else if (etype[ind].length() != 2) {
            isf_error = String.format("bad etype: %s", line);
            return 1;
        }
        if (!ISFIO.partline(author, ind, line, 118, 9)) {
            isf_error = String.format("missing author: %s", line);
            return 1;
        }
        if (ISFIO.check_whole(author[ind])) {
            isf_error = String.format("bad author: %s", line);
            return 1;
        }
        if (ISFIO.partline(substr, 0, line, 128, 8)) {
            if (ISFIO.check_int(substr[0])) {
                isf_error = String.format("bad origid: %s", line);
                return 1;
            }
        } else {
            isf_error = String.format("missing origid: %s", line);
            return 1;
        }
        origid[ind] = Integer.parseInt(substr[0]);
        return 0;
    }

    static int parse_phase(String line, String[] sta, double[] dist, String[] phase, intW hh, intW mi, intW ss, intW msec, double[] azim, double[] slow, double[] amp, double[] per, char[] sp_fm, char[] detchar, int ind) {
        String[] substr = new String[1];
        if (!ISFIO.partline(sta, ind, line, 0, 5)) {
            isf_error = String.format("missing sta: %s", line);
            return 1;
        }
        if (ISFIO.check_whole(sta[ind])) {
            isf_error = String.format("bad sta: %s", line);
            return 1;
        }
        if (ISFIO.partline(substr, 0, line, 6, 6)) {
            if (ISFIO.check_float(substr[0])) {
                isf_error = String.format("bad distance: %s", line);
                return 1;
            }
            dist[ind] = Double.parseDouble(substr[0]);
        } else {
            dist[ind] = 9999999.0;
        }
        if (ISFIO.partline(phase, ind, line, 19, 8)) {
            if (ISFIO.check_whole(phase[ind])) {
                isf_error = String.format("bad phase: %s", line);
                return 1;
            }
        } else {
            phase[ind] = " ";
        }
        if (phase[ind].length() == 0) {
            phase[ind] = "i";
        }
        if (ISFIO.partline(substr, 0, line, 28, 12)) {
            if (!ISFIO.partline(substr, 0, line, 28, 2)) {
                isf_error = String.format("missing hour: %s", line);
                return 1;
            }
            if (ISFIO.check_int(substr[0])) {
                isf_error = String.format("bad hour: %s", line);
                return 1;
            }
            hh.val = Integer.parseInt(substr[0]);
            if (!ISFIO.partline(substr, 0, line, 31, 2)) {
                isf_error = String.format("missing minute: %s", line);
                return 1;
            }
            if (ISFIO.check_int(substr[0])) {
                isf_error = String.format("bad minute: %s", line);
                return 1;
            }
            mi.val = Integer.parseInt(substr[0]);
            if (!ISFIO.partline(substr, 0, line, 34, 2)) {
                isf_error = String.format("missing second: %s", line);
                return 1;
            }
            if (ISFIO.check_int(substr[0])) {
                isf_error = String.format("bad second: %s", line);
                return 1;
            }
            ss.val = Integer.parseInt(substr[0]);
            if (ISFIO.partline(substr, 0, line, 37, 3)) {
                if (line.charAt(36) != '.') {
                    isf_error = String.format("bad time: %s", line);
                    return 1;
                }
                if (!Character.isDigit(line.charAt(37))) {
                    isf_error = String.format("bad time: %s", line);
                    return 1;
                }
                msec.val = (line.charAt(37) - 48) * 100;
                if (Character.isDigit(line.charAt(38))) {
                    msec.val += (line.charAt(38) - 48) * 10;
                } else if (line.charAt(38) != ' ' || line.charAt(39) != ' ') {
                    isf_error = String.format("bad time: %s", line);
                    return 1;
                }
                if (Character.isDigit(line.charAt(39))) {
                    msec.val += line.charAt(39) - 48;
                } else if (line.charAt(39) != ' ') {
                    isf_error = String.format("bad time: %s", line);
                    return 1;
                }
            } else {
                if (line.charAt(36) != '.' && line.charAt(36) != ' ') {
                    isf_error = String.format("bad time: %s", line);
                    return 1;
                }
                msec.val = 9999999;
            }
        } else {
            hh.val = 9999999;
            mi.val = 9999999;
            ss.val = 9999999;
            msec.val = 9999999;
        }
        if (ISFIO.partline(substr, 0, line, 47, 5)) {
            if (ISFIO.check_float(substr[0])) {
                isf_error = String.format("bad azim: %s", line);
                return 1;
            }
            azim[ind] = Double.parseDouble(substr[0]);
        } else {
            azim[ind] = 9999999.0;
        }
        if (ISFIO.partline(substr, 0, line, 59, 6)) {
            if (ISFIO.check_float(substr[0])) {
                isf_error = String.format("bad slow: %s", line);
                return 1;
            }
            slow[ind] = Double.parseDouble(substr[0]);
        } else {
            slow[ind] = 9999999.0;
        }
        if (ISFIO.partline(substr, 0, line, 83, 9)) {
            if (ISFIO.check_float(substr[0])) {
                isf_error = String.format("bad amp: %s", line);
                return 1;
            }
            amp[ind] = Double.parseDouble(substr[0]);
        } else {
            amp[ind] = 9999999.0;
        }
        if (ISFIO.partline(substr, 0, line, 93, 5)) {
            if (ISFIO.check_float(substr[0])) {
                isf_error = String.format("bad per: %s", line);
                return 1;
            }
            per[ind] = Double.parseDouble(substr[0]);
        } else {
            per[ind] = 9999999.0;
        }
        int c = Character.toLowerCase(line.charAt(100));
        sp_fm[ind] = c == 99 || c == 100 ? c : 95;
        c = Character.toLowerCase(line.charAt(101));
        detchar[ind] = c == 105 || c == 101 || c == 113 ? line.charAt(101) : (char)95;
        if (ISFIO.partline(substr, 0, line, 126, 2)) {
            sta[ind] = String.valueOf(substr[0]) + "." + sta[ind];
        }
        return 0;
    }

    static void write_origin(PrintWriter fp, int yyyy, int mm, int dd, int hh, int mi, double sec, char timfix, double stime, double sdobs, double lat, double lon, char epifix, double smaj, double smin, double strike, double depth, char depfix, double sdepth, int ndef, int nsta, double gap, double mindist, double maxdist, char antype, char loctype, String etype, String author, int origid) {
        fp.printf("%04d/%02d/%02d %02d:%02d:%05.2f%c ", yyyy, mm, dd, hh, mi, sec, Character.valueOf(timfix));
        if (stime == 9999999.0) {
            fp.printf("      ", new Object[0]);
        } else {
            fp.printf("%5.2f ", stime);
        }
        if (sdobs == 9999999.0) {
            fp.printf("      ", new Object[0]);
        } else {
            fp.printf("%5.2f ", sdobs);
        }
        fp.printf("%8.4f %9.4f%c", lat, lon, Character.valueOf(epifix));
        if (smaj == 9999999.0) {
            fp.printf("      ", new Object[0]);
        } else {
            fp.printf("%5.1f ", smaj);
        }
        if (smin == 9999999.0) {
            fp.printf("      ", new Object[0]);
        } else {
            fp.printf("%5.1f ", smin);
        }
        if (strike == 9999999.0) {
            fp.printf("    ", new Object[0]);
        } else {
            fp.printf("%3.0f ", strike);
        }
        if (depth == 9999999.0) {
            fp.printf("     %c ", Character.valueOf(depfix));
        } else {
            fp.printf("%5.1f%c ", depth, Character.valueOf(depfix));
        }
        if (sdepth == 9999999.0) {
            fp.printf("     ", new Object[0]);
        } else {
            fp.printf("%4.1f ", sdepth);
        }
        if (ndef == 9999999) {
            fp.printf("     ", new Object[0]);
        } else {
            fp.printf("%4d ", ndef);
        }
        if (nsta == 9999999) {
            fp.printf("     ", new Object[0]);
        } else {
            fp.printf("%4d ", nsta);
        }
        if (gap == 9999999.0) {
            fp.printf("    ", new Object[0]);
        } else {
            fp.printf("%3.0f ", gap);
        }
        if (mindist == 9999999.0) {
            fp.printf("       ", new Object[0]);
        } else {
            fp.printf("%6.2f ", mindist);
        }
        if (maxdist == 9999999.0) {
            fp.printf("       ", new Object[0]);
        } else {
            fp.printf("%6.2f ", maxdist);
        }
        fp.printf("%c %c ", Character.valueOf(antype), Character.valueOf(loctype));
        if (etype.length() == 0) {
            fp.printf("   ", new Object[0]);
        } else {
            fp.printf("%-2s ", etype);
        }
        if (author.length() == 0) {
            fp.printf("          ", new Object[0]);
        } else {
            fp.printf("%-9s ", author);
        }
        fp.printf("%8d\n", origid);
    }

    static void write_phase(PrintWriter fp, String sta, double dist, double esaz, String phase, int hh, int mi, double sec, double timeres, double azim, double slow, char timedef, double amp, double per, char sp_fm, char detchar, String magtype, double mag, int arid) {
        String s;
        String n;
        int idx = sta.indexOf(46);
        if (idx != -1) {
            n = sta.substring(0, idx);
            s = sta.substring(idx + 1);
        } else {
            n = null;
            s = sta;
        }
        fp.printf("%-5s ", s);
        if (dist == 9999999.0) {
            fp.printf("       ", new Object[0]);
        } else {
            fp.printf("%6.2f ", dist);
        }
        if (esaz == 9999999.0) {
            fp.printf("      ", new Object[0]);
        } else {
            fp.printf("%5.1f ", esaz);
        }
        if (phase.length() == 0) {
            fp.printf("         ", new Object[0]);
        } else {
            fp.printf("%-8s ", phase);
        }
        if (hh == 9999999) {
            fp.printf("             ", new Object[0]);
        } else {
            fp.printf("%02d:%02d:%06.3f ", hh, mi, sec);
        }
        if (timeres == 9999999.0) {
            fp.printf("      ", new Object[0]);
        } else {
            if (timeres > 9999.0) {
                timeres = 9999.0;
            }
            if (timeres < -9999.0) {
                timeres = -9999.0;
            }
            fp.printf("%5.1f ", timeres);
        }
        if (azim == 9999999.0) {
            fp.printf("            ", new Object[0]);
        } else {
            fp.printf("%5.1f       ", azim);
        }
        if (slow == 9999999.0) {
            fp.printf("              ", new Object[0]);
        } else {
            fp.printf("%6.2f        ", slow);
        }
        fp.printf("%c__ ", Character.valueOf(timedef));
        fp.printf("      ", new Object[0]);
        if (amp == 9999999.0) {
            fp.printf("          ", new Object[0]);
        } else {
            fp.printf("%9.1f ", amp);
        }
        if (per == 9999999.0) {
            fp.printf("      ", new Object[0]);
        } else {
            fp.printf("%5.2f ", per);
        }
        char d = Character.toLowerCase(sp_fm);
        char c = d == 'c' || d == 'u' || d == '+' ? (char)'c' : (d == 'd' || d == '-' ? (char)'d' : '_');
        d = Character.toLowerCase(detchar);
        if (d != 'e' && d != 'i' && d != 'q') {
            d = '_';
        }
        fp.printf("_%c%c ", Character.valueOf(c), Character.valueOf(d));
        fp.printf("%-5s ", magtype);
        if (mag == 9999999.0) {
            fp.printf("     ", new Object[0]);
        } else {
            fp.printf("%4.1f ", mag);
        }
        if (phase.contains("STA")) {
            fp.printf("%9d R", arid);
        } else {
            fp.printf("%9d  ", arid);
        }
        if (n != null) {
            fp.printf(" %2s", n);
        }
        fp.println();
    }

    static boolean partline(String[] parts, int ind, String line, int offset, int numchars) {
        boolean bracket = false;
        char[] part = new char[1024];
        int len = line.length();
        if (len < offset) {
            return false;
        }
        if (numchars == 0) {
            numchars = len - offset;
        }
        int rlen = Math.min(offset + numchars, len);
        int i = offset;
        int j = 0;
        while (i < rlen) {
            char c = line.charAt(i);
            if (j != 0 || c != ' ' && c != '\t') {
                if (c == '\u0000' || c == '\n') break;
                part[j++] = c;
                if (c == '(') {
                    bracket = true;
                }
            }
            ++i;
        }
        if (!bracket) {
            while (--j != -1 && (part[j] == ' ' || part[j] == '\t' || part[j] == ')')) {
            }
            part[++j] = '\u0000';
        } else if (j != 0) {
            while (part[--j] == ' ' || part[j] == '\t') {
            }
            part[++j] = '\u0000';
        }
        parts[ind] = new String(part, 0, j).trim();
        return j != 0;
    }

    static boolean check_whole(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t') {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean all_blank(String s) {
        return s.trim().length() == 0;
    }

    static boolean check_int(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return true;
        }
        return false;
    }

    static boolean check_float(String s) {
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            return true;
        }
        return false;
    }

    public static class ISFStruct {
        public ISCEvent ep;
        public ISCHyp[] hp;
        public ISCPha[] pp;
        public ISCSta[] stationlist;
        public STAMAG[] stamag_mb;
        public STAMAG[] stamag_ms;
        public RDMAG[] rdmag_mb;
        public RDMAG[] rdmag_ms;
        public MSZH[] mszh;
    }
}

