/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.FE;
import cn.org.gddsn.seis.location.iscloc2.ISCSol;
import cn.org.gddsn.seis.location.iscloc2.Interpolate;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class GeoRegion {
    static Logger logger = Logger.getLogger(GeoRegion.class);
    private static final int[] gstab;
    private static final String[] sregs;
    private static final String[] gregs;

    static {
        int[] nArray = new int[52];
        nArray[1] = 1;
        nArray[2] = 18;
        nArray[3] = 30;
        nArray[4] = 47;
        nArray[5] = 53;
        nArray[6] = 72;
        nArray[7] = 84;
        nArray[8] = 102;
        nArray[9] = 143;
        nArray[10] = 147;
        nArray[11] = 158;
        nArray[12] = 169;
        nArray[13] = 180;
        nArray[14] = 183;
        nArray[15] = 190;
        nArray[16] = 196;
        nArray[17] = 209;
        nArray[18] = 211;
        nArray[19] = 217;
        nArray[20] = 231;
        nArray[21] = 242;
        nArray[22] = 248;
        nArray[23] = 261;
        nArray[24] = 273;
        nArray[25] = 294;
        nArray[26] = 302;
        nArray[27] = 320;
        nArray[28] = 326;
        nArray[29] = 335;
        nArray[30] = 357;
        nArray[31] = 376;
        nArray[32] = 402;
        nArray[33] = 415;
        nArray[34] = 438;
        nArray[35] = 528;
        nArray[36] = 532;
        nArray[37] = 550;
        nArray[38] = 588;
        nArray[39] = 611;
        nArray[40] = 633;
        nArray[41] = 656;
        nArray[42] = 667;
        nArray[43] = 683;
        nArray[44] = 693;
        nArray[45] = 700;
        nArray[46] = 703;
        nArray[47] = 709;
        nArray[48] = 713;
        nArray[49] = 721;
        nArray[50] = 727;
        nArray[51] = 729;
        gstab = nArray;
        sregs = new String[]{"ALASKA - ALEUTIAN ARC", "E. ALASKA TO VANCOUVER ISLAND", "CALIFORNIA - NEVADA REGION", "BAJA CALIF. AND GULF OF CALIF.", "MEXICO - GUATEMALA AREA", "CENTRAL AMERICA", "CARIBBEAN LOOP", "ANDEAN SOUTH AMERICA", "EXTREME SOUTH AMERICA", "SOUTHERN ANTILLES", "NEW ZEALAND REGION", "KERMADEC - TONGA - SAMOA AREA", "FIJI ISLANDS AREA", "NEW HEBRIDES ISLANDS", "BISMARCK AND SOLOMON ISLANDS", "NEW GUINEA", "CAROLINE ISLANDS TO GUAM", "GUAM TO JAPAN", "JAPAN - KURILES - KAMCHATKA", "S.W. JAPAN AND RYUKYU ISLANDS", "TAIWAN", "PHILIPPINES", "BORNEO - CELEBES", "SUNDA ARC", "BURMA AND SOUTHEAST ASIA", "INDIA - TIBET - SZECHWAN - YUNAN", "SOUTHERN SINKIANG TO KANSU", "ALMA-ATA TO LAKE BAIKAL", "WESTERN ASIA", "MIDDLE EAST - CRIMEA - BALKANS", "WESTERN MEDITERRANEAN AREA", "ATLANTIC OCEAN", "INDIAN OCEAN", "EASTERN NORTH AMERICA", "EASTERN SOUTH AMERICA", "NORTHWESTERN EUROPE", "AFRICA", "AUSTRALIA", "PACIFIC BASIN", "ARCTIC ZONE", "EASTERN ASIA", "NE. ASIA,N. ALASKA TO GREENLAND", "S.E. AND ANTARCTIC PACIFIC", "GALAPAGOS AREA", "MACQUARIE LOOP", "ANDAMAN ISLANDS TO SUMATRA", "BALUCHISTAN", "HINDU KUSH AND PAMIR", "NORTHERN ASIA", "ANTARCTICA"};
        gregs = new String[]{"Central Alaska", "Southern Alaska", "Bering Sea", "Komandorsky Islands region", "Near Islands", "Rat Islands", "Andreanof Islands", "Pribilof Islands", "Fox Islands", "Unimak Island region", "Bristol Bay", "Alaska Peninsula", "Kodiak Island region", "Kenai Peninsula", "Gulf of Alaska", "South of Aleutian Islands", "South of Alaska", "Southern Yukon Territory", "Southeastern Alaska", "Off coast of southeastern Alaska", "West of Vancouver Island", "Queen Charlotte Islands region", "British Columbia", "Alberta", "Vancouver Island region", "Off coast of Washington", "Near coast of Washington", "Washington-Oregon border region", "Washington", "Off coast of Oregon", "Near coast of Oregon", "Oregon", "Western Idaho", "Off coast of northern California", "Near coast of northern California", "Northern California", "Nevada", "Off coast of California", "Central California", "California-Nevada border region", "Southern Nevada", "Western Arizona", "Southern California", "California-Arizona border region", "California-Baja California border region", "Western Arizona-Sonora border region", "Off west coast of Baja California", "Baja California", "Gulf of California", "Sonora", "Off coast of central Mexico", "Near coast of central Mexico", "Revilla Gigedo Islands region", "Off coast of Jalisco", "Near coast of Jalisco", "Near coast of Michoacan", "Michoacan", "Near coast of Guerrero", "Guerrero", "Oaxaca", "Chiapas", "Mexico-Guatemala border region", "Off coast of Mexico", "Off coast of Michoacan", "Off coast of Guerrero", "Near coast of Oaxaca", "Off coast of Oaxaca", "Off coast of Chiapas", "Near coast of Chiapas", "Guatemala", "Near coast of Guatemala", "Honduras", "El Salvador", "Near coast of Nicaragua", "Nicaragua", "Off coast of central America", "Off coast of Costa Rica", "Costa Rica", "North of Panama", "Panama-Costa Rica border region", "Panama", "Panama-Colombia border region", "South of Panama", "Yucatan Peninsula", "Cuba region", "Jamaica region", "Haiti region", "Dominican Republic region", "Mona Passage", "Puerto Rico region", "Virgin Islands", "Leeward Islands", "Belize", "Caribbean Sea", "Windward Islands", "Near north coast of Colombia", "Near coast of Venezuela", "Trinidad", "Northern Colombia", "Lake Maracaibo", "Venezuela", "Near west coast of Colombia", "Colombia", "Off coast of Ecuador", "Near coast of Ecuador", "Colombia-Ecuador border region", "Ecuador", "Off coast of northern Peru", "Near coast of northern Peru", "Peru-Ecuador border region", "Northern Peru", "Peru-Brazil border region", "Western Brazil", "Off coast of Peru", "Near coast of Peru", "Central Peru", "Southern Peru", "Peru-Bolivia border region", "Northern Bolivia", "Central Bolivia", "Off coast of northern Chile", "Near coast of northern Chile", "Northern Chile", "Chile-Bolivia border region", "Southern Bolivia", "Paraguay", "Chile-Argentina border region", "Jujuy Province", "Salta Province", "Catamarca Province", "Tucuman Province", "Santiago del Estero Province", "Northeastern Argentina", "Off coast of central Chile", "Near coast of central Chile", "Central Chile", "San Juan Province", "La Rioja Province", "Mendoza Province", "San Luis Province", "Cordoba Province", "Uruguay", "Off coast of southern Chile", "Southern Chile", "Southern Chile-Argentina border region", "Southern Argentina", "Tierra del Fuego", "Falkland Islands region", "Drake Passage", "Scotia Sea", "South Georgia Island region", "South Georgia Rise", "South Sandwich Islands region", "South Shetland Islands", "Antarctic Peninsula", "Southwestern Atlantic Ocean", "Weddell Sea", "Off west coast of North Island", "North Island", "Off east coast of North Island", "Off west coast of South Island", "South Island", "Cook Strait", "Off east coast of South Island", "North of Macquarie Island", "Auckland Islands region", "Macquarie Island region", "South of New Zealand", "Samoa Islands region", "Samoa Islands", "South of Fiji Islands", "West of Tonga Islands (REGION NOT IN USE)", "Tonga Islands", "Tonga Islands region", "South of Tonga Islands", "North of New Zealand", "Kermadec Islands region", "Kermadec Islands", "South of Kermadec Islands", "North of Fiji Islands", "Fiji Islands region", "Fiji Islands", "Santa Cruz Islands region", "Santa Cruz Islands", "Vanuatu Islands region", "Vanuatu Islands", "New Caledonia", "Loyalty Islands", "Southeast of Loyalty Islands", "New Ireland region", "North of Solomon Islands", "New Britain region", "Bougainville - Solomon Islands region", "D'Entrecasteaux Islands region", "South of Solomon Islands", "Irian Jaya region", "Near north coast of Irian Jaya", "Ninigo Islands region", "Admiralty Islands region", "Near north coast of New Guinea", "Irian Jaya", "New Guinea", "Bismarck Sea", "Aru Islands region", "Near south coast of Irian Jaya", "Near south coast of New Guinea", "Eastern New Guinea region", "Arafura Sea", "Western Caroline Islands", "South of Mariana Islands", "Southeast of Honshu", "Bonin Islands region", "Volcano Islands region", "West of Mariana Islands", "Mariana Islands region", "Mariana Islands", "Kamchatka Peninsula", "Near east coast of Kamchatka Peninsula", "Off east coast of Kamchatka Peninsula", "Northwest of Kuril Islands", "Kuril Islands", "East of Kuril Islands", "Eastern Sea of Japan", "Hokkaido region", "Off southeast coast of Hokkaido", "Near west coast of eastern Honshu", "Eastern Honshu", "Near east coast of eastern Honshu", "Off east coast of Honshu", "Near south coast of eastern Honshu", "South Korea", "Western Honshu", "Near south coast of western Honshu", "Northwest of Ryukyu Islands", "Kyushu", "Shikoku", "Southeast of Shikoku", "Ryukyu Islands", "Southeast of Ryukyu Islands", "West of Bonin Islands", "Philippine Sea", "Near coast of southeastern China", "Taiwan region", "Taiwan", "Northeast of Taiwan", "Southwestern Ryukyu Islands", "Southeast of Taiwan", "Philippine Islands region", "Luzon", "Mindoro", "Samar", "Palawan", "Sulu Sea", "Panay", "Cebu", "Leyte", "Negros", "Sulu Archipelago", "Mindanao", "East of Philippine Islands", "Borneo", "Celebes Sea", "Talaud Islands", "North of Halmahera", "Minahassa Peninsula, Sulawesi", "Northern Molucca Sea", "Halmahera", "Sulawesi", "Southern Molucca Sea", "Ceram Sea", "Buru", "Seram", "Southwest of Sumatera", "Southern Sumatera", "Java Sea", "Sunda Strait", "Jawa", "Bali Sea", "Flores Sea", "Banda Sea", "Tanimbar Islands region", "South of Jawa", "Bali region", "South of Bali", "Sumbawa region", "Flores region", "Sumba region", "Savu Sea", "Timor region", "Timor Sea", "South of Sumbawa", "South of Sumba", "South of Timor", "Myanmar-India border region", "Myanmar-Bangladesh border region", "Myanmar", "Myanmar-China border region", "Near south coast of Myanmar", "Southeast Asia (REGION NOT IN USE)", "Hainan Island", "South China Sea", "Eastern Kashmir", "Kashmir-India border region", "Kashmir-Xizang border region", "Western Xizang-India border region", "Xizang", "Sichuan", "Northern India", "Nepal-India border region", "Nepal", "Sikkim", "Bhutan", "Eastern Xizang-India border region", "Southern India", "India-Bangladesh border region", "Bangladesh", "Northeastern India", "Yunnan", "Bay of Bengal", "Kyrgyzstan-Xinjiang border region", "Southern Xinjiang", "Gansu", "Western Nei Mongol", "Kashmir-Xinjiang border region", "Qinghai", "Southwestern Siberia", "Lake Baykal region", "East of Lake Baykal", "Eastern Kazakhstan", "Lake Issyk-Kul region", "Kazakhstan-Xinjiang border region", "Northern Xinjiang", "Tuva-Buryatia-Mongolia border region", "Mongolia", "Ural Mountains region", "Western Kazakhstan", "Eastern Caucasus", "Caspian Sea", "Northwestern Uzbekistan", "Turkmenistan", "Iran-Turkmenistan border region", "Turkmenistan-Afghanistan border region", "Turkey-Iran border region", "Iran-Armenia-Azerbaijan border region", "Northwestern Iran", "Iran-Iraq border region", "Western Iran", "Northern and central Iran", "Northwestern Afghanistan", "Southwestern Afghanistan", "Eastern Arabian Peninsula", "Persian Gulf", "Southern Iran", "Southwestern Pakistan", "Gulf of Oman", "Off coast of Pakistan", "Ukraine - Moldova - Southwestern Russia region", "Romania", "Bulgaria", "Black Sea", "Crimea region", "Western Caucasus", "Greece-Bulgaria border region", "Greece", "Aegean Sea", "Turkey", "Turkey-Georgia-Armenia border region", "Southern Greece", "Dodecanese Islands", "Crete", "Eastern Mediterranean Sea", "Cyprus region", "Dead Sea region", "Jordan - Syria region", "Iraq", "Portugal", "Spain", "Pyrenees", "Near south coast of France", "Corsica", "Central Italy", "Adriatic Sea", "Northwestern Balkan Peninsula", "West of Gibraltar", "Strait of Gibraltar", "Balearic Islands", "Western Mediterranean Sea", "Sardinia", "Tyrrhenian Sea", "Southern Italy", "Albania", "Greece-Albania border region", "Madeira Islands region", "Canary Islands region", "Morocco", "Northern Algeria", "Tunisia", "Sicily", "Ionian Sea", "Central Mediterranean Sea", "Near coast of Libya", "North Atlantic Ocean", "Northern Mid-Atlantic Ridge", "Azores Islands region", "Azores Islands", "Central Mid-Atlantic Ridge", "North of Ascension Island", "Ascension Island region", "South Atlantic Ocean", "Southern Mid-Atlantic Ridge", "Tristan da Cunha region", "Bouvet Island region", "Southwest of Africa", "Southeastern Atlantic Ocean", "Eastern Gulf of Aden", "Socotra region", "Arabian Sea", "Lakshadweep region", "Northeastern Somalia", "North Indian Ocean", "Carlsberg Ridge", "Maldive Islands region", "Laccadive Sea", "Sri Lanka", "South Indian Ocean", "Chagos Archipelago region", "Mauritius - Reunion region", "Southwest Indian Ridge", "Mid-Indian Ridge", "South of Africa", "Prince Edward Islands region", "Crozet Islands region", "Kerguelen Islands region", "Broken Ridge", "Southeast Indian Ridge", "Southern Kerguelen Plateau", "South of Australia", "Saskatchewan", "Manitoba", "Hudson Bay", "Ontario", "Hudson Strait region", "Northern Quebec", "Davis Strait", "Labrador", "Labrador Sea", "Southern Quebec", "Gaspe Peninsula", "Eastern Quebec", "Anticosti Island", "New Brunswick", "Nova Scotia", "Prince Edward Island", "Gulf of St. Lawrence", "Newfoundland", "Montana", "Eastern Idaho", "Hebgen Lake region, Montana", "Yellowstone region", "Wyoming", "North Dakota", "South Dakota", "Nebraska", "Minnesota", "Iowa", "Wisconsin", "Illinois", "Michigan", "Indiana", "Southern Ontario", "Ohio", "New York", "Pennsylvania", "Vermont - New Hampshire region", "Maine", "Southern New England", "Gulf of Maine", "Utah", "Colorado", "Kansas", "Iowa-Missouri border region", "Missouri-Kansas border region", "Missouri", "Missouri-Arkansas border region", "Missouri-Illinois border region", "New Madrid region, Missouri", "Cape Girardeau region, Missouri", "Southern Illinois", "Southern Indiana", "Kentucky", "West Virginia", "Virginia", "Chesapeake Bay region", "New Jersey", "Eastern Arizona", "New Mexico", "Northwestern Texas-Oklahoma border region", "Western Texas", "Oklahoma", "Central Texas", "Arkansas-Oklahoma border region", "Arkansas", "Louisiana-Texas border region", "Louisiana", "Mississippi", "Tennessee", "Alabama", "Western Florida", "Georgia", "Florida-Georgia border region", "South Carolina", "North Carolina", "Off east coast of United States", "Florida Peninsula", "Bahama Islands", "Eastern Arizona-Sonora border region", "New Mexico-Chihuahua border region", "Texas-Mexico border region", "Southern Texas", "Near coast of Texas", "Chihuahua", "Northern Mexico", "Central Mexico", "Jalisco", "Veracruz", "Gulf of Mexico", "Bay of Campeche", "Brazil", "Guyana", "Suriname", "French Guiana", "Eire", "United Kingdom", "North Sea", "Southern Norway", "Sweden", "Baltic Sea", "France", "Bay of Biscay", "The Netherlands", "Belgium", "Denmark", "Germany", "Switzerland", "Northern Italy", "Austria", "Czech and Slovak Republics", "Poland", "Hungary", "Northwest Africa (REGION NOT IN USE)", "Southern Algeria", "Libya", "Egypt", "Red Sea", "Western Arabian Peninsula", "Chad region", "Sudan", "Ethiopia", "Western Gulf of Aden", "Northwestern Somalia", "Off south coast of northwest Africa", "Cameroon", "Equatorial Guinea", "Central African Republic", "Gabon", "Congo", "Zaire", "Uganda", "Lake Victoria region", "Kenya", "Southern Somalia", "Lake Tanganyika region", "Tanzania", "Northwest of Madagascar", "Angola", "Zambia", "Malawi", "Namibia", "Botswana", "Zimbabwe", "Mozambique", "Mozambique Channel", "Madagascar", "South Africa", "Lesotho", "Swaziland", "Off coast of South Africa", "Northwest of Australia", "West of Australia", "Western Australia", "Northern Territory", "South Australia", "Gulf of Carpentaria", "Queensland", "Coral Sea", "Northwest of New Caledonia", "New Caledonia region", "Southwest of Australia", "Off south coast of Australia", "Near coast of South Australia", "New South Wales", "Victoria", "Near southeast coast of Australia", "Near east coast of Australia", "East of Australia", "Norfolk Island region", "Northwest of New Zealand", "Bass Strait", "Tasmania region", "Southeast of Australia", "North Pacific Ocean", "Hawaiian Islands region", "Hawaiian Islands", "Eastern Caroline Islands region", "Marshall Islands region", "Enewetak Atoll region", "Bikini Atoll region", "Gilbert Islands region", "Johnston Island region", "Line Islands region", "Palmyra Island region", "Kiritimati region", "Tuvalu region", "Phoenix Islands region", "Tokelau Islands region", "Northern Cook Islands", "Cook Islands region", "Society Islands region", "Tubuai Islands region", "Marquesas Islands region", "Tuamotu Archipelago region", "South Pacific Ocean", "Lomonosov Ridge", "Arctic Ocean", "Near north coast of Kalaallit Nunaat", "Eastern Kalaallit Nunaat", "Iceland region", "Iceland", "Jan Mayen Island region", "Greenland Sea", "North of Svalbard", "Norwegian Sea", "Svalbard region", "North of Franz Josef Land", "Franz Josef Land", "Northern Norway", "Barents Sea", "Novaya Zemlya", "Kara Sea", "Near coast of northwestern Siberia", "North of Severnaya Zemlya", "Severnaya Zemlya", "Near coast of northern Siberia", "East of Severnaya Zemlya", "Laptev Sea", "Southeastern Siberia", "Primorye-Northeastern China border region", "Northeastern China", "North Korea", "Sea of Japan", "Primorye", "Sakhalin Island", "Sea of Okhotsk", "Southeastern China", "Yellow Sea", "Off east coast of southeastern China", "North of New Siberian Islands", "New Siberian Islands", "Eastern Siberian Sea", "Near north coast of eastern Siberia", "Eastern Siberia", "Chukchi Sea", "Bering Strait", "St. Lawrence Island region", "Beaufort Sea", "Northern Alaska", "Northern Yukon Territory", "Queen Elizabeth Islands", "Northwest Territories", "Western Kalaallit Nunaat", "Baffin Bay", "Baffin Island region", "Southeast Central Pacific Ocean", "Southern East Pacific Rise", "Easter Island region", "West Chile Rise", "Juan Fernandez Islands region", "East of North Island", "Chatham Islands region", "South of Chatham Islands", "Pacific-Antarctic Ridge", "Southern Pacific Ocean", "East Central Pacific Ocean", "Central East Pacific Rise", "West of Galapagos Islands", "Galapagos Islands region", "Galapagos Islands", "Southwest of Galapagos Islands", "Southeast of Galapagos Islands", "South of Tasmania", "West of Macquarie Island", "Balleny Islands region", "Andaman Islands region", "Nicobar Islands region", "Off west coast of northern Sumatera", "Northern Sumatera", "Malay Peninsula", "Gulf of Thailand", "Southeastern Afghanistan", "Pakistan", "Southwestern Kashmir", "India-Pakistan border region", "Central Kazakhstan", "Southeastern Uzbekistan", "Tajikistan", "Kyrgyzstan", "Afghanistan-Tajikistan border region", "Hindu Kush region", "Tajikistan-Xinjiang border region", "Northwestern Kashmir", "Finland", "Norway-Murmansk border region", "Finland-Karelia border region", "Baltic States - Belarus - Northwestern Russia", "Northwestern Siberia", "Northern and central Siberia", "Victoria Land", "Ross Sea", "Antarctica", "Northern East Pacific Rise", "North of Honduras", "East of South Sandwich Islands", "Thailand", "Laos", "Cambodia", "Vietnam", "Gulf of Tongking", "Reykjanes Ridge", "Azores-Cape St. Vincent Ridge", "Owen Fracture Zone region", "Indian Ocean Triple Junction", "Western Indian-Antarctic Ridge", "Western Sahara", "Mauritania", "Mali", "Senegal - Gambia region", "Guinea region", "Sierra Leone", "Liberia region", "Cote d'Ivoire", "Burkina Faso", "Ghana", "Benin - Togo region", "Niger", "Nigeria", "Southeast of Easter Island", "Galapagos Triple Junction region"};
    }

    public static int read_FlinnEngdahl(String fname, FE fep) {
        int j;
        int nlat = 0;
        int n = 0;
        Scanner sc = null;
        try {
            sc = new Scanner(new File(fname));
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            Config.errorcode = 2;
            return 1;
        }
        String delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|\\p{javaWhitespace}+)+";
        sc.useDelimiter(delimiter);
        fep.nlat = nlat = sc.nextInt();
        fep.lon = new int[nlat][];
        fep.grn = new int[nlat][];
        fep.nl = new int[nlat];
        n = 0;
        int i = 0;
        while (i < nlat) {
            fep.nl[i] = sc.nextInt();
            n += fep.nl[i];
            ++i;
        }
        i = 0;
        while (i < nlat) {
            fep.lon[i] = new int[nlat * fep.nl[i]];
            fep.grn[i] = new int[nlat * fep.nl[i]];
            ++i;
        }
        i = 0;
        while (i < nlat) {
            n = sc.nextInt();
            j = 0;
            while (j < n) {
                fep.lon[i][j] = sc.nextInt();
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nlat) {
            n = sc.nextInt();
            j = 0;
            while (j < n) {
                fep.grn[i][j] = sc.nextInt();
                ++j;
            }
            ++i;
        }
        sc.close();
        return 0;
    }

    public static void free_fe(FE fep) {
        fep.nl = null;
        fep.lon = null;
        fep.grn = null;
        fep = null;
    }

    public static int gregnum(double lat, double lon, FE fep) {
        intW ilo = new intW(0);
        intW ihi = new intW(0);
        int ilat = (int)(90.0 - lat);
        int ilon = (int)Math.floor(lon);
        int n = fep.nl[ilat];
        if (n == 2) {
            return fep.grn[ilat][0];
        }
        Interpolate.ibracket(ilon, n, fep.lon[ilat], ilo, ihi);
        if (ilon < fep.lon[ilat][ihi.val]) {
            return fep.grn[ilat][ilo.val];
        }
        if (ilon == 180) {
            return fep.grn[ilat][ilo.val];
        }
        return fep.grn[ilat][ihi.val];
    }

    public static int gregtosreg(int grn) {
        intW ilo = new intW(0);
        intW ihi = new intW(0);
        if (grn < 1 || grn > 757) {
            return -1;
        }
        if (grn < 730) {
            Interpolate.ibracket(grn, 51, gstab, ilo, ihi);
            if (grn < gstab[ihi.val]) {
                return ilo.val;
            }
            return ihi.val;
        }
        if (grn == 730) {
            return 5;
        }
        if (grn == 731) {
            return 7;
        }
        if (grn == 732) {
            return 10;
        }
        if (grn > 732 && grn < 738) {
            return 25;
        }
        if (grn > 737 && grn < 740) {
            return 32;
        }
        if (grn > 739 && grn < 743) {
            return 33;
        }
        if (grn > 742 && grn < 756) {
            return 37;
        }
        if (grn == 756) {
            return 43;
        }
        if (grn == 757) {
            return 44;
        }
        return -1;
    }

    public static double get_default_depth(ISCSol sp, int ngrid, double gres, double[][] depthgrid, FE fep, double[] grn_depth, intW isdefdep) {
        double defdep = 0.0;
        int grn = 0;
        doubleW defdepW = new doubleW(0.0);
        int ret = GeoRegion.default_depth_from_grid(sp.lat, sp.lon, gres, ngrid, depthgrid, defdepW);
        defdep = defdepW.val;
        if (ret != 0) {
            sp.depfixtype = 5;
            isdefdep.val = 1;
            logger.info((Object)String.format("Fix depth by default depth grid: %.2f", defdep));
        } else if (sp.depth > 100.0) {
            sp.depfixtype = 6;
            defdep = sp.depth;
            isdefdep.val = 0;
            logger.info((Object)String.format("No default depth grid point exists, fix depth to median reported depth: %.2f", defdep));
        } else {
            sp.depfixtype = 7;
            grn = GeoRegion.gregnum(sp.lat, sp.lon, fep);
            defdep = grn_depth[grn - 1];
            logger.info((Object)String.format("No default depth grid point exists, fix depth by region: %.2f", defdep));
        }
        return defdep;
    }

    public static double[] read_default_depth_region(String fname) {
        double[] grn_depth = null;
        double depth = 0.0;
        int ngreg = 757;
        grn_depth = new double[757];
        Scanner sc = null;
        try {
            sc = new Scanner(new File(fname));
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            Config.errorcode = 2;
            return null;
        }
        String delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|\\p{javaWhitespace}+)+";
        sc.useDelimiter(delimiter);
        int i = 0;
        while (i < 757) {
            sc.nextInt();
            grn_depth[i] = depth = sc.nextDouble();
            ++i;
        }
        sc.close();
        return grn_depth;
    }

    public static double[][] read_default_depth_grid(String fname, doubleW gres, intW ngrid) {
        double[][] depthgrid = null;
        double lat = 0.0;
        double lon = 0.0;
        double depth = 0.0;
        double res = 1.0;
        double q25 = 0.0;
        double q75 = 0.0;
        double lo = 0.0;
        double hi = 0.0;
        double range = 0.0;
        int n = 0;
        int m = 0;
        int k = 0;
        Scanner sc = null;
        try {
            sc = new Scanner(new File(fname));
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e.getMessage());
            Config.errorcode = 2;
            return null;
        }
        String delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|\\p{javaWhitespace}+)+";
        sc.useDelimiter(delimiter);
        res = sc.nextDouble();
        n = sc.nextInt();
        depthgrid = new double[n][3];
        k = 0;
        int i = 0;
        while (i < n) {
            lat = sc.nextDouble();
            lon = sc.nextDouble();
            depth = sc.nextDouble();
            lo = sc.nextDouble();
            q25 = sc.nextDouble();
            q75 = sc.nextDouble();
            hi = sc.nextDouble();
            m = sc.nextInt();
            range = sc.nextDouble();
            if (!(range > 100.0)) {
                depthgrid[k][0] = lat;
                depthgrid[k][1] = lon;
                depthgrid[k][2] = depth;
                ++k;
            }
            ++i;
        }
        sc.close();
        ngrid.val = k;
        gres.val = res;
        return depthgrid;
    }

    private static int default_depth_from_grid(double lat, double lon, double gres, int ngrid, double[][] depthgrid, doubleW defdep) {
        int i = 0;
        while (i < ngrid) {
            if (!(Math.abs(lat - depthgrid[i][0]) > 0.5 * gres) && !(Math.abs(lon - depthgrid[i][1]) > 0.5 * gres)) {
                String s = String.format("%.0f", depthgrid[i][2]);
                defdep.val = Double.parseDouble(s);
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public static String gregion(int number) {
        String gregname = null;
        gregname = number < 1 || number > 757 ? "UNKNOWN GEOGRAPHIC REGION" : gregs[number - 1];
        return gregname;
    }

    public static String sregion(int number) {
        String sregname = null;
        sregname = number < 1 || number > 50 ? "UNKNOWN SEISMIC REGION" : sregs[number - 1];
        return sregname;
    }
}

