/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Node;
import cn.org.gddsn.seis.location.iscloc2.StaOrder;
import java.util.Arrays;

public class Cluster {
    public static int HierarchicalCluster(int nsta, double[][] distmatrix, StaOrder[] staorder) {
        int j;
        int i1 = 0;
        int i2 = 0;
        int counts1 = 0;
        int counts2 = 0;
        int nnodes = nsta - 1;
        int[] clusterids = null;
        int[] nodecounts = null;
        int[] order = null;
        Node[] node = null;
        node = Cluster.pslcluster(nsta, distmatrix);
        if (node == null) {
            return 1;
        }
        clusterids = new int[nsta];
        order = new int[nsta];
        nodecounts = new int[nnodes];
        int i = 0;
        while (i < nsta) {
            order[i] = i;
            clusterids[i] = i;
            ++i;
        }
        i = 0;
        while (i < nnodes) {
            i1 = node[i].left;
            i2 = node[i].right;
            if (i1 < 0) {
                j = -i1 - 1;
                counts1 = nodecounts[j];
                node[i].linkdist = Math.max(node[i].linkdist, node[j].linkdist);
            } else {
                counts1 = 1;
            }
            if (i2 < 0) {
                j = -i2 - 1;
                counts2 = nodecounts[j];
                node[i].linkdist = Math.max(node[i].linkdist, node[j].linkdist);
            } else {
                counts2 = 1;
            }
            nodecounts[i] = counts1 + counts2;
            ++i;
        }
        Cluster.TreeSort(nsta, order, nodecounts, node, staorder, clusterids);
        int k = nnodes - 1;
        while (k > -1) {
            i = node[k].left;
            j = node[k].right;
            if (i >= 0) {
                staorder[i].index = i;
            }
            if (j >= 0) {
                staorder[j].index = j;
            }
            --k;
        }
        Arrays.sort(staorder, 0, nsta);
        return 0;
    }

    private static Node[] pslcluster(int nsta, double[][] distmatrix) {
        int k;
        int j;
        int nnodes = nsta - 1;
        int[] vector = null;
        int[] index = null;
        double[] temp = null;
        double[] linkdist = null;
        Object[] node = null;
        temp = new double[nnodes];
        linkdist = new double[nsta];
        vector = new int[nnodes];
        index = new int[nsta];
        node = new Node[nnodes];
        int i = 0;
        while (i < nnodes) {
            vector[i] = i;
            ++i;
        }
        i = 0;
        while (i < nsta) {
            linkdist[i] = 9999999.0;
            j = 0;
            while (j < i) {
                temp[j] = distmatrix[i][j];
                ++j;
            }
            j = 0;
            while (j < i) {
                k = vector[j];
                if (linkdist[j] >= temp[j]) {
                    if (linkdist[j] < temp[k]) {
                        temp[k] = linkdist[j];
                    }
                    linkdist[j] = temp[j];
                    vector[j] = i;
                } else if (temp[j] < temp[k]) {
                    temp[k] = temp[j];
                }
                ++j;
            }
            j = 0;
            while (j < i) {
                if (linkdist[j] >= linkdist[vector[j]]) {
                    vector[j] = i;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nnodes) {
            node[i] = new Node();
            ((Node)node[i]).left = i;
            ((Node)node[i]).linkdist = linkdist[i];
            ++i;
        }
        Arrays.sort(node, 0, nnodes);
        i = 0;
        while (i < nsta) {
            index[i] = i;
            ++i;
        }
        i = 0;
        while (i < nnodes) {
            j = ((Node)node[i]).left;
            k = vector[j];
            ((Node)node[i]).left = index[j];
            ((Node)node[i]).right = index[k];
            index[k] = -i - 1;
            ++i;
        }
        return node;
    }

    private static void TreeSort(int nsta, int[] order, int[] nodecounts, Node[] node, StaOrder[] staorder, int[] clusterids) {
        int nnodes = nsta - 1;
        int i1 = 0;
        int i2 = 0;
        int j = 0;
        int count1 = 0;
        int count2 = 0;
        int clusterid = 0;
        int order1 = 0;
        int order2 = 0;
        int inc = 0;
        int i = 0;
        while (i < nnodes) {
            i1 = node[i].left;
            i2 = node[i].right;
            if (i1 < 0) {
                j = -i1 - 1;
                order1 = staorder[j].x;
                count1 = nodecounts[j];
            } else {
                order1 = order[i1];
                count1 = 1;
            }
            if (i2 < 0) {
                j = -i2 - 1;
                order2 = staorder[j].x;
                count2 = nodecounts[j];
            } else {
                order2 = order[i2];
                count2 = 1;
            }
            if (i1 < i2) {
                inc = order1 < order2 ? count1 : count2;
                j = 0;
                while (j < nsta) {
                    clusterid = clusterids[j];
                    if (clusterid == i1 && order1 >= order2) {
                        staorder[j].x += inc;
                    }
                    if (clusterid == i2 && order1 < order2) {
                        staorder[j].x += inc;
                    }
                    if (clusterid == i1 || clusterid == i2) {
                        clusterids[j] = -i - 1;
                    }
                    ++j;
                }
            } else {
                inc = order1 <= order2 ? count1 : count2;
                j = 0;
                while (j < nsta) {
                    clusterid = clusterids[j];
                    if (clusterid == i1 && order1 > order2) {
                        staorder[j].x += inc;
                    }
                    if (clusterid == i2 && order1 <= order2) {
                        staorder[j].x += inc;
                    }
                    if (clusterid == i1 || clusterid == i2) {
                        clusterids[j] = -i - 1;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

