/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc;

import cn.org.gddsn.seis.location.iscloc.Config;
import cn.org.gddsn.seis.location.iscloc.ISCPha;
import cn.org.gddsn.seis.location.iscloc.ISCSol;
import cn.org.gddsn.seis.location.iscloc.Utils;
import org.apache.log4j.Logger;

public class Weight {
    static Logger logger = Logger.getLogger(Weight.class);
    private static final int NUM_PHASE_WEIGHTS = 12;
    private static final PhaseWeight[] phase_weight = new PhaseWeight[]{new PhaseWeight("P", 0, 20, 1.0), new PhaseWeight("P", 20, 100, 1.0), new PhaseWeight("Pn", 0, 8, 1.0), new PhaseWeight("Pg", 0, 8, 1.0), new PhaseWeight("Pb", 0, 8, 1.0), new PhaseWeight("PKP", 110, 180, 0.0), new PhaseWeight("S", 0, 10, 1.0), new PhaseWeight("S", 10, 20, 1.0), new PhaseWeight("S", 20, 65, 0.5), new PhaseWeight("Sn", 0, 10, 1.0), new PhaseWeight("Sg", 0, 10, 1.0), new PhaseWeight("Sb", 0, 10, 1.0)};
    private static final double CUT_OFF = 0.8275;

    private Weight() {
    }

    public static int calc_weight(ISCSol sp, ISCPha[] p) {
        if (sp.iteration != 0) {
            sp.prev_alpha = sp.alpha;
        }
        if (sp.weighting_type.equals("huber") ? Weight.huber_weight(sp, p) > 0 : (sp.weighting_type.equals("buland") ? Weight.buland_weight(sp, p) > 0 : sp.weighting_type.equals("none") && Weight.no_weight(sp, p) > 0)) {
            return 1;
        }
        sp.prev_sigma = sp.sigma;
        sp.sigma = 0.0;
        double total_weight = 0.0;
        int i = 0;
        while (i < sp.numphas) {
            sp.sigma += p[i].resid * p[i].resid * p[i].weight;
            total_weight += p[i].weight;
            ++i;
        }
        sp.sigma = Math.sqrt(sp.sigma / total_weight);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("calc_weight: %s:  sigma=%f alpha=%f", sp.weighting_type, sp.sigma, sp.alpha));
            Utils.print_pha(sp.numphas, p);
        }
        return 0;
    }

    static int buland_weight(ISCSol sp, ISCPha[] p) {
        double spread;
        int i;
        int ndef;
        double sigma_12 = 12.0 * Config.sigma_start;
        double sigval = 1.0 / (2.0 * Config.sigma_start * Config.sigma_start);
        if (sp.iteration == 0) {
            sp.alpha = 0.0;
            ndef = 0;
            i = 0;
            while (i < sp.numphas) {
                if (p[i].weight_factor > 0.0 && Math.abs(p[i].resid) < Config.init_max_resid) {
                    sp.alpha += p[i].resid;
                    ++ndef;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("buland_weight: init:%s %s %f %f", p[i].sta, p[i].phase, p[i].weight_factor, p[i].resid));
                }
                ++i;
            }
            if (ndef < Config.min_phases) {
                logger.debug((Object)String.format("TOO FEW PHASES buland_weight init: ndef=%d", ndef));
                return 1;
            }
            sp.alpha /= (double)ndef;
            sp.prev_alpha = sp.alpha;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("buland_weight: init alpha=%f n=%d", sp.alpha, ndef));
            }
            i = 0;
            while (i < sp.numphas) {
                if (Math.abs(p[i].resid) < Config.max_resid) {
                    spread = Math.abs(p[i].resid - sp.alpha);
                    p[i].weight = spread <= sigma_12 ? 1.0 / (1.0 + Config.mu * Math.exp(spread * spread * sigval)) : 0.0;
                    p[i].weight *= p[i].weight_factor;
                } else {
                    p[i].weight = 0.0;
                }
                ++i;
            }
        }
        sp.alpha = 0.0;
        double total_weight = 0.0;
        ndef = 0;
        i = 0;
        while (i < sp.numphas) {
            if (p[i].weight_factor > 0.0 && Math.abs(p[i].resid) < Config.max_resid) {
                sp.alpha += p[i].resid * p[i].weight;
                total_weight += p[i].weight;
                ++ndef;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("buland_weight: %s %s %f %f %f", p[i].sta, p[i].phase, p[i].weight_factor, p[i].weight, p[i].resid));
            }
            ++i;
        }
        if (ndef < Config.min_phases) {
            logger.debug((Object)String.format("TOO FEW PHASES buland_weight: ndef=%d", ndef));
            return 1;
        }
        sp.alpha /= total_weight;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("buland_weight: alpha=%f total_weight=%f", sp.alpha, total_weight));
        }
        i = 0;
        while (i < sp.numphas) {
            if (Math.abs(p[i].resid) < Config.max_resid) {
                spread = Math.abs(p[i].resid - sp.alpha);
                p[i].weight = spread <= sigma_12 ? 1.0 / (1.0 + Config.mu * Math.exp(spread * spread * sigval)) : 0.0;
                p[i].weight *= p[i].weight_factor;
            } else {
                p[i].weight = 0.0;
            }
            ++i;
        }
        return 0;
    }

    public static int change_weighting(ISCSol sp) {
        if (sp.weighting_type.equals(Config.weighting1) && !Config.weighting2.equals("")) {
            sp.weighting_type = Config.weighting2;
            sp.converged = 0;
        }
        return 0;
    }

    public static int get_weight_factor(ISCPha[] p, int numphas) {
        int i = 0;
        while (i < numphas) {
            p[i].weight_factor = 0.0;
            if (p[i].purged <= 0 && p[i].time != 9999999.0) {
                int j = 0;
                while (j < 12) {
                    if (p[i].phase.equals(Weight.phase_weight[j].phase)) {
                        if (p[i].delta > (float)Weight.phase_weight[j].delta1 && p[i].delta <= (float)Weight.phase_weight[j].delta2) {
                            p[i].weight_factor = Weight.phase_weight[j].weight_factor;
                        } else if (!p[i].phase.equals(Weight.phase_weight[j + 1].phase)) break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("get_weight_factor done:", new Object[0]));
            Utils.print_pha(numphas, p);
        }
        return 0;
    }

    static int huber_weight(ISCSol sp, ISCPha[] p) {
        double spread;
        int i;
        int ndef;
        if (sp.iteration == 0) {
            sp.alpha = 0.0;
            ndef = 0;
            i = 0;
            while (i < sp.numphas) {
                if (p[i].weight_factor > 0.0 && Math.abs(p[i].resid) < Config.init_max_resid) {
                    sp.alpha += p[i].resid;
                    ++ndef;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("huber_weight: init: %s %s %f %f", p[i].sta, p[i].phase, p[i].weight_factor, p[i].resid));
                }
                ++i;
            }
            if (ndef < Config.min_phases) {
                logger.debug((Object)String.format("TOO FEW PHASES huber_weight init: ndef=%d", ndef));
                return 1;
            }
            sp.alpha /= (double)ndef;
            sp.prev_alpha = sp.alpha;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("huber_weight: init alpha=%f n=%d ", sp.alpha, ndef));
            }
            i = 0;
            while (i < sp.numphas) {
                if (Math.abs(p[i].resid) < Config.max_resid) {
                    spread = Math.abs(p[i].resid - sp.alpha);
                    p[i].weight = spread <= 0.8275 ? 1.0 : 0.8275 / spread;
                    p[i].weight *= p[i].weight_factor;
                } else {
                    p[i].weight = 0.0;
                }
                ++i;
            }
        }
        sp.alpha = 0.0;
        double total_weight = 0.0;
        ndef = 0;
        i = 0;
        while (i < sp.numphas) {
            if (p[i].weight_factor > 0.0 && Math.abs(p[i].resid) < Config.max_resid) {
                sp.alpha += p[i].resid * p[i].weight;
                total_weight += p[i].weight;
                ++ndef;
            }
            if (logger.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append(String.format("huber_weight: %s %s ", p[i].sta, p[i].phase));
                sb.append(String.format("%f %f ", p[i].weight_factor, p[i].weight));
                sb.append(String.format("%f", p[i].resid));
                logger.debug((Object)sb.substring(0));
            }
            ++i;
        }
        if (ndef < Config.min_phases) {
            logger.debug((Object)String.format("TOO FEW PHASES huber_weight: ndef=%d", ndef));
            return 1;
        }
        sp.alpha /= total_weight;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("huber_weight: alpha=%f ndef=%d total_weight=%f", sp.alpha, ndef, total_weight));
        }
        i = 0;
        while (i < sp.numphas) {
            if (Math.abs(p[i].resid) < Config.max_resid) {
                spread = Math.abs(p[i].resid - sp.alpha);
                p[i].weight = spread <= 0.8275 ? 1.0 : 0.8275 / spread;
                p[i].weight *= p[i].weight_factor;
            } else {
                p[i].weight = 0.0;
            }
            ++i;
        }
        return 0;
    }

    static int no_weight(ISCSol sp, ISCPha[] p) {
        sp.alpha = 0.0;
        double total_weight = 0.0;
        int ndef = 0;
        int i = 0;
        while (i < sp.numphas) {
            if (p[i].weight_factor > 0.0 && Math.abs(p[i].resid) < Config.max_resid) {
                p[i].weight = p[i].weight_factor;
                total_weight += p[i].weight;
                sp.alpha += p[i].resid * p[i].weight;
                ++ndef;
            } else {
                p[i].weight = 0.0;
            }
            ++i;
        }
        if (ndef < Config.min_phases) {
            logger.debug((Object)String.format("TOO FEW PHASES no_weight: ndef=%d", ndef));
            return 1;
        }
        sp.alpha /= total_weight;
        if (sp.iteration == 0) {
            sp.prev_alpha = sp.alpha;
        }
        return 0;
    }

    public static class PhaseWeight {
        public String phase;
        public int delta1;
        public int delta2;
        public double weight_factor;

        public PhaseWeight(String phase, int delta1, int delta2, double weight_factor) {
            this.phase = phase;
            this.delta1 = delta1;
            this.delta2 = delta2;
            this.weight_factor = weight_factor;
        }
    }
}

