/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc;

import cn.org.gddsn.seis.location.iscloc.ISCPha;
import cn.org.gddsn.seis.location.iscloc.ISCSol;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class Utils {
    static Logger logger = Logger.getLogger(Utils.class);

    private Utils() {
    }

    public static String print_sol(ISCSol sp) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.format("%s ", Utils.write_time(sp.time)));
        if (sp.error[2] != 9999999.0) {
            sb.append(String.format("%6.3f+%6.3f ", sp.lat, sp.error[2]));
        } else {
            sb.append(String.format("%6.3f+%6s ", sp.lat, ""));
        }
        if (sp.error[3] != 9999999.0) {
            sb.append(String.format("%6.3f+%6.3f ", sp.lon, sp.error[3]));
        } else {
            sb.append(String.format("%6.3f+%6s ", sp.lon, ""));
        }
        if (sp.error[4] != 9999999.0) {
            sb.append(String.format("%.0f+%4.1f ", sp.depth, sp.error[4]));
        } else {
            sb.append(String.format("%.0f+%4s ", sp.depth, ""));
        }
        if (sp.sdobs != 9999999.0) {
            sb.append(String.format("sd=%3.1f", sp.sdobs));
        } else {
            sb.append(String.format("sd=%3s", ""));
        }
        return sb.substring(0);
    }

    public static void print_pha(int numphas, ISCPha[] p) {
        logger.info((Object)String.format("RDID      NET   STA     REP   ISC   TIME                      DELTA FACT  WT       RESID       AMP  PER  MAG", new Object[0]));
        int ndef = 0;
        int i = 0;
        while (i < numphas) {
            StringBuffer sb = new StringBuffer();
            sb.append(String.format("%-9d ", p[i].rdid));
            if (!p[i].net.equals("")) {
                sb.append(String.format("%-5s ", p[i].net));
            } else {
                sb.append(String.format("%5s ", ""));
            }
            sb.append(String.format("%-5s ", p[i].sta));
            if (p[i].comp > '\u0000') {
                sb.append(String.format("%c ", Character.valueOf(p[i].comp)));
            } else {
                sb.append(String.format("  ", new Object[0]));
            }
            sb.append(String.format("%-5s ", p[i].rep_phase));
            sb.append(String.format("%-5s ", p[i].phase));
            sb.append(String.format("%23s ", Utils.write_time(p[i].time)));
            sb.append(String.format("%7.3f ", Float.valueOf(p[i].delta)));
            if (p[i].purged > 0) {
                sb.append(String.format("PURGE ", new Object[0]));
            } else if (p[i].duplicate == 1) {
                sb.append(String.format("DUPLI ", new Object[0]));
            } else {
                sb.append(String.format("%5.3f ", p[i].weight_factor));
            }
            sb.append(String.format("%6.4f ", p[i].weight));
            if (p[i].resid != 9999999.0) {
                sb.append(String.format("%+8.4f ", p[i].resid));
            } else {
                sb.append(String.format("%8s ", ""));
            }
            if (p[i].numamps > 0) {
                if (p[i].a[0].amp != 9999999.0) {
                    sb.append(String.format("%8.1f ", p[i].a[0].amp));
                } else {
                    sb.append(String.format("%8s ", ""));
                }
                if (p[i].a[0].per != 9999999.0) {
                    sb.append(String.format("%4.1f ", p[i].a[0].per));
                } else {
                    sb.append(String.format("%4s ", ""));
                }
            } else {
                sb.append(String.format("%8s %4s ", "", ""));
            }
            if (p[i].bodymag > 0.0) {
                sb.append(String.format("%4.2fb ", p[i].bodymag));
            }
            if (p[i].surfmag > 0.0) {
                sb.append(String.format("%4.2fS ", p[i].surfmag));
            }
            logger.info((Object)sb.substring(0));
            if (p[i].weight > 0.0) {
                ++ndef;
            }
            ++i;
        }
        logger.info((Object)String.format("ndef=%d", ndef));
    }

    public static double calc_delta(double[] sta_dircos, double[] h_dircos) {
        double sq3;
        double sq2;
        double sq1;
        double dotprod = sta_dircos[1] * h_dircos[1];
        dotprod += sta_dircos[2] * h_dircos[2];
        if ((dotprod += sta_dircos[3] * h_dircos[3]) < -0.9994) {
            double sq12 = sta_dircos[1] + h_dircos[1];
            double sq22 = sta_dircos[2] + h_dircos[2];
            double sq32 = sta_dircos[3] + h_dircos[3];
            dotprod = 0.5 * (sq12 * sq12 + sq22 * sq22 + sq32 * sq32) - 1.0;
            if (dotprod < -1.0) {
                dotprod = -1.0;
            }
        } else if (dotprod > 0.9994 && (dotprod = 1.0 - 0.5 * ((sq1 = sta_dircos[1] - h_dircos[1]) * sq1 + (sq2 = sta_dircos[2] - h_dircos[2]) * sq2 + (sq3 = sta_dircos[3] - h_dircos[3]) * sq3)) > 1.0) {
            dotprod = 1.0;
        }
        return Math.acos(dotprod) / (Math.PI / 180);
    }

    public static double calc_esaz(double[] sta_dircos, double[] h_dircos, double sta_lon, double h_lon, double delta) {
        double da = (sta_dircos[1] - h_dircos[4]) * (sta_dircos[1] - h_dircos[4]);
        da += (sta_dircos[2] - h_dircos[5]) * (sta_dircos[2] - h_dircos[5]);
        da += (sta_dircos[3] - h_dircos[6]) * (sta_dircos[3] - h_dircos[6]);
        da -= 2.0;
        if ((da /= 2.0 * Math.sin(Math.PI / 180 * delta)) > 1.0) {
            da = 1.0;
        }
        if (da < -1.0) {
            da = -1.0;
        }
        double azim = Math.acos(da);
        double dellon = sta_lon - h_lon;
        if (dellon > 180.0 || dellon > -180.0 && dellon < 0.0) {
            azim = Math.PI * 2 - azim;
        }
        if ((azim /= Math.PI / 180) >= 360.0) {
            azim -= 360.0;
        }
        return azim;
    }

    public static void calc_dircos(double lat, double lon, double[] dircos) {
        double glat = Math.atan(0.99327733 * Math.tan(lat *= Math.PI / 180));
        double coslat = Math.cos(glat);
        double sinlat = Math.sin(glat);
        double coslon = Math.cos(lon *= Math.PI / 180);
        double sinlon = Math.sin(lon);
        dircos[1] = coslat * coslon;
        dircos[2] = coslat * sinlon;
        dircos[3] = sinlat;
        dircos[4] = sinlat * coslon;
        dircos[5] = sinlat * sinlon;
        dircos[6] = -coslat;
    }

    public static void dsort(double[] a, int left, int right) {
        if (left >= right) {
            return;
        }
        Utils.dswap(a, left, (left + right) / 2);
        int last = left;
        int i = left + 1;
        while (i <= right) {
            if (a[i] < a[left]) {
                Utils.dswap(a, ++last, i);
            }
            ++i;
        }
        Utils.dswap(a, left, last);
        Utils.dsort(a, left, last);
        Utils.dsort(a, last + 1, right);
    }

    public static void dswap(double[] a, int i, int j) {
        double temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }

    public static double read_time(String timestr) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss.SSS");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date d = new Date(0L);
        try {
            d = sdf.parse(timestr);
        }
        catch (ParseException e) {
            return 0.0;
        }
        return (double)d.getTime() / 1000.0;
    }

    public static String write_time(double time) {
        Date d = new Date((long)(time * 1000.0));
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss.SSS");
        return sdf.format(d);
    }

    public static String out_pha(int numphas, ISCPha[] p, ISCSol sp) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.format("\n NET   STA    REP   ISC    TIME                    DELTA(deg) FACT      WT     RESID       AMP  PER  MAG", new Object[0]));
        int i = 0;
        while (i < numphas) {
            sb.append("\n");
            if (!p[i].net.equals("")) {
                sb.append(String.format("%-5s ", p[i].net));
            } else {
                sb.append(String.format("%5s ", ""));
            }
            sb.append(String.format("%-5s ", p[i].sta));
            if (p[i].comp > '\u0000') {
                sb.append(String.format("%c ", Character.valueOf(p[i].comp)));
            } else {
                sb.append(String.format("  ", new Object[0]));
            }
            sb.append(String.format("%-5s ", p[i].rep_phase));
            sb.append(String.format("%-5s ", p[i].phase));
            sb.append(String.format("%23s ", Utils.write_time(p[i].time)));
            sb.append(String.format("%8.3f ", Float.valueOf(p[i].delta)));
            if (p[i].purged > 0) {
                sb.append(String.format("PURGE ", new Object[0]));
            } else if (p[i].duplicate == 1) {
                sb.append(String.format("DUPLI ", new Object[0]));
            } else {
                sb.append(String.format("%8.4f ", p[i].weight_factor));
            }
            sb.append(String.format("%8.4f ", p[i].weight));
            if (p[i].resid != 9999999.0) {
                sb.append(String.format("%+8.4f ", p[i].resid));
            } else {
                sb.append(String.format("%8s ", ""));
            }
            if (p[i].numamps > 0) {
                if (p[i].a[0].amp != 9999999.0) {
                    sb.append(String.format("%8.1f ", p[i].a[0].amp));
                } else {
                    sb.append(String.format("%8s ", ""));
                }
                if (p[i].a[0].per != 9999999.0) {
                    sb.append(String.format("%4.1f ", p[i].a[0].per));
                } else {
                    sb.append(String.format("%4s ", ""));
                }
            } else {
                sb.append(String.format("%8s %4s ", "", ""));
            }
            if (p[i].bodymag > 0.0) {
                sb.append(String.format("%4.2fb ", p[i].bodymag));
            }
            if (p[i].surfmag > 0.0) {
                sb.append(String.format("%4.2fS ", p[i].surfmag));
            }
            ++i;
        }
        sb.append("\n");
        return String.valueOf(sb.substring(0)) + "\n Final result: " + Utils.print_sol(sp);
    }

    static void handle_error() {
    }
}

