/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc;

import cn.org.gddsn.seis.location.iscloc.Correction;
import cn.org.gddsn.seis.location.iscloc.ISCPha;
import cn.org.gddsn.seis.location.iscloc.ISCSol;
import cn.org.gddsn.seis.location.iscloc.jbtab.Tab;
import cn.org.gddsn.seis.location.iscloc.jbtab.TabSurfDepth;
import org.apache.log4j.Logger;
import org.netlib.util.doubleW;

public class ModelJB {
    static Logger logger = Logger.getLogger(ModelJB.class);
    public static final double PGVEL = 5.57;
    public static final double SGVEL = 3.34;
    public static final double PBVEL = 6.5;
    public static final double SBVEL = 3.83;
    public static final double PNVEL = 7.88;
    public static final double SNVEL = 4.38;
    public static final double PGSLOW = 19.95;
    public static final double SGSLOW = 33.3;
    public static final double PBSLOW = 17.1;
    public static final double SBSLOW = 29.0;
    public static final double UPPER_RHO = 2.65;
    public static final double LOWER_RHO = 2.87;
    public static final double BELOW_RHO = 3.32;
    public static final double MOHO = 33.0;
    public static final double MOHO_RADIUS = 6338.0;
    public static final double CONRAD = 15.0;
    public static final double SURFACE = -0.005207;
    public static final double MAX_DEPTH = 0.12;
    public static final double SHORT_DELTA = 1.3;
    public static final double SHORT_DEPTH = 134.408;
    public static final double CRUSTAL_P_DELTA = 8.0;
    public static final double CRUSTAL_S_DELTA = 10.0;
    public static final double PKP_MIN_DELTA = 106.0;
    public static final double S_MAX_DELTA = 105.0;
    public static final double SKS_MIN_DELTA = 62.0;
    public static final int PDIFF_MIN_DELTA = 102;
    public static final double PDIFF_SEC_PER_DEG = 4.4;
    public static final double pP_LOW_DELTA = 25.0;
    public static final double pP_HIGH_DELTA = 100.0;
    public static final int MAXROW = 230;
    public static final int MAXCOL = 30;
    public static final TTTab p_tab = Tab.p_tab;
    public static final TTTab p_short = Tab.p_short;
    public static final TTTab pkp_tab = Tab.pkp_tab;
    public static final TTTab s_tab = Tab.s_tab;
    public static final TTTab s_short = Tab.s_short;
    public static final TTTab sks_tab = Tab.sks_tab;
    public static final TTTab pP_P_tab = Tab.pP_P_tab;
    public static final DepthAllowTTTab pcp_dep_allow_tab = TabSurfDepth.pcp_dep_allow_tab;
    public static final SurfTTTab pcp_surf_tab = TabSurfDepth.pcp_surf_tab;
    public static final DepthAllowTTTab scs_dep_allow_tab = TabSurfDepth.scs_dep_allow_tab;
    public static final SurfTTTab scs_surf_tab = TabSurfDepth.scs_surf_tab;
    public static final DepthAllowTTTab pp_dep_allow_tab = TabSurfDepth.pp_dep_allow_tab;
    public static final SurfTTTab pp_surf_tab = TabSurfDepth.pp_surf_tab;
    public static final DepthAllowTTTab ppp_dep_allow_tab = TabSurfDepth.ppp_dep_allow_tab;
    public static final SurfTTTab ppp_surf_tab = TabSurfDepth.ppp_surf_tab;
    public static final DepthAllowTTTab ps_dep_allow_tab = TabSurfDepth.ps_dep_allow_tab;
    public static final SurfTTTab ps_surf_tab = TabSurfDepth.ps_surf_tab;
    public static final DepthAllowTTTab sp_dep_allow_tab = TabSurfDepth.sp_dep_allow_tab;
    public static final SurfTTTab sp_surf_tab = TabSurfDepth.sp_surf_tab;
    public static final DepthAllowTTTab pps_psp_dep_allow_tab = TabSurfDepth.pps_psp_dep_allow_tab;
    public static final SurfTTTab pps_psp_surf_tab = TabSurfDepth.pps_psp_surf_tab;
    public static final DepthAllowTTTab spp_dep_allow_tab = TabSurfDepth.spp_dep_allow_tab;
    public static final SurfTTTab spp_surf_tab = TabSurfDepth.spp_surf_tab;
    public static final DepthAllowTTTab ss_dep_allow_tab = TabSurfDepth.ss_dep_allow_tab;
    public static final SurfTTTab ss_surf_tab = TabSurfDepth.ss_surf_tab;
    public static final DepthAllowTTTab ssp_sps_dep_allow_tab = TabSurfDepth.ssp_sps_dep_allow_tab;
    public static final SurfTTTab ssp_sps_surf_tab = TabSurfDepth.ssp_sps_surf_tab;
    public static final DepthAllowTTTab pss_dep_allow_tab = TabSurfDepth.pss_dep_allow_tab;
    public static final SurfTTTab pss_surf_tab = TabSurfDepth.pss_surf_tab;
    public static final DepthAllowTTTab sss_dep_allow_tab = TabSurfDepth.sss_dep_allow_tab;
    public static final SurfTTTab sss_surf_tab = TabSurfDepth.sss_surf_tab;
    public static final double max_depth = 764.52;
    private static final int NUM_MAX_RESID = 3;
    private static final pP_max_reisd_rec[] pP_max_reisd = new pP_max_reisd_rec[]{new pP_max_reisd_rec(0.0, 2.0), new pP_max_reisd_rec(33.0, 3.0), new pP_max_reisd_rec(44.0, 5.0)};

    public static int read_ttime(ISCSol sp, ISCPha pp) {
        int status = ModelJB.read_jb(sp.depth, pp);
        if (status > 0) {
            return status;
        }
        if (Correction.correct_ttime(sp, pp) > 0) {
            return 1;
        }
        return 0;
    }

    public static int read_pP_P(double depth, ISCPha pp) {
        doubleW a = new doubleW(pp.pP_P_time);
        doubleW b = new doubleW(pp.pP_dtdh);
        if (ModelJB.jb_pP_P(pp.delta, depth, a, b) > 0) {
            return 1;
        }
        pp.pP_P_time = a.val;
        pp.pP_dtdh = b.val;
        return 0;
    }

    static int fill_matrix(TTTab tp, int col1, int row1, int depth_dir, int delta_dir, int[][] matrix) {
        int numval = 0;
        int i = 0;
        while (i < 3) {
            int row = row1 + i * delta_dir;
            int j = 0;
            while (j < 3) {
                int col = col1 + j * depth_dir;
                matrix[j][i] = col > 13 ? (int)((double)col * tp.tab[13][row] - tp.tab[12][row]) : (int)tp.tab[col][row];
                if (matrix[j][i] != 0) {
                    ++numval;
                }
                ++j;
            }
            ++i;
        }
        return numval;
    }

    public static int read_jb(double depth, ISCPha pp) {
        doubleW ttime = new doubleW(0.0);
        doubleW dtdd = new doubleW(0.0);
        doubleW dtdh = new doubleW(0.0);
        int status = 0;
        if (pp.phase.equals("Pg")) {
            status = ModelJB.ps_g('P', pp.delta, depth, ttime, dtdh, dtdd);
        } else if (pp.phase.equals("Pb")) {
            status = ModelJB.ps_star('P', pp.delta, depth, ttime, dtdh, dtdd);
        } else if (pp.phase.equals("Pn")) {
            status = ModelJB.ps_crust('P', pp.delta, depth, ttime, dtdh, dtdd);
        } else if (pp.phase.equals("Sg")) {
            status = ModelJB.ps_g('S', pp.delta, depth, ttime, dtdh, dtdd);
        } else if (pp.phase.equals("Sb")) {
            status = ModelJB.ps_star('S', pp.delta, depth, ttime, dtdh, dtdd);
        } else if (pp.phase.equals("Sn")) {
            status = ModelJB.ps_crust('S', pp.delta, depth, ttime, dtdh, dtdd);
        } else if (pp.phase.equals("P")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("read_jb: P delta=%f depth=%f", Float.valueOf(pp.delta), depth));
            }
            status = (double)pp.delta < 1.3 && depth < 134.408 ? ModelJB.ps_short(p_short, pp.delta, depth, ttime, dtdh, dtdd) : (depth < 33.0 ? ModelJB.ps_crust('P', pp.delta, depth, ttime, dtdh, dtdd) : ModelJB.ps(p_tab, pp.delta, depth, ttime, dtdh, dtdd));
        } else if (pp.phase.equals("PKP")) {
            status = ModelJB.ps(pkp_tab, pp.delta, depth, ttime, dtdh, dtdd);
        } else if (pp.phase.equals("Pdiff")) {
            status = ModelJB.pdiff(p_tab, pp.delta, depth, ttime);
            dtdh.val = 9999999.0;
            dtdd.val = 9999999.0;
        } else if (pp.phase.equals("S")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("read_jb: S delta=%f depth=%f", Float.valueOf(pp.delta), depth));
            }
            status = (double)pp.delta < 1.3 && depth < 134.408 ? ModelJB.ps_short(s_short, pp.delta, depth, ttime, dtdh, dtdd) : (depth < 33.0 ? ModelJB.ps_crust('S', pp.delta, depth, ttime, dtdh, dtdd) : ModelJB.ps(s_tab, pp.delta, depth, ttime, dtdh, dtdd));
        } else if (pp.phase.equals("SKS")) {
            status = ModelJB.ps(sks_tab, pp.delta, depth, ttime, dtdh, dtdd);
        } else if (pp.phase.equals("PcP")) {
            status = ModelJB.other_phase(pcp_surf_tab, pp.delta, depth, ttime);
            dtdh.val = 9999999.0;
            dtdd.val = 9999999.0;
        } else if (pp.phase.equals("ScS")) {
            status = ModelJB.other_phase(scs_surf_tab, pp.delta, depth, ttime);
            dtdh.val = 9999999.0;
            dtdd.val = 9999999.0;
        } else if (pp.phase.equals("PP")) {
            status = ModelJB.other_phase(pp_surf_tab, pp.delta, depth, ttime);
            dtdh.val = 9999999.0;
            dtdd.val = 9999999.0;
        } else if (pp.phase.equals("PPP")) {
            status = ModelJB.other_phase(ppp_surf_tab, pp.delta, depth, ttime);
            dtdh.val = 9999999.0;
            dtdd.val = 9999999.0;
        } else if (pp.phase.equals("PS")) {
            status = ModelJB.other_phase(ps_surf_tab, pp.delta, depth, ttime);
            dtdh.val = 9999999.0;
            dtdd.val = 9999999.0;
        } else if (pp.phase.equals("SP")) {
            status = ModelJB.other_phase(sp_surf_tab, pp.delta, depth, ttime);
            dtdh.val = 9999999.0;
            dtdd.val = 9999999.0;
        } else if (pp.phase.equals("SPP")) {
            status = ModelJB.other_phase(spp_surf_tab, pp.delta, depth, ttime);
            dtdh.val = 9999999.0;
            dtdd.val = 9999999.0;
        } else if (pp.phase.equals("PSP") || pp.phase.equals("PPS")) {
            status = ModelJB.other_phase(pps_psp_surf_tab, pp.delta, depth, ttime);
            dtdh.val = 9999999.0;
            dtdd.val = 9999999.0;
        } else if (pp.phase.equals("SS")) {
            status = ModelJB.other_phase(ss_surf_tab, pp.delta, depth, ttime);
            dtdh.val = 9999999.0;
            dtdd.val = 9999999.0;
        } else if (pp.phase.equals("PSS")) {
            status = ModelJB.other_phase(pss_surf_tab, pp.delta, depth, ttime);
            dtdh.val = 9999999.0;
            dtdd.val = 9999999.0;
        } else if (pp.phase.equals("SSP") || pp.phase.equals("SPS")) {
            status = ModelJB.other_phase(ssp_sps_surf_tab, pp.delta, depth, ttime);
            dtdh.val = 9999999.0;
            dtdd.val = 9999999.0;
        } else if (pp.phase.equals("SSS")) {
            status = ModelJB.other_phase(sss_surf_tab, pp.delta, depth, ttime);
            dtdh.val = 9999999.0;
            dtdd.val = 9999999.0;
        } else {
            logger.warn((Object)String.format("%d: bad code: %s", pp.phid, pp.phase));
            return 1;
        }
        if (status > 0) {
            return status;
        }
        pp.ttime = ttime.val;
        pp.dtdh = dtdh.val;
        pp.dtdd = dtdd.val;
        return 0;
    }

    public static int ps(TTTab tp, double delta, double depth, doubleW ttime, doubleW dtdh, doubleW dtdd) {
        int delta_dir;
        int[][] matrix = new int[3][3];
        double[] t = new double[3];
        double[] d = new double[3];
        double depth_erad = (depth - 33.0) / 6338.0;
        if (depth_erad < tp.min_depth || depth_erad > tp.max_depth) {
            logger.warn((Object)String.format("ps: depth out of range: %f", depth));
            return 1;
        }
        int col1 = (int)(depth_erad * 100.0 + 1.0);
        double depth_frac = depth_erad * 100.0 - (double)((int)(depth_erad * 100.0));
        if (delta < tp.min_delta || delta > tp.max_delta) {
            logger.warn((Object)String.format("ps: delta out of range: %f", delta));
            return 1;
        }
        int row1 = (int)(delta - tp.min_delta);
        double delta_frac = delta - (double)((int)delta);
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(String.format("ps: depth=%f col1=%d ", depth_erad, col1));
            sb.append(String.format("depth_frac=%f", depth_frac));
            sb.append(String.format("ps: delta=%f row1=%d ", delta, row1));
            sb.append(String.format("delta_frac=%f", delta_frac));
            logger.debug((Object)sb.substring(0));
        }
        if (delta > tp.switch_dir_delta) {
            delta_dir = -1;
            ++row1;
            delta_frac = 1.0 - delta_frac;
        } else {
            delta_dir = 1;
        }
        int depth_dir = 1;
        int numval = ModelJB.fill_matrix(tp, col1, row1, depth_dir, delta_dir, matrix);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("ps: %d %d %d", matrix[0][0], matrix[1][0], matrix[2][0]));
            logger.debug((Object)String.format("    %d %d %d", matrix[0][1], matrix[1][1], matrix[2][1]));
            logger.debug((Object)String.format("    %d %d %d", matrix[0][2], matrix[1][2], matrix[2][2]));
        }
        if (numval == 8 && matrix[2][0] == 0) {
            if (col1 == 1) {
                matrix[2][0] = 2 * (matrix[1][0] + matrix[2][1] + matrix[1][1]);
                int[] nArray = matrix[2];
                nArray[0] = nArray[0] - (matrix[0][0] + matrix[2][2] + matrix[0][2]);
                int[] nArray2 = matrix[2];
                nArray2[0] = nArray2[0] / 3;
                numval = 9;
            } else {
                depth_dir = -1;
                depth_frac = 1.0 - depth_frac;
                numval = ModelJB.fill_matrix(tp, col1 += 2, row1, depth_dir, delta_dir, matrix);
            }
        } else if (numval == 7 && matrix[1][0] == 0 && matrix[2][0] == 0 && (delta_dir == 1 && depth_frac + delta_frac < 1.0 || delta_dir == -1 && depth_frac < delta_frac)) {
            matrix[1][0] = 2 * matrix[1][1] - matrix[1][2];
            matrix[2][0] = 2 * matrix[2][1] - matrix[2][2];
            numval = 9;
        }
        if (numval == 9) {
            int i = 0;
            while (i < 3) {
                t[i] = ModelJB.interpol(depth_frac, matrix[0][i], matrix[1][i], matrix[2][i]);
                d[i] = ModelJB.int_diff(depth_frac, matrix[0][i], matrix[1][i], matrix[2][i]);
                ++i;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("ps: t=%f %f %f", t[0], t[1], t[2]));
                logger.debug((Object)String.format("ps: d=%f %f %f", d[0], d[1], d[2]));
            }
        } else {
            logger.warn((Object)String.format("del=%f,dep=%f,numval=%d", delta, depth_erad, numval));
            return 2;
        }
        ttime.val = 0.1 * ModelJB.interpol(delta_frac, t[0], t[1], t[2]);
        dtdd.val = (double)delta_dir * 0.1 * ModelJB.int_diff(delta_frac, t[0], t[1], t[2]);
        dtdh.val = (double)(depth_dir * 10) * ModelJB.interpol(delta_frac, d[0], d[1], d[2]) / 6338.0;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("ps: ttime=%f dtdd=%f dtdh%f", ttime.val, dtdd.val, dtdh.val));
        }
        return 0;
    }

    public static int ps_crust(char ps, double delta, double depth, doubleW ttime, doubleW dtdh, doubleW dtdd) {
        int delta_dir;
        TTTab tp;
        double b_slow;
        double g_slow;
        double[] times = new double[3];
        if (ps == 'P') {
            g_slow = 19.95;
            b_slow = 17.1;
            tp = p_tab;
        } else if (ps == 'S') {
            g_slow = 33.3;
            b_slow = 29.0;
            tp = s_tab;
        } else {
            logger.warn((Object)String.format("ps_crust: wrong ps value %c", Character.valueOf(ps)));
            return 1;
        }
        if (depth < 0.0 || depth > 33.0) {
            logger.warn((Object)String.format("ps_crust: depth out of range: %f", depth));
            return 1;
        }
        if (delta < tp.min_delta || delta > tp.max_delta) {
            logger.warn((Object)String.format("ps_crust: delta out of range: %f", delta));
            return 1;
        }
        int row1 = (int)(delta - tp.min_delta);
        double delta_frac = delta - (double)((int)delta);
        if (delta > tp.switch_dir_delta) {
            delta_dir = -1;
            ++row1;
            delta_frac = 1.0 - delta_frac;
        } else {
            delta_dir = 1;
        }
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(String.format("ps_crust: delta=%f row1=%d ", delta, row1));
            sb.append(String.format("delta_frac=%f delta_dir=%d", delta_frac, delta_dir));
            logger.debug((Object)sb.substring(0));
        }
        int i = 0;
        while (i < 3) {
            int row = row1 + i * delta_dir;
            if (tp.tab[0][row] == 0.0) {
                logger.warn((Object)String.format("no value: del=%d, dep=%f", row1, depth));
                return 1;
            }
            times[i] = tp.tab[0][row];
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("ps_crust: t[0]=%d t[1]=%d t[2]=%d", times[0], times[1], times[2]));
        }
        ttime.val = 0.1 * ModelJB.interpol(delta_frac, times[0], times[1], times[2]);
        dtdd.val = 0.1 * ModelJB.int_diff(delta_frac, times[0], times[1], times[2]) * (double)delta_dir;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("ps_crust: surface ttime=%f dtdd=%f", ttime.val, dtdd.val));
        }
        double hfn = (6371.0 - depth) * (Math.PI / 180);
        double ray = Math.sqrt((g_slow - dtdd.val) * (g_slow + dtdd.val));
        if (depth <= 15.0) {
            ttime.val -= ray * depth / hfn;
        } else {
            ttime.val -= ray * 15.0 / hfn;
            ray = Math.sqrt((b_slow - dtdd.val) * (b_slow + dtdd.val));
            ttime.val -= ray * (depth - 15.0) / hfn;
        }
        dtdh.val = -0.57 * ray * 100.0 / 6338.0;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("ps_crust: ttime=%f dtdh=%f", ttime.val, dtdh.val));
        }
        return 0;
    }

    public static int ps_short(TTTab tp, double delta, double depth, doubleW ttime, doubleW dtdh, doubleW dtdd) {
        double[] times = new double[3];
        double[] t = new double[3];
        double[] d = new double[3];
        double depth_erad = (depth - 33.0) / 6338.0;
        if (depth_erad < tp.min_depth || depth_erad > tp.max_depth) {
            logger.warn((Object)String.format("ps_short:depth out of range: %f", depth));
            return 1;
        }
        int col1 = (int)(depth_erad * 500.0);
        double depth_frac = depth_erad * 500.0 - (double)col1;
        if (delta < tp.min_delta || delta > tp.max_delta) {
            logger.warn((Object)String.format("ps_short:delta out of range: %f", delta));
            return 1;
        }
        int row1 = (int)(delta * 10.0);
        double delta_frac = delta * 10.0 - (double)row1;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("ps_short: depth=%f col1=%d depth_frac=%f", depth_erad, col1, depth_frac));
            logger.debug((Object)String.format("ps_short: delta=%f row1=%d delta_frac=%f", delta, row1, delta_frac));
        }
        int i = 0;
        while (i < 3) {
            int row = row1 + i;
            int j = 0;
            while (j < 3) {
                int col = col1 + j;
                times[j] = tp.tab[col][row];
                ++j;
            }
            t[i] = ModelJB.interpol(depth_frac, times[0], times[1], times[2]);
            d[i] = ModelJB.int_diff(depth_frac, times[0], times[1], times[2]);
            ++i;
        }
        ttime.val = 0.1 * ModelJB.interpol(delta_frac, t[0], t[1], t[2]);
        dtdd.val = ModelJB.int_diff(delta_frac, t[0], t[1], t[2]);
        dtdh.val = 50.0 * ModelJB.interpol(delta_frac, d[0], d[1], d[2]) / 6338.0;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("ps_short: tt=%f dtdd=%f dtdh=%f", ttime.val, dtdd.val, dtdh.val));
        }
        return 0;
    }

    public static int ps_g(char ps, double delta, double depth, doubleW ttime, doubleW dtdh, doubleW dtdd) {
        double g_vel;
        double g_slow;
        if (ps == 'P') {
            g_slow = 19.95;
            g_vel = 5.57;
        } else if (ps == 'S') {
            g_slow = 33.3;
            g_vel = 3.34;
        } else {
            logger.warn((Object)String.format("ps_g: wrong ps value %c", Character.valueOf(ps)));
            return 1;
        }
        double distance = delta * 111.195;
        if (depth < 0.0 || depth > 15.0) {
            logger.warn((Object)String.format("ps_g: depth out of range: %f", depth));
            return 1;
        }
        double g_ray = Math.sqrt(distance * distance + depth * depth);
        ttime.val = g_ray / g_vel;
        if (ttime.val == 0.0) {
            dtdd.val = g_slow;
            dtdh.val = 0.0;
        } else {
            dtdd.val = g_slow * g_slow * delta / ttime.val;
            dtdh.val = depth / (ttime.val * g_vel * g_vel);
        }
        return 0;
    }

    public static int ps_star(char ps, double delta, double depth, doubleW ttime, doubleW dtdh, doubleW dtdd) {
        double sin_inc;
        double b_vel;
        double g_vel;
        if (ps == 'P') {
            g_vel = 5.57;
            b_vel = 6.5;
        } else if (ps == 'S') {
            g_vel = 3.34;
            b_vel = 3.83;
        } else {
            logger.warn((Object)String.format("ps_star: wrong ps value %c", Character.valueOf(ps)));
            return 1;
        }
        double distance = delta * 111.195;
        if (depth < 0.0 || depth > 33.0) {
            logger.warn((Object)String.format("ps_star: depth out of range: %f", depth));
            return 1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("ps_star: distance=%f,depth=%f", distance, depth));
        }
        if (depth < 15.0) {
            double above_conrad = 15.0 - depth;
            double critical = Math.asin(g_vel / b_vel);
            ttime.val = (above_conrad + 15.0) / (g_vel * Math.cos(critical));
            ttime.val += (distance - (above_conrad + 15.0) * Math.tan(critical)) / b_vel;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("ps_star: depth=%f,tt=%f", depth, ttime.val));
            }
            dtdh.val = -Math.cos(critical) / g_vel;
            dtdd.val = 111.195 / b_vel;
            return 0;
        }
        double below_conrad = depth - 15.0;
        if (distance < 0.01) {
            ttime.val = below_conrad / b_vel;
            dtdh.val = b_vel;
            dtdd.val = 0.0;
            return 0;
        }
        double conrad_radius = 6356.0;
        double source_radius = 6371.0 - depth;
        double frac1 = conrad_radius / 6371.0;
        double frac2 = source_radius / 6371.0;
        double prev_crossing = 0.0;
        double prev_time = 1000000.0;
        double incr = distance / 2.0;
        while (true) {
            double crossing = prev_crossing + incr;
            double b_ray = Math.sqrt(below_conrad * below_conrad + frac1 * frac2 * crossing * crossing);
            ttime.val = b_ray / b_vel;
            sin_inc = frac2 * crossing / b_ray;
            double sin_ref = sin_inc * g_vel / b_vel;
            double critical = Math.sqrt(1.0 - sin_ref * sin_ref);
            double g_ray = 15.0 / critical;
            ttime.val += g_ray / g_vel;
            double new_dist = crossing + g_ray * sin_ref;
            if (Math.abs(new_dist - distance) < 0.1 || Math.abs(new_dist - distance) < 0.5 && Math.abs(ttime.val - prev_time) < 0.01) break;
            if (new_dist > distance) {
                if (!((incr /= 2.0) < 0.01)) continue;
                break;
            }
            prev_time = ttime.val;
            prev_crossing = crossing;
        }
        dtdd.val = sin_inc / b_vel * 111.195;
        double cos_inc = 1.0 - sin_inc * sin_inc;
        dtdh.val = cos_inc > 0.0 ? Math.sqrt(cos_inc) / b_vel : 0.0;
        return 0;
    }

    public static int pdiff(TTTab tp, double delta, double depth, doubleW ttime) {
        double depth_frac;
        if (delta < 102.0 || delta > 180.0) {
            logger.warn((Object)String.format("pdiff: delta out of range: %f", delta));
            return 1;
        }
        double depth_erad = (depth - 33.0) / 6338.0;
        if (depth_erad < -0.005207 || depth_erad > tp.max_depth) {
            logger.warn((Object)String.format("pdiff:depth out of range: %f", depth));
            return 1;
        }
        int col = (int)(depth_erad * 100.0 + 1.0);
        if (col > 0) {
            depth_frac = depth_erad * 100.0 - (double)((int)(depth_erad * 100.0));
        } else if (col == 0) {
            depth_frac = 1.0 + depth_erad * 6338.0 / 33.0;
        } else {
            col = 0;
            depth_frac = 0.0;
        }
        if (col == 13) {
            col = 12;
        }
        double dtdh = 0.1 * (tp.tab[col + 1][102] - tp.tab[col][102]);
        ttime.val = 0.1 * tp.tab[col][102] + depth_frac * dtdh;
        ttime.val += 4.4 * (delta - 102.0);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("pdiff: delta=%f depth=%f col=%d depth_frac=%f ttime=%f", delta, depth, col, depth_frac, ttime.val));
        }
        return 0;
    }

    public static int other_phase(SurfTTTab tp, double delta, double depth, doubleW ttime) {
        double depth_frac;
        int col;
        double depth_erad;
        double[] c = new double[4];
        if (delta < tp.min_delta || delta > tp.max_delta) {
            logger.warn((Object)String.format("other_phase: delta out of range: %f", delta));
            return 1;
        }
        int row = (int)(delta - tp.min_delta);
        double delta_frac = delta - (double)((int)delta);
        double surf_time = 0.1 * tp.tab[row];
        surf_time += 0.1 * (tp.tab[row + 1] - tp.tab[row]) * delta_frac;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("other_phase: delta=%f delta_frac=%f surf_time=%f", delta, delta_frac, surf_time));
        }
        DepthAllowTTTab tp_allow = tp.dep_allow_tp;
        row = 0;
        while (row < tp_allow.numrows) {
            if (delta < tp_allow.row_label[row + 1]) break;
            ++row;
        }
        delta_frac = (delta - tp_allow.row_label[row]) / (tp_allow.row_label[row + 1] - tp_allow.row_label[row]);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("other_phase: row=%d delta_frac=%f", row, delta_frac));
        }
        if ((depth_erad = (depth - 33.0) / 6338.0) < -0.005207 || depth_erad >= tp_allow.max_depth) {
            logger.warn((Object)String.format("other_phase: depth out of range: %f", depth));
            return 1;
        }
        if (depth_erad <= 0.0) {
            col = -1;
            depth_frac = 1.0 - depth_erad / -0.005207;
            c[0] = 0.0;
            c[1] = 0.0;
        } else {
            col = (int)(depth_erad * 100.0);
            depth_frac = depth_erad * 100.0 - (double)col;
            c[0] = 0.1 * tp_allow.tab[row][col];
            c[1] = 0.1 * tp_allow.tab[row + 1][col];
        }
        c[2] = 0.1 * tp_allow.tab[row][col + 1];
        c[3] = 0.1 * tp_allow.tab[row + 1][col + 1];
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(String.format("other_phase: depth=%f depth_erad=%f ", depth, depth_erad));
            sb.append(String.format("depth_frac=%f ", depth_frac));
            sb.append(String.format("c= %f %f %f %f", c[0], c[1], c[2], c[3]));
            logger.debug((Object)sb.substring(0));
        }
        double depth_corr = c[0] + delta_frac * (c[1] - c[0]);
        depth_corr += depth_frac * (c[2] - c[0]);
        depth_corr += depth_frac * delta_frac * (c[0] - c[1] + c[3] - c[2]);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("other_phase:depth_corr=%f", depth_corr));
        }
        ttime.val = surf_time - depth_corr;
        return 0;
    }

    public static int jb_pP_P(double delta, double depth, doubleW timediff, doubleW dtdh) {
        double[] times = new double[3];
        double[] t = new double[3];
        double[] d = new double[3];
        TTTab tp = pP_P_tab;
        double depth_erad = (depth - 33.0) / 6338.0;
        if (depth_erad < tp.min_depth || depth_erad > tp.max_depth) {
            logger.warn((Object)String.format("jb_pP_P: depth out of range: %f", depth));
            return 1;
        }
        int col1 = (int)(depth_erad * 100.0 + 1.0);
        double depth_frac = depth_erad * 100.0 - (double)((int)(depth_erad * 100.0));
        if (delta < tp.min_delta || delta > tp.max_delta) {
            logger.warn((Object)String.format("jb_pP_P: delta out of range: %f", delta));
            return 1;
        }
        int row1 = (int)(delta * 0.2);
        double delta_frac = delta * 0.2 - (double)row1;
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(String.format("jb_pP_P: depth=%f depth_erad=%f ", depth, depth_erad));
            sb.append(String.format("col1=%d depth_frac=%f ", col1, depth_frac));
            sb.append(String.format("delta=%f,row1=%d,frac=%f", delta, row1, delta_frac));
            logger.debug((Object)sb.substring(0));
        }
        if (col1 == 0) {
            int row = row1 + 1;
            t[0] = tp.tab[1][row];
            t[1] = tp.tab[1][row + 1];
            if (t[0] == 0.0 || t[1] == 0.0) {
                return 0;
            }
            double moho = 0.5206689807510255;
            timediff.val = 0.1 * (1.0 + depth_frac / moho) * (delta_frac * (t[1] - t[0]) + t[0]);
            dtdh.val = 0.1 * (t[0] / 33.0);
        } else {
            int delta_dir;
            if (delta > tp.switch_dir_delta) {
                delta_dir = -1;
                ++row1;
                delta_frac = 1.0 - delta_frac;
            } else {
                delta_dir = 1;
            }
            int i = 0;
            while (i < 3) {
                int row = row1 + i * delta_dir;
                int j = 0;
                while (j < 3) {
                    int col = col1 + j;
                    if (col < 14) {
                        times[j] = tp.tab[col][row];
                        if (times[j] == 0.0) {
                            return 0;
                        }
                    } else {
                        times[j] = tp.tab[13][row];
                        int n = j;
                        times[n] = times[n] + (double)(col - 13) * (tp.tab[14][row] - tp.tab[13][row]);
                    }
                    ++j;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("t[%d]=%f %f %f", i, times[0], times[1], times[2]));
                }
                t[i] = ModelJB.interpol(depth_frac, times[0], times[1], times[2]);
                d[i] = ModelJB.int_diff(depth_frac, times[0], times[1], times[2]);
                ++i;
            }
            timediff.val = 0.1 * ModelJB.interpol(delta_frac, t[0], t[1], t[2]);
            dtdh.val = 10.0 * ModelJB.interpol(delta_frac, d[0], d[1], d[2]) / 6338.0;
        }
        return 0;
    }

    public static int find_pP(ISCSol sp, ISCPha[] p) {
        double p_time = 0.0;
        double threshold = 0.0;
        int p_index = 0;
        if (sp.depth == 9999999.0) {
            logger.warn((Object)"calc_pP_resid: depthless hypocentre.");
            return 1;
        }
        int i = 0;
        while (i < sp.numphas) {
            if (p[i].time != 9999999.0) {
                if (p[i].phase.equals("P")) {
                    p_time = p[i].time;
                    p_index = i;
                }
                if (p[i].phase.length() == 0 || p[i].phase.equals("pP")) {
                    if (p[i].rdid != p[p_index].rdid) {
                        p[i].phase = "";
                    } else if (ModelJB.read_pP_P(sp.depth, p[i]) > 0) {
                        p[i].phase = "";
                    } else {
                        p[i].pP_resid = p[i].time - p_time - p[i].pP_P_time;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("find_pP: %5s %2s %8.3f r=%f", p[i].sta, p[i].phase, Float.valueOf(p[i].delta), p[i].pP_resid));
                        }
                        int j = 0;
                        while (j < 3) {
                            if (sp.depth > ModelJB.pP_max_reisd[j].depth) {
                                threshold = ModelJB.pP_max_reisd[j].max_resid;
                            }
                            ++j;
                        }
                        if (Math.abs(p[i].pP_resid) > threshold) {
                            p[i].phase = "";
                            p[i].pP_resid = 9999999.0;
                            p[i].pP_P_time = 9999999.0;
                            p[i].pP_dtdh = 9999999.0;
                        } else {
                            p[i].phase = "pP";
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)String.format("find_pP: %s identified as pP", p[i].rep_phase));
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return 0;
    }

    static double interpol(double frac, double v1, double v2, double v3) {
        double val = v1 * (1.0 - 0.5 * frac * (3.0 - frac));
        val += v2 * frac * (2.0 - frac);
        return val += v3 * 0.5 * frac * (frac - 1.0);
    }

    static double int_diff(double frac, double v1, double v2, double v3) {
        double val = v1 * (frac - 1.5);
        val += v3 * (frac - 0.5);
        return val -= v2 * 2.0 * (frac - 1.0);
    }

    public static class DepthAllowTTTab {
        public double min_depth;
        public double max_depth;
        public int numrows;
        public double[] row_label = new double[230];
        public double[][] tab = new double[30][230];

        public DepthAllowTTTab(double min_depth, double max_depth, int numrows, double[] row_label, double[][] tab) {
            this.min_depth = min_depth;
            this.max_depth = max_depth;
            this.numrows = numrows;
            this.row_label = row_label;
            this.tab = tab;
        }
    }

    public static class SurfTTTab {
        public double min_delta;
        public double max_delta;
        public DepthAllowTTTab dep_allow_tp;
        public double[] tab = new double[230];

        public SurfTTTab(double min_delta, double max_delta, DepthAllowTTTab dep_allow_tp, double[] tab) {
            this.min_delta = min_delta;
            this.max_delta = max_delta;
            this.dep_allow_tp = dep_allow_tp;
            this.tab = tab;
        }
    }

    public static class TTTab {
        public double min_delta;
        public double switch_dir_delta;
        public double max_delta;
        public double min_depth;
        public double max_depth;
        public double[][] tab = new double[30][230];

        public TTTab(double min_delta, double switch_dir_delta, double max_delta, double min_depth, double max_depth, double[][] tab) {
            this.min_delta = min_delta;
            this.switch_dir_delta = switch_dir_delta;
            this.max_delta = max_delta;
            this.min_depth = min_depth;
            this.max_depth = max_depth;
            this.tab = tab;
        }
    }

    private static class pP_max_reisd_rec {
        double depth;
        double max_resid;

        pP_max_reisd_rec(double a, double b) {
            this.depth = a;
            this.max_resid = b;
        }
    }
}

