/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.hyposat;

import cn.org.gddsn.seis.location.StationMapping;
import java.util.Formatter;
import java.util.GregorianCalendar;

public class Phase {
    private String stationCode;
    private String phase;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private float second;
    private float stdTime;
    private float backAzimuth;
    private float stdBackAzimuth;
    private float rayParam;
    private float stdRayParam;
    private String controllFlag = "TASDR_";
    private float period;
    private double amp;
    private int from = 0;

    public void parse(cn.org.gddsn.seis.Phase p, StationMapping smap) {
        this.stationCode = smap == null || smap.getStation(p.getNetCode(), p.getStationCode()) == null ? p.getStationCode() : smap.getStation(p.getNetCode(), p.getStationCode());
        this.phase = p.getPhaseName();
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(p.getPhaseTime());
        this.year = c.get(1);
        this.month = c.get(2) + 1;
        this.day = c.get(5);
        this.hour = c.get(11);
        this.minute = c.get(12);
        this.second = (float)c.get(13) + (float)c.get(14) / 1000.0f;
        this.stdTime = 0.3f;
        this.backAzimuth = p.getBackAzimuth();
        if (this.backAzimuth < -9999.0f) {
            this.backAzimuth = -999.0f;
        }
        this.stdBackAzimuth = 30.0f;
        this.rayParam = -9.99f;
        this.stdRayParam = 0.0f;
        this.controllFlag = p.getWeight() == 1 ? "TASDR_" : "______";
        this.period = (float)p.getPeriod();
        this.amp = p.getAmp() * 1000.0;
    }

    public void parse(String buf) {
        this.from = 0;
        this.stationCode = this.getNextField(buf, 6).trim();
        this.phase = this.getNextField(buf, 9).trim();
        this.year = Integer.parseInt(this.getNextField(buf, 5).trim());
        this.month = Integer.parseInt(this.getNextField(buf, 3).trim());
        this.day = Integer.parseInt(this.getNextField(buf, 3).trim());
        this.hour = Integer.parseInt(this.getNextField(buf, 3).trim());
        this.minute = Integer.parseInt(this.getNextField(buf, 3).trim());
        this.second = Float.parseFloat(this.getNextField(buf, 7).trim());
        this.stdTime = Float.parseFloat(this.getNextField(buf, 6).trim());
        this.backAzimuth = Float.parseFloat(this.getNextField(buf, 7).trim());
        this.stdBackAzimuth = Float.parseFloat(this.getNextField(buf, 6).trim());
        this.rayParam = Float.parseFloat(this.getNextField(buf, 6).trim());
        this.stdRayParam = Float.parseFloat(this.getNextField(buf, 6).trim());
        this.controllFlag = this.getNextField(buf, 7).trim();
        if (this.from == buf.length()) {
            return;
        }
        this.period = Float.parseFloat(this.getNextField(buf, 7).trim());
        this.amp = Float.parseFloat(this.getNextField(buf, 12).trim());
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("%1$-5s %2$-8s ", this.stationCode, this.phase);
        fmt.format("%1$4d %2$02d %3$02d %4$02d %5$02d ", this.year, this.month, this.day, this.hour, this.minute);
        fmt.format("%1$6.3f %2$5.3f %3$6.1f %4$5.2f ", Float.valueOf(this.second), Float.valueOf(this.stdTime), Float.valueOf(this.backAzimuth), Float.valueOf(this.stdBackAzimuth));
        fmt.format("%1$5.2f %2$5.2f %3$6s %4$6.3f %5$12.2f", Float.valueOf(this.rayParam), Float.valueOf(this.stdRayParam), this.controllFlag, Float.valueOf(this.period), this.amp);
        return sb.substring(0);
    }

    private String getNextField(String buf, int width) {
        String field = buf.substring(this.from, this.from + width);
        this.from += width;
        return field;
    }

    public double getAmp() {
        return this.amp;
    }

    public void setAmp(double amp) {
        this.amp = amp;
    }

    public float getBackAzimuth() {
        return this.backAzimuth;
    }

    public void setBackAzimuth(float backAzimuth) {
        this.backAzimuth = backAzimuth;
    }

    public String getControllFlag() {
        return this.controllFlag;
    }

    public void setControllFlag(String controllFlag) {
        this.controllFlag = controllFlag;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public float getPeriod() {
        return this.period;
    }

    public void setPeriod(float period) {
        this.period = period;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public float getRayParam() {
        return this.rayParam;
    }

    public void setRayParam(float rayParam) {
        this.rayParam = rayParam;
    }

    public float getSecond() {
        return this.second;
    }

    public void setSecond(float second) {
        this.second = second;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public void setStationCode(String stationCode) {
        this.stationCode = stationCode;
    }

    public float getStdBackAzimuth() {
        return this.stdBackAzimuth;
    }

    public void setStdBackAzimuth(float stdBackAzimuth) {
        this.stdBackAzimuth = stdBackAzimuth;
    }

    public float getStdRayParam() {
        return this.stdRayParam;
    }

    public void setStdRayParam(float stdRayParam) {
        this.stdRayParam = stdRayParam;
    }

    public float getStdTime() {
        return this.stdTime;
    }

    public void setStdTime(float stdTime) {
        this.stdTime = stdTime;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }
}

