/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.hyposat;

import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import cn.org.gddsn.seis.location.StationMapping;
import java.util.Formatter;

public class HyposatStation {
    private String stationCode;
    private String flag = " ";
    private int lat;
    private int lat_min;
    private float lat_sec;
    private String latFlag = "";
    private int lon;
    private int lon_min;
    private float lon_sec;
    private String lonFlag = " ";
    private String space = " ";
    private float elevation;
    private String desc;
    private int from = 0;

    public void parse(TimeSeries ts, StationMapping smap) {
        this.stationCode = smap == null || smap.getStation(ts.getNetworkCode(), ts.getStationCode()) == null ? ts.getStationCode() : smap.getStation(ts.getNetworkCode(), ts.getStationCode());
        Location sl = ts.getStationLocation();
        sl.getLatitude();
        this.latFlag = sl.getLatitude() > 0.0 ? "N" : "S";
        this.lat = (int)Math.abs(sl.getLatitude());
        float latFrac = (float)(Math.abs(sl.getLatitude()) - (double)this.lat) * 60.0f;
        this.lat_min = (int)latFrac;
        this.lat_sec = (latFrac - (float)this.lat_min) * 60.0f;
        this.lonFlag = sl.getLongtitude() > 0.0 ? "E" : "W";
        this.lon = (int)Math.abs(sl.getLongtitude());
        float lonFrac = (float)(Math.abs(sl.getLongtitude()) - (double)this.lon) * 60.0f;
        this.lon_min = (int)lonFrac;
        this.lon_sec = (lonFrac - (float)this.lon_min) * 60.0f;
        this.elevation = (float)sl.getAltitude() * 1000.0f;
        this.desc = ts.getNetworkCode();
    }

    public void parse(String buf) {
        this.from = 0;
        this.stationCode = this.getNextField(buf, 5).trim();
        this.flag = this.getNextField(buf, 1);
        this.lat = Integer.parseInt(this.getNextField(buf, 2).trim());
        this.lat_min = Integer.parseInt(this.getNextField(buf, 2).trim());
        this.lat_sec = Float.parseFloat(this.getNextField(buf, 4));
        this.latFlag = this.getNextField(buf, 1);
        this.lon = Integer.parseInt(this.getNextField(buf, 3).trim());
        this.lon_min = Integer.parseInt(this.getNextField(buf, 2).trim());
        this.lon_sec = Float.parseFloat(this.getNextField(buf, 4));
        this.lonFlag = this.getNextField(buf, 1);
        this.space = this.getNextField(buf, 1);
        this.elevation = Float.parseFloat(this.getNextField(buf, 6).trim());
        this.desc = this.getNextField(buf, -1);
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("%1$-5s%2$1s", this.stationCode, this.flag);
        fmt.format("%1$02d%2$02d%3$04.1f%4$1s", this.lat, this.lat_min, Float.valueOf(this.lat_sec), this.latFlag);
        fmt.format("%1$03d%2$02d%3$04.1f%4$1s %5$6.1f%6$s", this.lon, this.lon_min, Float.valueOf(this.lon_sec), this.lonFlag, Float.valueOf(this.elevation), this.desc);
        return sb.substring(0);
    }

    private String getNextField(String buf, int width) {
        if (width == -1) {
            return buf.substring(this.from);
        }
        String field = buf.substring(this.from, this.from + width);
        this.from += width;
        return field;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public float getElevation() {
        return this.elevation;
    }

    public void setElevation(float elevation) {
        this.elevation = elevation;
    }

    public String getFlag() {
        return this.flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public int getLat() {
        return this.lat;
    }

    public void setLat(int lat) {
        this.lat = lat;
    }

    public int getLat_min() {
        return this.lat_min;
    }

    public void setLat_min(int lat_min) {
        this.lat_min = lat_min;
    }

    public float getLat_sec() {
        return this.lat_sec;
    }

    public void setLat_sec(float lat_sec) {
        this.lat_sec = lat_sec;
    }

    public String getLatFlag() {
        return this.latFlag;
    }

    public void setLatFlag(String latFlag) {
        this.latFlag = latFlag;
    }

    public int getLon() {
        return this.lon;
    }

    public void setLon(int lon) {
        this.lon = lon;
    }

    public int getLon_min() {
        return this.lon_min;
    }

    public void setLon_min(int lon_min) {
        this.lon_min = lon_min;
    }

    public float getLon_sec() {
        return this.lon_sec;
    }

    public void setLon_sec(float lon_sec) {
        this.lon_sec = lon_sec;
    }

    public String getLonFlag() {
        return this.lonFlag;
    }

    public void setLonFlag(String lonFlag) {
        this.lonFlag = lonFlag;
    }

    public String getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public void setStationCode(String stationCode) {
        this.stationCode = stationCode;
    }
}

