/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.hypoinverse;

import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import java.util.Formatter;

public class Station {
    private String stationCode;
    private String netCode;
    private String compCode;
    private String chanCode;
    private String stationWeightCode = " ";
    private int lat;
    private float latFrac;
    private String latFlag = " ";
    private int lon;
    private float lonFrac;
    private String lonFlag = " ";
    private int elevation;
    private float defaultPeriod;
    private String alternateModelFlag = " ";
    private String copyFlag = "B";
    private float delayP1;
    private float delayP2;
    private float ampMagCorr;
    private String ampMagWeight = " ";
    private float durationMagCorr;
    private String durationMagWeight = " ";
    private int instrumentTypeCode;
    private float caliFactor;
    private String locationCode = "  ";
    private String alternateCompcode = "---";
    private int from = 0;

    public void parse(TimeSeries ts) {
        this.stationCode = ts.getStationCode();
        this.netCode = ts.getNetworkCode();
        this.compCode = " ";
        this.chanCode = ts.getChannelCode();
        Location sl = ts.getStationLocation();
        this.latFlag = sl.getLatitude() >= 0.0 ? "N" : "S";
        double tmp = Math.abs(sl.getLatitude());
        this.lat = (int)tmp;
        this.latFrac = (float)(tmp - (double)this.lat) * 60.0f;
        this.lonFlag = sl.getLongtitude() >= 0.0 ? "E" : "W";
        tmp = Math.abs(sl.getLongtitude());
        this.lon = (int)tmp;
        this.lonFrac = (float)(tmp - (double)this.lon) * 60.0f;
        this.elevation = (int)sl.getAltitude();
        this.defaultPeriod = 0.1f;
        this.locationCode = ts.getAuxId();
        this.alternateCompcode = ts.getChannelCode();
    }

    public void parse(String buf) {
        this.from = 0;
        this.stationCode = this.getNextField(buf, 6).trim();
        this.netCode = this.getNextField(buf, 3).trim();
        this.compCode = this.getNextField(buf, 1);
        this.chanCode = this.getNextField(buf, 4).trim();
        this.stationWeightCode = this.getNextField(buf, 1);
        this.lat = Integer.parseInt(this.getNextField(buf, 3).trim());
        this.latFrac = Float.parseFloat(this.getNextField(buf, 7));
        this.latFlag = this.getNextField(buf, 1);
        this.lon = Integer.parseInt(this.getNextField(buf, 4).trim());
        this.lonFrac = Float.parseFloat(this.getNextField(buf, 7));
        this.lonFlag = this.getNextField(buf, 1);
        this.elevation = Integer.parseInt(this.getNextField(buf, 4).trim());
        this.defaultPeriod = Float.parseFloat(this.getNextField(buf, 5).trim());
        this.alternateModelFlag = this.getNextField(buf, 1);
        this.copyFlag = this.getNextField(buf, 1);
        this.delayP1 = Float.parseFloat(this.getNextField(buf, 6));
        this.delayP2 = Float.parseFloat(this.getNextField(buf, 6));
        this.ampMagCorr = Float.parseFloat(this.getNextField(buf, 5));
        this.ampMagWeight = this.getNextField(buf, 1);
        this.durationMagCorr = Float.parseFloat(this.getNextField(buf, 5));
        this.durationMagWeight = this.getNextField(buf, 1);
        this.instrumentTypeCode = Integer.parseInt(this.getNextField(buf, 1));
        this.caliFactor = Float.parseFloat(this.getNextField(buf, 6));
        this.locationCode = this.getNextField(buf, 2);
        this.alternateCompcode = this.getNextField(buf, 3);
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("%1$-5s %2$2s %3$1s%4$3s %5$1s", this.stationCode, this.netCode, this.compCode, this.chanCode, this.stationWeightCode);
        fmt.format("%1$02d %2$7.4f%3$1s%4$3d %5$7.4f%6$1s%7$4d", this.lat, Float.valueOf(this.latFrac), this.latFlag, this.lon, Float.valueOf(this.lonFrac), this.lonFlag, this.elevation);
        fmt.format("%1$3.1f  %2$1s%3$1s%4$5.2f %5$5.2f ", Float.valueOf(this.defaultPeriod), this.alternateModelFlag, this.copyFlag, Float.valueOf(this.delayP1), Float.valueOf(this.delayP2));
        fmt.format("%1$5.2f%2$1s%3$5.2f%4$1s", Float.valueOf(this.ampMagCorr), this.ampMagWeight, Float.valueOf(this.durationMagCorr), this.durationMagWeight);
        fmt.format("%1$1d%2$6.2f%3$2s%4$3s", this.instrumentTypeCode, Float.valueOf(this.caliFactor), this.locationCode, this.alternateCompcode);
        return sb.substring(0);
    }

    private String getNextField(String buf, int width) {
        String field = buf.substring(this.from, this.from + width);
        this.from += width;
        return field;
    }

    public String getAlternateCompcode() {
        return this.alternateCompcode;
    }

    public void setAlternateCompcode(String alternateCompcode) {
        this.alternateCompcode = alternateCompcode;
    }

    public String getAlternateModelFlag() {
        return this.alternateModelFlag;
    }

    public void setAlternateModelFlag(String alternateModelFlag) {
        this.alternateModelFlag = alternateModelFlag;
    }

    public float getAmpMagCorr() {
        return this.ampMagCorr;
    }

    public void setAmpMagCorr(float ampMagCorr) {
        this.ampMagCorr = ampMagCorr;
    }

    public String getAmpMagWeight() {
        return this.ampMagWeight;
    }

    public void setAmpMagWeight(String ampMagWeight) {
        this.ampMagWeight = ampMagWeight;
    }

    public float getCaliFactor() {
        return this.caliFactor;
    }

    public void setCaliFactor(float caliFactor) {
        this.caliFactor = caliFactor;
    }

    public String getChanCode() {
        return this.chanCode;
    }

    public void setChanCode(String chanCode) {
        this.chanCode = chanCode;
    }

    public String getCompCode() {
        return this.compCode;
    }

    public void setCompCode(String compCode) {
        this.compCode = compCode;
    }

    public String getCopyFlag() {
        return this.copyFlag;
    }

    public void setCopyFlag(String copyFlag) {
        this.copyFlag = copyFlag;
    }

    public float getDefaultPeriod() {
        return this.defaultPeriod;
    }

    public void setDefaultPeriod(float defaultPeriod) {
        this.defaultPeriod = defaultPeriod;
    }

    public float getDelayP1() {
        return this.delayP1;
    }

    public void setDelayP1(float delayP1) {
        this.delayP1 = delayP1;
    }

    public float getDelayP2() {
        return this.delayP2;
    }

    public void setDelayP2(float delayP2) {
        this.delayP2 = delayP2;
    }

    public float getDurationMagCorr() {
        return this.durationMagCorr;
    }

    public void setDurationMagCorr(float durationMagCorr) {
        this.durationMagCorr = durationMagCorr;
    }

    public String getDurationMagWeight() {
        return this.durationMagWeight;
    }

    public void setDurationMagWeight(String durationMagWeight) {
        this.durationMagWeight = durationMagWeight;
    }

    public int getElevation() {
        return this.elevation;
    }

    public void setElevation(int elevation) {
        this.elevation = elevation;
    }

    public int getInstrumentTypeCode() {
        return this.instrumentTypeCode;
    }

    public void setInstrumentTypeCode(int instrumentTypeCode) {
        this.instrumentTypeCode = instrumentTypeCode;
    }

    public int getLat() {
        return this.lat;
    }

    public void setLat(int lat) {
        this.lat = lat;
    }

    public String getLatFlag() {
        return this.latFlag;
    }

    public void setLatFlag(String latFlag) {
        this.latFlag = latFlag;
    }

    public float getLatFrac() {
        return this.latFrac;
    }

    public void setLatFrac(float latFrac) {
        this.latFrac = latFrac;
    }

    public String getLocationCode() {
        return this.locationCode;
    }

    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }

    public int getLon() {
        return this.lon;
    }

    public void setLon(int lon) {
        this.lon = lon;
    }

    public String getLonFlag() {
        return this.lonFlag;
    }

    public void setLonFlag(String lonFlag) {
        this.lonFlag = lonFlag;
    }

    public float getLonFrac() {
        return this.lonFrac;
    }

    public void setLonFrac(float lonFrac) {
        this.lonFrac = lonFrac;
    }

    public String getNetCode() {
        return this.netCode;
    }

    public void setNetCode(String netCode) {
        this.netCode = netCode;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public void setStationCode(String stationCode) {
        this.stationCode = stationCode;
    }

    public String getStationWeightCode() {
        return this.stationWeightCode;
    }

    public void setStationWeightCode(String stationWeightCode) {
        this.stationWeightCode = stationWeightCode;
    }
}

