/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.BaseLocationInf;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.seis.location.MagnitudeInf;
import cn.org.gddsn.seis.location.NearLocData;
import cn.org.gddsn.seis.location.OutputInfoForLoc;
import java.util.Date;

public class TrialThreeCompLoc
extends NearLocData
implements BaseLocationInf {
    int closedStn;
    double[] x;
    double[] y;
    Date[] Tp;
    double[] A;
    int threeCount = 0;

    public void setMagnitudeInf(MagnitudeInf magnitudeInf) {
    }

    public void setComputedTravelTime(ComputedTravelTime newTTT) {
    }

    public void setEvtData(EvtData mainEvent) {
    }

    public OutputInfoForLoc getOutputInfoForLoc() {
        return null;
    }

    public String getDetailLocationResult() {
        return null;
    }

    public void setTrySource(SourceParam trySource) {
    }

    void findClosedStation() {
        this.closedStn = 0;
        int i = 1;
        while (i < this.threeCount) {
            if (this.Tp[this.closedStn].before(this.Tp[i])) {
                this.closedStn = i;
            }
            ++i;
        }
    }

    private double interAng(double A1, double A2) {
        double a;
        if (A1 < 0.0) {
            A1 += 180.0;
        }
        if (A2 < 0.0) {
            A2 += 180.0;
        }
        if ((a = Math.abs(A1 - A2)) > 90.0) {
            a = 180.0 - a;
        }
        return a;
    }

    private void initData() {
        int stnSum = this.getStnSum();
        this.x = new double[stnSum];
        this.y = new double[stnSum];
        this.Tp = new Date[stnSum];
        this.A = new double[stnSum];
        int i = 0;
        while (i < stnSum) {
            double[] loc;
            Phase phase = this.getPhase(i, "PG");
            if (phase != null && !Double.isNaN(phase.getBackAzimuth())) {
                loc = this.getRectLocation(i);
                this.x[this.threeCount] = loc[0];
                this.y[this.threeCount] = loc[1];
                this.Tp[this.threeCount] = phase.getPhaseTime();
                this.A[this.threeCount] = phase.getBackAzimuth();
                ++this.threeCount;
            } else {
                phase = this.getPhase(i, "PN");
                if (phase != null && !Double.isNaN(phase.getBackAzimuth())) {
                    loc = this.getRectLocation(i);
                    this.x[this.threeCount] = loc[0];
                    this.y[this.threeCount] = loc[1];
                    this.Tp[this.threeCount] = phase.getPhaseTime();
                    this.A[this.threeCount] = phase.getBackAzimuth();
                    ++this.threeCount;
                } else {
                    phase = this.getPhase(i, "P");
                    if (phase != null && !Double.isNaN(phase.getBackAzimuth())) {
                        loc = this.getRectLocation(i);
                        this.x[this.threeCount] = loc[0];
                        this.y[this.threeCount] = loc[1];
                        this.Tp[this.threeCount] = phase.getPhaseTime();
                        this.A[this.threeCount] = phase.getBackAzimuth();
                        ++this.threeCount;
                    }
                }
            }
            ++i;
        }
    }

    public boolean findSourceLoc() {
        this.initData();
        if (this.threeCount < 2) {
            return false;
        }
        double resX = 0.0;
        double resY = 0.0;
        double resFits = Double.MIN_VALUE;
        double a0 = 0.0;
        double a1 = 0.0;
        int i = 0;
        while (i < this.threeCount) {
            int j = 0;
            while (j < this.threeCount) {
                if (i != j) {
                    a0 = Math.tan(Math.PI * (90.0 - this.A[j]) / 180.0);
                    a1 = Math.tan(Math.PI * (90.0 - this.A[i]) / 180.0);
                    double X = (a0 * this.x[j] - this.y[j] - a1 * this.x[i] + this.y[i]) / (a0 - a1);
                    double Y = a0 * (X - this.x[j]) + this.y[j];
                    double ang = this.interAng(this.A[i], this.A[j]);
                    if (ang > resFits) {
                        resX = X;
                        resY = Y;
                        resFits = ang;
                    }
                }
                ++j;
            }
            ++i;
        }
        this.sourceParam.lon = this.Tran.getLon(resX, resY) / Math.PI * 180.0;
        this.sourceParam.lat = this.Tran.getLat(resX, resY) / Math.PI * 180.0;
        this.sourceParam.depth = Double.NaN;
        this.setLocRes(0, resX);
        this.setLocRes(1, resY);
        this.setLocRes(2, this.sourceParam.depth);
        return true;
    }
}

