/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauP_Time;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TauPToolkit
implements ComputedTravelTime {
    static Logger logger = Logger.getLogger(TauPToolkit.class);
    TauP_Time timeTools = null;
    private String phaseType = "";
    private String modelName = "";

    public TauPToolkit() {
        this.setTauModel("iasp91");
    }

    public TauPToolkit(String modelName) {
        this.setTauModel(modelName);
        logger.info((Object)this.timeTools.getTauModelName());
    }

    public void setTauModel(String newModelName) {
        try {
            if (!this.modelName.equals(newModelName)) {
                this.modelName = newModelName;
                if (this.modelName.equals("scm")) {
                    TauModel tm = TauModelLoader.internalLoad((String)this.modelName, (String)".", (boolean)false);
                    this.timeTools = new TauP_Time(tm);
                } else {
                    this.timeTools = new TauP_Time(this.modelName);
                }
            }
        }
        catch (TauModelException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public List<Arrival> getArrivals(String phaseType, double Depth, double Delta) {
        List retVal = null;
        try {
            if (!this.phaseType.equals(phaseType)) {
                this.timeTools.clearPhaseNames();
                this.timeTools.parsePhaseList(phaseType);
                this.phaseType = phaseType;
            }
            this.timeTools.depthCorrect(Depth);
            this.timeTools.calculate(Delta);
            retVal = this.timeTools.getArrivals();
        }
        catch (TauModelException tauMEx) {
            logger.warn((Object)tauMEx.getMessage(), (Throwable)tauMEx);
        }
        return retVal;
    }

    @Override
    public double calTravelTime(double depth, double Delta, int phaseType) {
        return this.calTravelTime(depth, Delta, this.getPhaseType(phaseType));
    }

    @Override
    public double calTravelTime(double[] Src, double[] Stn, int phaseType) {
        double delta = SphereUtil.distOnSphere((double)Src[0], (double)Src[1], (double)Stn[0], (double)Stn[1]);
        return this.calTravelTime(Src[2], delta, phaseType);
    }

    @Override
    public double calTravelTime(double[] Src, double[] Stn, String phaseType) {
        double delta = SphereUtil.distOnSphere((double)Src[0], (double)Src[1], (double)Stn[0], (double)Stn[1]);
        return this.calTravelTime(Src[2], delta, phaseType);
    }

    @Override
    public double calTravelTime(double depth, double delta, String phaseType) {
        double retVal = Double.NaN;
        try {
            if (!this.phaseType.equals(phaseType)) {
                this.timeTools.clearPhaseNames();
                this.timeTools.parsePhaseList(phaseType);
                this.phaseType = phaseType;
            }
            this.timeTools.depthCorrect(depth);
            this.timeTools.calculate(delta);
            List arrivals = this.timeTools.getArrivals();
            int sz = arrivals.size();
            if (sz == 0) {
                return retVal;
            }
            retVal = sz == 1 ? ((Arrival)arrivals.get(0)).getTime() : (sz == 2 && phaseType.indexOf(44) != -1 ? Math.abs(((Arrival)arrivals.get(0)).getTime() - ((Arrival)arrivals.get(1)).getTime()) : ((Arrival)arrivals.get(0)).getTime());
        }
        catch (TauModelException tauMEx) {
            logger.warn((Object)tauMEx.getMessage(), (Throwable)tauMEx);
            return retVal;
        }
        return retVal;
    }

    @Override
    public double calDelta(double depth, double time, int phaseType) {
        return this.calDelta(depth, time, this.getPhaseType(phaseType));
    }

    @Override
    public double calDelta(double depth, double time, String phaseType) {
        double retVal;
        block16: {
            retVal = Double.NaN;
            try {
                if (!this.phaseType.equals(phaseType)) {
                    this.timeTools.clearPhaseNames();
                    this.timeTools.parsePhaseList(phaseType);
                    this.phaseType = phaseType;
                }
                this.timeTools.depthCorrect(depth);
                if (phaseType.indexOf(44) == -1) {
                    double delta = 0.0;
                    while (delta < 182.0) {
                        this.timeTools.calculate(delta);
                        List arrivals = this.timeTools.getArrivals();
                        int sz = arrivals.size();
                        if (sz > 0 && time < ((Arrival)arrivals.get(0)).getTime()) {
                            double minDel = delta - 2.0;
                            while (minDel < delta + 0.01) {
                                this.timeTools.calculate(minDel);
                                arrivals = this.timeTools.getArrivals();
                                sz = arrivals.size();
                                if (sz > 0) {
                                    if (!(time > ((Arrival)arrivals.get(0)).getTime())) {
                                        retVal = minDel;
                                        this.timeTools.calculate(retVal);
                                        arrivals = this.timeTools.getArrivals();
                                        sz = arrivals.size();
                                        if (sz == 0 || Math.abs(time - ((Arrival)arrivals.get(0)).getTime()) > 1.0) {
                                            retVal = Double.NaN;
                                        }
                                        break block16;
                                    }
                                } else {
                                    retVal = Double.NaN;
                                }
                                minDel += 0.01;
                            }
                            break block16;
                        }
                        delta += 2.0;
                    }
                    break block16;
                }
                double S_P = Double.NaN;
                double delta = 0.0;
                while (delta < 182.0) {
                    this.timeTools.calculate(delta);
                    List arrivals = this.timeTools.getArrivals();
                    S_P = this.getS_PTime(arrivals, phaseType);
                    int sz = arrivals.size();
                    if (sz > 1 && !Double.isNaN(S_P) && time < S_P) {
                        double minDel = delta - 2.0;
                        while (minDel < delta + 0.1) {
                            this.timeTools.calculate(minDel);
                            arrivals = this.timeTools.getArrivals();
                            sz = arrivals.size();
                            S_P = this.getS_PTime(arrivals, phaseType);
                            if (sz > 1 && !Double.isNaN(S_P) && time < S_P) {
                                if (Math.abs(time - S_P) > 10.0) {
                                    logger.info((Object)"Your picked phase may be wrong!");
                                }
                                retVal = minDel - 0.05;
                                break block16;
                            }
                            minDel += 0.1;
                        }
                        break;
                    }
                    delta += 2.0;
                }
            }
            catch (TauModelException tauMEx) {
                logger.warn((Object)tauMEx.getMessage(), (Throwable)tauMEx);
                return retVal;
            }
        }
        return retVal;
    }

    private double getS_PTime(List<Arrival> arrivals, String phaseType) {
        int idx = phaseType.indexOf(44);
        String pName = phaseType.substring(0, idx);
        String sName = phaseType.substring(idx + 1);
        double ptime = Double.MAX_VALUE;
        int i = 0;
        while (i < arrivals.size()) {
            if (pName.equals(arrivals.get(i).getName()) && ptime > arrivals.get(i).getTime()) {
                ptime = arrivals.get(i).getTime();
            }
            ++i;
        }
        if (ptime > 7200.0) {
            return Double.NaN;
        }
        double stime = Double.MAX_VALUE;
        int i2 = 0;
        while (i2 < arrivals.size()) {
            if (sName.equals(arrivals.get(i2).getName()) && stime > arrivals.get(i2).getTime()) {
                stime = arrivals.get(i2).getTime();
            }
            ++i2;
        }
        if (stime > 7200.0) {
            return Double.NaN;
        }
        double retVal = Math.abs(stime - ptime);
        return retVal;
    }

    public String getPhaseType(int phaseType) {
        String pType = "";
        if (phaseType == 1) {
            pType = "Pn";
        } else if (phaseType == 2) {
            pType = "Sn";
        } else if (phaseType == 3) {
            pType = "Pg";
        } else if (phaseType == 4) {
            pType = "Sg";
        } else if (phaseType == 8) {
            pType = "P";
        } else if (phaseType == 9) {
            pType = "S";
        } else if (phaseType == 11) {
            pType = "LG1";
        } else if (phaseType == 12) {
            pType = "LG2";
        } else if (phaseType == 5) {
            pType = "Pg,Sg";
        } else if (phaseType == 6) {
            pType = "Pn,Sn";
        } else if (phaseType == 7) {
            pType = "Pn,Sg";
        } else if (phaseType == 10) {
            pType = "P,S";
        }
        return pType;
    }

    public static void main(String[] args) {
        TauPToolkit tauKit = new TauPToolkit();
        double s = 0.0;
        while (s < 200.0) {
            double delta = tauKit.calDelta(20.0, s, "P");
            System.out.format("%.2f, %.3f\n", s, delta);
            s += 0.2;
        }
    }
}

