/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.optimization.RealValueFunction;
import cn.org.gddsn.optimization.SimplexMin;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.location.IterateNearlocL1Residual;
import cn.org.gddsn.seis.location.StnLocation;

public final class SimplexAndL1Loc
extends IterateNearlocL1Residual {
    double OTime;
    private int maxIterations;

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    private double getOTime() {
        double tt;
        double[] sta;
        double[] src;
        int stnSum = this.getStnSum();
        StnLocation[] stnLoc = new StnLocation[stnSum];
        int i = 0;
        while (i < stnSum) {
            stnLoc[i] = new StnLocation();
            ++i;
        }
        double[] arriveT = new double[stnSum];
        double OTimeSum = 0.0;
        int OTimeCount = 0;
        int counts = this.getLocationData(stnLoc, arriveT, 3);
        int i2 = 0;
        while (i2 < counts) {
            src = new double[]{this.sourceParam.lat, this.sourceParam.lon, this.sourceParam.depth};
            sta = new double[]{stnLoc[i2].getLat(), stnLoc[i2].getLon(), stnLoc[i2].getAlt()};
            tt = this.computedTravelTime.calTravelTime(src, sta, 3);
            if (!Double.isNaN(tt)) {
                OTimeSum += arriveT[i2] - tt;
                ++OTimeCount;
            }
            ++i2;
        }
        counts = this.getLocationData(stnLoc, arriveT, 1);
        i2 = 0;
        while (i2 < counts) {
            src = new double[]{this.sourceParam.lat, this.sourceParam.lon, this.sourceParam.depth};
            sta = new double[]{stnLoc[i2].getLat(), stnLoc[i2].getLon(), stnLoc[i2].getAlt()};
            tt = this.computedTravelTime.calTravelTime(src, sta, 1);
            if (!Double.isNaN(tt)) {
                OTimeSum += arriveT[i2] - tt;
                ++OTimeCount;
            }
            ++i2;
        }
        counts = this.getLocationData(stnLoc, arriveT, 8);
        i2 = 0;
        while (i2 < counts) {
            src = new double[]{this.sourceParam.lat, this.sourceParam.lon, this.sourceParam.depth};
            sta = new double[]{stnLoc[i2].getLat(), stnLoc[i2].getLon(), stnLoc[i2].getAlt()};
            tt = this.computedTravelTime.calTravelTime(src, sta, 8);
            if (!Double.isNaN(tt)) {
                OTimeSum += arriveT[i2] - tt;
                ++OTimeCount;
            }
            ++i2;
        }
        this.OTime = OTimeSum / (double)OTimeCount;
        return this.OTime;
    }

    public SourceParam getSourceParam() {
        SourceParam sp = super.getSourceParam();
        sp.setLocProgram("Simplex");
        sp.setOperator("Simplex");
        return sp;
    }

    public boolean findSourceLoc() {
        double[] trySrc = new double[]{this.trySource.lat, this.trySource.lon, this.trySource.depth};
        double width = 0.5;
        double[][] p = new double[][]{{trySrc[0], trySrc[1], trySrc[2] - 5.0}, {trySrc[0], trySrc[1] + width, trySrc[2]}, {trySrc[0] + width, trySrc[1], trySrc[2]}, {trySrc[0] - width, trySrc[1] - width, trySrc[2]}};
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(p[0][0] + "," + p[0][1] + "," + p[0][2]));
            logger.debug((Object)(p[1][0] + "," + p[1][1] + "," + p[1][2]));
            logger.debug((Object)(p[2][0] + "," + p[2][1] + "," + p[2][2]));
            logger.debug((Object)(p[3][0] + "," + p[3][1] + "," + p[3][2]));
        }
        SimplexMin simplexMin = new SimplexMin((double[][])p, 3, 1.0E-6);
        simplexMin.setItmax(this.maxIterations);
        simplexMin.setFunk((RealValueFunction)this);
        simplexMin.SearchMin();
        double Len = p.length;
        double lat = 0.0;
        double lon = 0.0;
        double depth = 0.0;
        int i = 0;
        while (i < p.length) {
            lat += p[i][0] / Len;
            lon += p[i][1] / Len;
            depth += p[i][2] / Len;
            ++i;
        }
        if (depth < 0.0) {
            depth = 10.0;
        }
        this.sourceParam.lat = lat;
        this.sourceParam.lon = lon;
        this.sourceParam.depth = depth;
        this.sourceParam.rms = simplexMin.getResidual();
        this.sourceParam.originTime.setTime(this.baseDate.getTime() + Math.round(this.getOTime() * 1000.0));
        this.sourceParam.gapAzi = this.getGapAzi();
        return true;
    }
}

