/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.location.TauPToolkit;
import edu.sc.seis.TauP.TauP_Create;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ShallowDepthSolver {
    static Logger logger = Logger.getLogger(ShallowDepthSolver.class);
    public SCM scm = new SCM();
    double cr;
    private int nz;
    private int nr;
    private double[][] pnpg;

    public double getCriticalPnDelta() {
        return this.cr;
    }

    public double findDepth(int npg, int mpn, Phase[] pg, Phase[] pn) {
        double[][] avg_depth = new double[npg][2];
        int i = 0;
        while (i < npg) {
            double sdt = 0.0;
            double tpg = (double)pg[i].getPhaseTime().getTime() / 1000.0;
            double rpg = pg[i].getDistance();
            int j = 0;
            while (j < mpn) {
                double tpn = (double)pn[j].getPhaseTime().getTime() / 1000.0;
                double rpn = pn[j].getDistance();
                double dt = tpn - (rpn - (rpg < this.cr ? this.cr : rpg)) / this.scm.vp[2] - tpg;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Pg sta=%s/%s, Pn sta=%s/%s  dt=%.2f", pg[i].getNetCode(), pg[i].getStationCode(), pn[j].getNetCode(), pn[j].getStationCode(), dt));
                }
                sdt += dt;
                ++j;
            }
            avg_depth[i] = this.findDepth(rpg, sdt /= (double)mpn);
            StringBuffer sb = new StringBuffer(32);
            sb.append(String.format("sta= %s/%s delta=%.2f avg dt=%.2f depth=", pg[i].getNetCode(), pg[i].getStationCode(), rpg, sdt));
            if (avg_depth[i][0] > 0.0) {
                if (Math.abs(avg_depth[i][0] - avg_depth[i][1]) < 1.0) {
                    sb.append(String.format("%.1f", avg_depth[i][0]));
                } else {
                    sb.append(String.format("%.1f/%.1f", avg_depth[i][0], avg_depth[i][1]));
                }
            } else {
                sb.append(String.format("%.1f", avg_depth[i][0]));
            }
            logger.info((Object)sb.substring(0));
            ++i;
        }
        double m0 = 0.0;
        double m1 = 0.0;
        int n = 0;
        int i2 = 0;
        while (i2 < npg) {
            if (avg_depth[i2][0] >= 0.0) {
                m0 += avg_depth[i2][0];
                m1 += avg_depth[i2][1];
                ++n;
            }
            ++i2;
        }
        if (n == 0) {
            logger.warn((Object)"No valid Pn/Pg phases, no depth solution!");
            return -1.0;
        }
        m0 /= (double)n;
        m1 /= (double)n;
        if (n == 1) {
            logger.warn((Object)String.format("Only one Pn/Pg phase, depth=%.1f", m0));
            return m0;
        }
        if (Math.abs(m0 - m1) < 0.1) {
            logger.info((Object)String.format("Solved, depth=%.1f", m0));
            return m0;
        }
        double d0 = 0.0;
        double d1 = 0.0;
        int i3 = 0;
        while (i3 < npg) {
            if (avg_depth[i3][0] >= 0.0) {
                d0 += (avg_depth[i3][0] - m0) * (avg_depth[i3][0] - m0);
                d1 += (avg_depth[i3][1] - m1) * (avg_depth[i3][1] - m1);
            }
            ++i3;
        }
        d0 /= (double)(n - 1);
        d0 = Math.sqrt(d0);
        double d = d0 = Math.sqrt(d1 /= (double)(n - 1));
        double om = m0;
        int J = 0;
        if (d0 > d1) {
            d = d1;
            om = m1;
            J = 1;
        }
        double m = 0.0;
        n = 0;
        int i4 = 0;
        while (i4 < npg) {
            if (avg_depth[i4][J] >= 0.0 && Math.abs(avg_depth[i4][J] - om) < 2.0 * d) {
                m += avg_depth[i4][J];
                ++n;
            }
            ++i4;
        }
        logger.warn((Object)String.format("Solved, 2 candidate: %.1f/%.1f, the fit depth=%.1f", m0, m1, m /= (double)n));
        return m;
    }

    public double[] findDepth(double tpg, double rpg, double tpn, double rpn) {
        double dt = tpn - (rpn - (rpg < this.cr ? this.cr : rpg)) / this.scm.vp[2] - tpg;
        return this.findDepth(rpg, dt);
    }

    public double[] findDepth(double rpg, double dt) {
        double[] depth = new double[]{-1.0, -1.0};
        int ir = (int)(rpg / 2.0 + 0.5);
        if (ir < 0 || ir >= this.nr) {
            return depth;
        }
        if (dt > this.pnpg[0][ir]) {
            depth[0] = 0.0;
            depth[1] = 0.0;
            return depth;
        }
        if (dt < this.pnpg[this.nz - 1][ir]) {
            return depth;
        }
        int n = 0;
        int i = 1;
        while (i < this.nz) {
            if (this.pnpg[i - 1][ir] > this.pnpg[i][ir] && this.pnpg[i - 1][ir] >= dt && dt > this.pnpg[i][ir]) {
                depth[n++] = i - 1;
                if (n > 1) {
                    n = 1;
                }
            }
            ++i;
        }
        if (depth[1] < 0.0) {
            depth[1] = depth[0];
        }
        return depth;
    }

    public void modifySCM() {
        Vector<String> strVec = new Vector<String>(256);
        try {
            Scanner sc = new Scanner(new File("cfg/scm.tvel"));
            while (sc.hasNext()) {
                strVec.add(sc.nextLine());
            }
            sc.close();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return;
        }
        if (!((String)strVec.get(0)).equals("ak135 - P") || strVec.size() < 8) {
            logger.warn((Object)("Bad format of " + new File("cfg/scm.tvel")));
            return;
        }
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(new File("cfg/scm.tvel")));
            pw.println((String)strVec.get(0));
            pw.println((String)strVec.get(1));
            pw.printf("%10.3f %11.4f %11.4f %11.4f\n", this.scm.h[0], this.scm.vp[0], this.scm.vs[0], this.scm.rho[0]);
            pw.printf("%10.3f %11.4f %11.4f %11.4f\n", this.scm.h[1], this.scm.vp[0], this.scm.vs[0], this.scm.rho[0]);
            pw.printf("%10.3f %11.4f %11.4f %11.4f\n", this.scm.h[1], this.scm.vp[1], this.scm.vs[1], this.scm.rho[1]);
            pw.printf("%10.3f %11.4f %11.4f %11.4f\n", this.scm.h[2], this.scm.vp[1], this.scm.vs[1], this.scm.rho[1]);
            pw.printf("%10.3f %11.4f %11.4f %11.4f\n", this.scm.h[2], this.scm.vp[2], this.scm.vs[2], this.scm.rho[2]);
            int i = 7;
            while (i < strVec.size()) {
                pw.println((String)strVec.get(i));
                ++i;
            }
            pw.close();
        }
        catch (IOException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return;
        }
    }

    public void generateSCM() {
        String[] args = new String[]{"-tvel", new File("cfg/scm.tvel").getAbsolutePath()};
        try {
            TauP_Create.main((String[])args);
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        try {
            Scanner sc = new Scanner(new File("cfg/scm.tvel"));
            sc.nextLine();
            sc.nextLine();
            this.scm.h[0] = sc.nextDouble();
            this.scm.vp[0] = sc.nextDouble();
            this.scm.vs[0] = sc.nextDouble();
            this.scm.rho[0] = sc.nextDouble();
            sc.nextLine();
            sc.nextLine();
            this.scm.h[1] = sc.nextDouble();
            this.scm.vp[1] = sc.nextDouble();
            this.scm.vs[1] = sc.nextDouble();
            this.scm.rho[1] = sc.nextDouble();
            sc.nextLine();
            sc.nextLine();
            this.scm.h[2] = sc.nextDouble();
            this.scm.vp[2] = sc.nextDouble();
            this.scm.vs[2] = sc.nextDouble();
            this.scm.rho[2] = sc.nextDouble();
            sc.close();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return;
        }
        double h1 = this.scm.h[1] - this.scm.h[0];
        double h2 = this.scm.h[2] - this.scm.h[1];
        double v1 = this.scm.vp[0];
        double v2 = this.scm.vp[1];
        double v3 = this.scm.vp[2];
        double i1 = Math.asin(v1 / v3);
        double i2 = Math.asin(v2 / v3);
        this.cr = 2.0 * (h1 * Math.tan(i1) + h2 * Math.tan(i2)) + 0.2;
        logger.info((Object)String.format("Pn critical delta %5.1f", this.cr));
        this.nz = (int)(h1 + h2);
        this.nr = (int)(this.cr * 2.0) / 2;
        this.pnpg = new double[this.nz][this.nr];
        TauPToolkit tpk = new TauPToolkit("scm");
        System.out.printf("\n%3s", "H\\D");
        int j = 0;
        while (j < this.nr) {
            System.out.printf(" %5d", j * 2);
            ++j;
        }
        System.out.println();
        double z = 0.0;
        int i = 0;
        while (i < this.nz) {
            z = i;
            System.out.printf("%3.0f", z);
            int j2 = 0;
            while (j2 < this.nr) {
                double r = j2 * 2;
                double tpg = tpk.calTravelTime(z, r / 111.19, "p");
                if (Double.isNaN(tpg)) {
                    tpg = tpk.calTravelTime(z, r / 111.19, "Pg");
                }
                double tpn = tpk.calTravelTime(z, (r < this.cr ? this.cr : r) / 111.19, "Pn");
                this.pnpg[i][j2] = tpn - tpg;
                System.out.printf(" %5.2f", this.pnpg[i][j2]);
                ++j2;
            }
            System.out.println();
            ++i;
        }
    }

    public static void main(String[] args) throws IOException {
        ShallowDepthSolver ds = new ShallowDepthSolver();
        ds.scm = new SCM();
        ds.scm.h = new double[]{0.0, 15.0, 33.0};
        ds.scm.vp = new double[]{6.01, 6.51, 8.01};
        ds.generateSCM();
    }

    public static class SCM {
        public double[] h = new double[]{0.0, 20.0, 35.0};
        public double[] vp = new double[]{5.8, 6.5, 8.04};
        public double[] vs = new double[]{3.46, 3.85, 4.48};
        public double[] rho = new double[]{2.72, 2.92, 3.3198};

        public SCM() {
        }

        public SCM(double[] h, double[] vp, double[] vs, double[] rho) {
            this.h = h;
            this.vp = vp;
            this.vs = vs;
            this.rho = rho;
        }
    }
}

