/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.seis.location.locsat.libloc.Ttcal0;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.netlib.util.floatW;
import org.netlib.util.intW;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.Index;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NetCDFTable
implements ComputedTravelTime {
    static Logger logger = Logger.getLogger(NetCDFTable.class);
    public static String[] default_phases = new String[]{"LQ", "LR", "Lg", "P", "PKP", "PP", "PcP", "Pg", "Pn", "Rg", "S", "SKS", "SS", "ScS", "Sn", "Sg", "pP", "sP", "Pb", "Sb"};
    private String[] phases;
    private int nphs;
    private int maxtbd;
    private int maxtbz;
    private int[] ntbd;
    private int[] ntbz;
    private float[] tbd;
    private float[] tbz;
    private float[] tbtt;
    private boolean interpolate = true;

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    public void setup_tttables(String filename) {
        block29: {
            NetcdfFile ncfile = null;
            try {
                try {
                    int _j;
                    ncfile = NetcdfFile.open((String)filename);
                    this.nphs = ncfile.findDimension("nphs").getLength();
                    this.maxtbz = ncfile.findDimension("maxtbz").getLength();
                    this.maxtbd = ncfile.findDimension("maxtbd").getLength();
                    this.phases = new String[this.nphs];
                    Variable v_phase = ncfile.findVariable("phase");
                    ArrayChar a_phase = (ArrayChar)v_phase.read();
                    int i = 0;
                    while (i < this.nphs) {
                        this.phases[i] = a_phase.getString(i);
                        ++i;
                    }
                    this.ntbz = new int[this.nphs];
                    Variable v_ntbz = ncfile.findVariable("ntbz");
                    Array a_ntbz = v_ntbz.read();
                    int i2 = 0;
                    while (i2 < this.nphs) {
                        this.ntbz[i2] = a_ntbz.getInt(i2);
                        ++i2;
                    }
                    this.ntbd = new int[this.nphs];
                    Variable v_ntbd = ncfile.findVariable("ntbd");
                    Array a_ntbd = v_ntbd.read();
                    int i3 = 0;
                    while (i3 < this.nphs) {
                        this.ntbd[i3] = a_ntbd.getInt(i3);
                        ++i3;
                    }
                    float[][] tbz1 = new float[this.nphs][this.maxtbz];
                    Variable v_tbz = ncfile.findVariable("tbz");
                    Array a_tbz = v_tbz.read();
                    Index ima_tbz = a_tbz.getIndex();
                    int i4 = 0;
                    while (i4 < this.nphs) {
                        int j = 0;
                        while (j < this.maxtbz) {
                            tbz1[i4][j] = a_tbz.getFloat(ima_tbz.set(i4, j));
                            ++j;
                        }
                        ++i4;
                    }
                    float[][] tbd1 = new float[this.nphs][this.maxtbd];
                    Variable v_tbd = ncfile.findVariable("tbd");
                    Array a_tbd = v_tbd.read();
                    Index ima_tbd = a_tbd.getIndex();
                    int i5 = 0;
                    while (i5 < this.nphs) {
                        int j = 0;
                        while (j < this.maxtbd) {
                            tbd1[i5][j] = a_tbd.getFloat(ima_tbd.set(i5, j));
                            ++j;
                        }
                        ++i5;
                    }
                    float[][][] tbtt1 = new float[this.nphs][this.maxtbz][this.maxtbd];
                    Variable v_tbtt = ncfile.findVariable("tbtt");
                    Array a_tbtt = v_tbtt.read();
                    Index ima_tbtt = a_tbtt.getIndex();
                    int i6 = 0;
                    while (i6 < this.nphs) {
                        int j = 0;
                        while (j < this.maxtbz) {
                            int k = 0;
                            while (k < this.maxtbd) {
                                tbtt1[i6][j][k] = a_tbtt.getFloat(ima_tbtt.set(i6, j, k));
                                ++k;
                            }
                            ++j;
                        }
                        ++i6;
                    }
                    this.tbd = new float[this.nphs * this.maxtbd];
                    this.tbz = new float[this.nphs * this.maxtbz];
                    this.tbtt = new float[this.nphs * this.maxtbz * this.maxtbd];
                    int _k = 0;
                    while (_k < this.nphs) {
                        _j = 0;
                        while (_j < this.maxtbz) {
                            this.tbz[_k * this.maxtbz + _j] = tbz1[_k][_j];
                            ++_j;
                        }
                        ++_k;
                    }
                    tbz1 = null;
                    _k = 0;
                    while (_k < this.nphs) {
                        int _i = 0;
                        while (_i < this.maxtbd) {
                            this.tbd[_k * this.maxtbd + _i] = tbd1[_k][_i];
                            ++_i;
                        }
                        ++_k;
                    }
                    tbd1 = null;
                    _k = 0;
                    while (_k < this.nphs) {
                        _j = 0;
                        while (_j < this.maxtbz) {
                            int _i = 0;
                            while (_i < this.maxtbd) {
                                this.tbtt[_k * this.maxtbz * this.maxtbd + _j * this.maxtbd + _i] = tbtt1[_k][_j][_i];
                                ++_i;
                            }
                            ++_j;
                        }
                        ++_k;
                    }
                    tbtt1 = null;
                }
                catch (IOException ioe) {
                    logger.warn((Object)("trying to open " + filename), (Throwable)ioe);
                    if (ncfile == null) break block29;
                    try {
                        ncfile.close();
                    }
                    catch (IOException ioe2) {
                        logger.warn((Object)("trying to close " + filename), (Throwable)ioe2);
                    }
                }
            }
            finally {
                if (ncfile != null) {
                    try {
                        ncfile.close();
                    }
                    catch (IOException ioe) {
                        logger.warn((Object)("trying to close " + filename), (Throwable)ioe);
                    }
                }
            }
        }
    }

    private int find_phase(String phase) {
        int n = -1;
        int i = 0;
        while (i < this.nphs) {
            if (phase.equals(this.phases[i])) {
                n = i;
                break;
            }
            ++i;
        }
        return n;
    }

    public double calTravelTime(double[] Src, double[] Stn, int phaseType) {
        double Delta = SphereUtil.distOnSphere((double)Src[0], (double)Src[1], (double)Stn[0], (double)Stn[1]);
        return this.calTravelTime(Src[2], Delta, phaseType);
    }

    public double calDelta(double depth, double time, int phaseType) {
        return this.calDelta(depth, time, this.getPhaseType(phaseType));
    }

    public double calTravelTime(double depth, double Delta, int phaseType) {
        return this.calTravelTime(depth, Delta, this.getPhaseType(phaseType));
    }

    public String getPhaseType(int phaseType) {
        String pType = "";
        if (phaseType == 1) {
            pType = "Pn";
        } else if (phaseType == 2) {
            pType = "Sn";
        } else if (phaseType == 3) {
            pType = "Pg";
        } else if (phaseType == 4) {
            pType = "Sg";
        } else if (phaseType == 18) {
            pType = "Pb";
        } else if (phaseType == 19) {
            pType = "Sb";
        } else if (phaseType == 8) {
            pType = "P";
        } else if (phaseType == 9) {
            pType = "S";
        } else if (phaseType == 13) {
            pType = "Pg1";
        } else if (phaseType == 14) {
            pType = "Sg1";
        } else if (phaseType == 11) {
            pType = "LG1";
        } else if (phaseType == 12) {
            pType = "LG2";
        } else if (phaseType == 5) {
            pType = "Pg,Sg";
        } else if (phaseType == 6) {
            pType = "Pn,Sn";
        } else if (phaseType == 7) {
            pType = "Pn,Sg";
        } else if (phaseType == 10) {
            pType = "P,S";
        }
        return pType;
    }

    public double calTravelTime(double[] Src, double[] Stn, String phaseType) {
        double Delta = SphereUtil.distOnSphere((double)Src[0], (double)Src[1], (double)Stn[0], (double)Stn[1]);
        return this.calTravelTime(Src[2], Delta, phaseType);
    }

    public double calTravelTime(double depth, float delta, float azi, int pid) {
        if (pid < 0 || pid >= this.nphs) {
            return Double.NaN;
        }
        floatW dcalx = new floatW(0.0f);
        double[] atx = new double[4];
        intW iterr = new intW(0);
        Ttcal0.ttcal0(pid, (float)depth, 6371.0f, delta, azi, this.maxtbd, this.maxtbz, this.ntbd[pid], this.ntbz[pid], this.tbd, pid * this.maxtbd, this.tbz, pid * this.maxtbz, this.tbtt, pid * this.maxtbz * this.maxtbd, dcalx, atx, 0, iterr);
        if (iterr.val != 0 && !this.interpolate) {
            return Double.NaN;
        }
        if ((double)dcalx.val < 0.0) {
            return Double.NaN;
        }
        return dcalx.val;
    }

    public double calTravelTime(double depth, double Delta, String phaseType) {
        int pid = this.find_phase(phaseType);
        if (pid == -1) {
            return Double.NaN;
        }
        float azi = 0.0f;
        return this.calTravelTime(depth, (float)Delta, azi, pid);
    }

    private double calDeltaSingle(double depth, double time, String phaseType) {
        int pid = this.find_phase(phaseType);
        if (pid == -1) {
            return Double.NaN;
        }
        int i = 1;
        while (i < this.ntbd[pid]) {
            double tc_1 = this.calTravelTime(depth, this.tbd[pid * this.maxtbd + i - 1], 0.0f, pid);
            double tc = this.calTravelTime(depth, this.tbd[pid * this.maxtbd + i], 0.0f, pid);
            if (!Double.isNaN(tc_1) && !Double.isNaN(tc) && tc > time && tc_1 <= time && tc_1 > 0.0) {
                float tmp = (float)((time - tc_1) / (tc - tc_1));
                float delta = this.tbd[pid * this.maxtbd + i - 1] + tmp * (this.tbd[pid * this.maxtbd + i] - this.tbd[pid * this.maxtbd + i - 1]);
                return delta;
            }
            ++i;
        }
        return Double.NaN;
    }

    public double calDelta(double depth, double time, String phaseType) {
        if (phaseType.indexOf(44) == -1) {
            return this.calDeltaSingle(depth, time, phaseType);
        }
        int idx = phaseType.indexOf(44);
        String pName = phaseType.substring(0, idx);
        String sName = phaseType.substring(idx + 1);
        int pPid = this.find_phase(pName);
        int sPid = this.find_phase(sName);
        if (pPid == -1 || sPid == -1) {
            return Double.NaN;
        }
        int i = 1;
        while (i < this.ntbd[pPid]) {
            double tc_1 = this.calTravelTime(depth, this.tbd[pPid * this.maxtbd + i - 1], 0.0f, sPid) - this.calTravelTime(depth, this.tbd[pPid * this.maxtbd + i - 1], 0.0f, pPid);
            double tc = this.calTravelTime(depth, this.tbd[pPid * this.maxtbd + i], 0.0f, sPid) - this.calTravelTime(depth, this.tbd[pPid * this.maxtbd + i], 0.0f, pPid);
            if (!Double.isNaN(tc_1) && !Double.isNaN(tc) && tc > time && tc_1 <= time && tc_1 > 0.0) {
                float tmp = (float)((time - tc_1) / (tc - tc_1));
                float delta = this.tbd[pPid * this.maxtbd + i - 1] + tmp * (this.tbd[pPid * this.maxtbd + i] - this.tbd[pPid * this.maxtbd + i - 1]);
                return delta;
            }
            ++i;
        }
        return Double.NaN;
    }

    public static void main(String[] args) {
        NetCDFTable lst = new NetCDFTable();
        lst.setup_tttables("/usr/local/jopens/msdp/cfg/iasp91.nc");
        double tt = lst.calTravelTime(20.0, 17.3, "Pn");
        System.out.println(tt);
        System.out.println(lst.calDelta(20.0, tt, "Pn"));
        tt = lst.calTravelTime(7.0, 5.21, "Pn");
        double sg = lst.calTravelTime(10.0, 5.21, "Sg");
        sg = lst.calTravelTime(7.0, 5.21, "Sg");
        System.out.println(String.valueOf(tt) + ", " + sg);
        System.out.println(lst.calDelta(7.0, sg - tt, "Pn,Sg"));
        System.out.println(lst.calDelta(20.0, tt, "Pn"));
        System.out.println(lst.calTravelTime(2.0, 30.0, "pP"));
        System.out.println(lst.calTravelTime(400.0, 5.0, "Pn"));
        System.out.println();
        lst = new NetCDFTable();
        lst.setInterpolate(false);
        lst.setup_tttables("/usr/local/jopens/msdp/cfg/iasp91.nc");
        tt = lst.calTravelTime(30.0, 6.3, "Pn");
        System.out.println(tt);
        System.out.println(lst.calDelta(30.0, tt, "Pn"));
        double depth = 80.0;
        tt = lst.calTravelTime(depth, 0.10792337, "Pg");
        sg = lst.calTravelTime(depth, 0.10792337, "Sg");
        System.out.println(String.valueOf(tt) + ", " + sg);
        System.out.println(lst.calDelta(depth, sg - tt, "Pg,Sg"));
        int d = 0;
        while (d < 80) {
            depth = d;
            int s = 2;
            while (s < 80) {
                double sec = s;
                System.out.printf("depth=%.1f, sec=%.1f, delta=%.3f\n", depth, sec, lst.calDelta(depth, sec, "S"));
                ++s;
            }
            ++d;
        }
    }
}

