/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.location.LocationData;
import java.util.Date;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class NearLocData
extends LocationData {
    static Logger logger = Logger.getLogger(NearLocData.class);
    private double lon0;
    private double lat0;
    private double[] locRes = new double[3];
    protected Date BaseDate;
    protected SphereUtil Tran;

    protected void initLocData() {
        if (this.getStnPhases() != null && this.getStnLocations() != null) {
            this.setOPoint();
            this.Tran = new SphereUtil(this.lon0, this.lat0);
            this.setBaseDate();
        }
    }

    private void setOPoint() {
        double lonSum = 0.0;
        double latSum = 0.0;
        int nstn = 0;
        int i = 0;
        while (i < this.stnLocations.length) {
            if (this.hasValidPhase(i)) {
                lonSum += this.stnLocations[i].getLon();
                latSum += this.stnLocations[i].getLat();
                ++nstn;
            }
            ++i;
        }
        this.lon0 = lonSum / (double)nstn * Math.PI / 180.0;
        this.lat0 = latSum / (double)nstn * Math.PI / 180.0;
    }

    private void setBaseDate() {
        this.BaseDate = new Date();
        int i = 0;
        while (i < this.stnPhases.length) {
            Enumeration Enu = this.stnPhases[i].elements();
            if (Enu.hasMoreElements()) {
                Phase phase = (Phase)Enu.nextElement();
                this.BaseDate.setTime(phase.getPhaseTime().getTime() - 120000L);
            }
            ++i;
        }
    }

    public double[] getLocRes() {
        return this.locRes;
    }

    public double getLat0() {
        return this.lat0;
    }

    public double getLon0() {
        return this.lon0;
    }

    protected void setLocRes(double[] newLocRes) {
        this.locRes = newLocRes;
    }

    protected void setLocRes(int index, double newRes) {
        this.locRes[index] = newRes;
    }

    public int getPhaseType(String phaseName) throws IllegalArgumentException {
        int type = Integer.MAX_VALUE;
        if (phaseName.equalsIgnoreCase("Pg")) {
            type = 3;
        } else if (phaseName.equalsIgnoreCase("Sg")) {
            type = 4;
        } else if (phaseName.equalsIgnoreCase("Pn")) {
            type = 1;
        } else if (phaseName.equalsIgnoreCase("Sn")) {
            type = 2;
        } else if (phaseName.equalsIgnoreCase("P")) {
            type = 8;
        } else if (phaseName.equalsIgnoreCase("S")) {
            type = 9;
        } else if (phaseName.equalsIgnoreCase("Pg1")) {
            type = 13;
        } else if (phaseName.equalsIgnoreCase("Sg1")) {
            type = 14;
        } else {
            throw new IllegalArgumentException("In NearLocData.getPhaseType() " + phaseName + " is a wrong argument");
        }
        return type;
    }

    public int recLocationData(double[] x, double[] y, double[] arriveT, int phaseType) {
        String phaseName = "";
        switch (phaseType) {
            case 3: {
                phaseName = "Pg";
                break;
            }
            case 4: {
                phaseName = "Sg";
                break;
            }
            case 1: {
                phaseName = "Pn";
                break;
            }
            case 2: {
                phaseName = "Sn";
                break;
            }
            case 8: {
                phaseName = "P";
                break;
            }
            case 9: {
                phaseName = "S";
                break;
            }
            case 13: {
                phaseName = "Pg1";
                break;
            }
            case 14: {
                phaseName = "Sg1";
                break;
            }
            default: {
                logger.warn((Object)"IN Nearloc.recLocationData(): Could not use unknow phase type to on location !");
                System.exit(-1);
            }
        }
        int m = 0;
        int i = 0;
        while (i < this.stnPhases.length) {
            Enumeration Enu = this.stnPhases[i].elements();
            while (Enu.hasMoreElements()) {
                Phase phase = (Phase)Enu.nextElement();
                if (!phase.getPhaseName().equals(phaseName) || phase.getWeight() != 1) continue;
                x[m] = this.Tran.getX(this.stnLocations[i].getLon() * Math.PI / 180.0, this.stnLocations[i].getLat() * Math.PI / 180.0);
                y[m] = this.Tran.getY(this.stnLocations[i].getLon() * Math.PI / 180.0, this.stnLocations[i].getLat() * Math.PI / 180.0);
                arriveT[m] = (double)(phase.getPhaseTime().getTime() - this.BaseDate.getTime()) / 1000.0;
                ++m;
            }
            ++i;
        }
        return m;
    }

    public int setWeight(double[] weight, int start, int phaseType) {
        String phaseName = "";
        switch (phaseType) {
            case 3: {
                phaseName = "Pg";
                break;
            }
            case 4: {
                phaseName = "Sg";
                break;
            }
            case 1: {
                phaseName = "Pn";
                break;
            }
            case 2: {
                phaseName = "Sn";
                break;
            }
            case 8: {
                phaseName = "P";
                break;
            }
            case 9: {
                phaseName = "S";
                break;
            }
            case 13: {
                phaseName = "Pg1";
                break;
            }
            case 14: {
                phaseName = "Sg1";
                break;
            }
            default: {
                logger.warn((Object)"IN Nearloc.recLocationData(): Could not use unknow phase type to on location !");
                System.exit(-1);
            }
        }
        int m = 0;
        int i = 0;
        while (i < this.stnPhases.length) {
            Enumeration Enu = this.stnPhases[i].elements();
            while (Enu.hasMoreElements()) {
                Phase phase = (Phase)Enu.nextElement();
                if (!phase.getPhaseName().equals(phaseName)) continue;
                phase.setWeight(weight[start + m] > 0.5 ? 1 : 0);
                ++m;
            }
            ++i;
        }
        return m;
    }

    public double[] getRectLocation(double lat, double lon) {
        double[] loc = new double[]{this.Tran.getX(lon * Math.PI / 180.0, lat * Math.PI / 180.0), this.Tran.getY(lon * Math.PI / 180.0, lat * Math.PI / 180.0), 0.0};
        return loc;
    }

    public double[] getRectLocation(int stn) {
        double[] loc = new double[]{this.Tran.getX(this.stnLocations[stn].getLon() * Math.PI / 180.0, this.stnLocations[stn].getLat() * Math.PI / 180.0), this.Tran.getY(this.stnLocations[stn].getLon() * Math.PI / 180.0, this.stnLocations[stn].getLat() * Math.PI / 180.0), 0.0};
        return loc;
    }
}

