/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.seis.location.locsat.LocSAT;
import cn.org.gddsn.seis.location.locsat.libloc.Ttcal0;
import org.apache.log4j.Logger;
import org.netlib.util.floatW;
import org.netlib.util.intW;

public class LocsatTable
implements ComputedTravelTime {
    static Logger logger = Logger.getLogger(LocsatTable.class);
    public static final int MAXTBD = 207;
    public static final int MAXTBZ = 41;
    public static String[] default_phases = new String[]{"LQ", "LR", "Lg", "P", "PKP", "PP", "PcP", "Pg", "Pn", "Rg", "S", "SKS", "SS", "ScS", "Sn", "Sg", "pP", "sP", "Pb", "Sb"};
    private String prefix;
    private String[] phases;
    private int num_phase_types;
    private int maxtbd = 207;
    private int maxtbz = 41;
    private int[] ntbd;
    private int[] ntbz;
    private float[] tbd;
    private float[] tbz;
    private float[] tbtt;
    private boolean interpolate = true;

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    public int setup_tttables(String prefix, String[] phases, int num_phase_types) {
        int _j;
        this.prefix = prefix;
        this.phases = phases;
        this.num_phase_types = num_phase_types;
        this.ntbd = new int[num_phase_types];
        this.ntbz = new int[num_phase_types];
        float[][] tbd1 = new float[num_phase_types][this.maxtbd];
        float[][] tbz1 = new float[num_phase_types][this.maxtbz];
        float[][][] tbtt1 = new float[num_phase_types][this.maxtbz][this.maxtbd];
        int ierr = LocSAT.rdtttab(this.prefix, this.phases, this.num_phase_types, this.maxtbd, this.maxtbz, this.ntbd, this.ntbz, tbd1, tbz1, tbtt1);
        this.tbd = new float[num_phase_types * this.maxtbd];
        this.tbz = new float[num_phase_types * this.maxtbz];
        this.tbtt = new float[num_phase_types * this.maxtbz * this.maxtbd];
        int _k = 0;
        while (_k < num_phase_types) {
            _j = 0;
            while (_j < this.maxtbz) {
                this.tbz[_k * this.maxtbz + _j] = tbz1[_k][_j];
                ++_j;
            }
            ++_k;
        }
        tbz1 = null;
        _k = 0;
        while (_k < num_phase_types) {
            int _i = 0;
            while (_i < this.maxtbd) {
                this.tbd[_k * this.maxtbd + _i] = tbd1[_k][_i];
                ++_i;
            }
            ++_k;
        }
        tbd1 = null;
        _k = 0;
        while (_k < num_phase_types) {
            _j = 0;
            while (_j < this.maxtbz) {
                int _i = 0;
                while (_i < this.maxtbd) {
                    this.tbtt[_k * this.maxtbz * this.maxtbd + _j * this.maxtbd + _i] = tbtt1[_k][_j][_i];
                    ++_i;
                }
                ++_j;
            }
            ++_k;
        }
        tbtt1 = null;
        if (ierr == 0) {
            return 0;
        }
        if (ierr == 1) {
            logger.warn((Object)"setup_tttables: Error opening travel-time tables");
            return 13;
        }
        if (ierr == 2) {
            logger.warn((Object)"setup_tttables: Error reading travel-time tables: Unexpected E-O-F");
            return 14;
        }
        logger.warn((Object)"setup_tttables: Unknown error reading travel-time tables");
        return 15;
    }

    private int find_phase(String phase) {
        int n = -1;
        int i = 0;
        while (i < this.num_phase_types) {
            if (phase.equals(this.phases[i])) {
                n = i;
                break;
            }
            ++i;
        }
        return n;
    }

    public double calTravelTime(double[] Src, double[] Stn, int phaseType) {
        double delta = SphereUtil.distOnSphere((double)Src[0], (double)Src[1], (double)Stn[0], (double)Stn[1]);
        return this.calTravelTime(Src[2], delta, phaseType);
    }

    public double calDelta(double depth, double time, int phaseType) {
        return this.calDelta(depth, time, this.getPhaseType(phaseType));
    }

    public double calTravelTime(double depth, double Delta, int phaseType) {
        return this.calTravelTime(depth, Delta, this.getPhaseType(phaseType));
    }

    public String getPhaseType(int phaseType) {
        String pType = "";
        if (phaseType == 1) {
            pType = "Pn";
        } else if (phaseType == 2) {
            pType = "Sn";
        } else if (phaseType == 3) {
            pType = "Pg";
        } else if (phaseType == 4) {
            pType = "Sg";
        } else if (phaseType == 18) {
            pType = "Pb";
        } else if (phaseType == 19) {
            pType = "Sb";
        } else if (phaseType == 8) {
            pType = "P";
        } else if (phaseType == 9) {
            pType = "S";
        } else if (phaseType == 13) {
            pType = "Pg1";
        } else if (phaseType == 14) {
            pType = "Sg1";
        } else if (phaseType == 11) {
            pType = "LG1";
        } else if (phaseType == 12) {
            pType = "LG2";
        } else if (phaseType == 5) {
            pType = "Pg,Sg";
        } else if (phaseType == 6) {
            pType = "Pn,Sn";
        } else if (phaseType == 7) {
            pType = "Pn,Sg";
        } else if (phaseType == 10) {
            pType = "P,S";
        }
        return pType;
    }

    public double calTravelTime(double[] Src, double[] Stn, String phaseType) {
        double delta = SphereUtil.distOnSphere((double)Src[0], (double)Src[1], (double)Stn[0], (double)Stn[1]);
        return this.calTravelTime(Src[2], delta, phaseType);
    }

    public double calTravelTime(double depth, float delta, float azi, int pid) {
        if (pid < 0 || pid >= this.num_phase_types) {
            return Double.NaN;
        }
        floatW dcalx = new floatW(0.0f);
        double[] atx = new double[4];
        intW iterr = new intW(0);
        Ttcal0.ttcal0(pid, (float)depth, 6371.0f, delta, azi, this.maxtbd, this.maxtbz, this.ntbd[pid], this.ntbz[pid], this.tbd, pid * this.maxtbd, this.tbz, pid * this.maxtbz, this.tbtt, pid * this.maxtbz * this.maxtbd, dcalx, atx, 0, iterr);
        if (iterr.val != 0 && !this.interpolate) {
            return Double.NaN;
        }
        if ((double)dcalx.val < 0.0) {
            return Double.NaN;
        }
        return dcalx.val;
    }

    public double calTravelTime(double depth, double Delta, String phaseType) {
        int pid = this.find_phase(phaseType);
        if (pid == -1) {
            return Double.NaN;
        }
        float azi = 0.0f;
        return this.calTravelTime(depth, (float)Delta, azi, pid);
    }

    public double calDeltaSingle(double depth, double time, String phaseType) {
        int pid = this.find_phase(phaseType);
        if (pid == -1) {
            return Double.NaN;
        }
        int i = 1;
        while (i < this.ntbd[pid]) {
            double tc_1 = this.calTravelTime(depth, this.tbd[pid * this.maxtbd + i - 1], 0.0f, pid);
            double tc = this.calTravelTime(depth, this.tbd[pid * this.maxtbd + i], 0.0f, pid);
            if (tc > time && tc_1 <= time && tc_1 > 0.0) {
                float tmp = (float)((time - tc_1) / (tc - tc_1));
                float delta = this.tbd[pid * this.maxtbd + i - 1] + tmp * (this.tbd[pid * this.maxtbd + i] - this.tbd[pid * this.maxtbd + i - 1]);
                return delta;
            }
            ++i;
        }
        return Double.NaN;
    }

    public double calDelta(double depth, double time, String phaseType) {
        if (phaseType.indexOf(44) == -1) {
            return this.calDeltaSingle(depth, time, phaseType);
        }
        int idx = phaseType.indexOf(44);
        String pName = phaseType.substring(0, idx);
        String sName = phaseType.substring(idx + 1);
        int pPid = this.find_phase(pName);
        int sPid = this.find_phase(sName);
        if (pPid == -1 || sPid == -1) {
            return Double.NaN;
        }
        int i = 1;
        while (i < this.ntbd[pPid]) {
            double tc_1 = this.calTravelTime(depth, this.tbd[pPid * this.maxtbd + i - 1], 0.0f, sPid) - this.calTravelTime(depth, this.tbd[pPid * this.maxtbd + i - 1], 0.0f, pPid);
            double tc = this.calTravelTime(depth, this.tbd[pPid * this.maxtbd + i], 0.0f, sPid) - this.calTravelTime(depth, this.tbd[pPid * this.maxtbd + i], 0.0f, pPid);
            if (!Double.isNaN(tc_1) && !Double.isNaN(tc) && tc > time && tc_1 <= time && tc_1 > 0.0) {
                float tmp = (float)((time - tc_1) / (tc - tc_1));
                float delta = this.tbd[pPid * this.maxtbd + i - 1] + tmp * (this.tbd[pPid * this.maxtbd + i] - this.tbd[pPid * this.maxtbd + i - 1]);
                return delta;
            }
            ++i;
        }
        return Double.NaN;
    }

    public static void main(String[] args) {
        LocsatTable lst = new LocsatTable();
        lst.setup_tttables("../lib/locsat/tables/iasp91", default_phases, default_phases.length);
        double tcalc = lst.calTravelTime(20.0, 17.3, "Pn");
        System.out.println(tcalc);
        System.out.println(lst.calDelta(20.0, tcalc, "Pn"));
        tcalc = lst.calTravelTime(7.0, 5.21, "Pn");
        double sg = lst.calTravelTime(10.0, 5.21, "Sg");
        sg = lst.calTravelTime(7.0, 5.21, "Sg");
        System.out.println(String.valueOf(tcalc) + ", " + sg);
        System.out.println(lst.calDelta(7.0, sg - tcalc, "Pn,Sg"));
        System.out.println(lst.calDelta(20.0, tcalc, "Pn"));
        System.out.println(lst.calTravelTime(2.0, 30.0, "pP"));
        System.out.println(lst.calTravelTime(400.0, 5.0, "Pn"));
    }
}

