/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.seis.CatalogExporter;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.seis.location.IterateNearloc;
import cn.org.gddsn.seis.location.hyposat.HyposatStation;
import cn.org.gddsn.seis.ttt3d.TTTDing;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LocSATZY
extends IterateNearloc {
    static Logger logger = Logger.getLogger(LocSATZY.class);
    private String workingPath = "/usr/local/jopens/msdp/work";
    private String modelPath = "/tmp/yjs/jopens/jseis/model/";
    private String[] envp;
    private String[] cmdArray = new String[]{"/bin/cp", "customLoc-in.phase", "customLoc-out"};
    private StringBuffer result = new StringBuffer();
    private EvtData evtData;

    public boolean findSourceLoc() {
        File out = new File(this.workingPath, "customLoc-out");
        if (out.isFile() && out.canWrite()) {
            out.delete();
        }
        return this.exportStation() && this.exportPhase() && this.shell();
    }

    public SourceParam getSourceParam() {
        SourceParam sp = super.getSourceParam();
        sp.setLocProgram("LocSAT3D");
        return sp;
    }

    private boolean exportStation() {
        File allStation = new File(this.workingPath, "customLoc-sta");
        try {
            FileWriter fos = new FileWriter(allStation);
            int TCN = this.evtData.getTCN();
            Hashtable<String, String> tbl = new Hashtable<String, String>();
            int i = 0;
            while (i < TCN) {
                HyposatStation s = new HyposatStation();
                String net = this.evtData.getNetworkCode(i);
                String sta = this.evtData.getStationCode(i);
                String key = String.valueOf(net) + "/" + sta;
                if (tbl.get(key) == null && this.evtData.hasPhase(net, sta)) {
                    s.parse(this.evtData.getTimeSeries(i), null);
                    fos.write(s.format());
                    fos.write("\n");
                    tbl.put(key, key);
                }
                ++i;
            }
            fos.close();
        }
        catch (IOException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean exportPhase() {
        try {
            File phaseFile = new File(this.workingPath, "customLoc-in");
            CatalogExporter ce = new CatalogExporter();
            ce.setExportAmp(false);
            ce.write(this.evtData, null, phaseFile);
        }
        catch (IOException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean shell() {
        boolean ret = false;
        try {
            String[] args = new String[]{"-p", this.modelPath};
            Class<?> cls = Class.forName("jseis.method.LocMain");
            Method m = cls.getDeclaredMethod("main", String[].class);
            m.invoke(null, new Object[]{args});
            this.parseResult();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        this.sourceParam.gapAzi = this.getGapAzi();
        return !ret;
    }

    private void parseResult() throws IOException {
        Scanner sc = new Scanner(new File(this.workingPath, "customLoc-out"));
        String sourceLine = sc.nextLine();
        String[] ss = sourceLine.split("\\p{javaWhitespace}+");
        sc.close();
        sc = new Scanner(new File(this.workingPath, "customLoc-out"));
        int y = sc.nextInt();
        int mon = sc.nextInt();
        int d = sc.nextInt();
        int h = sc.nextInt();
        int m = sc.nextInt();
        double sec = sc.nextDouble();
        int isec = (int)sec;
        double fsec = sec - (double)isec;
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT+8"));
        cal.set(y, mon - 1, d, h, m, isec);
        this.sourceParam.setOriginTime(new Date(cal.getTime().getTime() + (long)((int)(fsec * 1000.0))));
        this.sourceParam.setLat(sc.nextDouble());
        this.sourceParam.setErh(sc.nextDouble());
        this.sourceParam.setLon(sc.nextDouble());
        this.sourceParam.setErh(sc.nextDouble());
        this.sourceParam.setDepth(sc.nextDouble());
        this.sourceParam.setErz(sc.nextDouble());
        int nskip = ss.length - 13;
        int i = 0;
        while (i < nskip) {
            sc.next();
            ++i;
        }
        this.sourceParam.setRms(sc.nextDouble());
        this.sourceParam.setOperator("loc3dtt");
        sc.close();
        Hashtable<String, Float> tblDelta = new Hashtable<String, Float>();
        Hashtable<String, Float> tblAzi = new Hashtable<String, Float>();
        Hashtable<String, Float> tblRes = new Hashtable<String, Float>();
        sc = new Scanner(new File(this.workingPath, "customLoc-out"));
        String line = sc.nextLine();
        this.result = new StringBuffer();
        this.result.append("\n" + line + "\n");
        line = sc.nextLine();
        this.result.append(String.valueOf(line) + "\n");
        line = sc.nextLine();
        this.result.append(String.valueOf(line) + "\n");
        while (sc.hasNextLine()) {
            line = sc.nextLine();
            if (line.trim().length() == 0 || line.startsWith("#")) break;
            this.result.append(String.valueOf(line) + "\n");
            Scanner sc1 = new Scanner(line);
            String sta = sc1.next();
            String net = sc1.next();
            float dist = sc1.nextFloat();
            float azi = sc1.nextFloat();
            String pha = sc1.next();
            sc1.next();
            sc1.next();
            float res = sc1.nextFloat();
            String key = String.valueOf(net) + "_" + sta + "_" + pha;
            tblDelta.put(key, Float.valueOf(dist));
            tblAzi.put(key, Float.valueOf(azi));
            tblRes.put(key, Float.valueOf(res));
            sc1.close();
        }
        sc.close();
        Vector<Phase>[] vec = this.getStnPhases();
        int i2 = 0;
        while (i2 < vec.length) {
            for (Phase p : vec[i2]) {
                Float res;
                Float azi;
                if (p.getPhaType() != 0) continue;
                String sta = String.valueOf(p.getNetCode()) + "_" + p.getStationCode();
                String key = String.valueOf(sta) + "_" + p.getPhaseName();
                Float delta = (Float)tblDelta.get(key);
                if (delta != null) {
                    p.setDistance(delta.floatValue() * 111.19f);
                }
                if ((azi = (Float)tblAzi.get(key)) != null) {
                    p.setAzimuth(azi.floatValue());
                }
                if ((res = (Float)tblRes.get(key)) == null) continue;
                p.setResi(res.floatValue());
            }
            ++i2;
        }
        this.sourceParam.gapAzi = this.getGapAzi();
    }

    public String getDetailLocationResult() {
        String buf = super.getDetailLocationResult();
        return String.valueOf(buf) + this.result.substring(0);
    }

    public double getDetailResidual(int stn, String phaseName) {
        Phase phase = this.getPhase(stn, phaseName);
        if (phase == null) {
            return -99999.0;
        }
        return phase.getResi();
    }

    public String getWorkingPath() {
        return this.workingPath;
    }

    public void setWorkingPath(String workingPath) {
        this.workingPath = workingPath;
    }

    public void setModelPath(String modelPath) {
        this.modelPath = modelPath;
    }

    public EvtData getEvtData() {
        return this.evtData;
    }

    public void setEvtData(EvtData evtData) {
        this.evtData = evtData;
    }

    public String[] getCmdArray() {
        return this.cmdArray;
    }

    public void setCmdArray(String[] cmdArray) {
        this.cmdArray = cmdArray;
    }

    public String[] getEnvp() {
        return this.envp;
    }

    public void setEnvp(String[] envp) {
        this.envp = envp;
        int i = 0;
        while (i < this.envp.length) {
            this.envp[i] = this.envp[i].trim();
            ++i;
        }
    }

    public void setComputedTravelTime(ComputedTravelTime newCompTT) {
        this.computedTravelTime = new TTTDing();
    }
}

