/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.IterateNearloc;
import cn.org.gddsn.seis.location.StationMapping;
import cn.org.gddsn.seis.location.locsat.LocsatControl;
import cn.org.gddsn.seis.location.locsat.Phase;
import cn.org.gddsn.seis.location.locsat.PhaseDataHeader;
import cn.org.gddsn.seis.location.locsat.Station;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LocSAT3D
extends IterateNearloc {
    static Logger logger = Logger.getLogger(LocSAT3D.class);
    private String workingPath = "/usr/local/jopens/msdp/work";
    private long firstMs = Long.MAX_VALUE;
    private StringBuffer result = new StringBuffer();
    private EvtData evtData;
    private StationMapping smap = new StationMapping(6);
    private LocsatControl locsatControl = null;

    public boolean findSourceLoc() {
        this.smap.buildStationMap(this.evtData);
        File out = new File(this.workingPath, "locsat-out");
        if (out.isFile() && out.canWrite()) {
            out.delete();
        }
        return this.exportControl() && this.exportStation() && this.exportPhase() && this.shell();
    }

    private boolean exportControl() {
        try {
            this.locsatControl.save();
        }
        catch (IOException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    public SourceParam getSourceParam() {
        SourceParam sp = super.getSourceParam();
        sp.setLocProgram("LocSAT");
        return sp;
    }

    private boolean exportStation() {
        File allStation = new File(this.workingPath, "locsat-sta");
        try {
            FileWriter fos = new FileWriter(allStation);
            String[] stns = this.evtData.getAllNetStation();
            int i = 0;
            while (i < stns.length) {
                Station s = new Station();
                int idx = stns[i].indexOf(47);
                int[] chn = this.evtData.getChanOrder(stns[i].substring(0, idx), stns[i].substring(idx + 1));
                s.parse(this.evtData.getTimeSeries(chn[0]), this.smap);
                fos.write(s.format());
                fos.write("\n");
                ++i;
            }
            fos.close();
        }
        catch (IOException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean exportPhase() {
        int tch = this.evtData.getTCN();
        this.firstMs = Long.MAX_VALUE;
        int firstChn = 0;
        int numData = 0;
        int i = 0;
        while (i < tch) {
            Vector<cn.org.gddsn.seis.Phase> phs = this.evtData.getPhases(i);
            for (cn.org.gddsn.seis.Phase p : phs) {
                if (p.getPhaType() == 0) {
                    ++numData;
                }
                if (this.firstMs <= p.getPhaseTime().getTime()) continue;
                this.firstMs = p.getPhaseTime().getTime();
                firstChn = i;
            }
            ++i;
        }
        SourceParam s = new SourceParam();
        s.setOriginTime(new Date(this.firstMs));
        if (this.locsatControl.isUseLocation()) {
            s.setLat(this.evtData.getStationLocation(firstChn).getLatitude());
            s.setLon(this.evtData.getStationLocation(firstChn).getLongtitude());
            s.setDepth(this.locsatControl.getInitDepth());
        } else {
            s.setLat(999.0);
            s.setLon(999.0);
            s.setDepth(this.locsatControl.getInitDepth());
        }
        PhaseDataHeader pd = new PhaseDataHeader();
        pd.parse(s, numData);
        File phaseFile = new File(this.workingPath, "locsat-in");
        try {
            FileWriter fos = new FileWriter(phaseFile);
            fos.write(String.valueOf(pd.format()) + "\n");
            int n = 0;
            int i2 = 0;
            while (i2 < tch) {
                Vector<cn.org.gddsn.seis.Phase> phs = this.evtData.getPhases(i2);
                Collections.sort(phs);
                for (cn.org.gddsn.seis.Phase p : phs) {
                    if (p.getPhaType() != 0) continue;
                    Phase hp = new Phase();
                    hp.parse(s.getOriginTime(), n++, p, this.smap);
                    fos.write(hp.format());
                    fos.write("\n");
                }
                ++i2;
            }
            fos.close();
        }
        catch (IOException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean shell() {
        StringTokenizer st;
        String line;
        BufferedReader br;
        int ret;
        block21: {
            ret = -1;
            File conFile = new File(this.workingPath, "locsat-ctl3d");
            File inFile = new File(this.workingPath, "locsat-in");
            File staFile = new File(this.workingPath, "locsat-sta");
            File outFile = new File(this.workingPath, "locsat-out");
            String[] args = new String[]{"-c", conFile.getAbsolutePath(), "-d", inFile.getAbsolutePath(), "-s", staFile.getAbsolutePath(), "-o", outFile.getAbsolutePath()};
            ret = 0;
            cn.org.gddsn.seis.location.locsat3d.LocSAT3D.main0(args);
            br = new BufferedReader(new FileReader(new File(this.workingPath, "locsat-out")));
            line = null;
            float resi = -99999.0f;
            st = null;
            boolean found = false;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("- Unwt. RMS Res.:")) {
                    int idx = line.indexOf(":");
                    st = new StringTokenizer(line.substring(idx + 1));
                    resi = Float.parseFloat(st.nextToken());
                }
                if (!(found = line.startsWith(" Final location estimate"))) continue;
                this.sourceParam.setRms(resi);
                logger.info((Object)("Locat resi: " + resi));
                break;
            }
            if (found) break block21;
            return false;
        }
        try {
            this.result = new StringBuffer();
            this.result.append(String.valueOf(line) + "\n");
            while ((line = br.readLine()) != null) {
                this.result.append(String.valueOf(line) + "\n");
                st = new StringTokenizer(line);
                if (line.indexOf("Latitude") != -1) {
                    st.nextToken();
                    float lat = Float.parseFloat(st.nextToken());
                    st.nextToken();
                    if (st.nextToken().equals("S")) {
                        lat *= -1.0f;
                    }
                    this.sourceParam.setLat(lat);
                }
                if (line.indexOf("Longitude") != -1) {
                    st.nextToken();
                    float lon = Float.parseFloat(st.nextToken());
                    st.nextToken();
                    if (st.nextToken().equals("W")) {
                        lon *= -1.0f;
                    }
                    this.sourceParam.setLon(lon);
                }
                if (line.indexOf("Depth:") != -1) {
                    st.nextToken();
                    this.sourceParam.setDepth(Float.parseFloat(st.nextToken()));
                }
                if (line.indexOf("Relative O.T.:") != -1) {
                    StringTokenizer st1 = new StringTokenizer(line, " :");
                    st1.nextToken();
                    st1.nextToken();
                    long otime = this.firstMs + (long)(Float.parseFloat(st1.nextToken()) * 1000.0f);
                    this.sourceParam.setOriginTime(new Date(otime));
                }
                if (line.indexOf("Semi-major axis") != -1) {
                    st.nextToken();
                    st.nextToken();
                    this.sourceParam.setErh(Float.parseFloat(st.nextToken()));
                }
                if (line.indexOf("Depth error") != -1) {
                    st.nextToken();
                    st.nextToken();
                    this.sourceParam.setErz(Float.parseFloat(st.nextToken()));
                }
                if (line.indexOf("Orig. time error:") != -1) {
                    st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    this.sourceParam.setOriginTimeError(Float.parseFloat(st.nextToken()));
                }
                if (line.indexOf("Maximum azimuthal GAP:") != -1) {
                    st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    this.sourceParam.setGapAzi(Float.parseFloat(st.nextToken()));
                }
                if (line.indexOf("Ariv ID") != -1) break;
            }
            this.sourceParam.setOperator("LocSAT3d");
            Hashtable<String, Float> tbl = new Hashtable<String, Float>();
            Hashtable<String, Float> tblAzi = new Hashtable<String, Float>();
            Hashtable<String, Float> tblDelta = new Hashtable<String, Float>();
            this.result.append(String.valueOf(br.readLine()) + "\n");
            while ((line = br.readLine()) != null) {
                this.result.append(String.valueOf(line) + "\n");
                if (line.indexOf("====") != -1) break;
                st = new StringTokenizer(line);
                st.nextToken();
                String sta = st.nextToken();
                String phase = st.nextToken();
                st.nextToken();
                st.nextToken();
                tbl.put(String.valueOf(sta) + "_" + phase, Float.valueOf(Float.parseFloat(st.nextToken())));
                st.nextToken();
                tblDelta.put(String.valueOf(sta) + "_" + phase, Float.valueOf(Float.parseFloat(st.nextToken())));
                tblAzi.put(String.valueOf(sta) + "_" + phase, Float.valueOf(Float.parseFloat(st.nextToken())));
            }
            Vector<cn.org.gddsn.seis.Phase>[] vec = this.getStnPhases();
            int i = 0;
            while (i < vec.length) {
                for (cn.org.gddsn.seis.Phase p : vec[i]) {
                    Float delta;
                    Float azi;
                    String sta;
                    if (p.getPhaType() != 0 || (sta = this.smap.getStation(p.getNetCode(), p.getStationCode())) == null) continue;
                    String key = String.valueOf(sta) + "_" + p.getPhaseName();
                    Float re = (Float)tbl.get(key);
                    if (re != null) {
                        p.setResi(re.floatValue());
                    }
                    if ((azi = (Float)tblAzi.get(key)) != null) {
                        p.setAzimuth(azi.floatValue());
                    }
                    if ((delta = (Float)tblDelta.get(key)) == null) continue;
                    p.setDistance(delta.floatValue() * 111.19f);
                }
                ++i;
            }
            br.close();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return ret == 0;
    }

    public String getDetailLocationResult() {
        String buf = super.getDetailLocationResult();
        return String.valueOf(buf) + this.result.substring(0);
    }

    public double getDetailResidual(int stn, String phaseName) {
        cn.org.gddsn.seis.Phase phase = this.getPhase(stn, phaseName);
        if (phase == null) {
            return -99999.0;
        }
        return phase.getResi();
    }

    public String getWorkingPath() {
        return this.workingPath;
    }

    public void setWorkingPath(String workingPath) {
        this.workingPath = workingPath;
        this.locsatControl = new LocsatControl(new File(workingPath, "locsat-ctl3d").getAbsolutePath());
    }

    public EvtData getEvtData() {
        return this.evtData;
    }

    public void setEvtData(EvtData evtData) {
        this.evtData = evtData;
    }

    public LocsatControl getLocsatControl() {
        return this.locsatControl;
    }

    public void setLocsatControl(LocsatControl locsatControl) {
        this.locsatControl = locsatControl;
    }
}

