/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import JSci.maths.ArrayMath;
import cn.org.gddsn.convert.DoubleFormat;
import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.convert.cs_printf;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.BaseLocationInf;
import cn.org.gddsn.seis.location.CalMagnitude;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.seis.location.LocData;
import cn.org.gddsn.seis.location.MagnitudeInf;
import cn.org.gddsn.seis.location.OutputInfoForLoc;
import cn.org.gddsn.seis.location.StnLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IterateNearloc
extends LocData
implements BaseLocationInf {
    protected ComputedTravelTime computedTravelTime;
    private MagnitudeInf magnitudeInf = new CalMagnitude();
    protected SourceParam trySource = new SourceParam();

    @Override
    public void setTrySource(SourceParam trySource) {
        this.trySource = trySource;
    }

    @Override
    public void setEvtData(EvtData mainEvent) {
    }

    public SourceParam loopFindBestSource(String[] phns, int minStn, double minResidual) {
        Enumeration Enu;
        int stn;
        Phase phase;
        double cres = 0.0;
        int bad_stn = 0;
        String bad_phsnm = null;
        Vector<Phase>[] phases = this.getStnPhases();
        Vector<Phase> vec = new Vector<Phase>();
        int i = 0;
        while (i < phases.length) {
            Enumeration Enu2 = this.stnPhases[i].elements();
            while (Enu2.hasMoreElements()) {
                phase = (Phase)Enu2.nextElement();
                if (phase.getPhaType() != 0) continue;
                vec.add(phase);
            }
            ++i;
        }
        Collections.sort(vec);
        for (Phase ph : vec) {
            logger.info((Object)ph);
        }
        int n = 0;
        int size = vec.size();
        int nf = 0;
        int nl = 0;
        do {
            if (n % 4 == 0) {
                int s = this.isolateStation();
                if (s != -1) {
                    logger.info((Object)("remove isolate station: " + this.getStnLocations()[s].getSta()));
                }
            } else if (n % 4 == 1) {
                phase = (Phase)vec.get(size - 1 - nl++);
                this.setWeightByStation(phase.getStationCode(), 0);
                logger.info((Object)("remove first arrival station: " + phase.getStationCode()));
            } else if (n % 4 == 2) {
                phase = (Phase)vec.get(nf++);
                this.setWeightByStation(phase.getStationCode(), 0);
                logger.info((Object)("remove last arrival station: " + phase.getStationCode()));
            } else {
                cres = 0.0;
                int i2 = 0;
                while (i2 < phases.length) {
                    Enumeration Enu3 = this.stnPhases[i2].elements();
                    while (Enu3.hasMoreElements()) {
                        phase = (Phase)Enu3.nextElement();
                        if (phase.getPhaType() != 0) continue;
                        double sres = Math.abs(this.getDetailResidual(i2, phase.getPhaseName()));
                        if (phase.getWeight() != 1 || !(cres < sres)) continue;
                        cres = sres;
                        bad_stn = i2;
                        bad_phsnm = phase.getPhaseName();
                    }
                    ++i2;
                }
                phase = this.getPhase(bad_stn, bad_phsnm);
                if (phase != null) {
                    phase.setWeight(0);
                    logger.info((Object)("remove phase: " + phase));
                }
            }
            ++n;
            stn = this.getUsedStation();
            this.findSourceLoc();
            logger.info((Object)("residual: " + this.sourceParam.rms));
        } while (!(!Double.isNaN(this.sourceParam.rms) && this.sourceParam.rms < minResidual && this.sourceParam.rms > 0.01) && stn >= minStn);
        logger.info((Object)"Step 1, After remove bad phase, Location Result: ");
        this.printSourceParam(this.sourceParam);
        String[] choosePhs = new String[]{"Pn", "Pg", "P", "Sn", "Sg", "S"};
        int i3 = 0;
        while (i3 < phases.length) {
            Enu = this.stnPhases[i3].elements();
            while (Enu.hasMoreElements()) {
                phase = (Phase)Enu.nextElement();
                if (phase.getPhaType() != 0) continue;
                String origPh = phase.getPhaseName();
                double origRsdl = Math.abs(this.getDetailResidual(i3, phase.getPhaseName()));
                logger.info((Object)("origRsdl=" + origRsdl));
                int j = 0;
                while (j < choosePhs.length) {
                    if (!phase.getPhaseName().equals(choosePhs[j])) {
                        Phase tmp = this.getPhase(i3, choosePhs[j]);
                        if (tmp != null) {
                            String tmpPh = tmp.getPhaseName();
                            double tmpRsdl = Math.abs(this.getDetailResidual(i3, tmp.getPhaseName()));
                            tmp.setPhaseName("XXX");
                            phase.setPhaseName(choosePhs[j]);
                            double newRsdl = Math.abs(this.getDetailResidual(i3, phase.getPhaseName()));
                            logger.info((Object)("tmpRsdl=" + tmpRsdl + ",newRsdl=" + newRsdl));
                            if (newRsdl < tmpRsdl && newRsdl < origRsdl) {
                                tmp.setPhaseName(origPh);
                                logger.info((Object)(tmp + " change from " + tmpPh));
                                logger.info((Object)(phase + " change from " + origPh));
                                origPh = phase.getPhaseName();
                                origRsdl = Math.abs(this.getDetailResidual(i3, phase.getPhaseName()));
                            } else {
                                phase.setPhaseName(origPh);
                                tmp.setPhaseName(tmpPh);
                            }
                        } else {
                            phase.setPhaseName(choosePhs[j]);
                            double rsdl = Math.abs(this.getDetailResidual(i3, phase.getPhaseName()));
                            if (rsdl >= origRsdl) {
                                phase.setPhaseName(origPh);
                            } else {
                                logger.info((Object)("rsdl=" + rsdl));
                                logger.info((Object)(phase + " change from " + origPh));
                                origPh = phase.getPhaseName();
                                origRsdl = Math.abs(this.getDetailResidual(i3, phase.getPhaseName()));
                            }
                        }
                    }
                    ++j;
                }
                this.findSourceLoc();
                logger.info((Object)("residual: " + this.sourceParam.rms));
                if (!Double.isNaN(this.sourceParam.rms) && this.sourceParam.rms < minResidual && !(this.sourceParam.rms > 0.01)) continue;
            }
            ++i3;
        }
        logger.info((Object)"Step 2, after switch phase name, Location Result: ");
        this.printSourceParam(this.sourceParam);
        i3 = 0;
        while (i3 < phases.length) {
            Enu = this.stnPhases[i3].elements();
            while (Enu.hasMoreElements()) {
                phase = (Phase)Enu.nextElement();
                if (phase.getPhaType() != 0 || phase.getWeight() != 0) continue;
                phase.setWeight(1);
                stn = this.getUsedStation();
                this.findSourceLoc();
                logger.info((Object)("residual: " + this.sourceParam.rms));
                if (!Double.isNaN(this.sourceParam.rms) && this.sourceParam.rms < minResidual && this.sourceParam.rms > 0.01) {
                    logger.info((Object)(phase + " set Weight 1"));
                    continue;
                }
                phase.setWeight(0);
            }
            ++i3;
        }
        logger.info((Object)"Step 3, after put good phase back, Location Result: ");
        this.printSourceParam(this.sourceParam);
        return this.getSourceParam();
    }

    public int getUsedStation() {
        int stn = 0;
        Vector<Phase>[] phases = this.getStnPhases();
        int i = 0;
        while (i < phases.length) {
            Enumeration Enu = this.stnPhases[i].elements();
            while (Enu.hasMoreElements()) {
                Phase phase = (Phase)Enu.nextElement();
                if (phase.getWeight() != 1 || phase.getPhaType() != 0) continue;
                ++stn;
                break;
            }
            ++i;
        }
        return stn;
    }

    private void printSourceParam(SourceParam res) {
        logger.info((Object)("The Residual is: " + res.getRms()));
        logger.info((Object)("OTime = " + res.getOriginTime()));
        logger.info((Object)("Lontidude = " + DoubleFormat.toString((double)res.getLon(), (int)2)));
        logger.info((Object)("Latidude = " + DoubleFormat.toString((double)res.getLat(), (int)2)));
        logger.info((Object)("ML = " + DoubleFormat.toString((double)res.getMl(), (int)2)));
        logger.info((Object)("Ms = " + DoubleFormat.toString((double)res.getMs(), (int)2)));
        logger.info((Object)("Depth = " + DoubleFormat.toString((double)res.getDepth(), (int)2)));
        logger.info((Object)String.format("AzimuthGaps = %.0f" + res.getGapAzi(), new Object[0]));
    }

    @Override
    public abstract boolean findSourceLoc();

    @Override
    public SourceParam getSourceParam() {
        this.getML();
        this.getMs();
        this.getMb();
        if (Double.isNaN(this.sourceParam.getRms())) {
            this.sourceParam.setRms(-99999.0);
        }
        if (this.sourceParam.ms > 0.0) {
            this.sourceParam.setM(this.sourceParam.getMs());
            this.sourceParam.setMSource("Ms");
        } else {
            this.sourceParam.setM(CalMagnitude.Ml2Ms(this.sourceParam.getMl()));
            this.sourceParam.setMSource("ML");
        }
        if (Double.isNaN(this.sourceParam.getErh())) {
            this.sourceParam.setQloc("0");
        } else if (this.sourceParam.getErh() <= 5.0) {
            this.sourceParam.setQloc("1");
        } else if (this.sourceParam.getErh() <= 15.0) {
            this.sourceParam.setQloc("2");
        } else if (this.sourceParam.getErh() <= 30.0) {
            this.sourceParam.setQloc("3");
        } else {
            this.sourceParam.setQloc("4");
        }
        return this.sourceParam;
    }

    @Override
    public OutputInfoForLoc getOutputInfoForLoc() {
        OutputInfoForLoc outputInfoForLoc = new OutputInfoForLoc();
        double[] ML = new double[this.getStnSum()];
        double[] Ms = new double[this.getStnSum()];
        double[] Mb = new double[this.getStnSum()];
        double[] delta = new double[this.getStnSum()];
        int i = 0;
        while (i < this.getStnSum()) {
            ML[i] = this.getDetailMl(i);
            Ms[i] = this.getDetailMs(i);
            Mb[i] = this.getDetailMb(i);
            delta[i] = this.getDetailDelta(i);
            Enumeration Enu = this.stnPhases[i].elements();
            while (Enu.hasMoreElements()) {
                Phase phase = (Phase)Enu.nextElement();
                phase.setDistance((float)delta[i]);
            }
            ++i;
        }
        outputInfoForLoc.setDetailDelta(delta);
        outputInfoForLoc.setDetailML(ML);
        outputInfoForLoc.setDetailMs(Ms);
        outputInfoForLoc.setDetailMb(Mb);
        outputInfoForLoc.setLocPhaSum(this.getLocPhaSum());
        outputInfoForLoc.setLocStnSum(this.getStnSum());
        outputInfoForLoc.setSource(this.getSourceParam());
        return outputInfoForLoc;
    }

    public double getDetailDelta(int stn) {
        double stnLat = this.getStnLocations()[stn].getLat();
        double stnLon = this.getStnLocations()[stn].getLon();
        double srcLat = this.sourceParam.lat;
        double srcLon = this.sourceParam.lon;
        double delta = SphereUtil.distOnSphere((double)stnLat, (double)stnLon, (double)srcLat, (double)srcLon) * 111.19;
        return delta;
    }

    public double getDetailAzimuth(int stn) {
        double stnLat = this.getStnLocations()[stn].getLat();
        double stnLon = this.getStnLocations()[stn].getLon();
        double srcLat = this.sourceParam.lat;
        double srcLon = this.sourceParam.lon;
        SphereUtil.DELTAI deltai = SphereUtil.deltai((double)srcLat, (double)srcLon, (double)stnLat, (double)stnLon);
        return deltai.az1;
    }

    public double getDetailMl(int stn) {
        Phase phaseN;
        Phase phaseE;
        double delta = this.getDetailDelta(stn);
        double azimuth = this.getDetailAzimuth(stn);
        Phase phaseZ = this.getPhase(stn, "SMZ");
        if (phaseZ != null && phaseZ.getWeight() == 0) {
            phaseZ = null;
        }
        if ((phaseE = this.getPhase(stn, "SME")) != null && phaseE.getWeight() == 0) {
            phaseE = null;
        }
        if ((phaseN = this.getPhase(stn, "SMN")) != null && phaseN.getWeight() == 0) {
            phaseN = null;
        }
        double ml = (float)this.magnitudeInf.getML(phaseZ, phaseE, phaseN, delta);
        if (phaseN != null) {
            phaseN.setMagName("ML");
            phaseN.setMagVal((float)ml);
            phaseN.setDistance((float)delta);
            phaseN.setAzimuth((float)azimuth);
        }
        if (phaseE != null) {
            phaseE.setMagName("ML");
            phaseE.setMagVal((float)ml);
            phaseE.setDistance((float)delta);
            phaseE.setAzimuth((float)azimuth);
        }
        if (phaseZ != null) {
            phaseZ.setMagName("ML");
            phaseZ.setMagVal((float)ml);
            phaseZ.setDistance((float)delta);
            phaseZ.setAzimuth((float)azimuth);
        }
        return ml;
    }

    public double getDetailMs(int stn) {
        Phase phaseN;
        Phase phaseE;
        double delta = this.getDetailDelta(stn);
        double azimuth = this.getDetailAzimuth(stn);
        Phase phaseZ = this.getPhase(stn, "LZ");
        if (phaseZ != null && phaseZ.getWeight() == 0) {
            phaseZ = null;
        }
        if ((phaseE = this.getPhase(stn, "LE")) != null && phaseE.getWeight() == 0) {
            phaseE = null;
        }
        if ((phaseN = this.getPhase(stn, "LN")) != null && phaseN.getWeight() == 0) {
            phaseN = null;
        }
        double Ms = this.magnitudeInf.getMs(phaseZ, phaseE, phaseN, this.getDetailDelta(stn));
        if (phaseN != null) {
            phaseN.setMagName("Ms");
            phaseN.setMagVal((float)Ms);
            phaseN.setDistance((float)delta);
            phaseN.setAzimuth((float)azimuth);
        }
        if (phaseE != null) {
            phaseE.setMagName("Ms");
            phaseE.setMagVal((float)Ms);
            phaseE.setDistance((float)delta);
            phaseE.setAzimuth((float)azimuth);
        }
        if (phaseZ != null) {
            phaseZ.setMagName("Ms");
            phaseZ.setMagVal((float)Ms);
            phaseZ.setDistance((float)delta);
            phaseZ.setAzimuth((float)azimuth);
        }
        return Ms;
    }

    public double getDetailMb(int stn) {
        double delta = this.getDetailDelta(stn);
        double azimuth = this.getDetailAzimuth(stn);
        Phase phaseZ = this.getPhase(stn, "PMZ");
        if (phaseZ != null && phaseZ.getWeight() == 0) {
            phaseZ = null;
        }
        if (phaseZ == null) {
            return Double.NaN;
        }
        double mb = this.magnitudeInf.getMb(phaseZ.getAmp(), phaseZ.getPeriod(), delta / 111.19, phaseZ.getRecType());
        phaseZ.setMagVal((float)mb);
        phaseZ.setMagName("mb");
        phaseZ.setDistance((float)delta);
        phaseZ.setAzimuth((float)azimuth);
        return mb;
    }

    public Date getDetailOriginTime(int stn) {
        Vector<Phase> stnPhases = this.getStnPhases(stn);
        Vector<Phase> sv = new Vector<Phase>();
        for (Phase p : stnPhases) {
            if (p.getPhaType() != 0) continue;
            sv.add(p);
        }
        int size = sv.size();
        if (size < 2) {
            return null;
        }
        Collections.sort(sv);
        Phase fp = (Phase)sv.get(0);
        Phase lp = (Phase)sv.get(size - 1);
        double difTime = (double)lp.getPhaseTime().getTime() / 1000.0 - (double)fp.getPhaseTime().getTime() / 1000.0;
        String strPhaseType = String.valueOf(fp.getPhaseName()) + "," + lp.getPhaseName();
        double delta = this.computedTravelTime.calDelta(this.sourceParam.depth, difTime, strPhaseType);
        if (Double.isNaN(delta)) {
            return null;
        }
        double trvlTime = this.computedTravelTime.calTravelTime(this.sourceParam.depth, delta, fp.getPhaseName());
        if (Double.isNaN(trvlTime)) {
            return null;
        }
        return new Date(fp.getPhaseTime().getTime() - (long)(trvlTime * 1000.0));
    }

    public double getDetailResidual(int stn, String phaseName) {
        double residual = Double.NaN;
        try {
            Phase phase = this.getPhase(stn, phaseName);
            StnLocation stnLoc = this.getStnLocations()[stn];
            double[] src = new double[]{this.sourceParam.lat, this.sourceParam.lon, this.sourceParam.depth};
            double[] sta = new double[]{stnLoc.getLat(), stnLoc.getLon(), stnLoc.getAlt()};
            double trvlTime = this.computedTravelTime.calTravelTime(src, sta, phaseName);
            if (Double.isNaN(trvlTime)) {
                residual = -999.0;
            } else {
                residual = phase.getPhaseTime().getTime() - (long)(trvlTime * 1000.0) - this.sourceParam.originTime.getTime();
                residual /= 1000.0;
            }
            phase.setResi((float)residual);
            phase.setDistance((int)this.getDetailDelta(stn));
            phase.setAzimuth((float)this.getDetailAzimuth(stn));
        }
        catch (IllegalArgumentException ex) {
            return Double.NaN;
        }
        return residual;
    }

    private String getDate(Date d) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        StringBuffer strBuffer = new StringBuffer();
        cs_printf P = new cs_printf(strBuffer);
        int month = c.get(2) + 1;
        P.printf("%4d-%02d-%02d", (Object)new Integer(c.get(1)), (Object)new Integer(month), (Object)new Integer(c.get(5)));
        return strBuffer.substring(0);
    }

    private String getTime(Date d) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        long t = d.getTime();
        double sec = (double)c.get(13) + (double)(t % 1000L) / 1000.0;
        StringBuffer strBuffer = new StringBuffer();
        cs_printf P = new cs_printf(strBuffer);
        P.printf("%02d:%02d:%04.2f", (Object)new Integer(c.get(11)), (Object)new Integer(c.get(12)), (Object)new Double(sec));
        return strBuffer.substring(0);
    }

    @Override
    public String getDetailLocationResult() {
        StringBuffer textArea = new StringBuffer();
        textArea.append("                    Locating Result of Earthquake:\n");
        textArea.append(" ******************************************************************************\n");
        String strTime = this.getTime(this.sourceParam.originTime);
        String strDate = this.getDate(this.sourceParam.originTime);
        textArea.append(" Origin Time  :  " + strDate + "        " + strTime + "\n");
        long latIntPart = (long)Math.floor(Math.abs(this.sourceParam.lat));
        double latDotPart = Math.abs(this.sourceParam.lat) - (double)latIntPart;
        long lonIntPart = (long)Math.floor(Math.abs(this.sourceParam.lon));
        double lonDotPart = Math.abs(this.sourceParam.lon) - (double)lonIntPart;
        StringBuffer strBuffer = new StringBuffer();
        cs_printf P = new cs_printf(strBuffer);
        P.printf(" Epicentre    :  %03d\u00b0%04.2f\u2032         %04d\u00b0%04.2f\u2032   \n", (Object)new Integer((int)this.sourceParam.lat), (Object)new Double(latDotPart *= 60.0), (Object)new Integer((int)this.sourceParam.lon), (Object)new Double(lonDotPart *= 60.0));
        P.printf(" Magnitude    :  %02.1f(ML)\t%02.1f(Ms)\t%02.1f(mb)\n", (Object)new Double(this.sourceParam.ml), (Object)new Double(this.sourceParam.ms), (Object)new Double(this.sourceParam.mb));
        textArea.append(strBuffer.substring(0));
        textArea.append(String.format(" Focal Depth  : %03.1f          Residual : %.3f\n", this.sourceParam.depth, this.sourceParam.rms));
        textArea.append("Epicentre Accuracy:   N/A(km)    Depth Accuracy:   N/A\n");
        textArea.append(String.format(" Azimuth Gaps : %.0f\n", this.sourceParam.getGapAzi()));
        textArea.append(String.format("%-5s %-8s %1s %-12s %-10s %-12s %-8s %7s %8s %5s %3s %3s\n", "No.", "Stname", " ", "Phase", "Date", "Time", "OTime", "t-res", "Delta", "ML", "Ms", "mb"));
        int i = 0;
        while (i < this.getStnSum()) {
            boolean first = true;
            Enumeration Enu = this.stnPhases[i].elements();
            while (Enu.hasMoreElements()) {
                Phase phase = (Phase)Enu.nextElement();
                try {
                    this.getPhaseType(phase.getPhaseName());
                }
                catch (IllegalArgumentException ex) {
                    continue;
                }
                if (first) {
                    first = false;
                    textArea.append(String.format("%-5d %-8s %1s %-12s", i, String.valueOf(phase.getNetCode()) + "/" + phase.getStationCode(), phase.getClarity(), String.valueOf(phase.getWeight() == 0 ? String.valueOf(phase.getPhaseName()) + "-" : phase.getPhaseName()) + " " + phase.getWsign()));
                    Date so = this.getDetailOriginTime(i);
                    if (so != null) {
                        GregorianCalendar c = new GregorianCalendar();
                        c.setTime(so);
                        float sec = (float)c.get(13) + (float)(so.getTime() % 1000L) / 1000.0f;
                        double del = this.getDetailDelta(i);
                        if (del / 111.19 > 5.0) {
                            textArea.append(String.format(" %1$tF %1$tT.%2$03d %3$02d-%4$05.2f %5$7.2f %6$8.2f\u00b0", phase.getPhaseTime(), phase.getPhaseTime().getTime() % 1000L, c.get(12), Float.valueOf(sec), this.getDetailResidual(i, phase.getPhaseName()), del /= 111.19));
                        } else {
                            textArea.append(String.format(" %1$tF %1$tT.%2$03d %3$02d-%4$05.2f %5$7.2f %6$8.2fkm", phase.getPhaseTime(), phase.getPhaseTime().getTime() % 1000L, c.get(12), Float.valueOf(sec), this.getDetailResidual(i, phase.getPhaseName()), del));
                        }
                    } else {
                        double del = this.getDetailDelta(i);
                        if (del / 111.19 > 5.0) {
                            textArea.append(String.format(" %1$tF %1$tT.%2$03d %3$-8s %4$7.2f %5$8.2f\u00b0", phase.getPhaseTime(), phase.getPhaseTime().getTime() % 1000L, "", this.getDetailResidual(i, phase.getPhaseName()), del /= 111.19));
                        } else {
                            textArea.append(String.format(" %1$tF %1$tT.%2$03d %3$-8s %4$7.2f %5$8.2fkm", phase.getPhaseTime(), phase.getPhaseTime().getTime() % 1000L, "", this.getDetailResidual(i, phase.getPhaseName()), del));
                        }
                    }
                    double ml = this.getDetailMl(i);
                    if (Double.isNaN(ml)) {
                        textArea.append("    ");
                    } else {
                        textArea.append(String.format("% 2.1f", ml));
                    }
                    double ms = this.getDetailMs(i);
                    if (Double.isNaN(ms)) {
                        textArea.append("    ");
                    } else {
                        textArea.append(String.format("% 2.1f", ms));
                    }
                    double mb = this.getDetailMb(i);
                    if (Double.isNaN(mb)) {
                        textArea.append("    ");
                    } else {
                        textArea.append(String.format("% 2.1f", mb));
                    }
                    textArea.append("\n");
                    continue;
                }
                textArea.append(String.format("%-5s %-8s %1s %-12s", " ", " ", " ", String.valueOf(phase.getWeight() == 0 ? String.valueOf(phase.getPhaseName()) + "-" : phase.getPhaseName()) + "  "));
                textArea.append(String.format(" %1$tF %1$tT.%2$03d %3$-8s %4$7.2f", phase.getPhaseTime(), phase.getPhaseTime().getTime() % 1000L, "", this.getDetailResidual(i, phase.getPhaseName())));
                textArea.append("\n");
            }
            ++i;
        }
        textArea.append(" ******************************************************************************\n");
        return new String(textArea);
    }

    private void getML() {
        ArrayList<Double> list = new ArrayList<Double>(256);
        double MLSum = 0.0;
        int MLCounts = 0;
        double ml = 0.0;
        int s = 0;
        while (s < this.stnPhases.length) {
            ml = this.getDetailMl(s);
            if (!Double.isNaN(ml)) {
                MLSum += ml;
                list.add(ml);
                ++MLCounts;
            }
            ++s;
        }
        if (MLCounts == 0) {
            this.sourceParam.ml = Double.NaN;
            return;
        }
        double avgM = MLSum / (double)MLCounts;
        int s2 = 0;
        while (s2 < this.stnPhases.length) {
            Phase phaseN;
            Phase phaseE;
            Phase phaseZ = this.getPhase(s2, "SMZ");
            if (phaseZ != null && phaseZ.getWeight() == 0) {
                phaseZ = null;
            }
            if ((phaseE = this.getPhase(s2, "SME")) != null && phaseE.getWeight() == 0) {
                phaseE = null;
            }
            if ((phaseN = this.getPhase(s2, "SMN")) != null && phaseN.getWeight() == 0) {
                phaseN = null;
            }
            if (phaseN != null) {
                phaseN.setResi((float)((double)phaseN.getMagVal() - avgM));
            }
            if (phaseE != null) {
                phaseE.setResi((float)((double)phaseE.getMagVal() - avgM));
            }
            if (phaseZ != null) {
                phaseZ.setResi((float)((double)phaseZ.getMagVal() - avgM));
            }
            ++s2;
        }
        double[] m = new double[list.size()];
        if (m.length > 1) {
            int i = 0;
            while (i < m.length) {
                m[i] = (Double)list.get(i);
                ++i;
            }
            this.sourceParam.setMlRms(ArrayMath.standardDeviation((double[])m));
        }
        this.sourceParam.ml = avgM;
    }

    private void getMs() {
        ArrayList<Double> list = new ArrayList<Double>(256);
        double MsSum = 0.0;
        int MsCounts = 0;
        double Ms = 0.0;
        int s = 0;
        while (s < this.stnPhases.length) {
            Ms = this.getDetailMs(s);
            if (!Double.isNaN(Ms)) {
                MsSum += Ms;
                list.add(Ms);
                ++MsCounts;
            }
            ++s;
        }
        if (MsCounts == 0) {
            this.sourceParam.ms = Double.NaN;
        }
        double avgM = MsSum / (double)MsCounts;
        int s2 = 0;
        while (s2 < this.stnPhases.length) {
            Phase phaseN;
            Phase phaseE;
            Phase phaseZ = this.getPhase(s2, "LZ");
            if (phaseZ != null && phaseZ.getWeight() == 0) {
                phaseZ = null;
            }
            if ((phaseE = this.getPhase(s2, "LE")) != null && phaseE.getWeight() == 0) {
                phaseE = null;
            }
            if ((phaseN = this.getPhase(s2, "LN")) != null && phaseN.getWeight() == 0) {
                phaseN = null;
            }
            if (phaseN != null) {
                phaseN.setResi((float)((double)phaseN.getMagVal() - avgM));
            }
            if (phaseE != null) {
                phaseE.setResi((float)((double)phaseE.getMagVal() - avgM));
            }
            if (phaseZ != null) {
                phaseZ.setResi((float)((double)phaseZ.getMagVal() - avgM));
            }
            ++s2;
        }
        double[] m = new double[list.size()];
        if (m.length > 1) {
            int i = 0;
            while (i < m.length) {
                m[i] = (Double)list.get(i);
                ++i;
            }
            this.sourceParam.setMsRms(ArrayMath.standardDeviation((double[])m));
        }
        this.sourceParam.ms = avgM;
    }

    private void getMb() {
        ArrayList<Double> list = new ArrayList<Double>(256);
        double mbSum = 0.0;
        int mbCounts = 0;
        double mb = 0.0;
        int s = 0;
        while (s < this.stnPhases.length) {
            mb = this.getDetailMb(s);
            if (!Double.isNaN(mb)) {
                mbSum += mb;
                list.add(mb);
                ++mbCounts;
            }
            ++s;
        }
        if (mbCounts == 0) {
            this.sourceParam.mb = Double.NaN;
            return;
        }
        double avgM = mbSum / (double)mbCounts;
        int s2 = 0;
        while (s2 < this.stnPhases.length) {
            Phase phaseZ = this.getPhase(s2, "PMZ");
            if (phaseZ != null && phaseZ.getWeight() == 0) {
                phaseZ = null;
            }
            if (phaseZ != null) {
                phaseZ.setResi((float)((double)phaseZ.getMagVal() - avgM));
            }
            ++s2;
        }
        double[] m = new double[list.size()];
        if (m.length > 1) {
            int i = 0;
            while (i < m.length) {
                m[i] = (Double)list.get(i);
                ++i;
            }
            this.sourceParam.setMbRms(ArrayMath.standardDeviation((double[])m));
        }
        this.sourceParam.mb = avgM;
    }

    public static float getGapAzi(List<Float> azimuth) {
        float gap = -1.0f;
        Collections.sort(azimuth);
        int size = azimuth.size();
        if (size < 2) {
            return gap;
        }
        int i = 1;
        while (i < size) {
            gap = Math.max(gap, azimuth.get(i).floatValue() - azimuth.get(i - 1).floatValue());
            ++i;
        }
        gap = Math.max(gap, azimuth.get(0).floatValue() + 360.0f - azimuth.get(size - 1).floatValue());
        return gap;
    }

    protected double getGapAzi() {
        ArrayList<Float> azimuth = new ArrayList<Float>();
        int i = 0;
        while (i < this.getStnSum()) {
            azimuth.add(Float.valueOf((float)this.getDetailAzimuth(i)));
            ++i;
        }
        return IterateNearloc.getGapAzi(azimuth);
    }

    @Override
    public void setComputedTravelTime(ComputedTravelTime newCompTT) {
        this.computedTravelTime = newCompTT;
    }

    @Override
    public void setMagnitudeInf(MagnitudeInf magnitudeInf) {
        this.magnitudeInf = magnitudeInf;
    }

    public ComputedTravelTime getComputedTravelTime() {
        return this.computedTravelTime;
    }

    public MagnitudeInf getMagnitudeInf() {
        return this.magnitudeInf;
    }
}

