/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.IterateNearloc;
import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.DataCovariance;
import cn.org.gddsn.seis.location.iscloc2.EC_COEF;
import cn.org.gddsn.seis.location.iscloc2.EllipticityCorr;
import cn.org.gddsn.seis.location.iscloc2.FE;
import cn.org.gddsn.seis.location.iscloc2.GeoRegion;
import cn.org.gddsn.seis.location.iscloc2.ISCEvent;
import cn.org.gddsn.seis.location.iscloc2.ISCHyp;
import cn.org.gddsn.seis.location.iscloc2.ISCPha;
import cn.org.gddsn.seis.location.iscloc2.ISCSol;
import cn.org.gddsn.seis.location.iscloc2.ISCSta;
import cn.org.gddsn.seis.location.iscloc2.ISFIO;
import cn.org.gddsn.seis.location.iscloc2.Locator;
import cn.org.gddsn.seis.location.iscloc2.MAGQ;
import cn.org.gddsn.seis.location.iscloc2.MSZH;
import cn.org.gddsn.seis.location.iscloc2.RDMAG;
import cn.org.gddsn.seis.location.iscloc2.STAMAG;
import cn.org.gddsn.seis.location.iscloc2.TT_TABLE;
import cn.org.gddsn.seis.location.iscloc2.TravelTimes;
import cn.org.gddsn.seis.location.iscloc2.Utils;
import cn.org.gddsn.seis.location.iscloc2.VarioGram;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Scanner;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class ISCLoc2
extends IterateNearloc {
    static Logger logger = Logger.getLogger(ISCLoc2.class);
    TT_TABLE[] tt_tables = null;
    EC_COEF[] ec = null;
    VarioGram variogram = new VarioGram();
    MAGQ mbQ = new MAGQ();
    STAMAG[] stamag_mb = null;
    STAMAG[] stamag_ms = null;
    RDMAG[] rdmag_mb = null;
    RDMAG[] rdmag_ms = null;
    MSZH[] mszh = null;
    FE fe = new FE();
    double[][] depthgrid = null;
    double[] grn_depth = null;
    short[][] topo = null;
    intW ismbQ = new intW(0);
    intW ngrid = new intW(0);
    intW num_ecphases = new intW(0);
    doubleW gres = new doubleW(1.0);
    private EvtData evtData;
    private ISCEvent e;
    private ISCSol s;
    private ISCHyp[] h = null;
    private ISCPha[] p = null;
    private String configDirectory;
    private String instructionFile = "work/instruction.conf";

    public boolean findSourceLoc() {
        this.doISCLoc2();
        if (this.s.converged == 0 || this.s.diverging == 1) {
            logger.warn((Object)"location not convergence reached or the solution is diverging!");
            return false;
        }
        this.sourceParam.setGapAzi(this.s.azimgap);
        Date otime = new Date((long)(this.s.time * 1000.0));
        this.sourceParam.setOriginTime(otime);
        this.sourceParam.setOriginTimeError(this.s.error[0]);
        this.sourceParam.setLat(this.s.lat);
        this.sourceParam.setLon(this.s.lon);
        this.sourceParam.setDepth(this.s.depth);
        this.sourceParam.setErh(this.s.error[1] * 111.19);
        if (this.s.error[3] != 9999999.0) {
            this.sourceParam.setErz(this.s.error[3]);
        } else {
            this.sourceParam.setErz(-99999.0);
        }
        this.sourceParam.setRms(this.s.sdobs);
        this.sourceParam.setMb(this.s.bodymag);
        this.sourceParam.setMs(this.s.surfmag);
        this.sourceParam.setMl(Double.NaN);
        this.sourceParam.setOperator("ISCLoc2");
        Vector<Phase>[] vec = this.getStnPhases();
        int i = 0;
        while (i < vec.length) {
            block1: for (Phase ph : vec[i]) {
                if (ph.getPhaType() != 0) continue;
                String sta = String.valueOf(ph.getNetCode()) + "." + ph.getStationCode() + ph.getPhaseName();
                int j = 0;
                while (j < this.p.length) {
                    String sta1 = String.valueOf(this.p[j].sta) + this.p[j].rep_phase;
                    if (sta.equals(sta1)) {
                        ph.setAzimuth((float)this.p[j].esaz);
                        ph.setDistance((float)this.p[j].delta);
                        ph.setWeight(this.p[j].timedef ? 1 : 0);
                        if (ph.getWeight() != 0) {
                            ph.setResi((float)this.p[j].resid);
                            continue block1;
                        }
                        ph.setResi(-9.99f);
                        continue block1;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    public String getDetailLocationResult() {
        String buf = super.getDetailLocationResult();
        return String.valueOf(buf) + "\n" + this.printISCSol(this.s) + Utils.print_pha(this.s.numphas, this.p);
    }

    private String printISCSol(ISCSol s) {
        StringBuffer sb = new StringBuffer(2048);
        sb.append(String.format("time                     lat     lon     depth  sdef ndef nass gap  mindist stime sdep  smaj  score\n", new Object[0]));
        String timestr = Utils.human_time(s.time);
        sb.append(String.format("%s ", timestr));
        sb.append(String.format("%7.3f %8.3f ", s.lat, s.lon));
        if (s.depth != 9999999.0) {
            sb.append(String.format("%5.1f  ", s.depth));
        } else {
            sb.append(String.format("%5s  ", ""));
        }
        if (s.ndefsta != 9999999) {
            sb.append(String.format("%4d ", s.ndefsta));
        } else {
            sb.append(String.format("%4s ", ""));
        }
        if (s.ndef != 9999999) {
            sb.append(String.format("%4d ", s.ndef));
        } else {
            sb.append(String.format("%4s ", ""));
        }
        if (s.nass != 9999999) {
            sb.append(String.format("%4d ", s.nass));
        } else {
            sb.append(String.format("%4s ", ""));
        }
        if (s.azimgap != 9999999.0) {
            sb.append(String.format("%5.1f ", s.azimgap));
        } else {
            sb.append(String.format("%5s ", ""));
        }
        if (s.mindist != 9999999.0) {
            sb.append(String.format("%6.2f ", s.mindist));
        } else {
            sb.append(String.format("%6s ", ""));
        }
        if (s.error[0] != 9999999.0) {
            sb.append(String.format("%5.2f ", s.error[0]));
        } else {
            sb.append(String.format("%5s ", ""));
        }
        if (s.error[3] != 9999999.0) {
            sb.append(String.format("%5.2f ", s.error[3]));
        } else {
            sb.append(String.format("%5s ", ""));
        }
        if (s.smajax != 9999999.0) {
            sb.append(String.format("%5.1f ", s.smajax));
        } else {
            sb.append(String.format("%5s ", ""));
        }
        sb.append(String.format("%5d\n\n", s.prank));
        return sb.substring(0);
    }

    public double getDetailResidual(int stn, String phaseName) {
        Phase phase = this.getPhase(stn, phaseName);
        if (phase == null) {
            return -99999.0;
        }
        return phase.getResi();
    }

    public SourceParam getSourceParam() {
        SourceParam sp = super.getSourceParam();
        sp.setLocProgram("ISCLoc2");
        return sp;
    }

    public EvtData getEvtData() {
        return this.evtData;
    }

    public void setEvtData(EvtData evtData) {
        this.evtData = evtData;
    }

    public boolean readConfigFile() {
        String configfile = String.format("%s/iscloc/config.txt", this.configDirectory);
        System.out.printf("read_config: %s (%.2f)", configfile, Utils.secs(Utils.t0));
        if (Config.read_config(configfile) != 0) {
            System.err.printf("EVENT %.6f\n", Utils.secs(Utils.t0));
            return false;
        }
        logger.info((Object)String.format("read_data_files (%.2f)", Utils.secs(Utils.t0)));
        Config.DataStruct ds = new Config.DataStruct();
        ds.ismbQ = this.ismbQ;
        ds.mbQp = this.mbQ;
        ds.fep = this.fe;
        ds.gres = this.gres;
        ds.ngrid = this.ngrid;
        ds.num_ecphases = this.num_ecphases;
        ds.variogramp = this.variogram;
        if (Config.read_data_files(this.configDirectory, ds) != 0) {
            logger.info((Object)String.format("EVENT %.6f\n", Utils.secs(Utils.t0)));
            return false;
        }
        this.grn_depth = ds.grn_depth;
        this.depthgrid = ds.depthgrid;
        this.topo = ds.topo;
        this.ec = ds.ec;
        this.tt_tables = ds.tt_tables;
        return true;
    }

    private boolean doISCLoc2() {
        BufferedInputStream isfin = null;
        PrintWriter isfout = null;
        this.e = new ISCEvent();
        this.s = new ISCSol();
        this.h = null;
        this.p = null;
        intW total = new intW(0);
        intW fail = new intW(0);
        int[] opt = new int[7];
        int isf = 1;
        int database = 0;
        int i = 0;
        while (i < 7) {
            opt[i] = 0;
            ++i;
        }
        double t00 = (double)System.currentTimeMillis() / 1000.0;
        Utils.t0 = (double)System.currentTimeMillis() / 1000.0;
        Config.verbose = 0;
        Config.errorcode = 0;
        if (this.tt_tables == null && !this.readConfigFile()) {
            return false;
        }
        this.e.evid = 9999999;
        this.e.depth_agency = "";
        this.e.location_agency = "";
        this.e.time_agency = "";
        this.e.hypo_agency = "";
        this.e.start_time = 9999999.0;
        this.e.start_depth = 9999999.0;
        this.e.start_lon = 9999999.0;
        this.e.start_lat = 9999999.0;
        this.e.hypo_fix = false;
        this.e.surface_fix = false;
        this.e.depth_fix = false;
        this.e.time_fix = false;
        this.e.epi_fix = false;
        this.e.depth_fix_editor = false;
        this.e.fix_depth_depdp = false;
        this.e.fix_depth_default = false;
        String instruction = this.readInstruction();
        logger.info((Object)String.format("Instruction: %s", instruction));
        Config.parse_instruction(instruction, this.e, isf);
        if (!this.write_stafile() || !this.write_isf()) {
            logger.warn((Object)String.format("write_stafile or write_isf error", new Object[0]));
            logger.info((Object)String.format("EVENT %.6f\n", Utils.secs(Utils.t0)));
            return false;
        }
        if (Config.verbose > 0) {
            logger.info((Object)String.format("    read_stafile", new Object[0]));
        }
        if ((Config.stationlist = ISFIO.read_stafile()) == null) {
            logger.warn((Object)String.format("read_stafile: %s", ISFIO.isf_error));
            logger.info((Object)String.format("EVENT %.6f\n", Utils.secs(Utils.t0)));
            return false;
        }
        try {
            isfin = new BufferedInputStream(new FileInputStream(Config.isf_infile));
        }
        catch (IOException ex) {
            logger.warn((Object)String.format("Cannot open isf input file %s", Config.isf_infile));
            logger.info((Object)String.format("EVENT %.6f\n", Utils.secs(Utils.t0)));
            return false;
        }
        try {
            isfout = new PrintWriter(new FileWriter(Config.isf_outfile));
        }
        catch (IOException ex) {
            logger.warn((Object)String.format("Cannot open isf output file %s", Config.isf_outfile));
            logger.info((Object)String.format("EVENT %.6f\n", Utils.secs(Utils.t0)));
            return false;
        }
        ISFIO.ISFStruct isfs = new ISFIO.ISFStruct();
        isfs.ep = this.e;
        isfs.hp = this.h;
        isfs.pp = this.p;
        isfs.stamag_mb = this.stamag_mb;
        isfs.stamag_ms = this.stamag_ms;
        isfs.rdmag_mb = this.rdmag_mb;
        isfs.rdmag_ms = this.rdmag_ms;
        isfs.mszh = this.mszh;
        isfs.stationlist = Config.stationlist;
        Scanner sc = new Scanner(isfin);
        String delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|\\p{javaWhitespace}+)+";
        sc.useDelimiter(delimiter);
        while (ISFIO.read_isf(sc, isfs) == 0) {
            this.h = isfs.hp;
            this.p = isfs.pp;
            this.stamag_mb = isfs.stamag_mb;
            this.stamag_ms = isfs.stamag_ms;
            this.rdmag_mb = isfs.rdmag_mb;
            this.rdmag_ms = isfs.rdmag_ms;
            this.mszh = isfs.mszh;
            if (Config.verbose > 0) {
                logger.info((Object)String.format("    eventloc (%.2f)", Utils.secs(Utils.t0)));
            }
            if (Locator.eventloc(isf, database, total, fail, opt, this.e, this.h, this.s, this.p, this.stamag_mb, this.stamag_ms, this.rdmag_mb, this.rdmag_ms, this.mszh, this.ismbQ.val, this.mbQ, this.ec, this.tt_tables, this.variogram, this.gres.val, this.ngrid.val, this.depthgrid, this.fe, this.grn_depth, this.topo, isfout) != 0) {
                logger.warn((Object)String.format("CAUTION: No solution found due to %s", Config.errorcodes[Config.errorcode]));
            }
            logger.info((Object)String.format("EVENT %.6f %d %d", Utils.secs(Utils.t0), this.e.evid, this.s.numphas));
            logger.info((Object)String.format("\n", new Object[0]));
        }
        logger.info((Object)String.format("Totals: option 0: %d, 1: %d, 2: %d 3: %d, 4: %d, 5: %d converged: %d failed: %d time %.2f", opt[0], opt[1], opt[2], opt[3], opt[4], opt[5], total.val, fail.val, Utils.secs(t00)));
        try {
            sc.close();
            ((InputStream)isfin).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (Config.isf_outfile.length() != 0) {
            isfout.close();
        }
        return true;
    }

    private String readInstruction() {
        String instruction = "";
        Scanner sc = null;
        try {
            sc = new Scanner(new File(this.instructionFile));
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return instruction;
        }
        String delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|\\p{javaWhitespace}+)+";
        sc.useDelimiter(delimiter);
        try {
            instruction = sc.nextLine();
        }
        catch (Exception ex) {
            instruction = "";
        }
        sc.close();
        return instruction;
    }

    public void free() {
        Config.stationlist = null;
        GeoRegion.free_fe(this.fe);
        this.depthgrid = null;
        this.topo = null;
        this.grn_depth = null;
        if (this.tt_tables != null) {
            TravelTimes.free_tt_tbl(this.tt_tables);
        }
        if (this.ec != null) {
            EllipticityCorr.free_elcor_tbl(this.ec, this.num_ecphases.val);
        }
        if (this.ismbQ.val != 0) {
            this.mbQ.deltas = null;
            this.mbQ.depths = null;
            this.mbQ.q = null;
        }
        DataCovariance.free_variogram(this.variogram);
    }

    public String getConfigDirectory() {
        return this.configDirectory;
    }

    public void setConfigDirectory(String configDirectory) {
        this.configDirectory = configDirectory;
    }

    public String getInstructionFile() {
        return this.instructionFile;
    }

    public void setInstructionFile(String instructionFile) {
        this.instructionFile = instructionFile;
    }

    private boolean write_stafile() {
        String[] stns = this.evtData.getAllNetStation();
        ISCSta[] ps = new ISCSta[stns.length];
        int i = 0;
        while (i < stns.length) {
            ps[i] = new ISCSta();
            int idx = stns[i].indexOf(47);
            int[] chn = this.evtData.getChanOrder(stns[i].substring(0, idx), stns[i].substring(idx + 1));
            int c = chn[0];
            ps[i].sta = String.valueOf(this.evtData.getNetworkCode(c)) + "." + this.evtData.getStationCode(c);
            ps[i].altsta = String.valueOf(this.evtData.getNetworkCode(c)) + "." + this.evtData.getStationCode(c);
            ps[i].lat = this.evtData.getStationLocation(c).getLatitude();
            ps[i].lon = this.evtData.getStationLocation(c).getLongtitude();
            ps[i].elev = this.evtData.getStationLocation(c).getAltitude() * 1000.0;
            ++i;
        }
        return ISFIO.write_stafile(ps);
    }

    private boolean write_isf() {
        RDMAG[] rdmag_mb = null;
        RDMAG[] rdmag_ms = null;
        int grn = 0;
        this.e.evid = 9999999;
        this.e.depth_agency = "";
        this.e.location_agency = "";
        this.e.time_agency = "";
        this.e.hypo_agency = "";
        this.e.start_time = 9999999.0;
        this.e.start_depth = 9999999.0;
        this.e.start_lon = 9999999.0;
        this.e.start_lat = 9999999.0;
        this.e.hypo_fix = false;
        this.e.surface_fix = false;
        this.e.depth_fix = false;
        this.e.time_fix = false;
        this.e.epi_fix = false;
        this.e.depth_fix_editor = false;
        this.e.fix_depth_depdp = false;
        this.e.fix_depth_default = false;
        this.e.evid = 1;
        Vector<String> phsVec = new Vector<String>(16);
        String[] stringArray = Config.phaseTT;
        int n = Config.phaseTT.length;
        int n2 = 0;
        while (n2 < n) {
            String ph = stringArray[n2];
            phsVec.add(ph);
            ++n2;
        }
        int tch = this.evtData.getTCN();
        int numData = 0;
        int i = 0;
        while (i < tch) {
            Vector<Phase> phs = this.evtData.getPhases(i);
            for (Phase p : phs) {
                if (p.getPhaType() != 0 || !phsVec.contains(p.getPhaseName())) continue;
                ++numData;
            }
            ++i;
        }
        this.e.numphas = numData;
        this.e.numhyps = 1;
        SourceParam sparam = EvtData.source;
        this.s = new ISCSol();
        this.s.converged = 0;
        this.s.diverging = 0;
        this.s.numphas = this.e.numphas;
        this.s.hypid = 0;
        this.s.time = (double)sparam.getOriginTime().getTime() / 1000.0;
        this.s.lat = sparam.getLat();
        this.s.lon = sparam.getLon();
        this.s.depth = sparam.getDepth();
        this.s.depdp = 9999999.0;
        this.s.ndp = 0;
        this.s.depdp_error = 9999999.0;
        this.s.wrms = 0.0;
        this.s.urms = 0.0;
        this.s.strike = 9999999.0;
        this.s.sminax = 9999999.0;
        this.s.smajax = 9999999.0;
        this.s.sdobs = 9999999.0;
        this.s.nass = this.s.ndef = sparam.getLocPha();
        this.s.ndefsta = 0;
        this.s.nreading = 0;
        this.s.prank = 0;
        this.s.azimgap = 9999999.0;
        this.s.maxdist = 9999999.0;
        this.s.mindist = 9999999.0;
        this.s.surfmag = 0.0;
        this.s.bodymag = 0.0;
        this.s.surfmag_uncertainty = 0.0;
        this.s.bodymag_uncertainty = 0.0;
        this.s.nass_ms = 0;
        this.s.nass_mb = 0;
        this.s.nsta_ms = 0;
        this.s.nsta_mb = 0;
        this.s.nMsagency = 0;
        this.s.nmbagency = 0;
        this.s.epifix = this.e.epi_fix;
        this.s.timfix = this.e.time_fix;
        this.s.depfix = this.e.depth_fix;
        this.h = new ISCHyp[this.e.numhyps];
        int i2 = 0;
        while (i2 < this.e.numhyps) {
            this.h[i2] = new ISCHyp();
            this.h[i2].hypid = i2;
            this.h[i2].time = (double)sparam.getOriginTime().getTime() / 1000.0;
            this.h[i2].lat = sparam.getLat();
            this.h[i2].lon = sparam.getLon();
            this.h[i2].depth = sparam.getDepth();
            this.h[i2].nsta = sparam.getLocStn();
            this.h[i2].ndefsta = 9999999;
            this.h[i2].nass = this.h[i2].ndef = sparam.getLocPha();
            this.h[i2].azimgap = 9999999.0;
            this.h[i2].maxdist = 9999999.0;
            this.h[i2].mindist = 9999999.0;
            this.h[i2].etype = " ";
            this.h[i2].agency = Config.out_agency;
            this.h[i2].sdobs = 9999999.0;
            this.h[i2].stime = sparam.getOriginTimeError();
            this.h[i2].sdepth = sparam.getErz();
            this.h[i2].strike = 9999999.0;
            this.h[i2].smajax = 9999999.0;
            this.h[i2].sminax = 9999999.0;
            this.h[i2].timfix = false;
            this.h[i2].epifix = false;
            this.h[i2].depfix = false;
            this.h[i2].ignorehypo = 9999999;
            this.h[i2].rank = 9999999;
            ++i2;
        }
        this.p = new ISCPha[this.e.numphas];
        int j = 0;
        int i3 = 0;
        while (i3 < tch) {
            Vector<Phase> phs = this.evtData.getPhases(i3);
            for (Phase ph : phs) {
                String cp;
                if (ph.getPhaType() != 0 || !phsVec.contains(ph.getPhaseName())) continue;
                this.p[j] = new ISCPha();
                this.p[j].hypid = 0;
                this.p[j].rdid = this.p[j].rdid = j + 1;
                this.p[j].init = 1;
                this.p[j].repid = 9999999;
                this.p[j].rep_phase = this.p[j].phase = ph.getPhaseName();
                this.p[j].sta = this.p[j].prista = String.valueOf(ph.getNetCode()) + "." + ph.getStationCode();
                this.p[j].sta_lat = this.evtData.getStationLocation(i3).getLatitude();
                this.p[j].sta_lon = this.evtData.getStationLocation(i3).getLongtitude();
                this.p[j].sta_elev = this.evtData.getStationLocation(i3).getAltitude();
                this.p[j].time = (double)ph.getPhaseTime().getTime() / 1000.0;
                this.p[j].slow = 9999999.0;
                this.p[j].azim = ph.getAzimuth();
                if (this.p[j].azim < 0.0) {
                    this.p[j].azim = 9999999.0;
                }
                this.p[j].seaz = 9999999.0;
                this.p[j].esaz = 9999999.0;
                this.p[j].delta = ph.getDistance() / 111.19f;
                if (this.p[j].delta < 0.0) {
                    this.p[j].delta = 0.0;
                }
                if ((cp = ph.getChanCode()).endsWith("E")) {
                    this.p[j].comp = (char)69;
                } else if (cp.endsWith("N")) {
                    this.p[j].comp = (char)78;
                } else if (cp.endsWith("Z")) {
                    this.p[j].comp = (char)90;
                }
                this.p[j].sp_fm = (char)95;
                this.p[j].detchar = (char)32;
                this.p[j].phase_fixed = false;
                this.p[j].timedef = true;
                this.p[j].force_undef = false;
                this.p[j].resid = ph.getResi();
                if (this.p[j].resid < -999.0) {
                    this.p[j].resid = 9999999.0;
                }
                this.p[j].numamps = 0;
                ++j;
            }
            ++i3;
        }
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(Config.isf_infile));
            ISFIO.write_isf(pw, this.e, this.s, this.h, this.p, rdmag_mb, rdmag_ms, grn);
            pw.close();
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            return false;
        }
        return true;
    }
}

