/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.IterateNearloc;
import cn.org.gddsn.seis.location.iscloc.Config;
import cn.org.gddsn.seis.location.iscloc.ISCEvent;
import cn.org.gddsn.seis.location.iscloc.ISCHyp;
import cn.org.gddsn.seis.location.iscloc.ISCPha;
import cn.org.gddsn.seis.location.iscloc.ISCSol;
import cn.org.gddsn.seis.location.iscloc.ISFIO;
import cn.org.gddsn.seis.location.iscloc.Mag;
import cn.org.gddsn.seis.location.iscloc.PhaseId;
import cn.org.gddsn.seis.location.iscloc.Solve;
import cn.org.gddsn.seis.location.iscloc.Utils;
import cn.org.gddsn.seis.location.iscloc.Weight;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ISCLoc
extends IterateNearloc {
    static Logger logger = Logger.getLogger(ISCLoc.class);
    private String configFile = "./config.txt";
    private EvtData evtData;
    private ISFIO.ISC_DATA isc_data = new ISFIO.ISC_DATA();
    private ISCEvent e;
    private ISCSol s;
    private ISCHyp[] h;
    private ISCPha[] p;

    public ISCLoc() {
        this.e = this.isc_data.ep;
        this.s = this.isc_data.sol;
        this.h = null;
        this.p = null;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    private void setInputInfo() {
        ISCPha temp_pha;
        this.e.evid = 9999999;
        this.e.seed_agency = "";
        this.e.depth_agency = "";
        this.e.location_agency = "";
        this.e.time_agency = "";
        if (Config.fixed_depth != 0.0) {
            this.e.fixed_depth = Config.fixed_depth;
            logger.info((Object)String.format("depth is fixed!", new Object[0]));
        } else {
            this.e.fixed_depth = 9999999.0;
        }
        this.e.fixed_lat = 9999999.0;
        this.e.fixed_lon = 9999999.0;
        this.e.fixed_time = 9999999.0;
        this.e.reid_phase = 1;
        this.e.purge_phase = 1;
        this.e.fix_on_depdp = 0;
        this.e.numhyps = 1;
        SourceParam hp = EvtData.source;
        this.e.evid = (int)(Math.random() * 10000.0);
        this.h = new ISCHyp[this.e.numhyps];
        int i = 0;
        while (i < this.e.numhyps) {
            this.h[i] = new ISCHyp();
            this.h[i].hypid = i;
            this.h[i].time = (double)hp.getOriginTime().getTime() / 1000.0;
            this.h[i].lat = hp.getLat();
            this.h[i].lon = hp.getLon();
            Utils.calc_dircos(this.h[i].lat, this.h[i].lon, this.h[i].dircos);
            this.h[i].depth = hp.getDepth();
            this.h[i].ndefsta = hp.getLocStn();
            this.h[i].ndef = hp.getLocPha();
            this.h[i].etype = hp.getEqType();
            this.h[i].agency = Config.out_agency;
            this.h[i].ndefsta = 9999999;
            this.h[i].nass = 9999999;
            this.h[i].mindist = 9999999.0;
            this.h[i].maxdist = 9999999.0;
            this.h[i].azimgap = 9999999.0;
            this.h[i].sdobs = 9999999.0;
            this.h[i].stime = hp.getOriginTimeError();
            this.h[i].sdepth = hp.getErz();
            this.h[i].minax = 9999999.0;
            this.h[i].majax = 9999999.0;
            this.h[i].theta = 9999999.0;
            this.h[i].timfix = 0;
            this.h[i].epifix = 0;
            this.h[i].depfix = 0;
            ++i;
        }
        int tch = this.evtData.getTCN();
        this.p = new ISCPha[tch * 2];
        int j = 0;
        int i2 = 0;
        while (i2 < tch) {
            Vector<Phase> phs = this.evtData.getPhases(i2);
            for (Phase pp : phs) {
                this.p[j] = new ISCPha();
                if (pp.getPhaType() != 0) continue;
                this.p[j].rdid = j;
                this.p[j].rep_phase = pp.getPhaseName();
                this.p[j].net = pp.getNetCode();
                this.p[j].sta = pp.getStationCode();
                this.p[j].sta_lat = this.evtData.getStationLocation(i2).getLatitude();
                this.p[j].sta_lon = this.evtData.getStationLocation(i2).getLongtitude();
                this.p[j].sta_elev = this.evtData.getStationLocation(i2).getAltitude();
                Utils.calc_dircos(this.p[j].sta_lat, this.p[j].sta_lon, this.p[j].dircos);
                this.p[j].time = (double)pp.getPhaseTime().getTime() / 1000.0;
                this.p[j].init = '\u0001';
                this.p[j].slow = 9999999.0f;
                this.p[j].azim = pp.getAzimuth();
                this.p[j].delta = pp.getDistance() / 111.19f;
                String cp = pp.getChanCode();
                if (cp.endsWith("E")) {
                    this.p[j].comp = (char)69;
                } else if (cp.endsWith("N")) {
                    this.p[j].comp = (char)78;
                } else if (cp.endsWith("Z")) {
                    this.p[j].comp = (char)90;
                }
                this.p[j].sp_fm = (char)95;
                this.p[j].detchar = (char)95;
                ++j;
            }
            ++i2;
        }
        this.isc_data.ep.numphas = j;
        i2 = 0;
        while (i2 < this.isc_data.ep.numphas) {
            j = i2 - 1;
            while (j > -1) {
                if (this.p[j].time > this.p[j + 1].time && this.p[j + 1].time != 9999999.0 || this.p[j].time == 9999999.0) {
                    temp_pha = this.p[j];
                    this.p[j] = this.p[j + 1];
                    this.p[j + 1] = temp_pha;
                }
                --j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.isc_data.ep.numphas) {
            j = i2 - 1;
            while (j > -1) {
                if (!this.p[j].sta.equals(this.p[j + 1].sta)) {
                    temp_pha = this.p[j];
                    this.p[j] = this.p[j + 1];
                    this.p[j + 1] = temp_pha;
                }
                --j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.isc_data.ep.numphas) {
            j = i2 - 1;
            while (j > -1) {
                if (this.p[j].delta > this.p[j + 1].delta) {
                    temp_pha = this.p[j];
                    this.p[j] = this.p[j + 1];
                    this.p[j + 1] = temp_pha;
                }
                --j;
            }
            ++i2;
        }
    }

    private boolean doISCLoc() throws IOException {
        if (Config.read_config(this.configFile) > 0) {
            return false;
        }
        this.setInputInfo();
        int fail = 0;
        int opt2 = 0;
        int opt1 = 0;
        int opt0 = 0;
        int total = 0;
        logger.info((Object)String.format("=============================================", new Object[0]));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Calling init_event", new Object[0]));
        }
        if (Solve.init_event(this.e, this.h) > 0) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Calling rank_hyp", new Object[0]));
        }
        if (Solve.rank_hyp(this.e, this.h, this.p) > 0) {
            return false;
        }
        if (Solve.print_hyp(this.e, this.h) > 0) {
            return false;
        }
        int option = 0;
        while (option < 3) {
            if (this.e.fixed_time != 9999999.0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Calling init_sol to fix all", new Object[0]));
                }
                if (Solve.init_sol(this.s, this.e, this.h[0]) > 0) {
                    return false;
                }
                this.s.number_of_unknowns = 0;
                this.s.converged = 1;
                option = 3;
                break;
            }
            if (this.e.fixed_depth != 9999999.0 || this.e.fix_on_depdp != 0) {
                ++option;
            }
            if (this.e.fixed_lat != 9999999.0) {
                ++option;
            }
            if (logger.isDebugEnabled()) {
                logger.info((Object)String.format("option %d", option));
            }
            this.s.number_of_unknowns = option == 0 ? 4 : (option == 1 ? 3 : 1);
            int hyp = 0;
            while (hyp < this.e.numhyps) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Calling init_sol", new Object[0]));
                }
                if (Solve.init_sol(this.s, this.e, this.h[hyp]) > 0) {
                    ++hyp;
                    continue;
                }
                int i = 0;
                while (i < this.s.numphas) {
                    this.p[i].purged = 0;
                    ++i;
                }
                this.s.iteration = 0;
                while (this.s.iteration < Config.max_iter) {
                    logger.info((Object)String.format("opt%d %s iter %d: %s", option, this.h[hyp].agency, this.s.iteration, Utils.print_sol(this.s)));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Calling calc_delaz", new Object[0]));
                    }
                    if (Solve.calc_delaz(this.s, this.p) > 0) break;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Calling id_pha", new Object[0]));
                    }
                    if (PhaseId.id_pha(this.s, this.p, this.e.reid_phase) > 0) break;
                    if (this.e.fix_on_depdp != 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Calling calc_depdp", new Object[0]));
                        }
                        if (Solve.calc_depdp(this.s, this.p) > 0) break;
                        if (this.s.depdp == 9999999.0) {
                            logger.warn((Object)"no depdp to fix on");
                            break;
                        }
                        this.s.depth = this.s.depdp;
                        logger.info((Object)String.format("Fixing depth on depdp=%f", this.s.depdp));
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Calling id_pha", new Object[0]));
                        }
                        if (PhaseId.id_pha(this.s, this.p, this.e.reid_phase) > 0) break;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Calling get_weight_factor", new Object[0]));
                    }
                    if (Weight.get_weight_factor(this.p, this.s.numphas) > 0) break;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Calling mark_duplicates", new Object[0]));
                    }
                    if (Solve.mark_duplicates(this.s, this.p) > 0) break;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Calling calc_resid", new Object[0]));
                    }
                    if (Solve.calc_resid(this.s, this.p, "use") > 0) break;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Calling calc_weight", new Object[0]));
                    }
                    if (Weight.calc_weight(this.s, this.p) > 0) break;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Calling solve", new Object[0]));
                    }
                    if (Solve.solve(this.s, this.p) > 0) break;
                    if (this.s.iteration != 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Calling decide_iter", new Object[0]));
                        }
                        if (Solve.decide_iter(this.s, this.p) > 0) break;
                        if (this.s.diverging != 0) {
                            logger.info((Object)String.format("DIVERGING", new Object[0]));
                            break;
                        }
                        if (this.s.converged != 0) {
                            logger.info((Object)String.format("CONVERGED", new Object[0]));
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)String.format("Calling change_weighting", new Object[0]));
                            }
                            if (Weight.change_weighting(this.s) > 0) {
                                this.s.diverging = 1;
                                break;
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)String.format("Calling purge_pha", new Object[0]));
                            }
                            if (Solve.purge_pha(this.e, this.s, this.p) > 0) {
                                this.s.diverging = 1;
                                break;
                            }
                            if (this.s.converged == 0) {
                                this.s.iteration = -1;
                            }
                        }
                        if (this.s.converged != 0) break;
                    }
                    ++this.s.iteration;
                }
                logger.info((Object)String.format("last  : %s", Utils.print_sol(this.s)));
                if (this.s.converged != 0) break;
                ++hyp;
            }
            if (this.s.converged != 0) break;
            ++option;
        }
        if (this.s.converged != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Calling calc_delaz", new Object[0]));
            }
            if (Solve.calc_delaz(this.s, this.p) > 0) {
                return false;
            }
            if (this.e.fixed_time != 9999999.0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Calling id_pha", new Object[0]));
                }
                if (PhaseId.id_pha(this.s, this.p, this.e.reid_phase) > 0) {
                    return false;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Calling calc_resid", new Object[0]));
            }
            if (Solve.calc_resid(this.s, this.p, "all") > 0) {
                // empty if block
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Calling calc_error", new Object[0]));
            }
            if (Solve.calc_error(this.s, this.p) > 0) {
                // empty if block
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Calling calc_netmag", new Object[0]));
            }
            if (Mag.calc_netmag(this.s, this.p) > 0) {
                // empty if block
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Calling calc_depdp", new Object[0]));
            }
            if (Solve.calc_depdp(this.s, this.p) > 0) {
                // empty if block
            }
            logger.info((Object)String.format("final : %s", Utils.print_sol(this.s)));
            if (this.s.depdp != 9999999.0) {
                logger.info((Object)String.format("depdp=%.2f err=%.2f", this.s.depdp, this.s.depdp_error));
            }
            if (this.s.bodymag != 0.0) {
                logger.info((Object)String.format("mb=%.2f nsta=%d", this.s.bodymag, this.s.nsta_mb));
            }
            if (this.s.surfmag != 0.0) {
                logger.info((Object)String.format("ms=%.2f nsta=%d", this.s.surfmag, this.s.nsta_ms));
            }
            if (option == 0) {
                ++opt0;
            }
            if (option == 1) {
                ++opt1;
            }
            if (option == 2) {
                ++opt2;
            }
            if (option < 3) {
                ++total;
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Calling init_sol", new Object[0]));
            }
            if (Solve.init_sol(this.s, this.e, this.h[0]) > 0) {
                logger.info((Object)String.format("FAILURE", new Object[0]));
            }
            ++fail;
        }
        Utils.print_pha(this.isc_data.ep.numphas, this.p);
        logger.info((Object)String.format("opt0 %d, opt1 %d, opt2 %d converge %d fail %d", opt0, opt1, opt2, total, fail));
        return true;
    }

    public boolean findSourceLoc() {
        try {
            this.doISCLoc();
        }
        catch (IOException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        if (this.s.converged == 0 || this.s.diverging == 1) {
            logger.warn((Object)"location not convergence reached or the solution is diverging !");
            return false;
        }
        this.sourceParam.setGapAzi(this.s.azimgap);
        Date otime = new Date((long)(this.s.time * 1000.0));
        this.sourceParam.setOriginTime(otime);
        Vector<Phase>[] vec = this.getStnPhases();
        int i = 0;
        while (i < vec.length) {
            block3: for (Phase ph : vec[i]) {
                if (ph.getPhaType() != 0) continue;
                String sta = String.valueOf(ph.getNetCode()) + ph.getStationCode() + ph.getPhaseName();
                int j = 0;
                while (j < this.p.length) {
                    String sta1 = String.valueOf(this.p[j].net) + this.p[j].sta + this.p[j].rep_phase;
                    if (sta.equals(sta1)) {
                        ph.setDistance(this.p[j].delta);
                        ph.setResi((float)this.p[j].resid);
                        continue block3;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.sourceParam.setLat(this.s.lat);
        this.sourceParam.setLon(this.s.lon);
        this.sourceParam.setDepth(this.s.depth);
        this.sourceParam.setErh((this.s.error[2] + this.s.error[3]) / 2.0 * 111.19);
        this.sourceParam.setErz(this.s.error[4]);
        this.sourceParam.setRms(this.s.sdobs);
        this.sourceParam.setMb(this.s.bodymag);
        this.sourceParam.setMs(this.s.surfmag);
        this.sourceParam.setMl(Double.NaN);
        this.sourceParam.setOperator("ISCLoc");
        return true;
    }

    public String getDetailLocationResult() {
        String buf = super.getDetailLocationResult();
        return String.valueOf(buf) + Utils.out_pha(this.s.numphas, this.p, this.s);
    }

    public double getDetailResidual(int stn, String phaseName) {
        Phase phase = this.getPhase(stn, phaseName);
        if (phase == null) {
            return -99999.0;
        }
        return phase.getResi();
    }

    public SourceParam getSourceParam() {
        SourceParam sp = super.getSourceParam();
        sp.setLocProgram("ISCLoc");
        return sp;
    }

    public EvtData getEvtData() {
        return this.evtData;
    }

    public void setEvtData(EvtData evtData) {
        this.evtData = evtData;
    }
}

