/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.optimization.AEAMin;
import cn.org.gddsn.optimization.DoubleEncodeToDoubleFunction;
import cn.org.gddsn.optimization.RealValueFunction;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.location.IterateNearlocL1Residual;
import cn.org.gddsn.seis.location.StnLocation;

public class GaAndL1Loc
extends IterateNearlocL1Residual {
    double residual;
    double OTime;
    private double width = 2.5;
    private double maxDepth = 50.0;
    private int maxIterations = 600;

    public GaAndL1Loc() {
    }

    public GaAndL1Loc(SourceParam newTrySource) {
        this.trySource = newTrySource;
    }

    public boolean findSourceLoc() {
        double[] trialLoc = new double[]{this.trySource.lat, this.trySource.lon, this.trySource.depth};
        DoubleEncodeToDoubleFunction df = new DoubleEncodeToDoubleFunction();
        int size = 3;
        double[] paraMin = new double[size];
        double[] paraMax = new double[size];
        int i = 0;
        while (i < size - 1) {
            paraMin[i] = trialLoc[i] - this.width;
            paraMax[i] = trialLoc[i] + this.width;
            ++i;
        }
        paraMin[2] = 0.0;
        paraMax[2] = this.maxDepth;
        df.setParaMin(paraMin);
        df.setParaMax(paraMax);
        df.setFunk((RealValueFunction)this);
        AEAMin gm = new AEAMin();
        gm.setPopulationSize(20);
        gm.setMutationP(0.25);
        gm.setSelectP(0.8);
        gm.setInversionP(0.1);
        gm.setFunk(df);
        gm.setIterateMax(this.maxIterations);
        gm.setEps(5.0E-5);
        gm.searchMin();
        double[] res = gm.getResult();
        this.sourceParam.lat = res[0];
        this.sourceParam.lon = res[1];
        this.sourceParam.depth = res[2];
        this.sourceParam.rms = gm.getResidual();
        this.sourceParam.originTime.setTime(this.baseDate.getTime() + Math.round(this.getOTime() * 1000.0));
        this.sourceParam.gapAzi = this.getGapAzi();
        return true;
    }

    public SourceParam getSourceParam() {
        SourceParam sp = super.getSourceParam();
        sp.setLocProgram("GA");
        sp.setOperator("GA");
        return sp;
    }

    private double getOTime() {
        double tt;
        double[] sta;
        double[] src;
        int stnSum = this.getStnSum();
        StnLocation[] stnLoc = new StnLocation[stnSum];
        int i = 0;
        while (i < stnSum) {
            stnLoc[i] = new StnLocation();
            ++i;
        }
        double[] arriveT = new double[stnSum];
        double OTimeSum = 0.0;
        int OTimeCount = 0;
        int counts = this.getLocationData(stnLoc, arriveT, 3);
        int i2 = 0;
        while (i2 < counts) {
            src = new double[]{this.sourceParam.lat, this.sourceParam.lon, this.sourceParam.depth};
            sta = new double[]{stnLoc[i2].getLat(), stnLoc[i2].getLon(), stnLoc[i2].getAlt()};
            tt = this.computedTravelTime.calTravelTime(src, sta, 3);
            if (!Double.isNaN(tt)) {
                OTimeSum += arriveT[i2] - tt;
                ++OTimeCount;
            }
            ++i2;
        }
        counts = this.getLocationData(stnLoc, arriveT, 1);
        i2 = 0;
        while (i2 < counts) {
            src = new double[]{this.sourceParam.lat, this.sourceParam.lon, this.sourceParam.depth};
            sta = new double[]{stnLoc[i2].getLat(), stnLoc[i2].getLon(), stnLoc[i2].getAlt()};
            tt = this.computedTravelTime.calTravelTime(src, sta, 1);
            if (!Double.isNaN(tt)) {
                OTimeSum += arriveT[i2] - tt;
                ++OTimeCount;
            }
            ++i2;
        }
        counts = this.getLocationData(stnLoc, arriveT, 8);
        i2 = 0;
        while (i2 < counts) {
            src = new double[]{this.sourceParam.lat, this.sourceParam.lon, this.sourceParam.depth};
            sta = new double[]{stnLoc[i2].getLat(), stnLoc[i2].getLon(), stnLoc[i2].getAlt()};
            tt = this.computedTravelTime.calTravelTime(src, sta, 8);
            if (!Double.isNaN(tt)) {
                OTimeSum += arriveT[i2] - tt;
                ++OTimeCount;
            }
            ++i2;
        }
        this.OTime = OTimeSum / (double)OTimeCount;
        return this.OTime;
    }

    public double getMaxDepth() {
        return this.maxDepth;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setMaxDepth(double maxDepth) {
        this.maxDepth = maxDepth;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }
}

