/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.hk;

import JSci.util.ArrayCaster;
import cn.org.gddsn.seis.evtformat.sac.SAC;
import cn.org.gddsn.seis.hk.Complex;
import cn.org.gddsn.seis.hk.KNT;
import java.io.File;
import java.io.IOException;

public class RcvFn {
    private double tt;
    private double dt;
    private double p;
    private int ps = 0;
    private String com = "r";
    private int response = 1;
    private double shft = 0.0;
    private double gauss = 5.0;
    private double db;
    private double dh;

    public int run(String model) throws IOException {
        SAC hd = new SAC();
        double[] beta = new double[500];
        double[] thik = new double[500];
        double[] kapa = new double[500];
        int nt = (int)(this.tt / this.dt);
        int nft = 1;
        while (nft < nt) {
            nft *= 2;
        }
        SAC.sachdr(hd, (float)this.dt, nt, 0.0f);
        hd.USER0 = (float)this.p;
        hd.USER1 = (float)this.gauss;
        System.out.printf("%s\n", model);
        int nlyrs = KNT.mdin(model, thik, beta, kapa);
        if (nlyrs < 1 || nlyrs > 500) {
            return -1;
        }
        if (this.response == 1) {
            double[] z = new double[nft];
            double[] a = new double[nft];
            Complex[] z_c = new Complex[nft / 2];
            Complex.r2c(z_c, z);
            Complex[] a_c = new Complex[nft / 2];
            Complex.r2c(a_c, a);
            KNT.respknt(this.ps, nft, nlyrs, thik, beta, kapa, this.p, this.dt, z_c, a_c);
            Complex.c2r(z, z_c);
            Complex.c2r(a, a_c);
            String temp = String.format("%s.%05.3f.z", model, this.p);
            hd.data1 = ArrayCaster.toFloat((double[])z);
            SAC.writeBinarySAC(new File(temp), hd);
            temp = String.format("%s.%05.3f.r", model, this.p);
            hd.data1 = ArrayCaster.toFloat((double[])a);
            SAC.writeBinarySAC(new File(temp), hd);
        } else {
            double[] a = KNT.partial(this.ps, nft, nlyrs, thik, beta, kapa, this.p, this.dt, this.gauss, this.shft, this.db, this.dh);
            String temp = String.format("%s.%05.3f.%sd", model, this.p, this.com);
            hd.B = (float)(-this.shft);
            hd.data1 = ArrayCaster.toFloat((double[])a);
            SAC.writeBinarySAC(new File(temp), hd);
            if (this.db > 0.0) {
                int n = nlyrs;
                if (this.dh > 0.0) {
                    n = 2 * nlyrs - 1;
                }
                int i = 1;
                while (i < n) {
                    temp = String.format("%s.%05.3f-%03d.%cd", model, this.p, i, this.com);
                    hd.data1 = new float[hd.NPTS];
                    int j = 0;
                    while (j < hd.NPTS) {
                        hd.data1[j] = (float)a[i * nft + j];
                        ++j;
                    }
                    SAC.writeBinarySAC(new File(temp), hd);
                    ++i;
                }
            }
        }
        return 0;
    }

    public static void main(String[] args) throws IOException {
        RcvFn rcvFn = new RcvFn();
        rcvFn.tt = 80.0;
        rcvFn.dt = 0.01;
        rcvFn.ps = 1;
        rcvFn.p = 0.2778;
        rcvFn.run("/home/hwh/try/hk/sc.par");
    }
}

