/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.hk;

import cn.org.gddsn.seis.hk.Complex;
import cn.org.gddsn.seis.hk.DMatrix;
import cn.org.gddsn.seis.hk.FFT;
import cn.org.gddsn.seis.hk.Layer;
import cn.org.gddsn.seis.hk.Matrix;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.netlib.util.intW;

public class KNT {
    static Logger logger = Logger.getLogger(KNT.class);
    static final int MAXL = 500;

    static Layer[] mdSetup(int m, double[] thik, double[] beta, double[] kapa, double db, double dh, intW nlyrs) {
        nlyrs.val = m;
        if (dh > 0.0) {
            nlyrs.val = 2 * m - 1;
        }
        Layer[] lyr0 = new Layer[nlyrs.val + 1];
        lyr0[0] = new Layer();
        int jj = 1;
        int j = 0;
        while (j < m) {
            lyr0[jj] = new Layer();
            lyr0[jj].thik = thik[j] - dh;
            lyr0[jj].beta = beta[j];
            lyr0[jj].kapa = kapa[j];
            lyr0[jj].dbet = beta[j] + db;
            if (dh > 0.0 && j < m - 1) {
                lyr0[++jj] = new Layer();
                lyr0[jj].thik = dh;
                lyr0[jj].beta = beta[j];
                lyr0[jj].kapa = kapa[j];
                lyr0[jj].dbet = beta[j + 1];
            }
            ++j;
            ++jj;
        }
        return lyr0;
    }

    static DMatrix DDD(double p, double beta, double kapa, Complex qa, Complex qb) {
        DMatrix D = new DMatrix();
        Complex bet = new Complex();
        Complex pa = new Complex();
        Complex pb = new Complex();
        Complex t1 = new Complex();
        Complex t2 = new Complex();
        Complex tt = new Complex();
        double rho = 0.77 + 0.32 * kapa * beta;
        bet = Complex.cmplx(beta, 0.5 * beta / 225.0);
        tt = Complex.cmltp(bet, bet);
        t1 = Complex.cmplx(-p * p, 0.0);
        t2 = Complex.cinvs(tt);
        Complex cs = Complex.Csqrt(Complex.cplus(t2, t1));
        qb.x = cs.x;
        qb.y = cs.y;
        if (qb.y > 0.0) {
            cs = Complex.cngtv(qb);
            qb.x = cs.x;
            qb.y = cs.y;
        }
        t2 = Complex.cmplx(kapa * beta, 0.5 * kapa * beta / 500.0);
        t2 = Complex.cinvs(t2);
        t2 = Complex.cmltp(t2, t2);
        cs = Complex.Csqrt(Complex.cplus(t2, t1));
        qa.x = cs.x;
        qa.y = cs.y;
        if (qa.y > 0.0) {
            cs = Complex.cngtv(qa);
            qa.x = cs.x;
            qa.y = cs.y;
        }
        pa = Complex.cinvs(Complex.Csqrt(Complex.dmltp(2.0 * rho, qa)));
        pb = Complex.cinvs(Complex.Csqrt(Complex.dmltp(2.0 * rho, qb)));
        t1 = Complex.dmltp(2.0 * rho * p, tt);
        t2 = Complex.cplus(Complex.dmltp(p, t1), Complex.cmplx(-rho, 0.0));
        D.rd.pp = Complex.cmltp(Complex.IMAGE, Complex.cmltp(qa, pa));
        D.ru.pp = Complex.cngtv(D.rd.pp);
        D.ru.ps = D.rd.ps = Complex.dmltp(p, pb);
        D.ru.sp = D.rd.sp = Complex.dmltp(p, pa);
        D.rd.ss = Complex.cmltp(Complex.IMAGE, Complex.cmltp(qb, pb));
        D.ru.ss = Complex.cngtv(D.rd.ss);
        D.ru.sh = D.rd.sh = Complex.cmltp(Complex.cinvs(bet), pb);
        D.tu.pp = D.td.pp = Complex.cmltp(t2, pa);
        D.td.ps = Complex.cmltp(t1, D.rd.ss);
        D.tu.ps = Complex.cngtv(D.td.ps);
        D.td.sp = Complex.cmltp(t1, D.rd.pp);
        D.tu.sp = Complex.cngtv(D.td.sp);
        D.tu.ss = D.td.ss = Complex.cmltp(t2, pb);
        D.td.sh = Complex.cmltp(Complex.dmltp(rho, bet), D.rd.ss);
        D.tu.sh = Complex.cngtv(D.td.sh);
        return D;
    }

    static DMatrix QQQ(DMatrix D1, DMatrix D2) {
        DMatrix Q = new DMatrix();
        Matrix T = Matrix.plus(Matrix.mltp(Matrix.trns(D1.ru), D2.td), Matrix.ngtv(Matrix.mltp(Matrix.trns(D1.tu), D2.rd)));
        Matrix L = Matrix.invs(T);
        Q.td = Matrix.imlt(L);
        Q.tu = Matrix.trns(Q.td);
        T = Matrix.plus(Matrix.mltp(Matrix.trns(D1.rd), D2.td), Matrix.ngtv(Matrix.mltp(Matrix.trns(D1.td), D2.rd)));
        Q.rd = Matrix.ngtv(Matrix.mltp(T, L));
        T = Matrix.plus(Matrix.mltp(Matrix.trns(D1.ru), D2.tu), Matrix.ngtv(Matrix.mltp(Matrix.trns(D1.tu), D2.ru)));
        Q.ru = Matrix.ngtv(Matrix.mltp(L, T));
        return Q;
    }

    static Matrix EEE(Complex qa, Complex qb, double wh) {
        Complex iwh = new Complex();
        Matrix Ed = new Matrix();
        iwh = Complex.cmplx(0.0, -wh);
        Ed.pp = Complex.cphase(Complex.cmltp(iwh, qa));
        Ed.ss = Complex.cphase(Complex.cmltp(iwh, qb));
        Ed.ps = Complex.cmplx(0.0, 0.0);
        Ed.sp = Complex.cmplx(0.0, 0.0);
        Ed.sh = Complex.cmplx(Ed.ss.x, Ed.ss.y);
        return Ed;
    }

    static void ifmat(double p, int nlyrs, Layer[] lyr) {
        lyr[0].D.ru = Matrix.I();
        lyr[0].D.rd = new Matrix();
        lyr[0].D.td = new Matrix();
        lyr[0].D.tu = new Matrix();
        int i = 0;
        while (i++ < nlyrs) {
            lyr[i].D = KNT.DDD(p, lyr[i].beta, lyr[i].kapa, lyr[i].qa, lyr[i].qb);
            lyr[i].Q = KNT.QQQ(lyr[i - 1].D, lyr[i].D);
        }
    }

    static void delifm(double p, int nlyrs, Layer[] lyr) {
        DMatrix D = new DMatrix();
        int i = 1;
        while (i < nlyrs) {
            D = KNT.DDD(p, lyr[i].dbet, lyr[i].kapa, lyr[i].dqa, lyr[i].dqb);
            lyr[i].dQ1 = KNT.QQQ(lyr[i - 1].D, D);
            lyr[i].dQ2 = KNT.QQQ(D, lyr[i + 1].D);
        }
    }

    static Matrix rcvrfn(double w, int nlyrs, Layer[] lyr0) {
        int n = nlyrs;
        lyr0[n].STu = Matrix.I();
        lyr0[n].SRd = new Matrix();
        Matrix Rd = lyr0[n].Q.rd;
        Matrix Tu = lyr0[n].Q.tu;
        while (--n > 0) {
            Matrix Ed = KNT.EEE(lyr0[n].qa, lyr0[n].qb, w * lyr0[n].thik);
            Rd = Matrix.mltp(Ed, Matrix.mltp(Rd, Ed));
            Tu = Matrix.mltp(Ed, Tu);
            lyr0[n].SRd = Rd;
            lyr0[n].STu = Tu;
            Matrix L = Matrix.mltp(lyr0[n].Q.tu, Matrix.invs(Matrix.plus(Matrix.I(), Matrix.ngtv(Matrix.mltp(Rd, lyr0[n].Q.ru)))));
            Rd = Matrix.plus(lyr0[n].Q.rd, Matrix.mltp(lyr0[n].Q.tu, Matrix.mltp(Rd, Matrix.trns(L))));
            Tu = Matrix.mltp(L, Tu);
        }
        return Tu;
    }

    static Matrix rcvrtd(double w, int nlyrs, Layer[] lyr) {
        Matrix L = new Matrix();
        Matrix Ru = new Matrix();
        Matrix Tu = new Matrix();
        Matrix Ed = new Matrix();
        lyr[0].UTu = Matrix.I();
        lyr[0].URu = new Matrix();
        int i = 1;
        Ru = lyr[i].Q.ru;
        Tu = lyr[i].Q.tu;
        while (i < nlyrs) {
            Ed = KNT.EEE(lyr[i].qa, lyr[i].qb, w * lyr[i].thik);
            Ru = Matrix.mltp(Ed, Matrix.mltp(Ru, Ed));
            Tu = Matrix.mltp(Tu, Ed);
            lyr[i].URu = Ru;
            lyr[i].UTu = Tu;
            L = Matrix.mltp(Matrix.invs(Matrix.plus(Matrix.I(), Matrix.ngtv(Matrix.mltp(lyr[++i].Q.rd, Ru)))), lyr[i].Q.tu);
            Ru = Matrix.plus(lyr[i].Q.ru, Matrix.mltp(lyr[i].Q.td, Matrix.mltp(Ru, L)));
            Tu = Matrix.mltp(Tu, L);
        }
        return Tu;
    }

    static Matrix delrcv(double w, Layer[] k, int k_off) {
        Layer below = k[k_off + 1];
        Layer above = k[k_off - 1];
        Matrix Tu = below.STu;
        Matrix Rd = below.SRd;
        Matrix L = Matrix.mltp(k[k_off].dQ2.tu, Matrix.invs(Matrix.plus(Matrix.I(), Matrix.ngtv(Matrix.mltp(Rd, k[k_off].dQ2.ru)))));
        Tu = Matrix.mltp(L, Tu);
        Rd = Matrix.plus(k[k_off].dQ2.rd, Matrix.mltp(k[k_off].dQ2.tu, Matrix.mltp(Rd, Matrix.trns(L))));
        Matrix Ed = KNT.EEE(k[k_off].dqa, k[k_off].dqb, w * k[k_off].thik);
        Rd = Matrix.mltp(Ed, Matrix.mltp(Rd, Ed));
        Tu = Matrix.mltp(Ed, Tu);
        L = Matrix.mltp(k[k_off].dQ1.tu, Matrix.invs(Matrix.plus(Matrix.I(), Matrix.ngtv(Matrix.mltp(Rd, k[k_off].dQ1.ru)))));
        Tu = Matrix.mltp(L, Tu);
        Rd = Matrix.plus(k[k_off].dQ1.rd, Matrix.mltp(k[k_off].dQ1.tu, Matrix.mltp(Rd, Matrix.trns(L))));
        Tu = Matrix.mltp(above.UTu, Matrix.mltp(Matrix.invs(Matrix.plus(Matrix.I(), Matrix.ngtv(Matrix.mltp(Rd, above.URu)))), Tu));
        return Tu;
    }

    static double[] partial(int ps, int nft, int m, double[] thik, double[] beta, double[] kapa, double p, double dt, double gauss, double shft, double db, double dh) {
        int j;
        int k;
        intW nlyrs = new intW(0);
        double[] delta = new double[2];
        Complex temp = new Complex();
        int nft2 = nft / 2;
        double delw = Math.PI / (dt * (double)nft2);
        Layer[] lyr = KNT.mdSetup(m, thik, beta, kapa, db, dh, nlyrs);
        int n = 1;
        if (db > 0.0) {
            delta[0] = delta[1] = 1.0 / db;
            if (dh > 0.0) {
                delta[1] = -1.0 / dh;
            }
            n = nlyrs.val;
        }
        Complex[] a = new Complex[nft2 * n];
        KNT.ifmat(p, nlyrs.val, lyr);
        if (db > 0.0) {
            KNT.delifm(p, nlyrs.val, lyr);
        }
        int i = 0;
        double w = 0.0;
        while (i < nft2) {
            double agg = 0.5 * w / gauss;
            temp = Complex.cphase(Complex.cmplx(-agg * agg, -shft * w));
            Matrix dis = KNT.rcvrfn(w, nlyrs.val, lyr);
            a[i] = ps == 0 ? Complex.cmltp(dis.sp, Complex.cinvs(Complex.cmltp(Complex.IMAGE, dis.pp))) : Complex.cngtv(Complex.conjg(Complex.cmltp(Complex.cmltp(Complex.IMAGE, dis.ps), Complex.cinvs(dis.ss))));
            a[i] = Complex.cmltp(temp, a[i]);
            if (db > 0.0) {
                KNT.rcvrtd(w, nlyrs.val, lyr);
                k = i + nft2;
                int vORh = 0;
                j = 1;
                while (j < nlyrs.val) {
                    dis = KNT.delrcv(w, lyr, j);
                    a[k] = ps == 0 ? Complex.cmltp(dis.sp, Complex.cinvs(Complex.cmltp(Complex.IMAGE, dis.pp))) : Complex.cngtv(Complex.conjg(Complex.cmltp(Complex.cmltp(Complex.IMAGE, dis.ps), Complex.cinvs(dis.ss))));
                    a[k] = Complex.cmltp(temp, a[k]);
                    a[k] = Complex.dmltp(delta[vORh], Complex.cplus(a[k], Complex.cngtv(a[i])));
                    vORh ^= 1;
                    ++j;
                    k += nft2;
                }
            }
            ++i;
            w += delw;
        }
        k = 0;
        j = 0;
        while (j < n) {
            FFT.fftr(a, k, nft2, -dt);
            ++j;
            k += nft2;
        }
        double[] aa = new double[a.length * 2];
        i = 0;
        while (i < a.length) {
            aa[2 * i] = a[i].x;
            aa[2 * i] = a[i].y;
            ++i;
        }
        return aa;
    }

    static void respknt(int ps, int nft, int m, double[] thik, double[] beta, double[] kapa, double p, double dt, Complex[] z, Complex[] r) {
        Matrix aa = new Matrix();
        intW nlyrs = new intW(0);
        int nft2 = nft / 2;
        double delw = Math.PI / (dt * (double)nft2);
        Layer[] lyr = KNT.mdSetup(m, thik, beta, kapa, 0.0, 0.0, nlyrs);
        KNT.ifmat(p, nlyrs.val, lyr);
        int i = 0;
        double w = 0.0;
        while (i < nft2) {
            aa = KNT.rcvrfn(w, nlyrs.val, lyr);
            if (ps == 0) {
                r[i] = aa.sp;
                z[i] = Complex.cmltp(Complex.IMAGE, aa.pp);
            } else {
                r[i] = aa.ss;
                z[i] = Complex.cmltp(Complex.IMAGE, aa.ps);
            }
            ++i;
            w += delw;
        }
        FFT.fftr(r, 0, nft2, -dt);
        FFT.fftr(z, 0, nft2, -dt);
    }

    static int mdin(String fo, double[] thik, double[] beta, double[] kapa) {
        int m = 0;
        try {
            Scanner sc = new Scanner(new File(fo));
            while (sc.hasNext() && m < 500) {
                thik[m] = sc.nextDouble();
                beta[m] = sc.nextDouble();
                kapa[m] = sc.nextDouble();
                if (thik[++m] - 1.0 == 0.0) break;
            }
            sc.close();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return m;
    }
}

