/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.hk;

import cn.org.gddsn.seis.hk.Complex;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class FFT {
    private FFT() {
    }

    static void fft(Complex[] a, int a_off, int n, double dt) {
        int k;
        Complex u = new Complex();
        Complex w = new Complex();
        Complex t = new Complex();
        double pi = -Math.PI;
        if (dt < 0.0) {
            pi = Math.PI;
        }
        int m = n / 2;
        int j = 0;
        int i = 1;
        while (i < n - 1) {
            k = m;
            while (k <= j) {
                j -= k;
                k /= 2;
            }
            if (i < (j += k)) {
                t = a[a_off + i];
                a[a_off + i] = a[a_off + j];
                a[a_off + j] = t;
            }
            ++i;
        }
        m = 1;
        int step = 2;
        while (m < n) {
            u = Complex.One;
            w = Complex.cmplx(Math.cos(pi / (double)m), Math.sin(pi / (double)m));
            j = 0;
            while (j < m) {
                i = j;
                while (i < n) {
                    k = i + m;
                    t = Complex.cmltp(a[a_off + k], u);
                    a[a_off + k] = Complex.cplus(a[a_off + i], Complex.cngtv(t));
                    a[a_off + i] = Complex.cplus(a[a_off + i], t);
                    i += step;
                }
                u = Complex.cmltp(u, w);
                ++j;
            }
            m = step;
            step *= 2;
        }
        if (dt < 0.0) {
            dt = -1.0 / ((double)n * dt);
        }
        i = 0;
        while (i < n) {
            a[a_off + i] = Complex.dmltp(dt, a[a_off + i]);
            ++i;
        }
    }

    static void fftr(Complex[] x, int x_off, int n, double dt) {
        Complex t = new Complex();
        Complex g = new Complex();
        Complex h = new Complex();
        Complex isg = new Complex();
        int n2 = n / 2;
        double delw = Math.PI / (double)n;
        isg = Complex.IMAGE;
        if (dt > 0.0) {
            delw = -delw;
            isg = Complex.cngtv(isg);
            FFT.fft(x, x_off, n, dt);
        }
        x[0] = Complex.cmplx(x[0 + x_off].x + x[0 + x_off].y, x[0 + x_off].x - x[0 + x_off].y);
        int i = 1;
        double w = delw;
        while (i < n2) {
            int j = n - i;
            t = Complex.conjg(x[x_off + j]);
            g = Complex.cplus(x[x_off + i], t);
            h = Complex.cplus(x[x_off + i], Complex.cngtv(t));
            h = Complex.cmltp(Complex.cmplx(Math.cos(w), Math.sin(w)), h);
            x[x_off + i] = Complex.dmltp(0.5, Complex.cplus(g, Complex.cmltp(isg, h)));
            x[x_off + j] = Complex.dmltp(0.5, Complex.cplus(Complex.conjg(g), Complex.cmltp(isg, Complex.conjg(h))));
            ++i;
            w += delw;
        }
        x[x_off + n2] = Complex.conjg(x[x_off + n2]);
        if (dt < 0.0) {
            x[x_off + 0] = Complex.dmltp(0.5, x[x_off + 0]);
            FFT.fft(x, x_off, n, dt);
        }
    }

    static void cor(Complex[] src, Complex[] data, double dt, int nft) {
        double aa = -1.0;
        data[0] = Complex.cmplx(data[0].x * src[0].x, aa * data[0].y * src[0].y);
        int j = 1;
        while (j < nft) {
            data[j] = Complex.cmltp(data[j], Complex.conjg(src[j]));
            data[j] = Complex.dmltp(aa, data[j]);
            aa = -aa;
            ++j;
        }
        FFT.fftr(data, 0, nft, -dt);
    }

    static void conv(double[] s, int ns, double[] f, int n) {
        int m = n + ns;
        double[] g = new double[m];
        int i = 0;
        while (i < ns) {
            g[i] = 0.0;
            ++i;
        }
        double[] pt = f;
        int k = 0;
        while (k < n) {
            g[i] = pt[k];
            pt[k] = 0.0;
            int j = 0;
            while (j < ns) {
                int n2 = k;
                pt[n2] = pt[n2] + g[i - j] * s[j];
                ++j;
            }
            ++k;
            ++i;
        }
    }

    static double[] crscrl(int npt, double[] rec, int rec_off, double[] syn, int syn_off, int m) {
        int nft = 2;
        while (nft < npt) {
            nft *= 2;
        }
        int nft2 = nft;
        double[] ss1 = new double[nft *= 2];
        double[] ss2 = new double[nft];
        System.arraycopy(rec, rec_off, ss1, 0, npt);
        System.arraycopy(syn, syn_off, ss2, 0, npt);
        int i = npt;
        while (i < nft) {
            ss1[i] = 0.0;
            ss2[i] = 0.0;
            ++i;
        }
        Complex[] c1 = new Complex[nft2];
        Complex[] c2 = new Complex[nft2];
        i = 0;
        while (i < nft2) {
            c1[i] = new Complex(ss1[2 * i], ss1[2 * i + 1]);
            c2[i] = new Complex(ss2[2 * i], ss2[2 * i + 1]);
            ++i;
        }
        FFT.fftr(c1, 0, nft2, 1.0);
        FFT.fftr(c2, 0, nft2, 1.0);
        FFT.cor(c2, c1, 1.0, nft2);
        i = 0;
        while (i < nft2) {
            ss1[2 * i] = c1[i].x;
            ss1[2 * i + 1] = c1[i].y;
            ss2[2 * i] = c2[i].x;
            ss2[2 * i + 1] = c2[i].y;
            ++i;
        }
        ss2 = new double[m + 1];
        System.arraycopy(ss1, nft2 -= m / 2, ss2, 0, m + 1);
        return ss2;
    }

    static double maxCor(double[] data, int data_off, double[] syn, int syn_off, int n, int max_shift, intW delay, doubleW amp) {
        double dataAuto = 0.0;
        double synAuto = 0.0;
        int i = 0;
        while (i < n) {
            dataAuto += data[data_off + i] * data[data_off + i];
            synAuto += syn[syn_off + i] * syn[syn_off + i];
            ++i;
        }
        if (max_shift < 0) {
            max_shift = n;
        }
        double[] crs = FFT.crscrl(n, data, data_off, syn, syn_off, 2 * max_shift);
        double c = -1.7976931348623157E308;
        i = 0;
        while (i <= 2 * max_shift) {
            if (c < crs[i]) {
                c = crs[i];
                delay.val = i;
            }
            ++i;
        }
        delay.val -= max_shift;
        amp.val = c / synAuto;
        return c / Math.sqrt(dataAuto * synAuto);
    }

    static double maxCorSlide(double[] data, double[] syn, int n, int lw, double overlap, intW delay, doubleW amp) {
        double cc_best = 0.0;
        intW delay0 = new intW(0);
        doubleW amp0 = new doubleW(0.0);
        int max_shift = (int)Math.rint((double)lw * (1.0 - overlap));
        double cc = -1.7976931348623157E308;
        int i = 0;
        while (i + lw < n) {
            int j = 0;
            while (j + lw < n) {
                cc = FFT.maxCor(data, i, syn, j, lw, max_shift, delay0, amp0);
                if (cc > cc_best) {
                    cc_best = cc;
                    delay.val = delay0.val + i - j;
                    amp.val = amp0.val;
                }
                j += max_shift;
            }
            i += max_shift;
        }
        return cc_best;
    }

    static double amp(double t1, double t2, double[] data, int off, int n) {
        if (t1 < 0.0) {
            t1 = 0.0;
        }
        if (t2 > (double)(n - 1)) {
            t2 = n - 1;
        }
        if (t1 > (double)(n - 1) || t2 < t1) {
            return 0.0;
        }
        int it1 = (int)Math.floor(t1);
        int i = it1 + 1;
        double dd = (double)i - t1;
        double am = dd * (dd * data[off + it1] + (2.0 - dd) * data[off + i]);
        int it2 = (int)Math.ceil(t2);
        while (i < it2) {
            am += data[off + i] + data[off + i + 1];
            ++i;
        }
        dd = (double)i - t2;
        return 0.5 * (am -= dd * (dd * data[off + i - 1] + (2.0 - dd) * data[off + i]));
    }

    static double acc(double[] data, int off, int n, double t1, double t2, int half) {
        int it1 = (int)Math.floor(t1 - (double)half);
        int it2 = (int)Math.floor(t2 - (double)half);
        int len = 2 * half;
        if (half < 1 || it2 < it1 || it1 < 0 || it2 + len > n - 1) {
            return 0.0;
        }
        double am1 = 0.0;
        double am2 = 0.0;
        double amc = 0.0;
        int i = 0;
        while (i < len) {
            am1 += data[off + it1 + i] * data[off + it1 + i];
            am2 += data[off + it2 + i] * data[off + it2 + i];
            amc += data[off + it1 + i] * data[off + it2 + i];
            ++i;
        }
        return amc / Math.sqrt(am1 * am2);
    }

    static void cumsum(double[] a, int n, double dt) {
        double u = 0.0;
        int i = 0;
        while (i < n) {
            a[i] = u += a[i] * dt;
            ++i;
        }
    }

    static void maver(double[] a, int n, int m) {
        int m2 = (m - 1) / 2;
        double c = 1.0 / (double)m;
        double[] b = new double[n + m - 1];
        System.arraycopy(a, 0, b, m2, n);
        double aver = 0.0;
        int j = m2;
        while (j < m) {
            aver += c * b[j];
            ++j;
        }
        a[0] = aver;
        int i = 1;
        while (i < n) {
            a[i] = aver += c * (b[j] - b[j - m]);
            ++i;
            ++j;
        }
    }

    static void diffrt(double[] a, int n, double dt) {
        int i = n - 1;
        while (i > 0) {
            a[i] = (a[i] - a[i - 1]) / dt;
            --i;
        }
        a[0] = 0.0;
    }

    static void sqr(double[] a, int n) {
        int i = 0;
        while (i < n) {
            int n2 = i;
            a[n2] = a[n2] * a[i];
            ++i;
        }
    }

    static void revers(double[] a, int n) {
        int i = 0;
        int j = n - 1;
        while (i < j) {
            double dum = a[i];
            a[i] = a[j];
            a[j] = dum;
            ++i;
            --j;
        }
    }

    static double[] coswndw(int n, double w) {
        int n1;
        double[] wndw = new double[n];
        int j = 0;
        while (j < n) {
            wndw[j] = 1.0;
            ++j;
        }
        if (w > 0.5) {
            w = 0.5;
        }
        if ((n1 = (int)Math.rint(w * (double)n)) < 1) {
            n1 = 1;
        }
        double t = 0.0;
        double dt = Math.PI / (double)n1;
        j = 0;
        while (j < n1) {
            double d = 0.5 * (1.0 - Math.cos(t));
            wndw[n - j - 1] = d;
            wndw[j] = d;
            ++j;
            t += dt;
        }
        return wndw;
    }

    static void filter(Complex[] d, int n, double f1, double f2, double dt, int sgn) {
        dt = 0.5 / dt / (double)n;
        int if1 = (int)Math.rint(f1 / dt);
        int if2 = (int)Math.rint(f2 / dt);
        if (if2 >= n) {
            if2 = n - 1;
        }
        if (if2 <= if1) {
            System.err.printf("filter freq. wrong f2<f1\n", new Object[0]);
            return;
        }
        dt = Math.PI / (double)(if2 - if1);
        double a = 0.0;
        int i = if1;
        while (i < if2) {
            d[i] = Complex.dmltp(0.5 * (1.0 - (double)sgn * Math.cos(a)), d[i]);
            ++i;
            a += dt;
        }
        if (sgn < 0) {
            i = if2;
            while (i < n) {
                d[i] = Complex.Zero;
                ++i;
            }
            d[0].y = 0.0;
        } else {
            d[0].x = 0.0;
            i = 1;
            while (i < if1) {
                d[i] = Complex.Zero;
                ++i;
            }
        }
    }

    static int findMax(double[] a, int off, int n, doubleW amp) {
        int shift = 0;
        amp.val = 0.0;
        int i = 0;
        while (i < n) {
            if (a[off + i] > amp.val) {
                amp.val = a[off + i];
                shift = i;
            }
            ++i;
        }
        return shift;
    }

    static int findMaxAbs(double[] a, int off, int n, doubleW amp) {
        int shift = 0;
        amp.val = 0.0;
        int i = 0;
        while (i < n) {
            if (Math.abs(a[off + i]) > Math.abs(amp.val)) {
                amp.val = a[off + i];
                shift = i;
            }
            ++i;
        }
        return shift;
    }

    static void rtrend(double[] y, int n) {
        double y2 = 0.0;
        double y1 = 0.0;
        int i = 0;
        while (i < n) {
            y1 += (double)i * y[i];
            y2 += y[i];
            ++i;
        }
        double a12 = 0.5 * (double)n * (double)(n - 1);
        double a11 = a12 * (double)(2 * n - 1) / 3.0;
        double a22 = n;
        double b = a11 * a22 - a12 * a12;
        double a = (a22 * y1 - a12 * y2) / b;
        b = (a11 * y2 - a12 * y1) / b;
        i = 0;
        while (i < n) {
            y[i] = y[i] - a * (double)i - b;
            ++i;
        }
    }

    static void fltGauss(Complex[] u, int n, double gauss) {
        double agg;
        double delw;
        double w = delw = Math.PI / (double)n;
        int j = 1;
        while (j < n) {
            agg = 0.5 * w / gauss;
            u[j] = Complex.dmltp(Math.exp(-agg * agg), u[j]);
            ++j;
            w += delw;
        }
        agg = 0.5 * w / gauss;
        u[0].y = Math.exp(-agg * agg) * u[0].y;
    }

    static void shiftSpec(Complex[] u, int n, double shift) {
        double delw;
        double w = delw = Math.PI / (double)n;
        int j = 1;
        while (j < n) {
            u[j] = Complex.cmltp(Complex.cmplx(Math.cos(w * shift), -Math.sin(w * shift)), u[j]);
            ++j;
            w += delw;
        }
        u[0].y = Math.cos(w * shift) * u[0].y;
    }

    static double specPwr(Complex[] u, int n) {
        double a = 0.0;
        int j = 0;
        while (j < n) {
            double temp = Complex.ccabs(u[j]);
            a += temp * temp;
            ++j;
        }
        return a / (double)n;
    }

    static void specAdd(Complex[] a, Complex[] b, int n) {
        int j = 0;
        while (j < n) {
            a[j] = Complex.cplus(a[j], b[j]);
            ++j;
        }
    }

    static void specMul(Complex[] a, Complex[] b, int n) {
        a[0] = Complex.cmplx(a[0].x * b[0].x, a[0].y * b[0].y);
        int j = 1;
        while (j < n) {
            a[j] = Complex.cmltp(a[j], b[j]);
            ++j;
        }
    }

    static void specScale(Complex[] a, double c, int n) {
        int j = 0;
        while (j < n) {
            a[j] = Complex.dmltp(c, a[j]);
            ++j;
        }
    }
}

