/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.hk;

import JSci.util.ArrayCaster;
import cn.org.gddsn.seis.evtformat.sac.SAC;
import cn.org.gddsn.seis.hk.Complex;
import cn.org.gddsn.seis.hk.FFT;
import java.io.File;
import java.io.IOException;

public class Deconvolution {
    boolean cut = false;
    int tmark = -5;
    double t1 = 0.0;
    double t2;
    private double shift = 5.0;
    private double filterLen;
    private double gauss = 5.0;
    private boolean hpass = false;
    private double hf1;
    private double hf2;
    private double taper = 0.5;
    private double c = 0.01;

    public int run(String srcName, String[] rvName) throws IOException {
        int m;
        double[] src;
        SAC hd = new SAC();
        double[] acr = null;
        double[] wndw = null;
        if (this.cut) {
            Deconvolution.read_sac(new File(srcName), hd, this.tmark, (float)this.t1, (float)this.t2);
            src = ArrayCaster.toDouble((float[])hd.data1);
        } else {
            hd.readBinarySAC(new File(srcName));
            src = ArrayCaster.toDouble((float[])hd.data1);
            this.tmark = -5;
            this.t1 = 0.0;
            this.t2 = (float)hd.NPTS * hd.DELTA;
        }
        int nn = hd.NPTS;
        double dt = hd.DELTA;
        if (this.taper > 0.0) {
            wndw = FFT.coswndw(nn, this.taper);
            int j = 0;
            while (j < nn) {
                int n = j;
                src[n] = src[n] * wndw[j];
                ++j;
            }
        }
        if ((m = (int)Math.rint(this.filterLen / dt)) < 1 || m > nn) {
            m = nn;
        }
        int nshift = (int)Math.rint(this.shift / dt);
        int nft = 1;
        while (nft < nn) {
            nft *= 2;
        }
        int nft2 = nft;
        double[] src1 = src;
        src = new double[nft *= 2];
        System.arraycopy(src1, 0, src, 0, nn);
        int j = nn;
        while (j < nft) {
            src[j] = 0.0;
            ++j;
        }
        Complex[] src_c = new Complex[nft2];
        Complex.r2c(src_c, src);
        FFT.fftr(src_c, 0, nft2, dt);
        Complex.c2r(src, src_c);
        if (this.hpass) {
            Complex.r2c(src_c, src);
            FFT.filter(src_c, nft2, this.hf1, this.hf2, dt, 1);
            Complex.c2r(src, src_c);
        }
        if (this.filterLen > 0.0) {
            acr = new double[nft];
            System.arraycopy(src, 0, acr, 0, nft);
            Complex.r2c(src_c, src);
            Complex[] acr_c = new Complex[nft2];
            Complex.r2c(acr_c, acr);
            FFT.cor(src_c, acr_c, dt, nft2);
            Complex.c2r(src, src_c);
            Complex.c2r(acr, acr_c);
            System.arraycopy(acr, nft2, acr, 0, nft2);
        } else {
            Complex.r2c(src_c, src);
            Deconvolution.water(src_c, nft2, dt, this.c, this.gauss);
            Complex.c2r(src, src_c);
        }
        double[] data = new double[nft];
        String[] stringArray = rvName;
        int n = rvName.length;
        int n2 = 0;
        while (n2 < n) {
            String fn = stringArray[n2];
            System.out.printf("%s\n", fn);
            hd.readBinarySAC(new File(fn));
            double[] trace = ArrayCaster.toDouble((float[])hd.data1);
            if (hd.NPTS == nn) {
                double[] fpt;
                int j2;
                if (this.taper > 0.0) {
                    j2 = 0;
                    while (j2 < nn) {
                        data[j2] = trace[j2] * wndw[j2];
                        ++j2;
                    }
                } else {
                    j2 = 0;
                    while (j2 < nn) {
                        data[j2] = trace[j2];
                        ++j2;
                    }
                }
                j2 = nn;
                while (j2 < nft) {
                    data[j2] = 0.0;
                    ++j2;
                }
                Complex[] data_c = new Complex[nft2];
                Complex.r2c(data_c, data);
                FFT.fftr(data_c, 0, nft2, dt);
                Complex.c2r(data, data_c);
                if (nshift > 0) {
                    Complex.r2c(data_c, data);
                    FFT.shiftSpec(data_c, nft2, nshift);
                    Complex.c2r(data, data_c);
                }
                if (this.hpass) {
                    Complex.r2c(data_c, data);
                    FFT.filter(data_c, nft2, this.hf1, this.hf2, dt, 1);
                    Complex.c2r(data, data_c);
                }
                if (this.filterLen > 0.0) {
                    Complex.r2c(src_c, src);
                    Complex.r2c(data_c, data);
                    FFT.cor(src_c, data_c, dt, nft2);
                    Complex.c2r(src, src_c);
                    Complex.c2r(data, data_c);
                    fpt = new double[nft2];
                    System.arraycopy(data, nft2, fpt, 0, nft2);
                    Deconvolution.toeplitz(acr, fpt, m, this.c);
                } else {
                    Complex.r2c(src_c, src);
                    Complex.r2c(data_c, data);
                    FFT.specMul(data_c, src_c, nft2);
                    Complex.c2r(src, src_c);
                    Complex.c2r(data, data_c);
                    Complex.r2c(data_c, data);
                    FFT.fftr(data_c, 0, nft2, -dt);
                    Complex.c2r(data, data_c);
                    fpt = data;
                }
                hd.NPTS = m;
                float tref = 0.0f;
                switch (this.tmark) {
                    case -5: {
                        tref = hd.B;
                        break;
                    }
                    case -3: {
                        tref = hd.O;
                        break;
                    }
                    case -2: {
                        tref = hd.A;
                        break;
                    }
                    case 0: {
                        tref = hd.USER0;
                        break;
                    }
                    case 1: {
                        tref = hd.USER1;
                        break;
                    }
                    case 2: {
                        tref = hd.USER2;
                        break;
                    }
                    case 3: {
                        tref = hd.USER3;
                        break;
                    }
                    case 4: {
                        tref = hd.USER4;
                        break;
                    }
                    case 5: {
                        tref = hd.USER5;
                        break;
                    }
                    case 6: {
                        tref = hd.USER6;
                        break;
                    }
                    case 7: {
                        tref = hd.USER7;
                        break;
                    }
                    case 8: {
                        tref = hd.USER8;
                        break;
                    }
                    case 9: {
                        tref = hd.USER9;
                    }
                }
                hd.B = tref - (float)this.shift;
                hd.E = hd.B + (float)hd.NPTS * hd.DELTA;
                hd.USER1 = (float)this.gauss;
                hd.data1 = ArrayCaster.toFloat((double[])fpt);
                SAC.writeBinarySAC(new File(String.valueOf(fn) + "d"), hd);
            }
            ++n2;
        }
        return 0;
    }

    static void water(Complex[] a, int nft, double dt, double c, double gauss) {
        double agg;
        double u = 1.0 + c;
        double[] d2 = new double[nft + 1];
        double delw = Math.PI / (dt * (double)nft);
        d2[0] = a[0].x * a[0].x;
        d2[nft] = a[0].y * a[0].y;
        double water = d2[0] + d2[nft];
        int j = 1;
        while (j < nft) {
            d2[j] = a[j].x * a[j].x + a[j].y * a[j].y;
            water += d2[j];
            ++j;
        }
        water = c * water / (double)nft;
        a[0].x *= u / (d2[0] + water);
        double w = delw;
        j = 1;
        while (j < nft) {
            agg = 0.5 * w / gauss;
            a[j] = Complex.dmltp(u * Math.exp(-agg * agg) / (d2[j] + water), Complex.conjg(a[j]));
            ++j;
            w += delw;
        }
        agg = 0.5 * w / gauss;
        a[0].y *= u * Math.exp(-agg * agg) / (d2[j] + water);
    }

    static void toeplitz(double[] r, double[] g, int n, double u) {
        int i;
        double[] a = new double[n];
        double[] x = new double[n];
        double[] aa = new double[n];
        double[] xx = new double[n];
        double v = (1.0 + u) * r[0];
        aa[0] = 1.0;
        xx[0] = g[0] / v;
        int j = 1;
        while (j < n) {
            double dd = 0.0;
            double bb = 0.0;
            i = 0;
            while (i < j) {
                int k = j - i;
                dd += r[k] * aa[i];
                bb += r[k] * xx[i];
                ++i;
            }
            a[0] = 1.0;
            a[j] = -dd / v;
            i = 1;
            while (i < j) {
                a[i] = aa[i] + a[j] * aa[j - i];
                ++i;
            }
            x[j] = (g[j] - bb) / (v += dd * a[j]);
            i = 0;
            while (i < j) {
                x[i] = xx[i] + x[j] * a[j - i];
                ++i;
            }
            i = 0;
            while (i <= j) {
                aa[i] = a[i];
                xx[i] = x[i];
                ++i;
            }
            ++j;
        }
        u += 1.0;
        i = 0;
        while (i < n) {
            g[i] = u * x[i];
            ++i;
        }
    }

    public static float[] read_sac(File f, SAC hd, int tmark, float t1, float t2) throws IOException {
        hd.readBinarySAC(f);
        int nn = (int)Math.rint((t2 - t1) / hd.DELTA);
        if (nn <= 0) {
            return null;
        }
        float tref = 0.0f;
        switch (tmark) {
            case -5: {
                tref = hd.B;
                break;
            }
            case -3: {
                tref = hd.O;
                break;
            }
            case -2: {
                tref = hd.A;
                break;
            }
            case 0: {
                tref = hd.USER0;
                break;
            }
            case 1: {
                tref = hd.USER1;
                break;
            }
            case 2: {
                tref = hd.USER2;
                break;
            }
            case 3: {
                tref = hd.USER3;
                break;
            }
            case 4: {
                tref = hd.USER4;
                break;
            }
            case 5: {
                tref = hd.USER5;
                break;
            }
            case 6: {
                tref = hd.USER6;
                break;
            }
            case 7: {
                tref = hd.USER7;
                break;
            }
            case 8: {
                tref = hd.USER8;
                break;
            }
            case 9: {
                tref = hd.USER9;
                break;
            }
            default: {
                return null;
            }
        }
        if ((double)tref == -12345.0) {
            System.out.printf("Time mark undefined\n", new Object[0]);
            return null;
        }
        int nt1 = (int)Math.rint(((t1 += tref) - hd.B) / hd.DELTA);
        int nt2 = nt1 + nn;
        int npts = hd.NPTS;
        hd.NPTS = nn;
        hd.B = t1;
        hd.E = t1 + (float)nn * hd.DELTA;
        if (nt1 < 0 || nt2 < 0 || nt1 >= npts || nt2 >= npts) {
            return null;
        }
        nn = nt2 - nt1;
        System.arraycopy(hd.data1, nt1, hd.data1, 0, nn);
        return hd.data1;
    }
}

