/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.fk;

import cn.org.gddsn.seis.fk.Slbbfk;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.apache.commons.math.complex.Complex;
import org.netlib.util.StringW;
import org.netlib.util.floatW;
import org.netlib.util.intW;

public class FK {
    public static void main(String[] args) throws IOException {
        int max_trace = 45;
        int max_arrlth = 45000;
        int max_wrkspc = 51000;
        int max_clxdim = 51000;
        String data_file = "TestData/fk/fk_signal.dat";
        String hdr_file = "TestData/fk/fk_signal.hdr";
        String out_file = "TestData/fk/fk_signal.out.new";
        String line = new String("");
        int chan_num = 0;
        int i = 0;
        int j = 0;
        int index = 0;
        float frq_lo = 0.0f;
        float frq_hi = 0.0f;
        float max_slowness = 0.0f;
        float max_slowness_km = 0.0f;
        int unit_in_deg = 0;
        int grid_pts = 0;
        int verbosity = 0;
        floatW app_veloc = new floatW(0.0f);
        float res_slowness = 0.0f;
        floatW azimuth = new floatW(0.0f);
        floatW sx_max = new floatW(0.0f);
        floatW sy_max = new floatW(0.0f);
        floatW frq_lo_out = new floatW(0.0f);
        floatW frq_hi_out = new floatW(0.0f);
        floatW power = new floatW(0.0f);
        floatW abs_power = new floatW(0.0f);
        intW quality = new intW(0);
        StringW errMsg = new StringW("");
        String instr = new String("");
        int clxdim = 0;
        int wrkdim = 0;
        float alpha = 0.0f;
        float beta = 0.0f;
        float theta = 0.0f;
        float[] fdat = new float[max_arrlth];
        String[] station = new String[max_trace];
        float[] stat_x = new float[max_trace];
        float[] stat_y = new float[max_trace];
        float[] elevation = new float[max_trace];
        int[] chan_ptr = new int[max_trace];
        int[] chan_lth = new int[max_trace];
        float[] chan_dt = new float[max_trace];
        float[] wdw_start = new float[max_trace];
        float[] wdw_end = new float[max_trace];
        float[] work_spc = new float[max_wrkspc];
        Complex[] clxbuf = new Complex[max_clxdim];
        i = 0;
        while (i < clxbuf.length) {
            clxbuf[i] = new Complex(0.0, 0.0);
            ++i;
        }
        PrintWriter out = new PrintWriter(new FileWriter(out_file));
        BufferedReader hdr = new BufferedReader(new FileReader(hdr_file));
        while ((line = hdr.readLine()).startsWith("!")) {
            out.println(line);
        }
        Scanner s = new Scanner(line);
        chan_num = s.nextInt();
        s.close();
        if (chan_num > max_trace) {
            System.err.println("STOP: too many traces");
            System.exit(0);
        }
        i = 0;
        while (i < chan_num) {
            line = hdr.readLine();
            s = new Scanner(line);
            stat_x[i] = s.nextFloat();
            stat_y[i] = s.nextFloat();
            elevation[i] = s.nextFloat();
            station[i] = s.next();
            s.close();
            ++i;
        }
        line = hdr.readLine();
        s = new Scanner(line);
        frq_lo = s.nextFloat();
        frq_hi = s.nextFloat();
        s.close();
        line = hdr.readLine();
        s = new Scanner(line);
        max_slowness = s.nextFloat();
        s.close();
        line = hdr.readLine();
        s = new Scanner(line);
        grid_pts = s.nextInt();
        s.close();
        line = hdr.readLine();
        s = new Scanner(line);
        verbosity = s.nextInt();
        s.close();
        line = hdr.readLine();
        s = new Scanner(line);
        unit_in_deg = s.nextInt();
        s.close();
        max_slowness_km = max_slowness;
        if (unit_in_deg == 1) {
            max_slowness_km /= 111.19f;
        }
        if (grid_pts * grid_pts + grid_pts / 2 > max_wrkspc) {
            System.err.println("STOP: work space small");
            System.exit(0);
        }
        hdr.close();
        index = 1;
        s = new Scanner(new File(data_file));
        i = 0;
        while (i < chan_num) {
            s.next();
            chan_dt[i] = s.nextFloat();
            s.next();
            chan_lth[i] = s.nextInt();
            if (index + chan_lth[i] > max_arrlth) {
                System.err.println("STOP: too many samples");
                System.exit(0);
            }
            j = 0;
            while (j < chan_lth[i]) {
                fdat[index - 1 + j] = s.nextFloat();
                ++j;
            }
            chan_ptr[i] = index;
            index += chan_lth[i];
            wdw_start[i] = 0.0f;
            wdw_end[i] = (float)chan_lth[i] * chan_dt[i];
            ++i;
        }
        s.close();
        if (verbosity >= 2) {
            i = 0;
            while (i < chan_num) {
                System.out.printf("%s  %d  %f  %d  %f  %f  %.1f\n", station[i], chan_lth[i], Float.valueOf(chan_dt[i]), chan_ptr[i], Float.valueOf(stat_x[i]), Float.valueOf(stat_y[i]), Float.valueOf(elevation[i]));
                ++i;
            }
        }
        theta = 90.0f;
        instr = "VERTICAL";
        clxdim = max_clxdim;
        wrkdim = max_wrkspc;
        Slbbfk.slbbfk(fdat, 0, chan_ptr, 0, chan_lth, 0, chan_dt, 0, wdw_start, 0, wdw_end, 0, station, 0, instr, frq_lo, frq_hi, stat_x, stat_y, elevation, max_slowness_km, chan_num, alpha, beta, theta, grid_pts, work_spc, 0, wrkdim, clxbuf, 0, clxdim, app_veloc, azimuth, sx_max, sy_max, frq_lo_out, frq_hi_out, power, abs_power, quality, errMsg, verbosity);
        if (unit_in_deg == 1) {
            app_veloc.val /= 111.19f;
            sx_max.val *= 111.19f;
            sy_max.val *= 111.19f;
        }
        res_slowness = 1.0f / app_veloc.val;
        if (verbosity > 0) {
            System.out.printf("apparent velocity %7.2f\n", Float.valueOf(app_veloc.val));
            System.out.printf("slowness          %7.2f\n", Float.valueOf(res_slowness));
            System.out.printf("azimuth           %7.2f\n", Float.valueOf(azimuth.val));
            System.out.printf("Sx max            %7.2f\n", Float.valueOf(sx_max.val));
            System.out.printf("Sy max            %7.2f\n", Float.valueOf(sy_max.val));
            System.out.printf("low frq           %7.2f\n", Float.valueOf(frq_lo_out.val));
            System.out.printf("high frq          %7.2f\n", Float.valueOf(frq_hi_out.val));
            System.out.printf("power             %7.2f\n", Float.valueOf(power.val));
            System.out.printf("abs power         %7.2f\n", Float.valueOf(abs_power.val));
            System.out.printf("quality           %7d\n", quality.val);
            System.out.printf("msg               %s\n", errMsg.val);
        }
        out.printf("!* apparent veloc. : %7.2f\n", Float.valueOf(app_veloc.val));
        out.printf("!* slowness        : %7.2f\n", Float.valueOf(res_slowness));
        out.printf("!* azimuth         : %7.1f\n", Float.valueOf(azimuth.val));
        out.printf("!* max. slow.      : %7.2f,%7.2f\n", Float.valueOf(sx_max.val), Float.valueOf(sy_max.val));
        out.printf("!* slowness range  : %7.2f\n", Float.valueOf(max_slowness));
        out.printf("!* frq. wdw.       : %7.2f,%7.2f\n", Float.valueOf(frq_lo_out.val), Float.valueOf(frq_hi_out.val));
        out.printf("!* rel. power      : %7.2f\n", Float.valueOf(power.val));
        out.printf("!* abs. power      : %7.2f\n", Float.valueOf(abs_power.val));
        out.printf("!* quality         : %7d\n", quality.val);
        out.printf("%4d%4d\n", grid_pts, grid_pts);
        i = 0;
        while (i < grid_pts * grid_pts) {
            out.printf("%.6f\n", Float.valueOf(work_spc[i]));
            ++i;
        }
        out.close();
    }

    public static class FK_IN {
        public int nchan = 0;
        public String[] channel;
        public float[] stat_x;
        public float[] stat_y;
        public float[] elevation;
        public float freqLo;
        public float freqHi;
        public float max_slowness = 0.0f;
        public String instr = new String("VERTICAL");
        public float alpha = 0.0f;
        public float beta = 0.0f;
        public float theta = 90.0f;
        public float[] fdat;
        public int[] chanPtr;
        public int[] chanLen;
        public float[] chanDelta;
        public float[] wdwStart;
        public float[] wdwEnd;
        public Complex[] clxbuf;
        public int clxdim = 0;
    }

    public static class FK_RES {
        public float apparentVel;
        public float azimuth;
        public float sx_max;
        public float sy_max;
        public float freqLo;
        public float freqHi;
        public float power;
        public float absPower;
        public int quality;
        public String errMsg = "";
        public int grdPts;
        public float[] workBuf;
        public int wrkdim = 0;
    }
}

