/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.smwin32;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SMWin32Data {
    static Logger logger = Logger.getLogger(SMWin32Data.class);
    public int dataFormatID = 0;
    public int dataFormatID1 = 0;
    public int typeID = 0;
    public int orgID = 0;
    public int netID = 0;
    public int sensorID = 0;
    public int headBlockLength = 0;
    public int dataBlockLength = 0;
    public float staLat = 0.0f;
    public float staLon = 0.0f;
    public float staAlt = 0.0f;
    public float staAlt0 = 0.0f;
    public String staName = "";
    public long startRecordTime = 0L;
    public long nowSampleTime = 0L;
    public int recordLength = 0;
    public long lastAdjustmentTime = 0L;
    public int timeAdjustmentMode = 0;
    public int coordinate = 1;
    public String sensorType = "";
    public int srate = 100;
    public int chlNum = 3;
    public int moveFlag = 0;
    public ChannelInfo[] ci;
    public int eqInfo = 57376;
    public EQInfo ei;
    public int frameInterval = 0;

    public void readSMWin32(DataInputStream dis) throws IOException {
        this.dataFormatID = dis.readByte();
        this.dataFormatID1 = dis.readByte();
        dis.readByte();
        dis.readByte();
        this.typeID = dis.readByte();
        dis.readByte();
        dis.readByte();
        dis.readByte();
        this.orgID = dis.readByte();
        this.netID = dis.readByte();
        this.sensorID = dis.readShort();
        this.headBlockLength = dis.readInt();
        dis.readInt();
        byte[] bt = new byte[4];
        dis.read(bt);
        this.staLat = this.getLatLon(this.bcd2Str(bt, 8, false));
        dis.read(bt);
        this.staLon = this.getLatLon(this.bcd2Str(bt, 8, false));
        dis.read(bt);
        this.staAlt = this.getAltitude(this.bcd2Str(bt, 8, false), 2);
        if (this.netID == 17) {
            dis.read(bt);
            this.staAlt0 = this.getAltitude(this.bcd2Str(bt, 8, false), 2);
        }
        bt = new byte[12];
        dis.read(bt);
        this.staName = this.getStaName(bt);
        bt = new byte[8];
        dis.read(bt);
        this.startRecordTime = this.getBCDTime(bt);
        this.recordLength = (int)((double)dis.readInt() * 0.1);
        dis.read(bt);
        this.lastAdjustmentTime = this.getBCDTime(bt);
        this.timeAdjustmentMode = dis.readByte();
        this.coordinate = dis.readByte();
        this.sensorType = this.getSensorType(dis.readShort());
        this.srate = dis.readShort();
        this.chlNum = dis.readByte();
        this.moveFlag = dis.readByte();
        bt = new byte[20];
        this.ci = new ChannelInfo[this.chlNum];
        int i = 0;
        while (i < this.ci.length) {
            String chlCode = "";
            dis.read(bt);
            switch (i) {
                case 0: {
                    chlCode = "SHN";
                    break;
                }
                case 1: {
                    chlCode = "SHE";
                    break;
                }
                case 2: {
                    chlCode = "SHZ";
                    break;
                }
                case 3: {
                    chlCode = "BHN";
                    break;
                }
                case 4: {
                    chlCode = "BHE";
                    break;
                }
                case 5: {
                    chlCode = "BHZ";
                    break;
                }
            }
            this.ci[i] = new ChannelInfo(chlCode, bt);
            ++i;
        }
        this.eqInfo = dis.readUnsignedShort();
        int len = dis.readUnsignedShort();
        if (len != 24) {
            logger.error((Object)String.format("the size of eq information must be 24 byte! now = %4d", len));
        } else {
            bt = new byte[len];
            dis.read(bt);
            this.ei = new EQInfo(bt);
        }
        int sec = 0;
        while (dis.available() > 0) {
            bt = new byte[8];
            dis.read(bt);
            this.nowSampleTime = this.getBCDTime(bt);
            if (sec == 0) {
                if (this.nowSampleTime != this.startRecordTime) {
                    // empty if block
                }
                this.startRecordTime = this.nowSampleTime;
            }
            this.frameInterval = (int)((double)dis.readInt() * 0.1);
            this.dataBlockLength += dis.readInt();
            int nByte = 0;
            int i2 = 0;
            while (i2 < this.ci.length) {
                byte orgid = dis.readByte();
                byte netid = dis.readByte();
                short chlid = dis.readShort();
                nByte += 4;
                int j = 0;
                while (j < this.ci.length) {
                    if (orgid == this.ci[j].cOrgID && netid == this.ci[j].cNetID && chlid == this.ci[j].chlID) {
                        int k;
                        int ngaps;
                        short a = dis.readShort();
                        int bitSize = a >>> 12 & 0xF;
                        int n = a & 0xFFF;
                        int[] data = new int[n];
                        data[0] = dis.readInt();
                        nByte += 6;
                        block8 : switch (bitSize) {
                            case 0: {
                                int k2 = 1;
                                while (k2 < n) {
                                    byte b = dis.readByte();
                                    ++nByte;
                                    int d0 = b >> 4;
                                    data[k2] = data[k2 - 1] + d0;
                                    if (k2 + 1 >= n) break block8;
                                    d0 = b << 28;
                                    data[k2 + 1] = data[k2] + (d0 >>= 28);
                                    k2 += 2;
                                }
                                break;
                            }
                            case 1: {
                                int k2 = 1;
                                while (k2 < n) {
                                    data[k2] = data[k2 - 1] + dis.readByte();
                                    ++nByte;
                                    ++k2;
                                }
                                break;
                            }
                            case 2: {
                                int k2 = 1;
                                while (k2 < n) {
                                    data[k2] = data[k2 - 1] + dis.readShort();
                                    nByte += 2;
                                    ++k2;
                                }
                                break;
                            }
                            case 3: {
                                int k2 = 1;
                                while (k2 < n) {
                                    byte b1 = dis.readByte();
                                    int s2 = dis.readShort() & 0xFFFF;
                                    int d3 = (b1 << 24) + (s2 << 8);
                                    data[k2] = data[k2 - 1] + (d3 >>= 8);
                                    nByte += 3;
                                    ++k2;
                                }
                                break;
                            }
                            case 4: {
                                int k2 = 1;
                                while (k2 < n) {
                                    data[k2] = data[k2 - 1] + dis.readInt();
                                    nByte += 4;
                                    ++k2;
                                }
                                break;
                            }
                            default: {
                                logger.warn((Object)("Wrong bit size: " + bitSize));
                            }
                        }
                        if (n / this.frameInterval != this.srate) {
                            logger.warn((Object)String.format("n/frameInterval != srate: %4d/%4d != %4d", n, this.frameInterval, this.srate));
                        } else if (this.ci[j].dataList == null) {
                            this.ci[j].dataList = new ArrayList(12000);
                            ngaps = sec * this.srate;
                            if (ngaps > 0) {
                                k = 0;
                                while (k < ngaps) {
                                    this.ci[j].dataList.add(0);
                                    ++k;
                                }
                            }
                            k = 0;
                            while (k < n) {
                                this.ci[j].dataList.add(data[k]);
                                ++k;
                            }
                        } else {
                            ngaps = sec * this.srate - this.ci[j].dataList.size();
                            if (ngaps > 0) {
                                k = 0;
                                while (k < ngaps) {
                                    this.ci[j].dataList.add(0);
                                    ++k;
                                }
                            }
                            if (ngaps >= 0) {
                                k = 0;
                                while (k < n) {
                                    this.ci[j].dataList.add(data[k]);
                                    ++k;
                                }
                            }
                        }
                    }
                    ++j;
                }
                ++i2;
            }
            sec += this.frameInterval;
        }
    }

    private String bcd2Str(byte[] input, int numDigits, boolean nibble) {
        int i = 0;
        String shex = "";
        int digit = 0;
        while (digit < numDigits) {
            int decimal = nibble ? input[i] & 0xF : (input[i] & 0xF0) >>> 4;
            shex = String.valueOf(shex) + Integer.toHexString(decimal);
            if (nibble) {
                ++i;
            }
            nibble = !nibble;
            ++digit;
        }
        return shex;
    }

    private float getLatLon(String s) {
        float latLon = 0.0f;
        if (s.startsWith("b")) {
            logger.info((Object)"station lat./lon. unknow!");
            return latLon;
        }
        int len = s.length();
        int index = s.indexOf("e");
        if (index > 0) {
            s = s.substring(0, index);
        } else {
            index = 0;
        }
        latLon = (float)((double)Integer.valueOf(s).intValue() / Math.pow(10.0, 5 - (len - index)));
        return latLon;
    }

    private float getAltitude(String s, int point) {
        float alt = 0.0f;
        int sign = 1;
        if (s.startsWith("b")) {
            logger.info((Object)"station alt. unknow!");
            return alt;
        }
        if (s.startsWith("d")) {
            sign = -1;
        }
        s = s.substring(1);
        int len = s.length();
        int index = s.indexOf("e");
        if (index > 0) {
            s = s.substring(0, index);
        } else {
            index = len;
        }
        alt = (float)((double)Integer.valueOf(s).intValue() / Math.pow(10.0, point - (len - index)));
        return (float)sign * alt;
    }

    private float getMag(String s) {
        float m = 0.0f;
        if (s.startsWith("b")) {
            logger.info((Object)"EQ mag. unknow!");
            return m;
        }
        int index = s.indexOf("e");
        if (index > 0) {
            s = s.substring(0, index);
        } else {
            index = 0;
        }
        m = (float)((double)Integer.valueOf(s).intValue() / Math.pow(10.0, 1 - index));
        return m;
    }

    private String getStaName(byte[] bt) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bt.length) {
            sb.append((char)bt[i]);
            ++i;
        }
        return sb.toString().trim();
    }

    private long getBCDTime(byte[] bt) {
        long t = 0L;
        String s = this.bcd2Str(bt, 16, false);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSS");
        try {
            t = sdf.parse(s).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return t;
    }

    private String getSensorType(int id) {
        String type = "";
        switch (id) {
            case 0: {
                type = "";
                break;
            }
            case 1: {
                type = "K-NET95";
                break;
            }
            case 2: {
                type = "SMAC-MDU";
                break;
            }
            case 4: {
                type = "K-NET02";
                break;
            }
            case 5: {
                type = "K-NET02A";
                break;
            }
            case 11: {
                type = "SMAC-K/MDK";
                break;
            }
            case 13: {
                type = "KIK-net06a";
                break;
            }
            case 14: {
                type = "KIK-net06";
                break;
            }
        }
        return type;
    }

    public static void main(String[] args) throws IOException {
        String file = "/home/gddsn/documents/strong_motion_records/testdata/AIC0021103120359.kwin";
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        SMWin32Data sd = new SMWin32Data();
        sd.readSMWin32(dis);
        dis.close();
        System.out.println(sd.staName);
    }

    class ChannelInfo {
        public String chlCode = "";
        public int cOrgID = 0;
        public int cNetID = 0;
        public int chlID = 0;
        public double gain = 0.0;
        public int unit = 0;
        public String unitS = "";
        public double factor = 0.0;
        public int maxCounts = 0;
        public long cStartRecordTime = 0L;
        public ArrayList<Integer> dataList;

        public ChannelInfo(String chlCode, byte[] bt) {
            this.chlCode = chlCode;
            if (bt.length != 20) {
                logger.error((Object)String.format("the size of channel information must be 20 byte! now = %4d", bt.length));
                return;
            }
            ByteBuffer bb = ByteBuffer.wrap(bt);
            this.cOrgID = bb.get();
            this.cNetID = bb.get();
            this.chlID = bb.getShort();
            double fNum = bb.getShort();
            this.gain = bb.get();
            this.getUnits(bb.get());
            double fDen = bb.getInt();
            this.factor = fNum / fDen;
            bb.getInt();
            this.maxCounts = bb.getInt();
            this.dataList = new ArrayList();
            this.factor *= this.gain;
            this.gain = 1.0;
        }

        void getUnits(byte bt) {
            int u = bt & 0xF;
            int g = bt >>> 4 & 0xF;
            if (u == 0) {
                this.unitS = "";
                logger.warn((Object)"Don't set unit");
            } else if (u == 1) {
                this.unitS = "m";
                this.gain *= Math.pow(10.0, -1 * g);
            } else if (u == 2) {
                this.unitS = "m/s";
                this.gain *= Math.pow(10.0, -1 * g);
            } else if (u == 3) {
                this.unitS = "m/s/s";
                this.gain *= Math.pow(10.0, -1 * g);
            } else {
                this.unitS = "";
                logger.warn((Object)"Don't set unit");
            }
        }
    }

    class EQInfo {
        public long eqOrigTime = 0L;
        public float eqLat = 0.0f;
        public float eqLon = 0.0f;
        public float eqDep = 0.0f;
        public float eqMag = 0.0f;
        public int coordinate = 1;
        public int eqType = 0;

        public EQInfo(byte[] bt) {
            ByteBuffer bb = ByteBuffer.wrap(bt);
            byte[] bt0 = new byte[8];
            bb.get(bt0);
            this.eqOrigTime = SMWin32Data.this.getBCDTime(bt0);
            bt0 = new byte[4];
            bb.get(bt0);
            this.eqLat = SMWin32Data.this.getLatLon(SMWin32Data.this.bcd2Str(bt0, 8, false));
            bb.get(bt0);
            this.eqLon = SMWin32Data.this.getLatLon(SMWin32Data.this.bcd2Str(bt0, 8, false));
            bb.get(bt0);
            this.eqDep = SMWin32Data.this.getAltitude(SMWin32Data.this.bcd2Str(bt0, 8, false), 3);
            bt0 = new byte[1];
            bb.get(bt0);
            this.eqMag = SMWin32Data.this.getMag(SMWin32Data.this.bcd2Str(bt0, 2, false));
            this.coordinate = bb.get();
            this.eqType = bb.get();
        }
    }
}

