/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.seed;

import cn.org.gddsn.jopens.entity.EventInfo;
import cn.org.gddsn.jopens.entity.SeedConfig;
import cn.org.gddsn.jopens.entity.Waveform;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.service.ArchiveWaveServerPlugin;
import cn.org.gddsn.jopens.service.ChannelWaveform;
import cn.org.gddsn.jopens.service.SeedCache;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.evtformat.seed.SeedVolumePlugin;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import edu.iris.miniseedutils.steim.MiniSeedRecord;
import edu.iris.timeutils.TimeStamp;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class SeedVolumeDatabasePlugin
implements SeedVolumePlugin {
    static Logger logger = Logger.getLogger(SeedVolumeDatabasePlugin.class);
    private SeedVolumeService seedVolumeService;
    private String eventId = null;
    private Date startTime;
    private Date endTime;
    private List<Waveform> wfs;
    private int waveformSize = 0;
    private int count = 0;
    private boolean useTimeSpan = false;
    private int preFetchSize = 1200;
    private DataSource waveformDataStore;
    private Connection waveformConnection;
    private Dataless dl = null;
    private boolean useWaveformDataStore = false;
    private Statement stmt = null;
    private ResultSet rs = null;
    private GenericMiniSeedRecord g_512 = new GenericMiniSeedRecord(64, 512);
    private GenericMiniSeedRecord g_4096 = new GenericMiniSeedRecord(64, 4096);
    private MiniSeedRecord msr = new MiniSeedRecord();
    private String networkRegex = null;
    private String stationRegex = null;
    private String locIdRegex = null;
    private String chanRegex = null;
    private SeedCache seedCache = null;
    private ArchiveWaveServerPlugin archiveWaveServerPlugin;

    public void setSource(Object source, Object extr) {
        if (source instanceof String && extr == null) {
            this.eventId = (String)source;
            this.getDataless();
            this.useTimeSpan = false;
            if (this.useWaveformDataStore) {
                try {
                    this.initDataStore();
                }
                catch (SQLException ex) {
                    logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    this.waveformSize = 0;
                }
            } else {
                long now_ms = System.currentTimeMillis();
                this.wfs = this.seedVolumeService.getWaveform(this.eventId);
                this.waveformSize = this.wfs.size();
                logger.info((Object)("waveform size:" + this.waveformSize));
                logger.info((Object)("waveform query time: " + (System.currentTimeMillis() - now_ms)));
                this.count = 0;
                if (this.waveformSize == 0 && this.waveformDataStore != null) {
                    try {
                        this.initDataStore();
                    }
                    catch (SQLException ex) {
                        logger.warn((Object)ex.getMessage(), (Throwable)ex);
                        this.waveformSize = 0;
                    }
                }
            }
        } else if (source instanceof Date && extr instanceof Date) {
            this.useTimeSpan = true;
            this.getDataless();
            this.startTime = (Date)source;
            this.endTime = (Date)extr;
            this.eventId = null;
            if (this.archiveWaveServerPlugin != null) {
                this.archiveWaveServerPlugin.setTimespan(this.networkRegex, this.stationRegex, this.locIdRegex, this.chanRegex, this.startTime, this.endTime);
            } else {
                this.waveformSize = 0;
                if (this.useWaveformDataStore) {
                    try {
                        this.initDataStore();
                    }
                    catch (SQLException ex) {
                        logger.warn((Object)ex.getMessage(), (Throwable)ex);
                        this.waveformSize = 0;
                    }
                } else if (this.waveformSize == 0 && this.waveformDataStore != null) {
                    try {
                        this.initDataStore();
                    }
                    catch (SQLException ex) {
                        logger.warn((Object)ex.getMessage(), (Throwable)ex);
                        this.waveformSize = 0;
                    }
                }
            }
        } else if (source instanceof String && extr instanceof String) {
            this.eventId = (String)source;
            this.getDataless();
            this.useTimeSpan = true;
            this.startTime = this.dl.getVolumeIndex().getBlockette010().getStartTime();
            this.endTime = this.dl.getVolumeIndex().getBlockette010().getEndTime();
            if (this.archiveWaveServerPlugin != null) {
                this.archiveWaveServerPlugin.setTimespan(this.networkRegex, this.stationRegex, this.locIdRegex, this.chanRegex, this.startTime, this.endTime);
            } else if (this.useWaveformDataStore) {
                try {
                    this.initDataStore();
                }
                catch (SQLException ex) {
                    logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    this.waveformSize = 0;
                }
            } else if (this.waveformSize == 0 && this.waveformDataStore != null) {
                try {
                    this.initDataStore();
                }
                catch (SQLException ex) {
                    logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    this.waveformSize = 0;
                }
            }
        } else {
            new IllegalArgumentException("arg should be Long or Date");
        }
    }

    public void cleanUpSource() {
        if (this.wfs != null) {
            this.wfs.clear();
            this.wfs = null;
        }
        this.waveformSize = 0;
        this.count = 0;
        this.eventId = null;
        this.endTime = null;
        this.startTime = null;
        try {
            if (this.rs != null) {
                this.rs.close();
                this.rs = null;
            }
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
            if (this.waveformConnection != null) {
                this.waveformConnection.close();
                this.waveformConnection = null;
            }
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        if (this.archiveWaveServerPlugin != null) {
            this.archiveWaveServerPlugin.cleanup();
        }
        this.dl = null;
    }

    public boolean accept(ChannelLocator cl, double sampRate) {
        return true;
    }

    public Dataless getDataless() {
        if (this.dl != null) {
            return this.dl;
        }
        long now_ms = new Date().getTime();
        long datalessId = -1L;
        datalessId = this.eventId == null ? this.seedVolumeService.findNetworkInfoSelf().getUniCode() : this.seedVolumeService.findDatalessIdByEventId(this.eventId);
        logger.info((Object)("Dataless Id: " + datalessId));
        this.dl = this.seedVolumeService.findDatalessById(datalessId, false, false);
        if (this.dl == null) {
            return null;
        }
        if (this.dl.getSaveTime() == null || this.dl.getSeedConfig().getSaveTime() == null) {
            this.dl.setSaveTime(new Timestamp(new Date().getTime()));
            this.dl.getSeedConfig().setSaveTime(new Timestamp(new Date().getTime()));
            this.seedVolumeService.writeDataless(this.dl);
        }
        Dataless cacheDl = null;
        if (this.seedCache != null && (cacheDl = this.seedCache.getDataless(datalessId)) != null && cacheDl.getId() == this.dl.getId() && cacheDl.getSaveTime().getTime() == this.dl.getSaveTime().getTime()) {
            this.dl = cacheDl;
            logger.info((Object)("Using client side cache Dataless: " + this.dl.getId()));
        } else {
            this.dl = this.seedVolumeService.findDatalessById(datalessId, true, false);
            if (this.seedCache != null) {
                this.seedCache.updateDataless(this.dl);
            }
        }
        long scId = this.dl.getSeedConfig().getId();
        SeedConfig cacheSC = null;
        if (this.seedCache != null && (cacheSC = this.seedCache.getSeedConfig(scId)) != null && cacheSC.getId() == this.dl.getSeedConfig().getId() && cacheSC.getSaveTime().getTime() == this.dl.getSeedConfig().getSaveTime().getTime()) {
            this.dl.setSeedConfig(cacheSC);
            logger.info((Object)("Using client side cache SeedConfig: " + cacheSC.getId()));
        } else {
            cacheSC = this.seedVolumeService.findSeedConfig(scId);
            this.dl.setSeedConfig(cacheSC);
            if (this.seedCache != null) {
                this.seedCache.updateSeedConfig(cacheSC);
            }
        }
        if (this.eventId != null) {
            EventInfo ei = this.seedVolumeService.getTimeInfo(this.eventId);
            this.dl.getVolumeIndex().getBlockette010().setStartTime(new Timestamp(ei.getStartTime().getTime()));
            this.dl.getVolumeIndex().getBlockette010().setEndTime(new Timestamp(ei.getEndTime().getTime()));
        }
        long n_now_ms = new Date().getTime();
        logger.info((Object)("Station Query Time :" + (n_now_ms - now_ms)));
        return this.dl;
    }

    private void initDataStore() throws SQLException {
        long now_ms = System.currentTimeMillis();
        this.waveformConnection = this.waveformDataStore.getConnection();
        this.stmt = this.waveformConnection.createStatement();
        String channelFilter = "";
        if (this.networkRegex != null && this.networkRegex.length() != 0) {
            channelFilter = String.valueOf(channelFilter) + " AND Net_code REGEXP '" + this.networkRegex + "'";
        }
        if (this.stationRegex != null && this.stationRegex.length() != 0) {
            channelFilter = String.valueOf(channelFilter) + " AND Sta_code REGEXP '" + this.stationRegex + "'";
        }
        if (this.locIdRegex != null && this.locIdRegex.length() != 0) {
            channelFilter = String.valueOf(channelFilter) + " AND Loc_id REGEXP '" + this.locIdRegex + "'";
        }
        if (this.chanRegex != null && this.chanRegex.length() != 0) {
            channelFilter = String.valueOf(channelFilter) + " AND Chn_code REGEXP '" + this.chanRegex + "'";
        }
        if (this.useTimeSpan) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String start_time = sdf.format(new Date(this.startTime.getTime() - (long)this.preFetchSize * 1000L));
            String end_time = sdf.format(this.endTime);
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(new Date(this.startTime.getTime() - (long)this.preFetchSize * 1000L));
            c.setTime(this.endTime);
            String sqlStr = "select * from Waveform_con where Start_time >= '" + start_time + "' AND Start_time <= '" + end_time + "'" + channelFilter + " order by Net_code, Sta_code, Loc_id, Chn_code, Start_time, Start_time_frac";
            this.rs = this.stmt.executeQuery(sqlStr);
        } else {
            String sqlStr = "select * from Waveform_event where Event_id='" + this.eventId + "'" + channelFilter + " order by Net_code, Sta_code, Loc_id, Chn_code, Start_time, Start_time_frac";
            this.rs = this.stmt.executeQuery(sqlStr);
        }
        logger.info((Object)("waveform query time: " + (System.currentTimeMillis() - now_ms)));
    }

    private MiniSeedRecord getNextMiniSeedDataFromDataStore() throws SQLException {
        int len;
        if (!this.rs.next()) {
            return null;
        }
        Blob waveform = this.rs.getBlob("waveform");
        byte[] buf = waveform.getBytes(1L, len = (int)waveform.length());
        if (buf.length % 512 != 0) {
            logger.warn((Object)("Internal Error! buf.length =" + buf.length));
        }
        this.msr.setNetwork(this.rs.getString("Net_code"));
        this.msr.setStation(this.rs.getString("Sta_code"));
        this.msr.setLocID(this.rs.getString("Loc_id"));
        this.msr.setChannel(this.rs.getString("Chn_code"));
        double st = (double)this.rs.getTimestamp("Start_time").getTime() / 1000.0 + (double)this.rs.getInt("Start_time_frac") / 10000.0;
        this.msr.setStartTime(st);
        double ed = (double)this.rs.getTimestamp("End_time").getTime() / 1000.0 + (double)this.rs.getInt("End_time_frac") / 10000.0;
        this.msr.setEndTime(ed);
        this.msr.setSampleRate(this.rs.getDouble("Samp_rate"));
        this.msr.setRecordLength(this.rs.getInt("Rec_lenth"));
        int nsamples = (int)Math.round((this.msr.getEndTime() - this.msr.getStartTime()) * this.msr.getSampleRate());
        this.msr.setNumSamples(nsamples);
        this.msr.setData(new int[nsamples]);
        if (this.msr.getRecordLength() == 4096) {
            this.decodeMiniSeed(buf, 4096, this.g_4096, this.msr);
        } else {
            this.decodeMiniSeed(buf, 512, this.g_512, this.msr);
        }
        return this.msr;
    }

    public MiniSeedRecord getNextMiniSeedData() {
        if (this.useTimeSpan && this.archiveWaveServerPlugin != null) {
            return this.archiveWaveServerPlugin.getNextMiniSeedData();
        }
        if (this.useWaveformDataStore) {
            MiniSeedRecord gmsr = null;
            try {
                gmsr = this.getNextMiniSeedDataFromDataStore();
            }
            catch (SQLException ex) {
                logger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            return gmsr;
        }
        if (this.waveformSize == 0 && this.waveformDataStore != null) {
            MiniSeedRecord gmsr = null;
            try {
                gmsr = this.getNextMiniSeedDataFromDataStore();
            }
            catch (SQLException ex) {
                logger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            return gmsr;
        }
        if (this.count < this.waveformSize) {
            Waveform w = this.wfs.get(this.count++);
            this.msr.setNetwork(w.getChannelLocator().getNetCode());
            this.msr.setStation(w.getChannelLocator().getStationCode());
            this.msr.setLocID(w.getChannelLocator().getLocId());
            this.msr.setChannel(w.getChannelLocator().getChanCode());
            double st = (double)w.getStartTime().getTime() / 1000.0 + (double)w.getStartTimeFrac() / 10000.0;
            this.msr.setStartTime(st);
            double ed = (double)w.getEndTime().getTime() / 1000.0 + (double)w.getEndTimeFrac() / 10000.0;
            this.msr.setEndTime(ed);
            this.msr.setSampleRate((double)w.getSampRate());
            this.msr.setRecordLength(w.getRecLenth());
            int nsamples = (int)Math.round((this.msr.getEndTime() - this.msr.getStartTime()) * this.msr.getSampleRate());
            this.msr.setNumSamples(nsamples);
            this.msr.setData(new int[nsamples]);
            if (this.msr.getRecordLength() == 4096) {
                this.decodeMiniSeed(w.getWaveform(), 4096, this.g_4096, this.msr);
            } else {
                this.decodeMiniSeed(w.getWaveform(), 512, this.g_512, this.msr);
            }
            return this.msr;
        }
        return null;
    }

    private void decodeMiniSeed(byte[] buf, int mseedSize, GenericMiniSeedRecord g, MiniSeedRecord msr) {
        byte[] mbuf = new byte[mseedSize];
        int[] udata = null;
        int index = 0;
        long startMs = Math.round(msr.getStartTime() * 1000.0);
        TimeStamp gts = null;
        int i = 0;
        while (i < buf.length) {
            System.arraycopy(buf, i, mbuf, 0, mseedSize);
            g.setEncodeBuffer(mbuf);
            boolean success = false;
            success = g.decompress();
            if (success) {
                udata = g.getUData();
                gts = g.getStartTime();
                long ms = gts.getTime() / 1000L * 1000L + (long)(gts.getNanos() / 1000000);
                index = (int)Math.round((double)(ms - startMs) * msr.getSampleRate() / 1000.0);
                if (index >= 0) {
                    if (index > msr.getData().length) {
                        logger.info((Object)("bad packet: " + g));
                    } else if (index + udata.length > msr.getData().length) {
                        int k = 0;
                        while (k < msr.getData().length - index) {
                            msr.getData()[index + k] = udata[k];
                            ++k;
                        }
                    } else {
                        System.arraycopy(udata, 0, msr.getData(), index, udata.length);
                    }
                }
            }
            i += mseedSize;
        }
    }

    public SeedVolumeService getSeedVolumeService() {
        return this.seedVolumeService;
    }

    public void setSeedVolumeService(SeedVolumeService seedVolumeService) {
        this.seedVolumeService = seedVolumeService;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
        if (this.startTime != null && endTime != null) {
            this.useTimeSpan = true;
            if (this.useWaveformDataStore) {
                try {
                    this.initDataStore();
                }
                catch (SQLException ex) {
                    logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    this.waveformSize = 0;
                }
            } else {
                long now_ms = System.currentTimeMillis();
                this.wfs = this.seedVolumeService.getWaveform(this.startTime, endTime);
                this.waveformSize = this.wfs.size();
                logger.info((Object)("waveform size: " + this.waveformSize));
                logger.info((Object)("waveform query time: " + (System.currentTimeMillis() - now_ms)));
                this.count = 0;
                if (this.waveformSize == 0 && this.waveformDataStore != null) {
                    try {
                        this.initDataStore();
                    }
                    catch (SQLException ex) {
                        logger.warn((Object)ex.getMessage(), (Throwable)ex);
                        this.waveformSize = 0;
                    }
                }
            }
        }
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
        if (startTime != null && this.endTime != null) {
            this.useTimeSpan = true;
            if (this.useWaveformDataStore) {
                try {
                    this.initDataStore();
                }
                catch (SQLException ex) {
                    logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    this.waveformSize = 0;
                }
            } else {
                long now_ms = System.currentTimeMillis();
                this.wfs = this.seedVolumeService.getWaveform(startTime, this.endTime);
                this.waveformSize = this.wfs.size();
                logger.info((Object)("waveform size: " + this.waveformSize));
                logger.info((Object)("waveform query time: " + (System.currentTimeMillis() - now_ms)));
                this.count = 0;
                if (this.waveformSize == 0 && this.waveformDataStore != null) {
                    try {
                        this.initDataStore();
                    }
                    catch (SQLException ex) {
                        logger.warn((Object)ex.getMessage(), (Throwable)ex);
                        this.waveformSize = 0;
                    }
                }
            }
        }
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
        this.useTimeSpan = false;
        if (this.useWaveformDataStore) {
            try {
                this.initDataStore();
            }
            catch (SQLException ex) {
                logger.warn((Object)ex.getMessage(), (Throwable)ex);
                this.waveformSize = 0;
            }
        } else {
            long now_ms = System.currentTimeMillis();
            this.wfs = this.seedVolumeService.getWaveform(eventId);
            this.waveformSize = this.wfs.size();
            logger.info((Object)("waveform size: " + this.waveformSize));
            logger.info((Object)("waveform query time: " + (System.currentTimeMillis() - now_ms)));
            this.count = 0;
            if (this.waveformSize == 0 && this.waveformDataStore != null) {
                try {
                    this.initDataStore();
                }
                catch (SQLException ex) {
                    logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    this.waveformSize = 0;
                }
            }
        }
    }

    public DataSource getWaveformDataStore() {
        return this.waveformDataStore;
    }

    public void setWaveformDataStore(DataSource waveformDataStore) {
        this.waveformDataStore = waveformDataStore;
    }

    public void setChannelFilter(String networkRegex, String stationRegex, String locIdRegex, String chanRegex) {
        this.networkRegex = networkRegex;
        this.stationRegex = stationRegex;
        this.locIdRegex = locIdRegex;
        this.chanRegex = chanRegex;
    }

    public void setPreFetchSize(int preFetchSize) {
        this.preFetchSize = preFetchSize;
    }

    public void setSeedCache(SeedCache seedCache) {
        this.seedCache = seedCache;
    }

    public void setArchiveWaveServerPlugin(ArchiveWaveServerPlugin archiveWaveServerPlugin) {
        this.archiveWaveServerPlugin = archiveWaveServerPlugin;
    }

    public ChannelWaveform getNextChannelWaveform() {
        if (this.useTimeSpan && this.archiveWaveServerPlugin != null) {
            return this.archiveWaveServerPlugin.getNextChannelWaveform();
        }
        if (this.useWaveformDataStore) {
            ChannelWaveform cwf = null;
            try {
                cwf = this.getChannelWaveformFromDataStore();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return cwf;
        }
        if (this.waveformSize == 0 && this.waveformDataStore != null) {
            ChannelWaveform cwf = null;
            try {
                cwf = this.getChannelWaveformFromDataStore();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return cwf;
        }
        if (this.count == this.wfs.size()) {
            return null;
        }
        ChannelWaveform s = new ChannelWaveform();
        Waveform w = this.wfs.get(this.count++);
        String netCode0 = w.getChannelLocator().getNetCode();
        String staCode0 = w.getChannelLocator().getStationCode();
        String locId0 = w.getChannelLocator().getLocId();
        String channel0 = w.getChannelLocator().getChanCode();
        String netCode = null;
        String staCode = null;
        String locId = null;
        String channel = null;
        ArrayList wfsList = new ArrayList();
        s.setWfsList(wfsList);
        s.getWfsList().add(w);
        s.setNetworkCode(netCode0);
        s.setStation(staCode0);
        s.setLocId(locId0);
        s.setChannel(channel0);
        int i = this.count;
        while (i < this.waveformSize) {
            w = this.wfs.get(i);
            netCode = w.getChannelLocator().getNetCode();
            staCode = w.getChannelLocator().getStationCode();
            locId = w.getChannelLocator().getLocId();
            channel = w.getChannelLocator().getChanCode();
            if (!(netCode.equals(netCode0) && staCode.equals(staCode0) && locId.equals(locId0) && channel.equals(channel0))) {
                this.count = i;
                return s;
            }
            s.getWfsList().add(w);
            ++i;
        }
        return s;
    }

    private ChannelWaveform getChannelWaveformFromDataStore() throws SQLException {
        if (!this.rs.next()) {
            return null;
        }
        ++this.count;
        String netCode0 = this.rs.getString("Net_code");
        String staCode0 = this.rs.getString("Sta_code");
        String locId0 = this.rs.getString("Loc_id");
        String channel0 = this.rs.getString("Chn_code");
        String netCode = null;
        String staCode = null;
        String locId = null;
        String channel = null;
        ArrayList wfsList = new ArrayList();
        ChannelWaveform s = new ChannelWaveform();
        s.setWfsList(wfsList);
        s.getWfsList().add(this.wrapedWaveformFromDataStore());
        s.setNetworkCode(netCode0);
        s.setStation(staCode0);
        s.setLocId(locId0);
        s.setChannel(channel0);
        while (this.rs.next()) {
            ++this.count;
            netCode = this.rs.getString("Net_code");
            staCode = this.rs.getString("Sta_code");
            locId = this.rs.getString("Loc_id");
            channel = this.rs.getString("Chn_code");
            if (netCode.equals(netCode0) && staCode.equals(staCode0) && locId.equals(locId0) && channel.equals(channel0)) {
                s.getWfsList().add(this.wrapedWaveformFromDataStore());
                continue;
            }
            --this.count;
            this.rs.absolute(this.count);
            return s;
        }
        return s;
    }

    private Waveform wrapedWaveformFromDataStore() {
        Waveform w = new Waveform();
        try {
            cn.org.gddsn.jopens.entity.ChannelLocator c = new cn.org.gddsn.jopens.entity.ChannelLocator();
            w.setChannelLocator(c);
            Blob waveform = this.rs.getBlob("waveform");
            int len = (int)waveform.length();
            byte[] buf = waveform.getBytes(1L, len);
            if (buf.length % 512 != 0) {
                logger.warn((Object)("Internal Error! buf.length =" + buf.length));
            }
            w.setWaveform(buf);
            w.getChannelLocator().setNetCode(this.rs.getString("Net_code"));
            w.getChannelLocator().setStationCode(this.rs.getString("Sta_code"));
            w.getChannelLocator().setLocId(this.rs.getString("Loc_id"));
            w.getChannelLocator().setChanCode(this.rs.getString("Chn_code"));
            w.setStartTime((Date)this.rs.getTimestamp("Start_time"));
            w.setStartTimeFrac(this.rs.getInt("Start_time_frac"));
            w.setEndTime((Date)this.rs.getTimestamp("End_time"));
            w.setEndTimeFrac(this.rs.getInt("End_time_frac"));
            w.setSampRate((float)this.rs.getDouble("Samp_rate"));
            w.setRecLenth(this.rs.getInt("Rec_lenth"));
            w.setEncodeFormat(this.rs.getInt("Encode_format"));
            double st = (double)this.rs.getTimestamp("Start_time").getTime() / 1000.0 + (double)this.rs.getInt("Start_time_frac") / 10000.0;
            double ed = (double)this.rs.getTimestamp("End_time").getTime() / 1000.0 + (double)this.rs.getInt("End_time_frac") / 10000.0;
            int nsamples = (int)Math.round((ed - st) * (double)w.getSampRate());
            w.setNsamples(nsamples);
        }
        catch (SQLException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return w;
    }
}

