/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.seed;

import cn.org.gddsn.jopens.entity.EventInfo;
import cn.org.gddsn.jopens.entity.SeedConfig;
import cn.org.gddsn.jopens.entity.Waveform;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.service.ChannelWaveform;
import cn.org.gddsn.jopens.service.SeedCache;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import cn.org.gddsn.jopens.wfpool.ArchiveWaveClient;
import cn.org.gddsn.jopens.wfpool.AwcCallBack;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.evtformat.seed.SeedVolumePlugin;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import edu.iris.miniseedutils.steim.MiniSeedHeader;
import edu.iris.miniseedutils.steim.MiniSeedRecord;
import edu.iris.timeutils.TimeStamp;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class SeedVolumeArchiveWaveServerPluginMultiCmd
implements SeedVolumePlugin,
AwcCallBack {
    static Logger logger = Logger.getLogger(SeedVolumeArchiveWaveServerPluginMultiCmd.class);
    private SeedVolumeService seedVolumeService;
    private String eventId = null;
    private Date startTime;
    private Date endTime;
    private List<byte[]> wfs;
    private Iterator<ChannelLocator> clIterator = null;
    private Dataless dl = null;
    private GenericMiniSeedRecord g_512 = new GenericMiniSeedRecord(64, 512);
    private GenericMiniSeedRecord g_4096 = new GenericMiniSeedRecord(64, 4096);
    private SeedCache seedCache = null;
    private ArchiveWaveClient awc = null;
    private String awcHost;
    private int awcPort;

    public void handle(ByteBuffer bb) {
        bb.flip();
        byte[] buf = new byte[bb.limit() / 512 * 512];
        bb.get(buf);
        this.wfs.add(buf);
        bb.compact();
    }

    public void cleanup() {
    }

    public void setSource(Object source, Object extr) {
        if (source instanceof Date && extr instanceof Date) {
            this.getDataless();
            this.startTime = (Date)source;
            this.endTime = (Date)extr;
            this.eventId = null;
            try {
                this.awc = new ArchiveWaveClient(this.awcHost, this.awcPort);
            }
            catch (IOException ioEx) {
                logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            }
            this.awc.setAwcCallBack((AwcCallBack)this);
            LinkedList<ChannelLocator> clList = new LinkedList<ChannelLocator>();
            for (Station s : this.dl.getSeedConfig().getStation()) {
                String net = s.getBlockette050().getNetworkCode();
                String sta = s.getBlockette050().getStation();
                for (Channel c : s.getChannel()) {
                    clList.add(new ChannelLocator(net, sta, c.getBlockette052().getLocation(), c.getBlockette052().getChannel()));
                }
            }
            this.clIterator = clList.iterator();
            this.wfs = new LinkedList<byte[]>();
        } else {
            new IllegalArgumentException("arg should be Long or Date");
        }
    }

    public void cleanUpSource() {
        if (this.wfs != null) {
            this.wfs.clear();
            this.wfs = null;
        }
        this.eventId = null;
        this.endTime = null;
        this.startTime = null;
        try {
            if (this.awc != null) {
                this.awc.quit();
            }
            this.awc = null;
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        this.dl = null;
    }

    public boolean accept(ChannelLocator cl, double sampRate) {
        return true;
    }

    public Dataless getDataless() {
        if (this.dl != null) {
            return this.dl;
        }
        long now_ms = new Date().getTime();
        long datalessId = -1L;
        datalessId = this.eventId == null ? this.seedVolumeService.findNetworkInfoSelf().getUniCode() : this.seedVolumeService.findDatalessIdByEventId(this.eventId);
        logger.info((Object)("Dataless Id: " + datalessId));
        this.dl = this.seedVolumeService.findDatalessById(datalessId, false, false);
        if (this.dl == null) {
            return null;
        }
        if (this.dl.getSaveTime() == null || this.dl.getSeedConfig().getSaveTime() == null) {
            this.dl.setSaveTime(new Timestamp(new Date().getTime()));
            this.dl.getSeedConfig().setSaveTime(new Timestamp(new Date().getTime()));
            this.seedVolumeService.writeDataless(this.dl);
        }
        Dataless cacheDl = null;
        if (this.seedCache != null && (cacheDl = this.seedCache.getDataless(datalessId)) != null && cacheDl.getId() == this.dl.getId() && cacheDl.getSaveTime().getTime() == this.dl.getSaveTime().getTime()) {
            this.dl = cacheDl;
            logger.info((Object)("Using client side cache Dataless: " + this.dl.getId()));
        } else {
            this.dl = this.seedVolumeService.findDatalessById(datalessId, true, false);
            if (this.seedCache != null) {
                this.seedCache.updateDataless(this.dl);
            }
        }
        long scId = this.dl.getSeedConfig().getId();
        SeedConfig cacheSC = null;
        if (this.seedCache != null && (cacheSC = this.seedCache.getSeedConfig(scId)) != null && cacheSC.getId() == this.dl.getSeedConfig().getId() && cacheSC.getSaveTime().getTime() == this.dl.getSeedConfig().getSaveTime().getTime()) {
            this.dl.setSeedConfig(cacheSC);
            logger.info((Object)("Using client side cache SeedConfig: " + cacheSC.getId()));
        } else {
            cacheSC = this.seedVolumeService.findSeedConfig(scId);
            this.dl.setSeedConfig(cacheSC);
            if (this.seedCache != null) {
                this.seedCache.updateSeedConfig(cacheSC);
            }
        }
        if (this.eventId != null) {
            EventInfo ei = this.seedVolumeService.getTimeInfo(this.eventId);
            this.dl.getVolumeIndex().getBlockette010().setStartTime(new Timestamp(ei.getStartTime().getTime()));
            this.dl.getVolumeIndex().getBlockette010().setEndTime(new Timestamp(ei.getEndTime().getTime()));
        }
        long n_now_ms = new Date().getTime();
        logger.info((Object)("Station Query Time :" + (n_now_ms - now_ms)));
        return this.dl;
    }

    public MiniSeedRecord getNextMiniSeedData() {
        while (this.clIterator.hasNext()) {
            ChannelLocator cl = this.clIterator.next();
            try {
                this.awc.sendCommand(cl, this.startTime, this.endTime);
                this.wfs.clear();
                if (this.awc.receive() == -1) {
                    logger.warn((Object)"Unexpected close Archive Wave Server connection");
                    return null;
                }
            }
            catch (IOException ioEx) {
                logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            }
            int len = 0;
            for (byte[] bb : this.wfs) {
                len += bb.length;
            }
            if (len == 0) continue;
            byte[] buf = new byte[len];
            len = 0;
            for (byte[] bb : this.wfs) {
                System.arraycopy(bb, 0, buf, len, bb.length);
                len += bb.length;
            }
            this.wfs.clear();
            MiniSeedRecord msr = new MiniSeedRecord();
            msr.setNetwork(cl.getNetCode());
            msr.setStation(cl.getStationCode());
            msr.setLocID(cl.getLocID());
            msr.setChannel(cl.getChanCode());
            MiniSeedHeader msh = new MiniSeedHeader();
            msh.setHead(buf, 0);
            double st = msh.getStartTime();
            msr.setStartTime(st);
            msr.setSampleRate(msh.getSampleRate());
            msh.setHead(buf, buf.length / 512 * 512 - 512);
            double ed = msh.getEndTime();
            msr.setEndTime(ed);
            int nsamples = (int)Math.round((msr.getEndTime() - msr.getStartTime()) * msr.getSampleRate());
            msr.setNumSamples(nsamples);
            msr.setData(new int[nsamples]);
            if (msr.getRecordLength() == 4096) {
                this.decodeMiniSeed(buf, 4096, this.g_4096, msr);
            } else {
                this.decodeMiniSeed(buf, 512, this.g_512, msr);
            }
            return msr;
        }
        return null;
    }

    private void decodeMiniSeed(byte[] buf, int mseedSize, GenericMiniSeedRecord g, MiniSeedRecord msr) {
        byte[] mbuf = new byte[mseedSize];
        int[] udata = null;
        int index = 0;
        long startMs = Math.round(msr.getStartTime() * 1000.0);
        TimeStamp gts = null;
        int i = 0;
        while (i < buf.length) {
            System.arraycopy(buf, i, mbuf, 0, mseedSize);
            g.setEncodeBuffer(mbuf);
            boolean success = false;
            success = g.decompress();
            if (success) {
                udata = g.getUData();
                gts = g.getStartTime();
                long ms = gts.getTime() / 1000L * 1000L + (long)(gts.getNanos() / 1000000);
                index = (int)((double)(ms - startMs) * msr.getSampleRate() / 1000.0);
                if (index >= 0) {
                    if (index > msr.getData().length) {
                        logger.info((Object)("bad packet: " + g));
                    } else if (index + udata.length > msr.getData().length) {
                        int k = 0;
                        while (k < msr.getData().length - index) {
                            msr.getData()[index + k] = udata[k];
                            ++k;
                        }
                    } else {
                        System.arraycopy(udata, 0, msr.getData(), index, udata.length);
                    }
                }
            }
            i += mseedSize;
        }
    }

    public SeedVolumeService getSeedVolumeService() {
        return this.seedVolumeService;
    }

    public void setSeedVolumeService(SeedVolumeService seedVolumeService) {
        this.seedVolumeService = seedVolumeService;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setChannelFilter(String networkRegex, String stationRegex, String locIdRegex, String chanRegex) {
    }

    public void setPreFetchSize(int preFetchSize) {
    }

    public void setSeedCache(SeedCache seedCache) {
        this.seedCache = seedCache;
    }

    public ChannelWaveform getNextChannelWaveform() {
        while (this.clIterator.hasNext()) {
            ChannelLocator cl = this.clIterator.next();
            try {
                this.wfs.clear();
                this.awc.sendCommand(cl, this.startTime, this.endTime);
                if (this.awc.receive() == -1) {
                    logger.warn((Object)"Unexpected close Archive Wave Server connection");
                    return null;
                }
            }
            catch (IOException ioEx) {
                logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            }
            int len = 0;
            for (byte[] bb : this.wfs) {
                len += bb.length;
            }
            if (len == 0) continue;
            byte[] buf = new byte[len];
            len = 0;
            for (byte[] bb : this.wfs) {
                System.arraycopy(bb, 0, buf, len, bb.length);
                len += bb.length;
            }
            this.wfs.clear();
            ArrayList<Waveform> wfsList = new ArrayList<Waveform>();
            Waveform w = new Waveform();
            wfsList.add(w);
            ChannelWaveform s = new ChannelWaveform();
            s.setWfsList(wfsList);
            cn.org.gddsn.jopens.entity.ChannelLocator c = new cn.org.gddsn.jopens.entity.ChannelLocator(cl.getNetCode(), cl.getStationCode(), cl.getLocID(), cl.getChanCode());
            w.setChannelLocator(c);
            w.setWaveform(buf);
            MiniSeedHeader msh = new MiniSeedHeader();
            msh.setHead(buf, 0);
            double st = msh.getStartTime();
            w.setStartTime(new Date((long)(st * 1000.0)));
            w.setSampRate((float)msh.getSampleRate());
            msh.setHead(buf, buf.length / 512 * 512 - 512);
            double ed = msh.getEndTime();
            w.setEndTime(new Date((long)(ed * 1000.0)));
            int nsamples = (int)Math.round((ed - st) * (double)w.getSampRate());
            w.setNsamples(nsamples);
            return s;
        }
        return null;
    }

    public void setAwcHost(String awcHost) {
        this.awcHost = awcHost;
    }

    public void setAwcPort(int awcPort) {
        this.awcPort = awcPort;
    }
}

