/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.seed;

import cn.org.gddsn.jopens.entity.Waveform;
import cn.org.gddsn.jopens.entity.seed.Blockette050;
import cn.org.gddsn.jopens.entity.seed.Blockette052;
import cn.org.gddsn.jopens.entity.seed.Blockette053;
import cn.org.gddsn.jopens.entity.seed.Blockette058;
import cn.org.gddsn.jopens.entity.seed.Blockette074;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.ComplexError;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.entity.seed.Response;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.entity.seed.TimeSpan;
import cn.org.gddsn.jopens.service.ChannelWaveform;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.RTOneChannelData;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import cn.org.gddsn.seis.evtformat.seed.SeedVolumeDatabasePlugin;
import cn.org.gddsn.seis.evtformat.seed.SeedVolumePlugin;
import com.nr.Complex;
import edu.iris.dmc.seedcodec.Steim2;
import edu.iris.dmc.seedcodec.SteimException;
import edu.iris.miniseedutils.steim.GenericCompressMiniSeedRecord;
import edu.iris.miniseedutils.steim.MiniSeedHeader;
import edu.iris.miniseedutils.steim.MiniSeedRecord;
import edu.iris.timeutils.TimeStamp;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.springframework.context.support.FileSystemXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeedVolume
extends EvtData {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(SeedVolume.class);
    private Dataless dataless = null;
    private boolean uniTime = false;
    private Date beg = null;
    private Date end = null;
    private boolean bUseTimeSpan = false;
    private transient SeedVolumePlugin seedVolumePlugin;
    private int threadNums = 1;

    public SeedVolume() {
        this.evtFormat = 7;
    }

    public SeedVolume(boolean uniTime) {
        this.evtFormat = 7;
        this.uniTime = uniTime;
    }

    public void initMetaData() {
        this.seedVolumePlugin.cleanUpSource();
        this.setCleanNodataChannel(false);
        this.cleanTimeSpan();
        this.getSeedVolumePlugin().setSource(new Date(), null);
        this.setUniTime(true);
        this.readEvtFile("");
    }

    public void setTimeSpan(Date beg, Date end) {
        this.beg = beg;
        this.end = end;
        this.bUseTimeSpan = true;
    }

    public void setUniTime(boolean uniTime) {
        this.uniTime = uniTime;
    }

    public void cleanTimeSpan() {
        this.bUseTimeSpan = false;
        this.beg = null;
        this.end = null;
    }

    @Override
    public boolean readEvtFile(String fileName) {
        long uniSTms;
        long now_ms = new Date().getTime();
        this.list.clear();
        Iterator itr = null;
        RTOneChannelData ocd2 = null;
        this.dataless = this.seedVolumePlugin.getDataless();
        if (this.dataless == null) {
            return false;
        }
        for (Station stn : this.dataless.getSeedConfig().getStation()) {
            Blockette050 b050 = stn.getBlockette050();
            for (Channel chn : stn.getChannel()) {
                RTOneChannelData oneChannel = new RTOneChannelData();
                oneChannel.setStationSeqNumber(stn.getSeqNumber());
                oneChannel.setNetworkCode(b050.getNetworkCode());
                oneChannel.setStationCode(b050.getStation());
                oneChannel.setAuxId(chn.getBlockette052().getLocation());
                oneChannel.setChannelCode(chn.getBlockette052().getChannel());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("PreProcess: " + oneChannel.getNetworkCode() + "/" + oneChannel.getStationCode() + "/" + oneChannel.getAuxId() + "/" + oneChannel.getChannelCode()));
                }
                this.list.add(oneChannel);
            }
        }
        this.setTimeSeries();
        long uniEDms = -1L;
        if (this.bUseTimeSpan) {
            uniSTms = this.beg.getTime();
            uniEDms = this.end.getTime();
        } else {
            uniSTms = this.dataless.getVolumeIndex().getBlockette010().getStartTime().getTime();
            uniEDms = this.dataless.getVolumeIndex().getBlockette010().getEndTime().getTime();
        }
        for (RTOneChannelData ocd2 : this.list) {
            if (this.uniTime) {
                ocd2.setArrivalTime(new Date(uniSTms));
                continue;
            }
            TimeSpan ts = (TimeSpan)this.dataless.getTimeSpan().get(0);
            Blockette074 b074 = ts.findBlockette074(ocd2.getNetworkCode(), ocd2.getStationCode(), ocd2.getAuxId(), ocd2.getChannelCode());
            ocd2.setArrivalTime(b074.getStartTime());
        }
        itr = this.list.iterator();
        while (itr.hasNext()) {
            String instrument;
            Station stn;
            ocd2 = (RTOneChannelData)itr.next();
            String chanId = String.valueOf(ocd2.getNetworkCode()) + "/" + ocd2.getStationCode() + "/" + ocd2.getAuxId() + "/" + ocd2.getChannelCode();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Process Station Info: " + chanId));
            }
            if ((stn = this.dataless.findStation(ocd2.getNetworkCode(), ocd2.getStationCode())) == null) {
                logger.warn((Object)("station should not be null, check database for " + chanId));
                logger.warn((Object)("remove " + chanId));
                itr.remove();
                continue;
            }
            Blockette050 b050 = stn.getBlockette050();
            ocd2.setStationLocation(new Location(b050.getLatitude(), b050.getLongitude(), b050.getElevation() / 1000.0));
            int chn_size = stn.getChannel().size();
            ocd2.setChannelComp(chn_size);
            ocd2.setStationType(chn_size + "C");
            ocd2.setCoordSys("");
            Channel chn = stn.findChannel(ocd2.getAuxId(), ocd2.getChannelCode());
            Blockette052 b052 = chn.getBlockette052();
            if (b052 == null) {
                logger.warn((Object)("Channel should not be null, check database for " + chanId));
                logger.warn((Object)("remove " + chanId));
                itr.remove();
                continue;
            }
            Response rsp = chn.findResponse(0);
            if (rsp == null) {
                logger.warn((Object)("Response stage 0 should not be null, check database for " + chanId));
                logger.warn((Object)("remove " + chanId));
                itr.remove();
                continue;
            }
            Blockette058 b058 = rsp.getBlockette058();
            if (b058 == null) {
                logger.warn((Object)("Response stage 0 Blockette058 should not be null, check database for " + chanId));
                logger.warn((Object)("remove " + chanId));
                itr.remove();
                continue;
            }
            ocd2.setCalper(b058.getFreq());
            ocd2.setCalibFactor(b058.getSensitivity() / 1000000.0);
            ocd2.setHAng(b052.getAzimuth());
            ocd2.setVAng(b052.getDip());
            String string = instrument = b052.getInstrument() == null ? "" : b052.getInstrument().getDescription();
            if (instrument != null) {
                ocd2.setInstrumentType(instrument.trim());
            } else {
                ocd2.setInstrumentType("");
            }
            ocd2.setOriginalType(1);
            ocd2.setSampleRate(b052.getSampleRate());
            rsp = chn.findResponse(1);
            if (rsp == null) {
                logger.warn((Object)("Could not find Stage 1 rsp for: " + chn.getStation().getBlockette050().getStation()));
                logger.warn((Object)("remove " + chanId));
                itr.remove();
                continue;
            }
            Blockette053 b053 = rsp.getBlockette053();
            if (b053 == null) {
                logger.warn((Object)("Response stage 1 Blockette053 should not be null, check database for " + chanId));
                logger.warn((Object)("remove " + chanId));
                itr.remove();
                continue;
            }
            double coef = 1.0;
            if (b053.getTransferFunctionType() == 'B') {
                coef = Math.PI * 2;
            }
            Complex[] zero = new Complex[b053.getZeros().size()];
            Complex[] pole = new Complex[b053.getPoles().size()];
            int i = 0;
            while (i < zero.length) {
                zero[i] = new Complex(((ComplexError)b053.getZeros().get(i)).getRealPart(), ((ComplexError)b053.getZeros().get(i)).getImPart()).mul(coef);
                ++i;
            }
            i = 0;
            while (i < pole.length) {
                pole[i] = new Complex(((ComplexError)b053.getPoles().get(i)).getRealPart(), ((ComplexError)b053.getPoles().get(i)).getImPart()).mul(coef);
                ++i;
            }
            ocd2.setZero(zero);
            ocd2.setPole(pole);
            ocd2.setScaleFactor(b053.getNormalizationFactor() * Math.pow(coef, pole.length - zero.length));
        }
        long n_now_ms = new Date().getTime();
        if (this.list.size() == 0) {
            logger.warn((Object)"no channel info found");
            return false;
        }
        logger.info((Object)("Total Channel :" + this.list.size() + ",Load station info elapse time: " + (n_now_ms - now_ms) + " ms."));
        now_ms = n_now_ms;
        double srate = 0.0;
        int nTotal = -1;
        if (this.getThreadNums() > 1) {
            OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
            int ncpu = os.getAvailableProcessors();
            if (this.getThreadNums() > ncpu) {
                logger.info((Object)("threadNums=" + this.getThreadNums() + " cpuNums=" + ncpu));
                logger.info((Object)("threadNums bigger than cpuNums is not a good idea, set threadNums=" + ncpu));
                this.setThreadNums(ncpu);
            }
            logger.info((Object)("use multi thread ... ...theadNums=" + this.getThreadNums()));
            this.loadSampData(this.getThreadNums(), uniSTms, uniEDms, fileName);
        } else {
            logger.info((Object)"use single thread ... ...");
            if (!this.useSingleThread(fileName, srate, nTotal, uniSTms, uniEDms)) {
                return false;
            }
        }
        n_now_ms = new Date().getTime();
        logger.info((Object)("DECODE MiniSeed elapse time: " + (n_now_ms - now_ms) + " ms."));
        now_ms = n_now_ms;
        ListIterator li = this.list.listIterator();
        StringBuilder sb = new StringBuilder();
        this.noDataChannel.clear();
        while (li.hasNext()) {
            TimeSeries ts = (TimeSeries)li.next();
            if (ts.getSampData() != null) continue;
            if (this.cleanNodataChannel) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Remove no data channel: " + ts.getChannelLocator()));
                }
                li.remove();
            } else {
                srate = ts.getSampleRate();
                nTotal = (int)Math.round((double)(uniEDms - uniSTms) * srate / 1000.0);
                ts.setSampData(new double[nTotal]);
            }
            this.noDataChannel.add(ts.getChannelLocator());
            sb.append(ts.getChannelLocator() + " ");
        }
        logger.warn((Object)("No data channels: " + sb.substring(0)));
        if (this.list.size() == 0) {
            logger.warn((Object)"Your open event do not have any waveform data!");
            return false;
        }
        this.setTimeSeries();
        try {
            int i = 0;
            while (i < this.TSN) {
                double theTRL = this.getTRL(i);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        this.seedVolumePlugin.cleanUpSource();
        return true;
    }

    public void loadSampData(int numThreads, long uniSTms, long uniEDms, String fileName) {
        ChanLoader cloader = new ChanLoader(uniSTms, uniEDms, fileName);
        cloader.init(numThreads);
        ChannelWaveform cwf = this.seedVolumePlugin.getNextChannelWaveform();
        if (cwf == null) {
            return;
        }
        do {
            cloader.loadSampData(cwf);
        } while ((cwf = this.seedVolumePlugin.getNextChannelWaveform()) != null);
        cloader.destroy();
    }

    public boolean useSingleThread(String fileName, double srate, int nTotal, long uniSTms, long uniEDms) {
        ChannelLocator cl;
        double[] dat = null;
        MiniSeedRecord msr = null;
        Vector<Element> bufVec = new Vector<Element>(512, 128);
        logger.info((Object)"process waveform...");
        msr = this.seedVolumePlugin.getNextMiniSeedData();
        if (msr == null) {
            logger.warn((Object)"Your open event do not have waveform data!");
            return false;
        }
        logger.info((Object)"find first station info have waveform.");
        do {
            cl = new ChannelLocator(msr.getNetwork(), msr.getStation(), msr.getLocID(), msr.getChannel());
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Process Wavform: " + msr));
        } while (this.getTimeSeries(cl) == null && (msr = this.seedVolumePlugin.getNextMiniSeedData()) != null);
        if (this.getTimeSeries(cl) == null) {
            logger.warn((Object)"All waveform could not found his Station info.");
            return false;
        }
        ChannelLocator pre_cl = cl;
        TimeSeries tSeries = this.getTimeSeries(cl);
        srate = tSeries.getSampleRate();
        if (msr.getSampleRate() != srate) {
            logger.warn((Object)(cl + ": waveform sample rate(" + msr.getSampleRate() + ") is not as same as sample rate in channel table(" + srate + ")."));
            logger.warn((Object)(cl + ": force to use sample rate in waveform(" + msr.getSampleRate() + ")."));
            tSeries.setSampleRate(msr.getSampleRate());
            srate = tSeries.getSampleRate();
        }
        long start_ms = tSeries.getArrivalTime().getTime();
        logger.info((Object)(cl + "\trate= " + srate + "/startTime=" + tSeries.getArrivalTime()));
        if (this.bUseTimeSpan) {
            nTotal = (int)Math.round((double)(uniEDms - uniSTms) * srate / 1000.0);
            if (nTotal < 0) {
                nTotal = -1;
            }
        } else {
            nTotal = -1;
        }
        if (this.uniTime && uniEDms != -1L) {
            nTotal = (int)Math.round((double)(uniEDms - uniSTms) * srate / 1000.0);
        }
        logger.info((Object)"now prepare for next channelLocator");
        do {
            cl = new ChannelLocator(msr.getNetwork(), msr.getStation(), msr.getLocID(), msr.getChannel());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Process Wavform: " + msr));
            }
            if (this.getTimeSeries(cl) == null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(msr + " could not found his Station info."));
                continue;
            }
            if (!cl.equals((Object)pre_cl)) {
                dat = this.getSamples(fileName, pre_cl, start_ms, srate, nTotal, bufVec);
                tSeries.setSampData(dat);
                bufVec.removeAllElements();
                pre_cl = cl;
                tSeries = this.getTimeSeries(cl);
                srate = tSeries.getSampleRate();
                if (msr.getSampleRate() != srate) {
                    logger.warn((Object)(cl + ": waveform sample rate(" + msr.getSampleRate() + ") is not as same as sample rate in channel table(" + srate + ")."));
                    logger.warn((Object)(cl + ": force to use sample rate in waveform(" + msr.getSampleRate() + ")."));
                    tSeries.setSampleRate(msr.getSampleRate());
                    srate = tSeries.getSampleRate();
                }
                start_ms = tSeries.getArrivalTime().getTime();
                if (this.bUseTimeSpan) {
                    nTotal = (int)Math.round((double)(uniEDms - uniSTms) * srate / 1000.0);
                    if (nTotal < 0) {
                        nTotal = -1;
                    }
                } else {
                    nTotal = -1;
                }
                if (this.uniTime && uniEDms != -1L && (nTotal = (int)Math.round((double)(uniEDms - uniSTms) * srate / 1000.0)) < 0) {
                    nTotal = -1;
                }
            }
            long ms = Math.round(msr.getStartTime() * 1000.0);
            Element e = new Element();
            e.start_ms = ms;
            e.len = msr.getNumSamples();
            e.intDat = new int[e.len];
            if (msr.getData() == null) continue;
            System.arraycopy(msr.getData(), 0, e.intDat, 0, e.len);
            e.end_ms = ms + Math.round((double)e.len * 1000.0 / msr.getSampleRate());
            bufVec.add(e);
        } while ((msr = this.seedVolumePlugin.getNextMiniSeedData()) != null);
        dat = this.getSamples(fileName, pre_cl, start_ms, srate, nTotal, bufVec);
        tSeries.setSampData(dat);
        return true;
    }

    private double[] getSamples(String event_id, ChannelLocator cl, long start_ms, double srate, int nTotal, Vector<Element> vec) {
        int cnt = 0;
        Collections.sort(vec);
        if (nTotal == -1) {
            Element E = vec.lastElement();
            nTotal = (int)Math.round((double)(E.end_ms - start_ms) * srate / 1000.0);
        }
        double[] dat = new double[nTotal];
        long pre_end_ms = start_ms;
        Enumeration<Element> enu = vec.elements();
        while (enu.hasMoreElements()) {
            Element E = enu.nextElement();
            if (E.end_ms < pre_end_ms) continue;
            int firstIdx = 0;
            int endIdx = E.len;
            int ngaps = (int)Math.round((double)(E.start_ms - pre_end_ms) * srate / 1000.0);
            if (ngaps > 0) {
                cnt += ngaps;
                if (logger.isDebugEnabled()) {
                    logger.info((Object)("Event ID is " + event_id + ", contain gaps : " + cl + " at " + new Date(pre_end_ms) + ",length=" + (double)ngaps / srate + " seconds"));
                }
                if (cnt > dat.length) {
                    if (logger.isDebugEnabled()) {
                        logger.info((Object)("Event ID is " + event_id + ", contain big gaps ignore blocks after gaps: " + cl));
                    }
                    return dat;
                }
            } else if (ngaps < 0) {
                firstIdx = -ngaps;
                endIdx = E.len;
            }
            int j = firstIdx;
            while (j < endIdx) {
                if (cnt >= dat.length) break;
                dat[cnt++] = E.intDat[j];
                ++j;
            }
            pre_end_ms = E.end_ms;
        }
        return dat;
    }

    @Override
    public boolean writeEvtFile(String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            for (Station s : this.dataless.getSeedConfig().getStation()) {
                for (Channel c : s.getChannel()) {
                    c.getBlockette052().setDataRecordLength(4096);
                }
            }
            int seq = this.dataless.writeSeedVolumeDataless((OutputStream)fos);
            int begSec = 0;
            int cutSec = this.getMaxTRL();
            DecimalFormat fmt = new DecimalFormat("000000");
            short steimLevel = 2;
            short dframes = 63;
            GenericCompressMiniSeedRecord cmsr = new GenericCompressMiniSeedRecord(steimLevel, dframes);
            int tcn = this.getTCN();
            int chn = 0;
            while (chn < tcn) {
                TimeSeries TS = this.getTimeSeries(chn);
                cmsr.setStartTime(new TimeStamp(TS.getArrivalTime().getTime() + (long)(begSec * 1000)));
                cmsr.setSampleRate((double)((int)Math.round(TS.getSampleRate())));
                cmsr.setStationInfo(TS.getNetworkCode(), TS.getStationCode(), TS.getAuxId(), TS.getChannelCode());
                cmsr.setActivityFlag(0);
                double[] sdata = TS.getSampData();
                int[] buf = new int[cutSec * (int)Math.round(TS.getSampleRate())];
                int begPnt = begSec * (int)Math.round(TS.getSampleRate());
                int j = 0;
                while (j < buf.length) {
                    buf[j] = (int)sdata[begPnt + j];
                    ++j;
                }
                int nSamps = cmsr.encodeMiniSeedRecord(buf, buf.length);
                if (nSamps != buf.length) {
                    logger.warn((Object)"Error in handle gaps data in addWaveForm()");
                }
                Vector vec = cmsr.getComressFrame();
                Enumeration Enum2 = vec.elements();
                while (Enum2.hasMoreElements()) {
                    byte[] msBytes = (byte[])Enum2.nextElement();
                    System.arraycopy(fmt.format(seq++).getBytes(), 0, msBytes, 0, 6);
                    fos.write(msBytes);
                }
                ++chn;
            }
            fos.close();
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            return false;
        }
        return true;
    }

    public boolean readEvtFile(URL urlFile) {
        throw new UnsupportedOperationException("Method readEvtFile() not yet implemented.");
    }

    public boolean writeEvtFile(URL urlFile) {
        throw new UnsupportedOperationException("Method writeEvtFile() not yet implemented.");
    }

    public SeedVolumePlugin getSeedVolumePlugin() {
        return this.seedVolumePlugin;
    }

    public void setSeedVolumePlugin(SeedVolumePlugin seedVolumePlugin) {
        this.seedVolumePlugin = seedVolumePlugin;
    }

    public Dataless getDataless() {
        return this.dataless;
    }

    public void setDataless(Dataless dataless) {
        this.dataless = dataless;
    }

    public void setChannelFilter(String networkRegex, String stationRegex, String locIdRegex, String chanRegex) {
        this.seedVolumePlugin.setChannelFilter(networkRegex, stationRegex, locIdRegex, chanRegex);
    }

    public int getThreadNums() {
        return this.threadNums;
    }

    public void setThreadNums(int threadNums) {
        this.threadNums = threadNums;
    }

    public static void main(String[] args) {
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext(new String[]{"JOPENS-service-test.xml"});
        SeedVolumeService service = (SeedVolumeService)ctx.getBean("seedVolumeService");
        SeedVolumeDatabasePlugin plugin = new SeedVolumeDatabasePlugin();
        plugin.setSeedVolumeService(service);
        plugin.setSource(1L, null);
        SeedVolume seedVolume = new SeedVolume();
        seedVolume.setSeedVolumePlugin(plugin);
        seedVolume.readEvtFile("");
    }

    public class ChanLoader {
        private long uniSTms;
        private long uniEDms;
        private String fileName;
        private ExecutorService pool = null;

        public ChanLoader(long uniSTms, long uniEDms, String fileName) {
            this.uniSTms = uniSTms;
            this.uniEDms = uniEDms;
            this.fileName = fileName;
        }

        public void init(int numThreads) {
            this.pool = Executors.newFixedThreadPool(numThreads);
        }

        public void destroy() {
            this.pool.shutdown();
        }

        public void loadSampData(ChannelWaveform cwf) {
            WaveDataCallable callable = new WaveDataCallable(cwf);
            Future<Integer> future = this.pool.submit(callable);
            future.isDone();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class WaveDataCallable
        implements Callable<Integer> {
            private ChannelWaveform cwf;
            private Vector<Element> bufVec = new Vector(512, 128);

            public WaveDataCallable(ChannelWaveform cwf) {
                this.cwf = cwf;
            }

            @Override
            public Integer call() {
                int flag = 0;
                MiniSeedRecord msr = null;
                ChannelLocator cl = null;
                double[] dat = null;
                try {
                    msr = new MiniSeedRecord();
                    Waveform w = (Waveform)this.cwf.getWfsList().get(0);
                    msr.setNetwork(w.getChannelLocator().getNetCode());
                    msr.setStation(w.getChannelLocator().getStationCode());
                    msr.setLocID(w.getChannelLocator().getLocId());
                    msr.setChannel(w.getChannelLocator().getChanCode());
                    msr.setSampleRate((double)w.getSampRate());
                    msr.setRecordLength(w.getRecLenth());
                    cl = new ChannelLocator(msr.getNetwork(), msr.getStation(), msr.getLocID(), msr.getChannel());
                    TimeSeries tSeries = SeedVolume.this.getTimeSeries(cl);
                    if (tSeries == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(msr + " could not found his Station info."));
                        }
                        return 0;
                    }
                    double srate = tSeries.getSampleRate();
                    long start_ms = tSeries.getArrivalTime().getTime();
                    if (msr.getSampleRate() != srate) {
                        logger.warn((Object)(cl + ": waveform sample rate(" + msr.getSampleRate() + ") is not as same as sample rate in channel table(" + srate + ")."));
                    }
                    int nTotal = -1;
                    if (SeedVolume.this.bUseTimeSpan) {
                        nTotal = (int)Math.round((double)(ChanLoader.this.uniEDms - ChanLoader.this.uniSTms) * srate / 1000.0);
                        if (nTotal < 0) {
                            nTotal = -1;
                        }
                    } else {
                        nTotal = -1;
                    }
                    if (SeedVolume.this.uniTime && ChanLoader.this.uniEDms != -1L && (nTotal = (int)Math.round((double)(ChanLoader.this.uniEDms - ChanLoader.this.uniSTms) * srate / 1000.0)) < 0) {
                        nTotal = -1;
                    }
                    this.loadMiniSeedRecordList(this.cwf);
                    dat = SeedVolume.this.getSamples(ChanLoader.this.fileName, cl, start_ms, srate, nTotal, this.bufVec);
                    tSeries.setSampData(dat);
                    this.bufVec.removeAllElements();
                    flag = 1;
                }
                catch (Exception e) {
                    logger.info((Object)("exception: " + cl));
                    e.printStackTrace();
                }
                return flag;
            }

            private void loadMiniSeedRecordList(ChannelWaveform cwf) {
                Waveform w = null;
                MiniSeedHeader msh = new MiniSeedHeader();
                int i = 0;
                while (i < cwf.getWfsList().size()) {
                    w = (Waveform)cwf.getWfsList().get(i);
                    MiniSeedRecord msr = new MiniSeedRecord();
                    msr.setNetwork(w.getChannelLocator().getNetCode());
                    msr.setStation(w.getChannelLocator().getStationCode());
                    msr.setLocID(w.getChannelLocator().getLocId());
                    msr.setChannel(w.getChannelLocator().getChanCode());
                    double st = (double)w.getStartTime().getTime() / 1000.0 + (double)w.getStartTimeFrac() / 10000.0;
                    msr.setStartTime(st);
                    double ed = (double)w.getEndTime().getTime() / 1000.0 + (double)w.getEndTimeFrac() / 10000.0;
                    msr.setEndTime(ed);
                    msr.setSampleRate((double)w.getSampRate());
                    msr.setRecordLength(w.getRecLenth());
                    int nsamples = (int)Math.round((msr.getEndTime() - msr.getStartTime()) * msr.getSampleRate());
                    msr.setNumSamples(nsamples);
                    msr.setData(new int[nsamples]);
                    try {
                        if (msr.getRecordLength() == 4096) {
                            Steim2.decodeWaveData((byte[])w.getWaveform(), (int)4096, (MiniSeedHeader)msh, (MiniSeedRecord)msr);
                        } else {
                            Steim2.decodeWaveData((byte[])w.getWaveform(), (int)512, (MiniSeedHeader)msh, (MiniSeedRecord)msr);
                        }
                    }
                    catch (SteimException e1) {
                        logger.warn((Object)e1.getMessage(), (Throwable)e1);
                    }
                    long ms = Math.round(msr.getStartTime() * 1000.0);
                    Element e = new Element();
                    e.start_ms = ms;
                    e.len = msr.getNumSamples();
                    e.intDat = new int[e.len];
                    if (msr.getData() != null) {
                        System.arraycopy(msr.getData(), 0, e.intDat, 0, e.len);
                        e.end_ms = ms + Math.round((double)e.len * 1000.0 / msr.getSampleRate());
                        this.bufVec.add(e);
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Element
    implements Comparable<Element> {
        long start_ms;
        int[] intDat;
        int len;
        long end_ms;

        Element() {
        }

        @Override
        public int compareTo(Element anotherElement) {
            long diff = this.start_ms - anotherElement.start_ms;
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }
    }
}

