/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.sac;

import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.PZMgr;
import cn.org.gddsn.seis.evtformat.RTOneChannelData;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import cn.org.gddsn.seis.evtformat.TransferFun;
import cn.org.gddsn.seis.evtformat.sac.SAC;
import com.nr.Complex;
import edu.iris.miniseedutils.steim.GenericCompressMiniSeedRecord;
import edu.iris.timeutils.TimeStamp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SacEvent
extends EvtData {
    static Logger logger = Logger.getLogger(SacEvent.class);
    private static final long serialVersionUID = 1L;
    private boolean uniTime = false;

    public SacEvent() {
        this.evtFormat = 3;
    }

    public SacEvent(EvtData evt) {
        super(evt);
        this.evtFormat = 3;
    }

    public SacEvent(boolean uniTime) {
        this.evtFormat = 7;
        this.uniTime = uniTime;
    }

    public void setUniTime(boolean uniTime) {
        this.uniTime = uniTime;
    }

    public boolean readEvtFile(String fileName) {
        long now_ms = new Date().getTime();
        PZMgr pzMgr = new PZMgr();
        pzMgr.load("cfg/pz.cfg");
        this.list.clear();
        File[] sacFileList = new File(fileName).listFiles();
        RTOneChannelData ocd = null;
        long uniSTms = -1L;
        int chn = 0;
        File[] fileArray = sacFileList;
        int n = sacFileList.length;
        int n2 = 0;
        while (n2 < n) {
            block21: {
                File sacFile = fileArray[n2];
                SAC sac = new SAC();
                try {
                    logger.info((Object)("readding " + sacFile));
                    sac.readBinarySAC(sacFile);
                }
                catch (IOException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    break block21;
                }
                ocd = new RTOneChannelData();
                this.list.add(ocd);
                ocd.setStationSeqNumber(chn++);
                ocd.setNetworkCode(sac.KNETWK);
                ocd.setStationCode(sac.KSTNM);
                ocd.setAuxId("00");
                ocd.setChannelCode(sac.KCMPNM);
                if (this.uniTime) {
                    ocd.setArrivalTime(new Date(uniSTms));
                } else {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTimeZone(TimeZone.getTimeZone("UTC"));
                    cal.set(1, sac.NZYEAR);
                    cal.set(6, sac.NZJDAY);
                    cal.set(11, sac.NZHOUR);
                    cal.set(12, sac.NZMIN);
                    cal.set(13, sac.NZSEC);
                    cal.set(14, sac.NZMSEC);
                    ocd.setArrivalTime(new Date(cal.getTime().getTime() + (long)(sac.B * 1000.0f)));
                }
                ocd.setStationLocation(new Location(sac.STLA, sac.STLO, (double)sac.STEL / 1000.0));
                ocd.setCoordSys("");
                ocd.setCalper(1.0);
                ocd.setHAng(sac.CMPAZ);
                ocd.setVAng(-sac.CMPINC);
                ocd.setInstrumentType(sac.KINST);
                if (sac.IDEP == 7) {
                    ocd.setOriginalType(1);
                    ocd.setCalibFactor(sac.SCALE / 1000.0f);
                } else if (sac.IDEP == 8) {
                    ocd.setOriginalType(2);
                    ocd.setCalibFactor(sac.SCALE / 1000.0f);
                } else if (sac.IDEP == 6) {
                    ocd.setOriginalType(0);
                    ocd.setCalibFactor(sac.SCALE / 1000.0f);
                } else if (sac.IDEP == 50) {
                    ocd.setOriginalType(1);
                    ocd.setCalibFactor(1.0);
                } else {
                    ocd.setOriginalType(1);
                    ocd.setCalibFactor(sac.SCALE / 1000.0f);
                }
                ocd.setSampleRate(1.0f / sac.DELTA);
                ocd.setScaleFactor(-1.0);
                TransferFun tf = pzMgr.getTransferFun(ocd.getStationCode());
                if (tf != null) {
                    ocd.setScaleFactor(tf.a0);
                    ocd.setCalper(tf.f0);
                    ocd.setZero(tf.zeros);
                    ocd.setPole(tf.poles);
                } else {
                    ocd.setScaleFactor(1.0);
                    ocd.setCalper(1.0);
                    ocd.setZero(new Complex[0]);
                    ocd.setPole(new Complex[0]);
                }
                double[] countData = new double[sac.NPTS];
                ocd.setSampData(countData);
                int i = 0;
                while (i < sac.NPTS) {
                    countData[i] = sac.data1[i];
                    ++i;
                }
            }
            ++n2;
        }
        this.fixIt();
        long n_now_ms = new Date().getTime();
        logger.info((Object)("DECODE MiniSeed elapse time: " + (n_now_ms - now_ms) + " ms."));
        now_ms = n_now_ms;
        if (this.list.size() == 0) {
            logger.warn((Object)"no channel info found");
            return false;
        }
        this.setTimeSeries();
        try {
            int i = 0;
            while (i < this.TSN) {
                double theTRL = this.getTRL(i);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        EvtData.WaveFormSortType = 2;
        this.sort();
        return true;
    }

    private void fixIt() {
        this.TCN = this.list.size();
        Hashtable<String, LinkedList<TimeSeries>> tbl = new Hashtable<String, LinkedList<TimeSeries>>(64);
        for (TimeSeries ts : this.list) {
            String key = String.valueOf(ts.getNetworkCode()) + "_" + ts.getStationCode();
            LinkedList<TimeSeries> tsList = (LinkedList<TimeSeries>)tbl.get(key);
            if (tsList == null) {
                tsList = new LinkedList<TimeSeries>();
                tbl.put(key, tsList);
                tsList.add(ts);
                continue;
            }
            tsList.add(ts);
        }
        this.TSN = tbl.size();
        for (LinkedList tsList : tbl.values()) {
            int size = tsList.size();
            for (TimeSeries ts : tsList) {
                ts.setChannelComp(size);
                ts.setStationType(size + "C");
            }
        }
    }

    public boolean writeEvtFile(String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            int seq = -1;
            int begSec = 0;
            int cutSec = this.getMaxTRL();
            DecimalFormat fmt = new DecimalFormat("000000");
            short steimLevel = 2;
            short dframes = 63;
            GenericCompressMiniSeedRecord cmsr = new GenericCompressMiniSeedRecord(steimLevel, dframes);
            int tcn = this.getTCN();
            int chn = 0;
            while (chn < tcn) {
                TimeSeries TS = this.getTimeSeries(chn);
                cmsr.setStartTime(new TimeStamp(TS.getArrivalTime().getTime() + (long)(begSec * 1000)));
                cmsr.setSampleRate((double)((int)Math.round(TS.getSampleRate())));
                cmsr.setStationInfo(TS.getNetworkCode(), TS.getStationCode(), TS.getAuxId(), TS.getChannelCode());
                cmsr.setActivityFlag(0);
                double[] sdata = TS.getSampData();
                int[] buf = new int[cutSec * (int)Math.round(TS.getSampleRate())];
                int begPnt = begSec * (int)Math.round(TS.getSampleRate());
                int j = 0;
                while (j < buf.length) {
                    buf[j] = (int)sdata[begPnt + j];
                    ++j;
                }
                int nSamps = cmsr.encodeMiniSeedRecord(buf, buf.length);
                if (nSamps != buf.length) {
                    logger.warn((Object)"Error in handle gaps data in addWaveForm()");
                }
                Vector vec = cmsr.getComressFrame();
                Enumeration Enum2 = vec.elements();
                while (Enum2.hasMoreElements()) {
                    byte[] msBytes = (byte[])Enum2.nextElement();
                    System.arraycopy(fmt.format(seq++).getBytes(), 0, msBytes, 0, 6);
                    fos.write(msBytes);
                }
                ++chn;
            }
            fos.close();
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        SacEvent sacEvent = new SacEvent();
        sacEvent.readEvtFile("/tmp/sac/20061216.350.054011");
        System.out.println(sacEvent.TCN);
    }
}

