/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.reftek;

import edu.iris.dmc.seedcodec.Steim1;
import edu.iris.dmc.seedcodec.Steim2;
import edu.iris.dmc.seedcodec.SteimException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class RefData {
    static Logger logger = Logger.getLogger(RefData.class);
    public String packetType = null;
    public String unitID = null;
    public int expNumber = 0;
    public int byteCount = 0;
    public int packetSeq = 0;
    public String dataFormat = null;
    public String triggerType = null;
    public String TTMessage = null;
    public String timeSource = null;
    public String timeQuality = null;
    public String stationNameExt = null;
    public String stationName = null;
    public String streamName = null;
    public String triggerTime = null;
    public String firstSampleTime = null;
    public String detriggerTime = null;
    public String lastSampleTime = null;
    public int event = 0;
    public int dataStream = 0;
    public int sampleRate = 0;
    public int tyear = 0;
    public int tday = 0;
    public int thour = 0;
    public int tmin = 0;
    public int tsec = 0;
    public int tmsec = 0;
    public Float lat = Float.valueOf(0.0f);
    public Float lon = Float.valueOf(0.0f);
    public Float alt = Float.valueOf(0.0f);
    public int devent = 0;
    public int ddataStream = 0;
    public int channel = 0;
    public int nSamples = 0;
    public int tSamples = 0;
    public String dformat = null;
    public String canbw = null;
    public String lsb = null;
    public String chGain = null;
    public String chc = null;
    public String su = null;
    public String fsac = null;
    public String adRes = null;
    public double[] data0;
    public double[] data1;
    public double[] data2;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readRefTek(DataInputStream in) {
        bb = ByteBuffer.allocate(1024);
        temp = new byte[1024];
        c0 = new ArrayList<Integer>();
        c1 = new ArrayList<Integer>();
        c2 = new ArrayList<Integer>();
        try lbl-1000:
        // 3 sources

        {
            while (true) lbl-1000:
            // 6 sources

            {
                if (in.available() <= 0) break;
                in.readFully(temp);
                bb = ByteBuffer.wrap(temp);
                this.Com(bb);
                if (this.packetType.equals("ET") || this.packetType.equals("EH")) {
                    this.EH(bb);
                    continue;
                }
                if (!this.packetType.equals("DT")) continue;
                try {
                    block15: {
                        block14: {
                            temp1 = this.DT(bb);
                            this.tSamples += this.nSamples;
                            if (this.channel != 0) break block14;
                            i = 0;
                            if (true) ** GOTO lbl52
                        }
                        if (this.channel != 1) break block15;
                        i = 0;
                        if (true) ** GOTO lbl58
                    }
                    if (this.channel != 2) ** GOTO lbl-1000
                    i = 0;
                    while (true) {
                        if (i >= temp1.length) ** GOTO lbl-1000
                        c2.add(temp1[i]);
                        ++i;
                    }
                }
                catch (SteimException e) {
                    RefData.logger.warn((Object)e.getMessage(), (Throwable)e);
                }
                break;
            }
        }
        catch (IOException e) {
            RefData.logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        ts = this.tSamples / 3;
        this.data0 = new double[ts];
        this.data1 = new double[ts];
        this.data2 = new double[ts];
        temp0 = c0.toArray();
        i = 0;
        ** GOTO lbl63
        do {
            c0.add(temp1[i]);
            ++i;
lbl52:
            // 2 sources

        } while (i < temp1.length);
        ** GOTO lbl-1000
        do {
            c1.add(temp1[i]);
            ++i;
lbl58:
            // 2 sources

        } while (i < temp1.length);
        ** while (true)
        while (i <= ts - 1) {
            this.data0[i] = ((Integer)temp0[i]).intValue();
            ++i;
lbl63:
            // 2 sources

            if (i < temp0.length) continue;
        }
        temp1 = c1.toArray();
        i = 0;
        while (i < temp1.length) {
            if (i > ts - 1) break;
            this.data1[i] = ((Integer)temp1[i]).intValue();
            ++i;
        }
        temp2 = c2.toArray();
        i = 0;
        while (i < temp2.length) {
            if (i > ts - 1) {
                return;
            }
            this.data2[i] = ((Integer)temp2[i]).intValue();
            ++i;
        }
    }

    public void Com(ByteBuffer bb) {
        byte[] tmp = new byte[2];
        bb.get(tmp);
        this.packetType = new String(tmp);
        byte tmp1 = bb.get();
        this.expNumber = this.getExpn(tmp1);
        bb.get();
        bb.get(tmp);
        this.unitID = Integer.toHexString(RefData.bcd2int(tmp, 4, false, 0, 16));
        bb.get(new byte[6]);
        bb.get(tmp);
        this.byteCount = RefData.bcd2int(tmp, 4, false, 0, 10);
        bb.get(tmp);
        this.packetSeq = RefData.bcd2int(tmp, 4, false, 0, 10);
    }

    private int getExpn(byte expn) {
        byte[] ex = new byte[]{expn};
        return RefData.bcd2int(ex, 2, false, 0, 10);
    }

    public void EH(ByteBuffer bb) {
        byte[] tmp = new byte[2];
        bb.get(tmp);
        this.event = RefData.bcd2int(tmp, 4, false, 0, 10);
        this.dataStream = this.getStream(bb.get());
        bb.get(new byte[4]);
        this.dataFormat = this.getDformat(bb.get());
        byte[] tmp2 = new byte[33];
        bb.get(tmp2);
        this.TTMessage = this.getTTMessage(tmp2);
        this.timeSource = this.getTimeSource(bb.get());
        bb.get();
        this.stationNameExt = this.getStationNameExt(bb.get());
        byte[] tmp3 = new byte[4];
        bb.get(tmp3);
        this.stationName = this.getStation(tmp3);
        byte[] tmp4 = new byte[16];
        bb.get(tmp4);
        this.streamName = this.getStreamName(tmp4);
        bb.get(new byte[8]);
        bb.get(tmp3);
        this.sampleRate = this.getSrate(tmp3);
        bb.get(tmp3);
        this.triggerType = this.getTtype(tmp3);
        bb.get(tmp4);
        this.triggerTime = this.getTime(tmp4);
        bb.get(tmp4);
        this.firstSampleTime = this.getTime(tmp4);
        this.getTTime(tmp4);
        bb.get(tmp4);
        this.detriggerTime = this.getTime(tmp4);
        bb.get(tmp4);
        this.lastSampleTime = this.getTime(tmp4);
        byte[] tmp6 = new byte[128];
        bb.get(tmp6);
        this.canbw = this.getStr(tmp6);
        bb.get(tmp6);
        this.lsb = this.getStr(tmp6);
        bb.get(tmp4);
        this.chGain = this.getStr(tmp4);
        bb.get(tmp4);
        this.adRes = this.getStr(tmp4);
        bb.get(tmp4);
        this.fsac = this.getStr(tmp4);
        byte[] tmp7 = new byte[64];
        bb.get(tmp7);
        this.chc = this.getStr(tmp7);
        bb.get(new byte[112]);
        bb.get(tmp4);
        this.su = this.getStr(tmp4);
        bb.get(new byte[262]);
        byte[] tmp5 = new byte[26];
        bb.get(tmp5);
        this.getPosition(tmp5);
    }

    private String getStr(byte[] bt) {
        return new String(bt).trim();
    }

    private String getStation(byte[] sn) {
        String s = new String(sn);
        return s.trim();
    }

    private int getSrate(byte[] sr) {
        String sum = new String(sr);
        return Integer.valueOf(sum.trim());
    }

    private String getTtype(byte[] tt) {
        String s = new String(tt);
        return s.trim();
    }

    private String getTime(byte[] tgt) {
        String s = new String(tgt);
        return s.trim();
    }

    private void getTTime(byte[] tt) {
        String s = new String(tt);
        this.tyear = Integer.valueOf(s.substring(0, 4));
        this.tday = Integer.valueOf(s.substring(4, 7));
        this.thour = Integer.valueOf(s.substring(7, 9));
        this.tmin = Integer.valueOf(s.substring(9, 11));
        this.tsec = Integer.valueOf(s.substring(11, 13));
        this.tmsec = Integer.valueOf(s.substring(13, 16));
    }

    private String getTTMessage(byte[] ttm) {
        String s = new String(ttm);
        return s.trim();
    }

    private String getTimeSource(byte ts) {
        String s = Byte.toString(ts);
        if (s.trim().equals("1")) {
            return "Internal";
        }
        return "GPS";
    }

    private String getStationNameExt(byte sne) {
        String s = String.valueOf((char)sne);
        return s.trim();
    }

    private String getStreamName(byte[] sn) {
        String s = new String(sn);
        return s.trim();
    }

    private void getPosition(byte[] ps) {
        String s = new String(ps);
        if (s.trim().isEmpty()) {
            logger.warn((Object)"Station position< Lat. Lon. Alt.> not set!");
            this.lat = Float.valueOf(0.0f);
            this.lon = Float.valueOf(0.0f);
            this.alt = Float.valueOf(0.0f);
            return;
        }
        this.lat = s.substring(0, 1) == "E" ? Float.valueOf(Float.valueOf(s.substring(1, 4)).floatValue() + Float.valueOf(s.substring(4, 10)).floatValue() / 60.0f) : Float.valueOf(-(Float.valueOf(s.substring(1, 4)).floatValue() + Float.valueOf(s.substring(4, 10)).floatValue() / 60.0f));
        this.lon = s.substring(10, 11) == "N" ? Float.valueOf(Float.valueOf(s.substring(11, 14)).floatValue() + Float.valueOf(s.substring(14, 20)).floatValue() / 60.0f) : Float.valueOf(-(Float.valueOf(s.substring(11, 14)).floatValue() + Float.valueOf(s.substring(14, 20)).floatValue() / 60.0f));
        this.alt = Float.valueOf(s.substring(20));
    }

    public int[] DT(ByteBuffer bb) throws SteimException {
        int[] temp = null;
        byte[] tmp = new byte[2];
        bb.get(tmp);
        this.devent = this.getEvtid(tmp);
        this.ddataStream = this.getStream(bb.get());
        this.channel = this.getChl(bb.get());
        bb.get(tmp);
        this.nSamples = this.getNsamp(tmp);
        bb.get();
        this.dformat = this.getDformat(bb.get());
        bb.get(new byte[40]);
        byte[] tmp1 = new byte[960];
        bb.get(tmp1);
        temp = this.getData(tmp1);
        return temp;
    }

    private int getEvtid(byte[] id) {
        return RefData.bcd2int(id, 4, false, 0, 10);
    }

    private int getStream(byte b0) {
        byte[] b = new byte[]{b0};
        return RefData.bcd2int(b, 2, false, 0, 10);
    }

    private int getChl(byte b0) {
        byte[] b = new byte[]{b0};
        return RefData.bcd2int(b, 2, false, 0, 10);
    }

    private int getNsamp(byte[] ns) {
        return RefData.bcd2int(ns, 4, false, 0, 10);
    }

    private String getDformat(byte df) {
        String dtf = null;
        String c0 = "C0";
        String c1 = "C1";
        String c2 = "C2";
        int ddf = 0;
        byte[] dff = new byte[]{df};
        ddf = RefData.bcd2int(dff, 2, false, 0, 10);
        if (ddf == 120) {
            dtf = c0;
        } else if (ddf == 121) {
            dtf = c1;
        } else if (ddf == 122) {
            dtf = c2;
        }
        return dtf;
    }

    private int[] getData(byte[] dt) throws SteimException {
        if (this.dformat.equals("C2")) {
            return Steim2.decode((byte[])dt, (int)this.nSamples, (boolean)false);
        }
        if (this.dformat.equals("C1") || this.dformat.equals("C0")) {
            return Steim1.decode((byte[])dt, (int)this.nSamples, (boolean)false);
        }
        return null;
    }

    public static int bcd2int(byte[] input, int numDigits, boolean nibble, int i, int base) {
        int sum = 0;
        int digit = 0;
        while (digit < numDigits) {
            int decimal = nibble ? input[i] & 0xF : (input[i] & 0xF0) >>> 4;
            sum = sum * base + decimal;
            if (nibble) {
                ++i;
            }
            nibble = !nibble;
            ++digit;
        }
        return sum;
    }

    public static void main(String[] args) throws FileNotFoundException {
        String fid = "./TestData/reftek/024841000_0001D4C0";
        DataInputStream din = new DataInputStream(new BufferedInputStream(new FileInputStream(fid)));
        RefData rd = new RefData();
        rd.readRefTek(din);
        System.out.println(rd.stationName);
        System.out.println(Double.valueOf(rd.chGain.substring(1, 2)));
    }
}

