/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.edas;

import cn.org.gddsn.convert.CStringToJava;
import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.seis.evtformat.edas.EVT_HEAD;
import cn.org.gddsn.seis.evtformat.edas.GeoDevEvtData;
import cn.org.gddsn.seis.evtformat.edas.Response;
import cn.org.gddsn.seis.evtformat.edas.StationInfo;
import com.nr.Complex;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.GregorianCalendar;

public class GeoDevOldEvent
extends GeoDevEvtData {
    private EVT_HEAD evt_head = new EVT_HEAD();
    private Date EventDate = null;

    public GeoDevOldEvent() {
        this.evtFormat = 1;
    }

    public boolean readEvtFile(String fileName) {
        try {
            File file = new File(fileName);
            if (!file.isDirectory()) {
                FileInputStream FileIn = new FileInputStream(fileName);
                BufferedInputStream BufferedIn = new BufferedInputStream(FileIn, 4096);
                LittleEndianInputStream DatIn = new LittleEndianInputStream((InputStream)BufferedIn);
                this.getOldEvtData(DatIn);
                DatIn.close();
                BufferedIn.close();
                FileIn.close();
            }
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            return false;
        }
        this.convertToTimeSeries();
        return true;
    }

    public boolean writeEvtFile(String fileName) {
        return false;
    }

    private void getOldEvtData(LittleEndianInputStream DatIn) {
        int zeroTRL = 0;
        try {
            byte[] bTemp = new byte[80];
            DatIn.readFully(bTemp, 0, 20);
            DatIn.readFully(this.evt_head.netpar.NetName, 0, 80);
            CStringToJava.tailToZero((byte[])this.evt_head.netpar.NetName, (int)80);
            this.evt_head.netpar.stn_sum = this.TSN = DatIn.readInt();
            this.evt_head.netpar.centlat = DatIn.readFloat();
            this.evt_head.netpar.centlon = DatIn.readFloat();
            this.evt_head.netpar.centalt = DatIn.readFloat();
            this.evt_head.data_begin = DatIn.readInt();
            this.evt_head.data_start.year = DatIn.readShort();
            if (this.evt_head.data_start.year < 1900) {
                this.evt_head.data_start.year = (short)(this.evt_head.data_start.year + 1900);
            }
            this.evt_head.data_start.mon = DatIn.readShort();
            this.evt_head.data_start.day = DatIn.readShort();
            this.evt_head.data_start.hour = DatIn.readShort();
            this.evt_head.data_start.min = DatIn.readShort();
            this.evt_head.data_start.sec = DatIn.readShort();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(this.evt_head.data_start.year, this.evt_head.data_start.mon, this.evt_head.data_start.day, this.evt_head.data_start.hour, this.evt_head.data_start.min, this.evt_head.data_start.sec);
            this.EventDate = calendar.getTime();
            long ms = (long)this.evt_head.data_begin * 1000L;
            this.EventDate.setTime(ms);
            this.TRL = this.evt_head.rec_length = DatIn.readInt();
            this.SI = new StationInfo[this.TSN];
            int i = 0;
            while (i < this.TSN) {
                this.SI[i] = new StationInfo();
                this.SI[i].stn_par.no = DatIn.readInt();
                DatIn.readFully(this.SI[i].stn_par.name, 0, 20);
                CStringToJava.tailToZero((byte[])this.SI[i].stn_par.name, (int)20);
                this.SI[i].stn_par.samp = DatIn.readInt();
                this.SI[i].stn_par.comp = DatIn.readInt();
                DatIn.skipBytes(432);
                this.SI[i].stn_par.latitude = DatIn.readFloat();
                this.SI[i].stn_par.longitude = DatIn.readFloat();
                this.SI[i].stn_par.altitude = DatIn.readFloat();
                this.SI[i].stn_par.weight = DatIn.readShort();
                this.SI[i].stn_par.veloc = DatIn.readShort();
                this.SI[i].stn_par.oritype = 1;
                DatIn.skipBytes(12);
                ++i;
            }
            if (this.TRL < 10) {
                this.TRL = 600;
            }
            this.TCN = this.getCN(this.TSN);
            this.Flag = new int[this.TSN][this.TRL];
            this.WDat = new double[this.TCN][];
            i = 0;
            while (i < this.TCN) {
                double[] ArraryTemp = new double[this.SI[this.toStn((int)i)].stn_par.samp * this.TRL];
                this.WDat[i] = ArraryTemp;
                ++i;
            }
            int L = 0;
            while (L < this.TRL) {
                ++zeroTRL;
                int k = 0;
                while (k < this.TSN) {
                    this.Flag[k][L] = DatIn.readInt();
                    int j = 0;
                    while (j < this.SI[k].stn_par.comp) {
                        int i2 = 0;
                        while (i2 < this.SI[k].stn_par.samp) {
                            int dat = DatIn.readInt();
                            this.WDat[this.getCN((int)k) + j][this.SI[k].stn_par.samp * L + i2] = this.Flag[k][L] == 0 ? (double)dat : 0.0;
                            ++i2;
                        }
                        ++j;
                    }
                    ++k;
                }
                ++L;
            }
        }
        catch (EOFException eofE) {
            this.TRL = --zeroTRL;
        }
        catch (IOException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        this.aEventDate = new Date[this.TCN];
        this.aTRL = new int[this.TCN];
        int i = 0;
        while (i < this.TCN) {
            this.aTRL[i] = this.TRL;
            this.aEventDate[i] = new Date(this.EventDate.getTime());
            ++i;
        }
        Complex[] pole = new Complex[]{new Complex(-1.0, 0.5), new Complex(-1.0, -0.5)};
        Complex[] zero = new Complex[]{new Complex(0.0, 0.0), new Complex(0.0, 0.0)};
        double calibFactor = 1000.0;
        double calper = 1.0;
        double scaleFactor = 1.0;
        this.Rspns = new Response[this.TCN];
        int i3 = 0;
        while (i3 < this.TCN) {
            this.Rspns[i3] = new Response();
            this.Rspns[i3].tfGain = scaleFactor;
            this.Rspns[i3].f0 = calper;
            this.Rspns[i3].Factor = calibFactor;
            this.Rspns[i3].zero = zero;
            this.Rspns[i3].nz = zero.length;
            this.Rspns[i3].pole = pole;
            this.Rspns[i3].np = pole.length;
            ++i3;
        }
    }

    public static void main(String[] args) {
        GeoDevOldEvent geoDevOldEvent = new GeoDevOldEvent();
        geoDevOldEvent.readEvtFile("D:\\public\\EvtFormat\\9905150406.EVT");
    }
}

